// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.6;

#include "colors.inc"
#include "woods.inc" 
 
global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 1, -15.0>
  direction 1.5*z
  rotate y*20
  right     x*image_width/image_height
  look_at   <0, -1,  0.0>
}


// ----------------------------------------

plane {
  y, -1
  pigment {
    checker
    color rgb 1
    color rgb 0.7
    //color rgb 0.5
  }
  finish{
        ambient 0.0
        diffuse 1.0
        reflection 0.0

  }
}

plane {
  z, 5
  pigment {color rgb 1}
}
 
 
 
union{
        light_source {
          <0.2, -0.95, -2.5>            // light's position 
          color rgb <1, 1, 1>/3  // light's color
          spotlight
          point_at <0,0,0>        
          radius 20
          area_light x/30 y/30 3 3
          jitter
                    //fade_distance 3
          //fade_power 1
          //looks_like{sphere{<0,0,0>,0.05} pigment{color Red}}
        }

        union{
                text {
                  ttf             // font type (only TrueType format for now)
                  "times.ttf",  // Microsoft Windows-format TrueType font file name
                  "little",      // the string to create
                  0.2,              // the extrusion depth
                  0               // inter-character spacing
                  scale 0.2*(x+y+z)
                  pigment{color rgb <1,0,0>}
                  finish{ambient 0.1 specular 0.3 reflection 0.1 diffuse 0.5}
                  no_shadow  
                  //no_image
                }
                
                text {
                  ttf             // font type (only TrueType format for now)
                  "arial.ttf",  // Microsoft Windows-format TrueType font file name
                  "HUGE",      // the string to create
                  0.02,              // the extrusion depth
                  0               // inter-character spacing
                  scale 0.2*(0.65*x+y+z)
                  no_image
                }
                scale 4
                translate <-0.15,-1,0>
        }             
        rotate 30*y
        translate -4.5*x
        translate -5*z
}
           
#declare text02=texture{pigment{color White*0.05}
           finish{specular 0.6 ambient 0.1}}
           
union{
        sphere{
             <0,0,0>,0.8
             interior{ior 1.3}
             pigment{color rgbf 1}
             scale z*0.17
             no_shadow
        }
        
        torus{
             0.8
             0.05
             rotate x*90
             texture{text02}
             no_shadow
        }
        
        cylinder{
           <0,0.8,0><0,2.4,0> 0.1
           texture{text02}
           rotate z*110
           no_shadow
        }                  
        rotate x*15
        translate <-4.3,-.2,-7.9>
}

light_source
{
        <0,0,0> color Red*0.7
        translate <-4.3,-.2,-7.9>
        fade_distance 3 
        fade_power 1.3
        area_light x y 3 3 
}