  #include "colors.inc"    
  #include "textures.inc"    
  #include "transforms.inc"
  #include "screen.inc"
  #include "spotlight.inc"
  
#declare Radiosity=on;

global_settings {
/**/  photons{ 
        count 20000
        media 200
             }
  assumed_gamma 1.0
  max_trace_level 25
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 35
      nearest_count 5
      error_bound 1.8
      recursion_limit 10
      low_error_factor .5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1

      adc_bailout 10
      normal on
      media on
      //save_file "file_name"
      //load_file "file_name"
      //always_sample off
      //max_sample 1.0
    }
  #end
}
Set_Camera(<17, 40,  -120>,<5,20,0>,110)
Set_Camera_Zoom(1)

#declare sphererow =
union{
        #declare X = 0;
        #while (X < 10)
                sphere{<X,0,5>, 0.5}
                #declare X = X+1;
        #end
     };

#declare spherelevel =
union{
        #declare Z = 0;                  
        #while (Z < 3)
                object{sphererow translate <0,0,Z>}
                #declare Z = Z+1;
        #end
     };

#declare spherebox =
union{
        #declare Y = 0;
        #while (Y < 3)
                object{spherelevel translate <0,Y,0>}
                #declare Y = Y+1;
        #end
     };

#declare section = 
union{
        #declare rotangle = 0;
        #while (rotangle < 360)
                box {<-2, -0.25, -0.25> <0,  0.25,  0> rotate z*rotangle}
                #declare rotangle = rotangle+20;
        #end
     };

#declare boxsphere =
union{
        #declare rotangle = 0;
        #while (rotangle < 360)
                object{section rotate y*rotangle translate <-1,1.2,0>}
                #declare rotangle = rotangle+20;
        #end
     };


#declare sbssect =
union{
        #declare rotangle = 0;
        #while (rotangle < 360)
                object{spherebox translate <0,0,-6> rotate z*rotangle}
                #declare rotangle = rotangle+45;
        #end
     };

#declare sbs =
union{
        #declare rotangle = 0;
        #while (rotangle < 360)
                object{sbssect rotate y*rotangle}
                #declare rotangle = rotangle+30;
        #end
     };

#declare bsbrow =
union{
        #declare X = 0;
        #while (X < 20)
                object{boxsphere translate <X,0,5>}
                #declare X = X+4;
        #end
     };
#declare bsblevel =
union{
        #declare Z = 0;
        #while (Z < 20)
                object{bsbrow translate <0,0,Z>}
                #declare Z = Z+4;
        #end
     };

#declare bsb =
union{
        #declare Y = 0;
        #while (Y < 20)
                object{bsblevel translate <0,Y,0>}
                #declare Y = Y+4;
        #end
     };

//wall
difference{
        box{<-1000000,-50,-5><1000000,1000000,5> texture{DMFDarkOak scale 5}finish{ambient 0 diffuse 1}}
        union{
                box{<-40,40,-5.1><40,2,0> texture{DMFDarkOak scale 5}finish{ambient 0 diffuse 1}}
                box{<-40,40,0><40,2, 5.1>pigment {
                                                    wood
                                                    turbulence 0.04            // For best results,  keep this low!
                                                    octaves 3
                                                    scale <0.2, 0.2, 1>        // Scaled for a unit object
                                                    color_map {
                                                        [0.1 rgb <0.60, 0.60, 0.6>]
                                                        [0.9 rgb <0.15, 0.15, 0.15>]
                                                              }
                                                
                                                    scale 5
                                                        }
                   finish{ambient 0 diffuse 1}}
                box{<-40.1,40.1,0.3><40.1,1.9,-0.3> pigment{color rgb 0} finish{reflection 1 ambient 0 diffuse 1}}
/*
                */
            #declare X = 1;
            #while (X<9)
                text {
                  ttf             // font type (only TrueType format for now)
                  "crystal.ttf",  // Microsoft Windows-format TrueType font file name
                  #if (X=1)
                  "R",      // the string to create
                  #end
                  #if (X=2)
                  "e",      // the string to create
                  #end
                  #if (X=3)
                  "a",      // the string to create
                  #end
                  #if (X=4)
                  "l",      // the string to create
                  #end
                  #if (X=5)
                  "i",      // the string to create
                  #end
                  #if (X=6)
                  "t",      // the string to create
                  #end
                  #if (X=7)
                  "y",      // the string to create
                  #end
                  #if (X=8)
                  "?",      // the string to create
                  #end
                  12,              // the extrusion depth
                  0               // inter-character spacing
                pigment {
                        wood
                        turbulence 0.04            // For best results,  keep this low!
                        octaves 3
                        scale <0.2, 0.2, 1>        // Scaled for a unit object
                        color_map {
                        [0.1 rgb <0.60, 0.60, 0.6>]
                        [0.4 rgb <0.15, 0.15, 0.15>]
                        [0.6 rgb <0.4, 0.7, 0.5>]
                              }
                        
                        scale 5
                        }
                  finish{ambient 0.8}
                  scale <10,10,1>
                  #if(X=1)
                  translate<50,62,-10>
                  #end
                  #if(X=2)
                  translate<50,56,-10>
                  #end
                  #if(X=3)
                  translate<50,48,-10>
                  #end
                  #if(X=4)
                  translate<50,40,-10>
                  #end
                  #if(X=5)
                  translate<50,32,-10>
                  #end
                  #if(X=6)
                  translate<50,24,-10>
                  #end
                  #if(X=7)
                  translate<50,16,-10>
                  #end
                  #if(X=8)
                  translate<50,5,-10>
                  #end
                                }
                #declare X = X+1;
                #end
                
                text {
                  ttf
                  "crystal.ttf",
                  "Fantasy?",
                  12,
                  0
                 pigment {
                        wood
                        turbulence 0.04            // For best results,  keep this low!
                        octaves 3
                        scale <0.2, 0.2, 1>        // Scaled for a unit object
                        color_map {
                        [0.1 rgb <0.60, 0.60, 0.6>]
                        [0.9 rgb <0.15, 0.15, 0.15>]
                              }
                        
                        scale 5
                        }
                finish{ambient 0.8}
                scale <12,12,1>
                translate <-22,50,-10>
                }
              }
          }

Spotlight(<30,34,-6.15>,<45,0,-30>,-100*x,100*x,90*x)
Spotlight(<0,35,-6.15>,<45,0,0>,-100*x,100*x,90*x)
Spotlight(<-30,34,-6.15>,<45,0,30>,-100*x,100*x,90*x)

light_group{
//color side_________________________
/*  */

light_source {
  0*x
  color rgb 1
  spotlight
  translate <-20, 100, -80>
  point_at <0,0,-70>
  radius 30
  tightness 0
  falloff 30
  scale <2,1,0.5>
}
//one side of the sky (color)
difference {
plane {
  z,
  5
  pigment{color White}
}
sphere{<0,0,0>,5 hollow pigment{Apocalypse turbulence 5} scale 9999000/5}
}
//color floor
difference {
plane {
  y,
  0.5
  pigment{checker color Blue color White scale 15 }
  finish{ambient 0 diffuse 1}
  }
plane {
  -z,
  5
  pigment{color White}
} 
}            

text {
  ttf
  "crystal.ttf",
  "or both?",
  2,
  0.1*x
  scale <10,10,1>
  pigment{checker color Blue color Green}
  finish{ambient 0.0 diffuse 1}
  rotate 30*y
  translate <5,5,0>
     }

/*
*/
//color objects
        union{
                object{bsb pigment{color Coral} finish{ambient 0 diffuse 1}translate <-13,1,0>}
                object{sbs pigment{color Yellow} finish{ambient 0 diffuse 1}translate <10,10.25,-10>}
                object{boxsphere pigment{color Magenta} finish{ambient 0 diffuse 1}translate <-16,1.25,-7>}
                object{spherebox pigment{color NeonBlue} finish{ambient 0 diffuse 1}translate <-15,1,-10>}
                sphere{<-5,1,-10>, 0.5 pigment{color Red}finish{ambient 0 diffuse 1}}
                box {<-2, -0.25, -0.25> <0,  0.25,  0> pigment{color Green}finish{ambient 0 diffuse 1} translate <-7,1,-9.5>}
                translate <0,0,-50>
             }

//media objects

box{
   <-10,-10,-10><10,10,10>
   pigment { rgbt 1 } hollow
   interior
   { media
      { absorption 0.15
        density
       { bozo density_map
         { [0.0 color White]
           [0.45 rgbt <0.5,0.5,0,1>]
           [0.9 rgbt 0        ]
           [1   rgbt 0        ]
         }      
       turbulence 5
       } 
             scale 25
        }
   
     media
      { absorption 0.15
        density
       { bozo density_map
         { [0.0 rgbt <0.5,0.5,0,1>]
           [0.45 color White  ]
           [0.9 rgbt 0        ]
           [1   rgbt 0        ]
         }      
       turbulence 5
       } 
             scale 25
        }
   }
translate<35,10,-40>
 }
 global_lights on
}//end of light group_________________________

sphere{
   <-35,10,-40>,10
   pigment { rgbt 1 } hollow
   interior
   {     media
      { absorption 0.15
        density
       { bozo density_map
         { [0.0 rgb 1        ]
           [0.45 rgbt <0,0.5,0.5,1>]
           [0.9 rgbt 0        ]
           [1   rgbt 0        ]
         }      
       turbulence 5
       } 
             scale 25
        }

     media
      { absorption 0.15
        density
       { bozo density_map
         { [0.0 rgbt <0,0.5,0.5,1>]
           [0.45 rgb 1      ]
           [0.9 rgbt 0        ]
           [1   rgbt 0        ]
         }      
       turbulence 5
       } 
             scale 25
             rotate 45
        }
   }
 }


bwSpotlight(<30,34,6.15>,<-45,0,30>,100*x,-100*x,-90*x)
bwSpotlight(<0,35,6.15>,<-45,0,0>,100*x,-100*x,-90*x)
bwSpotlight(<-30,34,6.15>,<-45,0,-30>,100*x,-100*x,-90*x)
//black and white side________________
/**/

box{<-70,0,0>,<70,50,100>
   pigment { rgbt 1 } hollow
   interior
   {     media
      { scattering {1,0.001 extinction 0.01}// absorption 0.15
        samples 30,100
        }

    }
}


//other side of the sky (B&W)
sphere{<0,0,0>,5 hollow
        pigment {
                bozo
                color_map {
                [0.0 rgb <0.8, 0.8, 0.8>]
                [0.4 rgb <0.4, 0.4, 0.4>]
                [0.6 rgb <0.2, 0.2, 0.2>]
                [1.0 rgb 0.0]
                          }
                turbulence 5
                }
      scale 9999000/5
      }

//black and white floor
difference{
plane {
  y,
  0.5
  pigment{checker color Black color White scale 15}
  finish{ambient 0 diffuse 1}
      }
plane {
  z,
  0
  pigment{checker Black color White}
}
}

text {
  ttf
  "crystal.ttf",
  "or both?",
  2,
  0.1*x
  scale <10,10,1>
  pigment{checker rgb 0.3 rgb 0.5}
  finish {ambient 0 diffuse 1}
  rotate -30*y
  translate <5,5,0>
     }

//black and white objects
        union{
                object{bsb pigment{color rgb 0.2} finish{ambient 0 diffuse 1}translate <0,1,0>}//edge = 10
                object{sbs pigment{color rgb 0.1} finish{ambient 0 diffuse 1}translate <-9,10.25,-10>}//radius = 9.5
                object{boxsphere pigment{color rgb 0.2} finish{ambient 0 diffuse 1}translate <18,1.25,-7>}//radius = 2
                object{spherebox pigment{color rgb 0.10} finish{ambient 0 diffuse 1}translate <6,1,-10>}//long edge (x) = 10
                sphere{<5,1,-10>, 0.5 pigment{color rgb 0.3}finish{ambient 0 diffuse 1}}//radius 0.5
                box {<6, -0.25, -0.25> <8,  0.25,  0> pigment{color rgb 0.9} finish{ambient 0 diffuse 1}translate <1,1,-9.5>}
                translate <0,0,50>
                no_reflection
              }

//solid reflectons
sphere{<35,10.25,40>,10 pigment{rgb 0.08}finish{ambient 0 diffuse 1}}
box{<-10,-10,-10>,<10,10,10> pigment{rgb 0.08}finish{ambient 0 diffuse 1} translate <-35,10,40>}
