#include "colors.inc"           
#include "textures.inc"
#include "transforms.inc"

  #declare Chain_Gold = texture {
    pigment { BrightGold }
    finish {
      ambient 0
      diffuse 1
      reflection .35
      specular 1
      metallic
    }
  }


#declare Bulb =
union{
sphere_sweep{linear_spline
                3,
                <0, 0, 0>, 0.8
                <0,-0.5,0>,0.4
                <0,-2,0>,0.39
                pigment {color rgbt <0.9,0.8,0.9,0>}
                finish{ambient 2 diffuse 1}
            } 

cylinder{<0,-1.5,0>,<0,-2,0>, 0.41 pigment {color Gray}
        finish{ambient 0.6}}
      };
      
#declare Lightbulb =
light_source {<0,0,0>,1.5
 photons{reflection on refraction on}
 looks_like {Bulb}
};

#macro halfsphere(Location) 
difference{
        difference{
        sphere{Location,3 texture{Chain_Gold}}
        sphere{Location,2.99 texture{Chain_Gold}}
             }
        plane{y,-2 texture{Chain_Gold}}
          }
#end
          
#macro Spotlight(Location,rot1,rot2,rot3,top) 
#declare joint1 = <0,3,0>;
#declare joint2 = <0,6,0>;
#declare joint3 = <0,9,0>;
union{
        union{
                union{
                        union{
                                object{halfsphere(0)}
                                object{Lightbulb rotate z*180 translate y*0.7}
                                sphere{joint1,0.2 texture{Chain_Gold}}
                                Rotate_Around_Trans(rot1,joint1)
                             }
                        union{
                                cylinder{joint1,joint2,0.1 texture{Chain_Gold}}
                                sphere{joint2,0.2 texture{Chain_Gold}}
                             }
                                Rotate_Around_Trans(rot2,joint2)
                     }
        
                union{
                        cylinder{joint2,joint3,0.1 texture{Chain_Gold}}
                        sphere{joint3,0.2  texture{Chain_Gold}}
                     }                                  
                        Rotate_Around_Trans(rot3,joint3)
        
             }
        lathe {linear_spline 4,<0, 9>, <2, 9.5>, <2.3, 10.1>, <2.7,10.2>
        texture{Chain_Gold}
                Rotate_Around_Trans(top,joint3)
                }
translate Location
        }
#end


#macro bwhalfsphere(Location) 
difference{
        difference{
        sphere{Location,3 pigment{color Gray50}}
        sphere{Location,2.99 pigment{color Gray50}}
             }
        plane{y,-2 pigment{color Gray50}}
          }
#end
          
#macro bwSpotlight(Location,rot1,rot2,rot3,top) 
#declare joint1 = <0,3,0>;
#declare joint2 = <0,6,0>;
#declare joint3 = <0,9,0>;
union{
        union{
                union{
                        union{
                                object{bwhalfsphere(0)}
                                object{Lightbulb rotate z*180 translate y*0.7}
                                sphere{joint1,0.2 pigment{color Gray50}}
                                Rotate_Around_Trans(rot1,joint1)
                             }
                        union{
                                cylinder{joint1,joint2,0.1 pigment{color Gray50}}
                                sphere{joint2,0.2 pigment{color Gray50}}
                             }
                                Rotate_Around_Trans(rot2,joint2)
                     }
        
                union{
                        cylinder{joint2,joint3,0.1 pigment{color Gray50}}
                        sphere{joint3,0.2  pigment{color Gray50}}
                     }                                  
                        Rotate_Around_Trans(rot3,joint3)
        
             }
        lathe {linear_spline 4,<0, 9>, <2, 9.5>, <2.3, 10.1>, <2.7,10.2>
        pigment{color Gray50}
                Rotate_Around_Trans(top,joint3)
                }
translate Location
        }
#end
