#declare lump = sphere{0, .03}
#declare definition = 20;


#macro Curve(OBJECT, N, radX, TWIST, startScale, endScale)   

   #declare thetaX = 60/radX;
  
   #declare s = endScale; 
   
   #declare scaler = pow( startScale/endScale, 1/(N));
   
   #declare N      = N * definition;
   #declare thetaX = thetaX/definition;
   #declare scaler = 1 + (scaler-1)/definition;
   #declare n = 0;
   #while ( n < N )
       union{
     #declare n = n + 1;
   #end
   
   object{OBJECT}

   #declare n = 0;
   #while ( n < N )  
      object{lump scale s}  
        translate radX * y  rotate thetaX * x   translate -radX*y
        rotate TWIST*y  
      }   
      #declare s = s * scaler;
      #declare n = n + 1;
   #end               
#end


#declare Flame =     

union{
  object{ Curve(
  object{ Curve(
  object{ Curve(
  object{lump}
        , 8,  -5,   0,  17.5,    4)   }    
        , 4,   8,   0,    36,   20)   }    
        , 3,  10,   0,    60, 37.6)  
  
     rotate -90*x
  }
  
  scale <0.4,1,1>
  rotate 90* y rotate 15*z scale 0.1   
}




