#include "Flame.inc"

#ifndef (highDef)
  #declare highDef = false;
#end 

#declare P_Copper   = color rgb <0.65, 0.25, 0.05> * 1.7;

#declare F_Metal  =
finish {
    ambient 0.1
    brilliance 5
    diffuse 0.4
    metallic
    specular 0.80
    roughness 0.05
    reflection 0.1
}

#declare T_Copper = texture { pigment { P_Copper } finish { F_Metal  } }


#declare SunTex  = 
texture{T_Copper   normal{ bumps bump_size .2 scale 0.002} }
 
#declare Sun =
union{ 
  #declare N = 0;
  #while (N < 360)
    object{Flame rotate 0*y translate<0,1,0> rotate N*z}
    #if (highDef)
      #declare N = N + 20;
    #else
      #declare N = N + 60;
    #end 
  #end

//  #if (highDef)  
//    #include "SunFace_pov.inc" difference{ object{Poseray_scene_object  rotate 180*y scale 8 translate <0,-5.2,0.15> scale 4.2 scale<1,1,.5>} box{<-100,-100,0.11><100,100,100>} }
//  #end
  
  texture{SunTex}
  scale 6.5
}

