#include "colors.inc"

light_source {
    <20, 20, -6>
    color  2 * White 
}                

light_source {
    <40, 10, 70> 
    color  White*0.5
    spotlight 
    radius  5
    falloff 10
    point_at<-15,4,100>
}                

camera{
    location <0,  0, -20>
    look_at  <0,  0,   0> 
    right image_width*x
    up    image_height*y
    angle 40
  } 
  

#declare highDef = true;  

#include "Sun.inc"  object{ Sun  scale 1.7   rotate -35*y                 translate <  -13,    4, 100> no_shadow }
#include "Moon.inc" object{ Moon scale 1.7   rotate -20*x rotate -100*y   translate < 34.4,  -10, 100> no_shadow  }
#include "Cloud.inc"
#include "Stars.inc"
#include "Rainbow.inc" object{Rainbow no_shadow} 


#declare NightPigment =
pigment{
  cylindrical   
  turbulence .3
  pigment_map{
    [0 Black]
    [1 rgb<0,0,.5>]
  }
  rotate 90*x
  scale .5
  translate <-0.5,0,0>
}


#declare DayPigment =
pigment{
  cylindrical
  turbulence .3
  pigment_map{
    [0   Blue]
    [1   White]
  }
  rotate 90*x
  scale .5  
  translate <-0.65,0,0>
}


sky_sphere{
  pigment{
    gradient x
    pigment_map{
      [0   DayPigment  ]
      [0.1 DayPigment  ]
      [0.8 NightPigment]
      [1   NightPigment]
    }
      
    translate <0.5,0,0> 
    scale .7
  }  
}  

      