
// Glenn's POV-Ray Scene File - Background for "Escape Velocity"
// created 15-Dec-05
// last update 27-Dec-05
//
// Copyright 2005 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 
// You are free:
// - to copy, distribute, display, and perform the work
// - to make derivative works
// - to make commercial use of the work
// Under the following conditions:
// - Attribution. You must give the original author credit.
// - For any reuse or distribution, you must make clear to others the license terms of this work.
// - Any of these conditions can be waived if you get permission from the copyright holder.
// Your fair use and other rights are in no way affected by the above. 
//
//
// This file creates the background areas for the main scene.
//
//
// Scene uses RH coordinate system, Z = up.
// Scene origin is roughly under the main boat,
// with +X towards the right, and +Y heading away from the camera.


//===============================================
//             Scene Switches
//===============================================

// Set this to 2 for best render
#declare Radios     = 0; // 0=off, 1=quick, 2=best radiosity

// Set these to 1 for best render
#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare DoFog        = 1; // 0=no fog, 1=fog

// Leave these at 0
#declare RenderMe     = 0; // supresses self-rendering of the include files, leave at 0


#declare My_Cam = 1;
// 1=	Render_Cam
// 8=	Special_Cam

//===============================================
//             Global Settings
//===============================================

#version 3.5;
global_settings {
	adc_bailout 1/255 // default 1/255
	ambient_light <1.0,1.0,1.0> // default <1,1,1>, use 0 for radiosity
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 150
	number_of_waves 13 // for ripple texture
	noise_generator 2
}


//===============================================
//             Includes
//===============================================

#include "GIncludeRH.inc" // Glenn's standard includes
#include "Bridge.inc"
#include "Trees.inc"

//===============================================
//             Variables
//===============================================

//#declare CamPos = <-23*Feet, -100*Feet, 10*Feet>; // Camera Position
#declare CamPos = <-23*Feet, -100*Feet, 5*Feet>; // Camera Position

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
//		right     <16/9, 0.0,  0.0>  // aspect ratio 16:9=1.78 widescreen
		right     < 4/3, 0.0,  0.0>  // aspect ratio  4:3=1.33 normal
//		right     < 1.0, 0.0,  0.0>  // aspect ratio  1:1=1.00 square
//		right     < 7/8, 0.0,  0.0>  // aspect ratio  7:8=0.87 vertical format
//		right     < 4/5, 0.0,  0.0>  // aspect ratio  4:5=0.80 vertical
//		right     < 3/4, 0.0,  0.0>  // aspect ratio  3:4=0.75 vertical
	angle 38
	location CamPos
	look_at <-2*Feet,0*Feet,16*Feet> // main render
//	look_at <45*Feet,280*Feet,61*Feet> // look further right
//	look_at <-45*Feet,280*Feet,61*Feet> // look further left
//
// Focal Blur Section
	aperture 9
	blur_samples 40
	confidence 0.99
	variance 1/20000
	focal_point <0,0,0>
}
#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <4/3,     0.0,  0.0>
//	angle 45 // render view
//	location CamPos
//	look_at <45*Feet,280*Feet,61*Feet> // right of main render
//	angle 55
//	location <100*Feet,1200*Feet,200*Feet> // reverse angle
//	look_at <18*Feet,20*Feet,50*Feet>
	angle 55
//	location <0*Feet,-400*Feet,50*Feet> // backup from origin
//	look_at <1*Feet,1*Feet,4*Feet>
//	angle 55
//	location <0*Feet,-2000*Feet,500*Feet> // backup overview
//	look_at <1*Feet,1*Feet,200*Feet>
//	angle 55
//	location <0*Feet,-2500*Feet,1500*Feet> // backup overview
//	look_at <1*Feet,1*Feet,200*Feet>
	angle 25
	location <0*Feet,-5000*Feet,5000*Feet> // blimp
	look_at <1*Feet,500*Feet,500*Feet>
	}

camera {
#switch (My_Cam)
#case (1) Render_Cam
#break
#else Special_Cam
#end
}

//===============================================
//             Textures
//===============================================


//===============================================
//             Lighting
//===============================================


#declare Sun =
	light_source {
		<0,0,0>
		color rgb <0.584,0.539,0.543>*2.3 // bluish
	}

object { Sun
	translate <0,0,5*Miles> // noon at Equator: directly overhead
	rotate y*-33 // towards left
  rotate z*-40 // behind camera
}

#if ( DoFog )
/*
fog {
	fog_type 1 // constant fog
//	distance 2500*Feet // deep morning fog
//	distance 10000*Feet // deep mist, too damn muddy
	distance 25000*Feet // deep mist, distant fog
//	distance 50000*Feet // med mist, too thin
//	distance 100000*Feet // fine mist
//	distance 400000*Feet // very fine mist, almost unnoticeable
//	color rgbt<.71,.77,1,0.5> // too much sky showing
	color rgbt<.71,.77,1,0.2>
}
*/

fog {
	fog_type 2 // ground fog
//	fog_alt 12*Feet // keeps bottom 20 or 30 feet out of view
	fog_alt 150*Feet
//	fog_alt 8*Feet // test
	up <0,0,1>
//	distance 20000*Feet // super thin haze
	distance 5000*Feet // extremely thin
//	distance 1000*Feet // extremely thin
//	distance 100*Feet // very thin
//	distance 33*Feet // medium
//	distance 19*Feet // thick
//	distance 6*Feet // very thick

//	color rgb<.67,.71,.64> // pale creamy white
//	color rgbt<.41,.47,.64,.2> // bluish white
//	color rgbt<.51,.47,.39,.2> // too reddish sandy
	color rgbt<.45,.47,.50,.2> // nice blue-green haze
}

#end

//===============================================
//             Environment
//===============================================

background { color rgb <0.576,0.667,0.832>*.97 } // deep blue grey

sky_sphere {
 pigment {
 	gradient z
 		color_map {
/*
 			[ 0.00 rgb<0,0,0> ] // test
 			[ 0.95 rgb<0,0,0> ]
 			[ 0.95 rgb<1,1,1> ]
 			[ 0.99 rgb<1,1,1> ]
*/
 			[ 0.00 rgb <0.576,0.667,0.832>*.97 ]
 			[ 0.45 rgb <0.076,0.567,1.832>*.57 ]
 			[ 0.75 rgb <0.076,0.167,0.732>*.47 ]

 		}
	}
}



#declare GroundPlane =
	plane { z,-0.1 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
//object { GroundPlane }
/*
#declare FLP1 = pigment {
	bozo
	color_map {
		[ 0.0 rgb<.022,.029,.022> ]
		[ 1.0 rgb<.020,.160,.040> ]
	}
	scale 20*Feet/(620*Feet)
}

#declare FarlandTex =
	texture {
		pigment {
			gradient z
			pigment_map {
//				[ 0.10 rgb<0.447,0.636,0.351>*.3 ] // rocky
//				[ 0.24 rgb<.17,.25,.14> ] // to dirty rock
//				[ 0.32 rgb<.04,.14,.08> ] // to dark green
				[ 0.50 FLP1 ] // mottled green trees
//				[ 0.95 FLP1 ] // mottled green trees
//				[ 1.00 rgb<0.447,0.636,0.351>*.3 ] // rocky
			}
			warp {turbulence 0.4}
		}
	}
*/
#declare FarlandTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0 rgb<.100,.200,.100>*.62 ]
				[ 0.8 rgb<.070,.040,.011>*.02 ]
			}
			scale (1/620*Feet)*1.5
		}
	}

#declare FarCoastline =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "FarlandHF1.png"
		smooth
		water_level 1/255
		rotate x*90
		scale <1,-1,1>
		scale <1.1*Miles,1.1*Miles,350*Feet>
		texture { FarlandTex scale 620*Feet }//translate <0,0,-50*Feet> }
	}



#declare WaveNorm = // this is the boat chop
	normal {
			granite 0.2 scale 24*Feet
	}

#declare RippleNorm = // this is wake tracks
	normal {
			bumps 0.24 scale 5*Feet
		}

#declare AvgWaveNorm =
	normal { 
		average
		normal_map {
			[ 1.0 RippleNorm ]
			[ 1.0 WaveNorm ]
		}
	}
#declare LinearNorm =
	normal {
		gradient x
		slope_map {
			[ 0.0 <0,0> ]
			[ 0.5 <1,1> ]
			[ 1.0 <0,0> ]
		}
		rotate z*-8
		warp { turbulence 0.3 }
		scale 20

	}
#declare SeaWaterPig =
	pigment {
		bozo
		color_map {
//			[ 0.00 rgb<0.167,0.316,0.382> ]
//			[ 1.00 rgb<0.227,0.506,0.762> ]
			[ 0.00 rgb<0.467,0.316,0.382>*.1 ]
			[ 1.00 rgb<0.127,0.366,0.762> ]
		}
		scale 20
	}
#declare SeaWaterTex =
	texture {
//		pigment { color rgbt<0.227,0.416,0.451,0.64> } // too clear
//		pigment { color rgb<0.227,0.416,0.451> } // no trans, too opaque
//		pigment { color rgb<1,1,1> } // test white
//		pigment { color rgbf<0.227,0.416,0.282,0.47> } // brownish
///		pigment { color rgbf<0.167,0.316,0.382,0.07> } // much more blue and clear
//		pigment { color rgb<0.167,0.316,0.382> } // test
//		pigment { color rgb<0.167,0.316,0.382>*4 } // test 2
		pigment { SeaWaterPig } // test 3
//		pigment { color rgbt<0.167,0.316,0.382,0.93> } // test, takes forever to render
//		pigment { color rgbt<0.044,0.084,0.190,0.97> } // blue, too slatelike
//		pigment { color rgbt<.004,0.24,0.490,0.75> } // too bland
//		pigment { color rgbt<.004,0.040,0.190,0.75> } // more cobalt
//		pigment { color rgbt<.004,0.040,0.190,1.0> } // clear
//		pigment { color rgbf<1,1,1,0.97> } // test white filtered
//		pigment { color rgbt<.01,.01,.01,0.97> } // test dark grey
//		normal { bumps .25 scale <2.2*Feet,2.2*Feet,12> } // too oily and large bumps
//		normal { bumps .25 scale <0.7*Feet,0.7*Feet,3> } // ok

//		normal { 
//			average
//			normal_map {
//				[ bumps .20 ]//scale <24*Feet,24*Feet,3*Feet>
//				[ granite .30 ]//scale <24*Feet,24*Feet,3*Feet>
//			}
//			scale <24*Feet,24*Feet,3*Feet>
//		}

		normal { 
			AvgWaveNorm
			translate <120*Feet,-0*Feet,0>
		}


//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { 0.04, 0.64 } conserve_energy}
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.04,0.14,0.04>, <0.99,0.99,0.99> } conserve_energy} // mirrorlike
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.00,0.0,0.00>, <0.42,0.74,0.84> } conserve_energy} // too crystal blue/green
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.00,0.0,0.00>, <0.12,0.34,0.43> } conserve_energy} // much too blue
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.00,0.0,0.00>, <0.22,0.44,0.67> } conserve_energy}
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.00,0.0,0.00>, <0.72,0.74,0.83> } conserve_energy}
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.00,0.0,0.00>, <0.16,0.21,0.28> } conserve_energy} // low reflection test, too blue reflection
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.00,0.0,0.00>, <0.03,0.11,0.15> } conserve_energy} // low reflection test, dk blue/brown
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.08,0.08,0.10>, <0.278,0.361,0.353>*1.8 fresnel on } conserve_energy} // lower reflection test, fresnel causes mirror puddles
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { 0.61 fresnel on } conserve_energy} // lower reflection test
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 conserve_energy} // ZERO reflection test
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection {0.3} } // simple reflection test, no fresnel
//		finish { reflection {0.3 } }
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 } // ZERO reflection test
///		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.08,0.08,0.10>, <0.278,0.361,0.353> } conserve_energy} // mid reflection ok
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.08,0.08,0.30>, <0.278,0.361,0.653> } conserve_energy} // too blue reflections
		finish { ambient 0.1 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.08,0.08,0.10>, <0.278,0.361,0.353> } conserve_energy} // close, too slate blue
//		finish { ambient 0.1 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.08,0.08,0.08>, <0.278,0.278,0.278> } conserve_energy} // test, nogood
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.38,0.38,0.38>, <0.678,0.661,0.653> } conserve_energy} // test, no pillars
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.38,0.38,0.38>, <0.678,0.661,0.653> } } // test 2, no pillars
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection <0.678,0.661,0.653> } // test, no pillars
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection <0.008,0.001,0.003> } // test, no pillars
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 } // test, no pillars
//		finish { ambient 0.1 diffuse 0.02 specular 1.21 roughness .003 } // test ambient,
	}

/*
#declare SeaWaterTex2 = //DELETE
	texture {
		pigment { color rgb<0.84,0.80,0.90> } // white
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 } // ZERO reflection test
//		finish { ambient 0.1 diffuse 0.6 specular .21 roughness .003 reflection { 0.61 fresnel on } conserve_energy} // lower reflection test
		finish { reflection {0.3 } }
	}
*/

/*
#declare SeaWaterWaveTex =
	texture {
		pigment { color rgbt<.004,0.040,0.190,1.0> } // clear
		normal { 
			bozo 
			normal_map {
				[ 0.4 Wave2Norm scale 1/(60*Feet) ]
				[ 0.6 RippleNorm scale 1/(60*Feet) ]
			}
			scale 60*Feet
			translate <-400*Feet,0,0>
		}
		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.08,0.08,0.10>, <0.278,0.361,0.353> fresnel on } conserve_energy} // mid reflection test
	}
*/


#declare SeaWaterInt =
//	interior { ior 1.33 caustics 10 fade_distance  12 fade_power 1.0 fade_color <0.03,0.25,0.60> }
//	interior { ior 1.33 caustics 10 fade_distance  12 fade_power 1.0 fade_color <0.03,0.55,0.36> }
//	interior { ior 1.33 caustics 10 fade_distance  24 fade_power 1.7 fade_color <0.03,0.55,0.36> } // greenish
//	interior { ior 1.33 caustics 10 fade_distance  24 fade_power 1.7 fade_color <1,1,1> } // clear test
//	interior { ior 1.33 caustics 10 fade_distance   5 fade_power 1.7 fade_color <0.03,0.26,0.55> } // test
//	interior { ior 1.33 caustics 10 fade_distance  10 fade_power 1.7 fade_color <0.03,0.43,0.25> } // test green, too much algea
//	interior { ior 1.33 caustics 10 fade_distance  10 fade_power 2.0 fade_color <0.23,0.43,0.35> } // test blue-green
//	interior { ior 1.33 caustics 10 fade_distance  20 fade_power 2.0 fade_color <0.04,0.18,0.22> } // test depth
//	interior { ior 1.33 caustics 10 fade_distance 100 fade_power 2.0 fade_color <0.04,0.18,0.22> } // test even deeper
//	interior { ior 1.33 caustics 10 fade_distance   1 fade_power 2.0 fade_color <0.04,0.18,0.22> } // still not deep enough
//	interior { ior 1.33 caustics 10 fade_distance  .7 fade_power 2.0 fade_color <0.12,0.22,0.29> } // test (got worse, not better)
//	interior { ior 1.33 caustics 10 fade_distance .007 fade_power 2.0 fade_color <0.12,0.22,0.29> } // test (no help)
//	interior { ior 1.33 caustics 10 fade_distance 100 fade_power 2.0 fade_color <0.12,0.22,0.29> } // test (even worse)
//	interior { ior 1.33 caustics 10 fade_distance   1 fade_power 5.0 fade_color <0.12,0.22,0.29> } // test (slightly better, still sucks)
//	interior { ior 1.33 caustics 10 fade_distance   1 fade_power 5.0 fade_color <0.008,0.008,0.014> } // test (NOW WE'RE TALKING!)
//	interior { ior 1.33 caustics 10 fade_distance 6 fade_power 2.0 fade_color <0.008,0.008,0.014> } // test (too black inky)
//	interior { ior 1.33 caustics 10 fade_distance 6 fade_power 2.0 fade_color <0.002,0.038,0.070> } // test ()
	interior { ior 1.33  } // test ()

#declare SeaWaterMat = // material
	material {
		texture { SeaWaterTex }
//		texture { SeaWaterWaveTex }
		interior { SeaWaterInt }
	}

#declare CausticTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.44 rgbt <1,1,1,1> ]
				[ 0.50 rgbt <1,1,1,.8> ]
				[ 0.55rgbt <1,1,1,1> ]
			}
			scale 20
		}
		finish { ambient .1 }
	}

#declare SandyBottom =
	pigment {
		granite
		color_map {
//			[ 0.00 rgb<0.957,0.906,0.851>*.8 ] // too light and dry
			[ 0.00 rgb<0.957,0.906,0.851>*.24 ] // medium grey
//			[ 1.00 rgb<0.957,0.906,0.851>*.6 ] // too light and dry
			[ 0.50 rgb<0.457,0.906,0.451>*.10 ] // greenish
			[ 1.00 rgb<0.957,0.906,0.851>*.10 ] // medium grey
		}
		scale 400*Feet
	}
#declare RockyBottom =
	pigment {
		bozo
		color_map {
			[ 0.25 color rgb <0.345,0.392,0.333>*.1 ]
			[ 0.50 color rgb <0.184,0.292,0.114>*.250 ]
			[ 0.60 color rgb <0.086,0.282,0.302>*.250 ]
			[ 0.80 color rgb <0.086,0.282,0.302>*.03 ]
		}
		scale 2*Feet
	}
#declare RockySand =
	pigment {
		granite
		pigment_map {
//			[ 0.40 SandyBottom scale 1/(200*Feet) ]
			[ 0.20 SandyBottom scale 1/(200*Feet) ]
			[ 0.48 RockyBottom scale 1/(200*Feet) ]
		}
		turbulence 0.16
		scale 200*Feet
	}

#declare SeaFloorTex =
	texture {
		pigment {
			granite
			pigment_map {
				[ 0.50 SandyBottom scale 1/(2000*Feet) ]
				[ 0.58 RockySand scale 1/(2000*Feet) ]
			}
			translate <50,50.04,50> // this sets up a new random layout
			scale 2000*Feet
		}
		normal { bumps .5 scale 2.7*Meter }
		finish { ambient .1 diffuse .7 specular .1 roughness .15 }
	}
/*
#declare SeabedHF =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
//		png "SeabedHF.png"
//		png "SeabedHF2.png"
		png "SeabedHF3.png"
		smooth
		water_level .01
		rotate x*90 // z=up
		scale <1,-1,1> // align top left to <0,1,z>
		scale <500*Feet,1000*Feet,26*Feet>
		translate <-250*Feet,-100*Feet,-27*Feet>
	}
*/
#declare DistantSeabed =
//	difference {
		box { <-30*KM,-30*KM,-30*KM>,<30*KM,30*KM,-36*Feet> }
/*
		box { // local area
			<-250*Feet,0,-40*Feet>,<250*Feet,900*Feet,1>
		}
	} //end difference
*/
#declare SeaWater =
	union {
//		box { <-30*KM,600*Feet,-100*Feet>,<30*KM,30*KM,0*Feet> // this is the transparent surface
		box { <-30*KM,-30*KM,-100*Feet>,<30*KM,30*KM,0*Feet> // this is the transparent surface
			texture { SeaWaterTex } // test no transparency
//			texture { FarlandTex } // test no transparency
//			material { SeaWaterMat }
		}

//		object { SeabedHF }
		object { DistantSeabed 
		texture { SeaFloorTex }
/*
		photons{
			target
			reflection on
			refraction on
//			collect off
		}
*/
		}
	} // end union


//===============================================
//             Object Groups
//===============================================
/*
#declare STree = sphere {<0,0,12*Feet>,30*Feet texture { pigment {color rgb<1.2,1,.2>}}}
#declare SeeCone1 = cone {<0,0,0>,10*Feet,<0,0,140*Feet>,5 texture { pigment {color rgb<.2,.6,1.2>}}}
object { SeeCone1 translate trace(FarCoastline,<3500*Feet,1500*Feet,-4000*Feet>,<0,0,1>)
			rotate z*-50 translate <-0.6*Miles,0.4*Miles,0> } 
#declare SeeCone2 = cone {<0,0,0>,50*Feet,<0,0,200*Feet>,5 texture { pigment {color rgb<1.2,.3,.2>}}}
object { SeeCone2 translate trace(FarCoastline,<3300*Feet,2000*Feet,-4000*Feet>,<0,0,1>)
			rotate z*-50 translate <-0.6*Miles,0.4*Miles,0> } 
*/

#declare RS=seed(77843);
#declare N=0;
#while (N<840)
	#local ThisLoc=trace(FarCoastline,<3000*Feet+rand(RS)*600*Feet,1500*Feet+rand(RS)*1500*Feet,-4000*Feet>,<0,0,1>);
	#if (ThisLoc.z>1*Feet)
//		object { STree
			object { SimpleBush(RS,4)
			translate ThisLoc
			rotate z*-50 translate <-0.6*Miles,0.4*Miles,0> }
		#local N=N+1;
	#end // if
#end // while
#declare N=0;
#while (N<280)
	#local ThisLoc=trace(FarCoastline,<3000*Feet+rand(RS)*600*Feet,1500*Feet+rand(RS)*1200*Feet,-4000*Feet>,<0,0,1>);
	#if (ThisLoc.z>28*Feet)
//		object { STree
			object { SimpleTree(RS,4)
			translate ThisLoc
			rotate z*-50 translate <-0.6*Miles,0.4*Miles,0> }
		#local N=N+1;
	#end // if
#end // while


//===============================================
//             Object Placement
//===============================================

//object { GroundPlane }

object { SeaWater }
object { FarCoastline rotate z*-50 translate <-0.6*Miles,0.4*Miles,0> }
object { FarCoastline rotate z*80 translate <0.2*Miles,0.7*Miles,0> }
object { Bridge2S rotate z*15 translate <-300*Feet,900*Feet,-10*Feet> }


