
// POV-Ray Object File - Canopy
// created 4-Dec-05
// last update 26-Dec-05
// 2005 Glenn McCarter  ( glenn@mccarters.net )
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// CanopyS // fake canopy for testing
// Debris
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Canopy origin is at the front center,
// with the height of the canopy in +Z,
// and the length extending into +X
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare CanopyFrameTex =
	texture {
		pigment { color rgb<.967,.977,.996>*0.75 }
		finish { specular 0.53 roughness 0.04 diffuse 0.4 ambient 0.05 }
	}
#declare CanopyFrameTex2 = // darker
	texture {
		pigment { color rgb<.967,.977,.996>*0.25 }
		finish { specular 0.13 roughness 0.24 diffuse 0.4 ambient 0.05 }
	}
#declare CanopyFrameTex2Blur20 = // darker
	texture {
		pigment { color rgbt<.967*.25,.977*.25,.996*.25,.85> }
		finish { specular 0.13 roughness 0.24 diffuse 0.4 ambient 0.05 }
	}
#declare CanopyFrameTex3 = // lighter
	texture {
		pigment { color rgb<.947,.907,.996>*0.65 }
		finish { specular 0.33 roughness 0.05 metallic }
	}
#declare WindshieldTex =
	texture {
		pigment { color rgbf<.967,.977,.996,.854> }
		finish { specular 0.83 roughness 0.04 reflection 0.16 }
	}

//===============================================
//             Macros
//===============================================


//===============================================
//             Canopy
//===============================================

#declare CanopyOuterShapeS = // for testing
	union {
		cylinder { <0,0,0>,<5*Feet,0,0>,13 translate <0,0,10>} // 
		box { <0,-13,0>,<5*Feet,13,10> } // 
	} // end union

#declare CanopyInnerShapeS =
	union {
		cylinder { <-1,0,0>,<5*Feet+1,0,0>,13-.25 translate <0,0,10>} // 
		box { <-1,-13+.25,-8>,<5*Feet+1,13-.25,10> } // 
	} // end union
#declare CanopyShapeS =
	difference {
		object { CanopyOuterShapeS }
		object { CanopyInnerShapeS }
	} // end difference
#declare WindowCutterS =
	union {
//		cylinder { <24,-16,10+13>,<24,16,10+13>,20 }
//		cylinder { <5*Feet-24,-16,10+13>,<5*Feet-24,16,10+13>,20 }
//		box { <24,-16,3>,<5*Feet-24,16,24> }
		cylinder { <14,-16,0+13>,<14,16,0+13>,10 }
		cylinder { <5*Feet-10,-16,-4+13>,<5*Feet-10,16,-4+13>,6 }
		box { <14,-16,3>,<5*Feet-10,16,24> }
		box { <4,-16,9>,<5*Feet-4,16,24> }
	} // end union
#declare WindowShapeS =
	intersection {
		object { CanopyShapeS }
		object { WindowCutterS }
	} // end difference
#declare FrameShapeS =
	difference {
		object { CanopyShapeS }
		object { WindowCutterS }
	} // end difference
#declare BottomRailGroup =
	union {
		box {
			<0,0,0>,<5*Feet,1.6,1.6>
			translate <0,-13,0>
		}
		#local L=0;
		#while (L<5*Feet)
			box { <0,0.3,-0.3>,<0.6,2,2.5>
				translate <L,-13,0>
			}
		#local L=L+6;
		#end
		texture { CanopyFrameTex2 }
	} // end union
#declare HardwareSL =
	union {
		box { <0,-1,-5>,<12,1,2> }
		box { <2,0,-3>,<8,4,1> }
		cylinder { <0,0,0>,<18,0,0>,1 rotate y*-45 translate <0,0,-12> }
		texture { CanopyFrameTex }
	} // end union

#declare CanopyS =
	union {
		object { WindowShapeS texture { WindshieldTex } }
		object { FrameShapeS texture { CanopyFrameTex } }
		object { BottomRailGroup }
		object { BottomRailGroup scale <1,-1,1> }
		object { HardwareSL scale <.81,.81,.81> translate <0,-12,0> }
		object { HardwareSL scale <.81,-.81,.81> translate <0,12,0> }
		object { HardwareSL scale <0.4,0.4,0.4> rotate x*90 translate <5*Feet-3,-11.5,0> }
		object { HardwareSL scale <0.4,0.4,0.4> rotate x*-90 translate <5*Feet-3,11.5,0> }
	} // end union

#declare DualHardware =
	union {
		object { HardwareSL scale 0.4 }
		object { HardwareSL scale <-0.3,0.3,0.3> rotate x*90 translate <1,-2,0> }
	} // end union 
#declare DebrisPiece1 =
	union {
		cylinder { <0,0,0>,<2,0,0>,0.4 }
		cylinder { <2,0,0>,<2.8,0,0>,0.8 }
		texture { CanopyFrameTex2 }
	}
#declare DebrisField =
	union {
		#local RS = seed(10329);
		#local DFN=1;
		#while (DFN< 5)
			object { DualHardware scale 0.8+rand(RS)*0.4
			rotate <rand(RS)*180,rand(RS)*180,rand(RS)*180>
			translate <rand(RS)*180,rand(RS)*180,rand(RS)*180> }
		#local DFN=DFN+1;
		#end
		#local DFN=1;
		#while (DFN< 12)
			object { DebrisPiece1 scale 0.3+rand(RS)*0.7
			rotate <rand(RS)*180,rand(RS)*180,rand(RS)*180>
			translate <rand(RS)*180,rand(RS)*180,rand(RS)*180> }
		#local DFN=DFN+1;
		#end
	} // end union

#declare FloatingDebris =
	union {
		box { <0,0,0>,<12,40,1.5> }
		sphere { <0,0,0>,12 scale <1,1,.1> translate <12,12,0.75> }
		cylinder { <0,0,0>,<0,0,4.65>,4 translate <12,12,0> }
		cylinder { <0,0,0>,<0,0,6.5>,2.6 translate <12,12,0> }//texture { CanopyFrameTex3 } }
		cylinder { <0,0,0>,<0,0,6.65>,2.0 translate <12,12,0> }
/*
		#local N=0;
		#while (N<36)
			cylinder { <2,N,0>,<2,N,3>,0.5 }//texture { CanopyFrameTex3 }}
			#local N=N+4;
		#end
*/
		sphere_sweep {
			cubic_spline
			5,
			< 0,0,-4>,.461
			< 0,0, 0>,.461
			<-3,0, 8>,.461
			<-4,2, 9>,.461
			<-8,3, 9>,.661
			translate <4,4,-8>
		}
//		texture { CanopyFrameTex2 }
		translate <-10,-10,0>
		texture { CanopyFrameTex2Blur20 }
	} // end union



//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 34
		location  <-1*Feet, -34*Feet, 5*Feet> // overall
		look_at <0*Feet,0*Feet,6*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
		location  <3, -14*Feet, 5*Feet> // detail
		look_at <0,0,26>
//		location  <3, -24*Feet, 5*Feet> // main wing
//		look_at <0,0,14*Feet>
//		location  <23*Feet,-5*Feet, 19*Feet> // upper RW
//		look_at <21*Feet,8*Feet,14*Feet>
//		location  <23*Feet,-25*Feet, 5*Feet> // lower RW
//		look_at <21*Feet,8*Feet,7*Feet>
//		location  <20*Feet, -20*Feet, 1*Feet> // down up view
//		look_at <10*Feet,0,4*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <.8,.8,1.0>, rgb <.8,.8,1.0>*.75 } scale 10*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }
/*
object { CanopyS rotate x*-60 rotate z*0  translate <0*Feet,0*Feet,16>}
object { CanopyS rotate x*0 rotate y*-20 rotate z*120  translate <-4*Feet,0*Feet,16>}
object { CanopyS rotate x*0 rotate z*240  translate <10*Feet,0*Feet,16>}
*/
//object { DebrisField translate <0,0,4*Feet> }
object { FloatingDebris rotate x*0 rotate z*0 translate <0,0,4> }

object { FloatingDebris rotate z*-12 rotate <20,-110+25,4*0> translate <.9*Feet,-.2*Feet,22> } // motion blur
object { FloatingDebris rotate z*-12 rotate <20,-110+29,4*1> translate <.9*Feet,-.2*Feet,22> } // motion blur
object { FloatingDebris rotate z*-12 rotate <20,-110+33,4*2> translate <.9*Feet,-.2*Feet,22> } // motion blur
object { FloatingDebris rotate z*-12 rotate <20,-110+37,4*3> translate <.9*Feet,-.2*Feet,22> } // motion blur
object { FloatingDebris rotate z*-12 rotate <20,-110+41,4*4> translate <.9*Feet,-.2*Feet,22> } // motion blur

#end

