
// POV-Ray Object File - EjectionSeat
// created 5-Dec-05
// last update 31-Dec-05
// 2005 Glenn McCarter  ( glenn@mccarters.net )
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// EjectionSeat
// 
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Seat origin is at the intersection of base and back,
// with the height of the seat in +Z,
// and the pilot facing +X
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#declare RocketQual = 0;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare SeatCushionTex =
	texture {
		pigment { color rgb<.967,.877,.596>*0.15 }
		normal { bumps 0.24 scale 2.3 }
		finish { specular 0.3 roughness 0.24 }
	}
#declare SeatFrameTex =
	texture {
		pigment { color rgb<.254,.384,.999>*0.80 }
		finish { specular 0.08 roughness 0.14 }
	}
#declare SeatBeltTex =
	texture {
		pigment { color rgb<.967,.877,.596>*0.35 }
		normal { bumps 0.24 scale <3,3,.4> }
		finish { specular 0.13 roughness 0.14 }
	}
#declare ParachuteTex =
	texture {
		pigment { color rgb<.967,.877,.596>*0.18}
		normal { bumps 0.7 scale 1.43 }
		finish { specular 0.13 roughness 0.24 }
	}
#declare RocketFlameSTex =
	texture {
		pigment { color rgb<1,1,.5>*1 }
		finish { ambient 1 }
	}
#declare SteelFrameTex =
	texture {
		pigment { color rgb<.51,.81,1>*.08 }
		finish { specular 0.27 roughness .028 metallic }
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Seat
//===============================================

#declare EjectionSeatStructureS = // for testing
	union {
		difference { // frame L
			box { <-5,-0.5,-8>,<16,0.5,28> }
			box { <1,-1,8>,<18,1,30> }
			translate <0,10.5,0>
		} // end difference
		difference { // frame R
			box { <-5,-0.5,-8>,<16,0.5,28> }
			box { <1,-1,8>,<18,1,30> }
			translate <0,-10.5,0>
		} // end difference
		box { <-1,-10.5,-6>,<14,10.5,-3> } // underseat
		box { <-3,-8,0>,<-1,8,10> translate <0,0,20> } // headrest
		box { <-6,-10,0>,<-1,10,16> translate <0,0,-6> } // rear module
		box { <-8,-6,-7>,<0,6,7> translate <-1,0,16> texture { ParachuteTex }} // parachute pack
		texture { SeatFrameTex }
	} // end union

#declare SeatBottomCushion =
	union {
		box { <0,-10,-3>,<14,10,0> }
		cylinder { <0,-10,-1.5>,<0,10,-1.5>,1.5 scale <.6,1,1> translate <14,0,0> }
		texture { SeatCushionTex }
	} // end union
#declare SeatRearCushion =
	union {
		box { <-3,-8,0>,<0,8,20> }
		cylinder { <-1.5,-8,0>,<-1.5,8,0>,1.5 scale <1,1,.7> translate <0,0,20> }
		texture { SeatCushionTex }
	} // end union
#declare EjectionSeatSideHF =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "EjectionSeatSideHF1.png"
		smooth
		water_level 1/255
//		rotate x*90
//		scale <1,-1,1>
		scale <-3.0*Feet,3,3.6*Feet*600/600>
		translate <26,0,-16>
		texture { SeatFrameTex }
	}
#declare EjectionSeatSide =
	union {
		object { EjectionSeatSideHF }
		object { EjectionSeatSideHF scale <1,-.2,1> }
	} // end union
#declare EjectionSeatStructure =
	union {
		object { EjectionSeatSide translate <0,8.5,0> }
		object { EjectionSeatSide scale <1,-1,1> translate <0,-8.5,0> }
		cylinder { <0,0,-10>,<0,0,0>,1.3 translate <21,-9.5,0> texture { SteelFrameTex} }
		cylinder { <0,0,-10>,<0,0,0>,1.3 translate <21, 9.5,0> texture { SteelFrameTex} }
		cylinder { <0,0,0>,<0,0,8>,1.3 translate <1,-9.5,13> texture { SteelFrameTex} }
		cylinder { <0,0,0>,<0,0,8>,1.3 translate <1, 9.5,13> texture { SteelFrameTex} }
		box { <-1,-10.5,-6>,<14,10.5,-3> } // underseat
		box { <-3,-8,-10>,<-1,8,10> } // backstop
		box { <-6,-10,0>,<-1,10,16> translate <0,0,-6> } // rear module
		object { RoundedHalfBox2(8,6,14,1.3) translate <-4-4,-3.0,-7+18> texture { ParachuteTex } } // parachute pack
//		{ <-8,-6,-7>,<0,6,7> translate <-1,0,16> texture { ParachuteTex }} // parachute pack

		texture { SeatFrameTex }
	} // end union

#declare SeatBeltShape =
	#local SR=0.23;
	sphere_sweep {
		cubic_spline
		7
		<0,0,-4>,SR,
		<0,0,0>,SR,
		<1,0,6>,SR,
		<0,0,11>,SR,
		<-2,0,14>,SR,
		<-3,0,13>,SR
		<-3,0,11>,SR
		scale <1,6,1>
		texture { SeatBeltTex }
	}
#declare SeatBelts =
	union {
		object { SeatBeltShape rotate x*34 translate <7,2,8> }
		object { SeatBeltShape rotate x*-34 translate <7.6,-2,8> }
	} // end union

//---------------- Flame -----------------

#declare RocketFlameInt =
	interior {
		media {
//			emission rgb<0.075,0.075,0.075> // a little thin
			emission rgb<0.125,0.125,0.125> // test
//			absorption rgb<0.75,0.75,0.75>
//			scattering { 1, <.01,.01,.01> extinction 3.0 } // good density, but totally grey-black
//			scattering { 1, <.01,.01,.01> extinction 1.0 } // just a bit too full
//			scattering { 1, <.01,.01,.01> extinction 1.0 } // just a bit too full
//			scattering { 1, 0.01/(Time*5) extinction 1.0 } // just a bit too full
//			scattering { 1, <.002,.002,.002> extinction 1.0 } // too see-thru except where several overlaps occur
//			scattering { 1, <.0002,.0002,.0002> extinction 1.0 } // much too diffuse

	    density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ] // outside is transparent
//					[0.2 color rgb <0.15,0.15,0.15> ] // test
/*
					[0.14 color rgb <0,0,0> ] // this prevents it from reaching the container
					[0.42 color rgb <.4,.2,0> ] // test
					[0.78 color rgb <1,1,.3> ] // test
					[1.0 color rgb <1,.8,.7> ] // inside is opaque
*/
					[0.38 color rgb <0,0,0> ] // this prevents it from reaching the container
					[0.54 color rgb <.4,.2,0> ] // 
					[0.85 color rgb <1,1,.3> ] // 
					[1.0 color rgb <1,.8,.7> ] // inside is opaque

				}

				warp {
					turbulence .18
					octaves 6 // default 6.0, use 1-10
					lambda 1.5 // default 2.0
					omega 0.835 // default 0.5, higher = rougher
				}

    	} // end density
		} // end media
	} // end interior

#declare RocketFlameSurfTex =
	texture {
//		pigment { color rgbf<1,1,1,.1> } // test
		pigment { color rgbf<1,1,1,1> }
		finish { ambient .1 diffuse 0.7 }
	}
#declare RocketFlameMaterial =
	material {
		texture { RocketFlameSurfTex }
//		texture { RocketFlameSTex } // test
		interior { RocketFlameInt }
	}

#declare RocketFlameS =
	cone {
		<0,0,0>,5,<0,0,-40>,0
		texture { RocketFlameSTex }
	}
#declare RandomSeed = 103294;
#declare RS = seed(RandomSeed);
//#declare OverallDensity = .13;
//#declare Darkness = 0.8;	
#debug concat("RocketQual Value is:",str(RocketQual,5,2),"\n")

#macro RocketFlame(RocketQual)
	#if (RocketQual=1)
		difference {
			sphere { <0,0,0>,1
			hollow
			material { RocketFlameMaterial }
//			texture { VaporSurfTex } // test
			scale <15,15,40>
			translate <0,0,-15>
			}
			cylinder { <0,0,0>,<0,0,60>,23 texture { RocketFlameSurfTex } }
		} // end difference
	#else
		object { RocketFlameS }
	#end
#end

//---------------- Smoke -----------------

#macro RocketSmokeInt(Dens)
	interior {
		media {
//			emission rgb<0.125,0.125,0.125>
			absorption rgb<0.075,0.075,0.075>*Dens
//			scattering { 1, <.01,.01,.01> extinction 3.0 } // good density, but totally grey-black
//			scattering { 1, <.01,.01,.01> extinction 1.0 } // just a bit too full
//			scattering { 1, <.01,.01,.01> extinction 1.0 } // just a bit too full
//			scattering { 1, 0.01/(Time*5) extinction 1.0 } // just a bit too full
//			scattering { 1, <.002,.002,.002> extinction 1.0 } // too see-thru except where several overlaps occur
//			scattering { 1, <.0002,.0002,.0002> extinction 1.0 } // much too diffuse

	    density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ] // outside is transparent
//					[0.2 color rgb <0.15,0.15,0.15> ] // test
/*
					[0.14 color rgb <0,0,0> ] // this prevents it from reaching the container
					[0.42 color rgb <.4,.2,0> ] // test
					[0.78 color rgb <1,1,.3> ] // test
					[1.0 color rgb <1,.8,.7> ] // inside is opaque
*/
					[0.38 color rgb <0,0,0> ] // this prevents it from reaching the container
					[0.54 color rgb <.2,.2,.2> ] // 
					[0.85 color rgb <0.5,0.5,.5> ] // 
//					[1.0 color rgb <1,1,1> ] // inside is opaque

				}

				warp {
					turbulence .18
					octaves 6 // default 6.0, use 1-10
					lambda 1.5 // default 2.0
					omega 0.835 // default 0.5, higher = rougher
				}

    	} // end density
		} // end media
	} // end interior
#end

#declare RocketSmokeSurfTex =
	texture {
		pigment { color rgbf<1,1,1,1> }
		finish { ambient .1 diffuse 0.7 }
	}
#macro RocketSmokeMaterial(Dens)
		texture { RocketSmokeSurfTex }
		RocketSmokeInt(Dens)
#end
#declare RocketSmokeSphereS =
	sphere { <0,0,0>,1 texture { pigment{rgb<1,1,1>*.24}}}

#macro RocketSmokeSphere(RocketQual,Dens)
	#if (RocketQual=1)
			sphere { <0,0,0>,1
			hollow
			material { RocketSmokeMaterial(Dens) }
//			texture { VaporSurfTex } // test
			}
	#else
		object { RocketSmokeSphereS }
	#end
#end

//#declare RS=seed(120394);

#macro RocketSmokeGroup(RocketQual,RandomSeed,NumSpheres,Zheight)
	union {
		#local RS=seed(RandomSeed);
		#local N=0;
		#while (N<NumSpheres)
//			#local Dens=2.5-(2.5*N/NumSpheres); // smoke density for this sphere
			#local InitialDens=2.0;
			#local FinalDens = 0.0;
			#local Dens=InitialDens-(InitialDens-FinalDens)/NumSpheres*(N+1);
			object { RocketSmokeSphere(RocketQual,Dens)
				#local SphRad = (Zheight/NumSpheres)*1.8; // size of first sphere
				#local SphRadAdd = 0.8; // additional scale factor to last sphere
				scale SphRad*(1+SphRadAdd*N/NumSpheres)
				rotate rand(RS)*360
				translate <rand(RS)*SphRad/2,rand(RS)*SphRad/2,-N*(Zheight/NumSpheres)>
			}
			#local N=N+1;
		#end
		object { RocketSmokeSphere(1,1.34) rotate z*180 scale 3.1*Feet translate <0,0, -5*Feet> } // hand-placed sphere
		object { RocketSmokeSphere(1,1.04) scale 2.3*Feet translate <0,0,-10*Feet> } // hand-placed sphere
		object { RocketSmokeSphere(1,0.61) scale 3.2*Feet translate <0,0,-12*Feet> } // hand-placed sphere
	} // end union
#end

#macro MiniSmokeGroup(RocketQual,RandomSeed,NumSpheres,Zheight)
	union {
		#local RS=seed(RandomSeed);
		#local N=0;
		#while (N<NumSpheres)
//			#local Dens=2.5-(2.5*N/NumSpheres); // smoke density for this sphere
			#local InitialDens=3.0;
			#local FinalDens = 0.0;
			#local Dens=InitialDens-(InitialDens-FinalDens)/NumSpheres*(N+1);
			object { RocketSmokeSphere(RocketQual,Dens)
				#local SphRad = (Zheight/NumSpheres)*1.2; // size of first sphere
				#local SphRadAdd = 0.3; // additional scale factor to last sphere
				scale SphRad*(1+SphRadAdd*N/NumSpheres)
				rotate rand(RS)*360
				translate <rand(RS)*SphRad/2,rand(RS)*SphRad/2,-N*(Zheight/NumSpheres)>
			}
			#local N=N+1;
		#end
	} // end union
#end

//-------------- Structures -------------------

#macro RocketPack(RocketQual)
	union {
		difference {
			cone { <0,0,0>,1.5,<0,0,-4>,3 }
			cone { <0,0,0>,1.5,<0,0,-4>,3 translate <0,0,-0.6> texture {pigment{color rgb<0,0,0>}} }
		} // difference
		object { RocketFlame(RocketQual) translate <0,0,-2> }
	} // end union
#end
/*
#macro EjectionSeat(RocketQual)
	union {
		object { EjectionSeatStructureS }
		object { SeatBottomCushion }
		object { SeatRearCushion }
		object { RocketPack(RocketQual) rotate z*120 rotate <-15,0,0> translate <10,-8,-6> }
		object { RocketPack(RocketQual) rotate < 15,0,0> translate <10, 8,-6> }
		object { RocketFlame(RocketQual) rotate z*240 scale 2 rotate < 0,25,0> translate <-10, 0,0> } // back
		object { RocketSmokeGroup(RocketQual,43786,15,20*Feet) translate <-10,0,-24> }
		object { MiniSmokeGroup(RocketQual,44423,5,6*Feet) rotate <-15,0,0> translate <10,-18,-30> }
		object { MiniSmokeGroup(RocketQual,97473,5,5*Feet) rotate < 10,0,0> translate <10, 15,-28> }
	} // end union
#end
*/
#declare Pose=1;
// Pose Angles ( in order )
#declare HPan     = -12;   // head, positive = towards his left
#declare HTiltFwd = 15;   // head forward tilt
#declare HCock    = 0;    // head right/left tilt, positive = to the left
#declare TTwist   = 0;    // torso twist, positive = right hip fwd
#declare HipTude  = 0;    // hip attitude, positive = right hip up
#declare RWCock   = 0;    // wrist side-to-side (golf)
#declare RWAng    = 0;    // wrist angle
#declare RETwist  = 30;   // twists the hand, positive = palms up
#declare REAng    = 90;  // elbow
#declare RAFwd    = 3;   // total arm
#declare RARot    = 4;   // claps hands
#declare RAOut    = 2;   // opens underarm
#declare RAFwd2   = 8;    // total arm
#declare RARot2   = 30;    // claps hands
#declare RKnee    = 80;    // knee bend
#declare RLTwist  = 0;    // leg twist
#declare RLAng    = 90;    // leg angle fwd
#declare RLOut    = 5;    // spread eagle
#declare LWCock   = 20;   // wrist side-to-side (golf)
#declare LWAng    = 40;    // wrist angle
#declare LETwist  = 140;  // twists the hand, positive = palms up
#declare LEAng    = 70;   // elbow
#declare LAFwd    = 12;   // total arm
#declare LARot    = 12;   // claps hands
#declare LAOut    = 30;    // opens underarm
#declare LAFwd2   = 8;    // total arm
#declare LARot2   = -20;  // claps hands
#declare LKnee    = 80;    // knee bend
#declare LLTwist  = 0;    // leg twist
#declare LLAng    = 90;    // leg angle fwd
#declare LLOut    = 5;    // spread eagle
#include "Pilot.inc"

#macro EjectionSeatPilot(RocketQual)
	union {
//		object { EjectionSeatStructureS }
		object { EjectionSeatStructure rotate y*15 }
		object { SeatBottomCushion rotate y*15 }
		object { SeatRearCushion rotate y*15 }
		object { SeatBelts rotate y*15 }
		object { Pilot scale 0.78 rotate z*90 translate <3,0,23> rotate y*15 }
	} // end union
#end

#macro EjectionSeatSmoke(RocketQual)
	union {
		object { RocketPack(RocketQual) rotate z*120 rotate <-15,0,0> translate <10,-8,-6> }
		object { RocketPack(RocketQual) rotate < 15,0,0> translate <10, 8,-6> }
		object { RocketFlame(RocketQual) rotate z*240 scale 2 rotate < 0,25,0> translate <3, 0,0> } // back
		object { RocketSmokeGroup(RocketQual,43786,15,20*Feet) translate <-10,0,-24> }
		object { MiniSmokeGroup(RocketQual,44423,5,6*Feet) rotate <-15,0,0> translate <10,-18,-30> }
		object { MiniSmokeGroup(RocketQual,97473,5,5*Feet) rotate < 10,0,0> translate <10, 15,-28> }
	} // end union
#end


//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
#declare RocketQual=1;
global_settings {	max_trace_level 150 }

#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 30
		location  <-2*Feet, -32*Feet, 8*Feet> // overall
		look_at <6*Feet,0*Feet,3*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
//		location  <3, -14*Feet, 5*Feet> // detail
//		look_at <0,0,46>
//		angle 55
//		location  <-2*Feet, -32*Feet, 5*Feet> // look up
//		look_at <00*Feet,0,16*Feet>
	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue

light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}


light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <.8,.8,1.0>, rgb <.8,.8,1.0>*.75 } scale 10*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

//object { EjectionSeatStructureS rotate z*-90 translate <0,0,20> }
object { EjectionSeatPilot(RocketQual) rotate z*0  translate <-0*Feet,0,3*Feet>}
object { EjectionSeatPilot(RocketQual) rotate z*-70  translate <4*Feet,1*Feet,3*Feet>}
object { EjectionSeatPilot(RocketQual) rotate <0,-40,-130>  translate <7*Feet,-4*Feet,3*Feet>}
//object { RocketSmokeSphere(RocketQual) scale 40 translate <0,0,24*Feet> }
//object { EjectionSeatPilot(RocketQual) rotate x*0 rotate z*80  translate <-0*Feet,0,25*Feet>}
//object { EjectionSeatPilot(RocketQual) scale 3 rotate x*0 rotate z*-50  translate <0,0,18*Feet>}
//object { EjectionSeat(RocketQual) rotate x*0 rotate z*190  translate <14*Feet,0,25*Feet>}

#end

