
// POV-Ray Object File - Fishy
// created 15-Dec-05
// last update 28-Dec-05
// 2005 Glenn McCarter  ( glenn@mccarters.net )
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Fishy // jumping fish
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Fish origin is at the front center of lips,
// with the height of the fish in +Z,
// and the length extending into +X
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare FishTex =
	texture {
		pigment { color rgb<.967,.977,.996>*0.85 }
		normal { bumps 0.2 scale 0.3 }
		finish { specular 0.13 roughness 0.04 diffuse 0.4 ambient 0.05 reflection 0.282 }
	}
#declare EyeballWhite =
	texture {
		pigment { color rgb<.967,.977,.996>*0.95 }
		finish { specular 0.53 roughness 0.04 diffuse 0.4 ambient 0.405 reflection 0.184 }
	}
#declare EyeballBlue =
	texture {
		pigment { color rgb<.167,.477,.696>*0.095 }
		finish { specular 0.53 roughness 0.04 diffuse 0.4 ambient 0.405 reflection 0.138 }
	}

#declare SplashTex =
	texture {
//		pigment { color rgbf<0.167,0.316,0.382,0.07> }
		pigment { color rgbt<0.167,0.316,0.382,0.93> }
		normal { bumps 0.3 scale 0.5 }
		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.08,0.08,0.10>, <0.278,0.361,0.353> } conserve_energy} // mid reflection test
	}
#declare SplashInt =
	interior { ior 1.33  }

#declare SplashMat = // material
	material {
		texture { SplashTex }
		interior { SplashInt }
	}
#declare TestWhiteTex =
	texture {
		pigment { color rgb<1,1,1> }
	}


//===============================================
//             Macros
//===============================================

#macro FadeSphere(Zrot)
	sphere {
		<0,0,0>,1

		texture {
			pigment {
				spherical
				color_map {
//					[ 0.0 rgbf<1,1,1,0> ]
					[ 0.2 rgbf<1,1,1,1> ] // edge is clear
					[ 1.0 rgbf<1,1,1,0.34> ] // center is dense
				}
//				turbulence 0.3
				scale <10,1,1>
			}
//			finish { ambient 0.4 diffuse 0.6 }
			finish { ambient 0.4 diffuse 0.6 specular 0.03 roughness .14 }
		}

		rotate z*Zrot
//	texture { FakeWaterTex } // test
	}
#end

//===============================================
//             Fishy
//===============================================

#declare VFin =
	prism {
		linear_spline
		linear_sweep
		-0.1,0.1,
		11,
		<0,0>,
		<0,1.0>,
		<1.0,1.2>,
		<3.0,2.0>,
		<4.0,2.6>,
		<3.5,2.0>,
		<4.2,1.4>,
		<3.6,0.8>,
		<4.4,0.3>,
		<3.0,0.0>,
		<0.0,0.0>
	}
#declare FBodyShape =
	sphere_sweep {
		cubic_spline
		6,
		<-1,0,0>,0,
		<0,0,0>,1,
		<3,0.0,0.5>,3,
		<6,-0.5,0>,2.2,
		<9,-1.6,-1>,1.3,
		<10,-2.2,-1.5>,0
		scale <1,0.37,1>
	}
#declare MouthCutout =
	union {
		cylinder {
			<-1,0,0>,<2,0,0>,0.6
			scale <1,.4,1>
		}
		cylinder {
			<0,-3,0>,<0,3,0>,0.75
			translate <-0.93,0,0>
		}
	} // end union
#declare FBody =
	difference {
		object { FBodyShape }
		object { MouthCutout }
	} // end difference
#declare GillShape =
	sphere {
		<0,0,0>,1.5
		scale <0.76,0.2,1>
	}
#declare FishEye =
	union {
		sphere { <0,0,0>,0.46 texture { EyeballWhite } }
		sphere { <0,-0.3,0>,0.22 rotate z*-20 texture { EyeballBlue } }
		scale <1,.5,1>
	} // end union
#declare Fishy =
	union {
		object { FBody }
		object { FishEye translate <1.1,-0.782,0.65> }
		object { FishEye scale <1,-1,1> translate <1.1,0.782,0.65> }
		object { GillShape rotate z*15 translate <2.3,0.8,0> }
		object { GillShape rotate z*-15 translate <2.3,-0.8,0> }
		object { VFin rotate <5,-4,4> translate <3,0,2.5> } // dorsal
		object { VFin rotate y*9 translate <9,-0.8,-1.0> } // tail
		object { VFin scale <1,1,-1> rotate y*9 translate <9,-0.8,-1.0> } // tail
		object { VFin rotate <90,30,-60> translate <4,0.6,-1.5> }
		object { VFin rotate <90,30,-60> translate <4,0.6,-1.5> scale <1,-1,1> }
		texture { FishTex }
		scale <1.4*.8,.8,.8>
	} // end union

//===============================================
//             Splash
//===============================================

#declare SplashDripShape = // height in +Z, bends into +Y
	sphere_sweep {
		cubic_spline
		6,
		<0, 0.0,-2.0>,0.45,
		<0, 0.0, 0.0>,0.65,
		<0, 1.5, 1.5>,0.50,
		<0, 2.5, 2.4>,0.67,
		<0, 3.6, 2.8>,0.90,
		<0, 4.2, 3.3>,0

		scale <1.4,0.57,1>
	}

#declare SplashDrip =
	sphere_sweep {
		cubic_spline
		4,
		<0, 0.0,-2.0>,0.15,
		<0, 0.0, 0.0>,0.25,
		<0, 0.2, 1.0>,0.45,
		<0, 0.5, 1.8>,0.36
	}
#declare SplashSphere =
	sphere {
		<0,0,0>,0.6
		scale <.6,.6,1>
	}
#declare SplashGroupNoFoam =
	union {
		object { SplashDripShape scale <1,1,1.0> rotate x*-5  translate <0,3.0,0> rotate z*0 }
		object { SplashDripShape scale <1,1,0.9> rotate x*-12 translate <0,2.8,0> rotate z*40 }
		object { SplashDripShape scale <1,1,1.4> rotate x*-10 translate <0,3.4,0> rotate z*90 }
		object { SplashDripShape scale <1,1,1.0> rotate x*-16 translate <0,3.6,0> rotate z*120 }
		object { SplashDripShape scale <1,1,1.6> rotate x*-5  translate <0,3.2,0> rotate z*150 }
		object { SplashDripShape scale <1,1,1.2> rotate x*-20 translate <0,3.0,0> rotate z*190 }
		object { SplashDrip scale 2 rotate <-30,0,0> translate <0,3,6> }
		object { SplashDrip scale 1.4 rotate <-30,0,-40> translate <3,1,9> }
		object { SplashSphere scale 2 translate <0,0,8> } 
		object { SplashSphere scale .6 translate <-3,-2,6> } 
		object { SplashSphere scale 1.2 translate <-6,-2,12> } 
		object { SplashSphere scale 1.6 translate <4,-7,10> } 

//		texture { TestWhiteTex }
		material { SplashMat }
	} // end union

#declare SplashGroup =
	union {
		object { SplashGroupNoFoam }
		object { FadeSphere(130) scale 1.2 translate <0,0,1.5> }
		object { FadeSphere(130) scale 0.9 translate <1.2,1.3,1.9> }
		object { FadeSphere(130) scale 0.6 translate <-1.5,-1.0,1.8> }
		object { FadeSphere(130) scale 0.6 translate <0.5,2.2,2.3> }
	} // end union

//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 34
		location  <-2*Feet, -8*Feet, 3*Feet> // overall
		look_at <0*Feet,0*Feet,1*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
//		location  <3, -14*Feet, 5*Feet> // detail
//		look_at <0,0,46>
//		location  <3, -24*Feet, 5*Feet> // main wing
//		look_at <0,0,14*Feet>
//		location  <23*Feet,-5*Feet, 19*Feet> // upper RW
//		look_at <21*Feet,8*Feet,14*Feet>
//		location  <23*Feet,-25*Feet, 5*Feet> // lower RW
//		look_at <21*Feet,8*Feet,7*Feet>
//		location  <20*Feet, -20*Feet, 1*Feet> // down up view
//		look_at <10*Feet,0,4*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <.28,.28,1.0>, rgb <.28,.28,1.0>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }
/*
#object { Fishy translate <0,0,12> }
#object { Fishy rotate z*120 translate <-8,4,12> }
#object { Fishy rotate z*240 translate <-8,-4,12> }
*/
#object { SplashGroup rotate z*-90 translate <0,0,2> }
#end

