
// POV-Ray Object File - Trees
// created 4-Dec-05
// last update 26-Dec-05
// 2005 Glenn McCarter  ( glenn@mccarters.net )
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// SimpleTree() // fake plastic tree
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Tree origin is at the base of the trunk,
// with the height of the canopy in +Z,
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare TreeBarkTex =
	texture {
		pigment { color rgb<.967,.577,.396>*0.75 }
		finish { specular 0.03 roughness 0.40 diffuse 0.4 ambient 0.05 }
	}
 
#declare TreeLeafPig =
//	texture {
		pigment {
			bozo
			color_map {
				[ 0.00 rgb<.14,.67,.23>*.5 ]
				[ 0.45 rgb<.14,.67,.23>*.5 ]
				[ 0.47 rgbt<1,1,1,1> ]
			}
			scale .074
		}
//		finish { specular 0.13 roughness 0.05 }
//	}

#declare ClearPig =
	pigment {
		color rgbt<0,0,0,1>
	}
#macro FadeLeafSphere(Zrot)
	sphere {
		<0,0,0>,1
		texture {
			pigment {
				spherical
				pigment_map {
					[ 0.2 ClearPig ] // edge is clear
					[ 0.5 TreeLeafPig ] // center is dense
					[ 1.0 TreeLeafPig ] // center is dense
				}
				scale <10,1,1>
			}
//			finish { specular 0.13 roughness 0.05 }
		}
		rotate z*Zrot
	}
#end

//===============================================
//             Macros
//===============================================


//===============================================
//             Tree
//===============================================

#macro TreeTrunk(RS)
	union {
		cone { <0,0,0>,16,<0,0,12*Feet>,10 }
		cone { <0,0,12*Feet>,8,<4*Feet,8*Feet,24*Feet>,2 }
		cone { <0,0,12*Feet>,7,<-12*Feet,-4*Feet,21*Feet>,2}
		cone { <-4*Feet,-4*Feet,18*Feet>,6,<-8*Feet,-2*Feet,22*Feet>,2 }
		rotate z*rand(RS)*360			
		texture { TreeBarkTex }
	} // end union
#end

#macro TreeLeaves()
	sphere {
		<0,0,0>,16*Feet
		texture { TreeLeafTex }
	}
#end

#macro TreeLeavesGroup(RS,Groups)
	union {
		#local N=0;
		#while (N<Groups)
//			sphere {
//				<0,0,0>,12*Feet+rand(RS)*6*Feet
				object { FadeLeafSphere(90)
					scale 12*Feet+rand(RS)*6*Feet 
				translate <-6*Feet+rand(RS)*12*Feet,-6*Feet+rand(RS)*12*Feet,-6*Feet+rand(RS)*12*Feet>
//				texture { TreeLeafTex scale 4 }
			}
			#local N=N+1;
		#end
	} // end union
#end

#macro SimpleTree(RS,Groups)
	union {
		object { TreeTrunk(RS) }
		object { TreeLeavesGroup(RS,Groups) scale 1 translate <0,0,30*Feet> }
	}
#end

#macro SimpleBush(RS,Groups)
	#local SF=0.3+rand(RS)*0.6;
	object { TreeLeavesGroup(RS,Groups) scale <SF,SF,SF*.6> translate <0,0,3*Feet> }
#end

//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 34
		location  <-1*Feet, -140*Feet, 45*Feet> // overall
		look_at <0*Feet,0*Feet,16*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
//		location  <3, -14*Feet, 5*Feet> // detail
//		look_at <0,0,46>
	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <240*Feet,-200*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.2
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <.8,.8,1.0>, rgb <.8,.8,1.0>*.75 } scale 10*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }
//object { TreeTrunk() translate <0,0,0> }
#declare RS=seed(12094);
//object { SimpleTree(RS,4) translate <0,0,0> }
//object { SimpleTree(RS,4) translate <30*Feet,0,0> }
object { SimpleBush(RS,4) translate <0,-20*Feet,0> }
object { SimpleBush(RS,4) translate <30*Feet,-20*Feet,0> }

#end

