#include "Shapes.inc"     
#include "FullPullTex.inc"
#include "Stones.inc"

#ifdef (Blur)
  #version unofficial megapov 1.2;

  global_settings {
    motion_blur 5, 4         
  }
#end

#declare Barrier =
union{
  #declare r  = 0.1;
  #declare R  = 0.25;
  #declare h1 =   1;
  #declare h2 =   3.5;
  #declare l  =   7;
  
  cylinder{<0, 0, -l/2 + R> <0, 0, l/2-R> r translate<0, h1+h2, 0>} 
  cylinder{<0, 0, -l/2> <0, 0, l/2> r translate<0, h1, 0>} 
  
  object{tube(R,90,r) translate<0, h1+h2-R, l/2>}   
  object{tube(R,90,r) translate<0, h1+h2-R, l/2> rotate 180*y}   
  
  cylinder{<0,h1/2,0><0,h1+h2-R,0> r translate<0,0,-l/2>}
  cylinder{<0,h1/2,0><0,h1+h2-R,0> r translate<0,0, l/2>}  
  
  #declare x1 = 1.5;
  
  union{
     cylinder{<-x1/2+R, 0, 0>< x1/2-R, 0, 0> r translate<0,h1/2,0>} 
     object{tube(R,90,r) rotate -90*y translate<-x1/2,h1/2-R,0>}
     object{tube(R,90,r) rotate -90*y translate<-x1/2,h1/2-R,0> rotate 180*y}
     cylinder{<0,0,0><0,h1/2-R,0> r translate<-x1/2,0,0> }
     cylinder{<0,0,0><0,h1/2-R,0> r translate< x1/2,0,0> }
     translate<0,0,l/2>
  }
  union{
     cylinder{<-x1/2+R, 0, 0>< x1/2-R, 0, 0> r translate<0,h1/2,0>} 
     object{tube(R,90,r) rotate -90*y translate<-x1/2,h1/2-R,0>}
     object{tube(R,90,r) rotate -90*y translate<-x1/2,h1/2-R,0> rotate 180*y}
     cylinder{<0,0,0><0,h1/2-R,0> r translate<-x1/2,0,0> }
     cylinder{<0,0,0><0,h1/2-R,0> r translate< x1/2,0,0> }
     translate<0,0,-l/2>
  }
  
  #declare N=0;
  #while (N<=11)
    cylinder{<0,h1,0><0,h1+h2,0> r*0.5 translate<0, 0, 0.5*l*(0.835 - 1.67*N/11)>}
    #declare N=N+1;
  #end
  texture{BarrierTex}
}

#declare Scene =
union{ 
  
  //Basic ground
  height_field{
    jpeg "TrackB.jpg"           
    smooth
    pigment {
      image_map{    
        jpeg
        "TrackC.jpg"
        interpolate 2.0
      }      
      rotate 90*x
    }
    finish {
      ambient 0.5
    }
    translate<-0.5,0,-0.5>
    rotate 90*y
    scale<100,1,100> 
    translate<20,0,30>
  }

  #declare N=0;
  #while (N<4)
    object{Barrier translate<20,0,0> translate <0,1,N*7.5-5>}
    #declare N=N+1;                                  
  #end      
  
  #ifdef (Spectators)
    #include "Crowd_pov.inc"  
    object{
       Poseray_scene_object 
       rotate -90*y
       scale 10.5   
       translate <21.9,1,0.5> 
       
//       translate <0,0,3>
        
       no_shadow
    }
  #end   
  
  box{<36,0,-10><36.5,5.6,40> 
      pigment{
        gradient z   
        turbulence .5
        color_map{
         [0 White*.2]
         [1 rgb<.3,.3,.1> ]
        }
      }
  }
}


#declare Scenery =  
  #ifdef (Blur)
     motion_blur{
        object{Scene} 
        translate 0.0625*z*clock
     }
  #else
     object{Scene}
  #end
