#include "Shapes.inc" 
#include "FullPullTex.inc"
#include "Flags.inc"
#include "Lights.inc"

#macro Section(W) 
  union{
    object{ LumpyBox(W, H, 2*T, r, .075, 3) scale <1,1,1/2> translate <0, H/2,  0> }
    object{ LumpyBox(W, L, 2*T, r, .075, 3) scale <1,1,1/2> translate <0, L/2, 0> rotate -40*x translate <0, H - T/2, 0> }
  }
#end 

#macro Girder(L)

#declare W = 0.6;
#declare H = 1.0;
#declare T = 0.1;
#declare r = 0.2;

difference{
  
//   box{<-W/2,-H/2,-L/2><W/2,H/2,L/2>}
   rbox(W,H,L,0.075)
   
   union{
     
     #declare Y = H/2 - T;
     box{<-W,-Y,-L><-T/2-r, Y, L>}  
     box{< W,-Y,-L>< T/2+r, Y, L>}  
     
     #declare Y = H/2 - T - r;
     box{<-W,-Y,-L><-T/2, Y, L>}
     box{< W,-Y,-L>< T/2, Y, L>}
     
     cylinder{<-r-T/2, Y, -L><-r-T/2, Y,  L> r} 
     cylinder{< r+T/2, Y, -L>< r+T/2, Y,  L> r}
      
     cylinder{<-r-T/2,-Y, -L><-r-T/2,-Y,  L> r}   
     cylinder{< r+T/2,-Y, -L>< r+T/2,-Y,  L> r}   
   }
}
#end

#macro SqTube(L)

#declare W = 0.6;
#declare r = 0.1;

difference{
  
  object{
    difference{
      object{rbox(L+2*W, W, W, r)  translate<-L/2,0,0>}
      box{<0,-W-L,-W-L><L+2*W,W+L,W+L>  rotate -22.5*z }
    }
    
    translate<L,0,0>
  }
  box{<0,-W-L,-W-L><-L-2*W,W+L,W+L> rotate 22.5*z }
  translate<-L/2,0,0>
}

#end

#declare Seed = seed(1);

#macro TubeWeld()

#declare H = W/cos(radians(22.5)); 
#declare I = .05;
union{
  #declare N = -H/2+I;
  #while (N<H/2-I) 
    sphere{<0,0,0> I*(rand(Seed)) scale<1,1.5,1> translate<0,N,-W/2+I/2>}
    #declare N=N+I;
  #end
  #declare N = -W/2+I*2;
  #while (N<W/2-I) 
    sphere{<0,0,0> I*rand(Seed)*.8 scale<1,1,1.5> translate<0, H/2-I/2,N>}
    sphere{<0,0,0> I*rand(Seed)*.8 scale<1,1,1.5> translate<0,-H/2+I/2,N>}
    #declare N=N+I;
  #end
}

#end
     
#declare Support =  
difference{
 union{
   #declare L = 15;
   #declare H = 2;
   
   object{SqTube(L+1) rotate 90*y translate<0,H,0>}
   object{SqTube(L-2*H) rotate 90*y rotate 180*z}
   
   #declare l1 = H*1.4142;
   #declare N=-L/2;
   
   #while (N<L/2)
     
        object{SqTube(l1) rotate 90*y rotate 180*z translate <0,0,l1/2> rotate 45*x translate<0,H,N>}   
        object{SqTube(l1) rotate 90*y rotate 180*z translate <0,0,-l1/2> rotate -45*x translate<0,H,N+2*H>}   
        
        #declare N = N + 2*H;
   #end
 }
 object{SqTube(2*L) rotate 90*y  scale<.8,.8,1>translate<0,H,0>}  
 translate <0,-H,L/2>
}

#declare FlagBracket =
union{
  cylinder{<0,0,0><0,0.2,0>0.13}
  box{<0,0,-.13/2><.2,.2,.13/2>}
  cylinder{<.07,.1,.13/2><.2,.1,.13/2>.1}
  cylinder{<.07,.1,-.13/2><.2,.1,-.13/2>.1}
  sphere{<.07,.1,-.12>.03}
  sphere{<.07,.1, .12>.03}
  texture{AlloyTex}
}
  
#declare Sled = 
union{ 
///*
  //Do the front blade  
  
  #declare W1 =  6;
  #declare W2 =  1.5;

  #declare H =  5.5;
  #declare T =  0.15; 
  #declare r =  0.1;

  #declare L =  0.75;

  union{     
    object{Section(W1) }
    object{Section(W2) translate <-W2/2,0,0> rotate -20*y translate <-W1/2,0,0> }
    object{Section(W2) translate < W2/2,0,0> rotate  20*y translate < W1/2,0,0> }  
    
    #declare N = 0.1;
    #while  (N<H)
      sphere{<0,0,0> 0.07*(1+rand(Seed)) scale<1,1.5,1> translate <-W1/2, N, 0>}
      sphere{<0,0,0> 0.07*(1+rand(Seed)) scale<1,1.5,1> translate < W1/2, N, 0>}
      #declare N=N+.1;
    #end 
    
    union{
      #declare N = 0;
      #while  (N<W2)
        sphere{<0,0,0> 0.06*(1+rand(Seed)) scale<1.5,1,1> translate <-N, H-T/2, 0>}
        #declare N=N+.1;
      #end 
      rotate -20*y 
      translate <-W1/2,0,-T/2>
    }
    
    union{
      #declare N = 0;
      #while  (N<W2)
        sphere{<0,0,0> 0.06*(1+rand(Seed)) scale<1.5,1,1> translate < N, H-T/2, 0>}
        #declare N=N+.1;
      #end 
      rotate  20*y 
      translate < W1/2,0,-T/2>
    } 
    
    #declare N = -W1/2;
    #while  (N<W1/2)
       sphere{<0,0,0> 0.06*(1+rand(Seed)) scale<1.5,1,1> translate < N, H, -T/2>}
       #declare N=N+.1;
    #end 

    union{
      #declare N = 0;
      #while  (N<L-0.1)
        sphere{<0,0,0> 0.04*(1+rand(Seed)) scale<1,1.5,1> translate < 0, N, 0> }
        #declare N=N+.1;
      #end 
      rotate -40*x 
      rotate  10*y
      translate < W1/2,H,-T>
    } 
    union{
      #declare N = 0;
      #while  (N<L-0.15)
        sphere{<0,0,0> 0.04*(1+rand(Seed)) scale<1,1.5,1> translate < 0, N, 0> }
        #declare N=N+.1;
      #end 
      rotate -40*x 
      rotate -10*y
      translate <-W1/2,H,-T>
    } 
    
    texture{SledPlateTex}         
  }
// */
  //End of blade. Do the plate
  #declare W = 7;
  #declare L = 30;
  #declare T = 0.75;
  #declare r = 0.5;
  
  object{rbox(W,T*4,L,r) scale<1,1/4,1> translate<0,0,2+L/2>  }
  
  //Do the rails
  
  union{ 
    #declare Xg = 1.7; 
    #declare Yg = 5.75;
    union{
      difference{  
        object{ Girder(30) translate <0,0.5,15> rotate 5*x }
        box{<-10,-10,-10><10,10,0> rotate  42.5*x}
      }
      difference{  
        object{ Girder(2) rotate 90*x translate <0,1, 0.5> }
        box{<-10,-10,-10><10,0,10> rotate  -42.5*x}      
      }    
      translate<-Xg,Yg,0>
    }
    union{
      difference{  
        object{ Girder(30) translate <0,0.5,15> rotate 5*x }
        box{<-10,-10,-10><10,10,0> rotate  42.5*x}
      }
      difference{  
        object{ Girder(2) rotate 90*x translate <0,1, 0.5> }
        box{<-10,-10,-10><10,0,10> rotate  -42.5*x}      
      }    
      translate< Xg,Yg,0>
    } 
    
    object{rbox(2*Xg+0.6 + 0.05,  2, .1, .05)  translate<0,Yg + 1.05 ,0> }
    object{rbox(2*Xg+0.6,        .1,  1, .05)  translate<0,Yg + 2,0.5>   }
    
    #declare N = Yg + .25;
    #while  (N<Yg + 2)
       sphere{<-1.8,N,0> .1 }
       sphere{<-0.9,N,0> .1 }
       sphere{< 0,N,0> .1 }
       sphere{< 1.8,N,0> .1 }
       sphere{< 0.9,N,0> .1 }
       #declare N = N + .2;
    #end
    translate<0,0,1> 
    texture{GirderTex}  
  }
  
  //Supports
  object{Support rotate 5*x translate<-Xg, Yg - .4, 2>}
  object{Support rotate 5*x translate< Xg, Yg - .4, 2>}
     
  //TopFrame
  union{    
    #declare Tw = 3.3;
    object{SqTube(Tw) } 
    
    object{SqTube(1)  translate<-1/2, 0, 0> rotate 45*z translate<-Tw/2, 0, 0>}         
    object{SqTube(1)  translate< 1/2, 0, 0> rotate-45*z translate< Tw/2, 0, 0>}         
    
    object{SqTube(10) rotate  90*z translate<-Tw/2-1/1.41421, -5-1/1.41421, 0>}         
    object{SqTube(10) rotate -90*z translate< Tw/2+1/1.41421, -5-1/1.41421, 0>}         
    
    object{SqTube(6) rotate 90*z rotate 90*y translate <0, -3, 0> rotate -45*x translate<-Tw/2-1/1.41421, -6, 0>}  
    object{SqTube(6) rotate 90*z rotate 90*y translate <0, -3, 0> rotate -45*x translate< Tw/2+1/1.41421, -6, 0>}  
    
    object{TubeWeld() rotate  22.5*z translate<-Tw/2, 0, 0>}
    object{TubeWeld() rotate -22.5*z translate< Tw/2, 0, 0>}

    object{TubeWeld() rotate  67.5*z translate<-Tw/2-1/1.41421, -1/1.41421, 0>}
    object{TubeWeld() rotate -67.5*z translate< Tw/2+1/1.41421, -1/1.41421, 0>}
    
  
    object{RedLight               translate<-Tw/4, 0.3, 0>}
    object{GreenLight rotate 40*y translate< Tw/4, 0.3, 0>}

    translate<0,11,1.5>
  }

  //Flags      
  cylinder{<0,1,0><0,14.5,0>.1 translate <-2.78,0,1.5> texture{AlloyTex}}
  object{Flag1 translate <-2.78,13,1.5>} 
  object{FlagBracket translate<-2.78,6,1.5>} 
  object{FlagBracket translate<-2.78,9,1.5>} 
  
  cylinder{<0,1,0><0,14.5,0>.1 translate < 2.78,0,1.5> texture{AlloyTex}}
  object{Flag2 translate < 2.78,13,1.5>}     
  object{FlagBracket rotate 180*y translate< 2.78,6,1.5>} 
  object{FlagBracket rotate 180*y translate< 2.78,9,1.5>} 
  
  
  //Base
  union{
    object{Girder(40) translate<-3,1,20.5>}
    object{Girder(40) translate< 3,1,20.5>}
    
    
  }
  
  texture{SledTex}
  
  translate<0,0.1,7>
  
}

   