//
//  TITLE: X-1 Breaking The Sound Barrier
//
//  ---------------------------------------------------------------------------------------------
//  Number of frames                                      = 2  [+KFF2] 
//  Aspect Ratio                                          = 1.2 
//  Suggested resolution                                  = 1280 x 1024;  
//  Anti-aliasing (AA):                                   = Enabled [AA 0.3]
//  Avg Rendering Time Per Frame (AA Off)                 = 252.0 seconds
//  Avg Rendering Time Per Frame (AA On)                  = 295.0 seconds
//  Executed on a 3.2 GHz Pentium IV 
//
// ------------------------------------- Copyright notice ---------------------------------------  
//
//  Copyright 2005 Laurence A. Feldman email:larryf@lanl.gov
//


// Set +KFF2  



#include "colors.inc"
#declare itype = frame_number;

#declare tx = -0.5;  
#declare ty = -0.5;
#declare tz = -0.5;
#declare rx = 0.;
#declare ry = -90.;


#declare NX = 094;
#declare NY = 094;
#declare NZ = 094;   
#declare DD = <NX,NY,NZ>;
#declare VP = <00,00,200>;

#declare emitg = 100/(1.+10/72.);   // denominator from 1 to 10
#declare absorpg = 1000/(.002*1);   // denominator fro .001 to 1000 

camera {      
   location VP  
   up y
   right x*1.2
   angle 60
   sky <0,0,-1>
   look_at <0,0,0>    
   rotate <0,0,180> 

}  

light_source {
   VP + <0,0,NZ/2>
   color rgb <1,1,1>
   media_interaction on
   media_attenuation on
   shadowless
}    



#if (itype = 1)

#include "titlea.inc" 
#declare theinterior = interior {    
	 
      media {                                              
      intervals 100
      ratio 0.5
      samples 2,2
      method 2
      emission <1,1,1> / emitg
      absorption <1,0,0> / absorpg
      scattering { 1, <0,0,0> }
      confidence 0.999
      variance 1/1000
      density {           


   density_file df3 "volume_scalar_053.df3"



 	 interpolate 1

  color_map {         
			   [ 0.00    rgb<.1,.1,.1>] 
			   [ 0.35    rgb<.4,.4,.4>]     
			   [ 0.40    rgb<0,0,0>] 
			   [ 0.425   rgb<.7,.8,.8>]   
			   [ 0.45    rgb<0.3,0.3,0.3>]  
			   [ 0.50    rgb<0,0,0>]   
			   [ 0.70    rgb<.25,.25,.25>] 
			   [ 0.725   rgb<.6,.6,.6>]   
			   [ 0.7475  rgb<1,1,1>]          
			   [ 0.75    rgb<.3,.3,.3>]   
			   [ 0.755   rgb<1,1,1>] 
			   [ 0.765   rgb<0,0,0>] 
			   [ 0.80    rgb<.75,.75,.75>] 
			   [ 0.785   rgb<1,1,1>] 
			   [ 0.825   rgb<.7,.7,.7>]  
			   [ 0.845   rgb<1,1,1>]        
                           [ 0.85    rgb<0,0,0>] 
                           [ 0.855   rgb<1,1,1>]   
                           [ 0.90    rgb<1,1,1>]
             }		  
			
  
 
 }}} 

box {  <0,0,0>, <1,1,1>
   pigment { color rgbt <.2,.2,.3,.7>}
   interior { theinterior }
   hollow
	translate <tx,ty,tz>
	scale DD*1.80 
	rotate <0,-90,00> 
}   


   cylinder {<   0,0,0>,<   1,0,0> .005        pigment {color rgb <.2,.2,.3>} translate <tx,ty,tz> scale DD*1.80 rotate <rx,ry,00> }  
   cylinder {<   0,0,0>,<   0,0,1> .005        pigment {color rgb <.2,.2,.3>} translate <tx,ty,tz> scale DD*1.80 rotate <rx,ry,00> }    
   cylinder {<   0,0,0>,<   0,1,0> .005        pigment {color rgb <.2,.2,.3>} translate <tx,ty,tz> scale DD*1.80 rotate <rx,ry,00> }  
   cylinder {<   0,1,0>,<   1,1,0> .005        pigment {color rgb <.2,.2,.3>} translate <tx,ty,tz> scale DD*1.80 rotate <rx,ry,00> }    
   cylinder {<   0,1,0>,<   0,1,1> .005        pigment {color rgb <.2,.2,.3>} translate <tx,ty,tz> scale DD*1.80 rotate <rx,ry,00> }   
   cylinder {<   0,0,1>,<   0,1,1> .005        pigment {color rgb <.2,.2,.3>} translate <tx,ty,tz> scale DD*1.80 rotate <rx,ry,00> }  
   cylinder {<   1,0,0>,<   1,0,1> .005        pigment {color rgb <.2,.2,.3>} translate <tx,ty,tz> scale DD*1.80 rotate <rx,ry,00> }  
   cylinder {<   1,0,0>,<   1,1,0> .005        pigment {color rgb <.2,.2,.3>} translate <tx,ty,tz> scale DD*1.80 rotate <rx,ry,00> }    
   cylinder {<   1,1,0>,<   1,1,1> .005        pigment {color rgb <.2,.2,.3>} translate <tx,ty,tz> scale DD*1.80 rotate <rx,ry,00> }  
   cylinder {<   1,0,1>,<   1,1,1> .005        pigment {color rgb <.2,.2,.3>} translate <tx,ty,tz> scale DD*1.80 rotate <rx,ry,00> }    
   cylinder {<   0,1,1>,<   1,1,1> .005        pigment {color rgb <.2,.2,.3>} translate <tx,ty,tz> scale DD*1.80 rotate <rx,ry,00> }   
   cylinder {<   0,0,1>,<   1,0,1> .005        pigment {color rgb <.2,.2,.3>} translate <tx,ty,tz> scale DD*1.80 rotate <rx,ry,00> }    
  

#include "xbody.inc" 
object {x1_nogear  rotate<0,0,0>   translate <-0.0,-0.30,0>    scale <12.06,12.06,12.06>} 
 
#end                                                                
#if (itype = 2)  
 
   #include "light2.inc"
   #include "titleb.inc" 
   #include "mach_b1_053.pov"
   #include "x1_nogear.inc"
    object {x1_nogear  rotate<0,90,0>    translate <0,-1.75,0> rotate <0,-90,0>    scale <0.078,0.078,0.078> scale <100,100,100> }  
    object {iso1       rotate<0,-90,0>   scale <0.75,0.75,0.75> rotate <0,-90,0> scale <100,100,100> }  

   #declare ang = 315.;
   #include "mach_meter.pov" 
   object {meter rotate <0,0,0> translate <-25,-18,0> scale <3.5,3.5,3.5>} 

#end                                                                                                
   