/*---------------.lens fx.------------------
                 '-------'
megapov post processing to apply:
chromatic aboration - rgb seperation at edges due to refraction in the lens
vignetting - darkening at edges
*/

#version unofficial MegaPov 1.21;



#declare f_ease = function(x){ 3*x*x-2*x*x*x }                                                                                              

//lens_fx - call this inside your global settings.
#macro lens_fx()

	//todo: do a series of PP stages, not everything at once!

	post_process {
		#local rscale = 0;
		#local gscale = 0;
		#local bscale = 0;
		#ifdef (lens_dispersion)
			#if (lens_dispersion > 0)
				#local gscale = -lens_dispersion/2;	//actually I want this to be a curve, based on x^2+y^2
				#local bscale = -lens_dispersion;
			#else
				#local gscale = +lens_dispersion/2;
				#local rscale = +lens_dispersion;
			#end
		#end
		
		#ifndef (gamma_function) #declare gamma_function = function(x){x} #end
		
		#ifndef (lens_vignetting) #declare lens_vignetting = 0; #end


		#local x_scale = min(image_width/image_height,1);
		#local y_scale = min(image_height/image_width,1);

		#macro m_bilinear( func )
			#local bilinear_read =
				function (x,y,mx,my) {
					func( x+0/image_width, y+0/image_height ) * (1-mx)*(1-my)
					+
					func( x+1/image_width, y+0/image_height ) * mx*(1-my)
					+
					func( x+0/image_width, y+1/image_height ) * (1-mx)*my
					+
					func( x+1/image_width, y+1/image_height ) * mx*my
				}
			function (x,y) {
				bilinear_read(
					int(x*image_width)/image_width,int(y*image_height)/image_height,
					x*image_width-int(x*image_width),y*image_height-int(y*image_height)
				)
			}
		#end

		#macro m_lens_distort( func, distortmag )
			#local foo = m_bilinear( func )
				
			function(x,y,d) {
				foo( (1+distortmag*d)*x*.5/x_scale+.5 - .5/image_width, (1+distortmag*d)*y*.5/y_scale+.5 - .5/image_height )
			}
		#end
		
		
		#local vignetted_gamma =
			function(b,d) {
				gamma_function(
					b*(1-(f_ease(pow(d,.5))*lens_vignetting))
				)
			}

		#macro m_vignetted_gamma( func )
			function(x,y,d) { vignetted_gamma(func(x,y,d),d) }
		#end


		//I wish there was a way to declare variables in functions
		#local funcr2 = m_vignetted_gamma( m_lens_distort( f_output_red  , rscale ) )
		#local funcg2 = m_vignetted_gamma( m_lens_distort( f_output_green, gscale ) )
		#local funcb2 = m_vignetted_gamma( m_lens_distort( f_output_blue , bscale ) )

		#local funcr1 = function(x,y) { funcr2(x,y,(x*x+y*y)/2) }
		#local funcg1 = function(x,y) { funcg2(x,y,(x*x+y*y)/2) }
		#local funcb1 = function(x,y) { funcb2(x,y,(x*x+y*y)/2) }

		function { funcr1((x*2-1)*x_scale, (y*2-1)*y_scale) }
		function { funcg1((x*2-1)*x_scale, (y*2-1)*y_scale) }
		function { funcb1((x*2-1)*x_scale, (y*2-1)*y_scale) }
		
		function { f_output_alpha(x,y) }
		save_file concat("pp-",output_filename(0))
	}
#end



#if (0)
	//test scene
	
	#include "pprocess.inc"
	// store data of the color and transparency
	PP_Init_Alpha_Colors_Outputs()
	

	#include "rad_def.inc"

	global_settings {
		//assumed_gamma 1
		//radiosity { Rad_Settings(Radiosity_2Bounce,on,on) }
		ambient_light rgb <.1,.2,.3>/4

		#declare lens_vignetting = .8;
		#declare lens_dispersion = -0.1;	
		#declare colour_matrix = 0.01;
		#declare gamma_function = function(x) { pow(x,1/2.2) }//2*min(1,max(0,pow(x,2)*3 - pow(x,3)*2)) }
		lens_fx()
	}
	
	camera {
		right	x
		up y*image_height/image_width
		direction z
	}
	
	#if (0)
		background { rgb 1 }
		plane { -z,-4 pigment { checker rgbt 1, rgb 0 } }
	#else
		//fancy scene
		background { rgb <.1,.2,.3>/4 }
		
		#default { pigment { rgb .8 } finish{ ambient 1 diffuse 1 } }
		union {
			plane { y, -1 pigment { checker rgb .01, rgb 1 rotate y*30 } normal { granite } }
			blob {
				sphere { -x*2, 2, 1.5 pigment { rgb x } finish { specular 1 roughness .001 } }
				sphere { z, 2, 1.5 pigment { rgb y } finish { specular 1 roughness .001 } }
				sphere { x*2, 2, 1.5 pigment { rgb z } finish { specular 1 roughness .001 } }
			}
			
			rotate -20*x
			translate z*6
		}
		
		light_source { <-2,3,-1>*3, rgb 1 fade_power 2 fade_distance 16 }//spotlight point_at z*6 radius 10 falloff 15 }
	#end
	
#end

