// test cantop 
#ifndef(Get)
 #include "colors.inc" 

 global_settings{ max_trace_level 50 }
 camera{ location <0,2,-5> 
        right x*image_width/image_height
        look_at <0,2,0>
        }
// background {Pink}
 light_source{<0,20,-20> White}
 light_source{<0,20,0> White}
 light_source{<-20,0,-20> White*.75}

 light_source{<0,3,0> White}
#end                 
/*
polygon{5,<-50,-50,-30>,<-50,50,-30>,
          <50,50,-30>,<50,-50,-30>,<-50,-50,-30> 
          pigment{bozo 
           color_map{[0 rgb<.2,.2,.23>][.5 rgb<.3,.3,.34>][1 rgb<.2,.2,.23>]}
           scale 10}
          finish{ambient .5 diffuse 0}
        } 
*/         
//cylinder{<5,1,0><-5,1,0>,.1 pigment{Red}}
#declare Can=
intersection{
             sphere{0,.5 scale <1.5,1,1.5> translate <-.3,1.4,-.2> inverse}
             sphere{0,.48 scale <1,.5,1> translate y inverse}
             cylinder{x,-x,.2 rotate y* 25 scale<.8,.3,.8> translate y*1 inverse}
             cylinder{0,x,.3  rotate y* 25 scale<1,.25,1> translate y*1 inverse}
             cylinder{0,z,.2  scale<.7,.4,.7> translate y inverse}
             cylinder{0,z,.2  scale<.6,.4,.6> rotate -y* 25 translate y inverse}
             cylinder{0,z,.1  scale<1,.25,1> rotate y* 35 translate y*1 inverse}
             cylinder{0,z,.1  scale<1,.25,1> rotate y* 65 translate y*1 inverse}
             cylinder{0,-z,.1  scale<1.3,.5,1.3> rotate y* 33 translate y*.8 inverse}
             sphere{0,.48 scale <1,.5,1> translate <-.2,1,-.2> inverse}
             cone{-y*5,1,y,.5}  
             hollow //translate y*.5
}
//object{Can pigment{Gold} }//translate -y*.5}

object{Can
    // pigment{rgbt <.2,.2,.25,.83>} 
     pigment{rgbf<.9,.9,.95,.95>}
     interior{ior 1.309} //media{emission <.3,.3,.35> absorption <.5,.5,.75>}}
     //normal{agate scale 10}
     finish{diffuse .5  reflection .2 
            //phong 2 phong_size 250 
            specular 1 roughness .005}
     }        
  

//Water
//sphere{0,.4 scale <1,.5,1> translate y*.75 pigment{Blue}}

#declare Water=
blob {
 threshold 0.3
 sphere{0,.5,1 scale <1.5,.6,1.5> translate y*.75}
 #declare N = 0;
 #declare Norm = <0, 0, 0>; 
 // Drip1
  sphere{<-.250,712,-.375>,.15,1}
  #declare Cnt = 0;
  #while (Cnt < 10)
    #declare Ct=.662-Cnt*.05;
    //#declare Cv=.15-Cnt*.005;
   #declare Start = <-.7,Ct,-1>; 
   #declare Inter= trace (Can, Start,<.7,Ct,1>, Norm );                 
   #if (vlength(Norm)!=0) 
     sphere{0,.1,.7 scale<1,1.1,1> translate Inter}
    #declare N=N+1;
//    #debug concat("DripInter= <",vstr(3,Inter,",",3,3),">\n") 
   #end
  #declare Cnt = Cnt+1; 
  #end

   #declare Start = <-.7,Ct-.05,-1>; 
   #declare Inter= trace (Can, Start,<.7,Ct-.05,1>, Norm );                 
   #if (vlength(Norm)!=0) sphere{Inter,.15,1.1} #end
 
   #declare Start = <-.2,2,-.3>; 
   #declare Inter= trace (Can, Start,-y, Norm );                 
   #if (vlength(Norm)!=0) sphere{Inter,.15,.7} #end

   #declare Start = <-.25,2,-.35>; 
   #declare Inter= trace (Can, Start,-y, Norm );                 
   #if (vlength(Norm)!=0) sphere{Inter,.15,.7} #end
//#debug concat("N=",str(N,3,3),"\n")    
sturm}

intersection{object{Water} object{Can inverse} hollow
//              pigment{Red}
            pigment{rgbf <.7,.7,.8,.9>} 
            interior{ior 1.33}// media{absorption <.08,.08,.18>}}
            finish{reflection .3
                   //conserve_energy 
                   diffuse .2
                   phong 0.9 phong_size 180//200 
                   brilliance 3  specular .2 roughness .000005}        

            translate <-.0000001,.0000001,-.0000001>
            }

//#declare Get=1;
#ifndef(Get)
 #declare Get=1;
 #include "Wick.pov"
 object{Wick scale<.45,1,.45> translate y*.045}
 object{
 #include "Wick5.inc" pigment{agate 
  color_map{[.5 Clear][.5 White*.1]} scale .001}
  finish{ambient 1 }
  scale<.005,.0055,.005> rotate z*3 rotate y*56 translate <-.01,.85,.018>} 

 #include "Flame4.Lat"
 object{Thing pigment{Yellow} finish{ambient 1 diffuse 0}
 scale 2 scale .8  rotate z*4 translate y*1.6 no_shadow}

#end 
