//Rope using sphere_sweep
#ifndef(Get) 
 #include "colors.inc"      

 global_settings{ max_trace_level 50 }
 camera{ location <0,2,-5> 
        right x*image_width/image_height
        look_at <0,2,0>
        }
 background {Pink}
 light_source{<0,0,-20> White}
 light_source{<0,0,20> White}
#end
#declare Start=y*1.5; //start of rope
#declare End=-y*6; //End of rope

#declare Turn=.5;// turns per pov unit
#declare Wires=5;// number of strands
#declare Thick=.04;// thinkness
#declare Bite=0;// < Thick cut into

#declare a=90-(180/Wires); #declare b=360/Wires;
#declare Cr=Thick/cos(radians(a))*(1-Bite);

//#declare St=array[Wires];
#declare q=vlength(End-Start);
#declare Wend=int(q/(Thick*Wires/Turn)+1);
//#debug concat("q="str(q,3,3),"\n")
#debug concat("Wend="str(Wend,3,3),"\n")
#declare Wr=array[Wend+1]; 
//cylinder{<2,-q/2,0><2,q/2,0>,Thick pigment{Red}}

#declare Cnt = -1;
#while (Cnt < Wend)
  #declare Wr[Cnt+1]= vrotate(z*Cr,y*Cnt*b)-y*(Cnt*Thick*Wires/Turn);
#declare Cnt = Cnt+1; 
#end
//#debug concat("St="str(Wr[1].y,3,3),"\n")
//#debug concat("En="str(Wr[Wend-1].y,3,3),"\n")
//warp end
#declare Wr[0]=Wr[0]*.1;
#declare Wr[1]=Wr[1]*.8;
//#declare Wr[2]=Wr[2]*.8;
#declare Cnt2 = 0;
#declare Wick=union{
#while (Cnt2 <Wires)
 sphere_sweep{b_spline 
  Wend
 #declare Cnt = 0;
 #while (Cnt <Wend)
  #if (Cnt<2) Wr[Cnt],Thick*.5
  #else Wr[Cnt],Thick
  #end
 #declare Cnt = Cnt+1; 
 #end
 rotate y*Cnt2*b} 
#declare Cnt2 = Cnt2+1; 
#end
// translate y*3.5 
 pigment{White}
 finish{diffuse .3}
// bounded_by{box{<-(Cr+Thick+.1),.1,-(Cr+Thick+.1)><Cr+Thick+.1,Wr[Wend-1].y,Cr+Thick+.1>} }
 translate y*1.1 
 }

#ifndef(Get) 
 object{Wick}
#end 

/*
#while (Cnt < Wires)
 sphere{y*Cr,Thick pigment{rgbt .5} rotate z*Cnt*b}
#declare Cnt = Cnt+1; 
#end
*/