//"Far sun" by Shigeyoshi M
//Internet Ray Tracing Competition, Feb 2006, topic is "Fire and Ice"

//+A0.001 (W1280 H1024) = 2h 07m 49s( Low Camera Location ) 

#version 3.6;

#declare Low_Cam_Loc=on;    //Low_Camera_Location  
#declare Deep=off;          //global_settings:ambient_light =blue
#declare Dark=on;           //global_settings:assumed_gamma
#declare Diamond_dust=on;   //few
#declare SmallSun=off;      //small sun
#declare ClearLine =off;    //on=clear horizontal line
 
#declare Right_object=on;
#declare Center_ice_cube=on;
#declare Left_box=on;

#declare Ice_In = interior{ ior 1.01 } 

//------------------------------------------------  

global_settings
{ max_trace_level 10*3
  #if (Deep) 
  ambient_light rgb <0.294, 0.384, 0.561>
  #end
} 

#if (Dark) 
global_settings {assumed_gamma 2.8 } 
#else
global_settings {assumed_gamma 2.2 } 
#end  



//------------------------------------------------
//Light ------------------------------------------

#if (SmallSun)
  light_source {
    <0, 10, -3>
  color rgb 7.7 
               } 
#else 
//Main
  light_source {
    <0, 10, -5> 
    color rgb 7.7
               }
//Sub
  light_source {
    <0, 10, -3>
  color rgb 1.7
               }   
#end  

//------------------------------------------------ 
//Camera -----------------------------------------  
#if (Low_Cam_Loc)     

camera {  
        location <0, 0.25+5, -150>
        look_at <0, 0.25+5, 0>  
        angle 30 
        right x*image_width/image_height 
       } 
#else 
camera {  
       location <0, 15, -150>
       look_at <0, 5, 0>
       angle 40
       right x*image_width/image_height 
}   
#end 


//-------------------------------------------------
//Fog ---------------------------------------------


       //------------------------------------------
   //Low_angle Main Fog         
    fog{ color rgbt <0.777, 0.777, 0.859, 0.51>
    fog_type 2                                                                                 
    fog_alt 0.5
    fog_offset -17     
    distance -15
    turbulence <.15, .55, .95> 
    omega 0.35 
    lambda 1.25 
    octaves 5 
   rotate 180*x   
      }  
   
   //Sub Fog   
   fog{ color rgbt <0.777, 0.777, 0.859, 0.999> 
    fog_type 2                                                                                 
    fog_alt 0.5
    fog_offset 17
    distance -5.0
      //turbulence <.15, .55, .95>
      turbulence <.15, .55, .85> 
   
    omega 0.35 
    lambda 1.25 
    octaves 5 
   rotate -180*x  
      } 
      

     
   //----------------------------------------------      

   //Like a Filter
    fog{
    color rgbt<0.3, 0.3, 0.5, 0.05>
    fog_type 2
    fog_alt 0.5
    fog_offset 5
    distance 149
    turbulence <.15, .55, .95>
    omega 2
    lambda 1.5
    octaves 8 
    rotate 90*x  
       }  


//---------------------------------------------------------- 
//Sky-------------------------------------------------------
      
//Back Sky-------------------------------------------------- 
object {
  plane { z, 0 } 
  pigment{
        gradient y
         color_map{ [0 color rgb <0.235, 0.082, 0.02>]//down      
                   [0.005 color rgb <0.278, 0.031, 0.188>]
                   [0.01 color rgb <0.392, 0.059, 0.177>] 
                   [0.05 color rgb <0.592, 0.031, 0.063>]
                   [0.2 color rgb <1, 0.502, 0.251>] 
                   [0.9 color  rgb <0.91, 0.863, 0.612>]
                   [1.0 color rgb <1, 1, 0.784>] //upper
                }  
                scale 50 
        }   
  hollow
  }
    
//Near Sky------------------------------------------------------- 
#declare Tmt = 0.2;
object {
  plane { z, -9}         
  pigment{
        gradient y
        color_map{ [0 color rgbt <0.235, 0.082, 0.02, Tmt>]//down      
                   [0.005 color rgbt <0.278, 0.031, 0.188, Tmt>]
                   [0.01 color rgbt <0.392, 0.059, 0.177, Tmt>] 
                   [0.05 color rgbt <0.592, 0.031, 0.063, Tmt>]
                   [0.2 color rgbt <1, 0.502, 0.251, Tmt>] 
                   [0.9 color  rgbt <0.91, 0.863, 0.612, Tmt>]
                   [1.0 color rgbt <1, 1, 0.784, Tmt>] //upper
                 }
                 scale 50 
        }   
   hollow 
}         
 
     

//---------------------------------------------------------------
//Earth and Water

object {
  plane { y, 0 } 
  pigment{
        gradient z 
        color_map{
                [0.1 color rgb <1, 1, 1>] //near 
                [0.4 color rgb <0.745, 0.918, 0.929>] 
                [0.97 color rgb <0.357, 0.392, 0.675>]  
                [1.0 color rgb <0.235, 0.082, 0.02>]//far
                  } 
                scale 200
         }  
      finish {
        reflection 0.5
             }
   hollow 
}  

//Ice field 
object {
        #if (ClearLine)
         box { <-500, 0, -9>, <500, 1, -200> }//clear horizontal line 
        #else
         box { <-500, 0, 0>, <500, 1, -200> }
        #end 

       pigment{
       waves
       color_map{
               [0 color rgbf <1, 1, 1, 0.95>]
               [1 color rgbf <0.753, 0.753, 0.753, 0.95>]
               } 
                   //scale 0.01
                   scale 0.05
       }
        interior{Ice_In }
        finish { reflection 0.1 }
       } 
       
 
//Sub Ice field 
object {  
#if (ClearLine)
   box { <-500, -0.75, 100-9>, <500, 0.25, -100> }//clear horizontal line
#else
   box { <-500, -0.75, 100>, <500, 0.25, -100> }
#end

       pigment{
       waves
       color_map{
               [0 color rgbt <1, 1, 1, 0.95>]
               [1 color rgbt <0.753, 0.753, 0.753, 0.95>]
               } 
                   //scale 0.01
                   scale 0.05
       }
         interior{Ice_In }
         finish {  reflection 0.1 }
       translate <0, 0.5, -100>
       hollow
       }  
  
//------------------------------------------------------------------------------------ 
//OBJECT---------------------------------------------------
//Right, Center, Left
 
#declare RBox_Pig =   
pigment{
       wrinkles
       color_map{
               [0 color rgbt <1, 1, 1, 0.995>]
               [1 color rgbt <0.753, 0.753, 0.753, 0.995>]
               }
               scale 0.5
       }
          
#declare CCube_Pig =        
pigment{
       crackle
       color_map{
               [0 color rgbt <1, 1, 1, 0.85>] 
               [0.3 color rgbt <0.753, 0.753, 0.753, 0.95>] 
               [1 color rgbt <0.424, 0.471, 0.478, 0.95>]
                } 
               scale 1      
       }
        
#declare LBox_Pig =        
pigment{
       dents
       color_map{
               [0 color rgbt <1, 1, 1, 0.95>] 
               [1 color rgbt <0.753, 0.753, 0.753, 0.95>]
               } 
               scale 0.5       
       } 
        
//------------------------------------------------------------    
//Center Ice Cube   

#if (Center_ice_cube)
object {
        superellipsoid{<0.2,0.2>} 
        pigment{ CCube_Pig }
        interior{Ice_In } 
        finish { ambient <1, 1, 1>*0.1
           specular 0.025
                }	
        scale <1.5, 1.5, 1.5> 
        rotate -10*y     
        translate <0, 1.5+0.1, -90-1>
        rotate 2*z 
        hollow  
       }     
#end 


//------------------------------------------------------------
//Right_Object
#declare Right_obj =
object {
        superellipsoid{<0.2,0.2>}
        pigment{ RBox_Pig }
        interior{ Ice_In }
        scale <1.5, 1.5, 1.5> 
} 

#declare MyBox3 =
object {
        superellipsoid{<0.2,0.2>}
        pigment{ rgbt <0.518, 0.612, 0.643, 0.92>} 
        interior{Ice_In } 
        scale <1.3, 1.3, 2.5> 
}

#declare My_Right_obj =
difference { 
     object{ Right_obj }
     object{ MyBox3 } 
     object{ MyBox3
     rotate 90*y }
     object{ MyBox3 
     rotate 90*x } 
           }


declare R_Tr = 3;

#if (Right_object)
object { My_Right_obj 
     rotate <0, 15, 0> 
     translate <3.5+R_Tr, 1.5+0.1, -90> 
}
#end


//------------------------------------------------------------ 
//Left_Box 
#declare Lpos = -0.25;

#if (Left_box) 
difference {
object {
     superellipsoid{<0.1,0.1>}
        pigment{ rgbt <0.518, 0.612, 0.643, 0.9>}
        interior{ Ice_In }
        scale 2 
       }

object {
superellipsoid{<0.1,0.1>}
       pigment{ LBox_Pig }
       scale 1.8
       }
    translate <-5+Lpos, 2+0.1, -88>  
}

///////////TEXT---------------------------------------------------- 

#declare Text_Color = pigment{ rgbt <0.294, 0.294, 0.294, 0.8> }
object {
	text {
		ttf
		"timrom.ttf",
		"From :",
		0.2,
		<0, 0, 0>
	     }
	pigment{ Text_Color}
        finish { 
                 specular 0.2 }
	scale 0.5
     translate < -5.95-0.2+Lpos, 0.5+0.3, -90-0.1-0.2>
} 
 
object {
       text {
		ttf
		"timrom.ttf",
		"Tokyo River",
		0.2,
		<0, 0, 0>
	    }
	pigment{ Text_Color}
        finish {
                 specular 0.2 }
	scale 0.5
     translate < -5.95-0.2+Lpos, 0.1+0.3, -90-0.1-0.2>
} 
#end 

//-----------------------------------------------------------------
// Diamond dust (Mini-Hexagon)
#if (Diamond_dust) 
#declare Ddust =    
object{    
     prism {
    linear_sweep
    linear_spline
    0, 
    1,
    7,
    <3,5>, <-3,5>, <-5,0>, <-3,-5>, <3, -5>, <5,0>, <3,5>
            } 
    scale 0.005
    hollow 
 }

#declare r0 = seed (14325); 
#declare r1 = seed (15345); 
#declare r2 = seed (12355); 
#declare r3 = seed (12545); 
#declare r4 = seed (12335);
#declare r5 = seed (12345);

#declare MyValue = -20;
#while ( MyValue <= 21 )
  object {
    Ddust
    pigment { color rgbt <1*rand(r1), 1*rand(r2), 1*rand(r3), 0.99> } 
    finish{
              irid{
                   0.6
                   thickness 0
                   turbulence 0
                   }
              diffuse 0.7
              ambient 0.3 
              reflection 0.15//0.5
             }
             interior{ior 0.8}

    rotate <rand(r1)*180,rand(r2)*180,rand(r3)*180>
    translate <MyValue*rand(r5), rand(r0)*3+9, rand(r4)*3-90> 
  }
  #declare MyValue = MyValue + 1;
#end 
    
#end
//------------- end -------------------------------------------------------------