// Persistence of Vision Ray Tracer Scene Description File
// File: fire.inc
// Vers: 3.6
// Desc: Include file for a fire macro.
// Date: Feb 2006
// Auth: Bruno Cabasson

#ifndef (_fire_inc)
#declare _fire_inc = version;

#include "colors.inc"
#include "functions.inc"

#declare CM_Fire0 = color_map
                {
                    [0.0  rgb 0]
                    [0.1 color Red filter 1]
                    [0.3 color Red filter 1]
                    [0.5 Green filter 1]
                    [1 Blue filter 1]
                }
#declare CM_Fire1 = color_map
                {
                    [0.2 color 0]
                    [0.25 0.1*Yellow]
                    [0.4 0.2*Yellow]
                    [0.6 0.3*Orange]
                    [0.8 0.5*Red]
                    [1 Blue]
                }
#declare CM_Fire2 = color_map
                {
                    [0.15 color 0]
                    [0.17 0.1*Yellow]
                    [0.35 0.4*Yellow]
                    [0.5 0.5*Orange]
                    [0.7 0.6*Red]
                    [1 Blue]
                }
#declare CM_Fire3 = color_map
                {
                    [0.23 color 0]
                    [0.25 0.4*Yellow]
                    [0.4 0.8*Yellow]
                    [0.6 0.5*Orange]
                    [0.65 0.6*Red]
                    [1 Blue]
                }
#declare CM_Fire4 = color_map
                {
                    [0.2 color 0]
                    [0.25 0.1*Yellow]
                    [0.4 0.2*Yellow]
                    [0.6 0.3*Orange]
                    [0.8 0.5*Red]
                    [1 Blue]
                }
#declare CM_Fire5 = color_map
                {
                    [0.0   color 0]
                    [0.05   Red]
                    //[0.2    color rgb 0.7*<0.718,0.212,0.000>]
                    [0.2    color rgb <0.718,0.212,0.000>]
                    [0.3    color rgb <1.000,0.549,0.075>]
                    [0.5    color rgb <1.000,0.549,0.075>]
                    [0.6    color rgb <0.957,0.980,0.333>]
                    [0.8      color rgb <0.988,1.000,0.894>]
                }
                
#declare CM_Fire6 = color_map
                {
                    [0.0   color 0]
                    [0.05   Red]
                    //[0.2    color rgb 0.7*<0.718,0.212,0.000>]
                    [0.2    color rgb <0.718,0.212,0.000>]
                    [0.35    color rgb <1.000,0.549,0.075>]
                    [0.6    color rgb <1.000,0.549,0.075>]
                    [0.75    color rgb <0.957,0.980,0.333>]
                    [0.9      color rgb <0.988,1.000,0.894>]
                }

/* color_map file created by the GIMP */
/* http://www.gimp.org/               */
#declare CM_Incandescent = color_map {
	[0.000000 color rgbt <0.000000, 0.000000, 0.000000, 0.000000>]
	[0.459098 color rgbt <0.364706, 0.000000, 0.000000, 0.000000>]
	[0.594324 color rgbt <0.729412, 0.000000, 0.000000, 0.000000>]
	[0.594324 color rgbt <0.729412, 0.000000, 0.000000, 0.000000>]
	[0.677796 color rgbt <0.864706, 0.272549, 0.098039, 0.000000>]
	[0.809683 color rgbt <1.000000, 0.545098, 0.196078, 0.000000>]
	[0.809683 color rgbt <1.000000, 0.545098, 0.196078, 0.000000>]
	[0.853088 color rgbt <0.986274, 0.741176, 0.135294, 0.000000>]
	[0.899833 color rgbt <0.972549, 0.937255, 0.074510, 0.000000>]
	[0.899833 color rgbt <0.972549, 0.937255, 0.074510, 0.000000>]
	[0.948247 color rgbt <0.974510, 0.952941, 0.452942, 0.000000>]
	[1.000000 color rgbt <0.976471, 0.968627, 0.831373, 0.000000>]
} /* color_map */

#declare CM_CandleFlame = color_map
                {
                    [0.0   color 0]
                    //[0.03  0.5*Red]
                    [0.01   0.8*OrangeRed]
                    [0.02   color 0.8*(Yellow+0.1*White)]
                    [0.2   color (Yellow+0.2*White)]
                    [0.35   color 0.3*MediumSlateBlue]
                    //[0.6   color 0.2*MediumSlateBlue]
                    //[0.7   color 0.1*MediumSlateBlue ]
                }
                
#declare CM_Flame1 = color_map
                {
                    [0.0   color 0]
                    [0.03  0.5*Red]
                    [0.1   0.8*OrangeRed]
                    [0.2   color 0.8*(Yellow+0.1*White)]
                    [0.4   color (Yellow+0.2*White)]
                    [0.55   color 0.3*MediumSlateBlue]
                    //[0.6   color 0.2*MediumSlateBlue]
                    [0.7   color 0.1*MediumSlateBlue ]
                }

// --------------------------------------------------------------------------------------
#macro MakeFire (_brightness, _complexity, _global_turb, _colormap, _vertex, _offset, _mask_power, _random)
#local o_basic_object1 = merge
{
    intersection {sphere {0, 1 scale 1.8*y} plane {-y, 0}}
    intersection {sphere {0, 1} plane {y, 0.0}}
}
#local o_basic_object2 = isosurface
{

  function {f_sphere(x/(1-y/5), y, z/(1-y/5), 1)}
  max_gradient 1.3
  contained_by {sphere {0, 1.1}}
  scale 1.2*y
}

#local o_basic_object = o_basic_object1;

#local T = 0.15;
#local turb_scale = 1 + _complexity;

#local P_MainPattern = pigment
{
    #local turb_margin = 0.1 + 0.2*_complexity;
    spherical scale (1-turb_margin)
    scale turb_scale
    translate 1000*_random
    //warp {turbulence 0.9*_complexity octaves 4 lambda 1.6 omega 0.5}
    warp {turbulence 0.9*_complexity octaves 4+6*_complexity lambda 1.8+0.5*_complexity omega 0.5+0.5*_complexity}
    translate -1000*_random
    scale 1/turb_scale
    scale 1/2 warp {turbulence 0.2*_global_turb omega 0.5} scale 2
    scale 1.5*_vertex*y
    translate _offset*y
}

#local D_Main = density 
{
    pigment_pattern {P_MainPattern}
    color_map {_colormap}
}

#local D_Mask = density
{
    pigment_pattern {P_MainPattern}
    color_map {[0.01 rgb 0] [0.01 rgbt 1]}
}

#local D_Envelope = density
{
    pigment_pattern 
    {
        object {o_basic_object scale (1-turb_margin)}
        scale 2*turb_scale
        translate 100*_random*_random
        warp {turbulence 0.5*_complexity octaves 7+5*sqrt(_complexity) lambda 1.4+0.6*_complexity omega 0.55+0.6*_complexity}
        translate -100*_random*_random
        scale 1/(2*turb_scale)
        scale 1/2 warp {turbulence 0.2*_global_turb omega 0.5} scale 2
        scale 1.2*y
    }
    color_map {[0.5 rgb 0] [0.5 rgb 1]}
} 

#local nb_samples = 80 + 40*_complexity;

#local M_MediaMain =  media
{
    samples nb_samples
    intervals 1
    //scattering {1, rgb 10*_brightness}
    emission rgb 3*_brightness
    //absorption rgb 10*_brightness
    density {D_Main}
    density {D_Envelope}
}

#local M_MediaMask = media
{
    samples nb_samples
    intervals 1
    scattering {1, rgb 0.05+0.5*_mask_power*_brightness extinction 5+15*_mask_power}
    //emission rgb _brightness
    //absorption 0.2*_brightness
    density {D_Mask scale 0.99}
    density {D_Envelope}
}
        
#local o_flame_object = object 
{
    o_basic_object
    hollow
    pigment {rgbt 1}
    interior
    {
        media {M_MediaMain}
        media {M_MediaMask}
    }
}

object {o_flame_object}

#end
// --------------------------------------------------------------------------------------
#end