
// POV-Ray Object File - Furnishings
// created 19-Mar-06
// last update 19-Mar-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// FiveDollarChair
// FileCabinet
// StudioLight
// Radiator (requires "RadiatorHFMap.png")
// Cigarette
// BurningCigarette(WhiteLength)
// BurntOutCigarette
// StubbedCigarette
// CigaretteSmoke (requires "CigaretteSmoke_ColorMap.png")
// Ashtray
// CrumpledPaper(RSeed)
// PushBroom
// PipeGroup
// Bucket
// Kitchenette
// CrumpledPaper(Num,TRS)
// CardboardBox(L,W,H,FlapsOpen)
// CardboardBoxStack
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// 
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================

#if (RenderMe = 1)
	#local Radios=0;
#end

//===============================================
//             Textures
//===============================================

#declare TTP=<0.627,0.447,0.227>*.5;
#declare TeakTex =
	texture {
//		pigment { color rgb <0.627,0.447,0.227> } // a bit too bold, like Maple
//		pigment { color rgb <0.627,0.447,0.227>*.5 } // test
		pigment {
			wood // z-axis
			color_map {
				[ 0.00 color rgb <0.560, 0.352, 0.225>*0.60 ]
				[ 0.40 color rgb <0.780, 0.635, 0.350>*0.15 ]
				[ 0.60 color rgb <0.790, 0.605, 0.404>*0.50 ]
				[ 1.00 color rgb <0.560, 0.352, 0.225>*0.20 ]

			}
			turbulence 0.025
			omega 0.45
			lambda 2.3
		}
		finish { ambient .10 specular .35 roughness .125 }
	}
#declare FiveDollarChairTex  =
	texture {
		pigment {
			bozo
			color_map {
//				[ 0.0 color rgb <0.945,0.829,0.752>*.6 ]
//				[ 0.3 color rgb <0.945,0.829,0.752>*1 ]
				[ 0.0 color rgb <0.945,0.829,0.752>*.04 ] // test
				[ 0.3 color rgb <0.945,0.829,0.752>*.48 ]
			}
//			scale .3
			scale .5
		}
		normal { bumps .2 scale .3 }
		finish { ambient .24 specular .15 roughness .125 }
	}
#declare FileCabinetTex =
	texture {
		pigment { color rgb <0.627,0.567,0.527>*0.3 }
		normal { bumps 0.2 scale <8,8,14> }
		finish { ambient .10 specular .35 roughness .125 }
	}
#declare FileCabinetHandleTex =
	texture {
		pigment { color rgb <0.627,0.567,0.527>*0.48 }
		finish { ambient .10 specular .48 roughness .035 }
	}
#declare BlackPaintTex =
	texture {
		pigment { color rgb <0.017,0.017,0.030> }
		finish { ambient .10 specular .35 roughness .065 }
	}
#declare RadiatorTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.43 rgb <0.535,0.560,0.507>*0.74 ]
				[ 0.85 rgb <0.535,0.560,0.507>*0.04 ]
			}
			scale <1,1,20>
		}
		normal { bumps 0.2 scale 0.3 }
		finish { ambient .02 diffuse 0.6 specular .18 roughness .050 }
	}
#declare RadiatorValveTex =
	texture {
		pigment {color rgb <0.535,0.560,0.507>*0.84 }
		normal { bumps 0.12 scale 0.04 }
		finish { ambient .02 diffuse 0.6 specular .24 roughness .050 }
	}
#declare AshtrayBlueTex =
	texture {
		pigment { color rgb <0.317,0.417,0.930> }
		finish { ambient .10 specular .55 roughness .035 }
	}
#declare AshtrayGlassInt =
	interior { ior 1.45 }
#declare AshtrayGlassTex = // better version
	texture {
		pigment {
//			color rgbt <0.99,0.99,0.99,0.996> // clear glass
//			color rgbt <0.40,0.55,0.67,0.88> // clearish blue glass
			color rgbt <0.03,0.15,0.22,0.78> // blue glass
		}
		normal { bumps 0.015 scale 20 }
//		finish { ambient 0.1 specular 0.99 roughness 0.0015 } // for testing
		finish { ambient 0.1 specular 0.99 roughness 0.0015 reflection 0.17 }
	}
#declare AshtrayMat =
	material {
		texture { AshtrayGlassTex }
		interior { AshtrayGlassInt }
	}
#declare WhitePaperTex =
	texture {
		pigment { color rgb <1,1,1> }
	}

#declare BroomWoodTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.5 rgb<0.510,0.497,0.477>*0.8 ]
				[ 0.8 rgb<0.510,0.497,0.477>*0.45 ]
			}
			turbulence 0.5
			scale <.1,20,.1>
		}
		finish { ambient .10 specular .08 roughness .10 }
	}
#declare BroomFiberTex =
	texture {
		pigment {
			bozo
			color_map {

//				[ 0.5 rgb <0.427,0.347,0.157>*0.2 ]
//				[ 0.6 rgbt<0.427,0.347,0.157,1> ]

				[ 0.30 rgb <0.427,0.347,0.157>*1.3 ]
				[ 0.34 rgb <0.427,0.347,0.157>*0.2 ]
				[ 0.50 rgb <0.427,0.347,0.157>*0.2 ]
				[ 0.60 rgbt<0.427,0.347,0.157,1> ]

			}
			scale <.1,.1,4>
		}
		finish { ambient .10 specular .05 roughness .125 }
	}
#declare PipeTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.30 rgb<0.575,0.392,0.247>*0.70 ]
				[ 0.88 rgb<0.575,0.392,0.247>*0.08 ]
				[ 0.95 rgb<0.575,0.392,0.247>*0.02 ]
			}
			scale <2,2,26>
		}
		finish { metallic specular 0.92 roughness 0.035 }
	}

#declare CardboardTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.1 rgb<0.527,0.507,0.407>*0.68 ]
				[ 0.9 rgb<0.527,0.507,0.407>*1.18 ]
			}
			scale 16
		}
		normal { bumps 0.25 scale 16 translate 8 }
		finish { ambient .10 specular .02 roughness .18 }
	}
#declare PackingTapeTex =
	texture {
		pigment { color rgb<0.527,0.507,0.457>*1.3 }
		normal { bumps 0.05 scale 2.4 }
		finish { ambient .10 specular .82 roughness .018 }
	}


#declare GalvanizedBucketTex =
	texture {
		pigment {
				crackle solid
				scale 0.2
		}
		normal { bumps 0.3 scale 0.7 }
		finish { ambient 0.14 metallic specular 0.71 roughness 0.023 reflection 0.35 }
	}

#declare KBrownWoodTex =
	texture {
		pigment { color rgb <0.627,0.257,0.127> }
		finish { ambient .10 specular .15 roughness .10 }
	}
#declare KCounterTex =
	texture {
		pigment { color rgb <0.827,0.847,0.827> }
		finish { ambient .10 specular .45 roughness .05 }
	}
#declare KStainlessTex =
	texture {
		pigment { color rgb<0.964,0.964,0.988> }
		finish { ambient .10 specular .45 roughness .05 metallic brilliance 6 }
	}
#declare KChromeTex =
	texture {
		pigment { color rgb<.875,.858,.987>*.2 }
		finish { specular 0.99 roughness .005 reflection 0.48 metallic 0.3 brilliance 8 }
	}

#declare TestWhiteTex =
	texture {
		pigment { color rgb <1,1,1> }
	}

//===============================================
//             Macros
//===============================================

#macro CrumpledPaper(Num,TRS)
	union {
		#local TN=0;
		#while (TN<Num)
			triangle { <-0.5,0,0>,<0.5,0,0>,<0,0,1>
				scale <0.6+rand(TRS)*2.5,0.6+rand(TRS)*2.5,0.6+rand(TRS)*2.5>
				rotate <180*rand(TRS),180*rand(TRS),180*rand(TRS)>
				translate <0.6+rand(TRS)*0.5,0.6+rand(TRS)*0.5,0.6+rand(TRS)*0.5>
				rotate <180*rand(TRS),180*rand(TRS),180*rand(TRS)>
			}
			#local TN=TN+1;
		#end
		texture { WhitePaperTex }
	} // end union
#end

//--------------- Cardboard Box -----------------

#macro CardboardBox(L,W,H,FlapsOpen)
	union {
		box { <0,0,0>,<L,W,H> } // main
		box { <-0.05,-1,0>,<0.05,1,6> translate <0,W/2,0> texture { PackingTapeTex } }
		box { <-0.05,-1,0>,<0.05,1,6> translate <L,W/2,0> texture { PackingTapeTex } }
		box { <0.1,0,0>,<L-0.1,W/2-0.1,0.2> rotate x*FlapsOpen*0.80 translate <0,0,H> }
		box { <0.1,0,0>,<L-0.1,-W/2+0.1,0.2> rotate x*-FlapsOpen*1.15 translate <0,W,H> }
		texture { CardboardTex }
	} // end union
#end
#declare CardboardBoxStack =
	union {
		object { CardboardBox(28,18,14,0) }
		object { CardboardBox(20,14,12,35) rotate z*14 translate <4,3,14> }
	} // end union

//===============================================
//             Objects
//===============================================

//------------------ Chair --------------------

#declare FiveDollarChair =
	union {
		difference {
			box { // main
				<-11,0,0>,<11,21,25>
			}
			box { <-12,1.2,-1>,<12,21-1.2,26> }
			box { <-10,-1,-1>,<10,22,26> }

//			box { <-12,1.2,15>,<12,21-1.2,25-1.2> }
//			box { <-10,-1,15>,<10,22,26> }

			texture { TeakTex rotate y*3 }
		} // end difference
 			box { <-10.1,0.16,12>,<10.1,21,15> texture { TeakTex rotate y*85 } } // front face
			box { <-10.9,1.00,12>,<10.9,20,15> texture { TeakTex rotate x*85 }  }// side face
			box { <-11,0.1,23.8>,<-10,21,25> texture { TeakTex rotate x*93 } }
			box { < 11,0.1,23.8>,< 10,21,25> texture { TeakTex rotate x*88 } }
		union { // bottom cushion
			box { <-10,1,15>,<10,20,19> }
			cylinder { <-10,1,17>,<10,1,17>,2 }
			cylinder { <-10,20,17>,<10,20,17>,2 }
			texture { FiveDollarChairTex }
		} // end union
		union { // rear cushion
			box { <-10,-1.5,23>,<10,1.5,32> }
			cylinder { <-10,0,23>,<10,0,23>,1.5 }
			cylinder { <-10,0,32>,<10,0,32>,1.5 }
			rotate x*-8 translate <0,18,0>
			texture { FiveDollarChairTex }
		} // end union
	} // end union

//--------------- File Cabinet -----------------

#declare FileCabinetHandle =
	difference {
		box { <-2.0,-1.4,-0.18>,<2.0,0.0,0.18> }
		box { <-1.7,-1.3,-0.30>,<1.7,0.1,0.30> }
		texture { FileCabinetHandleTex }
	} // end difference
#declare FileTag =
	union {
		difference {
			box { <-1.80,-0.16,0.00>,<1.80,0.0,1.40> }
			box { <-1.65,-0.26,0.15>,<1.65,0.1,1.25> }
			texture { FileCabinetHandleTex }
		} // end difference
		box { // card
			<-1.7,-0.1,0.1>,<1.7,0,1.3>
			texture { pigment { color rgb<1,1,1>*0.78 }}
		}
	} // end union
#declare FileCabinet =
	union {
		box {
			<-7.5,0,0>,<7.5,25,54>
			texture { FileCabinetTex }
		}
		object { FileCabinetHandle translate <0,0,12*1-4> }
		object { FileCabinetHandle translate <0,0,12*2-4> }
		object { FileCabinetHandle translate <0,0,12*3-4> }
		object { FileCabinetHandle translate <0,0,12*4-4> }
		object { FileTag translate <0,0,12*1-1> }
		object { FileTag translate <0,0,12*2-1> }
		object { FileTag translate <0,0,12*3-1> }
		object { FileTag translate <0,0,12*4-1> }
	} // end union

//--------------- Studio Light -----------------

#declare StudioLight =
	union {
		cylinder {
			<0,0,0>,<0,0,10>,3
			texture { BlackPaintTex }
		}
		sphere {
			<0,0,0>,2.4
			scale <1,1,.2>
			texture {
				pigment { color rgb 1 }
				finish {ambient 20}
			}
		}
	} // end union


//------------------ Radiator --------------------

#declare RadiatorValve =
	union {
		cylinder { <-1,0,0>,<0,0,0>,1.37 }
		cylinder { <0,0,0>,<0.6,0,0>,1.02 }
		cylinder { <0,0,0>,<3.5,0,0>,0.55 } // shaft
		cylinder { <1.5,0,0>,<2.25,0,0>,0.8 } // nut
		sphere { <3.0,0,0>,1.15 }
		cylinder { <3.0,0,-1.7>,<3.0,0,1.7>,0.56 }
		cylinder { <3.0,0,-1.7>,<3.0,0,-2.2>,0.80 }		
		cylinder { <3.0,0, 1.7>,<3.0,0, 2.2>,0.80 }		
		sphere { <0,0,0>,0.85 scale <.6,.6,1> translate <3.0,0,2.0> }
		cylinder { <3.0,0,0>,<3.0,0,3.2>,0.22 }
		superellipsoid { <0.4,0.4> scale <0.2/2,3.5/2,0.6/2> translate <0,-1.6,0> rotate <-12,0,40> translate <3.0,0,2.5> }
		texture { RadiatorValveTex }
	} // end union

#declare RadiatorHF =
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Radiator_HFMap.png"
			water_level 1/255
			smooth
			scale <5*Feet,-6,5*Feet/1.5>
			texture { RadiatorTex } // test
/*
			texture { // grime
				pigment {
					image_map { // mapped onto x-y plane, upper left at <0,0,0>
						png "Brick_6x8_ColorMap.png"
					}
					rotate x*90
					scale <6*Feet,1,8*Feet>
				}
				finish { BrickFinish }
			}
*/
		}
#declare RadLeg =
	sphere_sweep {
		cubic_spline
		6
		< 0.3,0,-0.3>,0.8
		< 0.0,0,0.8>,0.8
		<-1.0,0,2.2>,0.5
		<-2.0,0,2.8>,0.7
		<-5.0,0,4.5>,1.0
		<-7.6,0,6.0>,1.0
		texture { RadiatorTex }
	}
#declare Radiator =
	union {
		object { RadiatorHF translate <0,0,5> }
		object { RadiatorHF scale <1,-1,1> translate <0,0,5> }
		object { RadLeg rotate z*-90 translate <3,-6,0> }
		object { RadLeg rotate z*-90 translate <3,-6,0> scale <1,-1,1> }
		object { RadLeg rotate z*-90 translate <58,-6,0> }
		object { RadLeg rotate z*-90 translate <58,-6,0> scale <1,-1,1> }
		object { RadiatorValve translate <60,0,38> }
	} // end union


//------------------ Ashtray --------------------

#declare CigaretteSmoke =
	box {
		<0,0,0>,<1,1,1>
			texture {
				pigment {
					image_map { // mapped onto x-y plane, upper left at <0,1,0>, upper right at <1,1,0>
						png "CigaretteSmoke_ColorMap.png"
					}
					rotate x*90 //<0,90,-90> translate <0,0,1>
				}
			#if (Radios)
				finish { ambient 6 diffuse 0 }
			#else
				finish { ambient 0.5 diffuse 0.6 }
			#end
			}
		scale <7,0.01,9>
		translate <-3.0,0,0>
	}
#declare BurningAsh =
	cone { // ash
		<0,0,0>,0.10,<0.23,0,0>0.13
		texture {
			pigment {
				granite
				color_map {
					[ 0.2 rgb<1,1,1>*0.30 ]
					[ 0.8 rgb<1,1,1>*0.90 ]
				}
				scale <.22,0.22,0.22>
			}
		}
	}
#declare CigaretteFilter =
	union {
		cylinder { // filter cover
			<0,0,0>,<0.8,0,0>,0.14
			texture {
				pigment {
					bozo
					color_map {
						[ 0.28 rgb<.95,.85,.64>*0.93 ] // spots
						[ 0.36 rgb<.95,.61,.32> ] // orange
					}
					scale .032
				}
			}
		}
		cylinder { // filter
			<0,0,0>,<0.81,0,0>,0.132
			texture {
				pigment {
					bozo
					color_map {
						[ 0.52 rgb<.95,.81,.74>*0.96 ]
						[ 0.80 rgb<.95,.92,.64>*0.53 ]
					}
					scale .015
				}
			}
		}
	} // end union
#macro BurningCigarette(WhiteLength)
	union {
		object { BurningAsh }
		cylinder { // main
			<0.23,0,0>,<WhiteLength,0,0>,0.14
			texture {
				pigment {
					bozo
					color_map {
						[ 0.6 rgb<1,1,1> ]
						[ 0.7 rgb<1,1,1>*0.90 ]
					}
					scale <.12,0.6,0.6>
				}
			}
			texture { // burning
				pigment {
					gradient x
					color_map {
						[ 0.00 rgbt<.1,.1,.1,.1> ]
						[ 0.04 rgbt<.8,.5,.5,.1> ]
						[ 0.05 rgbt<.1,.1,.1,0> ]
						[ 0.12 rgbt<1,1,1,1> ]
					}
				scale <3,1,1>
					warp { turbulence 0.2 octaves 6 lambda 2.5 omega 0.6 }
				}

			}
		}
		object { CigaretteFilter translate <WhiteLength,0,0> }
	} // end union
#end

#declare BurntOutCigarette =
	union {
		object { BurningAsh }
		cylinder { <0.23,0,0>,<0.42,0,0>,0.14 texture { WhitePaperTex } }
		object { CigaretteFilter translate <0.42,0,0> }
		rotate x*120
	} // end union
#declare StubbedCigarette = // center at beginning of filter
	union {
		object { CigaretteFilter }
		cylinder { <-0.20,0,0>,<0.05,0,0>,0.14 rotate z*-30 translate <0.10,-0.02,0> texture { WhitePaperTex } }
		cylinder { <-0.14,0,0>,<0.05,0,0>,0.14 rotate z*-60 translate <-0.08,0.08,0> texture { WhitePaperTex } }
		object { BurningAsh rotate z*-80 translate <-0.17,0.36,0> }
	} // end union

#declare Ashtray =
	difference {
//union {
		superellipsoid { <0.43,0.43> scale <4/2,4/2,1/2> translate <0,0,0.5> }
		superellipsoid { <0.43,0.43> scale <3.4/2,3.4/2,1.2/2> translate <0,0,0.5+0.5> } // inner
		superellipsoid { <0.43,0.43> scale <3.9/2,3.9/2,1/2> translate <0,0,1.3> } // bevel
		superellipsoid { <1.0,0.1> scale <3.4/2,3.4/2,.4/2> translate <0,0,0.2> } // base
		cylinder { <-0.6,0,0>,<1,0,0>,0.4 rotate y*-12 translate <0,0,1.1> rotate z*(45+90*0) }
		cylinder { <-0.6,0,0>,<1,0,0>,0.4 rotate y*-12 translate <2,0,1.1> rotate z*(45+90*1) }
		cylinder { <-0.6,0,0>,<1,0,0>,0.4 rotate y*-12 translate <2,0,1.1> rotate z*(45+90*2) }
		cylinder { <-0.6,0,0>,<1,0,0>,0.4 rotate y*-12 translate <2,0,1.1> rotate z*(45+90*3) }

		material { AshtrayMat }
	} // end difference


#declare AshtrayGroup =
	union {
		object { Ashtray }
		object { BurningCigarette(1.3) rotate <0,-16,45> translate <0.3,0.3,0.5> }
		object { CigaretteSmoke rotate z*30 translate <0.3,0.3,0.55> }
		object { StubbedCigarette rotate z*-100 translate <-0.6,-0.2,0.5> }
//		object { BurntOutCigarette rotate z*20 translate <-0.2,-0.6,0.5> }
		object { BurntOutCigarette rotate <0,-120,20> translate <-0.2,-0.6,0.5> }
	} // end union

//------------------ PushBroom --------------------

#declare PushBroomEndFibers=
	union {
		box { <-0.05,0,-2.6>,<0.18,0.05,0> texture { BroomFiberTex scale 0.5 } rotate <41,0,0> translate <-0.1,-0.3,3> }
		box { <-0.05,0,-2.6>,<0.18,0.05,0> texture { BroomFiberTex scale 0.5 translate 1 } rotate <48,0,-20> translate <-0.1,-0.3,3.3> }
		cone { <0,0,1>,0.8,<0,0,3>,0.42 texture { BroomFiberTex scale 2 rotate <0,0,-40> }}
		cone { <0,0,0>,0.7,<0,0,1.53>,0.42 texture { BroomFiberTex scale 2 rotate <12,8,70> }}
	} // end union
#declare PushBroom = // handle leans towards +x in xz plane, broom width in y
	union {
		difference {
			cylinder { <0,-9,0>,<0,9,0>,1.6 scale <1,1,0.5> translate <0,0,3.4> }
			cylinder { <0,0,0>,<0,0,3>,0.54 rotate y*-30 translate <-0.8,0,3.4> }
		} // end difference
		sphere { <0,0,0>,1.6 scale <1,0.3,0.5> translate <0,-9,3.4> }
		sphere { <0,0,0>,1.6 scale <1,0.3,0.5> translate <0, 9,3.4> }
		cylinder { <0,0,-0.6>,<0,0,0> 1.6 scale <1,0.3,1> translate <0,-9,3.4> }
		cylinder { <0,0,-0.6>,<0,0,0> 1.6 scale <1,0.3,1> translate <0, 9,3.4> }
		box { <-1.6,-9,-0.6>,<1.6,9,0> translate <0,0,3.4> }
		cylinder { <0,0,0>,<0,0,50>,0.48 texture { BroomWoodTex rotate x*90 } rotate y*30 translate <1,0,3.4> } // handle
		sphere { <0,0,0>,0.48 translate <0,0,50> rotate y*30 translate <1,0,3.4> } // handle tip
		superellipsoid { <0.4,0.0> scale <3.0/2,18/2,2.8/2> translate <0,0,1.5> texture { BroomFiberTex } }
		object { PushBroomEndFibers translate <-0.8, 8.5,0> }
		object { PushBroomEndFibers translate < 0.8, 8.5,0> }
		object { PushBroomEndFibers translate <-0.8,-8.5,0> }
		object { PushBroomEndFibers translate < 0.8,-8.5,0> }
		texture { BroomWoodTex }			
	} // end union

//------------------ Pipes --------------------

#macro PipeSection(Dia,Length)
//	union {
		cylinder {
			<0,0,0>,<Length,0,0>,Dia/2
		}
//	} // end union
#end
#macro FlangedElbow(Dia) // starts into +x, bending into +z
// Dia = main diameter of pipe
	union {
		difference {
			torus {
				1.5*Dia, Dia/2
			}
			box { <-3*Dia,-Dia,0>,<3*Dia,Dia,3*Dia> }
			box { <-3*Dia,-Dia,-3*Dia>,<0,Dia,3*Dia> }
			translate <0,0,1.5*Dia> // set end at x=0
		} // end difference
		cylinder { <Dia/28,0,0>,<Dia/4,0,0>,0.8*Dia }
		cylinder { <-Dia/4,0,0>,<-Dia/28,0,0>,0.8*Dia }
		cylinder { <Dia/28,0,0>,<Dia/4,0,0>,0.8*Dia rotate y*90 translate <1.5*Dia,0,1.5*Dia> }
		cylinder { <-Dia/4,0,0>,<-Dia/28,0,0>,0.8*Dia rotate y*90 translate <1.5*Dia,0,1.5*Dia> }
		#declare BoltPos = 0;
		#while ( BoltPos < 360 )
			cylinder {
				<-Dia/4-Dia/6,0,0>,<Dia/4+Dia/6,0,0>,Dia/10
				translate <0,0,0.65*Dia>
				rotate x*BoltPos
			}
			#declare BoltPos = BoltPos + 24;
		#end
		#declare BoltPos = 0;
		#while ( BoltPos < 360 )
			cylinder {
				<-Dia/4-Dia/6,0,0>,<Dia/4+Dia/6,0,0>,Dia/10
				translate <0,0,0.65*Dia>
				rotate x*BoltPos
				rotate y*90 translate <1.5*Dia,0,1.5*Dia>
			}
			#declare BoltPos = BoltPos + 24;
		#end
	} // end union
#end

#declare PipeGroup =
	union {
		object { PipeSection(6,13*Feet) rotate y*-90 }
		object { FlangedElbow(6) rotate <0,-90,90> translate <0,0,13*Feet> }
		object { PipeSection(6,20*Feet) rotate z*-90 translate <0,-9,13*Feet+9> }
		texture { PipeTex }
	} // end union
	

//------------------ Bucket --------------------

#declare Bucket =
	union {
		difference {
			cone { // main
				<0,0,0.6>,6,<0,0,14>,8.2
			}
			cone { // inner
				<0,0,0.8>,5.75,<0,0,15>,8.1
			}
		} // end difference
		cylinder { // base
			<0,0,0>,<0,0,1>,5.78
		}
		cylinder { // handle mount
			<-8.5,0,0>,<-8.2,0,0>,0.55
			translate <0,0,14-0.6>
		}
		cylinder { // handle mount
			<8.5,0,0>,<8.2,0,0>,0.55
			translate <0,0,14-0.6>
		}
		torus { // rim
			8.35,0.18
			rotate x*90
			translate <0,0,14>
		}
		torus {
			7.45,0.14
			rotate x*90
			scale <1,1,1.4>
			translate <0,0,9>
		}
		torus {
			7.22,0.14
			rotate x*90
			scale <1,1,1.4>
			translate <0,0,7.5>
		}
		scale <0.75,0.75,0.75> // downsize it a little
		texture { GalvanizedBucketTex }
	} // end union


//------------------ Kitchenette --------------------

#declare KHandleV = cylinder { <0,-1.3,0>,<0,-1.3,7>,0.35 texture { KChromeTex } }
#declare KHandleH = cylinder { <-4,-1.3,0>,<4,-1.3,0>,0.35 texture { KChromeTex } }
#declare KLowerCabinets =
	union {
		box { <0,0,5>,<8*Feet,24,35> } // cabinets
		box { <0,4,0>,<8*Feet,24,5> } // kickplate
		box { <0,-1.0,35>,<8*Feet,24,36.6> texture { KCounterTex } } // countertop
		cylinder { <0,-1.0,35.8>,<8*Feet,-1.0,35.8>,0.8 texture { KCounterTex } } // countertop
		box { <0,23,0>,<8*Feet,24,41> texture { KCounterTex } } // backsplash
		box { <0,23.5,0>,<8*Feet,24,61> texture { KCounterTex } } // backwall
		object { KHandleH translate <12,0,14> }
		object { KHandleH translate <12,0,14+8> }
		object { KHandleH translate <12,0,14+8*2> }
		object { KHandleH translate <38,0,14> }
		object { KHandleH translate <38,0,14+8> }
		object { KHandleH translate <38,0,14+8*2> }
		object { KHandleV translate <58,0,20> }
		object { KHandleV translate <63,0,20> }
		object { KHandleH translate <85,0,14> }
		object { KHandleH translate <85,0,14+8> }
		object { KHandleH translate <85,0,14+8*2> }
		cylinder { <0,0,0>,<0,0,8>,4 texture { KStainlessTex } translate <82,16,36> }
		cylinder { <0,0,0>,<0,0,8>,2 texture { KStainlessTex } translate <74,14,36> }
		superellipsoid { <0.2,0.2> scale <12/2,6/2,8/2> texture { KStainlessTex } rotate z*12 translate <18,14,36+4> }

	box { // fake floor
		<-4*Feet,-10*Feet,-1>,<10*Feet,36,0.5>
		texture {
			pigment {
				wood // z-axis
				color_map {
					[ 0.00 color rgb <0.560, 0.352, 0.225>*0.45 ]
					[ 0.40 color rgb <0.780, 0.635, 0.350>*0.45 ]
					[ 0.60 color rgb <0.790, 0.605, 0.404>*0.45 ]
					[ 1.00 color rgb <0.560, 0.352, 0.225>*0.45 ]
				}
				rotate <0,88,-91>
				translate <0,2,1>
				turbulence 0.025
				omega 0.45
				lambda 2.3
				warp {
					black_hole <8,2,0>, 6 strength 1 inverse
					repeat <31,0,0> turbulence <6,3,0>
				}
			}
		}
	}
		texture { KBrownWoodTex }
	} // end union
#declare KUpperCabinets =
	union {
		box { <0,0,0>,<8*Feet,15,36> }
		object { KHandleV translate <18,0,3> }
		object { KHandleV translate <22,0,3> }
		object { KHandleV translate <40,0,3> }
		object { KHandleV translate <44,0,3> }
		object { KHandleV translate <60,0,3> }
		object { KHandleV translate <64,0,3> }
		object { KHandleV translate <80,0,3> }
		object { KHandleV translate <84,0,3> }
		texture { KBrownWoodTex }
	} // end union
#declare KRefrigerator =
	union {
		difference {
			superellipsoid {
				<0.14,0.14>
				scale <40/2,24/2,72/2>
				translate <0,24/2,72/2>
			}
			box { <-0.35,-1,0>,<0.35,2,8*Feet> }
			box { <0,-1,0>,<10,5,10> translate <-14,0,38> texture { KCounterTex } }
			texture { KStainlessTex }
		} // end difference
		cylinder { <0,0,0>,<0,0,24>0.5 translate < 2,-2,30> texture { KChromeTex } }
		cylinder { <0,0,0>,<0,0,24>0.5 translate <-2,-2,30> texture { KChromeTex } }
	} // end union
#declare Kitchenette =
	union {
		object { KLowerCabinets }
		object { KUpperCabinets translate <0,10,55> }
		object { KRefrigerator translate <-22,0,0> }
	} // end union


//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 30
		location  <6, -14*Feet, 5.0*Feet> // overall
		look_at <0*Feet,0*Feet,2.3*Feet>
//		location  <3*Feet, -1*Feet, 35*Feet> // top down
//		look_at <3*Feet,3*Feet,3*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 1*Feet }
//cylinder { <0,0,0>,<0,0,24>12 texture { pigment { rgb<1,1,1>*.06 } finish { reflection 0.24 } } } // table

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

//object { FiveDollarChair rotate z*0 translate <-3*Feet,4*Feet,0> }
object { FiveDollarChair rotate z*60 translate <-3*Feet,7*Feet,0> }
object { FileCabinet rotate z*-20 translate <30,40,0> }
object { Radiator rotate z*-10 translate <-50,120,0> }
//object { Radiator rotate z*-120 translate <20,50,0> }
object { AshtrayGroup scale 3 rotate z* -30 translate <0,0,24> }
/*
object { BurningCigarette scale 4 translate <-8,-4,30> }
object { BurningCigarette scale 4 rotate z*75 translate <6,4,26> } // right
object { BurningCigarette scale 4 rotate z*-90 translate <-9,4,28> } // left
*/
/*
object { BurntOutCigarette scale 4 translate <-8,-4,30> }
object { BurntOutCigarette scale 4 rotate z*75 translate <6,4,26> } // right
object { BurntOutCigarette scale 4 rotate z*-90 translate <-9,4,28> } // left
*/
//object { StubbedCigarette scale 4 rotate x*90 translate <-8,-4,32> }
//object { StubbedCigarette scale 8 rotate z*-180 translate <6,4,26> } // right
//object { StubbedCigarette scale 80 rotate z*-180 translate <6,20*Feet,0> } // right
//object { StubbedCigarette scale 4 rotate z*-90 translate <-9,4,28> } // left

object { CrumpledPaper(20,seed(20399)) translate <-16,0,2> }
//object { CrumpledPaper(40,seed(77394)) translate <-6,-2,26> }

//object { PushBroom }
//object { Bucket translate <12,-12,0> }
//object { PushBroom scale 3 rotate z*140 translate <-2*Feet,3*Feet,0> }
object { PushBroom scale 1 rotate z*180 translate <-2*Feet,0.3*Feet,0> }
//object { PipeGroup translate <0,0,-9*Feet> translate <-3*Feet,8*Feet,0> }
//object { CardboardBox(28,18,14,20) rotate z*40 translate <-2*Feet,1*Feet,0> }
//object { CardboardBox(20,14,12,0) rotate z*-20 translate < 2*Feet,2*Feet,0> }
//object { CardboardBoxStack rotate z*0 translate < 2*Feet,5*Feet,0> }
object { CardboardBoxStack rotate z*80 translate <6*Feet,10*Feet,0> }
//object { Kitchenette rotate z*24 translate <-4*Feet,20*Feet,0> }
#end

