
// Glenn's Transformations POV-Ray Include File
// This file does not render.  #include "GTransforms.inc" in another .pov file
// created 12-Jun-97  last update 16-Apr-06
// copyright 1997-2002 Glenn McCarter (glenn@mccarters.net)

// Creates useful transformation matrices

#declare RandRotSeed = seed(68372);
#macro RandRot()
	rotate <rand(RandRotSeed)*360,rand(RandRotSeed)*360,rand(RandRotSeed)*360>
#end


//===============================================
//             Inverses (Mirror Images)
//===============================================

#declare InverseX =
	transform {
  	matrix < -1, 0, 0,
             0, 1, 0,
             0, 0, 1,
             0, 0, 0 >
	}

#declare InverseY =
	transform {
  	matrix < 1, 0, 0,
             0, -1, 0,
             0, 0, 1,
             0, 0, 0 >
	}

#declare InverseZ =
	transform {
  	matrix < 1, 0, 0,
             0, 1, 0,
             0, 0, -1,
             0, 0, 0 >
	}

//===============================================
//             Shears
//===============================================

#declare ShearXZn05 = // shear 50% along x-axis; areas high in z get sheared more towards -x
	transform {
  	matrix < 1, 0, 0,
             0, 1, 0,
           -.5, 0, 1,
             0, 0, 0 >
	}

#declare ShearYZn05 = // shear 50% along y-axis; areas high in z get sheared more towards -y
	transform {
  	matrix < 1, 0, 0,
             0, 1, 0,
             0,-0.5, 1,
             0, 0, 0 >
	}

#macro ZShear(Dir,Percent) // usage: ZShear(y,-0.35) = high z gets sheared towards -y
	#if (Dir.y=1)
	transform {
  	matrix < 1, 0, 0,
             0, 1, 0,
             0,Percent, 1,
             0, 0, 0 >
	}
	#end
	#if (Dir.x=1)
	transform {
  	matrix < 1, 0, 0,
             0, 1, 0,
           Percent, 0, 1,
             0, 0, 0 >
	}
	#end

#end