
// POV-Ray Object File - Studio
// created 19-Mar-06
// last update 27-Apr-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Studio
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================

#if (RenderMe = 1)
	#local Radios=0;
#end

//===============================================
//             Textures
//===============================================

#declare StudioEastWallTex =
	texture {
		pigment { color rgb<.967,.977,.996>*0.96 }
		normal { bumps 0.2 scale 1.3 }
		finish { specular 0.13 roughness 0.04 diffuse 0.6 ambient 0.1 }
	}
#declare StudioSouthWallTex =
	texture {
		pigment { color rgb<.967,.977,.996>*0.16 }
		normal { bumps 0.2 scale 1.3 }
		finish { specular 0.13 roughness 0.04 diffuse 0.6 ambient 0.1 }
	}
#declare StudioWestWallTex =
	texture {
		pigment { color rgb<.967,.977,.996>*0.96 }
		normal { bumps 0.2 scale 1.3 }
		finish { specular 0.13 roughness 0.04 diffuse 0.6 ambient 0.1 }
	}
#declare StudioFloorTex =
	texture {
		pigment { color rgb<.967,.877,.396>*0.85 }
		normal { bumps 0.2 scale 1.3 }
		finish { specular 0.13 roughness 0.04 diffuse 0.6 ambient 0.1 }
	}

#declare WindowFrameTex =
	texture {
		pigment { color rgb<.987,.970,.956>*0.135 }
		normal { bumps 0.2 scale 4 }
		finish { ambient 0.1 diffuse 0.6 specular 0.43 roughness 0.062 }
	} 
#declare BlackGlassTex =
	texture {
		pigment { color rgb<.967,.977,.996>*0.05 }
		finish { specular 0.93 roughness 0.002 diffuse 0.6 ambient 0.1 reflection 0.12 }
	}
#declare WindowGlassInt =
	interior { ior 1.45 }
#declare WindowGlassTex = // better version
	texture {
		pigment {
			color rgbt <0.99,0.99,0.99,0.996>
		}
		normal { bumps 0.015 scale 20 }
//		finish { ambient 0.1 specular 0.99 roughness 0.0015 } // for testing
		finish { ambient 0.1 specular 0.99 roughness 0.0015 reflection 0.17 }
	}
#declare WindowGlassMat =
	material {
		texture { WindowGlassTex }
		interior { WindowGlassInt }
	}

#declare TestWhiteTex =
	texture {
		pigment { color rgb<1,1,1> }
	}
#declare BrickFinish =
//	finish { ambient 0.0 diffuse 0.5 specular 0.34 roughness 0.23 }
		#if (Radios)
//			finish { ambient 0 diffuse 10 specular 0.34 roughness 0.23 } // too colorful
			finish { ambient 0 diffuse 3 specular 0.34 roughness 0.23 } // test
//			finish { ambient 0 diffuse 1 specular 0.34 roughness 0.23 }
		#else
			finish { ambient 0.3 diffuse 0.4 specular 0.34 roughness 0.23 }
		#end

#declare BeamTex =
	texture {
		pigment {
			color rgb<.30,.20,.03>
		}
//		finish { ambient 0.1 diffuse 0.6 specular 0.24 roughness 0.20 }
		finish { ambient 0.0 diffuse 0.6 specular 0.24 roughness 0.20 }
	}

//===============================================
//             Macros
//===============================================

// FloorBoards macro creates a wood plank flooring
// rectangular shape, extending into +X,+Y with top surface at Z=0
// Each plank is individually textured

#macro PlankWoodTex(RandomSeed)
	#local ZS = seed(RandomSeed);
//	#local Darkness = 0.7+rand(ZS)*0.3;
	#local Darkness = 0.25+rand(ZS)*0.15;
		pigment {
			wood // z-axis
			color_map {
/* // too highly saturated
				[ 0.00 color rgb <0.760, 0.352, 0.125>*Darkness ]
				[ 0.40 color rgb <1.000, 0.675, 0.250>*Darkness ]
				[ 0.60 color rgb <1.000, 0.645, 0.304>*Darkness ]
				[ 1.00 color rgb <0.740, 0.352, 0.125>*Darkness ]
*/

				[ 0.00 color rgb <0.560, 0.352, 0.225>*Darkness ]
				[ 0.40 color rgb <0.780, 0.635, 0.350>*Darkness ]
				[ 0.60 color rgb <0.790, 0.605, 0.404>*Darkness ]
				[ 1.00 color rgb <0.560, 0.352, 0.225>*Darkness ]

			}
//			scale <1,1,1>
			rotate <0,87+rand(ZS)*6,-3+rand(ZS)*6>
			translate <0,-6+rand(ZS)*12,-6+rand(ZS)*12>
			turbulence 0.025
			omega 0.45
			lambda 2.3
			warp {
				black_hole <8,2,0>, 6 strength 1 inverse
				repeat <31,0,0> turbulence <6,3,0>
			}
		}
#end

#macro FloorPlank(Length,Width,Height,RandomSeed)
	box {
		<0,0,-Height>,<Length,Width,0>
//		texture { TestWhiteTex }
		texture { PlankWoodTex(RandomSeed) }
	}
#end

#macro FloorBoards(Length,Width,BoardWidth,RandomSeed) // top of floor at z=0
	union {
		#local RS = seed(RandomSeed);
		#local WC = 0; // WidthCount
		#while (WC < Width)
			#local FBL = 12+rand(RS)*5*Feet; // first board length
			#local TLB = 0; // this long board
			object { // first board in this row
				FloorPlank(FBL-0.15,BoardWidth-0.15,1.0,rand(RS)*9999)
				translate <0,WC,-0.2+rand(RS)*0.4>
				}
			#while (FBL+TLB < Length)
				object { // all the rest in this row
					#if (FBL+TLB+6*Feet > Length)
						FloorPlank(Length-FBL-TLB-0.15,BoardWidth-0.15,1.0,rand(RS)*9999)
					#else
						FloorPlank(6*Feet-0.15,BoardWidth-0.15+rand(RS)*0.30,1.0,rand(RS)*9999)
					#end
					translate <FBL+TLB,WC,-0.12+rand(RS)*0.24>
				}
				#local TLB = TLB + 6*Feet; // 6-feet main plank length
			#end
			#local WC = WC + BoardWidth; // Row spacing
		#end
	} // end union
#end

#macro WindowOuterFrame(Length,Height)
	#local SW = 6; // Sill Width
	union {
		box { <0,-SW/2-1.5,0>,<Length,SW/2,1> } // sill
		box { <0,-SW/2,Height-1>,<Length,SW/2,Height> } // top
		box { <0,-SW/2,0>,<1,SW/2,Height> } // left
		box { <-0.85,-SW/3,0>,<0.85,SW/3,Height> translate <Length/2,0,0> } // center
		box { <Length-1,-SW/2,0>,<Length,SW/2,Height> } // right
		texture { WindowFrameTex }
	} // end union
#end

#macro TiledWindow(Xlength,Zheight,Xpanes,Zpanes,BarThickness,Quality)
// Window is in XZ plane, with glass centered on Y=0
	#local BT = BarThickness;
	#local RS = seed(20395);
#switch ( Quality )
#case ( false ) // use low quality: single pane of glass
	union {
		difference {
			box { // outer frame
				<0,-BT/2,0>,<Xlength,BT/2,Zheight>
			}
			box { // cutout
				<BT/2,-2,BT/2>,<Xlength-BT/2,2,Zheight-BT/2>
			}
		} // end difference

		#local VB = 1;
		#while ( VB < Xpanes ) // vertical bars
			box { <-BT/2,-BT/2,0>,<BT/2,BT/2,Zheight>
				translate <VB*Xlength/Xpanes,0,0>
			}
			#local VB = VB + 1;
		#end

		#local HB = 1;
		#while ( HB < Zpanes ) // horozontal bars
			box { <0,-BT/2,-BT/2>,<Xlength,BT/2,BT/2>
				translate <0,0,HB*Zheight/Zpanes>
			}
			#local HB = HB + 1;
		#end
		box { // glass
			<0,-0.065,0>,<Xlength,0.065,Zheight>
			material { WindowGlassMat }
		}
		texture { WindowFrameTex }
	} // end union
#break
#else // use individual panes of glass, good quality
	union {
		difference {
			box { // outer frame
				<0,-BT/2,0>,<Xlength,BT/2,Zheight>
			}
			box { // cutout
				<BT/2,-2,BT/2>,<Xlength-BT/2,2,Zheight-BT/2>
			}
		} // end difference

		#local VB = 1;
		#while ( VB < Xpanes ) // vertical bars
			box { <-BT/2,-BT/2,0>,<BT/2,BT/2,Zheight>
				translate <VB*Xlength/Xpanes,0,0>
			}
			#local VB = VB + 1;
		#end
		#local HB = 1;
		#while ( HB < Zpanes ) // horozontal bars
			box { <0,-BT/2,-BT/2>,<Xlength,BT/2,BT/2>
				translate <0,0,HB*Zheight/Zpanes>
			}
			#local HB = HB + 1;
		#end
		#local Hglass = 0;
		#while ( Hglass < Xpanes )
			#local Vglass = 0;
			#while ( Vglass < Zpanes )
				box {
					<0,-0.065,0>,<Xlength/Xpanes,0.065,Zheight/Zpanes>
					material { WindowGlassMat translate <rand(RS)*30*Feet,0,rand(RS)*30*Feet> }
					translate <Hglass*Xlength/Xpanes,0,Vglass*Zheight/Zpanes>
				}
				#local Vglass = Vglass + 1;
			#end
			#local Hglass = Hglass + 1;
		#end
		texture { WindowFrameTex }
	} // end union
#end // switch
#end // macro

#declare Window55 =
	union {
		object { WindowOuterFrame(5*Feet,5*Feet) }

	} // end union

//===============================================
//             Studio
//===============================================

#declare NorthWallS =
	box {
		<0,0,0>,<40*Feet,8,20*Feet>
		texture { StudioSouthWallTex }
	}


#declare BrickWallOne =
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Brick01_HFMapTEST.png"
			smooth
			scale <8*Feet,-2,8*Feet/1.33333>
			//texture { StudioWallTex } // test
			texture {
				pigment {
					image_map { // mapped onto x-y plane, upper left at <0,0,0>
						png "Brick01_ColorMapTEST.png"
					}
					rotate x*90
					scale <8*Feet,1,8*Feet/1.33333>
				}
				finish { BrickFinish }
			}
		}
#declare LeftCornerWallOne =
	intersection {
		object { BrickWallOne }
		object { BrickWallOne
			translate <-8*Feet,0,0>
			rotate z*-90
			translate <3,-3,0>
		}
	}
#declare BrickWall_1x8 =
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Brick_1x8_HFMap.png"
			smooth
			scale <1.5*Feet,-2,8*Feet>
			//texture { StudioWallTex } // test
			texture {
				pigment {
					image_map { // mapped onto x-y plane, upper left at <0,0,0>
						png "Brick_1x8_ColorMap.png"
					}
					rotate x*90
					scale <1.5*Feet,1,8*Feet>
				}
				finish { BrickFinish }
			}
		}
#declare BrickWall_2x8 =
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Brick_2x8_HFMap.png"
			smooth
			scale <2*Feet,-2,8*Feet>
			//texture { StudioWallTex } // test
			texture {
				pigment {
					image_map { // mapped onto x-y plane, upper left at <0,0,0>
						png "Brick_2x8_ColorMap.png"
					}
					rotate x*90
					scale <2*Feet,1,8*Feet>
				}
				finish { BrickFinish }
			}
		}
#declare BrickWall_6x8 =
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Brick_6x8_HFMap.png"
			smooth
			scale <6*Feet,-2,8*Feet>
			//texture { StudioWallTex } // test
			texture {
				pigment {
					image_map { // mapped onto x-y plane, upper left at <0,0,0>
						png "Brick_6x8_ColorMap.png"
					}
					rotate x*90
					scale <6*Feet,1,8*Feet>
				}
				finish { BrickFinish }
			}
		}
#declare BrickWall_12x8 =
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Brick_12x8_HFMap.png"
			smooth
			scale <12*Feet,-2,8*Feet>
			//texture { StudioWallTex } // test
			texture {
				pigment {
					image_map { // mapped onto x-y plane, upper left at <0,0,0>
						png "Brick_12x8_ColorMap.png"
					}
					rotate x*90
					scale <12*Feet,1,8*Feet>
				}
				finish { BrickFinish }
			}
		}
#declare LeftCorner_1x2 =
	intersection {
		object { BrickWall_2x8 }
		object { BrickWall_1x8
			translate <-1.5*Feet,0,0>
			rotate z*-90
			translate <3,-3,0>
		}
	}
#declare LeftCorner_1x6 =
	intersection {
		object { BrickWall_6x8 }
		object { BrickWall_1x8
			translate <-1.5*Feet,0,0>
			rotate z*-90
			translate <3,-3,0>
		}
	}

#declare NorthWall =
	union {
/*
		box { // filler glass
			<0,4,0>,<40*Feet,8,20*Feet>
			texture { BlackGlassTex }
		}
*/
		object { BrickWall_6x8 }
		object { BrickWall_6x8 translate <0,0,8*Feet> }

		object { BrickWall_6x8 translate <6*Feet,4,-5*Feet> }
		object { BrickWall_6x8 translate <6*Feet,4,8*Feet> }
		object { LeftCorner_1x2 translate <11*Feet,0,0> }
		object { LeftCorner_1x2 translate <11*Feet,0,8*Feet> }

		object { BrickWall_6x8 translate <13*Feet,4,-5*Feet> }
		object { BrickWall_6x8 translate <13*Feet,4,8*Feet> }
		object { LeftCorner_1x2 translate <18*Feet,0,0> }
		object { LeftCorner_1x2 translate <18*Feet,0,8*Feet> }

		object { BrickWall_6x8 translate <20*Feet,4,-5*Feet> }
		object { BrickWall_6x8 translate <20*Feet,4,8*Feet> }
		object { LeftCorner_1x2 translate <25*Feet,0,0> }
		object { LeftCorner_1x2 translate <25*Feet,0,8*Feet> }

		object { BrickWall_6x8 translate <27*Feet,4,-5*Feet> }
		object { BrickWall_6x8 translate <27*Feet,4,8*Feet> }
		object { LeftCorner_1x6 translate <32*Feet,0,0> }
		object { LeftCorner_1x6 translate <32*Feet,0,8*Feet> }

		object { BrickWall_12x8 translate <34*Feet,4,0*Feet> }
		object { BrickWall_12x8 translate <34*Feet,4,8*Feet> }

//#macro TiledWindow(Xlength,Zheight,Xpanes,Zpanes,BarThickness,Quality)

		object { TiledWindow(5*Feet-2,5*Feet-2,4,5,0.5,1) translate < 6*Feet+1,5.4,3*Feet+1> }
		object { TiledWindow(5*Feet-2,5*Feet-2,4,5,0.5,1) translate <13*Feet+1,5.4,3*Feet+1> }
		object { TiledWindow(5*Feet-2,5*Feet-2,4,5,0.5,1) translate <20*Feet+1,5.4,3*Feet+1> }
		object { TiledWindow(5*Feet-2,5*Feet-2,4,5,0.5,1) translate <27*Feet+1,5.4,3*Feet+1> }

		object { WindowOuterFrame(5*Feet,5*Feet) translate < 6*Feet,5.4,3*Feet> }
		object { WindowOuterFrame(5*Feet,5*Feet) translate <13*Feet,5.4,3*Feet> }
		object { WindowOuterFrame(5*Feet,5*Feet) translate <20*Feet,5.4,3*Feet> }
		object { WindowOuterFrame(5*Feet,5*Feet) translate <27*Feet,5.4,3*Feet> }
		
	} // end union
#declare SouthWall =
	union {
		box {
			<0,-8,0>,<40*Feet,0,20*Feet>
			texture { StudioSouthWallTex }
		}
		object { BrickWall_6x8 rotate z*180 translate <15*Feet,1,0*Feet> }
		object { BrickWall_6x8 rotate z*180 translate <15*Feet,1,8*Feet> }
		object { BrickWall_6x8 rotate z*180 translate <23*Feet,1,0*Feet> }
		object { BrickWall_6x8 rotate z*180 translate <23*Feet,1,8*Feet> }
	} // end union
#declare EastWallS =
	box {
		<0,0,0>,<8,40*Feet,20*Feet>
		texture { StudioEastWallTex }
	}
#declare WestWallS =
	box {
		<-8,0,0>,<0,40*Feet,20*Feet>
		texture { StudioWestWallTex }
	}

#declare StudioFloorS =
	box {
		<0,0,-8>,<40*Feet,40*Feet,0>
		texture { StudioFloorTex }
	}
#declare StudioFloor =
	object { FloorBoards(40*Feet,40*Feet,4,90725)
	}

#declare StudioCeilingS =
	box {
		<0,0,0>,<40*Feet,40*Feet,8>
		texture { StudioFloorTex }
	}
#declare StudioCeiling =
	union {
		object { StudioFloor translate <0,0,13*Feet> }
		#local BPos = 0;
		#while (BPos < 40*Feet)
			box {
				<0,0,0>,<6,40*Feet,12>
				translate <BPos,0,12*Feet>
				texture { BeamTex }
			}
			#local BPos = BPos + 24;
		#end
	} // end union

#declare Studio =
	union {
		object { StudioFloor }
//		object { StudioCeilingS }
		object { StudioCeiling translate <0,0,3*Feet> }
		object { SouthWall }
//		object { NorthWallS translate <0,40*Feet,0> }
		object { NorthWall  translate <0,40*Feet-6,0> }
		object { EastWallS translate <40*Feet,0,0> }
		object { WestWallS }
		cylinder { <0,0,0>,<0,0,13*Feet>,6 texture { PlankWoodTex(2103) } translate <10*Feet,16*Feet,0> }
		cylinder { <0,0,0>,<0,0,13*Feet>,6 texture { PlankWoodTex(2103) } translate <20*Feet,16*Feet,0> }
		cylinder { <0,0,0>,<0,0,13*Feet>,6 texture { BeamTex } translate <30*Feet,16*Feet,0> }
	} // end union

//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 44
//		location  <-20*Feet, -60*Feet, 53*Feet> // overall
//		look_at <0*Feet,0*Feet,1*Feet>
		location  <-8*Feet, 0*Feet, 5*Feet> // render
		look_at <1*Feet,15*Feet,6*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
//		location  <-3*Feet, 0*Feet, 5*Feet> // room center
//		look_at <0*Feet,20*Feet,4*Feet>
//		location  <-0*Feet, 18*Feet, 8.5*Feet/1.3> // brick corner
//		look_at <0.5*Feet,20*Feet,7.0*Feet/1.3>
//		location  <3*Feet, -2*Feet, 1.5*Feet> // closeup
//		look_at <5*Feet,2*Feet,0>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue

/*
light_source // external
	{ <140*Feet,-300*Feet,250*Feet>, 2.2 }

light_source // external
	{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8 }
*/
light_source // internal
	{ <0,0,0>, 1.2
		spotlight point_at <0,2*Feet,-10*Feet> radius 23 falloff 44
		translate <6*Feet,16*Feet,13*Feet>
	}

light_source // internal
	{ <0,0,0> , <1.13,1.08,0.83>*.8
		spotlight point_at <0,2*Feet,-10*Feet> radius 23 falloff 44
		translate <-6*Feet,16*Feet,13*Feet>
	}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 10*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

object { Studio rotate z*0 translate <-20*Feet,-20*Feet,2> }
//#object { FloorBoards(20*Feet,12*Feet,5,320495) translate <0,0,1> }

#end

