#version unofficial megapov 1.21;

#include "colors.inc"
#include "transforms.inc"

global_settings {assumed_gamma 1.0 max_trace_level 6}
background {SkyBlue}
camera {location <210,225,-1200> angle 90 up y right 2*x look_at <-25, 135, 0>}

light_source {<-5000, 5000, 0> color White}
light_source {<0, 799, -1249> color White shadowless}
light_source {<0, 799, 0> color White shadowless}

//Leafy roof
#declare HalfCylinder = 
difference {
  cylinder {
    <0, 1200, 0>,
    <0, 1000, 0>,
    1249
  }
  box {
    <-1250, 999, 0>,
    <1250, 1201, 1250>
  }
}

//Enclosing trees
difference {
  cylinder {
    <0, 1100, 0>,
    <0, -100, 0>,
    1250
    texture {
      pigment {
        bozo scale 50
        color_map {
          [0.0 Green]
          [1.0 Gray20]
        }
      }
    }
    hollow
  }
  object {HalfCylinder
    texture {
      pigment {
        bozo scale 60
        color_map {
          [0.0 rgbt <0.137255 0.556863 0.137255, 0>]
          [0.7 rgbt <0.137255 0.556863 0.137255, 0>]
          [0.8 rgbt <0.137255 0.556863 0.137255, 1>]
          [1.0 rgbt <0.137255 0.556863 0.137255, 1>]
        }
      }
    }
  }
  interior{
    media{
      intervals 10
      samples 10,10
      method 1
      scattering { 1, rgb 1.5 }
      density{ rgb 0.001 }
    }
  }
}

//Ground
height_field {
  tga "Ground.tga"
  smooth
  translate <-0.5, -0.5, -0.5>
  scale <2500, 50, 2500>
  texture {
    pigment { rgb <1,0.6,0.31>*0.05 }
    normal {
      bumps
      bump_size 5
      scale 2
    }
  }

}


//Vines and flowers
#include "Vines.pov"

  //Vine variables
  #declare VineSegments = 200; //number of point in vine spline
  #declare VineLengthBasic = 100; //basic length of vine segment between spline points
  #declare VineLengthVariation = 25; //units variation of basic length (plus or minus)
  #declare VineThickness = 0.5; //vine thickness
  #declare LeafFrequency = 10; //number of leaves per vine segment; set to zero to turn off leaves/flowers
  #declare LeafScale = 10; //relative size of leaves
  #declare FlowerProbability = 0.1; //percent probability that a flower will appear instead of a leaf
  #declare FlowerScale = 10; //relative size of flowers
  
  //Bounding box for vine
  #declare MinX = -500;
  #declare MaxX = 450;
  #declare MinY = 0;
  #declare MaxY = 20;
  #declare MinZ = -900;
  #declare MaxZ = -700;
  
  //Random seed declarations
  #declare Xseed = seed(102);
  #declare Yseed = seed(98);
  #declare Zseed = seed(85);
  #declare AngleSeed = seed(6432);
  #declare VarSeed = seed(53421);
  #declare LeafRotSeed = seed(4562);
  #declare FlowerSeed = seed(91);
  
  #declare ShowBox = false; //display visual bounding box?
  #declare ShowVines = true; //draw vines?
  
  DrawVines()

//Scattered leaves
  #include "Maketree.pov"
  #include "txttree.inc"
  #declare dofile = false;
  #declare ffname="leaf.inc"
  #declare colLeaf=rgb<1,0.6,0.31>*0.1;
  #declare txtLeaf=texture{pigment{colLeaf} finish{ambient 0.1 specular 0.3 roughness 0.01}}
  #declare Leaf=object{MakeLeaf(0.3,10,5,2,0.4,3,100,1,0,1,0,0,3,0.12,10,dofile,ffname)} //Calls Gilles Tran's Makeleaf macro
  #declare DeadSeed = seed(672);
  #declare Diameter = 2500;
  #declare DeadLeaf = 1;
  
  #while (DeadLeaf < 10000)
    #declare DeadRndx = (rand(DeadSeed) - 0.5) * Diameter;
    #declare DeadRndz = (rand(DeadSeed) - 0.5) * Diameter;
    #declare DeadRot = rand(DeadSeed) * 360;
    object {Leaf texture {txtLeaf} scale 10 rotate <235, DeadRot, 0> translate <DeadRndx, 10, DeadRndz>}
    #declare DeadLeaf = DeadLeaf + 1;
  #end

//Small rocks
  #declare RockSeed = seed(432);
  #declare RockBrown = rgb <1,0.6,0.31>*0.1;
  #declare RockGrey = rgb <0.1, 0.1, 0.1>;
  #declare RockPink = rgb <0.8, 0.5, 0.5>*0.2;
  #declare Rocks = 1;
  
  #while (Rocks < 5000)
    #declare RockRot = rand(RockSeed) * 360;
    #declare RandRockx = (rand(RockSeed) - 0.5) * Diameter;
    #declare RandRockz = (rand(RockSeed) - 0.5) * Diameter;
    #declare RockSwitch = int(rand(RockSeed)*3) + 1;
    #declare RockScale = rand(RockSeed)*11;
    
    #switch (RockSwitch)
      #case (1)
        #declare RockColor = RockBrown;
      #break
      #case (2)
        #declare RockColor = RockGrey;
      #break
      #case (3)
        #declare RockColor = RockPink;
      #break
    #end
    
    sphere {0, 1 scale <1, 0.2, 0.5> scale RockScale rotate y*RockRot translate <RandRockx, 0, RandRockz> texture {pigment {RockColor} normal {bumps}}}
    
    #declare Rocks = Rocks + 1;
  #end

//Ferns
  #include "Fern.pov"
  #declare LeafPigment = texture{pigment{rgb <0.4,1,0.3>*0.4} finish{ambient 0.1 specular 1 roughness 0.01}};
  #declare SpinePigment = LeafPigment;
  
  #declare s1 = seed(432);
  #declare s2 = seed(612);
  #declare s3 = seed(54);
    
  Fern(1, true)
    
  object {FullFern rotate y*180 scale 10 translate <300, 0, -775>}
  object {FullFern rotate <0, 135, 15> scale 10 translate <300, 0, -775>}
  object {FullFern rotate <0, 0, 45> scale 10 translate <300, 0, -775>}
  
  object {FullFern scale 10 rotate z*-30 rotate y*15 translate <0, 0, -400>}
  object {FullFern scale 10 rotate z*-30 rotate y*75 translate <0, 0, -400>}
  object {FullFern scale 10 rotate z*-30 rotate y*135 translate <0, 0, -400>}
  object {FullFern scale 10 rotate y*205 translate <0, 0, -400>}
  object {FullFern scale 10 rotate y*265 translate <0, 0, -400>}
  object {FullFern scale 10 rotate y*325 translate <0, 0, -400>}  
  
  object {FullFern scale 10 rotate z*-30 translate <-300, 0, -600>}
  object {FullFern scale 10 rotate z*-30 rotate y*60 translate <-300, 0, -600>}
  object {FullFern scale 10 rotate z*-30 rotate y*120 translate <-300, 0, -600>}
  object {FullFern scale 10 rotate y*180 translate <-300, 0, -600>}
  object {FullFern scale 10 rotate y*240 translate <-300, 0, -600>}
  object {FullFern scale 10 rotate y*300 translate <-300, 0, -600>}  
  
//Actual trees
  #include "txttree.inc"
  #declare txtTree=texture{txtTree_3}; // Bark texture
  #declare txtLeaf=texture{txtLeaf_0}; // Leaf texture
  
  #include "treetrunk1.inc"
  object {TreeTrunk1 scale <7, 20, 7> translate <-500, 0, 0>}

  #include "treetrunk2.inc"
  object {TreeTrunk2 scale <7, 15, 7> translate <-700, 0, -550>}

  #include "treetrunk3.inc"
  object {TreeTrunk3 scale <7, 20, 7> translate <500, 0, 0>}
  
  #include "treetrunk4.inc"
  object {TreeTrunk4 scale <7, 20, 7> rotate y*45 translate <-950, 0, 400>}
  
  #include "BgLeaf1.inc"
  #include "BgFoliage1.inc"
  #include "BgTree1.inc"
  object {BgTree1 scale 15 translate z*300}
  object {BgTree1 rotate y*90 scale 15 translate <-900, 0, 0>}
  
  #include "BgLeaf2.inc"
  #include "BgFoliage2.inc"
  #include "BgTree2.inc"
  object {BgTree2 scale <10,10,10> translate <600, 0, -200>}

  #include "LayingLeaf.inc"
  #include "LayingFoliage.inc"
  #include "LayingTree.inc"
  object {LayingTree rotate y*-15 scale <10,10,10> translate <-1000, 0, -200>}

  #include "OverhangLeaf.inc"
  #include "OverhangFoliage.inc"
  #include "OverhangTree.inc"
  object {OverhangTree rotate y*-45 scale <10,15,10> translate <415, 0, -900>}
  
  #include "BushLeaf.inc"
  #include "BushFoliage.inc"
  #include "Bush.inc"
  object {Bush scale 10 translate <-450, 0, -400>}


//Grass
  #include "GrassPatches.pov"
  #declare GrassPatch = 
  union{
    object{objectPatch translate <-100, 0, 100>}
    object{objectPatch translate <100, 0, 100>}
    object{objectPatch translate <-100, 0, -100>}
    object{objectPatch translate <100, 0, -100>}
  }
  object {GrassPatch texture{txtGrass scale 40} translate z*300}
  object {GrassPatch texture{txtGrass scale 40} translate x*-500}
  object {GrassPatch texture{txtGrass scale 40} translate <-700, 0, -550>}
  object {GrassPatch texture{txtGrass scale 40} translate x*500}
  object {GrassPatch texture{txtGrass scale 40} translate <-950, 0, 400>}
  object {GrassPatch texture{txtGrass scale 40} translate x*-900}
  object {GrassPatch texture{txtGrass scale 40} translate <600, 0, -200>}
  object {GrassPatch texture{txtGrass scale 40} translate <1000, 0, -200>}
  object {GrassPatch texture{txtGrass scale 40} translate <415, 0, -1000>}
  
//Large rocks
#declare RockPigment = pigment{
  spotted
  color_map {
    [0.0 White]
    [0.2 White]
    [0.2 Gray20]
    [1.0 Gray20]
  }
}

height_field {
  tga "Rock2.tga"
  smooth
  pigment { RockPigment }
  translate <-0.5, 0, -0.5>
  rotate y*90
  scale <300, 250, 300>
  translate <-200, -20, 100>
  normal {bumps scale 5 bump_size 3}
}

height_field {
  tga "Rock3.tga"
  smooth
  pigment { RockPigment }
  translate <-0.5, 0, -0.5>
  rotate y*90
  scale <200, 200, 200>
  translate <-200, -50, -350>
  normal {bumps scale 5 bump_size 1}
}

height_field {
  tga "Rock4.tga"
  smooth
  pigment { RockPigment }
  translate <-0.5, 0, -0.5>
  scale <200, 200, 200>
  translate <-0, -75, -750>
  normal {bumps scale 5 bump_size 1}
} 

 

//Elf and Harp
#include "Elf.inc"
#include "Hair.inc"
#include "Dress.inc"
#include "Lips.inc"
#include "Eyes.inc"
#include "Harp.inc"
#include "Wings.inc"
#include "Eyebrow.inc"

#declare EyelashSpline =
spline {
  cubic_spline
  0, <0.066, 5.952, -0.522>,
  1, <0.066, 5.952, -0.522>,
  2, <0.132, 5.970, -0.494>,
  3, <0.219, 5.995, -0.458>,   
  4, <0.286, 6.012, -0.428>,
  5, <0.333, 6.012, -0.407>,
  6, <0.394, 5.992, -0.377>,
  7, <0.440, 5.988, -0.355>
  8, <0.440, 5.992, -0.355>
}

#declare Eyelash = 
sphere_sweep {
  cubic_spline
  5,
  <0, 0, 0.25>, 0.01
  <0, 0, 0>, 0.01
  <0, 0.125, -0.15>, 0.0075
  <0, 0.25, -0.15>, 0.005
  <0, 0.375, 0>, 0.005
}

#declare Rock1 =
height_field {
  tga "Rock1.tga"
  smooth
  pigment { RockPigment scale 5 }
  translate <-0.5, -0.5, -0.5>
  scale <10, 8, 10>
  translate z*1
  normal {bumps scale 5 bump_size 5}
}

#include "Flowers.pov"

union{
  union {
    object {Elf pigment {Flesh} finish {ambient 0.9 diffuse 0.1}}
    object {Hair 
      texture { 
        normal {
          gradient z
          triangle_wave
          scale 0.01
        }
        finish {
          brilliance 0.7
          specular 0.5
          roughness .001
        }
        pigment {BrightGold}
      }
    }
    object {MorningGloryforHair scale 0.5 rotate z*-90 translate <0.85, 6.2, 0>}
    object {Dress pigment {White} finish {ambient 0.7}}
    object {Lips
      pigment {SpicyPink}
      normal {
        wrinkles
        scale 0.001
      }
      finish {
        phong 0.9
        phong_size 10
        reflection 0.15
      }
    }
    object {Eyes
      pigment {
        spherical
        scale 0.4
        translate <0.27, 5.95, -0.45>
        color_map{
          [0.0 White]
          [0.5 White]
          [0.85 White]
          [0.85 Blue]
          [0.93 Blue]
          [0.93 Black]
          [1.0 Black]
        }
      }
      finish {
        phong 0.25
        phong_size 0.001
        reflection 0.5
      }
    }
    
    #declare ELCount = 0;
    #declare ELScale = 0.05;
    
    #while (ELCount < 8)
      object {Eyelash pigment {Black} rotate x*-10 scale ELScale translate EyelashSpline(ELCount)}
      #declare ELCount = ELCount + 0.1;
      #if (ELCount <= 3.5)
        #declare ELScale = ELScale + 0.01;
      #else
        #declare ELScale = ELScale - 0.01;
      #end
    #end
    
    object {Eyebrow pigment {DarkBrown}}

    object {Wing
      rotate y*-45
      translate <0, 3.771, 1>
    }
    object {Wing
      rotate y*-135
      translate <0, 3.771, 1>
    }
    object {Rock1}
    rotate y*90
    scale 30
    translate <400, 110, -700>
  }  
  object {FullHarp scale 30 rotate z*-15 translate <140, 20, -675>}
  Rotate_Around_Trans(y*5, <270, 65, -690>)
}


//Little fairy glows
#declare FairySpline =
spline {
  cubic_spline
  0, <325, 150, -750>,
  1, <300, 200, -700>,
  2, <275, 250, -650>,
  3, <270, 300, -600>,
  4, <225, 400, -550>,
  5, <130, 400, -550>,
  6, <-50, 350, -500>,
  7, <-150, 300, -450>,
  8, <-250, 250, -450>,
  9, <-300, 150, -550>,
  10, <-350, 100, -600>,
  11, <-400, 150, -650>,
  12, <-400, 250, -700>,
  13, <-350, 300, -725>,
  14, <-250, 350, -750>,
  15, <-150, 250, -750>,
  16, <0, 200, -700>,
  17, <200, 300, -700>,
  18, <250, 350, -700>
}

#declare FairyCount = 0;
#declare GlowColorSeed = seed(653);
#declare GlowSizeSeed = seed(7101);
#declare GlowShiftSeed = seed(453);

#while (FairyCount <= 18)
  #declare GlowColor = rand(GlowColorSeed);
  #declare GlowSize = abs(rand(GlowSizeSeed)-0.5)/4;
  #declare xGlowShift = (rand(GlowShiftSeed)-0.5)*40;
  #declare yGlowShift = (rand(GlowShiftSeed)-0.5)*40;
  #declare zGlowShift = (rand(GlowShiftSeed)-0.5)*40;  
  glow {          
    type 0
    location FairySpline(FairyCount)
    size GlowSize
    fade_power 1
    color Goldenrod
    translate <xGlowShift, yGlowShift, zGlowShift>
  }
  #declare FairyCount = FairyCount + 0.09;
#end


#include "Fairy.inc"

union {
  object {Fairy
    pigment {White}
  }
  object {Wing2
    rotate <-30,60,0>
    translate <0, 1, 0.5>
  }
  object {Wing2
    rotate <30,120,0>
    translate <0, 1, 0.5>
  }
  rotate <-45, -90, 0>
  scale 4
  translate <200, 300, -700>
    finish {
      ambient 0.8
      diffuse 0.8
    }
}

glow {          
  type 0
  location <202, 307, -700>
  size 1
  fade_power 0.65
  color DarkTurquoise
}
