#version unofficial megapov 1.21;

#include "colors.inc"

global_settings {assumed_gamma 1.0}
background {rgb <1,0.9,0.9>}

camera {location <0,6,-2> look_at <0, 6, 0>}
//camera {location <5,0,0> look_at 0}
light_source {<0,0,-100> color White }
#include "Eyes.inc"

#declare Eyes = object {Eyes
  pigment {
    spherical
    scale 0.4
    translate <0.27, 5.95, -0.45>
    color_map{
      [0.0 White]
      [0.5 White]
      [0.85 White]
      [0.85 Blue]
      [0.93 Blue]
      [0.93 Black]
      [1.0 Black]
    }
  }
/*  finish {
    phong 0.25
    phong_size 0.001
    reflection 0.5
  }*/
}

#declare EyelashSpline =
spline {
  cubic_spline
  0, <0.066, 5.952, -0.522>,
  1, <0.066, 5.952, -0.522>,
  2, <0.132, 5.970, -0.494>,
  3, <0.219, 5.995, -0.458>,   
  4, <0.286, 6.012, -0.428>,
  5, <0.333, 6.012, -0.407>,
  6, <0.394, 5.992, -0.377>,
  7, <0.440, 5.988, -0.355>
  8, <0.440, 5.992, -0.355>
}

#declare Eyelash = 
sphere_sweep {
  cubic_spline
  5,
  <0, 0, 0.25>, 0.01
  <0, 0, 0>, 0.01
  <0, 0.125, -0.15>, 0.0075
  <0, 0.25, -0.15>, 0.005
  <0, 0.375, 0>, 0.005
}

#declare ELCount = 0;
#declare ELScale = 0.05;

#while (ELCount < 8)
  object {Eyelash pigment {Black} rotate x*-10 scale ELScale translate EyelashSpline(ELCount)}
  #declare ELCount = ELCount + 0.1;
  #if (ELCount <= 3.5)
    #declare ELScale = ELScale + 0.01;
  #else
    #declare ELScale = ELScale - 0.01;
  #end
#end
    
object {Eyes} 

#include "PCMHAIR.MCR"
#declare hair_object_count = 400;
#declare hair_length = 0.05;
#declare hair_thickness = 0.005;
#declare hair_patch_size = 0.005;
#declare hairs_per_patch = 1;
#declare hair_sky = x;
#declare hair_objects_only = true;
#declare hair_texture = texture{pigment {DarkBrown}};
read_mesh("Eyebrow.pcm")






