#version unofficial megapov 1.21;

#include "colors.inc"

//global_settings {assumed_gamma 1.0}
//background {rgb <1,0.9,0.9>}
//camera {location <0,0,-2> look_at <0, 0, 0>}
//light_source {<500,500,-500> color White}

//#include "MorningGlory1.inc"
//#include "MorningGlory2.inc"
//#include "MorningGlory3.inc"
//#include "MorningGlory4.inc"
//#include "MorningGlory5.inc"

//#declare FlowerSeed = seed(5432);

#macro CreateFlower()
  #declare FlowerType = int((rand(FlowerSeed)*5) + 1);
  #declare FlowerColor = int((rand(FlowerSeed)*8) + 1);
  
  #switch (FlowerType)
    #case (1)
      #declare MorningGlory = object{MorningGlory1};
    #break
    #case (2)
      #declare MorningGlory = object{MorningGlory2};
    #break
    #case (3)
      #declare MorningGlory = object{MorningGlory3};
    #break
    #case (4)
      #declare MorningGlory = object{MorningGlory4};
    #break
    #case (5)
      #declare MorningGlory = object{MorningGlory5};
    #break
  #end
  
  #declare Stamen =
  union {
    cylinder {
      <0, -0.25, 0>,
      <0, 0.1, 0>,
      0.01
    }
    sphere {<0, 0.1, 0.05>, 0.015}
    sphere {<0, 0.1, 0.025>, 0.02}
    sphere {<-0.01, 0.08, 0>, 0.01}
    sphere {<-0.025, 0.1, -0.01>, 0.02}
    sphere {<-0.03, 0.1, 0>, 0.01}
    sphere {<0.01, 0.06, 0>, 0.012}
    sphere {<-0.01, 0.08, 0.01>, 0.012}
    sphere {<0.03, 0.05, 0.02>, 0.015}
    sphere {<-0.01, 0.03, 0.01>, 0.015}
    sphere {<0.02, 0.04, -0.01>, 0.015}
    sphere {<0, 0.02, -0.01>, 0.015}
    pigment {White}
  }
  
  #switch (FlowerColor)
    #case (1)
      #declare MorningGlory =
      union {
        object {MorningGlory
          pigment {
            image_map {png "MorningGloryBlue.png"}
            rotate x*90
            translate <0.5, 0, 0.5>
            scale 2.1
          }
          finish {
            ambient .3
          }
        }  
        object {Stamen translate y*-0.2}
      }
    #break
    #case (2)
      #declare MorningGlory =
      union {
        object {MorningGlory
          pigment {
            image_map {png "MorningGloryDarkBlue.png"}
            rotate x*90
            translate <0.5, 0, 0.5>
            scale 2.1
          }
          finish {
            ambient .3
          }
        }  
        object {Stamen translate y*-0.2}
      }
    #break
    #case (3)
      #declare MorningGlory =
      union {
        object {MorningGlory
          pigment {
            image_map {png "MorningGloryDarkPink.png"}
            rotate x*90
            translate <0.5, 0, 0.5>
            scale 2.1
          }
          finish {
            ambient .3
          }
        }  
        object {Stamen translate y*-0.2}
      }
    #break
    #case (4)
      #declare MorningGlory =
      union {
        object {MorningGlory
          pigment {
            image_map {png "MorningGloryPaleBlue.png"}
            rotate x*90
            translate <0.5, 0, 0.5>
            scale 2.1
          }
          finish {
            ambient .3
          }
        }  
        object {Stamen translate y*-0.2}
      }
    #break
    #case (5)
      #declare MorningGlory =
      union {
        object {MorningGlory
          pigment {
            image_map {png "MorningGloryPalePink.png"}
            rotate x*90
            translate <0.5, 0, 0.5>
            scale 2.1
          }
          finish {
            ambient .3
          }
        }  
        object {Stamen translate y*-0.2}
      }
    #break
    #case (6)
      #declare MorningGlory =
      union {
        object {MorningGlory
          pigment {
            image_map {png "MorningGloryPalePurple.png"}
            rotate x*90
            translate <0.5, 0, 0.5>
            scale 2.1
          }
          finish {
            ambient .3
          }
        }  
        object {Stamen translate y*-0.2}
      }
    #break
    #case (7)
      #declare MorningGlory =
      union {
        object {MorningGlory
          pigment {
            image_map {png "MorningGloryPinkBlue.png"}
            rotate x*90
            translate <0.5, 0, 0.5>
            scale 2.1
          }
          finish {
            ambient .3
          }
        }  
        object {Stamen translate y*-0.2}
      }
    #break
    #case (8)
      #declare MorningGlory =
      union {
        object {MorningGlory
          pigment {
            image_map {png "MorningGloryPurple.png"}
            rotate x*90
            translate <0.5, 0, 0.5>
            scale 2.1
          }
          finish {
            ambient .3
          }
        }  
        object {Stamen translate y*-0.2}
      }
    #break
  #end
#end 


//Stand alone hair flower
  #include "MorningGlory3.inc"
  #declare Stamen =
  union {
    cylinder {
      <0, -0.25, 0>,
      <0, 0.1, 0>,
      0.01
    }
    sphere {<0, 0.1, 0.05>, 0.015}
    sphere {<0, 0.1, 0.025>, 0.02}
    sphere {<-0.01, 0.08, 0>, 0.01}
    sphere {<-0.025, 0.1, -0.01>, 0.02}
    sphere {<-0.03, 0.1, 0>, 0.01}
    sphere {<0.01, 0.06, 0>, 0.012}
    sphere {<-0.01, 0.08, 0.01>, 0.012}
    sphere {<0.03, 0.05, 0.02>, 0.015}
    sphere {<-0.01, 0.03, 0.01>, 0.015}
    sphere {<0.02, 0.04, -0.01>, 0.015}
    sphere {<0, 0.02, -0.01>, 0.015}
    pigment {White}
  }

  #declare MorningGloryforHair =
  union {
    object {MorningGlory3
      pigment {
        image_map {png "MorningGloryPurple.png"}
        rotate x*90
        translate <0.5, 0, 0.5>
        scale 2.1
      }
      finish {
        ambient .3
      }
    }  
    object {Stamen translate y*-0.2}
  }
      
