// several different gold colors, finishes and textures
#include "golds.inc"

// various metal colors, finishes and textures
// brass, copper, chrome, silver
#include "metals.inc"


// perspective (default) camera
camera {
  location  <-12.0, 8.0, -25.0>
  look_at   <0, 3.0,  0.0>
  right     x*image_width/image_height
}

/*
//laterale
camera {
  location  <20.0, 2.0, -5>
  look_at   <0, 0.0,  0.0>
  right     x*image_width/image_height
} 


//pianta
camera {
  location  <0.0, 40.0, 10.0>
  look_at   <0, 0.0,  10.0>
  right     x*image_width/image_height
} 
*/
light_source {
  0*x                 // light's position (translated below)
  color rgb .5       // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <40, 80, -40>   // <x y z> position of light
}




//Dichiarazioni


/////////////////////Tastiera
declare dofa=
        difference{
                box{<0.2,0.2,1>,<-0.2,-0.2,-1>}
                box{<0.1,0.22,0>,<0.21,-0.22,1.1>}          
                texture{pigment{ color rgb <1.3,1.2,1>}}
                finish{
                        reflection 0.3
                        }
                }
declare resolla=
        difference{
                box{<0.2,0.2,1>,<-0.2,-0.2,-1>}          
                box{<0.1,0.22,0>,<0.21,-0.22,1.1>}
                box{<-0.1,0.22,0>,<-0.21,-0.22,1.1>}                    
                texture{pigment{ color rgb <1.3,1.2,1>}}
                finish{
                        reflection 0.3
                        }
                }
declare misi=
        difference{
                box{<0.2,0.2,1>,<-0.2,-0.2,-1>}          
                box{<-0.1,0.22,0>,<-0.21,-0.22,1.1>}          
                texture{pigment{ color rgb <1.3,1.2,1>}}
                finish{
                        reflection 0.3
                        }
                }
declare complete =
                box{<0.2,0.2,1>,<-0.2,-0.2,-1>
                texture{pigment{ color rgb <1.3,1.2,1>}}
                finish{
                        reflection 0.3
                        }
                }
                
declare nero=
        intersection{
                box{<0.108,0.4,0>,<0.292,-0.20,1>}
                plane{ <0,1,-1>,0.2}
                texture{pigment{ color rgb <0.2,0.1,0.1>}}
                finish{
                        reflection 0.3
                        }
                }
#declare scala=  
           union{                                
                 object{nero}       
                 object{nero
                        translate x*.42} 
                 object{nero
                        translate x*.42*3} 
                 object{nero
                        translate x*.42*4} 
                 object{nero
                        translate x*.42*5}                                       
                 object{dofa}                
                 object{resolla
                        translate x*0.42}           
                 object{misi
                        translate x*0.42*2} 
                 object{dofa
                        translate x*0.42*3} 
                 object{resolla
                        translate x*0.42*4}   
                 object{resolla
                        translate x*0.42*5}                                  
                 object{misi
                        translate x*0.42*6}        
                }       


///////////Tastiera

object{complete
        translate x*.42*28}
object{dofa
        translate -x*.42*23}
object{misi
        translate -x*.42*22}        
object{nero
        translate -x*.42*23}        
object{scala}    
object{scala
        translate x*.42*7}
object{scala
        translate x*.42*14}
object{scala
        translate -x*.42*7}
object{scala
        translate -x*.42*14}
object{scala
        translate x*.42*21}        
object{scala
        translate -x*.42*21}

       
// Create an infinite sphere around scene and allow any pigment on it
sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.000 0.002 color rgb <1.0, 1.2, 1.3>*0.4
                     color rgb <1.0, 1.2, 1.3>*0.4]
        [0.002 0.200 color rgb <0.8, 0.8, 0.8>*0.4
                     color rgb <0.2, 0.2, 0.3>*0.4]
      }
      scale 2
      translate -1
    }
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>
    }
    rotate -135*x
  }


////////////Acqua

plane{ <0,1,0>, -6.5                 
        pigment{color rgbt <0,0,0,0.2>
        }         
        normal{waves}
        interior{ior 1.33}
        finish{reflection 0.5}  
        
        }
       
////////////Piano   
#declare pedaliera=
        union{
          union{
                box{<-0.1,0,-0.1>,<0.1,-5,0.1>
                        translate x*0.5}
                box{<-0.1,0,-0.1>,<0.1,-5,0.1>
                        translate x*2.5}    
                box{<1.1,-5,1.1>,<-1.1,-5.3,-1.1>
                        translate x*1.5}                                                  
                pigment{color rgb <0.2,0.1,0.1>}
                finish{
                        reflection 0.1
                        }       
               }              
          cylinder{<1.4,0,0.6>,<1.4,-5,0.6>,0.08     
                texture{T_Gold_1A}
                }                 
          cylinder{<1.8,0,0.6>,<1.8,-5,0.6>,0.08     
                texture{T_Gold_1A}
                }
          box{<1.2,-5.2,0>,<1.5,-5.4,-2>
                texture{T_Gold_1A}
                }
          box{<1.7,-5.2,0>,<2,-5.4,-2>
                texture{T_Gold_1A}
                }                
                
             }                           
                          
#declare contorno=
        union{                      
                cylinder{<0,-0.8,0>,<0,2,0>,5.6
                scale <1,1,1>
                translate <-5.4,0,17>}
                box{<-11,-0.8,1>,<0.2,2,17>}
                difference{
                        cylinder{<6,-0.8,1>,<6,2,1>,8}
                        box{<-3,-1,1>,<15,3,-9>}
                        box{<13,-1,11>,<15,3,-9>}
                        }
                       
                difference{
                        box{<6,-0.8,15>,<-5,2,1>}
                        cylinder{<6,-0.9,15>,<6,2.1,15>,6}
                        }
                          
                pigment{color rgb <0.2,0.1,0.1>}
                finish{
                        reflection 0.1
                        }                
              }  
#declare contorno_int=
        union{                      
                cylinder{<0,-0.8,0>,<0,2,0>,5.1
                translate <-5.4,0,17>}
                box{<-10.5,-0.8,1.5>,<-0.3,2,17>}
                 difference{
                        cylinder{<6,-0.8,1>,<6,2,1>,7.5}
                        box{<-2.5,-1,1.5>,<14.5,3,-8.5>}
                        box{<12.5,-1,11.5>,<14.5,3,-9.5>}     
                        }
                       
                difference{
                        box{<5.5,-0.8,14.5>,<-5.5,2,1.5>}
                        cylinder{<6,-0.9,15>,<6,2.1,15>,6.6}
                        }
                     
                pigment{color rgb <0.2,0.1,0.1>}
                finish{
                        reflection 0.1
                        }                
              }  
                
                
                
                
box{<-11,-.6,-1.2>,<13,-0.9,2>
        pigment{color rgb <0.2,0.1,0.1>}
        finish{
                        reflection 0.1
                        }
        }

box{<-11.25,-.6,-1.5>,<13.25,-0.1,-1>
        pigment{color rgb <0.2,0.1,0.1>}
        finish{
                        reflection 0.1
                        }
        }

box{<-11.25,-.6,1.5>,<-10,0.1,-1>
        pigment{color rgb <0.2,0.1,0.1>}
        finish{
                        reflection 0.1
                        }
        }

box{<13.25,-.6,1.5>,<12,0.1,-1>
        pigment{color rgb <0.2,0.1,0.1>}
        finish{
                        reflection 0.1
                        }
        }

#declare kcover=
union{
        box{<-11,1.5,1.2>,<13,0,1.1>}
        difference{
                cylinder{<-10.8,1,0.15>,<12.8,1,0.15>,1.2}
                cylinder{<-11.2,1,0.15>,<13.2,1,0.15>,1}
                box{<-11.1,-4,-4.65>,<13.1,3,0.65>}
                box{<-11.2,1,5>,<13.2,-0.5,-5>}
                }  
                
                pigment{color rgb <0.2,0.1,0.1>}  
                finish{
                                reflection 0.1
                                }
        }                                                          




#declare saliscendi=
        union{
                difference{
                        box{<1,1,0.2>,<-1,-1,-0.2>}
                        cylinder{<0,1,0.3>,<0,1,-0.3>,1}
                        cylinder{<0,-1,0.3>,<0,-1,-0.3>,1}
                        box{<1.1,1,0.3>,<0,-1,-0.3>}
                        pigment{color rgb <0.2,0.1,0.1>}        
                        finish{
                        reflection 0.1
                        }
                        }
                difference{
                        cylinder{<0,-1,0.2>,<0,-1,-0.2>,1}
                        box{<1,-1,0.3>,<-1,-2,-0.3>}
                        pigment{color rgb <0.2,0.1,0.1>}        
                        finish{
                        reflection 0.1
                        }
                        }
                difference{
                        cylinder{<-1,1.5,0.2>,<-1,1.5,-0.2>,0.5}
                        box{<-1.5,2,0.3>,<-1,-1,-0.3>}
                        pigment{color rgb <0.2,0.1,0.1>}        
                        finish{
                        reflection 0.1
                        }                        
                        }         
                        rotate y*90
                        translate x*-9
                        translate z*0
                        translate y*1
                        scale <1,1,1.3>
                }                                   
union{
object{saliscendi
        scale <1,0.7,1>
        translate <-2.05,-0.1,0>}            
object{saliscendi
        scale <1,0.7,1>
        translate <22.05,-0.1,0>}            
object{kcover
        scale <0.98,1/1.5,1>
        }
difference{
        object{contorno}
        object{contorno_int
                scale <1,1.2,1>}
        scale <1.015,1,1.1>   
        translate 0.3*z             
        }                

object{contorno
        scale <1,0.1,1.1>
        translate -1*y
        translate 1*z
        }
        scale <1,1.5,1>                                 
        }

///cover

union{
        difference{
                object{contorno}        
                box{<-12,10,-3>,<14,-10,3>}
                }                       
        box{<-11,-.8,3>,<13,2,5>
                translate 3*y
                pigment{color rgb <0.2,0.1,0.1>}        
                        finish{
                        reflection 0.1}  
                        }
        
        scale y*0.1
                rotate z*15
                translate 6*y
                translate 0.3*z
                translate -0.5*x
        }                                

box{<12.3,2,3>,<12.5,10.5,3.2>
                        pigment{color rgb <0.2,0.1,0.1>}        
                        finish{
                        reflection 0.1}  
                        rotate z*20
                        translate -y*5
                        translate x*2
                        translate z*2
                        }
                       
////Corde
#declare cordacorta=
        cylinder{<11,1,2>,<11,1,24>,0.04
                texture{
                        pigment{ color rgb <0.5,0.5,0.2>}
                        }
                 }

object{pedaliera}     


#declare Count=0;
 #while (Count < 210)
 /*         
 
  scale <1,1,100>
  }              
  */
  intersection{
  object{cordacorta          
        translate -x*0.1*Count }
  object{contorno
        scale <1,100,1>}           
  }
         
  #declare Count=Count+1;
 #end
/*
#declare Count=90;
 #while (Count < 110)
 intersection{
  object{cordacorta  
        rotate -y*5        
        translate -x*0.1*Count }
  object{contorno}              
  scale <1,1,0.7>
  }      
  #declare Count=Count+1;
 #end 

#declare Count=120;
 #while (Count < 210)
 intersection{
  object{cordacorta 
        rotate y*3         
        translate -x*0.1*Count 
        }
  object{contorno}         
  scale <1,1,0.7>
  }      
  #declare Count=Count+1;
 #end
*/ 

   // radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}
     