
// Persistence of Vision Ray Tracer Scene Description File
// File: coq.pov
// Vers: 3.6
// Desc:
// Date: 23.04.06
// Auth: Jean-Louis Saquet

#include "colors.inc"
#include "textures.inc"
#include "glass.inc"

global_settings {
  assumed_gamma 1.0
} 
     
plane { y,-1	
	pigment {rgb<166, 150, 13>/255}
	finish{reflection .15}
      }
//--------------------------------------------------------------
#declare T_1= texture {
      pigment {gradient y turbulence 2
             color_map{
             [0  rgb<155, 118, 37>/255]
             [.2 rgb<192, 118, 37>/255]
             [.3 rgb<192, 163 37>/255]
             [1 rgb<192, 163, 89>/255]} 
             }
      finish{phong 1} 
   }      
#declare Oeuf=
sphere{<0, 1.3, 0>, 1  scale y*1.5
      texture {T_1} 
      } 

#declare Doigts= 
blob{  threshold .65
    cylinder{<0, 0, -1>, <0, 0, 0>, .15, 1}               //doigt M  
    sphere{<0, 0, -1>, .1, 1 } 
    cylinder{<0, 0, -1>, <0, 0, 0>, .15, 1 rotate y*15}   //doigt G 
    sphere{<0, 0, -1>, .1, 1 rotate y*15}
    cylinder{<0, 0, -1>, <0, 0, 0>, .15, 1 rotate y*-15}  //doigt D 
    sphere{<0, 0, -1>, .1, 1 rotate y*-15}
    cylinder{<0, 0, 0>, <0, .75, 0>, .15, 1}              //patte  
    pigment{rgb <208, 95, 0>/255}
    finish{phong 1} 
    sturm
    } 
    
#declare Griffe=
sphere_sweep {           
  cubic_spline
  5,                          
  < 0, .02, -.99>, .06             
  < 0, .02, -1>, .05               
  < 0, .04, -1.2>, .02
  < 0, -.02, -1.25>, .001
  < 0, -.03, -1.2>, .001
  tolerance .1      
  pigment{rgb <113, 53, 0>/255}
    finish{phong 1} 
}

#declare Patte=
union{ 
  object{Doigts}
  object{Griffe}  
  object{Griffe rotate y*15}  
  object{Griffe rotate y*-15}
  }

//--------------------------------------------------------------
#declare Visage=            
blob {
	threshold .65 
sphere {<0, 0, 0>, 2, 1 scale <2,3,1> rotate x*15 }          //visage
cylinder{<0, 0, -1>,<0, -.5, -2>, 1, 1 scale <.5,.75,1> }    //nez
sphere{<0, .75, -.5>, .8, -1 scale <1,1.5,1> rotate z*-75 }  //orbite  D
sphere{<0, .75, -.5>, .8, -1 scale <1,1.5,1> rotate z*75 }   //orbite  G
sphere{<0,3.5, 0>, 1.5, 1 scale <1,.3,1> rotate z*0 }        //front
sphere{<0, -3, -2>, .8, -1 scale <1,.5,.5> rotate z*0 }      //bouche 
cylinder{<0, -3, -.5>,<0,0, 0>, .8, 1 rotate x*15 }          //menton 
cylinder{<0, -5, 1>,<0,0, .5>, 2, 1 scale<1,1,1> }           //cou  
} 
//--------------------------------------------------------------
#declare Veines = pigment {
      radial   turbulence .4
      frequency 17
      color_map {
        [0.00  color White   ]
        [0.28  color White   ]
        [0.31  color Scarlet   ]
        [0.33  color Red   ] 
        [0.35  color Scarlet  ]
        [0.38  color White   ]
        [1.00  color White   ]
      }  
      translate <-.05,0,-.05>
    }  
      
#declare Blanc = pigment { color White}
//--------------------------------------------------------------
#declare Oeil=
union{  
 intersection{             
  sphere{<0,0,0>,1} 
  box{<-1.1,-1.1,-1.1>,<1.1,.7999,1.1>}
  texture{
       pigment {
		gradient y   scale 2 translate y*1
		pigment_map {
			[0 Veines  ] 
			[.4 Veines ]
			[1 Blanc]
		} 
           }
           	finish{phong .2  }
  }  
} 

 difference{                                     
  sphere { <0,0,0>, 1 
    material { M_Glass }
  }  
  box{<-1.1,-1.1,-1.1>,<1.1,.8,1.1>
    pigment {
      radial   turbulence .05
      frequency 26
      color_map {
        [0.00 color LightBlue]
        [0.33 color MediumTurquoise]
        [0.66 color SeaGreen ]
        [1.00 color MediumAquamarine ]
      }  
    }   
  }
  cylinder{<0,.6,0>,<0,.801,0>,.2
    pigment{color Black}
  }
} 
}
//--------------------------------------------------------------
#declare Tete=
union{
object{Visage}
object{Oeil rotate<-90,0,0> translate <-1.5,.25,-.3>scale.8}  
object{Oeil rotate<-90,0,0> translate <1.5,.25,-.3>scale.8}
     } 
//--------------------------------------------------------------
#declare Couronne=
blob {
	threshold .9   
//-----------------Extrmits-----------------------------------
#declare R = .6;
#declare Nr = 0;      
#declare EndNr = 7;  
#while (Nr< EndNr) 

 sphere {<.5, -.1, 0>, .1, 1 
        translate <R,0,0> 
        rotate <0,Nr* 360/EndNr,0> 
        pigment{rgb<255, 0, 0>/255}      
        finish{phong 1}
       }  

 #declare Nr = Nr + 1;  

#end
//-----------------Rayons---------------------------------------
#declare R = 1;
#declare Nr = 0;      
#declare EndNr = 7;  
#while (Nr< EndNr) 

 sphere {<.5, -.1, 0>, .15, 1       
        scale y*6  rotate z*-45
        translate <R,.5,0> 
        rotate <0,Nr* 360/EndNr,0> 
       pigment{rgb<255, 0, 0>/255}      
        finish{phong 1}
       }  

 #declare Nr = Nr + 1;  

#end    
//-----------------Paroi----------------------------------------
#declare R = 1.5;
#declare Nr = 0;      
#declare EndNr = 14;  
#while (Nr< EndNr) 

 sphere {<.5, -.5, 0>, .3, 1  scale < .2, 4, 2>    
          rotate z*-45
        translate <R,.5,0> 
        rotate <0,Nr* 360/EndNr,0> 
        pigment{rgb <255, 150, 0>/255}
    finish{phong 1} 
       }  

 #declare Nr = Nr + 1;  

#end                                 
               sturm  
}//----------Fin du  blob  
#declare Brouette= 
union{
union{
//-------------------rayons------------------------------------- 
#declare R = 0;
#declare Nr = 0;      
#declare EndNr = 7;  
#while (Nr< EndNr) 

 cylinder{<0, .3, 0>,<2.15, 0, 0>, .05 
        translate <R,0,0> 
        rotate <0,Nr* 360/EndNr+77,0>        
       }  

 #declare Nr = Nr + 1;  

#end    
//------------------rayons-------------------------------------- 
#declare R = 0;
#declare Nr = 0;      
#declare EndNr = 7;  
#while (Nr< EndNr) 

 cylinder{<0, -.3, 0>,<2.15, 0, 0>, .05 
        translate <R,0,0> 
        rotate <0,Nr* 360/EndNr,0> 
       }  

 #declare Nr = Nr + 1;  

#end   
//--------------------axe---------------------------------------                               
cylinder{<0, -1, 0>,<0, 1, 0>, .15 } 
//-------------------jante--------------------------------------
torus{2.2,.1 scale y*3}

        pigment{rgb <1, .25, 0>}
        finish{phong 1}
        rotate<-90, 0, 0>  
}  
//----------------------benne-----------------------------------
blob{ threshold .65
   cylinder{<3.5, 1, 1.2>, <7.5, 2, 3>, 2, 1 scale z*.3 rotate x*45}    //bord D
   cylinder{<3.5, 1, -1.2>, <7.5, 2, -3>, 2, 1 scale z*.3 rotate x*-45} //bord G
   cylinder{<4.5, -.5, 0>, <7, 0, 0>, 2, 1 scale y*.3}                  //bas   
   cylinder{<-.25, 0, .7>, <12, 0, 1.4>,.4, 1 scale y*1.2}              //poigne D
   cylinder{<-.25, 0, -.7>, <12, 0, -1.4>,.4, 1 scale y*1.2}            //poigne G
   sphere{<10, -.5, 0>, 2, 1 scale x*.3 rotate z*30}                    //avant 
   cylinder{<7, -2.3, -1>, <8, 0, -1>,.4, 1 }                           //pied G 
   cylinder{<7, -2.3, -1>, <5, 0, -1>,.4, 1 }                           //...
   sphere{<7, -2.3, -1>, .4, -1}                                        //...     
   cylinder{<7, -2.3, 1>, <8, 0, 1>,.4, 1 }                             //pied D 
   cylinder{<7, -2.3, 1>, <5, 0, 1>,.4, 1 }                             //...
   sphere{<7, -2.3, 1>, .4, -1}                                         //...  
         pigment{rgb <.6, .4, 0>}
        finish{phong 1} 
        } 
}
//--------------------croche------------------------------------
#declare Croche = 
merge{
   sphere{<0, 0, 0>, .6 scale x*1.5}
   cylinder{<.7, 0, 0>, <.7, 4, 0>, .15} 
   sphere_sweep {           
  cubic_spline
  5,                          
  < .6, 4, 0>, .15             
  < .7, 4, 0>, .15               
  < 1.5, 3.25, 0>, .125
  < 2, 2.5, 0>, .1
  < 2, 2, 0>, .08
  tolerance .1 }    
} 
   
 camera {location  < -2.5, 4 ,-17>
         look_at   < -2.5, 3 , -1>
         angle 35
        }                                       
light_source{<-5,7,-5> rgb 1} 
 
#declare Coq=
union{ 
object{Couronne rotate x*20 translate <0, 4.2, .2>scale 1.68}
object{Tete scale.3 translate <0, 4.5, -.5> texture { T_1 }   }
object{Oeuf}    
object{Patte translate x*-.5 rotate y*30} 
object{Patte translate x*.5 rotate y*-30} 
 translate y*-.9  
 }
object{Coq  rotate y*30 translate z*2}   
object{Brouette rotate <0, -60, 0> scale .5 translate<-5, .18, 0>} 
object {Croche
      rotate <60, -30, 0> translate <-2.5, -.5, -1>  
      pigment{rgb <1, 0, 0>}  finish{phong 1} 
      } 
#declare Bulle=
sphere {
	<0, 2, 0>,4
	pigment {White filter 1}
	finish {
		ambient .1
		diffuse .1
		reflection .2
		specular 1
		roughness .001
		irid {
			0.25
			thickness .5
			turbulence .5
		}
	}
	interior {
		ior 1.5
		fade_distance 5
		fade_power 1
		caustics 1
	}
} 
union{  
object {Croche
      pigment{rgb <0, 1, 0>}  finish{phong 1} 
      } 
object {Bulle}
 rotate<0, 0, 10>translate <-5, 10, 90> 
}
union{  
object {Croche
      pigment{rgb <0, 0, 1>}  finish{phong 1} 
      } 
object {Bulle}
 rotate<0, 0, 20>translate <-20, 5, 70> 
}     
      

