// Written By: Adam McCormick
//   Begun On: 4/3/06

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "metals.inc"
#include "woods.inc" 

global_settings {max_trace_level 10}  
#declare ToggleStaff = on;   
#declare ToggleHelix = on;
#declare ToggleFinal = on;
#declare ToggleLights = off; 
#declare ToggleCloud = on; 
  
#if(ToggleHelix)
  #declare TogglePlasma = on;   
#end   

#declare Examples = off;   
#declare MainCam = on;   
#declare TopCam = off;   
#declare LeftCam = off;   
#declare RightCam = off;    
#declare GridLinesXY = off;   
#declare GridLinesYZ = off;    //These do nothing as of now
#declare GridLinesZX = off; 

#if(GridLinesZX)

#end

#if(MainCam) 
  #declare CAM = 1;
  camera {                  
    location <12,15,-55>
    look_at  <-20,-20,350>
    /*location <0,25,-15>
    look_at  <0,0,0> */
  }  
   
  #if(ToggleLights) 
    light_source { <0,400,-50>, rgb <.9,.9,.8>
    
    }    
    
    light_source { <-200,-100,-50>, rgb <.9,.9,.8>
    
    }     
    
    light_source { <200,10,-50>, rgb <.9,.9,.8>
    
    }  
  #end
#end  

#if(TopCam)   
  #declare CAM = 1;
  camera {                  
    location <0,200,50>
    look_at  <0,100,50>
    /*location <0,25,-15>
    look_at  <0,0,0> */
  }  
    
  #if(ToggleLights) 
    light_source { <20,250,50>, rgb <.9,.9,.8>
    
    }    
    
    light_source { <-20,250,50>, rgb <.9,.9,.8>
    
    }  
  #end
#end 

#if(LeftCam) 
  #declare CAM = 1;
  camera {                  
    location <-100,30,60>
    look_at  <0,30,60>
    /*location <0,25,-15>
    look_at  <0,0,0> */
  }  
    
  #if(ToggleLights) 
    light_source { <0,40,-50>, rgb <.9,.9,.8>
    
    }    
    
    light_source { <0,10,50>, rgb <.9,.9,.8>
    
    } 
  #end
#end 

#if(RightCam)  
  #declare CAM = 1;
  camera {                  
    location <150,30,60>
    look_at  <0,30,60>
    /*location <0,25,-15>
    look_at  <0,0,0> */
  }  
   
  #if(ToggleLights) 
    light_source { <0,40,-50>, rgb <.9,.9,.8>
    
    }    
    
    light_source { <0,10,50>, rgb <.9,.9,.8>
    
    } 
  #end
#end  
  
#ifndef(CAM) 
  camera {                    
    location <0,20,-50>
    look_at  <0,-20,300>
  }  
   
  #if(ToggleLights) 
    light_source { <0,40,-50>, rgb <.9,.9,.8>
    
    }    
    
    light_source { <0,10,50>, rgb <.9,.9,.8>
    
    }   
  #end
#end   

#if(ToggleStaff)
  #declare StaffHeight = 16 / 2;            
  #declare NoteInitial = StaffHeight * 3 / 16; // this is the scale unit
  #declare BarLength = 1.5; // scaling factor used w/ NoteInitial   
  
  #declare StaffPoints = 9;
  #declare StaffPath = array [StaffPoints][3] {          // position, rotation, up   
    { <-600,350,600>, <-15,0,0>, <0,0,1>/sqrt(1) },
    { <-200,250,400>, <0,0,0>, <0,1,1>/sqrt(2) },
    { <100,200,425>, <90,0,-10>, <-.5,1,0>/sqrt(1.25) },
    { <200,150,450>, <90,90,0>, <-.5,1,-.5>/sqrt(1.5) },
    { <100,100,200>, <50,160,0>, <-1,1,1>/sqrt(3) }, 
    { <-100,75,300>, <25,280,-10>, <0,1,0>/sqrt(1) },
    { <100,-30,400>, <90,375,-15>, <.5,1,0>/sqrt(1.25) },
    { <200,-50,150>, <0,475,-15>, <-1,1,1>/sqrt(3) },
    { <0,30,-250>, <0,495,-15>, <-1,0,3> }} 
  
   
  #local i=0;
  #while(i<StaffPoints)   
    sphere { <0,0,0> .5      
      translate StaffPath[i][0]/4
      
      pigment { rgb <0,.3,1> }
      finish {
        diffuse .7
        ambient rgb <.3 .3 .3>
        specular .9     
        reflection { .1 }
      } 
    } 
    #local i=i+1;
  #end  
  
  #declare PlaceSpline = spline {
    natural_spline  
    #local i=0;
    #while(i<StaffPoints)
      i/(StaffPoints-1), StaffPath[i][0]/4
      #local i=i+1;
    #end
  }  
  
  #declare RotateSpline = spline {
    natural_spline  
    #local i=0;
    #while(i<StaffPoints)
      i/(StaffPoints-1), StaffPath[i][1]
      #local i=i+1;
    #end
  }  
  
  #declare UpDirSpline = spline {
    natural_spline  
    #local i=0;
    #while(i<StaffPoints)
      i/(StaffPoints-1), StaffPath[i][2]
      #local i=i+1;
    #end
  }

  
  #if(ToggleFinal)
    #declare NoteNumber = 180;   
    
    //0 is note, 1 is length
    #declare NoteList = array [NoteNumber+1][2] {                                              
      { -20,5 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }}
    
    #declare NoteList[176][0] = 12;   
    #declare NoteList[176][1] = 8; 
    
  #else 
    #declare NoteNumber = 50;   
    
    //0 is note, 1 is length
    #declare NoteList = array [NoteNumber+1][2] {                                              
      { -20,5 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, 
      { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }, { 0,0 }}
    
    #declare NoteList[42][0] = 12;   
    #declare NoteList[42][1] = 8;  
  #end
  
  #local i=0;
  #while(i<NoteNumber)   
    #if(mod(i-5,6) = 0)                    
      #declare NoteList[i][0] = mod(i-5,10); 
      #declare NoteList[i][1] = mod(i-5,11);  
    #end   
    #if(mod(i-5,3) = 0)                    
      #declare NoteList[i][0] = mod(i-5,16)-5; 
      #declare NoteList[i][1] = mod(i-5,5)+2;  
    #end  
    #if(mod(i-5,4) = 0)                    
      #declare NoteList[i][0] = mod((i-5)*5,16)-8; 
      #declare NoteList[i][1] = mod((i-5)*(i-5),5)+2;  
    #end
    #local i=i+1;
  #end 
                                            
  #declare NoteColor = 
  texture {
    pigment { rgb <.3,.3,.3> }
    finish {
      diffuse .7
      ambient rgb <.3 .3 .3>
      specular .9     
      reflection { .1 }
    } 
    
  }  
                                            
  #declare AltNoteColor = 
  texture {
    pigment { rgb <0,.3,1> }
    finish {
      diffuse .7
      ambient rgb <.3 .1 .3>
      specular .9     
      reflection { .25 }
    } 
    
  }  
  
  #declare StaffBar =
  object {Round_Box(<-1,-1,-1>, <1,1,1>, 0.25, no)
    scale NoteInitial*<.2,.5,16/5>     
    translate<NoteInitial*BarLength/2,-NoteInitial/2,StaffHeight/2>
    
    texture{NoteColor}   
  }  
  
  #declare StaffPiece =
  object {Round_Box(<-1,-1,-1>, <1,1,1>, 0.25, no)
    scale NoteInitial*<BarLength,.2,.5>     
    translate <-.5,-.25,0>    
    
    rotate x*90
    
    texture{NoteColor}   
  }  
  
  #declare Staff =   // Not used for note placement
  union {            
    object {StaffPiece}                       
    object {StaffPiece translate y*StaffHeight/3}
    object {StaffPiece translate y*StaffHeight/3*2}
    object {StaffPiece translate y*StaffHeight} 
    
    rotate x*90 
    translate <0,-NoteInitial/2,NoteInitial*.25>                                                           
  }
  
  #declare Dot =
  sphere { <NoteInitial*.75,NoteInitial*.25,0> .35*NoteInitial  
  
    texture{AltNoteColor}
  }
  
  #declare NoteDrop =
  sphere { <-.5,0,0> NoteInitial scale <1,.66,.66> rotate z*25 translate -x*NoteInitial*.25 }     
  
  #declare HalfDropBore =
  sphere { <-.5,0,0> NoteInitial scale <1,.66,.66> scale <.9,.65,1.5> rotate z*25 translate -x*NoteInitial*.3 }     
  
  #declare WholeDropBore =
  sphere { <-.5,0,0> NoteInitial scale <1,.66,.66> scale <.5,.8,1.5> rotate z*25 translate -x*NoteInitial*.45 }
  
  #declare WholeNote =
  difference {                                                          
    object {NoteDrop} 
    object {WholeDropBore}  
    
    rotate -z*25 
    translate -y*NoteInitial*.25 
  
    texture{AltNoteColor}
  }
  
  #declare QuarterNote = 
  union {  
    object {NoteDrop}  
    cylinder { <0,StaffHeight,0> <0,0,0> .25*NoteInitial }  
    sphere { <0,StaffHeight,0> .25*NoteInitial }    
  
    texture{AltNoteColor}
  }
  
  #declare HalfNote =
  difference {                                                          
    object {QuarterNote} 
    object {HalfDropBore}     
  
    texture{AltNoteColor}
  }   
  
  #declare Flag =             // future change: this should be a spline prism
  union {
    difference {
      union {                                
        object {UnitBox scale <.5,1,.2>}   
        cylinder { <.25,.25,.2> <.25,.25,-.2> .75 } 
        cylinder { <2.5,-1.75,.2> <2.5,-1.75,-.2> 2 } 
                   
        object {UnitBox scale <.5,1,.2> translate <.5,-.75,0>}                          
      }                                     
      cylinder { <-1,-2,.25> <-1,-2,-.25> 1.5 }
      cylinder { <11,-1,.25> <11,-1,-.25> 10 }    
    }   
    
    scale NoteInitial
    
    matrix 
      < 1, -1, 0,
        0, 1, 0,
        0, 0, 1,
        0, 0, 0 >
    
    scale <.6,.6,1> 
     
    texture{AltNoteColor}
  }  
  
  #declare EigthNote =
  union {
    object{QuarterNote}
    object{Flag scale <.8,.7,0> translate <.25,5*NoteInitial,0>}
  }  
  
  #declare SixteenthNote =  
  difference {
    union {
      object{QuarterNote}
      object{Flag scale <.8,.7,0> translate <.25,3*NoteInitial,0>}
      object{Flag scale <.8,.7,0> translate <.25,5*NoteInitial,0>}
    }   
  }
  
  #declare Flat =
  union {
    difference {
      union {
        object {NoteDrop rotate <0,180,65>}   
        cylinder { <0,4.5*NoteInitial,0> <0,0,0> .25*NoteInitial}  
        sphere { <0,4.5*NoteInitial,0> .25*NoteInitial } 
      }
      object {HalfDropBore rotate <0,180,60>} 
      
      rotate -z*12
    }   
    
    scale .66
    translate y*NoteInitial*.25
  
    texture{AltNoteColor}
  }
    
  #declare SharpPart =          
  cylinder { <1,0,0> <-1,0,0> 1 scale y*.25 }
    
  #declare Sharp = 
  blob { 
    threshold .6
                          
    cylinder { <1,0,0> <-1,0,0> 1 5 scale y*.25 scale y*1.5 translate y*.5}
    cylinder { <1,0,0> <-1,0,0> 1 5 scale y*.25 scale y*1.5 translate -y*.5}
    cylinder { <1,0,0> <-1,0,0> 1 5 scale y*.25 rotate z*90 translate x*.5}
    cylinder { <1,0,0> <-1,0,0> 1 5 scale y*.25 rotate z*90 translate -x*.5} 
    
    scale y*NoteInitial*1.5
    rotate -z*45
    scale y*.6
    rotate z*45   
    
    scale .6  
    translate y*NoteInitial*.5 
  
    texture{AltNoteColor} 
  } 
  
  #macro PlaceNote(noteIn,length,placement,updir,rotation) 
    #declare offsetScale = updir*StaffHeight/6; 
    #local noted = 0;  
    #local note = noteIn-.125;
  
    #switch(length)  
      #case(1)
        object {WholeNote rotate rotation+y*180 translate placement translate note*offsetScale}  
        #local noted = 1;
      #break  
      #case(2) 
        object {WholeNote rotate rotation+y*180 translate placement translate note*offsetScale} 
        object {Dot rotate rotation+y*180 translate placement translate note*offsetScale}         
        #local noted = 1;
      #break  
      #case(3) 
        object {HalfNote rotate rotation+y*180 translate placement translate note*offsetScale}     
        #local noted = 1;
      #break  
      #case(4)     
        object {HalfNote rotate rotation+y*180 translate placement translate note*offsetScale} 
        object {Dot rotate rotation+y*180 translate placement translate note*offsetScale}       
        #local noted = 1;
      #break 
      #case(5)   
        object {QuarterNote rotate rotation+y*180 translate placement translate note*offsetScale}                  //Place Note
        #local noted = 1;
      #break  
      #case(6)   
        object {QuarterNote rotate rotation+y*180 translate placement translate note*offsetScale}  
        object {Dot rotate rotation+y*180 translate placement translate note*offsetScale}           
        #local noted = 1;
      #break
      #case(7)  
        object {EigthNote rotate rotation+y*180 translate placement translate note*offsetScale}    
        #local noted = 1;
      #break 
      #case(8) 
        object {EigthNote rotate rotation+y*180 translate placement translate note*offsetScale}  
        object {Dot rotate rotation+y*180 translate placement translate note*offsetScale}         
        #local noted = 1;
      #break  
      #case(9)  
        object {SixteenthNote rotate rotation+y*180 translate placement translate note*offsetScale}   
        #local noted = 1;
      #break  
      #case(10)   
        object {SixteenthNote rotate rotation+y*180 translate placement translate note*offsetScale} 
        object {Dot rotate rotation+y*180 translate placement translate note*offsetScale}      
        #local noted = 1;
      #break 
    #end  
  
    #declare tStaffPiece = object {StaffPiece rotate rotation+y*180}
    
    
    #if(noted = 1)
      #if(note > 7)
        #local line = 8;  
        #while(line <= note)   
          object{tStaffPiece translate <0,-NoteInitial/2,NoteInitial*.25> translate placement translate line*offsetScale }
          #local line = line + 2;
        #end
      #end                                                                   //Place bars between staff and note
      
      #if(note < -1) 
        #local line = -2;  
        #while(line >= note)   
          object{tStaffPiece translate <0,-NoteInitial/2,NoteInitial*.25> translate placement translate line*offsetScale }
          #local line = line - 2;
        #end
      #end
    #end      

    union {            
      object {tStaffPiece}                       
      object {tStaffPiece translate offsetScale*2}
      object {tStaffPiece translate offsetScale*4}
      object {tStaffPiece translate offsetScale*6} 

      translate placement+<0,-NoteInitial/2,NoteInitial*.25>                                                           
    }
    
    
  #end 
  
  #macro Tween(numPoints, tVal, tOf)   
    
    #if(numPoints > 1) 
      #local NextPoints = array [numPoints-1][3]   
      #local NextPoints[0][0] = <0,0,0>;  
      #local NextPoints[0][1] = <0,0,0>;  
      #local NextPoints[0][2] = <0,0,0>;
      #local i=0;        
      #while(i<numPoints-2)                                                    
        #local NextPoints[i][0] = NewPoints[i][0]*(1-(tVal/tOf)) + NewPoints[i+1][0]*(tVal/tOf);
        #local NextPoints[i][1] = NewPoints[i][1]*(1-(tVal/tOf)) + NewPoints[i+1][1]*(tVal/tOf);
        #local NextPoints[i][2] = NewPoints[i][2]*(1-(tVal/tOf)) + NewPoints[i+1][2]*(tVal/tOf);
        #local i=i+1;
      #end
      
      #declare NewPoints = NextPoints;
            
      #if(numPoints = 2)                                                                                   
        PlaceNote( NoteList[tVal][0], NoteList[tVal][1], NewPoints[0][0], NewPoints[0][1], NewPoints[0][2] )  
      #else       
        #local newNum = numPoints-1;
        Tween(NewPoints, newNum, tVal, tOf)                                          
      #end   
                                                                                               
      
      
    #else   
      PlaceNote( NoteList[tVal][0], NoteList[tVal][1], pathPoints[0][0], pathPoints[0][1], pathPoints[0][2] )
    #end
  
  #end 

   
  #if(Examples)
    union {              
      object{Staff}       
      object{StaffBar}
      object{SixteenthNote}
      object{EigthNote translate x*3}
      object{QuarterNote translate x*6}
      object{HalfNote translate x*9}
      object{WholeNote translate x*12}
      object{Dot translate x*12}  
      object{Sharp translate -x*3}
      object{Flat translate -x*6}        
                                   
      //Tween(StaffPoints,180,NoteNumber)
      
      PlaceNote(10,8,<-10,10,-10>,<0,0,1>,<0,0,0>)
    }  
  #end    
                                          
  #local j=0;
  #while(j<NoteNumber)              
    PlaceNote(NoteList[j][0], NoteList[j][1],PlaceSpline(j/NoteNumber),UpDirSpline(j/NoteNumber),RotateSpline(j/NoteNumber))   
    #local j = j + 1;
  #end
          
#end    

#if(ToggleHelix)                 
  #declare CenterTop = <10,100,77>;    
  #declare CenterBottom = <10,-100,77>; 
  #declare BrightCenter = <10,60,77>;
  #declare HelixRadius = 20;
  #declare MinorRadius = 5;
  #declare RadialIter = 3;
  #declare VerticleIter = 200; //Up to 400 for final
  #declare Threshold = .5;
  #declare Rotations = 2;    
  
  light_source {
    .5*(CenterBottom+CenterTop) rgb <.9,.9,1>  
    looks_like{ 
      cylinder{ CenterBottom CenterTop .1 
        pigment { rgb <.8,.8,1> }   
        finish {
          diffuse .7
          ambient rgb <.3 .3 .6>
          specular .9     
          reflection { 0 }
        } 
      } 
    }
  }
                                            
  #declare HelixColor = pigment { rgb <.5,.5,.6> }   
                                            
  #declare HelixFinish = texture {
    finish {
      diffuse .7
      ambient rgb <.3 .3 .6>
      specular .9     
      reflection { .35 }
    } 
  } 
  
  #macro HelixBarColor(X) 
    rgb <0,.3,1>+mod(X,4)*<.05,.1,.1>/2
  #end
  
  #macro ThreeBarHelix(Y) 
    #local j=0;
    #while(j<RadialIter)       
      #if(TogglePlasma)
        #local l=0; 
        #while(l<VerticleIter)  
          #local Center = l/VerticleIter*CenterTop+(1-l/VerticleIter)*CenterBottom;
          #if(mod(l,15) = 0)        
            light_source{ Center, rgb <.3,.3,.65> 
            } 
          #end  
          #local l=l+1;   
        #end 
      #end
      
      blob { threshold Threshold  
        #local k=0; 
        #local UseRadius = Y*HelixRadius;
        #while(k<VerticleIter)  
          #local Center = k/VerticleIter*CenterTop+(1-k/VerticleIter)*CenterBottom;
          sphere{<UseRadius*sin(-2*pi*(Rotations*k/VerticleIter+j/RadialIter)),0,
                  UseRadius*cos(-2*pi*(Rotations*k/VerticleIter+j/RadialIter))>+Center
            Y*MinorRadius   
            1
            pigment{HelixColor}
          }  
          #if(mod(k,15) = 0)
            cylinder{<UseRadius*sin(-2*pi*(Rotations*k/VerticleIter+j/RadialIter)),0,
                      UseRadius*cos(-2*pi*(Rotations*k/VerticleIter+j/RadialIter))>+Center
              <UseRadius*sin(-2*pi*(Rotations*k/VerticleIter+mod(j+1,3)/RadialIter)),0,
               UseRadius*cos(-2*pi*(Rotations*k/VerticleIter+mod(j+1,3)/RadialIter))>+Center 
              Y*MinorRadius/3*2  
              1.5  
              pigment{HelixBarColor(k)}
            }
          #end
          #local k=k+1;
        #end
        #texture{HelixFinish}
      }                     
      #local j=j+1;
    #end 
  #end     
               
  #if(TogglePlasma)
    cylinder { 0 CenterTop-CenterBottom HelixRadius 
      hollow on
  		pigment { rgbt 1 }
  		interior {
  			media {
  				emission 1
  				absorption 1
  				density {
  					pigment_pattern {
  						gradient y
  						scale vlength(CenterTop - CenterBottom)
  						poly_wave .2
  					}
  					density_map { 
  						[0
  							rgb 0
  						]
  						[1
  							#local tmag = 1; 
  							#local ts = .5;
  							cylindrical
  							scale HelixRadius*3/2
  							scale 1/ts
  							warp {
  								turbulence tmag/ts omega .7 lambda 4 octaves 10
  							}
  							scale ts
  							scale 1/(1+tmag)
  							cubic_wave
  							colour_map {
  								[0 rgb 0]
  								[1 rgb <.6 .6 1>]
  							}
  						]
  						[2
  							rgb 0
  						]
  					}
  				}
  			}
  		}
  		
  		translate CenterBottom 
      
      finish {
        diffuse 1
        ambient rgb <.3 .3 1>
        specular 0     
        reflection { 0 }
      } 
      
    } 
  #end
  
  ThreeBarHelix(1)
  ThreeBarHelix(.25)
#end    

#if(ToggleCloud)    
  #declare Explosion = union {
    /*cylinder { 0 <0,.1,0> 100
      hollow on
    	pigment { rgbt 1 }
    	interior {
    		media {
    			emission 1
    			absorption 0
    			density {
    				pigment_pattern {
    					gradient y
    					scale vlength(.1)
    					poly_wave .2
    				}
    				density_map { 
    					[0
    						rgb 0
    					]
    					[1
    						#local tmag = 1; 
    						#local ts = .5;
    						cylindrical
    						scale 25
    						scale 1/ts
    						warp {
    							turbulence tmag/ts omega .7 lambda 4 octaves 10
    						}
    						scale ts
    						scale 1/(1+tmag)
    						cubic_wave
    						colour_map {
    							[0 rgb 0]
    							[1 rgb 1]
    						}
    					]
    					[2
    						rgb 0
    					]
    				}
    			}
    		}
    	}         
      
      finish {
        diffuse 1
        ambient rgb <.6 .6 .6>
        specular .5     
        reflection { .1 }
      } 
      
    } */
    
    sphere{ <0,0,0> 50
      hollow on
    	pigment { rgbt 1 }
    	interior {
    		media {
    			emission 1
    			absorption 1
    			density {
    				pigment_pattern {
    					gradient y
    					scale vlength(5)
    					poly_wave .2
    				}
    				density_map { 
    					[0
    						rgb 0
    					]
    					[1
    						#local tmag = 1; 
    						#local ts = .5;
    						spherical
    						scale 1
    						scale 1/ts   
    						scale 35/4
    						warp {
    							turbulence tmag/ts omega .7 lambda 4 octaves 10
    						}
    						scale ts
    						scale 1/(1+tmag)
    						cubic_wave
    						colour_map {
    							[0 rgb 0]
    							[1 rgb <.6 .6 .6>]
    						}
    					]
    				}
    			}
    		}
    	}    
    	                     	   
      finish {
        diffuse 1
        ambient rgb <.3 .3 .3>
        specular .5     
        reflection { .2 }
      } 
    }
  
  }    
    
  #if(ToggleFinal)
    object{ Explosion translate <10, 25, 77> }     
  #else
    sphere{ <10, 25, 77> 20
      
    	pigment { rgb <.7,.7,.7> }         // appx replacement, not particularly shiny
    	                     	   
      finish {
        diffuse 1
        ambient rgb <.3 .3 .3>
        specular .5     
        reflection { 0 }
      }    
    }
  #end

#end
