//  "Midnight" 
//  Topic: Music,IRTC Competition
//  10 April 2006
//  copyright Shigeyoshi M
//  http://hp.vector.co.jp/authors/VA020725/
//  sigeyosi_m@yahoo.co.jp
//------------------------------------------- 
//+A0.001 5h46m41s jitter SXGA=on 1280 x 1024 

#version 3.6;

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "stones.inc"  

#include "tokei.inc" 
#include "charamela.inc"
#include "tumbleweed.inc"
#include "wooddog.inc"

#declare SXGA=on; //SXGA(1280x1024) or XGA(1024x768)...
#declare Headlight =on;
#declare ShowLamp =on;
#declare ShowPevement =on;
#declare ShowBaseTex =on;
#declare ShowBuilding =on;
#declare ShowDog =on;
#declare ShowSky =on;

#declare Jimen = -65; //horizon

global_settings{
 assumed_gamma 2.2
 }
 
 camera { location <30,15,-300>
         look_at <0,0, -7.5>
         angle 58
         right x*image_width/image_height 
         }
     
//========================================================== 
 //in window============================================== 
 light_source { <35,22,-17.5> color 0.75 }   
 
 //--------------------------------------------------------
 // An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source {
  0*x                 // light's position (translated below)
  color rgb 1.5//1.0//       // light's color
  area_light
  <-40, 20, -28> <40, 20, 30> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  //circular            // make the shape of the light circular
  //orient              // orient light
  translate <0, 20, -28>   // <x y z> position of light
}  
//-------------------- 
//==================================================================================================
#if (Headlight)  
 //==============Car headlight ====================================================================        
          // create a point "spotlight" (conical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color rgb <1,1,1>*0.5       // light's color
  spotlight               // this kind of light source
  translate <100, 0, -500> // <x y z> position of light 
  point_at <-20, -15, 100>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
} 
     
          // create a point "spotlight" (conical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color rgb <1,1,1>*0.5       // light's color
  spotlight               // this kind of light source
  translate <180, 0, -500> // <x y z> position of light
  point_at <60, -15, 100>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
} 
#end       
//==================================================================================================


//Sky ==============================================================
#declare mySky =
object {
	sphere {<0,0,0>,5000}
	hollow
	texture {
		pigment {
			gradient y
			color_map {
				[0	color LightBlue]//down
				[1.0	color NavyBlue]//upper
			}
			scale <1,5000,1>
		}
	}  
	texture {
		pigment { dents 
		turbulence 0.5 
			octaves 3
			lambda 6.0
			color_map {
				[0.0 color rgbf <1, 1, 1, 1>]
				[0.8 color rgb <0.737, 0.788, 0.820>]
				[1.0 color rgb <1, 1, 1>]
			}
		}
		finish {
			//ambient 1.0
			diffuse 0.0
		}
		scale <3000, 1500, 2000>
	}  
	translate -65*y
}
  
#if (ShowSky)
object {mySky}
#end      
//ground===========================================================================
#declare  GroundPig =  pigment{ rgb <0.326, 0.326, 0.326> }
 object {
	plane {<0,1,0>,Jimen-2}
	pigment{ GroundPig }
	}

///================================================================================
#include "functions.inc"		
#declare Ground =
isosurface {
	function {y - f_snoise3d(x/7, 0, z/2)*0.5}
	threshold 0
	max_gradient 1.1
	contained_by {
                      box{ <-11200,Jimen-1.0, 10000>,<11200, Jimen-2, -30> }}
	texture {
		pigment {GroundPig}
		normal {granite bump_size 0.5 scale 0.1}
	}

}
object {Ground}	
//==================================================================================
	 	 
//pavement================================================================================================================== 
#declare stainPig = pigment{
       crackle
       color_map{
               [0 color rgbt <0.702, 0.702, 0.702, 1>]
               [0.7 color rgbt <0.702, 0.702, 0.702, 1>]
               [1 color rgb <0.51, 0.416, 0.322>] 
               } 
       }

#declare stainFin = finish{ crand 0.4 }
#declare jimenTex = texture{pigment{ rgb <0.263, 0.212, 0.165> }} 
#declare PavTex = texture { T_Stone44 rotate -90*y scale 0.5} 
#declare pMizo = object { box{ <-1,300,1>,<1, -300, -1> } texture{PavTex}
                         rotate 90*x}                                               
#if (ShowBaseTex)                       
#declare BasePavement = object { box{ <-200,Jimen-0.2, 0>,<200, Jimen-2, -200> } texture{PavTex}} 
#else
#declare BasePavement = object { box{ <-200,Jimen-0.2, 0>,<200, Jimen-2, -200> } texture{jimenTex} finish{stainFin}}
#end

#declare CorePavement = union {object { box{ <-200,Jimen, 0>,<200, Jimen-2, -200> }  texture{PavTex} }
                               object { box{ <-200,Jimen, 0>,<200, Jimen-2, -200> }  texture{pigment{stainPig}} }
                               } 

//----------------------------------------                               
#declare Plus = union {        
#declare  fillMizo = union{ object { box{ <-0.9,300,1>,<0.9, -300, 0> } texture{PavTex}
                       rotate 90*x } 
                     object { box{ <-0.9,300,1>,<0.9, -300, 0> }  texture{pigment{stainPig}}
                      rotate 90*x } 
                    }     
#declare MyValue = -500;
#while ( MyValue <= 500 )
       object {  fillMizo 
              translate Jimen*y 
              rotate -45*y
              translate MyValue*x
              }
       object {  fillMizo 
              translate Jimen*y 
              rotate 45*y
              translate MyValue*x
              }        
#declare MyValue = MyValue + 20;
#end  } 

#declare myPlus =            
#difference {                 
       object{  Plus }
       plane { x, 200 inverse pigment{ rgb <0.263, 0.212, 0.165> }}
       plane { x, -200 pigment{ rgb <0.263, 0.212, 0.165> }}
       plane { z, 0  inverse pigment{ rgb <0.263, 0.212, 0.165> }}
       plane { z, -200 pigment{ rgb <0.263, 0.212, 0.165> }}
         }  
//----------------------------                                      
#declare myPavement = union {
difference {
       object { CorePavement
       }  
#declare MyValue = -300;
#while ( MyValue <= 300 )
       object { pMizo 
              translate Jimen*y 
              rotate -45*y
              translate MyValue*x
              }
       object { pMizo 
              translate Jimen*y 
              rotate 45*y
              translate MyValue*x
              }        
#declare MyValue = MyValue + 20;
#end         
         }
         object {  myPlus }//------- 
            }
    //-----------------------------------------------            
#if (ShowPevement)             
object { myPavement 
       translate -30*z}
       object { BasePavement 
       translate -30*z } 
#else
object { box{ <-200,Jimen, 0>,<200, Jimen-2, -200> }  texture{GroundPig} }

#end
//===========================================================================================
object{Tumbleweed
       rotate -45*z
       translate 1.5*y
       scale 10
       translate <0,-65,-50>}
//===========================================================================================          
//Show Window & building---------------xyz 200  90  130------------------------------------ 
#declare rTex =  texture { T_Stone8 rotate -90*y scale 0.5}//scale 1.5 }
#declare wTex = texture {pigment{ rgbf <0.761, 0.839, 0.886, 0> }} 
#declare rFin = finish{ crand 0.1 } 
#declare rNor = normal{ bumps 0.3 scale 0.2 }
#declare MizoH = object { box{ <-215,-0.25,-29>,<215, 0.25, -31> } texture{rTex} 
        finish{ rFin }
        normal{ rNor }
       } 
#declare MizoV = object { box{ <-0.25,Jimen-3,-29>,<0.25, 155, -31> } texture{rTex} 
        finish{ rFin }
        normal{ rNor }
       }
    
//---------------------------------------------------- 
#declare W_Haba = 40; //width
#declare myWindow = difference {
  object { box{ <-105,Jimen-2,105>,<105, 55, -30> } 
         texture{rTex} 
        finish{ rFin }
        normal{ rNor }
       } 
  //in space
  object { box{ <-W_Haba,-10,100>,<W_Haba, 20, -100> } texture{wTex} 
      } 
  //light area
  object { box{ <-W_Haba,19,30>,<W_Haba, 25, -28> } texture{wTex} 
      }     
        
  //Mizo
    object{MizoH}
    object{MizoV}      

   } //end_diff 
//------------------------------------   
   
#declare myWall = union {
         object { box{ <-W_Haba,-10,100>,<W_Haba, 20, 99.9> } 
         texture{pigment{ rgb <0.228, 0.267, 0.243> }}
         finish{ crand 0.1 }
            }  
            object {Tokei
            translate <20, 5, 99.9>}
           }   
    
//Waku----- frame + glass-------------------------------------------
#declare WakuTex = texture{Soft_Silver} 
#declare myMaterial = material {  M_NB_Glass }

#declare Waku =
difference {
     object { box{ <-W_Haba-2,-12,-29.5>,<W_Haba+2, 22, -32> }  
       texture {WakuTex}
      }
      
      object { box{ <-W_Haba+0.5,-9.5,-29.0>,<W_Haba-0.5, 19.5, -35> }
       texture {WakuTex}
      }
        
    //glass hole
      object { box{ <-W_Haba+0.5,-10,-29.5>,<W_Haba-0.5, 20, -30> }
        texture {WakuTex}
        translate -0.5*z
              }
            } 
//=======================================================
//Text
#declare Text_Color = pigment{ rgb <1, 1, 1> }
#declare myText = 
object {
	text {  ttf
		"timrom.ttf",
		"Chie Ushiyama & CO.",
		0.2,
		<0, 0, 0>
	     }
	pigment{ Text_Color}
        finish { specular 0.2 }
	scale 4.5
     translate < -20, 10, -30.5>
} 
            
//=======================================================
#declare myBuilding =
union {
     object { myWindow
     finish { ambient 0.3 
     diffuse 0.4 }
     }
	
     object {myWall translate -30*z}
   //glass
     object { box{ <-W_Haba-0.5,-10,-29.5>,<W_Haba-0.5, 20, -30> }
        material { myMaterial }
        translate -0.5*z
              }
    //Waku
     object { Waku}
    //Text
     object {myText}
    
     }
//=========================================================
// steps.

#declare Dai = prism {
  linear_spline
  linear_sweep
  0, 1, 9
  <cos(radians(0*45)), sin(radians(0*45))>,
  <cos(radians(1*45)), sin(radians(1*45))>,
  <cos(radians(2*45)), sin(radians(2*45))>,
  <cos(radians(3*45)), sin(radians(3*45))>,
  <cos(radians(4*45)), sin(radians(4*45))>,
  <cos(radians(5*45)), sin(radians(5*45))>,
  <cos(radians(6*45)), sin(radians(6*45))>,
  <cos(radians(7*45)), sin(radians(7*45))>,
  <cos(radians(0*45)), sin(radians(0*45))>
  rotate 22.5*y
}

#declare Stage = 
  object {
    Dai
    scale <20, 4, 20>
    translate <0, 0, 0>
  } 

//======================================	
//Dog & Charamela	
//-6
#declare Dog_Charamela =
union {	
 object {Wood_dog}         
          
 object { Charamela 
       rotate -115*x  
       translate -18*z + -1.3*y
          }
    //Dai (stand)
 object { Stage
        texture {T_Stone41}
        translate -10*y + -9*z
              } 
      translate 9*z        
      rotate -45*y 
       } //end_union  
    
//==============================================================
#if (ShowBuilding)
object {myBuilding}
#end

#if (ShowDog)
object {Dog_Charamela}
#end
    
//Lamp post====================================================  
#if (ShowLamp)   
#include "lamppost.inc"
   object { Lamppost 
   scale 0.7 
   #if (SXGA)
     translate < -30+1.25, -60, -150.5-3.5>
   #else
     translate < -30, -60, -150.5>
   #end
          }
//Lamp light====================
light_source {
   //<-30, 179*0.7-60, -150.5>
   #if (SXGA)
     <-30+1.25, 182*0.7-60, -150.5-3.5> 
   #else
      <-30, 182*0.7-60, -150.5>
   #end   
 
color rgb <0.906, 0.894, 0.592>
area_light <1, 0, 0>, <0, 1, 0>, 5, 5
adaptive 1
jitter
looks_like { Lamp }
}
#end
//================================================================= end ============                          