//              Render the file with the same aspect ratio as in dreamy.pov (16:9).

#declare maxdist_trace = 0; // first run -> 1 (result can be seen in the editor window) / second run -> 0

#if (maxdist_trace = 0)
        #declare ftname = "veg_flower2.inc"
        #warning concat (ftname," veg_manythings file creation start\n")
        #fopen filehandle ftname write  
#end

#include "functions.inc"  
#include "transforms.inc"

#declare fak = 0.038;
#declare fek = 200;
#declare P = function {pattern {bumps scale 0.1}}
#declare f_pigm2 = function {pigment {bumps}}
#declare manytrees_area =
isosurface {
        function {
                y
                -P(x,0,z)
                -f_noise3d(x*250*fek,y*250*fek,z*250*fek)*fak*0.5
                -f_pigm2(x*75*fek,y*75*fek,z*75*fek).x*fak*1.5
                +f_pigm2(x*150*fek,y*150*fek,z*150*fek).z*fak*1.5                
        }
        contained_by {box {0,1}}        
        translate <-0.5,0,0>
        scale <50,0.5,50>  
        translate -z*10
}        

//_________________________________________________________________

#if (maxdist_trace = 1)
        #declare max_dist = 0.000001;
#else
        #declare max_dist = 50;       // from a former run with #declare maxdist_trace = 1; -> see first lines
#end

// code ideas from http://www.spiritone.com/~english/cyclopedia/background.html

#declare cam_loc = <0,1.5,-8>;
#declare lookat = <1,0.5,0>;
#declare cam_ang = 67;
#declare cam_mirror = 1;                                                 // 1 for normal / -1 for mirror image
#declare cam_z = 0.5*image_width/image_height/tan(radians(cam_ang*0.5)); // the amount of camera zoom you want
#declare cam_ang_up = degrees(2*atan2(0.5/cam_z,1));                     // camera angle in cam_up direction
#declare back_dist = 1;                                                  // how far away the background is
#declare cam_a = cam_mirror*image_width/image_height;                    // camera aspect ratio
#declare cam_s = y;                                                      // camera sky vector
#declare cam_d = vnormalize (lookat-cam_loc);                            // camera direction vector
#declare cam_r = vnormalize (vcross(cam_s,cam_d));                       // camera right vector
#declare cam_up = vnormalize (vcross(cam_d,cam_r));                      // camera up vector
#declare cam_dir = cam_d*cam_z;                                          // direction vector scaled
#declare cam_right = cam_r*cam_a;                                        // right vector scaled

#declare fz = vlength(cam_dir);
#declare fx = vlength(cam_right)/2;
#declare fy = vlength(cam_up)/2; 

#macro OrientZ(p1,p2,cs)          // looks like Reorient_trans macro!
        #local nz = vnormalize(p2-p1);
        #local nx = vnormalize(vcross(cs,nz)); 
        #local ny = vcross(nz,nx);
        matrix <nx.x,nx.y,nx.z,ny.x,ny.y,ny.z,nz.x,nz.y,nz.z,p1.x,p1.y,p1.z>          
#end

#declare view_paint =
box { 
        <0,0,0> <1,1,0.1>
        pigment {color rgb 1}
        translate <-0.5,-0.5,0>
        scale 2*<cam_mirror*fx,fy,0.5>
        translate fz*z
        scale back_dist
        OrientZ (cam_loc,lookat,cam_up)
}

#declare view_pig =  
pigment {
        image_map {tga "music_flowers1" once map_type 0 interpolate 2} // "effect" image
        translate <-0.5,-0.5,0>
        scale 2*<cam_mirror*fx,fy,0.5>
        translate fz*z
        scale back_dist
        OrientZ (cam_loc,lookat,cam_up)
}

#declare r1 = seed(1);
#declare r2 = seed(1);
#declare r3 = seed(1);
#declare r4 = seed(1); 
#declare n = 0;
#declare things_numb = 100;
#if (maxdist_trace = 1)
        #declare things_numb = things_numb*100;
#end
#declare min_dist = 2000;
#debug "manythings\n"
#while (n < things_numb)
        #declare rnd_y = vaxis_rotate (cam_d,vcross (cam_d,cam_up),(rand(r1)-0.5)*cam_ang_up);
        #declare rnd_xy = vaxis_rotate (vnormalize (rnd_y),cam_up,(rand(r3)-0.5)*cam_ang);
        #declare Norm = <0,0,0>;
        #declare Inter = trace (manytrees_area,cam_loc,rnd_xy,Norm);
        #declare NormP = <0,0,0>;
        #declare InterP = trace (view_paint,cam_loc,rnd_xy,NormP);
        #if ((vlength (Norm) != 0)&(vlength (NormP) != 0)&(eval_pigment(view_pig,InterP).x*rand(r3) > 0.3))
                #if (maxdist_trace = 1)                        
                        #declare randdist = -1;
                #else
                        #declare randdist = rand(r4);
                #end
                #declare ab = (0.7+0.6*rand(r1))*0.8;
                #declare ac = 360*rand(r2);
                #declare ad = 20*rand(r2);
                #declare ae = 360*rand(r2); 
                #if (maxdist_trace = 1)
                        #declare p = vlength(cam_loc-Inter);
                        #if (p > max_dist)
                                #declare max_dist = p;
                        #end 
                        #if (p < min_dist)
                                #declare min_dist = p;
                        #end                       
                #else        
                        #declare aa = int(2*rand(r1));
                        #write (filehandle,"object {flower1[",aa,"] scale ",ab," rotate y*",ac," rotate <",ad,",",ae,",0> translate ",Inter,"} // ",n+1,"\n")
                #end
                #declare n = n+1; 
        #end
        #if(mod(n,100) = 0)
                #debug concat(str(n,0,0)," things\n")
                #debug concat(str(max_dist,0,3)," max_dist\n")
                #debug concat(str(min_dist,0,3)," min_dist\n")
        #end        
#end    
#if (maxdist_trace = 1)
        #debug concat(str(max_dist,0,5)," max_dist\n")
#end