// Perfection
#version 3.7;
#include "std.inc"
#include "skeleton.inc"

SCREAM(0)

//cam2(<0,0,-4>,<0,0,1>)
//cam2(<-2,20,-3>,<0.8,-1.3,-0.2>)       
cam2(<-10,7,-3>,<0.8,-1.3,-0.2>)       //goodi
//cam2(<-10,0,-3>,<1,0,0>)               //top from plain side
//cam(<-6,2,-2>,<0,0,0>)
//cam(<0,0.1,0>,<-1,0,-1>)              //tight top
//cam_hover(SCENE,<0,100,0>,<0,-1,0>,Pside*0.8)  //full pyramid from top
//cam(<0,0.25,-2>,<0,0.25,0>)          //clarinet
//cam(<0,1,2.3>,<0,0.8,0>)          //skeleton
//cam(<0,1.6,1.2>,<0,1.6,0>)          //skeleton head
//cam(<0,0.5,1.2>,<0,0.5,0>)          //skeleton leg
//#declare loc=loc+0.5*x;

///////////////////////// Scene Options

#declare GREEN_CRACKS=0; //0
#declare STONE_CRACKS=0; //0
#declare STEEN_CRACKS=5;  //5
#declare STEEN_CRACKS_R=5; //5
#declare SPRINKLE_STONES=200;  #declare SPRINKLE_STONES_R=30;  #declare SPRINKLE_STONES_P=2;
#declare SPRINKLE_GRIMS=0; //0
#declare PUT_GRIMS=7;  #declare PUT_GRIMS_LOC=array[PUT_GRIMS]{<1,0,-5>,<-5,0,-2>,<-7,0,2>,<-8,0,0>,<-4,0,-10>,<4.5,0,-14.5>,<-6.5,0,-6.5>};
//#declare PUT_GRIMS=0; //7
#declare SPOTLIGHT=1; //1
#declare FOG=1; //1
#declare CLOUDS=10;  //10
#declare TOPGRIM=1; //1
#declare CLARINET=1; //1
#declare PYRAMID_LEVEL=1; //1
#declare PYRAMID_SKIPLEVEL=20; //50

#declare CLOUD_h1=1;
#declare CLOUD_t1=<1,1,1,0.6>;
#declare CLOUD_s1=30;
#declare CLOUD_d1=0.9;
#declare CLOUD_h2=-100.191;
#declare CLOUD_t2=<1,1,0.1,0.6>;
#declare CLOUD_s2=0.4;
#declare CLOUD_d2=0.9;

#declare Pstep_n=100;
#declare Pstep_h=1;
#declare Pstep_w=1;
#declare Pstep_h_w=Pstep_h/Pstep_w;
#declare Pstep_top_size=5;

#declare Pside=Pstep_top_size+2*(Pstep_n-1)*Pstep_w;
#declare Pheight=Pstep_h*Pstep_n;

#declare Pblock_siz=<2,1,1>;
#declare Pblock_ob=stoneblock(0,Pblock_siz);
#declare Pblock_tex=tex_stone;
#declare Pblock_leave=<0,0,0>;
#declare Pblock_layout=1;
#declare Pblock_options=<0,0,0,0,0>;
#declare Pblock_minsiz=<Pblock_siz.x*0.7,Pblock_siz.y/2,Pblock_siz.z/2>;
#declare Pblock_ROT=3;
#declare Pblock_SHIFT=0.03;
#declare Pblock_DEVIATE=0.1;
#declare Pblock_deviate=<Pblock_siz.x*0.3,0,0>+Pblock_DEVIATE*Pblock_siz*<0,1,1>;
#declare Pblock_rot=Pblock_ROT*<1,1,1>;
#declare Pblock_shift=Pblock_SHIFT*Pblock_siz*<1,1,1>;


#declare L=0.0;  //camera light
#declare SL=1;  //sun light

/////////////////////////
//pigment{color <0.51,0.49,0.11>} normal {bumps 0.6 scale 0.025}
/////////////////////////



#macro clarinet(tex_wod,tex_met)
   union{
      #local S0=0;     #local DS0=-0.5;
      #local S1=0.014; #local DS1=0;

      #local B1=0.017; #local DB1=0.05; #local WB1=0.010; #local TB1=0.002;
      #local B2=0.019; #local DB2=0.075; #local WB2=0.010; #local TB2=0.002;
      #local B3=0.021; #local DB3=0.10; #local WB3=0.010; #local TB3=0.002;

      #local SE1=0.024; #local DE1=0.20; #local WE1=0.013; #local TE1=0.002;
      #local SC=0.021; #local DC=0.5;
      #local SE2=0.024; #local DE2=0.86; #local WE2=0.014; #local TE2=0.002;
      #local S21=0.03; #local DS21=0.95;
      #local S2=0.06; #local DS2=1;
      #local S3=0.10; #local DS3=1.1;

      #local H=1;
      
      difference{
         sor{11,
            <S0  ,DS0>
            <S1  ,DS1>

            <B1 ,DB1>
            <B2 ,DB2>
            <B3 ,DB3>

            <SE1 ,DE1>
            <SC  ,DC>
            <SE2 ,DE2>
            <S21 ,DS21>
            <S2  ,DS2>
            <S3  ,DS3>
      
            open
            texture{tex_wod}
         }
         object{planeat(<1.3,1,0>,<S1*0.95,0,0>) texture{tex_wod}}
      }
      torus{S2,S2/10 translate <0,H,0> texture{tex_met}}
      object{ ring(<0,DE1,0>,<0,1,0>,WE1,SE1,TE1) texture{tex_met} }
      object{ ring(<0,DE2,0>,<0,1,0>,WE2,SE2,TE2) texture{tex_met} }
      object{ ring(<0,DB1,0>,<0,1,0>,WB1,B1,TB1) texture{tex_met} }
      object{ ring(<0,DB2,0>,<0,1,0>,WB2,B2,TB2) texture{tex_met} }
      object{ ring(<0,DB3,0>,<0,1,0>,WB3,B3,TB3) texture{tex_met} }
      translate <0,-0.5,0>
      rotate <0,0,90>
   }
#end
   
#macro pyramid(LEVEL)
   #declare R1=seed(0);
   union{
      #local n=0;
      #local siz=Pstep_top_size/2;
      #local hei=0;
      #while(n<Pstep_n)
         #if(LEVEL=0 | n>PYRAMID_SKIPLEVEL)
            object{box{<-siz,hei,-siz> <siz,hei-Pstep_h,siz>} texture{tex_stone}}
         #else
            #if(LEVEL=1)
               #if(n=0)
                  #declare Pblock_leave=<0,0,0>;
               #else
                  #declare Pblock_leave=<siz-Pstep_w*2,0,siz-Pstep_w*2>;
               #end
   //            #declare Pblock_rot=<Pblock_ANG*n,Pblock_ANG*n,Pblock_ANG*n>;
   //            #declare Pblock_layout=1-(n>10);
               object{blockfill(<siz*2,Pstep_h,siz*2>, Pblock_ob,Pblock_siz,Pblock_tex, Pblock_leave,Pblock_layout,Pblock_options,Pblock_minsiz, Pblock_deviate,Pblock_rot,Pblock_shift)  translate <0,hei-Pstep_h/2,0>}
   //            object{box{<-siz,hei,-siz> <siz,hei-Pstep_h,siz>} texture{pigment{rgbft<0,0,1,0,0.9>}}}
            #end
         #end
         #local n=n+1;
         #local siz=siz+Pstep_w;
         #local hei=hei-Pstep_h;
      #end
   }   
#end

#declare TOPGRIMpose=array[14]{
   <2,10,-73>,<0,0,0>,
   <30,20,0>,<0,0,0>,<0,0,0>,
   <70,25,0>,<45,-20,0>,<0,45,0>,
   <0,0,0>,<0,0,0>,<0,70,0>,
   <20,-10,0>,<0,10,0>,<0,40,20>
}
#declare TOPGRIMobject=object{
   Skeleton(TOPGRIMpose)
   rotate 90*x rotate 33*y translate <0,0.06,0>
}

#declare SCENE=union{
   #local R1=seed(0);

   // The Pyramid
   #declare Opyramid=object{pyramid(PYRAMID_LEVEL)};
   #if(SPRINKLE_STONES)
      #declare Opyramid=sprinkle1p(R1,Opyramid,stoneblock(R1,1),SPRINKLE_STONES_P, <0,1000,0>,<SPRINKLE_STONES_R,0,0>,<0,0,SPRINKLE_STONES_R>, <0,-Pheight,0>,<SPRINKLE_STONES_R,0,0>,<0,0,SPRINKLE_STONES_R>, SPRINKLE_STONES,0.1,0.6,0,360)
   #end
   
   //   #declare Opyramid=errode(R1,object{Opyramid},sphere{<0,0,0>,1 scale <0.1,1,0.1> texture{tex_stone}}, <0,1000,0>,<Pside,0,0>,<0,0,Pside>, <0,-Pheight,0>,<Pside,0,0>,<0,0,Pside>, 100,0.05,0.5,1,180)
   //   #declare Opyramid=errode(R1,object{Opyramid},stoneblock(1), <0,1000,0>,<Pside,0,0>,<0,0,Pside>, <0,-Pheight,0>,<Pside/2,0,0>,<0,0,Pside/2>, 10,0.1,0.3,0,180)
   //   #declare Opyramid=sprinkle1(R1,object{Opyramid},sphere{<0,0,0>,1 scale <1,1,1> texture{tex_stone}}, <0,1000,0>,<Pside,0,0>,<0,0,Pside>, <0,-Pheight,0>,<Pside,0,0>,<0,0,Pside>, 10,1,1,0,360)
   //   #declare Opyramid=sprinkle1(R1,object{Opyramid},sphere{<0,0,0>,1 translate <0,0.5,0> pigment{rgb<2,2,2>}}, <0,1000,0>,<Pside,0,0>,<0,0,Pside>, <0,-Pheight,0>,<Pside,0,0>,<0,0,Pside>, 100,0.1,0.3,0,360)


   //STONE CRACKS
   #if(STONE_CRACKS)
      #declare Opyramid=union{
         object{Opyramid}
         cracks(R1,
            Opyramid,
            cylinder{0,x,0.04 texture{tex_stone}},
            sphere{0,0.04  texture{tex_stone}},
            3,
            <8,0.05,0.2>, <0.5,0.3>, <0,0.5,0.8>,
            0,
            STONE_CRACKS,
            <0,1000,0>,<Pside/2,0,0>,<0,0,Pside/2>,
            <0,-Pheight,0>,<Pside/2,0,0>,<0,0,Pside/2>
         )
      }
   #end
   
   //GREEN CRACKS
   #if(GREEN_CRACKS)
      #declare Opyramid=union{
         object{Opyramid}
         cracks(R1,
            Opyramid,
            cylinder{0,x,0.03 pigment{rgb<0,1,0>}},
            sphere{0,0.03 pigment{rgb<0,0,1>}},
            3,
            <8,0.05,0.5>, <0.5,0.3>, <0,0.5,0.8>,
            0,
            GREEN_CRACKS,
            <0,1000,0>,<Pside/2,0,0>,<0,0,Pside/2>,
            <0,-Pheight,0>,<Pside/2,0,0>,<0,0,Pside/2>
         )
      }
   #end

   #declare R2=seed(1);

   #if(STEEN_CRACKS)
      #local steen=STEEN_CRACKS;
      #declare Opyramid=union{
         object{Opyramid}
         #while(steen>=0)
            cracks(R2,
               Opyramid,
               sphere{0,0.5 scale <1,0.02,0.02> translate <0.5,0,0> texture{tex_stone} texture{pigment{rgbt<0,1,0,0.3+0.7*steen/STEEN_CRACKS>}}},
               sphere{0,0.1 texture{tex_stone} texture{pigment{rgbt<0,0,1,steen/STEEN_CRACKS>}}},
               1, //put
               <9,0.03,1>, <0.5,0.1>, <0.3,0.3,0.8>,
               0,
               1,
               <0,1000,0>,<1,0,0>,<0,0,1>,
               <0,-Pheight,0>,<STEEN_CRACKS_R,0,0>,<0,0,STEEN_CRACKS_R>
            )
         
            #local steen=steen-1;
         #end
      }
   #end
   object{Opyramid}
   
   #if(CLARINET=1)
      object{clarinet(tex_black,tex_gold) rotate <0,20,0> translate <0,0.1,0>}
   #end
   #if(SPRINKLE_GRIMS)
      #local grimcount=0;
      #local hit=<0,0,0>;
      #local norm=<0,0,0>;
      #local yep=0;
      #while(grimcount<SPRINKLE_GRIMS)
         #local DIV=4;
         p2phit(R1,object{Opyramid}, loc,<1,0,0>,<0,0,1>, <0,-Pheight,0>,<Pside/2,0,0>,<0,0,Pside/2>, hit,norm,yep)
         #if(yep=1)         
            object{clarinet(tex_black,tex_gold) rotate<0,rand(R1)*360,0> translate hit}
            #local newgrim=TOPGRIMpose;
            array_diff(R1,14,newgrim,<30,30,30>)
            object{
               Skeleton(newgrim)
               translate<0,-0.85,0> rotate 90*x rotate 33*y translate hit+<0,0.06,0>
            }
         #end
         #local grimcount=grimcount+1;
      #end
   #end
   #if(PUT_GRIMS>0)
      #local grimcount=0;
      #local grimcount=0;
      #local hit=<0,0,0>;
      #local norm=<0,0,0>;
      #local yep=0;
      #while(grimcount<PUT_GRIMS)
         p2phit(R1,object{Opyramid}, (PUT_GRIMS_LOC[grimcount]*<1,0,1>+<0,1000,0>),<1,0,0>,<0,0,1>, PUT_GRIMS_LOC[grimcount],<0.11,0,0>,<0,0,0.1>, hit,norm,yep)
         #if(yep=1)         
            object{clarinet(tex_black,tex_gold) rotate<0,rand(R1)*360,0> translate hit}
            #local newgrim=TOPGRIMpose;
            array_diff(R1,14,newgrim,<30,30,30>)
            object{
               Skeleton(newgrim)
               translate<0,-0.85,0> rotate 90*x rotate 33*y translate hit+<0,0.06,0>
            }
         #end
         #local grimcount=grimcount+1;
      #end
   #end
      
   #declare cnt=0;
   #declare R1=seed(0);
   #while(cnt>0)
   //   object{drop(object{clarinet(1) rotate <0,rand(R1)*360,rand(R1)*10>},Opyramid,<(rand(R1)-0.5)*Pstep_w*Pstep_n,100,(rand(R1)-0.5)*Pstep_w*Pstep_n>,-y) texture{tex_gold}}
      object{
//#macro drop(ob,world,p1,d)
         drop(
            object{fig rotate <0,rand(R1)*360,rand(R1)*10>},
            Opyramid,
            rnds(R1)*Pstep_w*Pstep_n*<rnds(R1),0,rnds(R1)>+<0,200,0>,
            -y)}
      #declare cnt=cnt-1;
   #end
//   object{fig scale 2 translate <-3,-2,-3>}
//   object{stoneblock(<2,1,1>) scale 1 translate <-5,0,-5> }
}


#if(SPOTLIGHT=1)
   light_source {
     <-10, 15, -5> color rgb<1, .3, .3> * 50
     spotlight
     point_at <0, 0, 0>
     radius 1
     falloff 5
     tightness 1
     media_attenuation on
   }
#end

object{SCENE}

#if(CLOUDS>0)
   #local i=0;
   #while(i<=CLOUDS)
      planecloud(
         (CLOUD_h1+i*(CLOUD_h2-CLOUD_h1)/CLOUDS)*y,
         (CLOUD_t1+i*(CLOUD_t2-CLOUD_t1)/CLOUDS),
         (CLOUD_s1+i*(CLOUD_s2-CLOUD_s1)/CLOUDS),
         (CLOUD_d1+i*(CLOUD_d2-CLOUD_d1)/CLOUDS)
      )
      #local i=i+1;
   #end
#end

#if(FOG=1)
   fog{distance 20 rgbt <0.2,0.25,0.1,0.2> turbulence 10}
#end

#if(TOPGRIM)
   object{TOPGRIMobject translate<-2,0,-2>}
#end

light_source {loc rgb <1, 0.9, 0.8>*L}
light_source {<-3000, 1000, -850> rgb <1,0.9,0.8>*SL}
camera {right 1.6*x location loc look_at locat} 

SCREAM(1)
