#include "Colors.inc"
#include "functions.inc"
#include "transforms.inc"

////////////////////////////////////////////////////////////////////////////////////////// Constants

#declare EA=0.001;
#declare E45=sqrt(0.5);

////////////////////////////////////////////////////////////////////////////////////////// Variables

#declare RAN=seed(0);

////////////////////////////////////////////////////////////////////////////////////////// Basic macros

#macro p2phit(R,ob, ac,au,av, bc,bu,bv, hit,norm,yep)
   #local PA=ac+au*rnds(R)+av*rnds(R);
   #local PB=bc+bu*rnds(R)+bv*rnds(R);
   #declare norm=<0,0,0>;
   #declare hit=trace(ob,PA,PB-PA,norm);
   #if((vlength(norm)!=0) | (vlength(hit)!=0)) #declare yep=1; #else #declare yep=0; #end
#end

#macro p2phitp(R,ob,powr, ac,au,av, bc,bu,bv, hit,norm,yep)
   #local PA=ac+au*rndps(R,powr)+av*rndps(R,powr);
   #local PB=bc+bu*rndps(R,powr)+bv*rndps(R,powr);
   #declare norm=<0,0,0>;
   #declare hit=trace(ob,PA,PB-PA,norm);
   #if((vlength(norm)!=0) | (vlength(hit)!=0)) #declare yep=1; #else #declare yep=0; #end
#end

#macro stretch(ob,p0,p1,xlen)  object{ ob scale<vlength(p1-p0)/xlen,1,1> Reorient_Trans(x,p1-p0) translate p0 }  #end
#macro sphere2(p0,p1,siz) object{stretch(sphere{0,1 scale <0.5,siz,siz> translate <0.5,0,0>},p0,p1,1)} #end
#macro sphere2alookup(n,a,s,over,i)
   #local p=array[2];
   #local p[0]=a[i];
   #local p[1]=a[i+1];
   #if(i>0) #local p[0]=p[0]+(a[i-1]-a[i])*over; #end
   #if(i<n-1) #local p[1]=p[1]+(a[i+1]-a[i])*over; #end
   p
#end
#macro sphere2ado(n,a,s,over,i)
   #local p=sphere2alookup(n,a,s,over,i);
   sphere2(p[0],p[1],s[i])
#end
#macro sphere2a(n,a,s,over)
   union{
      #local i=0;
      #while(i<n)
         sphere2ado(n,a,s,over,i)
         #local i=i+1;
      #end
   }
#end
#macro cutspheres(ob,n,a,s,over)
   #local sp=array[n];
   #local i=0;
   #while(i<n)
      #local o=difference{box{-1000,1000} sphere2ado(n,a,s,over,i)};
      #local sp[i]=difference{object{ob} object{o}};
      #local i=i+1;
   #end
   sp
#end
#macro array_union(n,a)
   union{
      #local i=0;
      #while(i<n)
         object{a[i]}
         #local i=i+1;
      #end
   }
#end

#macro place(ob,n,p)
   union{
      #local i=0;
      #while(i<n)
         object{ob translate p[i]}
         #local i=i+1;
      #end
   }
#end

#macro array_mul(n,a,c)
   #local i=0;
   #local b=a;
   #while(i<n)
      #local b[i]=b[i]*c;
      #local i=i+1;
   #end
   b
#end

#macro array_diff(R,n,a,c)
   #local i=0;
   #while(i<n)
      #declare a[i]=a[i]+rndpsv(R,c);
      #local i=i+1;
   #end
#end

#macro cracks(R, ob,obdrop,obnode,put, Iter_CLM,Divide_VD,Height_VD, rot, amount, ac,au,av, bc,bu,bv )
   #local succ=0;
   union{
      #local hit1=0; #local hit2=0; #local norm=0; #local yep=0;
      object{ob}
      #local n=amount;
      #while(n>0)

         p2phit(R,ob, ac,au,av, bc,bu,bv,hit1,norm,yep)
         #if(yep=1)
            p2phit(R,ob, ac,au,av, bc,bu,bv,hit2,norm,yep)
            #if(yep=1)
               crack(R, ob,obdrop,obnode,put, Iter_CLM,Divide_VD,Height_VD, rot, hit1,hit2, ac,ac-bc)
               #local succ=succ+1;
            #end
         #end

         #local n=n-1;
      #end
   }
//   #debug concat("put ",str(succ,0,0)," cracks\n")
#end

#macro crackit(R, ob,obdrop,obnode,put, Iter_CLM,Divide_VD,Height_VD, rot, p0,p1, bc,bup )
   #if(vlength(p0-p1)<Iter_CLM.y | Iter_CLM.x<=0)
      #if( vlength(p0-p1)>Iter_CLM.y*0.1 & vlength(p0-p1)<Iter_CLM.z)
         #if(put=1 | put=3)
            object{
               obdrop
               rotate <rot*rnds(R),0,0>
               scale <vlength(p0-p1),1,1>
   //            rotate <0,0,90>
               Reorient_Trans(x,p1-p0)
   //            Point_At_Trans(p1-p0)
               translate p0
            }
         #end
         #if(put=2 | put=3)
            object{obnode translate p1}
         #end
      #end
   #else
      #local ITER_CLM=<Iter_CLM.x-1,Iter_CLM.y,Iter_CLM.z>;
      #local DIVIDE=Divide_VD.x+Divide_VD.y*rnds(R);
      #local HEIGHT=Height_VD.x+Height_VD.y*rnds(R);
      #local HDIR=vnormalize(vcross(bup,p1-p0));
      #local PT=p0+(p1-p0)*DIVIDE+HDIR*HEIGHT;
      #local HEIGHT_VD=Height_VD*<Height_VD.z,Height_VD.z,1>;
      
      #local NORM=<0,0,0>;
      #local HIT=trace(ob,bc,PT-bc,NORM);
      #if((vlength(NORM)!=0) | (vlength(HIT)!=0))
         crackit(R,ob,obdrop,obnode,put, ITER_CLM,Divide_VD,HEIGHT_VD, rot, p0,HIT, bc,bup)
         crackit(R,ob,obdrop,obnode,put, ITER_CLM,Divide_VD,HEIGHT_VD, rot, HIT,p1, bc,bup)
      #end
   #end
#end

#macro crack(R, ob,obdrop,obnode,put, Iter_CLM,Divide_VD,Height_VD, rot, p0,p1, bc,bup )
   #if(put=2 | put=3)
      object{obnode translate p0}
   #end
   crackit(R, ob,obdrop,obnode,put, Iter_CLM,Divide_VD,Height_VD, rot, p0,p1, bc,bup )
#end
               
#macro errode(R,ob,obdrop, ac,au,av, bc,bu,bv, amount,siz0,siz1,sizeq,rot)
   difference{
      object{ob}

      #local n=amount;
      #while(n>0)
         #local pa=ac+au*rnds(R)+av*rnds(R);
         #local pb=bc+bu*rnds(R)+bv*rnds(R);
         #local norm=<0,0,0>;
         
         #local hit=trace(ob,pa,pb-pa,norm);
         #if(vlength(norm)!=0 | vlength(hit)!=0)
            #if(sizeq) #local SCL=(siz0+(siz1-siz0)*(R)); #else #local SCL=(siz0+(siz1-siz0)*rndv(R)); #end
            object{obdrop scale SCL rotate (rot*rndsv(R)) translate hit}
         #end
         #local n=n-1;
      #end
   }
#end

#macro sprinkle1(R,ob,obdrop, ac,au,av, bc,bu,bv, amount,siz0,siz1,sizeq,rot)
   union{
      #local hit=0; #local norm=0; #local yep=0;
      object{ob}
      #local n=amount;
      #while(n>0)

         p2phit(R,ob, ac,au,av, bc,bu,bv,hit,norm,yep)
         #if(yep=1)
            #if(sizeq) #local SCL=(siz0+(siz1-siz0)*rand(R)); #else #local SCL=(siz0+(siz1-siz0)*rndv(R)); #end
            object{obdrop scale SCL rotate (rot*rndsv(R)) translate hit}
         #end

         #local n=n-1;
      #end
   }
#end

#macro sprinkle1p(R,ob,obdrop,powr, ac,au,av, bc,bu,bv, amount,siz0,siz1,sizeq,rot)
   union{
      #local hit=0; #local norm=0; #local yep=0;
      object{ob}
      #local n=amount;
      #while(n>0)

         p2phitp(R,ob,powr, ac,au,av, bc,bu,bv,hit,norm,yep)
         #if(yep=1)
            #if(sizeq) #local SCL=(siz0+(siz1-siz0)*rand(R)); #else #local SCL=(siz0+(siz1-siz0)*rndv(R)); #end
            object{obdrop scale SCL rotate (rot*rndsv(R)) translate hit}
         #end

         #local n=n-1;
      #end
   }
#end

#macro sprinkle2(R,ob,obdrop, ac,au,av, bc,bu,bv, amount,siz0,siz1,sizeq,rot)
   #local n=amount;
   #while(n>0)
      #local pa=ac+au*rnds(R)+av*rnds(R);
      #local pb=bc+bu*rnds(R)+bv*rnds(R);
      #local norm=<0,0,0>;
      
      #local hit=trace(ob,pa,pb-pa,norm);
      #if(vlength(norm)!=0 | vlength(hit)!=0)
         #declare ob=union{object{ob} object{obdrop scale (siz0+(siz1-siz0)*rand(R)) rotate (rot*rndsv(R)) translate hit}};
      #end
      #local n=n-1;
   #end
   object{ob}
#end

#macro drop(ob,world,p1,d)
   #local nor=<0,0,0>;
   #local hit=trace(world,p1,d,nor);
   object{ob translate hit}
#end

#macro rndp(R,p) (pow(rand(R),p)) #end
#macro rndps(R,p) #local r=(2*rand(R)-1); #if(r<0) #local r=(-pow(-r,p)); #else #local r=(pow(r,p)); #end r #end
#macro rnds(R) (2*rand(R)-1) #end
#macro rndd(R,c,r) (c+r*rnds(R)) #end
#macro rndsv(R) <rnds(R),rnds(R),rnds(R)> #end
#macro rndv(R) <rand(R),rand(R),rand(R)> #end
#macro rndpsv(R,p) (p*rndsv(R)) #end
#macro rndsx(R,p) #local r=rand(R1); #if(r<0.5) #local r=(-p-(1-p)*r); #else #local r=(p+(1-p)*r); #end r #end

#macro SCREAM(n)
   #if(n=0)
      #debug "####################################################################\n"
   #else
      #debug "^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n"
   #end
#end

#macro vtostr(hit)  concat("<",str(hit.x,8,8),",",str(hit.y,8,8),",",str(hit.z,8,8),">") #end
#macro vdebug(hit)  #debug concat(Vtostr(hit),"\n") #end

#macro dupt(ob,d,cnt)
   #local p=<0,0,0>;
   #local cn=cnt;
   #union{
      #while(cn>0)
         object{ ob translate p }
         #local p=p+d;                 
         #local cn=cn-1;
      #end
   }   
#end

#macro dupa(ob,da,cnt)
   #local p=<0,0,0>;
   #local cn=cnt;
   #union{
      #while(cn>0)
         object{ ob rotate p }
         #local p=p+da;
         #local cn=cn-1;
      #end
   }   
#end

#macro dup4(ob)  dupa(object{ob},<0,90,0>,4)  #end
#macro dup4m(ob) dup4(object{ob scale<-1,1,1>}) #end
#macro dup8(ob)  union{dup4m(ob) dup4(ob)} #end

#macro space1(ob,p1,p2,cnt,b,e)
   #if(cnt>0)
      #local P1=<0,0,0>;
      #local D=<0,0,0>;
      
      #if(b=0 & e=0)
         #local D=(p2-p1)/(cnt+1);
         #local P1=p1+D;
      #end
      
      object{ dupt(ob,D,cnt) translate P1 }
   #end
#end

#macro cam(loc_,locat_)  #declare loc=loc_;  #declare locat=locat_;  #end
#macro cam2(loc_,locat_)  cam(loc_,loc_+locat_)  #end
#macro cam_hover(world,pos,dir,height)
   #declare hit=trace(world,pos,dir);
   cam2(hit-vnormalize(dir)*height,dir)
#end
#macro T(diff,tex)  texture{tex finish{diffuse diff}}  #end
#macro U(diff)  texture{tex_basic finish{diffuse diff}}  #end

////////////////////////////////////////////////////////////////////////////////////////// Basic OBJECT macros

#macro ring(pc,pd,height,radi,thick)
   #local PD=vnormalize(pd);
   difference{
      cylinder{(pc-PD*height/2) (pc+PD*height/2) (radi+thick)}
      cylinder{(pc-PD*(height/2+EA)) (pc+PD*(height/2+EA)) (radi)}
   }
#end

#macro planeat(norm,p0)  plane{vnormalize(norm),vdot(vnormalize(norm),p0)} #end
//#macro planeat(norm,p0)  plane{norm,vdot(norm,p0)/vdot(norm,norm)} #end

#macro trumpet(len,w0,w1, forth)  sor {5, <w0,-1> <w0,+0> <w0+(w1-w0)/4,forth+(1-forth)/2> <w1,1> <w1*2,1.1>  open}  #end

#macro rowfill(R,len, ob,siz,tex, minsiz, deviate,rot,shift)
   #local LEN=len;
   #local POS=0;
   union{
      #while(LEN>0)
         #local CSIZ=siz+rndpsv(R,deviate);
         #if(LEN<CSIZ.x+minsiz.x) #local CSIZ=<LEN,CSIZ.y,CSIZ.z>; #end
         object{
            ob
            scale CSIZ/siz
            rotate rndpsv(R,rot)
            translate (rndpsv(R,shift)+(POS+CSIZ.x/2)*x)
            texture{
               tex
               translate <1000*rand(R),1000*rand(R),1000*rand(R)>
            }
         }
         #local LEN=LEN-CSIZ.x;
         #local POS=POS+CSIZ.x;
      #end
   }
#end

#macro blockfill(sb, ob,siz,tex, leave,layout,options,minsiz, deviate,rot,shift)

   #local R1=seed(sb.x*(sb.y+10)*(sb.z+100));
   
   #switch(layout)
      #case(0)
         object{ob scale (sb/siz) texture{tex}}
      #break

      #case(1)

         #local SIZ=siz;

         //options
         //x=0 : adjust block heights to match evenly with the superblocks height
         #if(options.x=0)
            #local n=ceil(sb.y/SIZ.y);
            #local SIZ=<SIZ.x,sb.y/n,SIZ.z>;
         #end

         //main fillemup-loop
         union{
            #local LEFT=sb.y;
            #local POS=<0,-sb.y/2,0>;
            #while(LEFT>0)

               #if(LEFT<SIZ.y+minsiz.y)
                  #local SIZ=<SIZ.x,LEFT,SIZ.z>;
                  #local LEFT=0;
               #else
                  #local LEFT=LEFT-SIZ.y;
               #end

//               object{ob scale <sb.x,SIZ.y,sb.z>/siz translate (POS+SIZ.y/2*y) texture{tex}}

               #local SIDE=<sb.x,0,sb.z>;
               #local CONT=1;
               #while(CONT=1)
                  #if(SIDE.x<1.5*(SIZ.x+SIZ.z) | SIDE.z<1.5*(SIZ.x+SIZ.z))
                     object{ob scale <SIDE.x,SIZ.y,SIDE.z>/siz translate (POS+SIZ.y/2*y) texture{tex}}
                     #local CONT=0;
                  #else
                  
                     #if(rand(R1)<0.5) #local TER=1; #else #local TER=0; #end  //fill at termination or beginning of row
                     #local SER=1-TER;
                     #if(SIDE.z<leave.z*2 | SIDE.x<leave.x*2) #local SER=0; #local TER=0; #end
                     #if(SIDE.z<leave.z*2 & SIDE.x<leave.x*2) #local CONT=0; #end
                     
                     
//                     R,len, ob,siz,tex, minsiz, deviate,rot,shift)
                     ///xxxxxxx
                     #if(SIDE.z>leave.z*2)
                        object{
                           rowfill(R1,SIDE.x-(SER+TER)*SIZ.z, object{ob scale SIZ/siz},SIZ,tex, minsiz, deviate,rot,shift)
                           translate <-SIDE.x/2+SER*SIZ.z,(POS.y+SIZ.y/2),-SIDE.z/2+SIZ.z/2>
                        }
                        object{
                           rowfill(R1,SIDE.x-(SER+TER)*SIZ.z, object{ob scale SIZ/siz},SIZ,tex, minsiz, deviate,rot,shift)
                           translate <-SIDE.x/2+SER*SIZ.z,(POS.y+SIZ.y/2),-SIDE.z/2+SIZ.z/2>
                           rotate<0,180,0>
                        }
                     #end
                     ///zzzzzzz
                     #if(SIDE.x>leave.x*2)
                        object{
                           rowfill(R1,SIDE.z-(SER+TER)*SIZ.z, object{ob scale SIZ/siz},SIZ,tex, minsiz, deviate,rot,shift)
                           rotate <0,-90,0>
                           translate <SIDE.x/2-SIZ.z/2,(POS.y+SIZ.y/2),-SIDE.z/2+SER*SIZ.z>
                        }
                        object{
                           rowfill(R1,SIDE.z-(SER+TER)*SIZ.z, object{ob scale SIZ/siz},SIZ,tex, minsiz, deviate,rot,shift)
                           rotate <0,-90,0>
                           translate <SIDE.x/2-SIZ.z/2,(POS.y+SIZ.y/2),-SIDE.z/2+SER*SIZ.z>
                           rotate <0,180,0>
                        }
                     #end
                     
                     #local SIDE=SIDE-2*SIZ.z*<1,0,1>;
                     
                  #end
               #end
               
               
               #local POS=POS+SIZ.y*y;
            #end
         }
      #break

   #end
#end

#macro stoneblock(R,p)
   object{ superellipsoid{<0.2,0.2>} scale (p/2) texture{tex_stone translate <1000*rand(R),1000*rand(R),1000*rand(R)>} }
#end

#macro sylinder(p1,p2,r,s1,s2)
   union{
      cylinder{p1,p2,r}
      #if(s1>0) sphere{p1,s1*r} #end
      #if(s2>0) sphere{p2,s2*r} #end
   }
#end

#macro table1(xx,zz,yy,thick,legthick)
   #union{
      box{<0,yy-thick,0> <xx,yy,zz>}
      box{<0,0,0> <legthick,yy-thick+EA,legthick>}
      box{<xx-legthick,0,0> <xx,yy-thick+EA,legthick>}
      box{<xx-legthick,0,zz-legthick> <xx,yy-thick+EA,zz>}
      box{<0,0,zz-legthick> <legthick,yy-thick+EA,zz>}
   }
#end

#macro door1(ww,hh,dd,w,h,d,dir,opn,over,split)
   #if(dir=0)
      #local dp=box{(w*(split)-d*(dd/2)) (w*(ww/2+over)+h*(hh)+d*(dd/2)) };
      #union{ object{dp translate w*(ww/2*opn)} object{dp rotate h*180 translate -w*(ww/2*opn)} }
   #end
#end

#macro door1_free(ww,hh,w,h,d,p,dd_wall)
   box{ (w*(-ww/2)+h*(EA)+d*(-dd_wall/2-EA)) (w*(ww/2)+h*(hh)+d*(dd_wall/2+EA)) translate p}
#end

#macro lense(xx,zz,yy)
// derivation: r^2=(r-zz/2)^2+(xx/2)^2 => (zz^2+xx^2)/4=zz*r => r=(zz^2+xx^2)/4/zz
   #local r=(zz*zz+xx*xx)/4/zz;
   #intersection{
      cylinder{ <0,0,(zz/2-r)> <0,yy,(zz/2-r)> r }
      cylinder{ <0,-EA,-(zz/2-r)> <0,yy+EA,-(zz/2-r)> r }
   }
#end

#macro lense_half(xx,zz,yy)
   #difference{
      lense(xx,zz,yy)
      box{ <-xx/2-EA,-EA,0> <xx/2+EA,yy+EA,zz/2+EA> }
   }
#end

#macro lense_hollow(xx,zz,yy,thick)
   #difference{
      lense(xx,zz,yy)
      object{ lense(xx-thick,zz-thick,yy+2*EA) translate <0,-EA,0> }
   }
#end

#macro lense_hollow_half(xx,zz,yy,thick)
   #difference{
      lense_hollow(xx,zz,yy,thick)
      box{ <-xx/2-EA,-EA,0> <xx/2+EA,yy+EA,zz/2+EA> }
   }
#end

#macro table_lense1(/*lense*/xx,zz,yy, /*cutaway*/thick,legthick)
   #difference{
      lense(xx,zz,yy)
      box{ <-xx/2+legthick,-EA,-zz/2-EA> <xx/2-legthick,yy-thick,zz/2+EA> }
   }
#end

#macro frame1(xx,zz,yy, xxleft,xxright, yytop,yybot, zzback,zzfront)
   #union{
      #if(xxleft>0) box{<0,0,0> <xxleft,yy,zz>} #end
      #if(xxright>0) box{<xx-xxright,0,0> <xx,yy,zz>} #end
      #if(yytop>0) box{<0,yy,0> <xx,yy-yytop,zz>} #end
      #if(yybot>0) box{<0,0,0> <xx,yybot,zz>} #end
      #if(zzback>0) box{<0,0,0> <xx,yy,zzback>} #end
      #if(zzfront>0) box{<0,0,zz-zzfront> <xx,yy,zz>} #end
   }
#end

#macro shelf1(/*frame1*/ xx,zz,yy,xxleft,xxright,yytop,yybot,zzback,zzfront, /**/xxinner,yyinner,nxx,nyy)
   #union{
      frame1(xx,zz,yy, xxleft,xxright, yytop,yybot, zzback, zzfront)
      space1(box{<0,0,0> <xx-xxleft-xxright,yyinner,zz>},<xxleft,yybot,0>,<xxleft,yy-yytop-yyinner,0>,nyy,0,0)
      space1(box{<0,0,0> <xxinner,yy-yytop-yybot,zz>},<xxleft,yybot,0>,<xx-xxleft-xxinner,yybot,0>,nxx,0,0)
   }
#end

#macro ladder1(xx,zz,yy,leg_xx,stps,stps_zz,stps_yy,free_top,free_bot)
   #union{
      box{<0,0,0> <leg_xx,yy,zz>}
      box{<xx-leg_xx,0,0> <xx,yy,zz>}
      
      #local stp=box{<0,0,0> <xx-2*leg_xx,stps_yy,stps_zz>}
      
      //steps
      #if(stps=1)
         object{ stp translate <leg_xx,(yy-stps_yy)/2,(zz-stps_zz)/2> }
      #else
         #if(stps>1)
            object{ dupt(stp,<0,(yy-free_top-free_bot-stps_yy)/(stps-1),0>,stps) translate <leg_xx,free_bot,(zz-stps_zz)/2> }
         #end
      #end
   }
#end

#macro chair1( /*sit table*/ sxx,szz,syy,sthick,slegthick, /*back ladder*/ bzz,byy,bleg_xx,bstps,bstps_zz,bstps_yy,bfree_top,bfree_bot)
   #union{
      table1(sxx,szz,syy,sthick,slegthick)
      object{ ladder1(sxx,bzz,byy,bleg_xx,bstps,bstps_zz,bstps_yy,bfree_top,bfree_bot) translate <0,syy,0>}
   }
#end

#macro tree(h1,t1,tex1, h2,t2,tex2, mode)
   #if(mode=0)
      union{
         cylinder{0,h1*y t1/2 texture{pigment{rgb<0.5,0.45,0.1>}}}
         sphere{0,h2/2 scale<t2/h2,1+0.1*h1/h2,t2/h2> translate (h1+h2/2)*y texture{pigment{rgbt<0.2,0.70,0.1,tex2>}}}
      }
   #end   
#end

////////////////////////////////////////////////////////////////////////////////////////////////// POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// POSERS
#macro stickfig(LEVEL,thick,joint, p0, dstomach,dneck,dhead,darm11,darm12,darm21,darm22,dhand1,dhand2,dleg11,dleg12,dleg21,dleg22,dfoot1,dfoot2)
   #if(LEVEL=0 | LEVEL=1)
      #local siz=vlength(dstomach);
      #local thi=0.04*thick*siz;
      
      #local armpos=p0+dstomach*0.3;//
      #local legpos=p0-dstomach*0.3;//

      #local hedpos=armpos+vnormalize(dneck)*(siz*0.15+5*thi*thi);

      #local ar1pos=armpos+vnormalize(darm11)*siz*0.25;
      #local ar2pos=armpos+vnormalize(darm21)*siz*0.25;
      #local hd1pos=ar1pos+vnormalize(darm12)*siz*0.3;
      #local hd2pos=ar2pos+vnormalize(darm22)*siz*0.3;
      #local fi1pos=hd1pos+vnormalize(dhand1)*siz*0.17;
      #local fi2pos=hd2pos+vnormalize(dhand2)*siz*0.17;

      #local lg1pos=legpos+vnormalize(dleg11)*siz*0.4;
      #local lg2pos=legpos+vnormalize(dleg21)*siz*0.4;
      #local fo1pos=lg1pos+vnormalize(dleg12)*siz*0.5;
      #local fo2pos=lg2pos+vnormalize(dleg22)*siz*0.5;
      #local to1pos=fo1pos+vnormalize(dfoot1)*siz*0.24;
      #local to2pos=fo2pos+vnormalize(dfoot2)*siz*0.24;
      
      #if(joint=0)
         union{
            cylinder{armpos,legpos,thi}
            cylinder{armpos,hedpos,thi}
            sphere{hedpos,0.1*siz+5*thi*thi}
            cylinder{armpos,ar1pos,thi}
            cylinder{armpos,ar2pos,thi}
            cylinder{ar1pos,hd1pos,thi}
            cylinder{ar2pos,hd2pos,thi}
            cylinder{hd1pos,fi1pos,thi}
            cylinder{hd2pos,fi2pos,thi}
            cylinder{legpos,lg1pos,thi}
            cylinder{legpos,lg2pos,thi}
            cylinder{lg1pos,fo1pos,thi}
            cylinder{lg2pos,fo2pos,thi}
            cylinder{fo1pos,to1pos,thi}
            cylinder{fo2pos,to2pos,thi}
         }
      #else
         union{
            sylinder(armpos,legpos,thi,joint,joint)
            sylinder(armpos,hedpos,thi,0,0) 
            #if(LEVEL=0)
               sphere{hedpos,0.1*siz+5*thi*thi}
            #else
               object{scull(array[5]{0,1,1,1,1}) scale 2*siz translate hedpos}
            #end            
            sylinder(armpos,ar1pos,thi,0,joint)
            sylinder(armpos,ar2pos,thi,0,joint)
            sylinder(ar1pos,hd1pos,thi,0,joint)
            sylinder(ar2pos,hd2pos,thi,0,joint)
            sylinder(hd1pos,fi1pos,thi,0,joint)
            sylinder(hd2pos,fi2pos,thi,0,joint)
            sylinder(legpos,lg1pos,thi,0,joint)
            sylinder(legpos,lg2pos,thi,0,joint)
            sylinder(lg1pos,fo1pos,thi,0,joint)
            sylinder(lg2pos,fo2pos,thi,0,joint)
            sylinder(fo1pos,to1pos,thi,0,joint)
            sylinder(fo2pos,to2pos,thi,0,joint)
         }
      #end
   #end
#end

#macro scull(p) //LEVEL w h eyesize eyespace
   #local WIDTH=p[1]*0.13;
   #local HEIGHT=p[2]*0.18;
   #local CHEEKR=WIDTH/4;

   #local EYER=p[3]*WIDTH/4/2;
   #local EYED=EYER+p[4]*(WIDTH-2*2*EYER)/8;
   #local EYEH=0.1*WIDTH;

   #local base=union{
      sphere{0,WIDTH/2}
      cylinder{<0,-WIDTH/2-(HEIGHT-WIDTH),-CHEEKR>,<0,0,-CHEEKR>,CHEEKR}
   }
   difference{
      object{base}
      //eyes
      #local hit=trace(base,<-EYED,EYEH,-1>,<0,0,1>);
      sphere{hit,EYER}
      #local hit=trace(base,<+EYED,EYEH,-1>,<0,0,1>);
      sphere{hit,EYER}
   }
#end

//////////////////////////////////////////////// Figure
// TYPE=FIG_StickFigure
//  F
//   FigureTYPE,DetailLEVEL,thick,joint
//  V
//   p0,dstomach,dneck,dhead,darm11,
//   darm12,darm21,darm22,dhand1,dhand2,
//   dleg11,dleg12,dleg21,dleg22,dfoot1,
//   dfoot2,
//  O
//  T
////////////////////////////////////////////////
#declare FIG_StickFigure=0;
#macro FIG(F,V,O,T)
   #switch(F[0])
      #case(FIG_StickFigure)
         stickfig(F[1],F[2],F[3],V[0],V[1],V[2],V[3],V[4],V[5],V[6],V[7],V[8],V[9],V[10],V[11],V[12],V[13],V[14],V[15])
      #break
   #end
#end

//////////////////////// Skeleton
// a is array of rotation vectors
//
// H1 H2
// LA1 LA2 LA3
// RA1 RA2 RA3
// LL1 LL2 LL3
// RL1 RL2 RL3
////////////////////////
#macro arm(cnt,P,O,R,D)
   #local OO=O;
   #local PP=P;
   #local DD=D;
   
   #local i=0;
   #while(i<cnt)
      #local j=i;

      #local d0=DD[0];
      #local d1=vaxis_rotate(DD[1],d0,R[i].x);
      #local d2=vaxis_rotate(vaxis_rotate(P[i+1]-P[i],d0,R[i].x),d1,R[i].y);

      #local DD[0]=vaxis_rotate(vaxis_rotate(d0,d1,R[i].y),d2,R[i].z);
      #local DD[1]=vaxis_rotate(d1,d2,R[i].z);

      #while(j<cnt)

         #local OO[j]=object{
            OO[j]
            translate -PP[i]
            Axis_Rotate_Trans(d0,R[i].x)
            Axis_Rotate_Trans(d1,R[i].y)
            Axis_Rotate_Trans(d2,R[i].z)
            translate PP[i]
         }

         #local PP[j+1]=vaxis_rotate(vaxis_rotate(vaxis_rotate(PP[j+1]-PP[i],d0,R[i].x),d1,R[i].y),d2,R[i].z)+PP[i];

         #local j=j+1;
      #end
      
      
      
      #local i=i+1;
   #end
   OO
#end

#macro armu(cnt,P,O,R,D) array_union(cnt,arm(cnt,P,O,R,D)) #end

#macro Skeleton(a)
   //HEAD
   #local PH=array[3]{<0,1.40,-0.05>,<0,1.50,-0.045>,<0,1.72,0>};
   #local SH=array[2]{0.05,0.2};
   #local OH=cutspheres(skeleton,2,PH,SH,0.1);
   //LEFT ARM
   #local PLA=array[4]{<-0.14,1.38,-0.05>,<-0.44,1.40,-0.05>,<-0.7,1.39,-0.055>,<-0.89,1.37,-0.06>}
   #local SLA=array[3]{0.1,0.1,0.2};
   #local OLA=cutspheres(skeleton,3,PLA,SLA,0.05);
   //RIGHT ARM
   #local PRA=array_mul(4,PLA,<-1,1,1>);
   #local SRA=SLA;
   #local ORA=cutspheres(skeleton,3,PRA,SRA,0.05);
   //LEFT LEG
   #local PLL=array[4]{<-0.11,0.87,-0.04>,<-0.07,0.48,-0.04>,<-0.08,0.03,-0.08>,<-0.08,-0.01,0.13>}
   #local SLL=array[3]{0.1,0.1,0.08};
   #local OLL=cutspheres(skeleton,3,PLL,SLL,0.05);
   //RIGHT LEG
   #local PRL=array_mul(4,PLL,<-1,1,1>);
   #local SRL=SLL;
   #local ORL=cutspheres(skeleton,3,PRL,SRL,0.05);

   union{
      difference{
         object{skeleton}
   
         
         object{sphere2a(2,PH,SH,0.1) pigment{rgbt <1,1,1,0.4>}}
         object{sphere2a(3,PLA,SLA,0.05) pigment{rgbt <1,1,1,0.4>}}
         object{sphere2a(3,PRA,SRA,0.05) pigment{rgbt <1,1,1,0.4>}}
         object{sphere2a(3,PLL,SLL,0.05) pigment{rgbt <1,1,1,0.4>}}
         object{sphere2a(3,PRL,SRL,0.05) pigment{rgbt <1,1,1,0.4>}}
      }
      
//         object{sphere2a(3,PRA,SRA,0.05) pigment{rgbt <1,1,1,0.4>}}
//      place(sphere{0,0.04 pigment{rgbt <1,1,1,0.4>}},4,PLL)
/*      place(sphere{0,0.03 pigment{rgbt <1,1,1,0.4>}},4,PLA)
      place(sphere{0,0.03 pigment{rgbt <1,1,1,0.4>}},4,PRA)
      place(sphere{0,0.03 pigment{rgbt <1,1,1,0.4>}},3,PH)*/

      armu(2,PH,OH,array[2]{a[0],a[1]},array[2]{<0,0,1>,<1,0,0>})
      armu(3,PLA,OLA,array[3]{a[2],a[3],a[4]},array[2]{<0,0,1>,<1,0,0>})
      armu(3,PRA,ORA,array[3]{a[5],a[6],a[7]},array[2]{<0,0,1>,<1,0,0>})
      armu(3,PLL,OLL,array[3]{a[8],a[9],a[10]},array[2]{<0,0,1>,<1,0,0>})
      armu(3,PRL,ORL,array[3]{a[11],a[12],a[13]},array[2]{<0,0,1>,<1,0,0>})
   }
#end
////////////////////////////////////////////////////////////////////////////////////////////////// ^^^^^^^^POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// ^^^^^^^^POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// ^^^^^^^^POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// ^^^^^^^^POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// ^^^^^^^^POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// ^^^^^^^^POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// ^^^^^^^^POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// ^^^^^^^^POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// ^^^^^^^^POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// ^^^^^^^^POSERS
////////////////////////////////////////////////////////////////////////////////////////////////// ^^^^^^^^POSERS


#macro planecloud(yy,tt,s,d)
   #local ttt=<tt.x,tt.y,tt.z,0>*0.8+t*tt.t;
   plane{
      vnormalize(yy),vlength(yy)
      hollow
      pigment{
         bozo
         warp{ turbulence x+z octaves 6 omega 0.7 lambda 2 }
         color_map{
            [0.0 d/5 color rgbt tt  color rgbt ttt]
            [d/5 d color rgbt ttt color rgbt 1]
            [d 1.0 color rgbt 1   color rgbt 1]
         }
         scale <0.2*s, 0.5*s, 0.2*s>
      }
   }
#end

////////////////////////////////////////////////////////////////////////////////////////// Standard objects

#macro chair1_std(rot)
   chair1(/*sit table*/ 0.43,0.41,0.46,0.015,0.04, /*back ladder*/ 0.03,0.5,0.01,3,0.01,0.059,0.04,0.1)
   rotate <0,rot,0>
#end


////////////////////////////////////////////////////////////////////////////////////////// Textures

#declare tex_black=texture{pigment{color <0,0,0>} finish{specular 0.3}}
#declare tex_basic=texture{pigment{color <0.5,0.5,0.5>}}
#declare tex_sand=texture{pigment{rgb<1,0.9,0.1>} normal{bumps 0.3 scale 0.01}};
#declare tex_gold=texture{pigment{rgb<1,1,1>} finish{metallic specular 1}};
#declare tex_bone=texture{pigment{rgb<1,1,1>} normal {bumps 0.5 scale 0.1} finish{}};
#declare tex_stone1=texture{
   pigment{
      marble
      scale 0.5
      turbulence 10
      color_map {
          [0.0 rgb <1.3,1.1,0.1>]
          [0.3 rgb <1.3,1.1,0.1>]
          [0.4 rgb <1.4,1.2,0.1>]
          [0.5 rgb <1.3,1.1,0.1>]
          [0.8 rgb <1.5,1.3,0.1>]
      }
   }
   normal{ bumps 0.3 scale 0.01}
}
#declare tex_stone2=texture{
   #local d=0.9;
   #local tt=<0.8,0.8,0.4,0.1>;
   #local ttt=<0.7,0.6,0.2,0.1>;
   #local s=10;
   pigment{
      bozo
      scale 0.2*s
      warp{ turbulence <1,1,1> octaves 6 omega 0.7 lambda 2 }
      color_map{
         [0.0 d/5 color rgbt tt  color rgbt ttt]
         [d/5 d color rgbt ttt color rgbt 1]
         [d 1.0 color rgbt 1   color rgbt 1]
      }
   }
}
#declare tex_stone=
   texture{tex_stone1}
   texture{tex_stone2};
