
// setting all the variables for the iPodRetro rendering here

// all lengts in cm


// the main body
#declare mainHeight				= 10.35;
#declare mainWidth  			=  6.18;
#declare mainThick  			=  1.4;
#declare mainEdgeRadius 		= mainWidth/10;
#declare plasticThickness		= mainThick/3;				// how thick the plastic part is
#declare gapWidth				= 0.04;					// width of the gap between plastic and metal
#declare gapDepth				= 0.04;						// deptt of the gap
#declare metalShrinkFactor		= 1;						// the metal part is a little smaller

// the display
#declare displayWidth			= 4.18;
#declare displayHeight			= displayWidth*115/228;
#declare frameWidth				= 0.05;				// to have round edges around the display there has to be a little frame
#declare displayX				= 0;				// x position of the middle point of the display
#declare displayZ				= -0.5;				// z posision
#declare edgeRadius				= 0.05;				// the radius with which the edge of the plastic part is rounded
#declare displayDepth			= 0.2;				// how far the actual display is located away from the surface
#declare glassScaleFactor		= 0.9999;			// the factor to scale the glass of the display with to make it a little smaller than the opening in the body
#declare displayGlassThickness = 0.1;				// thickness of the display's glass

//the touchpad
#declare touchpadX				= 0;
#declare touchpadZ				= -3.25;
#declare touchpadOuterRad		= 0.75;//displayWidth/2;		// the outer radius of the touchpad
#declare touchpadInnerRad		= touchpadOuterRad/2.85; 	//     inner radius, ignored if just a circular touchpad
#declare touchpadFrameRad		= 0.02;				// the height of the circular edge around the touchpad
#declare touchpadGap			= 0.01;				// the gap between touchpad and the main body ( zero if perfectly manufactured)
#declare touchpadGapDepth		= 0.02;				// the depth of the gap
#declare touchpadIn				= 0.005;			// how much deeper the touchpad is related to the main body surface
#declare touchpadConcave		= 0.1;				// if there is just one button, we make it concave so that it is this deep in the middle


// the memory cylinder. It has 18 tracks        
#declare trackNumber 			= 18;
#declare cylinderTrackWidth	 	= 0.15;				// width of a single track
#declare cylinderEndspace  		= 0.05;				// blank region on the cylinder
#declare cylinderRadius			= 0.75;				// Radius of the cylinder without nipples
#declare cylinderMantleThick	= 0.025;			// thickness of the mantle of the cylinder, there is other material beneath
#declare nippleBaseRad			= 0.045;			// radius of the nipples' base
#declare nippleTopRad			= 0.03;				//                        top
#declare nippleLength			= 0.075;			// the lengt of a nipple measured from the outer surface of the cylinder
#declare endCapWidth			= 0.12;				// widht of the caps at the end
#declare endCapGap				= 0.015;			// the width of the  gap between the cylinder and its endcaps 
#declare endCapGapDepth			= 0.05;				// the depth of that gap
#declare endCapRadius			= 1.02*cylinderRadius; // radius of the endcap
#declare gearRadius				= 1.08*cylinderRadius; // radius of the gear wheel at the endcap
#declare sprocketNumber			= 48;				// numper of sprockets or 'nipples' on the gearwheel of the cylinder
#declare sprocketHeight			= 0.1;				// height of the sprocket, approx only. It is a little shorter due to rounded edges
#declare sprocketRounding		= 0.35;				// 1 -> very round, 0 -> not round at all
#declare axisRadius				= 0.07;				// radius of the axis of the cylinder
#declare axisOuterLength		= 0.7;				// how far the axis comes out of the cylinder

// the gap in which the cylinder etc. sits
#declare cylinderGapWidth		= displayWidth; 				//18*cylnderTrackWidth + 2*cylinderEndspace+ 2*endCapWidth +2*endCapGap + 0.7; // the width of the gap
#declare cylinderGapX			= 0;							// x pos of the gap. 0 is centered
#declare cylinderGapCornerRad	= frameWidth/(1-cos(pi/4));		// radius of the corners of the gap
#declare cylinderGapHeight		= 4.15;					// how deep the gap reaches into the main body on the upper part
#declare cylinderGapHeightLow	= 2.4*cylinderRadius;	//                                                    lower
#declare cylinderGapStepY		= 1.12*mainThick/2;		// in which height the step is, measured from the backside of the device
#declare cylinderGapEdgeRad		= 0.25*cylinderGapCornerRad;		// NOT MORE THAN cylinderGapCornerRad!!! rounding of the cut edges

// the mechanics of the music box
#declare guidesY				= 0.22*mainThick/2;			// Y coordinate of the lower surface of the guides
#declare guideToCylinder		= 0.15*nippleLength;		// distance between guide and cylinder
#declare visibleGuideMin		= 1.35;						// shortest of the metal guides
#declare visibleGuideMax		= visibleGuideMin+0.75;						// longest  of them
#declare mechanicsHeight		= cylinderGapHeight;		// the height of the mechanics part, including its plastic cover. Width is determinded by the gap
#declare guideThick				= 0.08;						// thickness of the guides
#declare guideWidth				= 0.85*cylinderTrackWidth;	// how wide a guide is
#declare guideEdgeRad			= 0.0275; 					// how round the edges of the guides are
#declare negOffset				= 0.3;						// make the guides a little longer in minus Z direction than visible
#declare gapToCylinderLeft		= 0.3;
#declare gapToCylinderRight		= 0.1;
#declare gapToBody				= 0.0;						// gap between the inlay and the main body. together with cylinderGapEdgeRad this has to be less than cylinderGapCornerRad
// the gap in the cover:
#declare coverGapWidth 			= trackNumber*cylinderTrackWidth +2*cylinderEndspace + 2*0.3;
#declare coverGapZOffset		= 0.9;						// offset in z direction of the diagonal edge
#declare coverGapCornerRad		= 0.3;						// how round the corners are, not the edges!
#declare coverGapEdgeRad		= 0.15;						// how round the edges are

// there are two extra gear wheels, number 2 and 3, they share the axis
#declare gw2AxisRadius			= 0.075;									// radius of the axis holding the two extra wheels
#declare gw2AxisXend			= -trackNumber/2*cylinderTrackWidth+0.02;	// x coordinate where the axis ends
#declare gw2AxisZ				= 3.54;										// the z coordinate of the axis
#declare gw2AxisY				= mainThick/2-gw2AxisRadius*1.5;			//     y coord
#declare gw2AxisGap				= 0.015;									// gap between axis and gw2
#declare gw2radius				= 0.15;										// guess what
#declare gw2sprocketNumber		= 11;
#declare gw2sprocketHeight		= 0.08;
#declare gw2thick				= 0.2;
#declare gw2rounding			= 0.35;
#declare gearWheelGap			= 0.005;									// gap between the wheels
#declare gw3radius				= 0.55;
#declare gw3sprocketNumber		= 42;
#declare gw3sprocketHeight		= 0.080;
#declare gw3thick				= 0.085;
#declare gw3rounding			= 0.4;

// the manual
#declare manualWidth			= 12.487;
#declare manualHeight			= 12.552;
#declare manualThick			= 0.75;
#declare manualWrinkledPartWidth = 0.1;
#declare manualWrinkledPartThick = 0.02;
#declare manualWrinkleX			= -5.75;


