// Persistence of Vision Ray Tracer Scene Description File
// File: orchestra.pov
// Vers: 3.6
// Desc: Conductor and string section
// Date: March 7, 2006 
// Auth: Rob Fitzel
// Units: feet 

// includes ///////////////////////////////////////////////////////////////////
#declare inch_to_feet  = 1/12;
#declare using_megapov = 0;
// Scene Controls /////////////////////////////////////////////////////////////


// camera
#declare view = 4; // 4 audience 
                   // 5 in the midst of the cellos
                   // 6 way back 
                   // 7 zoom in
                   
// objects
#declare draw_indoors      = 1; 
#declare draw_chairs       = 1;  
#declare draw_spotlights   = 0;
#declare draw_ceiling      = 0; 
#declare draw_risers       = 1;
#declare draw_curved_stage = 0;
#declare num_spotlights    = 50;
#declare ceil_height       = 30;

// people - not included
#declare draw_conductor    = 0; // not visible in view 5
#declare draw_violinists   = 0;
#declare draw_cellists     = 0;
#declare draw_trumpeters   = 0; 
#declare draw_clarinetists = 0;
#declare draw_bassoonists  = 0; 
#declare draw_flutists     = 0; 
#declare draw_timpanist    = 0;
#declare draw_french_horns = 0;
#declare draw_audience     = 0;
#declare detailed_hair     = 0; // (mp3man)
#declare draw_front_row    = 0; 

// quality settings
//#declare violinist2_hires = 1;



// lights  
#declare rad          = 1;
#declare cam_light    = 0; // tmp // replaced by aud_light
#declare aud_light    = 4; // audience light_group
#declare top_light    = 1.5;
#declare spot_light   = 0; // front spotlights
#declare draw_mist    = 1;
#declare sun_light    = 10*0;
#declare SunPos       = <-100,100,-100>; 
//#declare SunPos     = <-100,ceil_height-5,-20>; 
#declare area         =1;

// common textures 
#debug "includes\n"
//#include "rf_cello_mat.inc"
//#include "rf_black_3pc_suit_mat.inc" 
#include "rand.inc"

// random seeds
#declare csd = seed(19); // curtains  
#declare tsd = seed(2229); // translation/rotations
#declare fsd = seed(27); // floor planks 
#declare lsd = seed(5454); // spotlights

// conditional includes 
#debug "including people definition...\n"
#if (draw_conductor)
  #include "conductorB.inc"
#end 
#if (draw_violinists)
  #include "violinist1.inc" 
  #include "violinist2.inc" 
  #include "violinist3.inc" 
#end 

#if (draw_cellists)
  #include "violin_bow.inc" 
  #include "cellist1.inc" 
  #include "cellist2c.inc" 
  #include "cellist3.inc" 
#end

#if (draw_trumpeters)
  #include "trumpeter1.inc" 
  #include "trumpeter2.inc"
  #include "trumpeter3b.inc"
#end

#if (draw_clarinetists) 
  #include "clarinetist1.inc" 
  #include "clarinetist2.inc" 
#end

#if (draw_flutists) 
  #include "flutist1.inc"
#end 

#if (draw_spotlights)
  #include "rf_lamps.inc" 
#end 

#if (draw_french_horns)
  #include "french_hornist1.inc"
  #include "french_hornist2.inc"
#end

#include "rf_chairs.inc"
#include "rf_music_stand.inc" 


global_settings {
  max_trace_level 50
  assumed_gamma 2.2 
  #if (rad)
    #include "rad_def.inc"
   radiosity 
   {
     Rad_Settings(Radiosity_IndoorLQ, off, off)
    //Rad_Settings(Radiosity_IndoorHQ, off, off)
   }
  #end

  #if (using_megapov)
    #version unofficial MegaPov 1.21;
    motion_blur 5, clock_delta*0.5
  #end



}





// Camera /////////////////////////////////////////////////////////////////////

#switch (view)
  #case (0)  // top view
    #declare CamPos    = <0, 50, 10> ;
    #declare CamLookAt = <0,0,10>;
    #break
  #case (1) // backstage  
    #declare CamPos    = <-20, 8, 20>;
    #declare CamLookAt = <2,4,0>;
    #break 
  #case (2) // forestage  
    #declare CamPos    = <5, 4, -15>;
    #declare CamLookAt = <0,4,0>;
    #break 
  #case (3) // forestage  
    #declare CamPos    = <5, 6, -8>;
    #declare CamLookAt = <5,4,0>;
    #break
  #case (4) // audience  
    #declare CamPos    = <8, 6, -20>;
    #declare CamLookAt = <8,4,0>;
    #break 
  #case (5) // closeup of cellists
    #declare CamPos    = <15, 4, -6>; 
    #declare CamPos    = <14, 4, -5>; 
    #declare CamLookAt = <5,4,10>;
    #break
  #case (6) // audience  
    #declare CamPos    = <0, 20, -50>;
    #declare CamLookAt = <0,4,0>;
    #break
  #case (7) // audience  
    #declare CamPos    = <0, 8, 0>;
    #declare CamLookAt = <0,4,20>;
    #break 
    
     
  #else  
    #declare CamPos    = <0, 5, -50>; 
    #declare CamLookAt = <0,5,0>; 

#end


camera {
  location  CamPos 
  look_at   CamLookAt

}


// Lights /////////////////////////////////////////////////////////////////////

#if (cam_light>0) 
  light_source {0*x rgb cam_light translate CamPos }
#end 
  
#if (top_light>0) 
  // overhead spotlights
  #local s1pos = <10,ceil_height-5,-15>;
  #local s1pat = <-5,0,10>;  
  
  #local s2pos = <-10,ceil_height-5,-15>;
  #local s2pat = <5,0,10>; 
  
  
  #local s3pos = <5,ceil_height-5,5>;
  #local s3pat = <20,0,20>; 
  #local s4pos = <-10,ceil_height-5,5>;
  #local s4pat = <10,0,5>; 
  #local s5pos = <10,ceil_height-5,5>;
  #local s5pat = <-10,0,5>; 
  

// faked media
//cone {s2pos, 0.5, s2pat, 10 pigment {rgbt <1,1,1,0.5>}}  
   
light_source {
  0*x                     // light's position (translated below)
  color rgb top_light       // light's color
  spotlight               // this kind of light source
  translate s1pos       // <x y z> position of light
  point_at s1pat        // direction of spotlight
  radius 20                // hotspot (inner, in degrees)
  tightness 0            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 35               // intensity falloff radius (outer, in degrees)  
#if (area)
  area_light
  <2, 0, 0> <0, 0, 2> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
#end  
  // add area light
}   





light_source {
  0*x                     // light's position (translated below)
  color rgb top_light       // light's color
  spotlight               // this kind of light source
  translate s2pos       // <x y z> position of light
  point_at s2pat        // direction of spotlight
  radius 20                // hotspot (inner, in degrees)
  tightness 0            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 30               // intensity falloff radius (outer, in degrees)
#if (area)
  area_light
  <2, 0, 0> <0, 0, 2> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
#end  
  
} 
/*
light_source {
  0*x                     // light's position (translated below)
  color rgb top_light       // light's color
  spotlight               // this kind of light source
  translate s3pos       // <x y z> position of light
  point_at s3pat        // direction of spotlight
  radius 20                // hotspot (inner, in degrees)
  tightness 0            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 30               // intensity falloff radius (outer, in degrees)
}
light_source {
  0*x                     // light's position (translated below)
  color rgb top_light       // light's color
  spotlight               // this kind of light source
  translate s4pos       // <x y z> position of light
  point_at s4pat        // direction of spotlight
  radius 20                // hotspot (inner, in degrees)
  tightness 0            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 30               // intensity falloff radius (outer, in degrees)
}
light_source {
  0*x                     // light's position (translated below)
  color rgb top_light       // light's color
  spotlight               // this kind of light source
  translate s5pos       // <x y z> position of light
  point_at s5pat        // direction of spotlight
  radius 20                // hotspot (inner, in degrees)
  tightness 0            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 30               // intensity falloff radius (outer, in degrees)
}
*/
#end  


#if (spot_light >0)
light_source {
  0*x                     // light's position (translated below)
  color rgb spot_light       // light's color
  spotlight               // this kind of light source
  translate <0,ceil_height-5,-30> // <x y z> position of light
  point_at <0,0,40>      // direction of spotlight
  radius 30                // hotspot (inner, in degrees)
  tightness 0            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 50               // intensity falloff radius (outer, in degrees)
}

//cylinder {<0,ceil_height-5,-60>, <0,0,20> 1 pigment {rgb 1} translate <0,-1,0>}
#end



#if (sun_light>0)
  light_source {0*x rgb sun_light translate SunPos  
  #if (area)
    area_light
    <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
    4, 4                // total number of lights in grid (4x*4z = 16 lights)
    adaptive 0          // 0,1,2,3...
    jitter              // adds random softening of light
    circular            // make the shape of the light circular
    orient              // orient light
  #end
  
  fade_distance 50 fade_power 2
  } 

#end

background {0}




#if (draw_mist) 
  #local i_spotlight =  
    interior{                                            
      media{   
      
        density {
          gradient y  
          density_map {
            [0  rgb     0]
            [1  rgb     1]
            
          } 
          scale 15
        }
        
        scattering{4,0.005 extinction 0} 
        intervals 3
        confidence 0.99               
          
      }
  };
  #local t_spotlight = texture{pigment{rgbt 1} finish{ambient 0 diffuse 0}};
  #include "colors.inc" 
  
  // spotlight beams (very slow)
   
  light_group {
    light_source {<19,ceil_height-10,2> rgb 40 fade_distance 7 fade_power 3}
    cone {<19,ceil_height-10,2>, 0.1, <-5,-4,10> 4 texture {t_spotlight} hollow interior {i_spotlight} } 
  }
  

  light_group {
    light_source {<-20,ceil_height-10,2> rgb 40 fade_distance 7 fade_power 3}
    cone {<-20,ceil_height-10,2>, 0.1, <0,-4,20> 4 texture {t_spotlight} hollow interior {i_spotlight} } 
  }


  light_group {
    light_source {<20,ceil_height-10,2> rgb 40 fade_distance 7 fade_power 3}
    cone {<20,ceil_height-10,2>, 0.1, <5,-4,11> 4 texture {t_spotlight} hollow interior {i_spotlight} } 
  }

// alternate method  
/*
  #local t_spotlight2 = texture {pigment {gradient y color_map{[0.3  rgbt <1,1,1,1>][1 rgbt <1,1,1,0.9>] } scale 15} };
  light_group {
    light_source {CamPos rgb 2}
    cone {<20,ceil_height-10,2>, 0.1, <-5,-4,10> 4 texture {t_spotlight2}  no_shadow} 
    cone {<-20,ceil_height-10,2>, 0.1, <0,-4,20> 4 texture {t_spotlight2}  no_shadow} 
    cone {<25,ceil_height-10,2>, 0.1, <5,-4,11> 4 texture {t_spotlight2}  no_shadow} 
   } 
*/
#end 

// Textures ///////////////////////////////////////////////////////////////////



// Scene  Objects /////////////////////////////////////////////////////////////   
#debug "define scene objects\n"
#if (draw_chairs)
  
  #declare vio1 =
  union {
    object {metal_chair1 rotate <0,90,0> scale 1/12 translate <0,1.1,0>}         
    #if (draw_violinists) object {violinist1_ scale 8 rotate <0,180,0> } #end 
    translate <0,-1,0>  
  };
   
  #declare vio2 =
  union {  
    object {metal_chair1 rotate <0,90,0> scale 1/12 translate <0,1.1,0>}         
    #if (draw_violinists) object {violinist2_ scale 8 rotate <0,180,0> } #end 
    translate <0,-1.1,0>  
  }; 
  
  #declare vio3 = 
  union {
    object {metal_chair1 rotate <0,90,0> scale 1/12 translate <0,0,0>}         
    #if (draw_violinists) object {violinist3_ scale 8 translate <0,0.2,0> rotate <0,180,0> } #end   
  }; 
 
  #declare cellist1=
  union { 
   #if (draw_cellists) 
      object {cellist1_ scale 8}
    #end 
    object {metal_chair1 rotate <0,180,0> scale 1/12}       
    rotate <0,-90,0>
  };

  #declare cellist2= 
/*  
  union { 
    #if (draw_cellists) 
      object {cellist2_ scale 8}
    #end 
    object {metal_chair1_chair1 rotate <0,180,0> scale 1/12 translate <0,-0.3,0>}       
    rotate <0,-90,0>
  };
*/  
union {
  union { 
    #if (draw_cellists) 
      object {cellist2_ scale 8}  
    #end
    object {metal_chair1 rotate <0,180,0> scale 1/12 translate <0,-0.3,0>}       
    rotate <0,-90,0>  
    }
  #if (draw_cellists)
    #if (using_megapov)
      motion_blur {
        type 0 
        union { 
          object {violin_bow_  rotate <0,80,100+5*clock> rotate <0,clock*10,0> translate <0.5,2.6,-1.6>}       
        }
      } 
    #else
      object {violin_bow_  rotate <0,80,100> rotate <0,10,0> translate <0.5,2.6,-1.6>} 
    #end 
  #end
};   
  
  

  #declare cellist3=
  union { 
    #if (draw_cellists) 
      object {cellist3_ scale 8}
    #end 
    object {metal_chair1 rotate <0,180,0> scale 1/12 translate <0,-0.3,0>}       
    rotate <0,-90,0>
  };



  #declare trumpeter1 = 
  union {
    object {metal_chair1 rotate <0,90,0> scale 1/12 translate <0,0,0>}         
    #if (draw_trumpeters) object {trumpeter1_ scale 8 translate <0,0.2,0> rotate <0,180,0> } #end 
    translate <0,0.2,0>
  }; 

  #declare trumpeter2 = 
  union {
    object {metal_chair1 rotate <0,90,0> scale 1/12 translate <0,0,0>}         
    #if (draw_trumpeters) object {trumpeter2_ scale 8 translate <0,0.2,0> rotate <0,180,0> } #end
    translate <0,-0.1,0>
  };
   
  #declare trumpeter3 = 
  union {
    object {metal_chair1 rotate <0,90,0> scale 1/12 translate <0,0,0>}         
    #if (draw_trumpeters) object {trumpeter3_ scale 8 translate <0,0.2,0> rotate <0,180,0> } #end
  }; 

  #declare clarinetist1 = 
  union {
    object {metal_chair1 rotate <0,90,0> scale 1/12 translate <0,0,0>}         
    #if (draw_clarinetists) object {clarinetist1_ scale 8 translate <0,0,0> rotate <0,-90,0> } #end
  }; 

  #declare clarinetist2 = 
  union {
    object {metal_chair1 rotate <0,90,0> scale 1/12 translate <0,0,0>}         
    #if (draw_clarinetists) object {clarinetist2_ scale 8 translate <0,0,0> rotate <0,-90,0> } #end
  }; 


  #include "rf_clarinet.inc"
  #declare bassoonist1 = 
  union {
    object {metal_chair1 rotate <0,90,0> scale 1/12 translate <0,0,0>}         
    #if (draw_bassoonists)
      #include "rf_clarinet.inc"
      union { 
        object {clarinetist2_ scale 8 translate <0,0,0> rotate <0,-90,0> } 
        object {rf_clarinet_ scale 10 scale <1,-1,1> rotate <-20,0,10> translate <0,4,0> }
        scale <-1,1,1>
        }
    #end
  }; 

  #declare flutist1 = 
  union {
    object {metal_chair1 rotate <0,90,0> scale 1/12 translate <0,0,0>}         
    #if (draw_flutists) object {flutist1_ scale 8 translate <0,0.2,0> rotate <0,180,0> } #end
  };

#declare french_hornist1 = 
  union {
    object {metal_chair1 rotate <0,90,0> scale 1/12 translate <0,0,0>}         
    #if (draw_french_horns) object {french_hornist1_ scale 8 translate <0,0.2,0> rotate <0,270+10,0> }  #end
    translate <0,0.2,0>
  } 
#declare french_hornist2 = 
  union {
    object {metal_chair1 rotate <0,90,0> scale 1/12 translate <0,0,0>}         
    #if (draw_french_horns) object {french_hornist2_ scale 8 translate <0,0.2,0> rotate <0,270+20,0> }  #end
    translate <0,0.2,0>
  } 





#end



// Scene ////////////////////////////////////////////////////////////////////// 
#debug "draw scene\n"

#if (draw_indoors)  
 #include "rf_riser.inc"

  // stage /////

  
  // floor 
 // #local t_floor_wood = texture {T_Wood23 } 
 #local t_floor_wood = texture {pigment {rgb <0.89,0.643,0.404>*0.8}}; 
 #local t_floor_wood = texture {pigment {bozo color_map{[0 rgb <0.89,0.643,0.404>*0.8][1 rgb <0.89,0.643,0.404>*0.6]}scale 0.1}}; 
  
  #local t_floor_finish = texture {pigment {rgbt 1} finish {/*phong 0.2 phong_size 10*/ reflection 0.1}};
  #include "rf_woodfloor.inc"
  #declare t_front_of_stage_slats = texture {pigment {gradient y color_map{[0 rgb 1][1 rgb 0.1]} scale 10} finish {ambient rgb 0.2}}; 
  #declare t_front_of_stage_grout = texture {pigment {rgb 0}};
  #declare t_front_of_stage = 
  texture {
    gradient x
    texture_map{
      [0   t_front_of_stage_slats]
      [0.9 t_front_of_stage_slats]
      [0.9 t_front_of_stage_grout]
      [1.0 t_front_of_stage_grout]
    }
  }

  #if (draw_curved_stage)
    
    difference { 
      union {
        wood_floor1(80,60,0.3,2,0.5,t_floor_wood,t_floor_finish,fsd,transform {translate <-40,0,-5>}) 
        box {<-40,-0.001,-1>,<40,-0.5,10> pigment {rgb 0} finish {phong 1 phong_size 40}}
        box {<-40,-10,0>,<40,-0.5,1> texture {t_front_of_stage}}
        }
      union {
        cylinder {<0,-1,0>,<0,1,0> 40 scale <1,1,0.3> pigment {rgb <1,0,0>} translate <0,0,8>}     
        box {<-40,-1,8>,<40,1,60> pigment {rgb <1,0,0>}} 
         
        inverse
      }
    }
  #else
    //  wood_floor1(80,60,0.3,2,0.5,t_floor_wood,t_floor_finish,fsd,transform {translate <-40,0,-5>}) // (orig)  
    
    
        wood_floor1(80,60,0.3,2,0.5,t_floor_wood,t_floor_finish,fsd,transform {translate <-40,0,-5>})
        wood_floor1(0.5,120,0.5,2,0.5,t_floor_wood,t_floor_finish,fsd,transform {rotate <0,90,0> translate <-50,0,-4>})
        box {<-40,-0.001,-4.5>,<40,-0.5,-5> pigment {rgb 0} finish {phong 1 phong_size 40}}
        box {<-40,-10,-5>,<40,-0.2,-0.01> texture {t_front_of_stage}}
  #end

  

  #macro curtain (len,height csd, txt, xfrm)   
    #local i=0;
    union {
      #while (i<len) 
        cone {<0,height,0>,RRand(0.1,0.5,csd),<0,0,0>,RRand(0.5,1,csd) translate <i,0,0> texture {txt}}
        #local i=i+RRand(0.4,0.9,csd);
      #end
      box {<0,0.5,0>,<len,height,0.000001>}
      transform {xfrm}
    }
  #end
  #declare t_dark_curtain = texture {pigment {rgb 0.2} finish {phong 0.201 phong_size RRand(10,100,csd)}};  
  #declare t_red_curtain = texture {pigment {rgb <0.2,0,0> }};
  
  curtain( 10,ceil_height,csd,t_dark_curtain, transform {translate <-40,0.2,20>}) 
  curtain( 20,ceil_height,csd,t_dark_curtain, transform {translate < 30,0.2,20>})
  curtain( 100,ceil_height,csd,t_dark_curtain, transform {translate <-50,0.2,50>}) // back curtain  (dark)


  // side walls and curtains
  union {
    box {<-3,0,0>,<3,ceil_height,2> translate <-30,0,0> }
    box {<-3,0,0>,<3,ceil_height,2> translate < 30,0,0> }
    box {<-30,ceil_height-5,0>,<30,ceil_height,2> }
    pigment {rgb 0.4}
    translate <0,0,-10>
    }
  union {
  //curtain(100,20,csd,t_red_curtain transform {translate <-50,ceil_height-20,0>})  // top curtain  
    #local i=0;
    #while (i<4)
      cylinder {<0,0,0>,<0,0,0.1> 4  texture {t_red_curtain normal {ripples scale 0.5 frequency 3}} scale <1.5,-1,1> translate <i*5,ceil_height-16+0.2*i,0.1*i>  no_shadow} 
      #local i=i+1;
    #end
    curtain(10,ceil_height,csd,t_red_curtain, transform {translate <-35,0,0>})  
    
    light_group {
      light_source {<18,0,-7> rgb 2 fade_distance 6 fade_power 2}
      curtain(30,ceil_height,csd,t_red_curtain, transform {scale <0.3,1,1> translate < 16,0,4>})
    }
    translate <0,0,-7>
    }
/*   
  // back curtain
  #local i=-100;
  #while (i<100)
    cone {<0,500,0>,RRand(0.1,0.5,csd),<0,0,0>,RRand(0.5,1,csd) translate <i,0,35> pigment {rgb 0.1} finish {phong 0.105 phong_size RRand(10,100,csd)}}
    #local i=i+RRand(0.4,0.9,csd);
  #end
*/ 

 // stage risers
  #if (draw_risers)
    #local i=-90;
    #while (i<65)
     //orig riser(6,1,6,transform {translate <-3,0,15> rotate <0,i,0>})
      riser(8,1,6,transform {translate <-4,0+0.00001*i,15> rotate <0,i,0>}) 
      #local i=i+22;
    #end 

    #local i=-90;
    #while (i<60)
      riser(12,1,6,transform {translate <-6,0+0.00001*i,15+6> rotate <0,i,0>})
      #local i=i+22;
    #end 
    
    
    // back risers
    #local i=-40;
    #while (i<40)
      riser(6,2,6,transform {translate <-3,0+0.00001*i,15+10> rotate <0,i,0>})
      #local i=i+22/2;
    #end   
  #end // risers



#else

#end


#if (draw_conductor)
  //box {<-2,0,-2>,<2,1,2> texture {T_Wood23}}
  #if (draw_risers) 
    riser(4,1,6, transform {translate <-2,0,-2>})
    object {conductor_music_stand scale <0.8,1,0.8> rotate <0,170,0> translate <0,1,3>}
  #end
  object {conductorB_ scale 8 translate <0,1,0>} 
#end

// stage dimensions
  #local rw = 6; // row width
  #local r1z = 8;  
  #local r2y = 0; // row2 height
  #local r2z = 13; //12 // row2 radius (of players)
  
  #local r3y = 1;
  #local r3z = 16;


#if (draw_chairs)  

  // 4 music stands
  #local i=-90;
  #while (i<100)
    object {musician_music_stand scale 0.8 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r1z-4> rotate <0,i,0>}
    #local i=i+180/5;
  #end

  // first row: 8 instruments 6 violins, 2 cellos 
  object {vio2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r1z> rotate <0,-90+180*0/7,0>}
  object {vio1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r1z> rotate <0,-90+180*1/7,0>}
  object {vio3 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r1z> rotate <0,-90+180*2/7,0>}
  object {vio1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r1z> rotate <0,-90+180*3/7,0>}
  object {vio2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r1z> rotate <0,-90+180*4/7,0>}
  object {vio3 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r1z> rotate <0,-90+180*5/7,0>}
  object {cellist3 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r1z> rotate <0,-90+180*6/7,0>} 
  object {cellist2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r1z> rotate <0,-90+180*7/7,0>} 

  // 8 music stands
  #local i=-90;
  #while (i<90)
    object {musician_music_stand scale 0.8 rotate <0,RRand(-5,5,tsd),0> translate <0,r2y,r2z-3.2> rotate <0,i,0>}
    #local i=i+180/8;
  #end


  // second row: 10 violins, 4 cellos  
  union {
  object {vio1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*0/14,0>}
  object {vio3 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*1/14,0>}
  object {vio2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*2/14,0>}
  object {vio1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*3/14,0>}
  object {vio2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*4/14,0>}
  object {vio3 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*5/14,0>}
  object {bassoonist1  rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*6/14,0> translate <0.5,0,0>}
  object {clarinetist1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*7/14,0>}
  object {clarinetist2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*8/14,0>}
  object {flutist1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*9/14,0>}
  object {flutist1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*10/14,0>} 
  object {cellist1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*11/14,0>} 
  object {cellist2 scale <-1,1,1> rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*12/14,0>}  
  object {cellist2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r2z> rotate <0,-90+180*13/14,0>} 
  translate <0,r2y,0>
  } 
  
  // third row: a bunch of trumpeters 20 trumpeters 

  // 10 music stands
  #local i=-90;
  #while (i<65)
    object {musician_music_stand scale 0.8 rotate <0,RRand(-5,5,tsd),0> translate <0,r3y,r3z> rotate <0,i,0>}
    #local i=i+180/11;
  #end
  
  union { 
  /*
    #local i=0;
    #while (i<16) 
      object {trumpeter1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*i/20,0>}
      object {trumpeter2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*(i+1)/20,0>} 
      object {trumpeter3 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*(i+2)/20,0>} 
      object {french_hornist1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*(i+3)/20,0>}
      object {french_hornist2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*(i+4)/20,0>}

      #local i=i+5;
      
    #end
    */
    
      object {trumpeter1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*5/20,0>}
      object {trumpeter2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*6/20,0>} 
      object {trumpeter3 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*7/20,0>} 
      object {trumpeter1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*8/20,0>}
      object {trumpeter2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*9/20,0>} 
      object {trumpeter3 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*10/20,0>}       
      object {trumpeter1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*11/20,0>}
      object {trumpeter2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*12/20,0>} 
      object {trumpeter3 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*13/20,0>}       
      object {trumpeter1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*14/20,0>}

      object {french_hornist1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*15/20,0>}
      object {french_hornist2 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*16/20,0>}    
      object {french_hornist1 rotate <0,RRand(-5,5,tsd),0> translate <0,0,r3z+3> rotate <0,-90+180*17/20,0>}

    translate <0,r3y,0>
  } 
  
  
  #if (draw_timpanist)
    #include "rf_timpani.inc"
    #include "rf_bass_drum.inc"
    #include "rf_chimes.inc"
    union {
      object {timpani scale inch_to_feet                     translate <3,0,3>}
      object {timpani scale inch_to_feet scale <0.9,1,0.9>   translate <1,0,1>} 
      object {timpani scale inch_to_feet scale <0.81,1,0.81> translate <-1.4,0,1>} 
      object {timpani scale inch_to_feet scale <0.72,1,0.72> translate <-3,0,3>} 
      
      // throw in a bass drum
      object {bass_drum scale inch_to_feet scale 0.8 rotate <0,45,0> translate <7,0,2>} 
      
      // and some chimes
      object {chimes rotate <0,40,0> translate <10,0,2>}
      
      #if (draw_conductor=0)
        #include "conductorB.inc" 
      #end
      object {conductorB_ scale 8 rotate <0,180+20,0> translate <0,-1,3>}
      translate <0,2,25>
    }
  #end
#end







// stage  
// row 2    
/*
difference {
  cylinder {<0,0,0>,<0,r2y,0>, r2z +rw/2} 
  cylinder {<0,0,0>,<0,r2y+1,0>, r2z -rw/2} 
  texture {T_Wood23}
}  
*/
//row 3 

/*

difference {
  cylinder {<0,0,0>,<0,r3y,0>, r3z+rw/2}
  cylinder {<0,-1,0>,<0,r3y+1,0>, r3z-rw/2} 
  plane {z,0}
  texture {T_Wood23}
}
*/

// spotlights
#if (draw_spotlights) 
  #local t_boom = texture {pigment {rgb 0.1}};
  #local spots3 = union {
    spot_light1(30+rand(lsd)*10,0.8,30, transform {scale inch_to_feet})
    spot_light1(30+rand(lsd)*10,0.8,30, transform {scale inch_to_feet translate <2,0,0>})
    spot_light1(30+rand(lsd)*10,0.8,30, transform {scale inch_to_feet translate <-2,0,0>})
    lighting_boom(10,1,1,t_boom, transform { translate <-5,1,0>})
    };
    
  
  #local i=0;
  #local i=num_spotlights -10;
  #while (i<num_spotlights)                       
        object {spots3 rotate <0,rand(lsd)*360,0> translate <RRand(-50,30,lsd),ceil_height-4,RRand(20,50,lsd)> no_shadow}

        //object {      
        //spot_light1 (RRand(0,80,lsd), rand(lsd)*3/*<0.8,0.8,1>*/, 30, transform {scale inch_to_feet rotate <0,360*rand(lsd),0> translate <RRand(-50,20,lsd),ceil_height-4,RRand(20,50,lsd)>})
        //no_shadow
        //}
    #local i=i+1;
  #end 
#end

#if (draw_ceiling)
// style : 0= no trusses, 1=small trusses only, 2=small+large trusses
  #include "rf_ceiling.inc"
  warehouse_ceiling (100, 60, 0.5, 1, transform {translate <-50,ceil_height,0>})
#end


#if (draw_audience)

  #include "mp3man2.inc" 
  #include "mp3mandate2.inc"  
  
#declare t_audience_seat_back_fabric = texture {pigment {bozo color_map {[0 rgb <0.3,0,0>][1 rgb <0.1,0,0>]} scale 0.01} };
#declare t_audience_seat_back_metal = texture {pigment {rgb 0.1} finish {phong 1 phong_size 120}};
#declare t_audience_seat_back =
texture {
  gradient z
  texture_map {
    [0   t_audience_seat_back_fabric ]
    [0.4 t_audience_seat_back_fabric ] 
    [0.4 t_audience_seat_back_metal]
    [0.6 t_audience_seat_back_metal]
    [0.6 t_audience_seat_back_fabric]
    [1.0 t_audience_seat_back_fabric]
  }
};

#declare audience_seat_back = 
union {                               
  Round_Box_Union(<-2,0,0>,<20,20,2>,1)
  texture {t_audience_seat_back scale 2}
  scale 1/12
  scale <1,1,2>
  
  } 
  
  light_group {
    light_source {0*x rgb aud_light /* *<0.776,0.957,0.988>*/ translate CamPos + <0,1,1>  fade_distance 0.5 fade_power 2}
    object {mp3mandate2_ scale 8 rotate <0,90,0> translate <6.9,1.2,-18> no_shadow} 
    object {audience_seat_back translate <6.9,1.2,-18>+<-0.8,2.3,-0.7> }
    object {mp3man2_ scale 8 rotate <0,0,0>  translate <9,0.2,-18> no_shadow}
    object {audience_seat_back translate <9,0,-18>+<-0.8,3.5,-0.7> } 

    #if (draw_front_row) 
    
       // #if (draw_trumpeters=0)
       //   #include "trumpeter2.inc" 
       // #end
        
        #if (draw_clarinetists=0)
          #include "clarinetist1.inc"    
          #include "clarinetist2.inc"
        #end  
        object {clarinetist2_ scale 8 rotate <0,90,0> translate <6.4,-0.4,-15>}  
        object {audience_seat_back translate <6.4,-0.4,-15>+<-0.8,2.5,-0.6> }                  
        object {clarinetist1_ scale 8 rotate <0,90,0> translate  <8.3,-0.4,-15> }
        object {audience_seat_back translate <8.3,-0.4,-15>+<-0.8,2.5,-0.6> }  
    #end                    

    
  }
#end



// Notes ///////////////////////////////////////////////////////////////////////
/*
stage is a semicircle of raised platforms


texture notes
vio1 V3HeadMale2 (shared) body: <0.596,0.404,0.376>  opt
vio2 Cptn_Head_M          body: <0.827,0.565,0.463>  opt
vio3 DelSP3_Head          body: <0.827,0.565,0.463>  opt - hair could be made a pattern

cel1 MNH_Head_Natural body: <0.796,0.588,0.463> opt
cel2 M3_HeadMHI M3_BodyMHI opts: eyes
cel3 M3_HeadMHI V3BodyMale2 opts: eyes, teeth

trm1 V3HeadMale2 V3BodyMale2 (shared) opt: eyes
trm2 V3HeadMale2 V3BodyMale2 (shared) opt: eyes
trm3 V3HeadMale2 V3BodyMale2 (shared) opt: eyes

cla1 RW001_Head_DC RW001_Body_DC no opts

flu1 SophieHeadMkp1 SophieBody opt




*/





   
   