// Persistence of Vision Ray Tracer Scene Description File
// File: rf_riser.inc
// Vers: 3.6
// Desc: stage riser macro
// Date: April 5, 2006
// Auth: Rob Fitzel
// Unit: feet


#ifndef(Metals_Inc_Temp)
  #include "metals.inc"
#end

#macro riser(rx,ry,rz,xfrm) 
  #local t_riser_metal = texture {T_Chrome_2C}; 
  #local t_riser_middle = texture {pigment {rgb <0.808,0.749,0.494>/1.5}};

  #local riser_leg = 
  union {
    box {<0,0,0>,<0.05,ry-0.1,0.05> texture {t_riser_metal}}
    cylinder {<0.025,0,0.025>,<0.025,0.1,0.025> 0.04 texture {pigment {rgb 0}}  }
  };
    
  #local riser_leg_pair =
  union {
    object {riser_leg translate <0,0,0.2>}  
    object {riser_leg translate <0,0,rz-0.2>} 
    box {<0,0,0.21>,<0.05,0.05,rz-0.21> translate <0,ry*0.4,0> texture {t_riser_metal}} 
    cylinder {<0,ry*0.4,0.21>,<0,ry*0.95,rz-0.21>, 0.02 texture {t_riser_metal}}
    cylinder {<0,ry*0.95,0.21>,<0,ry*0.4,rz-0.21>, 0.02 texture {t_riser_metal}}  
  
  };
  
  union {
    box {<0,0,0>,<rx,-0.1,rz> translate <0,ry,0> texture {t_riser_metal} } 
    box {<0.4,0.0001,0.4>,<rx-0.4,0,rz-0.4> translate <0,ry,0> texture {t_riser_middle}}
    
    
    #local i=1;
    #while (i<rx)
      object {riser_leg_pair translate <i,0,0.2>}  
      #local i=i+1;
    #end 
    
    // first & last legs
    object {riser_leg_pair translate <   0.1,0,0.2>}  
    object {riser_leg_pair translate <rx-0.1,0,0.2>}  


    transform {xfrm}  
  }
    
#end