// Persistence of Vision Ray Tracer Scene Description File
// File: strings.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: 18-Apr-06
// Auth: Sean Day
//

//#version 3.5; 
#version unofficial megapov 1.2; 

#include "colors.inc"
#include "shapes.inc"       

#declare showStrings = 1;
#declare useTestTex = 0;     
#declare useRadiosity = 2;   // 0=none, 1=load, 2=save        
#declare useHDRI = 1;           
#declare useFocalBlur = 0; //0 = none 1-100 1 = low 100 = high




#declare PRETRACE_END=2/image_width;

global_settings {
 assumed_gamma 1.0
// ambient_light 0.0 
 max_trace_level 15        
#if(useRadiosity) 
 radiosity{ 
  // save settings: modified Outdoor settings from rad_def.inc
  #if (useRadiosity=2) 
//    adaptive 1
    pretrace_start 1
    pretrace_end  PRETRACE_END //1/image_width   
    
    count 500
    nearest_count 10
    //error_bound 0.2   
    error_bound { 0.2 adaptive 2.0, 20 }
  
    low_error_factor .8
    gray_threshold 0
    recursion_limit 2
    brightness 0.8
    adc_bailout 0.01/2
    normal on
    randomize on
    save_file "guitar.rad"
  #end
  #if(useRadiosity=1)
    // load settings  
    pretrace_start 1 pretrace_end 1 
    load_file "guitar.rad" 
//    error_bound 0.07    // it's important to specify the same value used to save data
    error_bound { 0.2 adaptive 2.0, 20 }
    recursion_limit 2  // also the same if specified
    always_sample off  // no more samples: specially useful with focal blur
    normal on
    randomize on
  #end
 }
 #end
}  

#if(useHDRI)
sphere {
  0,5000
  pigment { image_map { hdr "museum.hdr" once interpolate 2 map_type 1 } }
  finish { ambient 0.6 diffuse 0 }
  scale <1,-1,1>
  hollow
  //rotate x*180 
  rotate <0, 0, 0> 
  translate <0, 0, 0>
}           
#end   




camera {
  location  <0, 0, -50.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0, 0, 0>
#if(useFocalBlur)
  aperture 10          // [0...N] larger is narrower depth of field (blurrier)
  blur_samples useFocalBlur*5        // number of rays per pixel for sampling
//  focal_point <15,2,118>    // point that is in focus <X,Y,Z>
  focal_point <20,-5,119>    // point that is in focus <X,Y,Z>
  confidence 0.99999//0.8999+(useFocalBlur/1000)           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/(20000*useFocalBlur)            // [0...1] how precise to calculate (smaller is more accurate)
#end
}

 

light_source {
  0
  colour (White+(Gold*1.5))*4  // light's color
  area_light
  <15, 0, 0> <0, 0, 15> // lights spread out across this distance (x * z)
  15, 15                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light    
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 70
  fade_power 2

//  translate <-10, 150, -180>
  translate <-20, 170, -120>
}


#declare generalRand = seed(3432); 

// Macro to return a random number

#macro gr(num)
        rand(generalRand)*num
#end


// knob used to tune string


#declare shape1 = difference
{
        union
        {
                cylinder { <0, 0, 0> <0, 20, 0> 5 }
                sphere { <0, 0, 0> 5 scale <1, 0.2, 1> translate <0, 20, 0> }
        }                                                                    
        torus { 5.1, 1 scale <1, 7.5, 1> translate <0, 11, 0> }
}

#declare silverTex = texture 
        { 
                pigment
                {
                        rgb <0.5, 0.51, 0.525> 
                }                            
                finish { ambient 0 specular 1 roughness 0.025 brilliance 8 reflection { 0.1, 0.025 metallic fresnel on } conserve_energy }                 
        }      
        texture 
        { 
                pigment
                {       
                        wrinkles  
                        triangle_wave
                        turbulence 0.3
                        omega 0.7
                        
                        colour_map
                        {
                                [ 0.0 rgbt <0.45, 0.41, 0.39, 1> ] 
                                [ 0.4 rgbt <0.45, 0.41, 0.39, 0> ] 
                                [ 0.7 rgbt <0.4, 0.35, 0.3, 0> ]
                                [ 1.0 rgbt <0.4, 0.35, 0.3, 1> ]
                        }      
                        scale 0.25
                }                            
                finish { ambient 0 specular 1 roughness 0.025 brilliance 7 reflection { 0.051, 0.0125 metallic fresnel on } conserve_energy }                 
        }      
        texture 
        { 
                pigment
                {       
                        wrinkles  
                        turbulence 0.3
                        omega 0.75
                        
                        colour_map
                        {
                                [ 0.0 rgbt <1, 1, 1, 1> ] 
                                [ 0.8 rgbt <1, 1, 1, 1> ] 
                                [ 0.8 rgbt <0.125, 0.05, 0, 1> ] 
                                [ 0.95 rgbt <0.125, 0.05, 0, 0.1> ] 
                                [ 1.0 rgbt <0.125, 0.05, 0, 0> ]
                        }      
                        scale 1.5
                }                            
                finish { ambient 0 specular 1 roughness 0.025 brilliance 6 reflection { 0.05, 0.0125 metallic fresnel on } conserve_energy }                 
        }   
#declare tuner = union
{
        difference
        {
                object { Round_Cylinder_Union(<0, 0, 0>, <0, 0, 15>, 12, 2) }
                cylinder { <0, 0, -0.1> <0, 0, 15.1> 8 }
        }
        object { Round_Cylinder_Union(<0, 0, 0>, <0, 0, 15>, 7.99, 1) }
        difference
        {
                object { Round_Cylinder_Union(<0, 0, -15>, <0, 0, 1>, 4, 1) }  
                torus { 4, 1.5 rotate <90, 0, 0> translate <0, 0, -5> }
                torus { 4, 1.5 rotate <90, 0, 0> translate <0, 0, -10> }
        }                
        difference
        {
                object { Round_Cylinder_Union(<-1.5, 0, 0>, <1.5, 0, 0>, 6, 0.5) scale <1, 1.5, 1> }
                cylinder { <0, -15, 0> <0, 15, 0> 6 scale <0.25, 1, 1> translate <2.5, 0, 0> }
                cylinder { <0, -15, 0> <0, 15, 0> 6 scale <0.25, 1, 1> translate <-2.5, 0, 0> }
                rotate <0, 0, 40>
                translate <0, 0, -20> 
        } 
        Round_Box_Union(<-12, 8, 0>, <12, 12, 15>, 1) 
        texture { silverTex }
}

#declare p1 = union
{
        difference
        {
                union
                {
                        object { shape1 }
                        // add torus's for ring effect to top
                        #declare h=0.3;
                        #while(h < 4.5)  
                                #declare tS = 0.2+gr(0.1);
                                #declare tH = <0, 0, 0>;
                                #declare tP = trace(shape1, <0, 30, h>, <0, -1, 0>, tH); 
                                torus { h, tS scale <1,0.7-(h/30), 1> translate <0, tP.y-(tS*0.55), 0> }
                                #declare h=h+0.3+gr(0.3);
                        #end
        
                }                                                                    
                // add torus's for ring effect to side
                #declare h=3;
                #while(h < 19)  
                        #declare tS = 0.075+gr(0.1);
                        #declare tH = <0, 0, 0>;
                        #declare tP = trace(shape1, <0, h, -10>, <0, 0, 1>, tH); 
                        torus { -tP.z+(tS*(0.6+gr(0.4))), tS scale <1,2.2+gr(0.85), 1> translate <0, h, 0> }
                        #declare h=h+0.13+gr(0.175);
                #end
                // add torus's for ring effect to top
                #declare h=0.65;
                #while(h < 5)  
                        #declare tS = 0.2+gr(0.1);
                        #declare tH = <0, 0, 0>;
                        #declare tP = trace(shape1, <0, 30, h>, <0, -1, 0>, tH); 
                        torus { h, tS scale <1,0.2, 1> translate <0, tP.y+(tS*0.3), 0> }
                        #declare h=h+0.3+gr(0.3);
                #end
        
                cylinder { <0, 11.5, -6> <0, 11.5, 6> 2 }    
                sphere { <0, 0, 0> 2.25 scale <1, 1.5, 1> translate <0, 11.5, -5> } 
                bounded_by { object { shape1 scale 1.1 } }
        }   
        // base
        union
        {
                difference
                {
                        intersection 
                        {
                                sphere { 0, 20 translate <0, -17, 0> }
                                cylinder { <0, -5, 0> <0, 2, 0> 10 }
                        }        
                        cylinder { <0, -3, 0> <0, 3, 0> 5.75 }                
                }    
                torus { 5.75, 0.5 translate <0, 1.5, 0> }            
                cylinder { <0, -5, 0> <0, -0.113, 0> 10.25  } 
                torus { 9.75, 0.5 translate <0, -0.113, 0> }
        }    
        
        texture { silverTex }  
   

        
}
// add strings

#declare stringFinish = finish { ambient 0 specular 2 roughness 0.01 phong 2 phong_size 125 brilliance 2  reflection { 0.1, 0.05 fresnel on metallic } conserve_energy }
#macro String(rad, numLoops, rotation, freq, sColour) 
union
{        
        // top string
        #declare h=11.5;       
        #declare tH = <0, 0, 0>;
        #declare tP = trace(shape1, <0, h, -10>, <0, 0, 1>, tH); 
        union
        {
                intersection
                {
                        torus 
                        { 
                                -tP.z+rad, rad translate <0, h, 0> 
                        }
                        box { <0, -rad, tP.z-(rad*2)> <-tP.z+(rad*2), rad, -tP.z+(rad*2)> translate <0, h, 0> }                
                        texture
                        {
                                pigment { sColour }
                                normal { radial frequency freq bump_size (100/freq)  scallop_wave turbulence 0.04 omega 0.6  }  
                                finish { stringFinish }
                                rotate <0, gr(360), 0> 
                        }
                }       
                intersection
                {
                        torus { rad rad } 
                        union
                        {
                                box { <-rad*2, -rad, -rad*2> <0, rad, 0> } 
                                box { <-rad*2, -rad, -rad*2> <0, rad, 0> rotate <0, 22, 0> } 
                        }
                        texture
                        {
                                pigment { sColour }
                                normal { radial frequency freq/8 bump_size (100/freq)  scallop_wave turbulence 0.04 omega 0.6  }  
                                finish { stringFinish }
                                rotate <0, gr(360), 0> 
                        }
                        translate <0, h, tP.z>   
                }
                // straight part   
                #declare stringEnd=15+gr(20);
                cylinder 
                { 
                        <0, 0, 0> <0, 0, stringEnd> rad translate <-rad, h, 0> 
                        texture 
                        {
                                pigment { sColour }
                                normal { marble rotate <0, -90, 0> frequency freq/32 bump_size (100/freq) scallop_wave turbulence 0.04 omega 0.6 translate <-(freq/64),0,0> }
                                finish { stringFinish }
                        }  
                        rotate <0, 22, 0>
                        translate <0, 0,  tP.z>
                        
                } 
                // add half torus to end
                union
                {        
                        torus { rad-(rad/4), rad/4 rotate <90, 0, 0> rotate <5+gr(10), 5+gr(10), 5+gr(10)> } 
                        intersection
                        {
                                torus { rad-(rad/4), rad/4 rotate <90, 0, 0> }      
                                box { <-(rad+(rad/2)), -(rad+(rad/2)), -(rad+(rad/2))> <rad+(rad/2), rad+(rad/2), rad+(rad/2)> translate <rad/2+gr(rad/2), rad/2+gr(rad), 0>  rotate <0, 0, gr(360)> }
                                rotate <-10-gr(20), 15+gr(20), -20-gr(20)>
                                translate <gr(rad*0.1), gr(rad*0.1), rad>                
                        }
                        texture 
                        {
                                pigment { sColour }
                                finish { stringFinish }
                        }  
                        translate <-rad, h, stringEnd+(rad*0.7)>
                        rotate <0, 22, 0> 
                        translate <0,0, tP.z>
                }
                rotate <0, -25, 0> 
                rotate <0, rotation, 0>
        }
        
        // rest of string loops
        #declare h=11.5-rad*2;       
        #declare endP = h-((numLoops-1)*rad*2);
        #while(h >= endP)  
                #declare tH = <0, 0, 0>;
                #declare tP = trace(shape1, <0, h, -10>, <0, 0, 1>, tH); 
                torus 
                { 
                        -tP.z+rad, rad translate <0, h, 0> 
                        texture
                        {
                                pigment { sColour }
                                normal { radial frequency freq bump_size (100/freq)  scallop_wave turbulence 0.04 omega 0.6  }  
                                finish { stringFinish }
                                rotate <0, gr(360), 0> 
                        }
                }
                #declare h=h-(rad*2);
        #end                       
        // bottom string
        #declare tH = <0, 0, 0>;
        #declare tP = trace(shape1, <0, h, -10>, <0, 0, 1>, tH); 
        torus 
        { 
                -tP.z+rad, rad translate <0, h, 0> 
                texture
                {
                        pigment { sColour }                                            
                        finish { stringFinish }
                        normal { radial frequency freq bump_size (100/freq)  scallop_wave turbulence 0.04 omega 0.6  }  
                        //rotate <0, gr(360), 0> 
                }   
        }           
        // straight part
        cylinder 
        { 
                <0, 0, 0> <1000, 0, 0> rad translate <0, h, tP.z-rad> 
                texture 
                {
                        pigment { sColour }
                        normal { marble frequency freq/32 bump_size (100/freq) scallop_wave turbulence 0.04 omega 0.6 translate <-(freq/64),0,0> }
                        finish { stringFinish }
                } 
                
        }
}
#end

// base
#declare sScale = 0.75;

union
{
        object { Round_Box_Union(<-200, -25, 0>, <0, 0, 25>, 1) rotate <0, -10, 0> translate <0, 0, -25> }       
        object { Round_Box_Union(<-200, -25, -25>, <0, 0, 0>, 1) rotate <0, 10, 0> translate <0, 0, 25> }       
        object { Round_Box_Union(<-200, -25, -25>, <0, 0, 25>, 1) }  
        object { Round_Box_Union(<0, -25, -25>, <70, 0, 50>, 1) rotate <0, 10, 0> translate <-200, 0, 25> rotate <0, -10, 0>  }  

#if(showStrings)        
        // add strings
        // top 3
        union
        {
                object { p1 rotate <0, -30, 0> }      
                object { String(0.5, 5, -30, 150, rgb <0.9, 0.565, 0.12> ) }   
                scale sScale  
                rotate <0, 3, 0>
                translate <-160, 0.5, 13> rotate <0, 10, 0>  
        }
        object { tuner scale <1, 1, 1> translate <-160, -36, -50> scale <1, 1, -1> }

        union
        {
                object { p1 rotate <0, 25, 0> }
                object { String(0.35, 6, 25, 200, rgb <0.45, 0.425, 0.4> ) } 
                scale sScale
                rotate <0, 1, 0>
                translate <-110, 0.5, 13> rotate <0, 10, 0>  
        }
        object { tuner scale <1, 1, 1> translate <-110, -36, -40> scale <1, 1, -1> }

        union
        {
                object { p1 rotate <0, 90, 0> }
                object { String(0.25, 8, 90, 250, rgb <0.5, 0.5, 0.52> ) } 
                scale sScale
                rotate <0, -5, 0>
                translate <-60, 0.5, 13> rotate <0, 10, 0>  
        }
        object { tuner scale <1, 1, 1> translate <-60, -36, -30> scale <1, 1, -1> }

        // bottom 3
        union
        {
                object { p1 rotate <0, 180, 0>  }
                object { String(0.6, 5, 180, 90, rgb <0.9, 0.565, 0.12> ) }   
                scale sScale
                rotate <0, 3, 0>
                scale <1, 1, -1>
                translate <-160, 0.5, -13> rotate <0, -10, 0>  
        }
        object { tuner scale <1, 1, 1> translate <-160, -36, -50> }

        union
        {
                object { p1 rotate <0, 200, 0> }
                object { String(0.7, 3, 200, 60, rgb <0.9, 0.565, 0.12> ) } 
                scale sScale
                rotate <0, 1, 0>
                scale <1, 1, -1>
                translate <-110, 0.5, -13> rotate <0, -10, 0>  
        }
        object { tuner scale <1, 1, 1> translate <-110, -36, -40> }

        union
        {
                object { p1 rotate <0, 160, 0> }
                object { String(0.8, 2, 160, 40, rgb <0.9, 0.565, 0.12> ) } 
                scale sScale
                rotate <0, -5, 0>
                scale <1, 1, -1>
                translate <-60, 0.5, -13> rotate <0, -10, 0>  
        }                       
        object { tuner scale <1, 1, 1> translate <-60, -36, -30> }
        
#end            
        // wood texture
        
        texture
        {
                pigment 
                {
                        bozo                 
                        turbulence 0.1275
                        omega 0.8
                        lambda 3
                        colour_map
                        {
                                [ 0.0 rgb <0.3, 0.01, 0> ]
                                [ 0.1 rgb <0.2, 0.002, 0> ]
                                [ 0.3 rgb <0.15, 0.01, 0> ]
                                [ 0.7 rgb <0.12, 0.005, 0> ]
                                [ 0.9 rgb <0.243, 0.01, 0> ]
                                [ 1.0 rgb <0.12, 0.0025, 0> ]
                        }                                  
                        rotate <0, 90, -1>         
                        scale <50, 10,10>
                        
                         
                }      
        }     
        texture
        {
                pigment 
                {
                        wood                 
                        turbulence 0.1275
                        omega 0.7
                        lambda 3
                        colour_map
                        {
                                [ 0.0 rgbt <0.2, 0.04, 0, 0.8> ]
                                [ 0.1 rgbt <0.1, 0.01, 0, 0.1> ]
                                [ 0.3 rgbt <0.2, 0.04, 0, 0.5> ]
                                [ 0.7 rgbt <0.1, 0.01, 0, 0.7> ]
                                [ 0.9 rgbt <0.2, 0.04, 0, 0.1> ]
                                [ 1.0 rgbt <0.1, 0.01, 0, 0.7> ]
                        }                                  
                        rotate <0, 90, -1>         
                        scale <10, 10,3>
                        
                         
                }      
        }     
        texture
        {
                pigment 
                {
                        wood                 
                        turbulence 0.11
                        omega 0.67
                        lambda 2
                        colour_map
                        {
                                [ 0.0 rgbt <1, 1, 1, 1> ]
                                [ 0.1 rgbt <1, 1, 1, 1> ]
                                [ 0.1 rgbt <0.03, 0.001, 0.001, 1> ]
                                [ 0.125 rgbt <0.03, 0.001, 0.001, 0.1> ]
                                [ 0.15 rgbt <0.03, 0.001, 0.001, 1> ]
                                [ 0.15 rgbt <1, 1, 1, 1> ]
                                [ 0.7 rgbt <1, 1, 1, 1> ]
                                [ 0.7 rgbt <0.03, 0.001, 0.001, 1> ]
                                [ 0.75 rgbt <0.03, 0.001, 0.001, 0.1> ]
                                [ 0.8 rgbt <0.03, 0.001, 0.001, 1> ]
                                [ 0.8 rgbt <1, 1, 1, 1> ]
                        }                                  
                        rotate <0, 90, -1>         
                        scale <10, 10,3>
                        
                         
                }      
        }       
        texture // varnish
        {
                pigment 
                { 
                        granite 
                        scallop_wave    
                        turbulence 0.8
                        omega 0.8 
                        colour_map 
                        { 
                                [ 0.0 rgbt <0.3, 0, 0, 0.95> ]
                                [ 0.075 rgbt <0.3, 0, 0, 0.95> ]
                                [ 0.075 rgbt <0.9, 0.8, 0.6, 0.15> ]
                                [ 0.15 rgbt <0.9, 0.8, 0.6, 0.15> ]
                                [ 0.15 rgbt <0.3, 0, 0, 0.95> ]
                                [ 0.2 rgbt <0.3, 0, 0, 0.95> ]
                                [ 0.2 rgbt <0.5, 0.3, 0.02, 0> ]
                                [ 0.25 rgbt <0.5, 0.3, 0.02, 0> ]
                                [ 0.25 rgbt <0.3, 0, 0, 0.95> ]
                                [ 1.0 rgbt <0.3, 0, 0, 0.95> ]
                        }               
                        scale 100
                }
                finish { ambient 0 phong 1 phong_size 90 reflection 0.025 }     
                normal { wrinkles 0.01 turbulence 0.3 scale <100, 0.5, 0.5> rotate <0, 0, -1> }
                
        }
        rotate <-45, -20, -38> 
        translate <90, -65, 145>
}