#include "colors.inc"
//#include "..\axis.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"

//==========================================================================================================================
#declare mm=0.01;
#declare cm=10*mm;
#declare m=100*cm;
//==========================================================================================================================
#declare IsDebugMode=no;
#declare IsRadiocityMode=no; 
#declare RadiocityQualityHigh=no;
#declare NeedUseFog=yes;
#declare NeedShowLightLines=yes;
#declare NeedFocalBlur=no;

#declare Metall1=T_Gold_1E;
#declare Metall2=T_Chrome_1A; // T_Silver_1A;//T_Chrome_1A;

#declare FogMaterial=material{

  texture{pigment{color rgbt<1,1,1,1>} } 
  
  
  interior
   { media
     { emission 0.2
     //scattering { 4 0.5 }
     //absorption rgbf 0.1
     
     
       density
       { planar density_map
         { [0 rgb 0]
           [0.1 rgb <0.5,0.5,0.5>]
           //[0.7 rgb 1]
           [0.8 rgb <0,0,0>]
           [1 rgb 1]
         }
         
       warp { turbulence <1,1,1> octaves 5 lambda 0.5 omega 0.3 }         
       
       scale 1*m
       
       scale <0.2,1,0.5>
       
       }       
     }
   }


}


//==========================================================================================================================
#declare DoorH=2*m;
#declare DoorW=0.8*m;
#declare DoorD=6*cm;
#declare DoorOpenAngle=60; //60

#declare DRaiseW=DoorD;
#declare DRaiseAngle=30;

#declare RaiseSpace=15*cm;
#declare BottomRaiseEnd=90*cm;
#declare BottomRaiseStart=20*cm;
#declare UpperRaiseStart=110*cm;
#declare UpperRaiseEnd=DoorH-BottomRaiseStart;

#declare DoorBoxD=1.5*DoorD;
#declare DoorBoxW=10*cm;
#declare DoorBoxWDelta=3*mm;
#declare DoorBoxHDelta=1*cm;

#declare DoorLoopH=12*cm;
#declare DoorLoopW=0.8*DoorD;
#declare DoorLoopR=0.5*cm;
#declare DoorLoopD=1.5*mm;
#declare DoorLoop1_Y=0.5*m;
#declare DoorLoop2_Y=1.5*m;

#declare BoltR=1.5*mm;

#declare DoorKnobY=1*m;
#declare DoorKnobX=8*cm;
#declare DoorKnobBaseRMax=3*cm;
#declare DoorKnobBaseRMin=1*cm;
#declare DoorKnobBaseH=2*cm;
#declare DoorKnobLen=12*cm;

#declare LockHolePlateH=10*cm;
#declare LockHolePlateW=DoorD-1.5*cm;
#declare LockHoleD=3*cm;
#declare LockHoleW=1*cm;
#declare LockHoleH=3*cm;
#declare LockHolePlateD=2*mm;

#declare Door=merge{
  // doorKnob     
  #local LockHoleDiff=merge{
  
    box{<-1*mm,-1*mm,-1*mm>,<LockHolePlateD+1*mm,LockHolePlateH+1*mm,LockHolePlateW+1*mm> translate <-LockHolePlateD,-0.5*LockHolePlateH,-0.5*LockHolePlateW>}
    box{<-1*mm,-1*mm,-1*mm>,<LockHoleD+1*mm,LockHoleH+1*mm,LockHoleW+1*mm> translate <-LockHoleD,-0.5*LockHoleH,-0.5*LockHoleW> }
    
    translate z*(0.5*(DoorD-LockHolePlateW) + 0.5*LockHolePlateW)
    
  }
  
  #local LockHolePlate=difference{
    box{<0,0,0>,<LockHolePlateD,LockHolePlateH,LockHolePlateW> translate <-LockHolePlateD,-0.5*LockHolePlateH,-0.5*LockHolePlateW>}
    box{<-1*mm,-1*mm,-1*mm>,<LockHoleD+1*mm,LockHoleH+1*mm,LockHoleW+1*mm> translate <-LockHoleD,-0.5*LockHoleH,-0.5*LockHoleW> }    
    
    #local BoltHole=cylinder{<-1*m,0,0>,<1*m,0,0>, BoltR}
    
    object{BoltHole translate y*0.4*LockHolePlateH}
    object{BoltHole translate y*-0.4*LockHolePlateH}
    
    translate z*(0.5*(DoorD-LockHolePlateW) + 0.5*LockHolePlateW)
    #if (IsDebugMode)
      pigment{color Brown}
    #else
      texture{Metall1}
    #end  
  }
  
  #local LockHead=box{<0,0,0>,<LockHoleD+1*cm,LockHoleH,LockHoleW> translate <-LockHoleD,-0.5*LockHoleH,-0.5*LockHoleW>       
    translate z*(0.5*(DoorD-LockHolePlateW) + 0.5*LockHolePlateW)
    
    #if (IsDebugMode)
      pigment{color Brown}
    #else
      texture{Metall1}
    #end  
  }
  
  #local DoorKnobBase=difference{
    #local ConeHole=cylinder{<0,0,-1>,<0,0,DoorKnobBaseH>, BoltR}
    
    cone{<0,0,0>,DoorKnobBaseRMax,<0,0,DoorKnobBaseH>,DoorKnobBaseRMin}    
    
    object{ConeHole translate y*0.5*DoorKnobBaseRMax}
    object{ConeHole translate y*-0.5*DoorKnobBaseRMax}
  }  
  #local DoorKnobStock=merge{
    cylinder{<0,0,0>,<0,0,DoorKnobBaseH*2>,DoorKnobBaseRMin} 
    sphere{<0,0,DoorKnobBaseH*2>,DoorKnobBaseRMin}
    
    intersection{
      cone{<0,0,0>,DoorKnobBaseRMin,<DoorKnobLen*2.5,0,0>,0}
      box{<0,-1*m,0>,<DoorKnobLen,1*m,1*m>}
      
      rotate z*180
      translate z*(DoorKnobBaseH*2)
    }
    
  }
  #local DoorKnob=merge{
    
    object{DoorKnobStock}
    object{DoorKnobBase}
    
    #if (IsDebugMode)
      pigment{color Brown}
    #else
      texture{Metall1}
    #end  
  } 
  // door Loops
  #local DLDiff=merge{
    cylinder{<0,-1*mm,0>,<0,DoorLoopH+1*mm,0,>, DoorLoopR+1*mm}
    sphere{<0,-1*mm,0>, DoorLoopR+1*mm}
    sphere{<0,DoorLoopH+1*mm,0,>, DoorLoopR+1*mm}
    box{<-0.5*DoorLoopD-1*mm,-1*mm,-1>,<0.5*DoorLoopD+1*mm,DoorLoopH+1*mm,DoorLoopW+1*mm> }
    pigment{color White}
  }  
  
  #local DoorLoopPlate=difference{
    #local BoltCone=merge{ 
      cone{<-DoorLoopD-1*mm,0,0>,BoltR+2*mm, <DoorLoopD+1*mm,0,0>,0}
      cone{<-DoorLoopD-1*mm,0,0>,0, <DoorLoopD+1*mm,0,0>,BoltR+2*mm}
    }
    box{<-DoorLoopD,0,0>,<DoorLoopD,DoorLoopH,DoorLoopW>}
    object{BoltCone translate <0,0.5*DoorLoopW,0.5*DoorLoopW>}
    object{BoltCone translate <0,DoorLoopH-0.5*DoorLoopW,0.5*DoorLoopW>}
  }  
  #local DoorLoopA=merge{
    difference{
      object{DoorLoopPlate}
      cylinder{<0,0.5*DoorLoopH-1*mm,0>,<0,DoorLoopH+1*mm,0>, DoorLoopR+2*DoorLoopD}
    }  
    cylinder{<0,0,0>,<0,0.5*DoorLoopH-1*mm,0>, DoorLoopR}
    cylinder{<0,0,0>,<0,DoorLoopH+1*mm,0>, DoorLoopR-DoorLoopD-1*mm}
    
    #if (IsDebugMode)
      pigment{color Brown}
    #else
      texture{Metall1}
    #end  
  }   
  #local DoorLoopB=merge{
    difference{
      object{DoorLoopPlate}
      cylinder{<0,-1*mm,0>,<0,0.5*DoorLoopH+1*mm,0>, DoorLoopR+2*DoorLoopD}
    }
    difference{
      cylinder{<0,0.5*DoorLoopH,0>,<0,DoorLoopH,0>, DoorLoopR}
      cylinder{<0,0,0>,<0,DoorLoopH+1*mm,0>, DoorLoopR-DoorLoopD-1*mm}    
    }  
    #if (IsDebugMode)
      pigment{color Brown}
    #else
      texture{Metall1}
    #end  
  }
  // doorBox
  #local DoorBox=merge{
    difference{
      box{<0,0,0>,<2*DoorBoxW+2*DoorBoxWDelta+DoorW, DoorBoxHDelta+DoorH+DoorBoxWDelta+DoorBoxW,DoorBoxD>}    
      box{<DoorBoxW, -1, -1>, <DoorBoxW+2*DoorBoxWDelta+DoorW, DoorBoxHDelta+DoorH+DoorBoxWDelta, DoorD+DoorBoxWDelta>}    
      box{<DoorBoxW+DoorBoxHDelta,-1,-10>, <DoorBoxW+2*DoorBoxWDelta+DoorW-DoorBoxHDelta,DoorH+DoorBoxWDelta,10> }
      // door loops diff
      object{DLDiff translate <DoorBoxW,DoorLoop1_Y,0>}
      object{DLDiff translate <DoorBoxW,DoorLoop2_Y,0>}
      
      object{LockHoleDiff rotate y*180 translate <(DoorW+2*DoorBoxWDelta+DoorBoxW),(DoorKnobY-DoorBoxHDelta),0>}
      
    }
    
    object{DoorLoopA translate <DoorBoxW+DoorLoopD,DoorLoop1_Y,0>}
    object{DoorLoopA translate <DoorBoxW+DoorLoopD,DoorLoop2_Y,0>}
    
    object{LockHolePlate translate <(DoorW+2*DoorBoxWDelta+DoorBoxW+LockHolePlateD),(DoorKnobY-DoorBoxHDelta),0> }
    
    #if (IsDebugMode)
      pigment{color Blue}
    #else
      texture{T_Wood12}
    #end  
  }
  //raise items
  /*#local LeftRaise=box{<-0.5*DRaiseW,0,-0.5*DRaiseW>,<0.5*DRaiseW,1,0.5*DRaiseW> rotate y*DRaiseAngle}
  #local RightRaise=box{<-0.5*DRaiseW,0,-0.5*DRaiseW>,<0.5*DRaiseW,1,0.5*DRaiseW> rotate y*-DRaiseAngle}
  #local UpRaise=box{<0,-0.5*DRaiseW,-0.5*DRaiseW>,<1,0.5*DRaiseW,0.5*DRaiseW> rotate x*DRaiseAngle}
  #local DownRaise=box{<0,-0.5*DRaiseW,-0.5*DRaiseW>,<1,0.5*DRaiseW,0.5*DRaiseW> rotate x*-DRaiseAngle}*/
  
  #local LeftRaise=cylinder{<0,0,0>,<0,1,0>,0.5*DRaiseW scale <1,1,0.5> rotate y*DRaiseAngle}
  #local RightRaise=cylinder{<0,0,0>,<0,1,0>,0.5*DRaiseW scale <1,1,0.5>  rotate y*-DRaiseAngle}
  #local UpRaise=cylinder{<0,0,0>,<1,0,0>,0.5*DRaiseW scale <1,1,0.5> rotate x*DRaiseAngle}
  #local DownRaise=cylinder{<0,0,0>,<1,0,0>,0.5*DRaiseW scale <1,1,0.5> rotate x*-DRaiseAngle}
  // bottom raise box
  #local BottomRaise=merge{
    #local W=DoorW-2*RaiseSpace;
    #local H=BottomRaiseEnd-BottomRaiseStart;
    
    /*sphere{<0,0,0>,0.5*DRaiseW}
    sphere{<0,H,0>,0.5*DRaiseW}
    sphere{<W,0,0>,0.5*DRaiseW}
    sphere{<W,H,0>,0.5*DRaiseW}*/
    
    object{LeftRaise scale<1,H,1>}
    object{RightRaise scale <1,H,1> translate x*W}
    object{DownRaise scale<W,1,1>}
    object{UpRaise scale<W,1,1> translate y*H}    
    
    scale <1,1,0.5>
    
    translate <RaiseSpace,BottomRaiseStart,0>
  }
  // upper raise box
  #local UpperRaise=merge{
    #local W=DoorW-2*RaiseSpace;
    #local H=UpperRaiseEnd-UpperRaiseStart;
    
    /*sphere{<0,0,0>,0.5*DRaiseW}
    sphere{<0,H,0>,0.5*DRaiseW}
    sphere{<W,0,0>,0.5*DRaiseW}
    sphere{<W,H,0>,0.5*DRaiseW}*/
    
    object{LeftRaise scale<1,H,1>}
    object{RightRaise scale <1,H,1> translate x*W}
    object{DownRaise scale<W,1,1>}
    object{UpRaise scale<W,1,1> translate y*H}    
    
    scale <1,1,0.5>
    
    translate <RaiseSpace,UpperRaiseStart,0>
  }
  // body of door
  #local Body=merge{
    difference{
      box{<0,0,0>, <DoorW, DoorH, DoorD>}
      // door raises
      object{BottomRaise}
      object{BottomRaise translate z*DoorD}
      object{UpperRaise}
      object{UpperRaise translate z*DoorD}
      // door loops diff
      object{DLDiff translate y*(DoorLoop1_Y-DoorBoxHDelta)}
      object{DLDiff translate y*(DoorLoop2_Y-DoorBoxHDelta)}
      // lock hole
      object{LockHoleDiff translate <DoorW,DoorKnobY, 0>}
      
    }
    
    object{DoorLoopB translate y*(DoorLoop1_Y-DoorBoxHDelta)}
    object{DoorLoopB translate y*(DoorLoop2_Y-DoorBoxHDelta)}
    
    object{DoorKnob translate <DoorW-DoorKnobX,DoorKnobY,DoorD>}
    object{DoorKnob rotate x*180 translate <DoorW-DoorKnobX,DoorKnobY,0>}

    object{LockHolePlate translate <DoorW,DoorKnobY, 0>}
    object{LockHead translate <DoorW,DoorKnobY, 0>}
    
    
    rotate y*DoorOpenAngle
    
    translate <DoorBoxW+DoorBoxWDelta,DoorBoxHDelta,0>
    
    #if (IsDebugMode)
      pigment{color Yellow}
    #else
      texture{T_Wood14}
    #end  
  }
  // floor
  #declare Floor=box{<-10*m,0,0>,<10*m,-1*m,10*m> pigment{color DarkGreen}}
  // main 
  
  object{Body}
  object{DoorBox}
  object{Floor}
  
}
//==========================================================================================================================
#declare StairW=DoorW+2*DoorBoxW+2*DoorBoxWDelta;
#declare StairH=15*cm;
#declare StairD=30*cm;
#declare StairsCount=10;
#declare SumStairD=StairsCount*StairD;
#declare SumStairH=StairsCount*StairH;
#declare RoomH=SumStairH+DoorH+DoorBoxW+DoorBoxWDelta+DoorBoxHDelta;

#declare BanisterR=2*cm;
#declare BanisterRBase=1*cm;
#declare BanisterBaseH=8*cm;
#declare BanisterRBaseConeH=0.5*cm;
#declare BanisterRBaseConeR=3*cm;
#declare BanisterAllocH=1*m;

#declare Stair=merge{
  #local SingleStair=box{<-1*cm,-1*cm,-1*cm>,<StairW+1*cm, StairH, 2*StairD>}
  
  #local RightWall=merge{
    box{<0,-1*cm,-10*m>,<1*m,RoomH,SumStairD>}
    
    #local BanisterStart=<-BanisterBaseH,BanisterAllocH+-3*StairH,-1*StairD>;
    #local BanisterEnd=<-BanisterBaseH,BanisterAllocH+(StairsCount-1)*StairH,(StairsCount-1)*StairD>;
    #local BanisterBase=merge{
      difference{
        cone{<0,0,0>,BanisterRBaseConeR,<-BanisterRBaseConeH,0,0>,BanisterRBase}
        #local BoltHole=cylinder{<1*m,0,0>,<-1*m,0,0>,BoltR}
        object{BoltHole translate y*(0.7*BanisterRBase)}
        object{BoltHole translate y*(-0.7*BanisterRBase)}
      }  
      cylinder{<0,0,0>,<-BanisterBaseH,0,0>,BanisterRBase}
    }
    #local BanisterTube=merge{
      cylinder{BanisterStart, BanisterEnd, BanisterR}
      sphere{BanisterStart, BanisterR}
      sphere{BanisterEnd, BanisterR}
    }
    #local Banister=merge{
      object{BanisterTube }
      object{BanisterBase translate <0,BanisterAllocH+-2*StairH,0*StairD>}
      object{BanisterBase translate <0,BanisterAllocH+(StairsCount-2)*StairH,(StairsCount-2)*StairD>}
      #if (IsDebugMode)
        pigment{color Brown}
      #else
        texture{Metall2
        normal{facets coords 0.4 scale 0.1}
        }
      #end  
    }
    
    object{Banister}
    
  }  
  #local LeftWall=box{<0,0, -10*m>,<-1*m, RoomH,SumStairD> }
  #local Top=box{<-10*m,0,-10*m>,<10*m,1*m,SumStairD>}
  #local Back=difference{
    box{<-1*m,-1*m,-2*m>,<StairW+1*m, RoomH+1*m,-10*m>}
    sphere{<0.5*StairW,0.5*RoomH,-2*m>,0.5*max(StairW, RoomH)}
    
    pigment{color White}
    finish { reflection <1, 1, 1> }
  }
  
  // allocate stairs
  merge{
    #local I=1;
    #while (I<=StairsCount)
      object{SingleStair translate <0,(I-1)*StairH,(I-1)*StairD>}
      #local I=I+1;
    #end
    #if (IsDebugMode)
      pigment{color Cyan}
    #else
     texture{   
       T_Stone25
       normal {granite scale 1*m}
     } 
    #end  
  }  
  // walls
  merge{
    object{RightWall translate x*StairW}
    object{LeftWall}
    object{Top translate y*RoomH } 
    //object{Back}
    
    #if (IsDebugMode)
      pigment{color White}    
    #else
      texture{ T_Stone10//T_Grnt15 //T_Stone31
        /*Crackle*/normal {granite /*scale 1*m*/} //crackle /*scale */}
        ///*Granite*/normal {granite}
      }
    #end     
  }
  
}  
//==========================================================================================================================
#declare RoomInner=box{
  <-10*m,-1*mm,-10*m>,<10*m,RoomH+1*mm,SumStairD>
  pigment{color rgbt<1,1,1,1>} hollow
  
  
  interior{
    media{ 
      scattering { 4, 0.007 extinction 0.001 } 
      scale 10
    } 
  }
}
//==========================================================================================================================
#declare FogH=10*cm;

#declare FogObj=merge{

  #local FogStair=merge{
  
  //blob{
      #local H=SumStairH+FogH;
      #local D=SumStairD+StairD;
      #local L=sqrt( pow(H,2) + pow(D,2) );    
    
      #local I=0;  
      #local Rnd=seed(1234);
      #local sCount=40;
      #local R=10*cm;
      #local Rmin=5*cm;
      #while (I<=sCount)
        sphere{<StairW*rand(Rnd),FogH*2,D*rand(Rnd)>,(Rmin+R*rand(Rnd))}
        #local I=I+1;
      #end
      
      //pigment{color Red}
    //}
  
    box{<-1*m,+FogH*2,0>,<+1*m,0,L>}
    
    hollow  
    material{FogMaterial}
    
    translate y*-FogH*2
    rotate x*-degrees(atan2(H,D))
    translate z*-2*StairD
  }

  #local FogPlate=box{<-10*m,0,0>,<10*m,FogH,10*m> 
    hollow  
    material{FogMaterial}
    translate <0,SumStairH,SumStairD-StairD*2>
  } 
  
 
  object{FogStair}
  
  object{FogPlate}


}
//==========================================================================================================================
plane{y,0 
  #if (IsDebugMode)
    pigment{color Cyan}
  #else
   texture{   
     T_Grnt1    
     normal {granite}
   } 
  #end  
}

  object{Door translate <0,SumStairH,SumStairD>}
  object{Stair}
  
  #if (NeedShowLightLines)
    object{RoomInner}
  #end  
  
  #if (NeedUseFog)  
    object{FogObj} 
  #end  
  
//==========================================================================================================================
camera{location<0.5*m,.7*m,-2*m> look_at<0*m,0.75*StairsCount*StairH,0*m> 
  #if (NeedFocalBlur)
    focal_point <0*m,SumStairH+0.5*DoorH,0*m>
    aperture 0.15
    blur_samples 30
  #end
}

#if (IsDebugMode)
  //light_source{<0.5*m,3*m,-2*m>, White shadowless}
#end  
light_source{<2.1*0.5*DoorW,/*2*RoomH*/ SumStairH+0.5*DoorH,SumStairD+1*m>, White}

// sky
sphere{  
  <0,0,0>,50*m
  inverse
  texture{
    pigment{color /*red 0 green 0.8 blue 1*/ White}
    finish{ambient 1 diffuse 0}
  }
}

global_settings{   

  assumed_gamma 1
  
  max_trace_level 10
  #if (IsRadiocityMode)
    radiosity {
      #if (RadiocityQualityHigh)
        // these settings from http://www.simnet.is/hildurka/index.htm 
        // look radiocity tutorial
        brightness 2.0
        count 100
        error_bound 0.15
        gray_threshold 0.0
        low_error_factor 0.2
        minimum_reuse 0.015
        nearest_count 10
        recursion_limit 5
        #if (version>3.1)
          adc_bailout 0.01
          max_sample 0.5
          media off
          normal off
          always_sample 1           
          pretrace_start 0.08
          pretrace_end 0.01
        #end
      #end  
    }
  #end
}

