/*

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 2
  charset utf8
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <     -6.733,     -11.600,       0.850>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <      0.000,      -0.277,       3.767>
}

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <8.469314, -16.938628, 17.061372>
}

*/

//
// ********  MATERIALS  *******
//

#include "medhouse1.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Floor1Rib1 = object {
  box { // Floor1Rib1
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.04, 1.5>
    translate  <-1.9, -0.6, 3.0>
    material {
      T_Wood35
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
}
#declare LintelBeam1 = object {
  box { // LintelBeam1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.08, 5.0, 0.08>
    translate  <-1.9, 4.35, 2.82>
    material {
      DMFWood4HorBeams
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
}
#declare LintelBeam7 = object {
  box { // LintelBeam7
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood4HorBeams
    }
    photons {
      collect off
    }
    scale <0.08, 5.0, 0.08>
    translate  <-1.9, 4.35, 5.82>
  }
}
#declare TopFloorRib1 = object {
  box { // TopFloorRib1
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.04, 1.3>
    translate  <-1.9, -0.1, 6.0>
    material {
      T_Wood35
      // Transform to world space
      translate  0.5*y
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
}
#declare Glass1 = difference {
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.005, 0.48, 0.47>
    rotate -10.0*y
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    photons {
      collect off
    }
    scale <0.01, 0.1, 0.49>
    rotate <-10.0, -10.0, 0.0>
    translate  <0.0, 0.48, 0.01>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    photons {
      collect off
    }
    scale <0.01, 0.1, 0.49>
    rotate <10.0, -10.0, 0.0>
    translate  <0.0, -0.48, 0.01>
  }
  photons {
    collect off
  }
  translate  <-0.48, 0.0, -0.57>
}




//
// ********  OBJECTS  *******
//



#declare GroundFloor_Dif = difference {
  box { // GroundFloor
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.0, 0.15, 1.5>
    translate  1.5*z
  }
  box { // GroundFloor_Door
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.45, 0.2, 1.2>
    translate  <-1.0, 0.0, 1.2>
  }
  box { // GroundFloor_Window1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.34, 0.2, 0.68>
    translate  <0.2, 0.0, 1.03>
  }
  box { // GroundFloor_Window2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.34, 0.2, 0.68>
    translate  <1.2, 0.0, 1.03>
  }
  photons {
    collect off
  }
  material {
    BrickWall
    // Transform to world space
    translate  <-3.314079, -4.66426, 0.0>
    rotate 3.401295*z
  }
}
#declare DoorHandle = union {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.04, 0.04, 0.15>
    translate  <0.3, 0.0, 0.7>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.008, 0.008, 0.15>
    rotate -90.0*x
    translate  <0.3, 0.0, 0.9>
  }
  sphere { // Sphere003
    <0,0,0>,1
    photons {
      collect off
    }
    scale <0.03, 0.01, 0.05>
    translate  <0.3, -0.08, 0.9>
  }
  sphere { // Sphere004
    <0,0,0>,1
    photons {
      collect off
    }
    scale <0.03, 0.01, 0.05>
    translate  <0.3, 0.08, 0.9>
  }
  photons {
    collect off
  }
  translate  -1.0*x
  material {
    Brass_Metal
    // Transform to world space
    translate  <1.383547, 0.0, -0.103373>
    rotate 26.47945*z
    translate  <-1.384414, 0.0, 0.104855>
    rotate 0.0*y
    translate  <-1.384414, 0.0, 0.104855>
    rotate 0.0*y
    translate  <-3.314079, -4.66426, 0.0>
    rotate 3.401295*z
  }
}
#declare EntranceDoor = union {
  box { // Door
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*y
    translate  1.000005*z
    photons {
      collect off
    }
    scale <0.385, 0.03, 0.93>
    translate  <-1.0, 0.0, 0.104995>
    material {
      T_Wood7
      // Transform to world space
      translate  <1.383547, 0.0, -0.103373>
      rotate 26.47945*z
      translate  <-1.384414, 0.0, 0.104855>
      rotate 0.0*y
      translate  <-1.384414, 0.0, 0.104855>
      rotate 0.0*y
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { DoorHandle }
  rotate -0.0*y
  translate  <1.384414, 0.0, -0.104855>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate -26.47945*z
  translate  <-1.383547, 0.0, 0.103373>
}
#declare Group_GroundFloorDoor = union {
  box { // GroundFloor_DoorSill
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.45, 0.2, 0.05>
    translate  <-1.0, 0.0, 0.05>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // GroundFloor_DoorVert1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.03, 0.1, 1.2>
    translate  <-1.42, 0.0, 1.2>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // GroundFloor_DoorVert2
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.03, 0.1, 1.2>
    translate  <-0.58, 0.0, 1.2>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // GroundFloor_DoorUpper
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.45, 0.1, 0.03>
    translate  <-1.0, 0.0, 2.37>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { EntranceDoor }
  photons {
    collect off
  }
}
#declare Window0_1_1 = union {
  box { // Win1Vert21
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.66>
    translate  <-0.12, -0.05, 1.05>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.12, 0.05, -1.05>
      rotate 9.482031*z
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Vert22
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.66>
    translate  <0.2, -0.05, 1.05>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.12, 0.05, -1.05>
      rotate 9.482031*z
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1HorUp
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, -1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <-0.09, -0.05, 2.37>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.12, 0.05, -1.05>
      rotate 9.482031*z
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1HorLow
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <-0.09, -0.05, 1.05>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.12, 0.05, -1.05>
      rotate 9.482031*z
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor41
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <-0.09, -0.05, 2.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.12, 0.05, -1.05>
      rotate 9.482031*z
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Pane11
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.14, 0.001, 0.64>
    translate  <-0.1, -0.05, 1.07>
    material {
      WindowGlass
      // Transform to world space
      translate  <0.12, 0.05, -1.05>
      rotate 9.482031*z
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor42
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <-0.09, -0.05, 1.5>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.12, 0.05, -1.05>
      rotate 9.482031*z
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.12, 0.05, -1.05>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate -9.482031*z
  translate  <-0.12, -0.05, 1.05>
}
#declare Window0_1_2 = union {
  box { // Win1Vert23
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.66>
    translate  <0.2, -0.05, 1.05>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.52, 0.05, -1.05>
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Vert24
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.66>
    translate  <0.52, -0.05, 1.05>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.52, 0.05, -1.05>
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor39
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, -1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <0.49, -0.05, 2.37>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.52, 0.05, -1.05>
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor40
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <0.49, -0.05, 1.05>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.52, 0.05, -1.05>
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor43
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <0.49, -0.05, 2.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.52, 0.05, -1.05>
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Pane12
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.142, 0.001, 0.64>
    translate  <0.5, -0.05, 1.07>
    material {
      WindowGlass
      // Transform to world space
      translate  <-0.52, 0.05, -1.05>
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor44
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <0.49, -0.05, 1.5>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.52, 0.05, -1.05>
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <-0.52, 0.05, -1.05>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <0.52, -0.05, 1.05>
}
#declare Group_GroundFloor_Window1 = union {
  box { // Window1_Sill
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.33, 0.2, 0.025>
    translate  <0.2, 0.0, 1.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // GroundFloor_Window1Vert1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.7>
    translate  <-0.15, 0.0, 1.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // GroundFloor_Window1Vert2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.7>
    translate  <0.55, 0.0, 1.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // GroundFloor_Window1Upper
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.35, 0.1, 0.015>
    translate  <0.2, 0.0, 2.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { Window0_1_1 }
  object { Window0_1_2 }
  photons {
    collect off
  }
}
#declare Window0_2_1 = union {
  box { // Win1Vert25
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.66>
    translate  <-0.12, -0.05, 1.05>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.88, 0.05, -1.05>
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Vert26
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.66>
    translate  <0.2, -0.05, 1.05>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.88, 0.05, -1.05>
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1HorUp1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, -1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <-0.09, -0.05, 2.37>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.88, 0.05, -1.05>
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1HorLow1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <-0.09, -0.05, 1.05>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.88, 0.05, -1.05>
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor45
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <-0.09, -0.05, 2.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.88, 0.05, -1.05>
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Pane13
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.14, 0.001, 0.64>
    translate  <-0.1, -0.05, 1.07>
    material {
      WindowGlass
      // Transform to world space
      translate  <-0.88, 0.05, -1.05>
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor46
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <-0.09, -0.05, 1.5>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.88, 0.05, -1.05>
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-0.12, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.12, 0.05, -1.05>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <0.88, -0.05, 1.05>
}
#declare Window0_2_2 = union {
  box { // Win1Vert27
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.66>
    translate  <0.2, -0.05, 1.05>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.52, 0.05, -1.05>
      rotate -13.034325*z
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Vert28
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.66>
    translate  <0.52, -0.05, 1.05>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.52, 0.05, -1.05>
      rotate -13.034325*z
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor47
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, -1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <0.49, -0.05, 2.37>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.52, 0.05, -1.05>
      rotate -13.034325*z
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor48
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <0.49, -0.05, 1.05>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.52, 0.05, -1.05>
      rotate -13.034325*z
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor49
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <0.49, -0.05, 2.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.52, 0.05, -1.05>
      rotate -13.034325*z
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Pane14
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.142, 0.001, 0.64>
    translate  <0.5, -0.05, 1.07>
    material {
      WindowGlass
      // Transform to world space
      translate  <-1.52, 0.05, -1.05>
      rotate -13.034325*z
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor50
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.13, 0.025, 0.015>
    translate  <0.49, -0.05, 1.5>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.52, 0.05, -1.05>
      rotate -13.034325*z
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <0.52, -0.05, 1.05>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <-0.52, 0.05, -1.05>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate 13.034325*z
  translate  <1.52, -0.05, 1.05>
}
#declare Group_GroundFloor_Window2 = union {
  box { // Window2_Sill
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.33, 0.2, 0.025>
    translate  <1.2, 0.0, 1.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // GroundFloor_Window2Vert1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.7>
    translate  <0.85, 0.0, 1.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // GroundFloor_Window2Vert2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.7>
    translate  <1.55, 0.0, 1.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // GroundFloor_Window2Upper
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.35, 0.1, 0.015>
    translate  <1.2, 0.0, 2.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { Window0_2_1 }
  object { Window0_2_2 }
  photons {
    collect off
  }
}
#declare Group_GroundFloor_DoorAndWindows = union {
  object { Group_GroundFloorDoor }
  object { Group_GroundFloor_Window1 }
  object { Group_GroundFloor_Window2 }
  box { // GroundFloor_DoorWindowsHor1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*x
    photons {
      collect off
    }
    scale <0.45, 0.05, 0.03>
    translate  <-1.45, 0.0, 2.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  photons {
    collect off
  }
}
#declare Group_GroundFloor = union {
  box { // GroundFloor_WestWall
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 4.7, 1.5>
    translate  <-1.95, 4.7, 1.5>
    material {
      BrickWall
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // GroundFloor_EastWall
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 4.7, 1.5>
    translate  <1.95, 4.7, 1.5>
    material {
      BrickWall
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { GroundFloor_Dif }
  object { Group_GroundFloor_DoorAndWindows }
  box { // Basement
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.0, 4.77, 0.3>
    translate  <0.0, 4.62, -0.3>
    material {
      BrickWall
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // GroundFloor_DoorPane
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.42, 0.003333, 0.185>
    translate  <-1.42, 0.0, 2.0>
    material {
      WindowGlass
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor0_Floor
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    photons {
      collect off
    }
    scale <1.9, 4.68, 0.1>
    translate  0.01*z
    material {
      WoodPanels
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  photons {
    collect off
  }
}
#declare Window1_1_1 = union {
  box { // Win1Vert5
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.615>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Vert6
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.615>
    translate  <-1.05, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor7
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor8
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor9
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Pane3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <1.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor10
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <-1.75, -0.65, 0.0>
}
#declare Window1_1_2 = union {
  box { // Win1Vert7
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.615>
    translate  <-1.39, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Vert8
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.615>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor11
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor12
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor13
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Pane4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <1.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor14
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <-1.05, -0.65, 0.0>
}
#declare Group_Window1 = union {
  box { // Floor1Sill1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.37, 0.2, 0.025>
    translate  <-1.4, -0.55, 3.95>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Vert1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <-1.78, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Vert2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <-1.02, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Upper1
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.35, 0.2, 0.015>
    translate  <-1.4, -0.5, 5.26>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { Window1_1_1 }
  object { Window1_1_2 }
  photons {
    collect off
  }
}
#declare Window1_2_1 = union {
  box { // Win1Vert9
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Vert10
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.05, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor15
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor16
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor17
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Pane5
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor18
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <-0.75, -0.65, 0.0>
}
#declare Window1_2_2 = union {
  box { // Win1Vert11
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.39, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Vert12
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor19
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor20
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor21
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Pane6
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor22
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <-0.05, -0.65, 0.0>
}
#declare Group_Window2 = union {
  box { // Floor1Sill2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.37, 0.2, 0.025>
    translate  <-0.03, -0.55, 3.95>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Vert3
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <-0.75, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Upper2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, -1.0>
    photons {
      collect off
    }
    scale <0.35, 0.2, 0.015>
    translate  <-0.05, -0.5, 5.26>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { Window1_2_1 }
  object { Window1_2_2 }
  photons {
    collect off
  }
}
#declare Window1_3_1 = union {
  box { // Win1Vert13
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.615>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Vert14
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.615>
    translate  <-1.05, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor23
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor24
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor25
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Pane7
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor26
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <0.05, -0.65, 0.0>
}
#declare Window1_3_2 = union {
  box { // Win1Vert15
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.615>
    translate  <-1.39, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      rotate -53.864799*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Vert16
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.615>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      rotate -53.864799*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor27
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      rotate -53.864799*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor28
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      rotate -53.864799*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor29
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      rotate -53.864799*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Pane8
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      rotate -53.864799*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor30
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      rotate -53.864799*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate 53.864799*z
  translate  <0.75, -0.65, 0.0>
}
#declare Group_Window3 = union {
  box { // Floor1Sill3
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.37, 0.2, 0.025>
    translate  <0.03, -0.55, 3.95>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Upper3
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, -1.0>
    photons {
      collect off
    }
    scale <0.35, 0.2, 0.015>
    translate  <0.05, -0.5, 5.26>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Vert4
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <0.75, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { Window1_3_1 }
  object { Window1_3_2 }
  photons {
    collect off
  }
}
#declare Window1_4_1 = union {
  box { // Win1Vert17
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.615>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Vert18
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.615>
    translate  <-1.05, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor31
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor32
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor33
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Pane9
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <-1.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor34
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <1.05, -0.65, 0.0>
}
#declare Window1_4_2 = union {
  box { // Win1Vert19
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.615>
    translate  <-1.39, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Vert20
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.615>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor35
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor36
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor37
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Pane10
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <-1.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Win1Hor38
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <1.75, -0.65, 0.0>
}
#declare Group_Window4 = union {
  box { // Floor1Sill4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.35, 0.2, 0.025>
    translate  <1.4, -0.55, 3.95>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Upper4
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.35, 0.2, 0.015>
    translate  <1.4, -0.5, 5.26>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Vert5
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <1.05, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Vert6
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <1.75, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { Window1_4_1 }
  object { Window1_4_2 }
  photons {
    collect off
  }
}
#declare Group_Floor1_Windows = union {
  object { Group_Window1 }
  object { Group_Window2 }
  object { Group_Window3 }
  object { Group_Window4 }
  photons {
    collect off
  }
}
#declare Floor1_FrontComposite = union {
  box { // Floor1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.0, 0.15, 1.5>
    translate  <0.0, -0.5, 4.5>
    material {
      T_Wood7
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { Floor1Rib1 }
  object { // Floor1Rib2 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <0.2, 0.0, 0.0>
  }
  object { // Floor1Rib3 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <0.4, 0.0, 0.0>
  }
  object { // Floor1Rib4 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <0.6, 0.0, 0.0>
  }
  object { // Floor1Rib5 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <0.8, 0.0, 0.0>
  }
  object { // Floor1Rib6 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <1.0, 0.0, 0.0>
  }
  object { // Floor1Rib7 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <1.2, 0.0, 0.0>
  }
  object { // Floor1Rib8 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <1.4, 0.0, 0.0>
  }
  object { // Floor1Rib9 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <1.6, 0.0, 0.0>
  }
  object { // Floor1Rib10 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <1.8, 0.0, 0.0>
  }
  object { // Floor1Rib11 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <2.0, 0.0, 0.0>
  }
  object { // Floor1Rib12 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <2.2, 0.0, 0.0>
  }
  object { // Floor1Rib13 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <2.4, 0.0, 0.0>
  }
  object { // Floor1Rib14 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <2.6, 0.0, 0.0>
  }
  object { // Floor1Rib15 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <2.8, 0.0, 0.0>
  }
  object { // Floor1Rib16 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <3.0, 0.0, 0.0>
  }
  object { // Floor1Rib17 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <3.2, 0.0, 0.0>
  }
  object { // Floor1Rib18 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <3.4, 0.0, 0.0>
  }
  object { // Floor1Rib19 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <3.6, 0.0, 0.0>
  }
  object { // Floor1Rib20 -> Floor1Rib1
    Floor1Rib1
    photons {
      collect off
    }
    translate  <3.8, 0.0, 0.0>
  }
  photons {
    collect off
  }
}
#declare FirstFloor = difference {
  object { Floor1_FrontComposite }
  box { // Floor1Window1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.365, 0.25, 0.635>
    translate  <-1.4, -0.5, 3.98>
    material {
      T_Wood7
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Window2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.37, 0.25, 0.635>
    translate  <-0.03, -0.5, 3.98>
    material {
      T_Wood7
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Window3
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.37, 0.25, 0.635>
    translate  <0.03, -0.5, 3.98>
    material {
      T_Wood7
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1Window4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.37, 0.25, 0.635>
    translate  <1.4, -0.5, 3.98>
    material {
      T_Wood7
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  photons {
    collect off
  }
}
#declare Lintels1 = union {
  box { // Lintel
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <2.0, 0.5, 0.1>
    translate  <0.0, -0.2, 3.0>
  }
  object { LintelBeam1 }
  object { // LintelBeam2 -> LintelBeam1
    LintelBeam1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <0.76, 0.0, -0.0>
  }
  object { // LintelBeam3 -> LintelBeam1
    LintelBeam1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <1.52, 0.0, -0.0>
  }
  object { // LintelBeam4 -> LintelBeam1
    LintelBeam1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <2.28, 0.0, -0.0>
  }
  object { // LintelBeam5 -> LintelBeam1
    LintelBeam1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <3.04, 0.0, -0.0>
  }
  object { // LintelBeam6 -> LintelBeam1
    LintelBeam1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <3.8, 0.0, -0.0>
  }
  photons {
    collect off
  }
}
#declare Lintels2 = union {
  object { LintelBeam7 }
  object { // LintelBeam8 -> LintelBeam7
    LintelBeam7
    photons {
      collect off
    }
    rotate <-0.0, -0.0, 0.0>
    translate  <0.76, 0.0, 0.0>
  }
  object { // LintelBeam9 -> LintelBeam7
    LintelBeam7
    photons {
      collect off
    }
    rotate <-0.0, -0.0, 0.0>
    translate  <1.52, 0.0, 0.0>
  }
  object { // LintelBeam10 -> LintelBeam7
    LintelBeam7
    photons {
      collect off
    }
    rotate <-0.0, -0.0, 0.0>
    translate  <2.28, 0.0, 0.0>
  }
  object { // LintelBeam11 -> LintelBeam7
    LintelBeam7
    photons {
      collect off
    }
    rotate <-0.0, -0.0, 0.0>
    translate  <3.04, 0.0, 0.0>
  }
  object { // LintelBeam12 -> LintelBeam7
    LintelBeam7
    photons {
      collect off
    }
    rotate <-0.0, -0.0, 0.0>
    translate  <3.8, 0.0, 0.0>
  }
  photons {
    collect off
  }
}
#declare Group_Floor1 = union {
  object { Group_Floor1_Windows }
  box { // UpperFloorStrut1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 0.2, 2.7>
    translate  <0.0, -0.6, 5.7>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // UpperFloorStrut2
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    photons {
      collect off
    }
    scale <0.6, 0.05, 0.05>
    translate  <0.0, -0.72, 7.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // UpperFloorStrut3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <1.9, 0.15, 0.05>
    translate  <0.0, -0.6, 6.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { FirstFloor }
  box { // Floor1_WestWall
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 5.0, 1.5>
    translate  <-1.95, 4.4, 4.5>
    material {
      T_Wood7
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // Floor1_EastWall
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 5.0, 1.5>
    translate  <1.95, 4.4, 4.5>
    material {
      T_Wood7
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { Lintels1 }
  box { // FloorCeiling
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.9, 4.5, 0.1>
    translate  <0.0, 4.8, 3.0>
    material {
      WoodPanels
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // FloorCeiling1
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    photons {
      collect off
    }
    scale <1.9, 4.95, 0.1>
    translate  <0.0, 9.3, 6.0>
    material {
      WoodPanels
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { Lintels2 }
  photons {
    collect off
  }
}
#declare FrontonWest = difference {
  box { // Toit1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 0.05, 1.0>
  }
  box { // Toit2
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.3, 0.07, 0.3>
    rotate -45.0*y
    translate  <0.204348, 0.0, 1.016739>
  }
  cylinder { // Toit3
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.15>
    rotate -90.0*x
    translate  <0.437594, -0.073341, 0.270573>
  }
  cylinder { // Toit4
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.15>
    rotate -90.0*x
    translate  <0.124101, -0.073341, -1.235394>
  }
  cylinder { // Toit5
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.15>
    rotate -90.0*x
    translate  <0.434287, -0.073341, -0.525965>
  }
  box { // Toit6
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.116267, 0.07, 0.407149>
    translate  <0.151654, 0.0, -0.131498>
  }
  material {
    DMFWood4Ver
  }
  photons {
    collect off
  }
  rotate 45.0*y
  translate  -0.562522*x
}
#declare FrontonEast = difference {
  box { // Toit7
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 0.05, 1.0>
  }
  box { // Toit8
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.3, 0.07, 0.3>
    rotate -45.0*y
    translate  <0.204348, 0.0, 1.016739>
  }
  cylinder { // Toit9
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.15>
    rotate -90.0*x
    translate  <0.437594, -0.073341, 0.270573>
  }
  cylinder { // Toit10
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.15>
    rotate -90.0*x
    translate  <0.124101, -0.073341, -1.235394>
  }
  cylinder { // Toit11
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.15>
    rotate -90.0*x
    translate  <0.434287, -0.073341, -0.525965>
  }
  box { // Toit12
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.116267, 0.07, 0.407149>
    translate  <0.151654, 0.0, -0.131498>
  }
  material {
    DMFWood4Ver
  }
  photons {
    collect off
  }
  scale -1.0
  rotate <-180.0, -45.0, -0.0>
  translate  0.566097*x
}
#declare Fronton = union {
  object { FrontonWest }
  object { FrontonEast }
  photons {
    collect off
  }
  scale <1.45, 1.45, 1.74>
  translate  <0.0, -0.7, 6.979784>
}
#declare TopFloor_CompositeElements = union {
  box { // TopFloor_Wall
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <2.0, 0.15, 1.3>
    translate  6.0*z
  }
  object { TopFloorRib1 }
  object { // TopFloorRib2 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  0.2*x
  }
  object { // TopFloorRib3 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  0.4*x
  }
  object { // TopFloorRib4 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  0.6*x
  }
  object { // TopFloorRib5 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  0.8*x
  }
  object { // TopFloorRib6 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  1.0*x
  }
  object { // TopFloorRib7 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  1.2*x
  }
  object { // TopFloorRib8 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  1.4*x
  }
  object { // TopFloorRib9 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  1.6*x
  }
  object { // TopFloorRib10 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  1.8*x
  }
  object { // TopFloorRib11 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  2.0*x
  }
  object { // TopFloorRib12 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  2.2*x
  }
  object { // TopFloorRib13 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  2.4*x
  }
  object { // TopFloorRib14 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  2.6*x
  }
  object { // TopFloorRib15 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  2.8*x
  }
  object { // TopFloorRib16 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  3.0*x
  }
  object { // TopFloorRib17 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  3.2*x
  }
  object { // TopFloorRib18 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  3.4*x
  }
  object { // TopFloorRib19 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  3.6*x
  }
  object { // TopFloorRib20 -> TopFloorRib1
    TopFloorRib1
    photons {
      collect off
    }
    translate  3.8*x
  }
  photons {
    collect off
  }
}
#declare TopFloorDif = difference {
  object { TopFloor_CompositeElements }
  box { // UpperWindow1
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.2, 0.25, 0.45>
    translate  <0.0, -0.034658, 6.8>
  }
  box { // UpperWindow2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.2, 0.25, 0.45>
    translate  <0.0, -0.034658, 6.8>
  }
  box { // Floor2_RoofDif1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <1.65, 0.2, 0.9>
    rotate -50.0*y
    translate  <-2.0, 0.0, 6.0>
  }
  box { // Floor2_RoofDif2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <1.65, 0.2, 0.9>
    rotate 50.0*y
    translate  <2.0, 0.0, 6.0>
  }
  photons {
    collect off
  }
  translate  -0.5*y
  material {
    T_Wood7
    // Transform to world space
    translate  <-3.314079, -4.66426, 0.0>
    rotate 3.401295*z
  }
}
#declare Group_Chimney = union {
  box { // Chimney
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 0.2, 1.3>
    translate  <-1.7, 2.0, 7.3>
    material {
      BrickWall
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  cylinder { // ChimneyStrut
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 1.7>
    rotate <0.0, -80.0, -3.0>
    translate  <0.0, 1.9, 8.0>
    material {
      Brass_Metal
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // ChimneyTop
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.22, 0.22, 0.05>
    translate  <-1.7, 2.0, 8.6>
    material {
      BrickWall
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  cone { // ChimneyTube
    <0,0,0>, 0.13, <0,0,1>, 0.1
    open
    material {
      Rust
    }
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.35>
    rotate <-2.0, -4.0, 0.0>
    translate  <-1.7, 2.0, 8.6>
  }
  photons {
    collect off
  }
}
#declare Group_Roof = union {
  object { Fronton }
  box { // RoofDeckW
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <1.675, 0.2, 0.04>
    rotate <-0.0, -50.280807, 0.0>
    translate  <-1.040205, -0.65, 7.271383>
  }
  box { // RoofDeckE
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <1.675, 0.2, 0.04>
    rotate <-0.0, -50.280807, 180.0>
    translate  <1.052265, -0.65, 7.271575>
  }
  object { TopFloorDif }
  box { // RoofWest
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.6, 5.0, 0.01>
    rotate -50.165241*y
    translate  <-1.013031, 4.4, 7.227765>
    material {
      Rust
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // RoofEast
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.6, 5.0, 0.01>
    rotate <0.0, -50.165241, 180.0>
    translate  <1.024725, 4.4, 7.231582>
    material {
      Rust
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { Group_Chimney }
  sphere { // TopDeco1
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.06
    translate  <0.0, -0.75, 8.67>
    material {
      Brass_Metal
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  cone { // TopDeco2
    <0,0,0>, 0.2, <0,0,1>, 0.0
    photons {
      collect off
    }
    scale <0.15, 0.15, 0.25>
    translate  <0.0, -0.75, 8.562623>
    material {
      Brass_Metal
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  photons {
    collect off
  }
}
#declare BackwallTopFloorDif = difference {
  box { // BackwallTopFloor
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.9, 0.05, 1.5>
    translate  <0.0, 9.35, 7.5>
  }
  box { // BackwallTopFloor1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.9, 0.1, 1.5>
    rotate -50.214809*y
    translate  <-2.016657, 9.35, 8.378561>
  }
  box { // BackwallTopFloor2
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.9, 0.1, 1.5>
    rotate 50.214809*y
    translate  <2.028709, 9.35, 8.376669>
  }
  photons {
    collect off
  }
  material {
    T_Wood7
    // Transform to world space
    translate  <-3.314079, -4.66426, 0.0>
    rotate 3.401295*z
  }
}
#declare Backwall = union {
  box { // BackwallGroundFloor
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.9, 0.05, 1.5>
    translate  <0.0, 9.35, 1.5>
    material {
      BrickWall
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  box { // BackwallFirstFloor
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.9, 0.05, 1.5>
    translate  <0.0, 9.35, 4.5>
    material {
      T_Wood7
      // Transform to world space
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  object { BackwallTopFloorDif }
  photons {
    collect off
  }
}
#declare CSG001 = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 0.1>
    translate  -0.15*z
  }
  torus { // Torus002
    0.2, 0.05  rotate -x*90
    photons {
      collect off
    }
    translate  -0.1*z
  }
  photons {
    collect off
  }
}
#declare CSG002 = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.5, 0.5, 0.2>
    translate  -0.37*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.5, 1.1>
    rotate -90.0*x
    translate  <0.72, -0.55, -0.17>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.5, 1.1>
    rotate -90.0*x
    translate  <-0.72, -0.55, -0.17>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.5, 1.1>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.55, 0.72, -0.17>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.5, 1.1>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.55, -0.72, -0.17>
  }
  cone { // Cone001
    <0,0,0>, 0.5, <0,0,1>, 0.2
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.5>
    translate  -0.7*z
    material {
      White_Paint
      // Transform to world space
      translate  <0.0, 0.81, -3.45>
      rotate -90.0*z
      scale 1.0/0.3
      translate  2.0*x
      translate  2.0*x
      translate  <-3.314079, -4.66426, 0.0>
      rotate 3.401295*z
    }
  }
  photons {
    collect off
  }
}
#declare Top = union {
  torus { // Torus001
    0.2, 0.05  rotate -x*90
    photons {
      collect off
    }
  }
  object { CSG001 }
  torus { // Torus003
    0.175, 0.02  rotate -x*90
    photons {
      collect off
    }
    translate  -0.15*z
  }
  object { CSG002 }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.96>
    rotate -90.0*x
    translate  <0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.96>
    rotate -90.0*x
    translate  <-0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.96>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.96>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.48, 0.48, -0.57>
  }
  photons {
    collect off
  }
}
#declare LampHolder = union {
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.96>
    rotate <-170.0, 10.0, 0.0>
    translate  <0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.96>
    rotate <-170.0, -10.0, 0.0>
    translate  <-0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.96>
    rotate <170.0, -10.0, 0.0>
    translate  <-0.48, 0.48, -0.57>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.96>
    rotate <170.0, 10.0, 0.0>
    translate  <0.48, 0.48, -0.57>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.64>
    rotate -90.0*x
    translate  <-0.315, -0.32, -1.5>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.64>
    rotate -90.0*x
    translate  <0.315, -0.32, -1.5>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.64>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.315, -0.32, -1.5>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.64>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.315, 0.315, -1.5>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.5>
    rotate <-60.0, 0.0, -45.0>
    translate  -1.75*z
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.5>
    rotate <-60.0, 0.0, -135.0>
    translate  -1.75*z
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.5>
    rotate <-60.0, 0.0, -225.0>
    translate  -1.75*z
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.5>
    rotate <-60.0, 0.0, -315.0>
    translate  -1.75*z
  }
  sphere { // Sphere001
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.05
    translate  -1.75*z
  }
  photons {
    collect off
  }
}
#declare LampArm = union {
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.8>
  }
  cone { // Cone002
    <0,0,0>, 0.06, <0,0,1>, 0.02
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.2>
    translate  0.2*z
  }
  photons {
    collect off
  }
}
#declare Tor1 = difference {
  torus { // Torus004
    0.1, 0.03  rotate -x*90
    photons {
      collect off
    }
    rotate -90.0*x
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.06, 0.05, 0.12>
    translate  0.06*x
  }
  photons {
    collect off
  }
  translate  1.0*z
}
#declare Tor2 = difference {
  torus { // Torus005
    0.15, 0.03  rotate -x*90
    photons {
      collect off
    }
    rotate -90.0*x
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.09, 0.05, 0.17>
    translate  -0.09*x
  }
  photons {
    collect off
  }
  translate  0.95*z
}
#declare Tor3 = difference {
  torus { // Torus006
    0.2, 0.03  rotate -x*90
    photons {
      collect off
    }
    rotate -90.0*x
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.12, 0.054545, 0.250909>
    translate  0.12*x
  }
  photons {
    collect off
  }
  translate  1.0*z
}
#declare GallowDif = difference {
  torus { // Torus007
    1.5, 0.03  rotate -x*90
    photons {
      collect off
    }
    scale <0.8, 0.5, 1.0>
    rotate -90.0*x
    translate  <0.75, 0.0, 0.01>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.8, 0.05, 1.0>
    translate  -0.05*x
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.3, 0.05, 0.5>
    translate  <0.75, 0.0, -0.5>
  }
  photons {
    collect off
  }
  translate  0.4*z
}
#declare Gallow = union {
  object { Tor1 }
  object { Tor2 }
  object { Tor3 }
  sphere { // Sphere002
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.055
    translate  0.92*z
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.03, 0.03, 2.0>
    rotate 90.0*y
    translate  1.2*z
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 0.05, 1.0>
    translate  <2.0, 0.0, 0.4>
  }
  object { GallowDif }
  photons {
    collect off
  }
  translate  -0.4*z
}
#declare LampGlass = union {
  object { Glass1 }
  object { // Glass2 -> Glass1
    Glass1
    photons {
      collect off
    }
    rotate -90.0*z
  }
  object { // Glass3 -> Glass1
    Glass1
    photons {
      collect off
    }
    rotate 180.0*z
  }
  object { // Glass4 -> Glass1
    Glass1
    photons {
      collect off
    }
    rotate 90.0*z
  }
  photons {
    collect off
  }
  material {
    T_Yellow_Glass
    // Transform to world space
    translate  <0.0, 0.81, -3.45>
    rotate -90.0*z
    scale 1.0/0.3
    translate  2.0*x
    translate  2.0*x
    translate  <-3.314079, -4.66426, 0.0>
    rotate 3.401295*z
  }
}
#declare StreetLamp = union {
  object { Top }
  object { LampHolder }
  object { LampArm }
  object { Gallow }
  object { LampGlass }
  translate  -2.0*x
  photons {
    collect off
  }
  scale 0.3
  rotate 90.0*z
  translate  <0.0, -0.81, 3.45>
  material {
    DarkBlue_Paint
    // Transform to world space
    translate  <-3.314079, -4.66426, 0.0>
    rotate 3.401295*z
  }
} 

#declare mh1 = 
union { // MedievalHouse1
  object { Group_GroundFloor }
  object { Group_Floor1 }
  object { Group_Roof }
  object { Backwall }
  object { StreetLamp }
  photons {
    collect off
  }
  //rotate -3.401295*z
  //translate  <3.314079, 4.66426, 0.0>
}


