// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.6
// Desc:
// Date:
// Auth: Iacopo Mochi

#include "colors.inc"
#include "woods.inc"
#declare curframe=1;
#include "colors.inc"
#include "mosca.pov" 
#include "organetto.pov"
#include "catena.pov"
#include "rad_def.inc"
#include "succhino1Mat.pov" 
#include "succhino1M.pov"

object {catena material {blender_default} 
rotate <-90,0,0>

scale 0.08
translate <-1,3.03,0>} 


#declare battiscopa=
union{
      box{<-40,-2.7,9.90>,<20,-4,10>}
      cylinder{<-40,-2.7,9.95>,<10,-2.7,9.95>,0.05}
      pigment{color rgb <1,0.7,0.3>} 
      finish{}
      }

 
#declare pozzanghera=
blob{
	threshold 0.6
	sphere{<0,0,0>,.6,.6}
	sphere{<.5,0,0>,.5,.5}
	sphere{<0,0,.5>,.5,.5}
	sphere{<-.5,0,0>,.5,.7}
	sphere{<0,0,-.5>,.5,.6}
	sphere{<0,0,-.7>,.5,.3}
	sphere{<0.5,0,0.5>,.5,.4}
	sphere{<-0.5,0,0.5>,.5,.7}
	texture{pigment{ color rgbt <1,0.4,0.6,0.8>}}
	interior { ior 1.3 }
	finish { reflection {0.1} ambient 0.1 diffuse 0.03 }
	scale<1,0.5,1>
	} 


#declare bordo_superiore=
union{
lathe {
  cubic_spline
  6
  <4.8, -1>,<4.9,-.5>,<5.2,0>,<5.3,.2>,<5.5,.22>, <5.7,.22>
  scale <1.2,3,1.2>
  translate y*14
}
lathe {
  cubic_spline
  6
  <4.6, -1>,<4.8,-.5>,<5.1,0>,<5.2,.2>,<5.4,.22>, <5.7,.22>
  scale <1.2,3,1.2>
  translate y*14
}
}

#declare Count=0;   
#declare asta=box{<4.3+0.01,1,0.13>,<4.3-0.03,14,-0.13>
                        rotate <0,0,-7>}
#declare gabbia=box{<4.3+0.01,1,0.13>,<4.3-0.03,14,-0.13>
                        rotate <0,0,-7>}
 #while (Count < 20)
   #declare gabbia=
        union{
                object{gabbia}
                object{asta
                        rotate <0,180*Count/10,0>}
                        }
               
   #declare Count=Count+1;
 #end


#declare cestino=

union{
difference{
        cone {
                1*y,  4.5,
                -1*y, 4.0
             }
        cone {
                1.1*y,  4.4,
                -0.9*y, 4
             }             
        }
        object{gabbia}
        object{bordo_superiore}
        texture{
                pigment{
                        color rgb <1.4,0.2,0.2>
                        }
                finish { specular 0.1
                         reflection {0.1} }
                }
                }


#declare bottiglia=
lathe {
  cubic_spline
  18
  <0, -1>,<0.01, -1.001>,<0.1, -1.01>,<0.5, -1.1>,<1, -1>, <1, 0>, <1, 1>, <1, 2>, <1, 2.5>, <0.8, 3>, <1, 3.5>, <1, 4>, <1, 5>,
  <1-sin(pi/4), 5+cos(pi/4)>, <1-sin(3*pi/4), 5+cos(pi/8)>, <1-sin(3*pi/4), 5+cos(pi/8)>,<1-sin(3*pi/4), 5+cos(pi/8)>,
  <1-sin(3*pi/4), 5+cos(pi/8)>              
}

#declare bottiglia_i=
lathe {
  cubic_spline
  18
  <0, -1>,<0.02, -1.001>,<0.11, -1.01>,<0.51, -1.1>,<.98, -1>, <.98, 0>, <.98, 1>, <.98, 2>, <.98, 2.5>, <0.78, 3>, <.98, 3.5>, <.98, 4>, <.98, 5>,
  <1-sin(pi/4), 5+cos(pi/4)>, <1-sin(3*pi/4), 5+cos(pi/8)>, <1-sin(3*pi/4), 5+cos(pi/8)>,<1-sin(3*pi/4), 5+cos(pi/8)>,
  <.98-sin(3*pi/4), 4.98+cos(pi/8)>              
}
                                            


#declare parquet=
        box{<3,-0.1,0.6>,<-3,0.1,-0.6>
                translate -2*y}                                            
                
 
///////  Scena   



#declare Count0=1;
#declare Count1=-50;
#declare Count2=0;
#declare Count=0;
 
 #while (Count < 200)        
              
  
 #declare inc=pow(-1,int(Count0/20))*1.22;
 #declare Count2=Count2+inc;
 #declare Count1=-45+Count2+int(Count0/20)*6.01;
 #declare Count0=Count0+1;           
 #declare R = seed(Count0);
 #declare N = rand(R)-0.5;
 
        object{parquet          
                translate <Count1,-1.6,Count2-10>
                rotate y*(80+50*N)
                texture{T_Wood10}
                  normal {
                        hexagon
                        normal { gradient x scale .2 },
                        normal { gradient y scale .2 },
                        normal { bumps scale .2 }
                        }

                rotate -y*(80+50*N)
        }       
        #declare Count=Count+1;
 #end                

object{pozzanghera           
        scale <3,1,3>
        translate <2.9,-3.45,-4>}       

object{mosca
scale 0.1
rotate <-10,-10,-30>
translate <2.9,-3.3,-4>}       


difference{             
 object{bottiglia
  texture{
        pigment{
                color rgbt <0.2,1,0.5,0.8>
                }
        finish { specular 0.3
                 reflection {0.3} }       
          }  
          interior{ior 1.1}
          }

 object{bottiglia_i
  texture{
        pigment{
                color rgbt <0.2,1,0.5,0.8>
                }
        finish { specular 0.1
                 reflection {0.1} }       
          }  
          //interior{ior 1.1}
          }            
   rotate <10,0,-10>
   translate -y*2
}
 
union{
intersection{
 object{bottiglia
  
   rotate <0,0,-90>
   translate <-5,-2,-4>
} 
           
plane{y,-2.25}  
texture{
        pigment{
                color rgbt <0.2,1,0.5,0.8>
                }
        finish { specular 0.3
                 reflection {0.3} }       
          }  
          interior{ior 1.5} 
}
intersection{
 object{bottiglia
  
   rotate <0,0,-90>
   translate <-5,-2,-4>
}            
plane{-y,2.25}  
texture{
        pigment{
                color rgbt <0.2,1,0.5,0.8>
                }
        finish { specular 0.3
                 reflection {0.3} }       
          }  
} 
translate -y*0.5
 }


object{mosca
scale 0.1
translate<-4.5,-1,0>}

object{mosca
scale 0.1
rotate <10,10,10>
translate<5,3,2>
}

object{mosca
scale 0.1
rotate <10,10,10>
translate<1,1,4>

}

object{mosca
scale 0.1
rotate <10,20,10>
translate<4,4,2>

}

object{mosca
scale 0.1
rotate <10,10,30>
translate<2,-1,3>
}


object{organetto
scale <0.1,0.1,0.1>  
rotate y*30
translate <6,-5,-3> 

} 
       
plane{ z,10

pigment { color rgb <1.5,1.5,1>}
normal{granite 0.2}
finish{reflection 0.4}

        }            
       

object{battiscopa}

object{cestino
        scale <0.3,0.3,0.3>
        scale <1.8,2,1.8>
        translate -2.9*y}        

#declare succhino1=
        union{object{succhinoA}
              object{succhinoB}
              object{succhinoC}
              object{succhinoD}
              object{succhinoE}  
              }



object{succhino1
        scale 0.5
        rotate <10,-20,30> 
        translate <-2.5,-4.4,0>}
object{succhino1
        scale 0.5
        rotate <10,20,30> 
        translate <2.6,-4.7,0>}
object{succhino1
        scale 0.5 
        rotate <0,-90,0>      
        rotate <-90,00,0> 
        rotate <0,30,0> 
        translate <6,-4.7,0>
        }                   
object{succhino1
        scale 0.5 
        rotate <0,-90,0>      
        rotate <-90,00,0> 
        rotate <0,-30,0> 
        translate <4,-4.7,0>
        } 

light_source {
  0*x                 // light's position (translated below)
  color rgb 1.0       // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <40, 80, -40>   // <x y z> position of light
}


camera {
  location  <3.0, 1.0, -10.0>*1.5
  look_at   <0.0, 1.0,  0.0>
  right     x*image_width/image_height
}
 

global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}
 