#include "colors.inc"
#include "shapes.inc"
#include "..\my_macro.inc"

//=============================================================================================================
#local Debug=no;
#local FocalBlur=yes;
#local Radiosity=yes;
#local Photons=yes;

global_settings{
  assumed_gamma 1
  noise_generator 3  
  max_trace_level 10
  #if (Radiosity)
    radiosity{}
  #end
  #if (Photons)
    photons {
      spacing 0.01  // higher value 'lower' quality, faster parsing.
      autostop 0
      jitter 0.5
      max_trace_level 15
    }
  #end   
}

//=============================================================================================================
#local TB_H=1*m;
#local TB_R=35*cm;
#local TB_BorderD=3*mm;
#local TB_DiffCount=30;
#local TB_RingH=0.15*TB_H;
#local TB_RingD=2*TB_BorderD;

#local TrashBasket=union{
  // base
  #local Diff=merge{
    #local DiffStart=<0,0.2*TB_H,0>;
    #local DiffFinish=<0,0.8*TB_H,0>;  
    #local DiffR=0.03*TB_H;
    merge{
      cylinder{DiffStart,DiffFinish,DiffR}
      sphere{DiffStart,DiffR}
      sphere{DiffFinish,DiffR}
    }
    scale <0.25,1,1>  
    translate x*TB_R
  }  
  intersection{
    difference{
      merge{
        difference{
          cylinder{<0,0,0>,<0,TB_H,0>, TB_R}
          cylinder{<0,TB_BorderD,0>,<0,TB_H+1,0>, TB_R-TB_BorderD}
        }
        #if (!Debug)        
          #local NumDiff=0;
          #while (NumDiff<TB_DiffCount)
            #local NumDiff=NumDiff+1;
            object{Diff rotate y*NumDiff*360/TB_DiffCount}
          #end        
        #end  
      }     
      #if (!Debug)
        #local NumDiff=0;
        #while (NumDiff<TB_DiffCount)
          #local NumDiff=NumDiff+1;
          object{Diff translate x*TB_BorderD rotate y*NumDiff*360/TB_DiffCount}
        #end            
      #end  
    }
    cylinder{<0,-1,0>,<0,TB_H+1,0>, 1.00001*TB_R}
  }
  // ring
  #local Ring=union{
    #local Bolt=union{
      #local BoltR=5*TB_BorderD;
      #local BoltBaseR=0.25*BoltR;
      
      intersection{
        sphere{0,BoltR}
        box{<0,-2*BoltR,-2*BoltR>,2*BoltR}
        scale <0.5,1,1>
        translate x*TB_BorderD
      }
      cylinder{<-3*TB_BorderD,0,0>,<1.0001*TB_BorderD,0,0>,BoltBaseR}
      translate <TB_R+TB_RingD,0.5*TB_RingH,0>
    }
    difference{
      cylinder{<0,0,0>,<0,TB_RingH,0>,TB_R+TB_RingD}
      cylinder{<0,-1,0>,<0,TB_RingH+1,0>,TB_R}
    }  
    object{Bolt rotate y*0*90}
    object{Bolt rotate y*1*90}
    object{Bolt rotate y*2*90}
    object{Bolt rotate y*3*90}
  }               
  object{Ring}
  object{Ring translate y*(TB_H-TB_RingH)}
  // material
  #if (Debug)
    pigment{LightBlue}
  #else  
    #local TexMet=texture{
      pigment {
        granite
        color_map {
          [0.35 color rgb 0.2*<0.27,0.3,0.35> ]
          [0.5 color rgb 0.25*<0.15,0.2,0.25> ]
        }
        scale 2
      }
      finish {
        ambient 0.0
        diffuse 0.2
        specular 0.4
        roughness 0.2
        metallic
    
        reflection {
          0.01
          metallic
        }
      }
      normal {
        average
        normal_map{
          [1 granite 0.05]
          [1 bumps scale 0.2]
          [1 bozo scale 0.2 translate 1*m]
          [0.3 crackle 5 solid scale 2]
        }  
        warp {turbulence 1}
        scale 0.1
      }
    };
    
    #local TexOldMet=texture{
      pigment {
        bumps
        color_map {
          [0.35 color rgb <0.1,0.05,0.05>]
          [0.5 color rgb <0.15,0.05,0.05> ]
        }
        scale 0.01
      } 
      
      finish {
        ambient 0.0
        diffuse 0.2
        specular 0.01
        roughness 1
        metallic     
        reflection {
          0.0
          metallic
        }
      }        
      normal{granite scale 0.01}      
    };
     
   
    texture{
      wrinkles scale 0.2 rotate 30 //warp {turbulence 1}
      texture_map{
        [0.3 TexOldMet]
        [0.4 TexMet]
      }            
    }
    
  #end
}
//=============================================================================================================
#local Seed=seed(103456);
#local FP_H=10*cm;
#local FP_W=80*cm;
#local FP_D=FP_W;
#local FP_Delta=1*cm;

#macro FloorPlate()
  #local Plate=box{<-0.5*FP_W,0.00000001,-0.5*FP_D>,<0.5*FP_W,-FP_H,0.5*FP_D>}
  
  union{
    object{Plate}  
    #local StoneCount=5+int(15*rand(Seed));    
    #while ((StoneCount>0)&(!Debug))
      // allocate garbage stone
      #local R=0.5*FP_Delta+1*FP_Delta*rand(Seed);
      sphere{
         <0,R*0.5,0>,R
         
         scale <1,0.5+0.5*rand(Seed),1>
         
         pigment{rgb (0.05+0.1*rand(Seed))*<1,1,1>}
         
         normal{crackle scale <0.1,3,0.1>
           warp{spherical}
         }
          
         finish{
           ambient 0
           specular 0.001
           roughness 1
         } 
         translate x*0.45*min(FP_W,FP_D)*rand(Seed)
         rotate y*360*rand(Seed)
      }
      #local StoneCount=StoneCount-1;
    #end
    #if (Debug)
      pigment{Brown}
    #else      
      pigment{
        granite
        color_map {
          [0.35 color Gray25 ]
          [0.5 color Gray20 ]
          [0.9 color Gray20 ]
          [0.95 White]
        }
        translate 3*FP_W*rand(Seed)
        warp{turbulence 0.1}
      }
      
      normal{
        average
        normal_map{
          [1 granite scale 0.5*<1,0.2,1> translate 3*FP_W*rand(Seed)]
          [1 agate scale 0.5*<1,0.3,1> translate 3*FP_W*rand(Seed)]
          [1 crackle scale <0.3,0.5,0.3> solid translate 3*FP_W*rand(Seed)]
          [1 planar]
          [0.5 granite scale 0.1]
        }  
      }
      
      finish{
        ambient 0
        reflection 0
        specular 0.001
        roughness 0.6
        crand 0.1
      }
    #end  
    translate y*5*mm*rand(Seed) rotate x*1*rand(Seed) rotate y*1*rand(Seed) rotate y*90*int(4*rand(Seed)) 
    translate <0.5*FP_W,0,0.5*FP_D>
  }
#end    

#macro BuildPlate(MaxX, MaxZ, PlaceEarth)
  union{
    #local X=0;
    #while (X<MaxX)
      #local Z=0;
      #while (Z<MaxZ)      
        object{FloorPlate() translate <X*(FP_W+FP_Delta),0,Z*(FP_D+FP_Delta)>}
        #local Z=Z+1;
      #end
      #local X=X+1;
    #end
    
    #if (PlaceEarth)
      cylinder{<0,-FP_Delta,0>,<0,-100*FP_Delta,0>,max(FP_W,FP_D)*max(MaxX,MaxZ)
        #if (Debug)
          pigment{Gray10}          
        #else
          pigment{Gray10}
          normal{wrinkles scale 0.1}
          finish{
            ambient 0
            reflection 0
            specular 0.0001
            roughness 1
            crand 0.2
          }
        #end  
        translate <0.5*MaxX*(FP_W+FP_Delta),0,0.5*MaxZ*(FP_D+FP_Delta)>
      }
    #end
  }  
#end
//=============================================================================================================
#local WallW=20*m;
#local WallH=3*m;
// this code from WallStucco.pov
//====== Lay some Bricks ======
//Size           : dimension of the brick in a vector x, y, z
//Mortar         : width of the joint.
//Turbulence etc : control the stone deformation.
#macro BrickWall(Size, Mortar, Turbulence, Octaves, Lambda, Omega)

   #local Brick= pigment {
      boxed                                // one single brick ...
      scale <Size.x/2,Size.y/2,Size.z/2>
      translate <Size.x/2+Mortar,Size.y/2+Mortar,0>
      warp {repeat x*(Size.x+Mortar)}      // ... repeated over and over again.
      warp {repeat y*(2*(Size.y+Mortar))}
   }

   #declare FBrickWall= function {
      pigment {
         pigment_pattern {
            gradient y
            warp {repeat y}
            scale <1,2*(Size.y+Mortar),1>
         }
         pigment_map {
            [0.5, Brick
                  warp {                  // deforming the bricks ...
                     turbulence Turbulence
                     octaves Octaves
                     lambda Lambda
                     omega Omega
                  }
                  translate <0,-(Mortar/2),0>
            ]
            [0.5, Brick                  // ... row by row.
                  warp {
                     turbulence Turbulence
                     octaves Octaves
                     lambda Lambda
                     omega Omega
                  }
                  translate <(Size.x/2)+Mortar,(Size.y+(Mortar/2)),0>
            ]
         }
      }
   }
#end

#declare PWall=pigment {
   BrickWall(<4,1,1>,0.2,<0.05,0.1,0>,0,0*0.5,0*0.5)
   function{FBrickWall(x,y,z).gray}
   pigment_map {                    // give some stucture to the joint ...
      [0, granite
          scale 0.1
          colour_map {
            [0, rgb 0][1, rgb 0.3]
          }
      ]
      [0.05, crackle                // ... and the bricks.
             scale <3,1,1>
             turbulence 0.5
             colour_map {
               [0, rgb 0.34][1, rgb 0.5]
             }
      ]
   }
   scale 0.03*<WallH/WallW,1,1>
}            
 

#declare L2=0.8;//clock   //Set amount of decay of stucco, higher value is more decay. animate
#declare PWrink= pigment { //Mortar
   wrinkles scale <0.25,0.25,1>
   colour_map {
      [0, rgb 0.5]
      [L2, rgb 0.96]
   }
   
}                       

#declare PStucco= pigment {    //Stucco
   granite
   scale 0.05
   colour_map {
      [0, rgb 0.96]
      [1, rgb 1]
   }
}

#declare StuMor= pigment {       //Stucco & Mortar
   pigment_pattern{
      crackle
      scale 0.25
   }
   pigment_map {
      [L2, PWrink]
      [L2, PStucco]
   }
   translate x*2.2
   scale <WallH/WallW,1,1>
}


 
#local Wall=union{    
  #if (Debug)
    box{<-WallW,0,0>,<0,WallH,-1> pigment{checker Gray10 Gray20 scale <1,0.2,1>}}
  #else
    //Stucco
    //====== Doing the Stucco ======
    #local OStucco=height_field {  //Turn it into a hightfield
      function 1000, 1000{               //500,500 for test higher is better, but watch the memory
        pigment{StuMor }
      } 
      smooth
      water_level 0.1
      translate -0.5
      rotate -90*x
      //scale <20,20,2>
      pigment {                         //Use the mortar to colour up the stucco
         pigment_pattern {
            wrinkles
            scale 0.25
         }
         color_map {
            [L2*0.5, rgb 0.2]
            [L2, rgb 0.4*<1,1,0.95>]
         }
         warp {planar z, 0}
         translate <-0.5, -0.5, 0>
         rotate <180,0,0>
         //scale <20,20,2>
      }   
     translate <-0.5,0.5,0.5>
     scale <WallW,WallH,20*FP_Delta>      
     translate z*-0.01*9.5
     
     
     finish{    
       ambient 0
       specular 0.001
       roughness 1
       crand 0.1
     }
     normal{
       average
       normal_map{
         [1 crackle solid scale <0.3,0.3,1>]
         [1 granite scale 0.1]
         [1 wrinkles scale 0.2]
         [2 planar]
       }  
     }
    }
    
   
    // Wall
    #local OWall=height_field {      // Build the wall
     function 500, 500 {   //500,500, for test, higher is better & slower. Watch the memory use.
        pigment{PWall}
     }
     smooth
     translate -0.5
     rotate <-90,180,0>
     //scale <33,33,0.01>
     translate <-0.5,0.5,-0.5>
     scale <WallW,WallH,10*FP_Delta>
     translate z*FP_Delta
    }
    
    // allocate
    
    object{OStucco}
    //difference{
      //object{OWall}    
      object{
        object{OWall}
        
        clipped_by{box{<0.0001,0.0001,-0.5>,<WallW-0.0001,WallH-0.0001,0.5> translate x*-WallW}} //pigment{Red} finish{ambient 0}}}
        pigment {
           PWall
           pigment_map {
              [0, rgb 0.1]
              [0.05, wrinkles
                     turbulence 0.3
                     scale <2,0.3,1>
                     colour_map {
                       [0.0, rgb  0.5*<0.5,0.3,0.25>]
                       [0.15, rgb 0.5*<0.5,0.3,0.25>/1.3]
                       [0.3, rgb  0.5*<0.5,0.3,0.25>]
                       [0.6, rgb  0.5*<0.6,0.3,0.25>/1.6]
                       [0.8, rgb  0.5*<0.5,0.3,0.25>]
                       [1.0, rgb  0.5*<0.5,0.3,0.35>/2]
                    }
              ]
           }
           translate <-0.5, -0.5, 0>
           rotate -90*x
           warp {planar y, 0}
           scale <WallW, WallH,1>
           //scale <33,33,0.01>
        }
        normal{
          average
          normal_map{
            [1 granite scale <0.1,0.1,0.05>]
            [1 wrinkles scale 0.01]
            [1 planar]
          }  
        }
           
        finish{
          ambient 0
          roughness 1
          specular 0.00001     
        }
        
      }  
      
    //}  
  #end
  
}
//=============================================================================================================
#local B_R=6*cm; 
#local B_Base_H=4*B_R;
#local B_Border=6*mm;
#local B_Head_RMax=0.5*B_R;
#local B_Head_RMin=0.9*B_Head_RMax;
#local B_HeadH=0.3*B_Base_H;
#local B_HeadRing_H=2*cm;

#local Bottle=union{  
  merge{
    //base
    difference{
      cylinder{<0,0,0>,<0,B_Base_H,0>,B_R}  
      difference{
        cylinder{<0,B_Border,0>,<0,B_Base_H+B_Border,0>,B_R-B_Border}  
        sphere{<0,B_Border,0>,2*B_R scale <1,0.5,1> translate y*-0.7*B_R}
      }  
      sphere{<0,0,0>,2*B_R scale <1,0.5,1> translate y*-0.7*B_R }        
    }
    // prepare To Head
    difference{
      sphere{0,B_R}
      sphere{0,B_R-B_Border}
      cylinder{<0,0,0>,<0,2*B_R,0>,B_Head_RMax-B_Border}
      box{<-2*B_R,0,-2*B_R>,<2*B_R,-2*B_R,2*B_R>}
      
      translate y*0.9999*B_Base_H
    }
    // head
    difference{ 
      difference{
        union{
          cylinder{<0,0,0>,<0,-0.5*B_R,0>,B_Head_RMax}
          cone{<0,0,0>,B_Head_RMax,<0,B_HeadH,0>,B_Head_RMin}
        }  
        cone{<0,-0.001,0>,B_Head_RMax-B_Border,<0,B_HeadH+0.001,0>,B_Head_RMin-B_Border}
        cylinder{<0,0.001,0>,<0,-0.5*B_R-0.001,0>,B_Head_RMax-B_Border}      
        translate y*(B_Base_H+B_R)
      }  
      sphere{0,B_R-B_Border translate y*0.9999*B_Base_H}
    }
    // Head Ring
    difference{  
      merge{
        cylinder{<0,0,0>,<0,B_HeadRing_H,0>,B_Head_RMin+B_Border}
        torus{B_Head_RMin,B_Border}
        torus{B_Head_RMin,B_Border translate y*B_HeadRing_H}
      }
      cylinder{<0,-0.001,0>,<0,B_HeadRing_H+0.001,0>,B_Head_RMin-B_Border}        
      translate y*(B_Base_H+B_R+B_HeadH)
    }
  }
  #if (Debug)
    pigment{DarkGreen}
  #else  
    pigment{rgbft 0.7*<0.1,0.2,0.12,0.5,0.9>}
    interior{ior 2}
    
    normal{bumps scale 0.1 warp{cylindrical}}
    
    finish{
      reflection 0.1
      specular 0.06
      roughness 0.1  
      ambient 0
    } 
    
    #if (Photons)
      photons {
        target
        refraction on
        reflection on
        collect on
      }  
    #end
    
  #end
}
//=============================================================================================================
#local BoxSize=60*cm;
#local BoxH=0.8*BoxSize;
#local BoxBorderD=5*mm;

#local Box=merge{
  #local CoverPart=merge{
    cylinder{<0+0.001,0,0>,<BoxSize-0.001,0,0>,0.5*BoxBorderD translate z*0.5*BoxBorderD}
    
    box{<0+0.002,0,0>,<BoxSize-0.002,0.45*BoxSize,BoxBorderD>}
    
  }

  difference{
    box{<0,0,0>,<BoxSize,BoxH,BoxSize>}
    box{BoxBorderD,<BoxSize-BoxBorderD,BoxH+1,BoxSize-BoxBorderD>}
  }  
  
  object{CoverPart rotate x*-120 translate y*BoxH}  
  object{CoverPart rotate x*-30 rotate y*-90 translate x*BoxBorderD translate y*BoxH}
  object{CoverPart rotate x*-120 rotate y*180 translate <BoxSize,0,BoxSize> translate y*BoxH}
  object{CoverPart rotate x*115 rotate y*90 translate <BoxSize-BoxBorderD,0,BoxSize>  translate y*BoxH}
  
  #if (Debug)
    pigment{White}
  #else
    pigment{
      wrinkles
      pigment_map{
        [0.10 Yellow]
        [0.15 color <0.5,0.5,0.3>]
        [0.8 color <0.5,0.5,0.5>]
        [1 Gray50]
      }
    }
    
    normal{
      average
      normal_map{
        [1 planar]
        [0.1 granite scale 0.5]
      }  
    }
    
    finish{
      ambient 0
      specular 0.1
      roughness 0.9
    }
  #end  
}
//=============================================================================================================
#macro _Tree(Seed, Level, BranchPerNode, P_Branch, P_Stem, Branch_Angle)
  #local PrevR=0.03*pow(Level+1,1.5);
  #local R=0.03*pow(Level,1.5);
  #local H=0.2+0.4*Level;  
  union{
    cone{<0,0,0>,PrevR,<0,H,0>,R}
    #if (Level=0)
      sphere{<0,0,0>,H translate y*H 
      pigment{
        wrinkles
        pigment_map{
          [0.01 Green]
          [0.1 DarkGreen]
        }
      } 
      normal{
        average
        normal_map{
          [1 bumps scale 0.1]
          [1 granite scale 0.5]
        }  
      } 
      finish{crand 0.2}}
    #else
      sphere{<0,H,0>,R}    
      // branches
      #local NumBranch=0;
      #while (NumBranch<BranchPerNode)
        #if ((rand(Seed)<=P_Branch) & (P_Branch>0))
          #local Branch=_Tree(Seed, Level-1, BranchPerNode, P_Branch, P_Stem, Branch_Angle)
          object{Branch rotate x*Branch_Angle*(0.5+0.5*rand(Seed)) rotate y*(NumBranch+0.5*rand(Seed))*(360/BranchPerNode) translate y*H}
        #end
        #local NumBranch=NumBranch+1;
      #end
      // stem
      #if ((rand(Seed)<=P_Stem) & (P_Stem>0))
        #local Stem=_Tree(Seed, Level-1, BranchPerNode, P_Branch, 0, Branch_Angle)  
        object{Stem translate y*H}
      #end
    #end
    
    rotate y*360*rand(Seed)
    normal{agate scale <0.1,1,0.1> translate y*rand(Seed)}    
    pigment{
      agate 
      pigment_map{
        [0.05 color 0.9*Brown]
        [0.1 Brown]
        [0.9 Brown]
        [0.95 color 0.5*Brown]
      }
      scale <0.1,1,0.1>
    }    
    finish{crand 0.2 roughness 0.001 ambient 0}       
  }
#end


#macro Tree(Seed, Level, BranchPerNode, P_Branch, P_Stem, Branch_Angle)
  object{
    _Tree(Seed, Level, BranchPerNode, P_Branch, P_Stem, Branch_Angle)
    
  }
#end

#local ShadowTree=object{
  //Tree(seed(470059),6,7,0.3,0.6,60) - not bad tree. This string for backup.
  Tree(seed(470059),6,7,0.3,0.6,60) // thist string for searching other trees (where is nice tree?)
  scale <0.1,0.15,0.1>  
  no_image
}  

//=============================================================================================================
#local LO_R=7*cm;
#local LeftOver=union{
  // full
  #local FullApple=difference{
    sphere{<0,0,0>,LO_R}
    #local DiffCone=cone{<0,0,0>,0,<0,1,0>,0.9 translate y*0.8*LO_R}
    
    object{DiffCone}
    object{DiffCone rotate x*180}
    
    //scale <1,0.9,1>   
    
    #if (Debug)
      pigment{Red}
    #else
      pigment{
        radial frequency 4
        pigment_map{
          [0.4 Red]
          [0.5 rgb<0.5,0.1,0.1>]
          [0.6 DarkGreen]
          [0.7 Yellow]
          [0.95 Yellow]
          [1 Red]
        }
        warp{turbulence 1 lambda 3 octaves 7}   
      }
      
      finish{
        ambient 0
        specular 0.05
        roughness 0.1
      }
    
    #end    
  } 
  #local L=union{  
    difference{
      object{FullApple}
      
      #local DiffTorus=torus{LO_R*0.45,0.25*LO_R scale <2,2.3,2>}
      
      object{DiffTorus translate y*0.5*LO_R translate x*0.1*LO_R}
      object{DiffTorus scale <0.6,1,0.6> translate z*0.1*LO_R}
      object{DiffTorus translate y*-0.5*LO_R} 
      
      cylinder{<0,0.5*LO_R,0>,<0,1,0>,0.5*LO_R translate x*0.7*LO_R}
      
    }
    
    #local Stack_R=0.05*LO_R;          
    union{
      cylinder{<0,0,0>,<0,1*LO_R,0>,Stack_R}
      cylinder{<0,0*LO_R,0>,<0,0.3*LO_R,0>,Stack_R rotate <30,10,0> translate y*LO_R}
      pigment{rgb 0.3*Brown}
      
      #if (!Debug)
        finish{
          ambient 0
        }
      #end  
    }  
    
    sphere{0,0.4*LO_R}
    
    #if (Debug)
      pigment{Yellow}
    #else  
      pigment{
        wrinkles
        pigment_map{
          [0.1 Gray10]
          [0.6 rgb 0.2*Brown]
          [0.9, Yellow]
          [1 Black]
        }  
      }
      
      normal{
        average
        normal_map{
          [1 bumps scale <0.01,0.5,0.01>]
          [1 agate scale 0.03]
        }  
        warp {cylindrical}
      }
      
      finish{
        ambient 0    
        specular 0.1
        roughness 0.8
      }
    #end
    rotate x*90
    rotate y*30
  }  
  
  object{L translate y*0.6*LO_R}
}
//=============================================================================================================

// debug
/*Show(
  object{LeftOver rotate y*60}
)*/

//main


union{
  object{Wall rotate y*90 translate x*-FP_Delta}      
  #if (!Debug)
    // border between wall and floor
    cylinder{<0,0,0>,<0,0,WallW>,3*cm
      scale <1,2/3,1>
      pigment{
        wrinkles scale 0.01
        pigment_map{
          [0.2 Gray10]      
          [0.4 Gray25]
          [0.6 Gray15]
          [1 Black]
        }
        warp{turbulence 1}
      }      
      normal{
        average
        normal_map{
          [1 granite scale <0.1,10,0.1>]
          [1 bumps scale <0.2,10,0.2>]
        }  
      }
      
      finish{
        ambient 0
        specular 0.001
        roughness 1
        crand 0.15
      }
    }
  #end
  
  object{Wall scale <1,10,1> rotate y*90 translate x*-FP_Delta rotate y*180 translate <6*(FP_W+FP_Delta),0,14*(FP_D+FP_Delta)>}
  object{Wall scale <1,10,1> rotate y*90 translate x*-FP_Delta rotate y*180 
    #if (Debug)
      translate <6*(FP_W+FP_Delta),0,43.5*(FP_D+FP_Delta)>
    #else  
      translate <6*(FP_W+FP_Delta),0,42*(FP_D+FP_Delta)>
    #end  
  }
  
  object{BuildPlate(6,20,yes) }
  
  union{
    Wire(no,Blue,object{TrashBasket })
    object{ShadowTree translate y*(TB_H-0.5*TB_RingH)}
    
    object{LeftOver rotate y*-30 translate m*<-1.5,0,-3.3>}
    translate m*<2,0,8>
  }
  
  union{
    Wire(no, Green, object{Bottle})
    Wire(no, Green, object{Bottle translate <25*cm,0,-8*cm>})
    Wire(no, Green, object{Bottle rotate x*90 rotate y*120 translate <-1*B_R,B_R,-3*B_R>})
    translate m*<2-0.7*TB_R/m,0,7.6>    
  }    
  
  Wire(no, Green, object{Bottle rotate x*90 rotate y*180 translate <B_R+FP_Delta,B_R,0>
    translate m*<0,0,6>
  })
  
  
  Wire(no, Yellow, object{Box rotate y*-10 translate m*<10*cm,0,3>}) 
  
 
}
  
//<4,1.5,1.5> - good camera location
camera{location <4,1.5,1.5> look_at<0,0,0> translate z*6
  #if (FocalBlur)
    blur_samples 50 //add samples if you got a fast computer
    aperture 0.05
    confidence 0.1
    variance 0         
    focal_point <0,1.5*TB_H,5>
  #end  
}

light_source{<20,5,35> 
  #if (Debug)
    White
  #else
    <0.5,0.7,1>
    area_light <0,0,0.5>,<0,0.5,0>,5,5 adaptive 1 jitter
  #end
}

#if (!Debug)
  sphere{0,1000 pigment{Gray10} inverse finish{ambient 1}}
#end


