

#include "colors.inc"   
#include "transforms.inc"    
#include "moss.inc"

#declare mossHair1=union { 
         object { moss_13_stems }
         object { moss_13_leaves }
        scale 0.8
        }            
        
        
#include "simplemoss.inc"

#declare mossHair2 = union { 
         object { simplemoss_13_stems }
         object { simplemoss_13_leaves }
         scale 3
         }
         
        


#declare mossRand = seed(1245);   

// Macro to return a random number

#macro mr(num)
        rand(mossRand)*num
#end

#macro randmoMossVect(mossPos,v1,v2)
        <mossPos.x+mr(v1.x)-mr(v1.x)+mr(v2.x)-mr(v2.x), mossPos.y+mr(v1.y)-mr(v1.y)+mr(v2.y)-mr(v2.y), mossPos.z+mr(v1.z)-mr(v1.z)+mr(v2.z)-mr(v2.z)>
#end            

#declare MOSS_TYPE_1 = 0;
#declare MOSS_TYPE_2 = 1;


#macro Add_Moss_Hair(mossSurface, sVect, eVect, fallDirection, hairSize, hairStep1, hairStep2, mossType, mossHairTex)
        
        #if(mossType = MOSS_TYPE_1)
                #declare mossHair=mossHair1;
        #else
                #declare mossHair=mossHair2;
        #end
        
        #local objStartPos = min_extent(mossSurface);
        #local objEndPos = max_extent(mossSurface);    


        #declare v1=sVect;
        #declare v2=eVect;
        #declare v3=v2-v1;     
        
        #if(v3.x != 0)
                #if(v3.y != 0)
                        #if(v3.z != 0)
                                #error "Difference between xyz for vectors cannot be greater than zero!"
                        #end
                #end
        #end              
        
        #if(v3.x !=0)
                #declare sVect=<objStartPos.x, sVect.y, sVect.z>;
                #declare eVect=<objEndPos.x, eVect.y, eVect.z>;
        #end
        #if(v3.y !=0)
                #declare sVect=<sVect.x, objStartPos.y, sVect.z>;
                #declare eVect=<eVect.x, objEndPos.y, eVect.z>;
        #end
        #if(v3.z !=0)
                #declare sVect=<sVect.x, sVect.y, objStartPos.z>;
                #declare eVect=<eVect.x, eVect.y, objEndPos.z>;
        #end

        #declare v1=sVect;
        #declare v2=eVect;
        #declare v3=v2-v1;     
                
        
        #if(v3.x != 0)
                #declare Step1Vect=<v3.x, 0, 0>;
        #else                        
                #declare Step1Vect=<0, v3.y, 0>;
        #end                        
        
        #if(v3.z != 0)
                #declare Step2Vect=<0, 0, v3.z>;
        #else                        
                #declare Step2Vect=<0, v3.y, 0>;
        #end            
        
        #declare Step1Vect=Step1Vect/hairStep1;
        #declare Step2Vect=Step2Vect/hairStep2;
        

        #declare step1=0;

        #declare cCount = 0;   
        #declare firstLine=true;     
        #declare percentDone = -1;
        union
        {
        #while(step1 < hairStep1)
                #declare step2=0;  
                #declare mossPos=sVect+(step1*Step1Vect);

                #if(floor((step1/hairStep1)*100) > percentDone)  
                #declare percentDone=floor((step1/hairStep1)*100);
                #warning concat(concat(concat(str(percentDone, 3, 1), "% Done. "), str(cCount,0,0)), " Hairs.")
                #end      

                #while(step2 < hairStep2)     

                        #local N = <0,0,0>;                                                          
                        
                        #local S = trace(mossSurface, randmoMossVect(mossPos,Step1Vect,Step2Vect), fallDirection, N); 

                        #if(vlength(N) > 0) // hit       
                                //cylinder { <0, 0, 0> <0, hairSize, 0> hairSize/(10+mr(10)) scale 1+mr(1) Reorient_Trans(-fallDirection,N) translate S pigment { Yellow } }       
                                
                                object { mossHair scale <hairSize+mr(hairSize), hairSize+mr(hairSize*2), hairSize+mr(hairSize)>  rotate <0, mr(360), 0> Reorient_Trans(-fallDirection,N) translate S } 
                                #declare cCount=cCount+1;
                        #end
                                        
                        #declare mossPos=mossPos+Step2Vect;
                        #declare step2=step2+1;
                #end                                       
                #declare step1=step1+1;
        #end
        
                texture 
                { 
                        mossHairTex
                }
        }


        #if(cCount = 0)
                #error "Place_Moss Error: no Moss has hit the object try using different direction or start/end pos for moss!"
        #end   
        #warning concat("Total: ", str(cCount,1,0), " moss hairs used")   
        

#end // End Mac                                    






#macro Place_Moss(objectSurface, sVect, eVect, random, fallDirection, clumpSize, clumpScale, clumpStep1, clumpStep2, showHairs, hairSize, hairAmount, mossType, mossHairTex, mossEarthTex)

        #declare v1=sVect;
        #declare v2=eVect;
        #declare v3=v2-v1;      
        
        #if(v3.x != 0)
                #if(v3.y != 0)
                        #if(v3.z != 0)
                                #error "Difference between xyz for vectors cannot be greater than zero!"
                        #end
                #end
        #end
        
        #if(v3.x != 0)
                #declare Step1Vect=<v3.x, 0, 0>;
        #else                        
                #declare Step1Vect=<0, v3.y, 0>;
        #end                        
        
        #if(v3.z != 0)
                #declare Step2Vect=<0, 0, v3.z>;
        #else                        
                #declare Step2Vect=<0, v3.y, 0>;
        #end            
        
        #declare Step1Vect=Step1Vect/clumpStep1;
        #declare Step2Vect=Step2Vect/clumpStep2;
        

        #declare step1=0;

        #declare cCount = 0;   
        #declare firstLine=true;     
        #declare percentDone = -1;

#declare mossBase = blob {
          threshold 0.6
            

        #while(step1 < clumpStep1)
                #declare step2=0;  
                #declare mossPos=sVect+(step1*Step1Vect);

                #if(floor((step1/clumpStep1)*100) > percentDone)  
                #declare percentDone=floor((step1/clumpStep1)*100);
                #warning concat(concat(concat(str(percentDone, 3, 1), "% Done. "), str(cCount,0,0)), " Clumps.")
                #end      

                #while(step2 < clumpStep2)     

                        #local N = <0,0,0>;                                                          
                        
                        #local S = trace(objectSurface, mossPos, fallDirection, N); 

                        #if(vlength(N) > 0) // hit       
                                #if(random)
                                        #if(mr(1) > random)
                                                sphere { <0, 0, 0>, clumpSize*(0.25+mr(1.5)), 1 scale clumpScale*(0.75+mr(0.5)) Reorient_Trans(fallDirection,N) translate S }       
                                        #end 
                                #else
                                        sphere { <0, 0, 0>, clumpSize*(0.25+mr(1.5)), 1 scale clumpScale*(0.5+mr(0.5)) Reorient_Trans(fallDirection,N) translate S }       
                                #end
                                #declare cCount=cCount+1;
                        #end
                                        
                        #declare mossPos=mossPos+Step2Vect;
                        #declare step2=step2+1;
                #end                                       
                #declare step1=step1+1;
        #end
      


        #if(cCount = 0)
                #error "Place_Moss Error: no Moss has hit the object try using different direction or start/end pos for moss!"
        #end   
        #warning concat("Total: ", str(cCount,1,0), " moss clumps used")   
        
        // place hairs
        
        
        }    
        
        union
        {
                #if(showHairs)                                                                                                                        
                        object { Add_Moss_Hair(mossBase, sVect, eVect, fallDirection, hairSize, clumpStep1*hairAmount, clumpStep2*hairAmount, mossType, mossHairTex) }
                #end
                object 
                {        
                        mossBase   
                        #if(showHairs)
                                texture  
                                { 
                                        mossEarthTex
                                }
                        #else
                                texture
                                {                                   
                                        granite
                                        turbulence 0.765
                                        omega 0.675
                                        lambda 2.5
                                        scale hairSize
                                        texture_map
                                        {
                                                [ 0.0 mossEarthTex ]
                                                [ 0.1 mossEarthTex ]
                                                [ 0.5 mossHairTex ]        
                                                [ 0.55 mossHairTex ]        
                                                [ 0.9 mossEarthTex ]
                                                [ 1.0 mossEarthTex ]
                                        }
                                            
                                                                                   
                                }
                        #end
                }                     
                
        }

#end // End Mac                                    

/*
#declare earthTex= texture  
{ 
        pigment 
        { 
                granite 
                turbulence 0.3 
                omega 0.7 
                lambda 2.8
                colour_map
                {
                        [ 0.0 rgb <0.15, 0.07, 0.04> ]
                        [ 0.5 rgb <0.22, 0.11, 0.05> ]
                        [ 1.0 rgb <0.32, 0.14, 0.05> ]
                }                                     
        }                         
        finish { ambient 0 diffuse 0.5 } 
        normal
        {
                wrinkles 3 turbulence 0.6 omega 0.8 scale 0.2
        }
}

#declare hairTex = texture 
{ 
        pigment
        {
                wrinkles      
                omega 0.625
                lambda 2.5 
                turbulence 0.375
                colour_map
                {
                        [ 0.0 rgb <0.01, 0.3, 0.00> ]
                        [ 0.4 rgb <0.00, 0.45, 0.08> ]
                        [ 0.7 rgb <0.01, 0.35, 0.04> ]
                        [ 0.8 rgb <0.8, 0.61, 0.29> ]
                        [ 0.9 rgb <0.65, 0.41, 0.12> ]
                        [ 1.0 rgb <0.001, 0.25, 0.02> ]                                            
                } 
        }     
        finish { ambient 0 diffuse 0.65 brilliance 0.9 }
}

*/  

