/*************** Tree made by: ******************

Arbaro 2.0 - creates trees objects for rendering from xml parameter files
(c) 2003-2004 by Wolfram Diestel <diestel@steloj.de> (GPL see file COPYING)


<?xml version='1.0' ?>

<arbaro>
  <species name='moss'>
    <!-- general params -->
    <param name='Shape' value='4'/>
    <param name='Levels' value='2'/>
    <param name='Scale' value='1.2'/>
    <param name='ScaleV' value='0.6'/>
    <param name='BaseSize' value='0.2'/>
    <param name='Ratio' value='0.0050'/>
    <param name='RatioPower' value='1.0'/>
    <param name='Flare' value='0.0'/>
    <param name='Lobes' value='0'/>
    <param name='LobeDepth' value='0.0'/>
    <param name='Smooth' value='0.3'/>
    <param name='Leaves' value='15'/>
    <param name='LeafShape' value='disc'/>
    <param name='LeafScale' value='0.06'/>
    <param name='LeafScaleX' value='0.15'/>
    <param name='LeafQuality' value='0.5'/>
    <param name='LeafStemLen' value='0.0'/>
    <param name='LeafDistrib' value='4'/>
    <param name='LeafBend' value='0.3'/>
    <param name='AttractionUp' value='0.0'/>
    <param name='PruneRatio' value='0.0'/>
    <param name='PrunePowerLow' value='0.5'/>
    <param name='PrunePowerHigh' value='0.5'/>
    <param name='PruneWidth' value='0.5'/>
    <param name='PruneWidthPeak' value='0.5'/>
    <param name='0Scale' value='1.0'/>
    <param name='0ScaleV' value='0.0'/>
    <param name='0BaseSplits' value='8'/>
    <!-- level 0 -->
    <param name='0DownAngle' value='0.0'/>
    <param name='0DownAngleV' value='0.0'/>
    <param name='0Rotate' value='0.0'/>
    <param name='0RotateV' value='0.0'/>
    <param name='0Branches' value='1'/>
    <param name='0BranchDist' value='0.0'/>
    <param name='0Length' value='1.0'/>
    <param name='0LengthV' value='0.0'/>
    <param name='0Taper' value='1.0'/>
    <param name='0SegSplits' value='0.0'/>
    <param name='0SplitAngle' value='40.0'/>
    <param name='0SplitAngleV' value='20.0'/>
    <param name='0CurveRes' value='10'/>
    <param name='0Curve' value='-20.0'/>
    <param name='0CurveBack' value='40.0'/>
    <param name='0CurveV' value='60.0'/>
    <!-- level 1 -->
    <param name='1DownAngle' value='90.0'/>
    <param name='1DownAngleV' value='60.0'/>
    <param name='1Rotate' value='120.0'/>
    <param name='1RotateV' value='30.0'/>
    <param name='1Branches' value='150'/>
    <param name='1BranchDist' value='1.0'/>
    <param name='1Length' value='0.2'/>
    <param name='1LengthV' value='0.15'/>
    <param name='1Taper' value='0.9'/>
    <param name='1SegSplits' value='0.0'/>
    <param name='1SplitAngle' value='0.0'/>
    <param name='1SplitAngleV' value='0.0'/>
    <param name='1CurveRes' value='4'/>
    <param name='1Curve' value='10.0'/>
    <param name='1CurveBack' value='30.0'/>
    <param name='1CurveV' value='20.0'/>
    <!-- level 2 -->
    <param name='2DownAngle' value='90.0'/>
    <param name='2DownAngleV' value='-50.0'/>
    <param name='2Rotate' value='-120.0'/>
    <param name='2RotateV' value='20.0'/>
  </species>
</arbaro>
************************************************/
#declare moss_13_height = 1.19266;
#declare moss_13_stems = 
  mesh2 {
    vertex_vectors { 3646
    /* stem 0*/ 
    /*0*/ <0,0,0>,
    /*1*/ <0.00567,0,0>,<0,0,0.00567>,<-0.00567,0,0>,
            <-0,0,-0.00567>,
    /*2*/ <0.0051,0.11335,0>,<0,0.11335,0.0051>,<-0.0051,0.11335,0>,
            <-0,0.11335,-0.0051>,
    /*3*/ <0.00394,0.22549,0.01673>,<-0.00059,0.2248,0.02121>,<-0.00513,0.22544,0.01672>,
            <-0.00059,0.22613,0.01224>,
    /*4*/ <0.00873,0.3344,0.04691>,<0.00478,0.33352,0.05079>,<0.00081,0.33476,0.04702>,
            <0.00477,0.33564,0.04314>,
    /*5*/ <0.01348,0.43758,0.09361>,<0.01007,0.43633,0.09676>,<0.00669,0.43788,0.09371>,
            <0.0101,0.43913,0.09056>,
    /*6*/ <0.01821,0.53818,0.14564>,<0.01536,0.537,0.1482>,<0.01255,0.53843,0.14572>,
            <0.01541,0.53961,0.14316>,
    /*7*/ <0.01951,0.6443,0.18572>,<0.01723,0.64353,0.18784>,<0.01497,0.64437,0.18573>,
            <0.01725,0.64513,0.1836>,
    /*8*/ <0.02314,0.75069,0.22452>,<0.02143,0.75017,0.22613>,<0.01974,0.75082,0.22455>,
            <0.02144,0.75134,0.22293>,
    /*9*/ <0.02724,0.86008,0.25394>,<0.0261,0.85983,0.25505>,<0.02497,0.86017,0.25396>,
            <0.0261,0.86042,0.25286>,
    /*10*/ <0.03969,0.96842,0.28456>,<0.03913,0.96833,0.28512>,<0.03857,0.96854,0.28459>,
            <0.03913,0.96864,0.28403>,
    /*11*/ <0.05701,1.07801,0.30766>

    /* stem 0c0*/ 
    /*0*/ <0,0.11335,0>,
    /*1*/ <0.00335,0.11363,0.00383>,<-0.00338,0.11598,0.00277>,<-0.00335,0.11308,-0.00383>,
            <0.00338,0.11072,-0.00277>,
    /*2*/ <0.04363,0.21052,-0.03904>,<0.03765,0.21262,-0.03999>,<0.03767,0.21004,-0.04586>,
            <0.04366,0.20794,-0.04491>,
    /*3*/ <0.08299,0.31017,-0.07553>,<0.07774,0.31197,-0.07633>,<0.07786,0.31002,-0.08159>,
            <0.08312,0.30821,-0.08079>,
    /*4*/ <0.10912,0.41788,-0.09904>,<0.10445,0.41891,-0.09957>,<0.10475,0.41784,-0.10425>,
            <0.10942,0.4168,-0.10372>,
    /*5*/ <0.12318,0.52939,-0.11403>,<0.11922,0.52986,-0.11441>,<0.11953,0.5293,-0.11837>,
            <0.1235,0.52884,-0.11799>,
    /*6*/ <0.14376,0.63896,-0.13456>,<0.14062,0.6395,-0.13489>,<0.14084,0.63888,-0.13802>,
            <0.14398,0.63834,-0.13769>,
    /*7*/ <0.17018,0.74624,-0.15992>,<0.16785,0.74675,-0.16019>,<0.16799,0.74618,-0.16252>,
            <0.17032,0.74566,-0.16225>,
    /*8*/ <0.20502,0.84982,-0.1899>,<0.2035,0.85028,-0.19011>,<0.20357,0.84982,-0.19164>,
            <0.20509,0.84936,-0.19143>,
    /*9*/ <0.24551,0.95304,-0.21303>,<0.24477,0.95331,-0.21315>,<0.24482,0.95312,-0.21392>,
            <0.24557,0.95285,-0.21381>,
    /*10*/ <0.29419,1.04996,-0.24605>

    /* stem 0c0.0*/ 
    /*0*/ <0.04716,0.22661,-0.04836>,
    /*1*/ <0.0489,0.22617,-0.04766>,<0.04712,0.22819,-0.04727>,<0.04542,0.22705,-0.04905>,
            <0.0472,0.22503,-0.04945>,
    /*2*/ <0.0896,0.27613,-0.11884>,<0.08823,0.27769,-0.11854>,<0.08691,0.27681,-0.11992>,
            <0.08828,0.27524,-0.12022>,
    /*3*/ <0.12799,0.31617,-0.19726>,<0.12706,0.31734,-0.19712>,<0.12606,0.31663,-0.19798>,
            <0.12698,0.31547,-0.19811>,
    /*4*/ <0.15679,0.33181,-0.28759>,<0.1563,0.33254,-0.28763>,<0.15562,0.33206,-0.28793>,
            <0.15611,0.33133,-0.2879>,
    /*5*/ <0.1787,0.32171,-0.38054>,<0.17856,0.32194,-0.3806>,<0.17834,0.32179,-0.38064>,
            <0.17848,0.32156,-0.38058>,
    /*6*/ <0.17852,0.32175,-0.38059>

    /* stem 0c0.1*/ 
    /*0*/ <0.07262,0.29049,-0.07147>,
    /*1*/ <0.07182,0.29133,-0.07003>,<0.07295,0.29213,-0.07224>,<0.07342,0.28965,-0.0729>,
            <0.07228,0.28885,-0.0707>,
    /*2*/ <0.15333,0.29491,-0.02724>,<0.15421,0.29553,-0.02895>,<0.15457,0.29361,-0.02946>,
            <0.15369,0.29299,-0.02775>,
    /*3*/ <0.23285,0.29191,0.01919>,<0.23355,0.29235,0.01802>,<0.23374,0.29099,0.01762>,
            <0.23304,0.29054,0.01878>,
    /*4*/ <0.30335,0.26737,0.07319>,<0.3039,0.26761,0.07259>,<0.30388,0.26682,0.07226>,
            <0.30333,0.26659,0.07286>,
    /*5*/ <0.36189,0.22286,0.12873>,<0.36208,0.22292,0.12857>,<0.36204,0.2227,0.12844>,
            <0.36185,0.22264,0.1286>,
    /*6*/ <0.36196,0.22278,0.12859>

    /* stem 0c0.2*/ 
    /*0*/ <0.08842,0.34257,-0.08552>,
    /*1*/ <0.08834,0.34222,-0.08726>,<0.08834,0.34432,-0.08587>,<0.0885,0.34293,-0.08377>,
            <0.08849,0.34083,-0.08517>,
    /*2*/ <-0.00059,0.33938,-0.08226>,<-0.00059,0.34101,-0.08118>,<-0.00047,0.33993,-0.07956>,
            <-0.00047,0.3383,-0.08064>,
    /*3*/ <-0.08865,0.32688,-0.07715>,<-0.08878,0.32802,-0.07638>,<-0.08861,0.32726,-0.07523>,
            <-0.08848,0.32612,-0.076>,
    /*4*/ <-0.17159,0.29489,-0.07124>,<-0.1718,0.29553,-0.07077>,<-0.1716,0.29511,-0.0701>,
            <-0.17138,0.29447,-0.07057>,
    /*5*/ <-0.24459,0.24437,-0.06366>,<-0.2447,0.24454,-0.06351>,<-0.2446,0.24443,-0.06331>,
            <-0.2445,0.24426,-0.06346>,
    /*6*/ <-0.2446,0.2444,-0.06348>

    /* stem 0c0.3*/ 
    /*0*/ <0.10146,0.39562,-0.09688>,
    /*1*/ <0.10242,0.3957,-0.09545>,<0.10244,0.39685,-0.09759>,<0.10051,0.39555,-0.09832>,
            <0.10049,0.39439,-0.09617>,
    /*2*/ <0.15496,0.33551,-0.12763>,<0.15498,0.33641,-0.1293>,<0.15348,0.3354,-0.12986>,
            <0.15347,0.3345,-0.1282>,
    /*3*/ <0.20457,0.27047,-0.15447>,<0.20465,0.27103,-0.15569>,<0.20356,0.27035,-0.15607>,
            <0.20348,0.26979,-0.15485>,
    /*4*/ <0.23712,0.19242,-0.17092>,<0.23724,0.19263,-0.17168>,<0.23651,0.19237,-0.17186>,
            <0.2364,0.19216,-0.17111>,
    /*5*/ <0.24901,0.10778,-0.18194>,<0.24905,0.10782,-0.18218>,<0.24882,0.10779,-0.18223>,
            <0.24877,0.10776,-0.18199>,
    /*6*/ <0.24891,0.10779,-0.18209>

    /* stem 0c0.4*/ 
    /*0*/ <0.1088,0.43226,-0.10353>,
    /*1*/ <0.10715,0.4325,-0.10332>,<0.10894,0.4338,-0.1042>,<0.11045,0.43202,-0.10373>,
            <0.10866,0.43073,-0.10285>,
    /*2*/ <0.12169,0.46466,-0.02699>,<0.12308,0.46566,-0.02767>,<0.12425,0.46428,-0.0273>,
            <0.12286,0.46328,-0.02662>,
    /*3*/ <0.13555,0.48995,0.05201>,<0.13655,0.49069,0.0516>,<0.13737,0.48969,0.05179>,
            <0.13637,0.48895,0.05219>,
    /*4*/ <0.1424,0.49121,0.13578>,<0.14301,0.49168,0.13572>,<0.14348,0.49106,0.1357>,
            <0.14286,0.4906,0.13575>,
    /*5*/ <0.14787,0.4698,0.21693>,<0.14807,0.46994,0.21696>,<0.14821,0.46976,0.2169>,
            <0.14801,0.46962,0.21688>,
    /*6*/ <0.14804,0.46978,0.21692>

    /* stem 0c0.5*/ 
    /*0*/ <0.11622,0.4896,-0.11101>,
    /*1*/ <0.11667,0.48934,-0.11255>,<0.11537,0.4909,-0.11148>,<0.11576,0.48986,-0.10948>,
            <0.11706,0.4883,-0.11054>,
    /*2*/ <0.05136,0.44276,-0.12365>,<0.05035,0.44397,-0.12283>,<0.05066,0.44316,-0.12127>,
            <0.05166,0.44196,-0.1221>,
    /*3*/ <-0.00551,0.38568,-0.13151>,<-0.00635,0.38643,-0.13094>,<-0.00603,0.38595,-0.12982>,
            <-0.00519,0.38519,-0.13039>,
    /*4*/ <-0.04669,0.31594,-0.13225>,<-0.04727,0.31628,-0.13193>,<-0.04699,0.31611,-0.13126>,
            <-0.04641,0.31577,-0.13159>,
    /*5*/ <-0.06957,0.23855,-0.12552>,<-0.06977,0.23862,-0.12542>,<-0.06966,0.2386,-0.12521>,
            <-0.06947,0.23854,-0.12531>,
    /*6*/ <-0.06962,0.23858,-0.12537>

    /* stem 0c0.6*/ 
    /*0*/ <0.12834,0.56589,-0.1229>,
    /*1*/ <0.12965,0.56579,-0.1221>,<0.12911,0.5665,-0.12408>,<0.12704,0.56599,-0.1237>,
            <0.12757,0.56527,-0.12172>,
    /*2*/ <0.14149,0.4956,-0.15094>,<0.14108,0.49616,-0.15247>,<0.13947,0.49576,-0.15218>,
            <0.13988,0.49521,-0.15065>,
    /*3*/ <0.14559,0.42354,-0.17741>,<0.1453,0.42392,-0.1785>,<0.14414,0.42376,-0.17825>,
            <0.14443,0.42338,-0.17716>,
    /*4*/ <0.14017,0.3475,-0.1866>,<0.14,0.34759,-0.18728>,<0.13932,0.34762,-0.1871>,
            <0.13949,0.34753,-0.18642>,
    /*5*/ <0.12655,0.27209,-0.18154>,<0.12649,0.27209,-0.18175>,<0.12629,0.27213,-0.18169>,
            <0.12634,0.27213,-0.18148>,
    /*6*/ <0.12642,0.27211,-0.18161>

    /* stem 0c0.7*/ 
    /*0*/ <0.13937,0.6236,-0.13348>,
    /*1*/ <0.13813,0.62397,-0.13277>,<0.13894,0.6244,-0.13464>,<0.14061,0.62324,-0.13419>,
            <0.1398,0.6228,-0.13232>,
    /*2*/ <0.17213,0.68288,-0.10464>,<0.17276,0.68321,-0.10609>,<0.17405,0.68231,-0.10574>,
            <0.17342,0.68197,-0.10429>,
    /*3*/ <0.20666,0.74005,-0.07373>,<0.20712,0.74032,-0.07474>,<0.20803,0.73966,-0.0745>,
            <0.20756,0.73938,-0.07349>,
    /*4*/ <0.24618,0.7866,-0.0326>,<0.2465,0.78682,-0.03315>,<0.24698,0.78635,-0.03307>,
            <0.24666,0.78613,-0.03252>,
    /*5*/ <0.28772,0.82081,0.01762>,<0.28784,0.8209,0.01747>,<0.28796,0.82073,0.01748>,
            <0.28785,0.82065,0.01763>,
    /*6*/ <0.28784,0.82077,0.01755>

    /* stem 0c0.8*/ 
    /*0*/ <0.14814,0.66231,-0.14172>,
    /*1*/ <0.14741,0.6622,-0.14295>,<0.14889,0.66339,-0.14227>,<0.14887,0.66241,-0.1405>,
            <0.14738,0.66122,-0.14118>,
    /*2*/ <0.09916,0.70844,-0.11771>,<0.10031,0.70936,-0.11718>,<0.10029,0.7086,-0.11581>,
            <0.09914,0.70768,-0.11634>,
    /*3*/ <0.05077,0.75068,-0.08627>,<0.05159,0.75134,-0.08589>,<0.05165,0.75073,-0.08497>,
            <0.05084,0.75007,-0.08534>,
    /*4*/ <-0.00498,0.77696,-0.05018>,<-0.00459,0.77741,-0.04989>,<-0.00447,0.77699,-0.0494>,
            <-0.00486,0.77655,-0.04968>,
    /*5*/ <-0.06134,0.78354,-0.00673>,<-0.06124,0.78369,-0.00662>,<-0.06117,0.78355,-0.0065>,
            <-0.06126,0.7834,-0.0066>,
    /*6*/ <-0.06125,0.78354,-0.00661>

    /* stem 0c0.9*/ 
    /*0*/ <0.16134,0.71519,-0.15401>,
    /*1*/ <0.16259,0.71479,-0.1544>,<0.16189,0.71624,-0.15332>,<0.16009,0.71559,-0.15363>,
            <0.16079,0.71415,-0.15471>,
    /*2*/ <0.1577,0.75429,-0.21009>,<0.15716,0.75541,-0.20925>,<0.15577,0.75491,-0.20949>,
            <0.15631,0.75379,-0.21032>,
    /*3*/ <0.1496,0.78712,-0.26959>,<0.1492,0.78797,-0.26908>,<0.14822,0.78756,-0.26917>,
            <0.14862,0.78672,-0.26968>,
    /*4*/ <0.13374,0.80367,-0.3341>,<0.13349,0.80421,-0.3339>,<0.13293,0.80393,-0.33384>,
            <0.13318,0.80339,-0.33404>,
    /*5*/ <0.11754,0.80445,-0.40056>,<0.11746,0.80463,-0.40054>,<0.11729,0.80453,-0.4005>,
            <0.11738,0.80436,-0.40052>,
    /*6*/ <0.11742,0.80449,-0.40053>

    /* stem 0c0.10*/ 
    /*0*/ <0.17679,0.76889,-0.16769>,
    /*1*/ <0.17614,0.7694,-0.16667>,<0.1779,0.76941,-0.16724>,<0.17744,0.76838,-0.16871>,
            <0.17568,0.76837,-0.16814>,
    /*2*/ <0.18782,0.71499,-0.13238>,<0.18919,0.715,-0.13282>,<0.18882,0.7142,-0.13395>,
            <0.18746,0.71419,-0.13351>,
    /*3*/ <0.19733,0.65896,-0.10005>,<0.1983,0.65894,-0.10035>,<0.19804,0.65842,-0.10118>,
            <0.19707,0.65843,-0.10088>,
    /*4*/ <0.19075,0.59873,-0.07551>,<0.19133,0.59861,-0.07564>,<0.19117,0.59841,-0.07618>,
            <0.1906,0.59852,-0.07606>,
    /*5*/ <0.17045,0.53863,-0.05976>,<0.17062,0.53856,-0.05979>,<0.17058,0.53853,-0.05997>,
            <0.17041,0.53859,-0.05994>,
    /*6*/ <0.17052,0.53858,-0.05986>

    /* stem 0c0.11*/ 
    /*0*/ <0.18859,0.80361,-0.17759>,
    /*1*/ <0.1883,0.80336,-0.1788>,<0.18975,0.80398,-0.17795>,<0.18888,0.80385,-0.17638>,
            <0.18743,0.80323,-0.17723>,
    /*2*/ <0.16705,0.86267,-0.18532>,<0.16818,0.86315,-0.18466>,<0.16751,0.86305,-0.18345>,
            <0.16638,0.86257,-0.18411>,
    /*3*/ <0.14546,0.92219,-0.1883>,<0.14626,0.92251,-0.18783>,<0.14581,0.92239,-0.18697>,
            <0.145,0.92207,-0.18743>,
    /*4*/ <0.11145,0.97559,-0.18606>,<0.11189,0.97586,-0.18578>,<0.11167,0.97569,-0.18527>,
            <0.11123,0.97543,-0.18554>,
    /*5*/ <0.06206,1.01468,-0.17959>,<0.06216,1.0148,-0.1795>,<0.06212,1.01472,-0.17934>,
            <0.06202,1.0146,-0.17943>,
    /*6*/ <0.06209,1.0147,-0.17946>

    /* stem 0c0.12*/ 
    /*0*/ <0.19805,0.83144,-0.18553>,
    /*1*/ <0.19909,0.83128,-0.18488>,<0.19852,0.83247,-0.18601>,<0.19701,0.83161,-0.18617>,
            <0.19758,0.83041,-0.18504>,
    /*2*/ <0.22263,0.79847,-0.23154>,<0.22219,0.7994,-0.23242>,<0.22102,0.79873,-0.23254>,
            <0.22146,0.7978,-0.23166>,
    /*3*/ <0.24143,0.75737,-0.27355>,<0.24116,0.75796,-0.27426>,<0.24029,0.75756,-0.27426>,
            <0.24056,0.75696,-0.27355>,
    /*4*/ <0.25066,0.7066,-0.30744>,<0.25052,0.70689,-0.30791>,<0.24998,0.70674,-0.30784>,
            <0.25012,0.70645,-0.30737>,
    /*5*/ <0.2513,0.64891,-0.32932>,<0.25126,0.64896,-0.32948>,<0.25109,0.64895,-0.32945>,
            <0.25113,0.64889,-0.32929>,
    /*6*/ <0.25119,0.64893,-0.32938>

    /* stem 0c0.13*/ 
    /*0*/ <0.20953,0.86304,-0.19367>,
    /*1*/ <0.20866,0.86348,-0.19326>,<0.21013,0.86366,-0.19306>,<0.2104,0.8626,-0.19409>,
            <0.20892,0.86242,-0.19429>,
    /*2*/ <0.20847,0.82158,-0.15051>,<0.20961,0.82173,-0.15036>,<0.20982,0.82091,-0.15115>,
            <0.20868,0.82076,-0.1513>,
    /*3*/ <0.20695,0.77613,-0.11156>,<0.20776,0.77621,-0.11143>,<0.20791,0.77567,-0.11204>,
            <0.2071,0.77559,-0.11217>,
    /*4*/ <0.19514,0.72302,-0.08659>,<0.1956,0.72298,-0.08646>,<0.1957,0.72276,-0.08688>,
            <0.19524,0.7228,-0.08701>,
    /*5*/ <0.17853,0.66649,-0.07598>,<0.17867,0.66645,-0.07593>,<0.17871,0.66642,-0.07607>,
            <0.17857,0.66645,-0.07612>,
    /*6*/ <0.17862,0.66645,-0.07602>

    /* stem 0c0.14*/ 
    /*0*/ <0.23688,0.93214,-0.20887>,
    /*1*/ <0.23669,0.93207,-0.20952>,<0.23658,0.93275,-0.20885>,<0.23707,0.93221,-0.20822>,
            <0.23718,0.93153,-0.2089>,
    /*2*/ <0.18914,0.90807,-0.1929>,<0.18905,0.90859,-0.19238>,<0.18944,0.90817,-0.19189>,
            <0.18952,0.90764,-0.19242>,
    /*3*/ <0.14419,0.87916,-0.17687>,<0.1441,0.87951,-0.17649>,<0.1444,0.87923,-0.17615>,
            <0.14449,0.87887,-0.17654>,
    /*4*/ <0.10981,0.83933,-0.15821>,<0.10972,0.83952,-0.15797>,<0.10995,0.8394,-0.1578>,
            <0.11004,0.83921,-0.15804>,
    /*5*/ <0.08482,0.79127,-0.14488>,<0.08479,0.79131,-0.1448>,<0.08486,0.79128,-0.14475>,
            <0.0849,0.79124,-0.14483>,
    /*6*/ <0.08484,0.79128,-0.14481>

    /* stem 0c0.15*/ 
    /*0*/ <0.25366,0.96986,-0.21912>,
    /*1*/ <0.25408,0.96969,-0.21899>,<0.25386,0.97008,-0.21949>,<0.25324,0.97003,-0.21924>,
            <0.25346,0.96965,-0.21875>,
    /*2*/ <0.24541,0.9263,-0.24909>,<0.24523,0.9266,-0.24947>,<0.24476,0.92656,-0.24928>,
            <0.24493,0.92626,-0.2489>,
    /*3*/ <0.23327,0.88045,-0.27388>,<0.23314,0.88063,-0.27417>,<0.23281,0.88064,-0.27402>,
            <0.23294,0.88045,-0.27373>,
    /*4*/ <0.21636,0.83091,-0.28503>,<0.21627,0.83098,-0.28522>,<0.21609,0.83102,-0.28511>,
            <0.21617,0.83095,-0.28493>,
    /*5*/ <0.19522,0.78178,-0.28326>,<0.19519,0.78179,-0.28332>,<0.19514,0.78181,-0.28328>,
            <0.19517,0.7818,-0.28323>,
    /*6*/ <0.19518,0.7818,-0.28327>

    /* stem 0c0.16*/ 
    /*0*/ <0.28626,1.03428,-0.24078>,
    /*1*/ <0.28621,1.03433,-0.24072>,<0.28623,1.03433,-0.24085>,<0.28631,1.03424,-0.24084>,
            <0.28629,1.03423,-0.24071>,
    /*2*/ <0.32227,1.0674,-0.23333>,<0.32228,1.0674,-0.23343>,<0.32235,1.06733,-0.23342>,
            <0.32233,1.06733,-0.23332>,
    /*3*/ <0.35985,1.09766,-0.22232>,<0.35986,1.09766,-0.22239>,<0.35991,1.09761,-0.22239>,
            <0.35989,1.0976,-0.22232>,
    /*4*/ <0.39964,1.12038,-0.20364>,<0.39965,1.12039,-0.20368>,<0.39967,1.12035,-0.20368>,
            <0.39966,1.12034,-0.20364>,
    /*5*/ <0.43773,1.13101,-0.1739>,<0.43773,1.13102,-0.17391>,<0.43774,1.131,-0.17391>,
            <0.43773,1.131,-0.1739>,
    /*6*/ <0.43773,1.13101,-0.1739>

    /* stem 0c1*/ 
    /*0*/ <0,0.11335,0>,
    /*1*/ <-0.00057,0.11323,0.00507>,<-0.00468,0.11532,-0.00048>,<0.00057,0.11348,-0.00507>,
            <0.00468,0.11138,0.00048>,
    /*2*/ <0.04269,0.21778,0.01195>,<0.03904,0.21964,0.00702>,<0.04371,0.218,0.00294>,
            <0.04736,0.21614,0.00787>,
    /*3*/ <0.06727,0.32848,0.01489>,<0.06384,0.32937,0.01053>,<0.06812,0.32854,0.007>,
            <0.07154,0.32764,0.01135>,
    /*4*/ <0.07675,0.44125,0.01919>,<0.07376,0.44166,0.01545>,<0.0775,0.44148,0.01243>,
            <0.0805,0.44107,0.01617>,
    /*5*/ <0.07625,0.55468,0.01174>,<0.07375,0.55447,0.00862>,<0.07689,0.55434,0.00612>,
            <0.07938,0.55454,0.00925>,
    /*6*/ <0.07445,0.66748,-0.00039>,<0.07245,0.66719,-0.00287>,<0.07495,0.66703,-0.00487>,
            <0.07695,0.66732,-0.00238>,
    /*7*/ <0.08187,0.78004,-0.01156>,<0.08038,0.77996,-0.01344>,<0.08225,0.7797,-0.01492>,
            <0.08375,0.77978,-0.01304>,
    /*8*/ <0.09839,0.89193,-0.01831>,<0.0974,0.89201,-0.01957>,<0.09865,0.89177,-0.02055>,
            <0.09963,0.89169,-0.01929>,
    /*9*/ <0.12091,1.00277,-0.0262>,<0.12042,1.00282,-0.02684>,<0.12103,1.00267,-0.02733>,
            <0.12152,1.00261,-0.02669>,
    /*10*/ <0.15721,1.10986,-0.03424>

    /* stem 0c1.0*/ 
    /*0*/ <0.05054,0.25103,0.0085>,
    /*1*/ <0.05136,0.2508,0.0102>,<0.04947,0.25244,0.0092>,<0.04972,0.25127,0.00679>,
            <0.05161,0.24962,0.00779>,
    /*2*/ <0.11858,0.31377,-0.01382>,<0.11712,0.31505,-0.01459>,<0.11731,0.31414,-0.01646>,
            <0.11877,0.31286,-0.01569>,
    /*3*/ <0.1902,0.3704,-0.04074>,<0.18923,0.37136,-0.04131>,<0.18931,0.37066,-0.04261>,
            <0.19027,0.36969,-0.04204>,
    /*4*/ <0.26808,0.41254,-0.07575>,<0.26759,0.41316,-0.07611>,<0.26752,0.41268,-0.07684>,
            <0.26802,0.41206,-0.07647>,
    /*5*/ <0.35482,0.42574,-0.11258>,<0.35473,0.42595,-0.11272>,<0.35467,0.42579,-0.11293>,
            <0.35476,0.42558,-0.11279>,
    /*6*/ <0.35474,0.42576,-0.11276>

    /* stem 0c1.1*/ 
    /*0*/ <0.06442,0.31371,0.01048>,
    /*1*/ <0.06268,0.31411,0.01004>,<0.06479,0.3155,0.01061>,<0.06615,0.31331,0.01091>,
            <0.06404,0.31192,0.01034>,
    /*2*/ <0.0403,0.3122,0.099>,<0.04194,0.31328,0.09945>,<0.04299,0.31159,0.09968>,
            <0.04135,0.31051,0.09924>,
    /*3*/ <0.01717,0.30486,0.1875>,<0.01832,0.30562,0.18787>,<0.01908,0.30442,0.18797>,
            <0.01793,0.30366,0.1876>,
    /*4*/ <-0.01246,0.27538,0.26915>,<-0.01183,0.27579,0.26953>,<-0.01134,0.2751,0.26946>,
            <-0.01197,0.27469,0.26908>,
    /*5*/ <-0.04404,0.22378,0.33814>,<-0.04386,0.22389,0.3383>,<-0.04369,0.2237,0.33823>,
            <-0.04387,0.22359,0.33808>,
    /*6*/ <-0.04386,0.22374,0.33819>

    /* stem 0c1.2*/ 
    /*0*/ <0.06945,0.34953,0.01185>,
    /*1*/ <0.07031,0.34952,0.01027>,<0.06839,0.35085,0.01127>,<0.06859,0.34953,0.01343>,
            <0.07051,0.3482,0.01243>,
    /*2*/ <0.01172,0.28899,-0.02089>,<0.01024,0.29002,-0.02011>,<0.0104,0.289,-0.01844>,
            <0.01188,0.28796,-0.01921>,
    /*3*/ <-0.042,0.22291,-0.04942>,<-0.04311,0.22358,-0.0489>,<-0.04295,0.22292,-0.04768>,
            <-0.04184,0.22225,-0.0482>,
    /*4*/ <-0.07909,0.14504,-0.07428>,<-0.07983,0.14531,-0.07402>,<-0.07967,0.14499,-0.07327>,
            <-0.07894,0.14473,-0.07354>,
    /*5*/ <-0.09928,0.05882,-0.08929>,<-0.09952,0.05886,-0.08922>,<-0.09946,0.05881,-0.08898>,
            <-0.09922,0.05876,-0.08905>,
    /*6*/ <-0.09937,0.05881,-0.08914>

    /* stem 0c1.3*/ 
    /*0*/ <0.07485,0.41406,0.01463>,
    /*1*/ <0.07617,0.41391,0.01573>,<0.0745,0.41563,0.01527>,<0.07352,0.41422,0.01354>,
            <0.07519,0.4125,0.014>,
    /*2*/ <0.12849,0.44929,-0.04315>,<0.1272,0.45063,-0.0435>,<0.12643,0.44954,-0.04485>,
            <0.12773,0.4482,-0.04449>,
    /*3*/ <0.17975,0.47424,-0.10808>,<0.17889,0.47522,-0.10839>,<0.17824,0.47439,-0.10922>,
            <0.17911,0.47341,-0.10891>,
    /*4*/ <0.2314,0.47762,-0.1772>,<0.23098,0.47822,-0.17749>,<0.23051,0.47771,-0.17787>,
            <0.23093,0.47711,-0.17758>,
    /*5*/ <0.27917,0.45189,-0.24437>,<0.27908,0.45207,-0.24451>,<0.2789,0.45192,-0.24458>,
            <0.27899,0.45174,-0.24444>,
    /*6*/ <0.27903,0.45191,-0.24448>

    /* stem 0c1.4*/ 
    /*0*/ <0.07697,0.47338,0.01387>,
    /*1*/ <0.07581,0.47345,0.01505>,<0.07626,0.47467,0.0131>,<0.07813,0.47331,0.01268>,
            <0.07768,0.47209,0.01463>,
    /*2*/ <0.12378,0.5257,0.05847>,<0.12413,0.52665,0.05695>,<0.12558,0.52559,0.05663>,
            <0.12523,0.52464,0.05814>,
    /*3*/ <0.17655,0.57312,0.10196>,<0.17681,0.57381,0.1009>,<0.17778,0.57301,0.10061>,
            <0.17752,0.57232,0.10168>,
    /*4*/ <0.23495,0.59849,0.15543>,<0.23523,0.59897,0.15491>,<0.2357,0.59843,0.15465>,
            <0.23543,0.59794,0.15518>,
    /*5*/ <0.29503,0.59683,0.21291>,<0.29516,0.59699,0.21279>,<0.29526,0.59681,0.21267>,
            <0.29514,0.59666,0.2128>,
    /*6*/ <0.29515,0.59682,0.21279>

    /* stem 0c1.5*/ 
    /*0*/ <0.07673,0.52133,0.01095>,
    /*1*/ <0.07592,0.52124,0.00956>,<0.07694,0.52291,0.01072>,<0.07754,0.52142,0.01234>,
            <0.07652,0.51975,0.01117>,
    /*2*/ <0.00729,0.53611,0.04912>,<0.00809,0.53741,0.05002>,<0.00855,0.53625,0.05127>,
            <0.00776,0.53496,0.05037>,
    /*3*/ <-0.06435,0.54426,0.08495>,<-0.0639,0.5452,0.08565>,<-0.06356,0.54437,0.08653>,
            <-0.06401,0.54344,0.08583>,
    /*4*/ <-0.13536,0.52994,0.12025>,<-0.13523,0.53048,0.12073>,<-0.13491,0.53,0.12119>,
            <-0.13504,0.52945,0.12071>,
    /*5*/ <-0.19765,0.49478,0.15746>,<-0.19764,0.49494,0.15762>,<-0.19749,0.49481,0.15774>,
            <-0.1975,0.49465,0.15758>,
    /*6*/ <-0.19757,0.49479,0.1576>

    /* stem 0c1.6*/ 
    /*0*/ <0.0763,0.57059,0.00728>,
    /*1*/ <0.07784,0.57064,0.00751>,<0.0761,0.57161,0.00845>,<0.07476,0.57054,0.00706>,
            <0.0765,0.56957,0.00612>,
    /*2*/ <0.08303,0.62958,-0.04325>,<0.08168,0.63033,-0.04252>,<0.08064,0.6295,-0.0436>,
            <0.08199,0.62875,-0.04432>,
    /*3*/ <0.08861,0.68058,-0.10196>,<0.08766,0.68119,-0.10153>,<0.08691,0.68051,-0.10219>,
            <0.08787,0.67989,-0.10263>,
    /*4*/ <0.09534,0.71531,-0.17144>,<0.09479,0.71574,-0.17128>,<0.09433,0.71526,-0.17157>,
            <0.09488,0.71483,-0.17172>,
    /*5*/ <0.09932,0.73168,-0.24758>,<0.09915,0.73183,-0.24756>,<0.09901,0.73167,-0.2476>,
            <0.09918,0.73152,-0.24762>,
    /*6*/ <0.09916,0.73168,-0.24759>

    /* stem 0c1.7*/ 
    /*0*/ <0.07525,0.63387,0.0008>,
    /*1*/ <0.07478,0.634,0.0022>,<0.07493,0.6353,0.00055>,<0.07572,0.63373,-0.00061>,
            <0.07557,0.63243,0.00104>,
    /*2*/ <0.14381,0.6531,0.02292>,<0.14392,0.6541,0.02164>,<0.14453,0.65289,0.02074>,
            <0.14442,0.65188,0.02202>,
    /*3*/ <0.21417,0.66749,0.04299>,<0.21429,0.66821,0.04209>,<0.21466,0.66734,0.04143>,
            <0.21454,0.66661,0.04233>,
    /*4*/ <0.28477,0.65665,0.06438>,<0.28499,0.65708,0.0639>,<0.28505,0.65656,0.06346>,
            <0.28483,0.65613,0.06394>,
    /*5*/ <0.34973,0.62926,0.08859>,<0.34983,0.62938,0.08845>,<0.34982,0.62923,0.08831>,
            <0.34972,0.62911,0.08845>,
    /*6*/ <0.34978,0.62925,0.08845>

    /* stem 0c1.8*/ 
    /*0*/ <0.07582,0.68443,-0.00425>,
    /*1*/ <0.07509,0.68436,-0.00548>,<0.07601,0.68584,-0.00443>,<0.07655,0.6845,-0.00301>,
            <0.07564,0.68302,-0.00406>,
    /*2*/ <0.01408,0.6971,0.03023>,<0.01479,0.69825,0.03104>,<0.01521,0.69721,0.03214>,
            <0.0145,0.69606,0.03133>,
    /*3*/ <-0.04491,0.70497,0.07058>,<-0.04441,0.70579,0.07116>,<-0.04402,0.70504,0.07188>,
            <-0.04452,0.70422,0.07131>,
    /*4*/ <-0.1033,0.69305,0.11067>,<-0.10312,0.69353,0.11109>,<-0.10278,0.69309,0.11145>,
            <-0.10297,0.69261,0.11103>,
    /*5*/ <-0.15755,0.66692,0.14985>,<-0.15752,0.66706,0.14999>,<-0.15739,0.66694,0.15009>,
            <-0.15742,0.6668,0.14994>,
    /*6*/ <-0.15747,0.66693,0.14997>

    /* stem 0c1.9*/ 
    /*0*/ <0.08018,0.75111,-0.01053>,
    /*1*/ <0.08139,0.75098,-0.01115>,<0.08048,0.75241,-0.01024>,<0.07897,0.75125,-0.00991>,
            <0.07988,0.74982,-0.01083>,
    /*2*/ <0.05316,0.77082,-0.07002>,<0.05245,0.77194,-0.06932>,<0.05129,0.77104,-0.06906>,
            <0.05199,0.76992,-0.06977>,
    /*3*/ <0.02434,0.78489,-0.13025>,<0.0238,0.7857,-0.12981>,<0.023,0.78505,-0.12958>,
            <0.02353,0.78424,-0.13002>,
    /*4*/ <-0.00603,0.78218,-0.19129>,<-0.00639,0.78266,-0.19113>,<-0.00682,0.78227,-0.19091>,
            <-0.00646,0.78178,-0.19106>,
    /*5*/ <-0.03572,0.75715,-0.2474>,<-0.03585,0.75729,-0.2474>,<-0.03596,0.75718,-0.24729>,
            <-0.03583,0.75704,-0.24729>,
    /*6*/ <-0.03584,0.75716,-0.24735>

    /* stem 0c1.10*/ 
    /*0*/ <0.08797,0.82006,-0.01546>,
    /*1*/ <0.08756,0.82019,-0.01425>,<0.08902,0.82075,-0.01518>,<0.08838,0.81994,-0.01668>,
            <0.08691,0.81938,-0.01575>,
    /*2*/ <0.11867,0.76595,0.00165>,<0.11981,0.76639,0.00092>,<0.11931,0.76575,-0.00024>,
            <0.11817,0.76532,0.00048>,
    /*3*/ <0.14303,0.70815,0.01667>,<0.14388,0.70837,0.01618>,<0.14349,0.70799,0.01533>,
            <0.14265,0.70776,0.01582>,
    /*4*/ <0.15383,0.64577,0.02901>,<0.15435,0.6458,0.02874>,<0.1541,0.64565,0.02823>,
            <0.15357,0.64562,0.0285>,
    /*5*/ <0.14743,0.5817,0.03333>,<0.14759,0.58168,0.03325>,<0.14751,0.58167,0.03309>,
            <0.14735,0.5817,0.03317>,
    /*6*/ <0.14747,0.58169,0.03321>

    /* stem 0c1.11*/ 
    /*0*/ <0.09344,0.85733,-0.01752>,
    /*1*/ <0.0931,0.85731,-0.01873>,<0.09291,0.85845,-0.01738>,<0.09379,0.85735,-0.01632>,
            <0.09398,0.85621,-0.01766>,
    /*2*/ <0.03946,0.82948,-0.00278>,<0.03931,0.83036,-0.00174>,<0.03999,0.82951,-0.00091>,
            <0.04015,0.82863,-0.00195>,
    /*3*/ <-0.01181,0.79696,0.01201>,<-0.01197,0.79755,0.01277>,<-0.01144,0.79697,0.01334>,
            <-0.01128,0.79637,0.01258>,
    /*4*/ <-0.05336,0.75235,0.02586>,<-0.05352,0.75264,0.02633>,<-0.05313,0.75237,0.02664>,
            <-0.05296,0.75207,0.02618>,
    /*5*/ <-0.07857,0.69654,0.03844>,<-0.07864,0.6966,0.03859>,<-0.0785,0.69655,0.03867>,
            <-0.07843,0.69649,0.03852>,
    /*6*/ <-0.07853,0.69654,0.03855>

    /* stem 0c1.12*/ 
    /*0*/ <0.10606,0.9291,-0.0219>,
    /*1*/ <0.10691,0.92896,-0.0215>,<0.10606,0.92998,-0.02156>,<0.10522,0.92925,-0.02229>,
            <0.10606,0.92822,-0.02223>,
    /*2*/ <0.13274,0.94752,-0.07071>,<0.13208,0.94832,-0.07075>,<0.13143,0.94775,-0.07132>,
            <0.13209,0.94695,-0.07127>,
    /*3*/ <0.15674,0.96299,-0.1219>,<0.15628,0.96356,-0.12194>,<0.1558,0.96314,-0.1223>,
            <0.15625,0.96257,-0.12225>,
    /*4*/ <0.17918,0.96377,-0.17602>,<0.17894,0.96412,-0.17612>,<0.17862,0.96386,-0.17626>,
            <0.17886,0.96352,-0.17616>,
    /*5*/ <0.20094,0.94633,-0.22753>,<0.20088,0.94643,-0.22759>,<0.20077,0.94635,-0.22761>,
            <0.20083,0.94625,-0.22755>,
    /*6*/ <0.20086,0.94634,-0.22757>

    /* stem 0c1.13*/ 
    /*0*/ <0.11607,0.97853,-0.02516>,
    /*1*/ <0.11574,0.97863,-0.02457>,<0.11626,0.97919,-0.02518>,<0.1164,0.97842,-0.02576>,
            <0.11589,0.97786,-0.02515>,
    /*2*/ <0.1626,0.96628,0.00328>,<0.163,0.96671,0.00281>,<0.16311,0.96612,0.00236>,
            <0.16271,0.96568,0.00283>,
    /*3*/ <0.20869,0.94834,0.02935>,<0.20899,0.94864,0.02903>,<0.20903,0.94823,0.02868>,
            <0.20872,0.94793,0.02901>,
    /*4*/ <0.24816,0.9175,0.05414>,<0.24838,0.91765,0.05398>,<0.24836,0.91744,0.05375>,
            <0.24814,0.91728,0.05391>,
    /*5*/ <0.27493,0.8728,0.07437>,<0.27501,0.87283,0.07432>,<0.27499,0.87278,0.07424>,
            <0.27491,0.87275,0.07428>,
    /*6*/ <0.27496,0.87279,0.0743>

    /* stem 0c1.14*/ 
    /*0*/ <0.13012,1.02978,-0.02865>,
    /*1*/ <0.13003,1.02978,-0.02907>,<0.13005,1.03019,-0.02863>,<0.13022,1.02977,-0.02824>,
            <0.1302,1.02936,-0.02867>,
    /*2*/ <0.07924,1.01993,-0.01739>,<0.07925,1.02025,-0.01706>,<0.07939,1.01993,-0.01675>,
            <0.07937,1.01961,-0.01709>,
    /*3*/ <0.0295,1.0061,-0.00525>,<0.02949,1.00632,-0.00501>,<0.02961,1.0061,-0.00479>,
            <0.02961,1.00587,-0.00504>,
    /*4*/ <-0.0159,0.98049,0.00453>,<-0.01593,0.98061,0.00468>,<-0.01584,0.98049,0.00479>,
            <-0.01581,0.98037,0.00464>,
    /*5*/ <-0.05258,0.94309,0.01279>,<-0.0526,0.94312,0.01284>,<-0.05256,0.94309,0.01287>,
            <-0.05254,0.94306,0.01283>,
    /*6*/ <-0.05257,0.94309,0.01283>

    /* stem 0c1.15*/ 
    /*0*/ <0.15062,1.09037,-0.03288>,
    /*1*/ <0.15071,1.09034,-0.03285>,<0.15062,1.09044,-0.0328>,<0.15052,1.0904,-0.03291>,
            <0.15062,1.09031,-0.03296>,
    /*2*/ <0.17,1.12559,-0.06195>,<0.16993,1.12566,-0.06191>,<0.16986,1.12563,-0.06199>,
            <0.16993,1.12556,-0.06203>,
    /*3*/ <0.18965,1.15619,-0.09569>,<0.1896,1.15625,-0.09566>,<0.18954,1.15622,-0.09572>,
            <0.18959,1.15616,-0.09574>,
    /*4*/ <0.20797,1.18013,-0.13509>,<0.20794,1.18016,-0.13508>,<0.2079,1.18015,-0.1351>,
            <0.20793,1.18011,-0.13511>,
    /*5*/ <0.22565,1.19265,-0.17971>,<0.22564,1.19267,-0.17971>,<0.22563,1.19266,-0.17971>,
            <0.22564,1.19265,-0.17971>,
    /*6*/ <0.22564,1.19266,-0.17971>

    /* stem 0c2*/ 
    /*0*/ <0,0.11335,0>,
    /*1*/ <-0.00257,0.11367,0.0044>,<-0.00402,0.11528,-0.00248>,<0.00257,0.11304,-0.0044>,
            <0.00402,0.11142,0.00248>,
    /*2*/ <0.03806,0.21833,0.02002>,<0.03677,0.21977,0.01391>,<0.04262,0.21778,0.0122>,
            <0.04391,0.21634,0.01832>,
    /*3*/ <0.07004,0.32661,0.03019>,<0.06879,0.32751,0.02479>,<0.07403,0.32612,0.02335>,
            <0.07528,0.32522,0.02874>,
    /*4*/ <0.09227,0.43781,0.03222>,<0.0911,0.43815,0.02757>,<0.09567,0.43728,0.02636>,
            <0.09684,0.43694,0.03101>,
    /*5*/ <0.10592,0.5501,0.02256>,<0.10488,0.54991,0.0187>,<0.10872,0.54937,0.01769>,
            <0.10976,0.54956,0.02155>,
    /*6*/ <0.13596,0.6594,0.02293>,<0.1352,0.65963,0.01983>,<0.1382,0.65882,0.01904>,
            <0.13895,0.65859,0.02214>,
    /*7*/ <0.17149,0.76701,0.02593>,<0.17095,0.76727,0.02361>,<0.17316,0.76656,0.02301>,
            <0.17371,0.76631,0.02534>,
    /*8*/ <0.21583,0.87134,0.02963>,<0.21548,0.87155,0.02808>,<0.21691,0.87096,0.02767>,
            <0.21726,0.87075,0.02922>,
    /*9*/ <0.26007,0.97535,0.03774>,<0.25991,0.97548,0.03697>,<0.26063,0.97519,0.03677>,
            <0.26079,0.97506,0.03754>,
    /*10*/ <0.31603,1.07313,0.05039>

    /* stem 0c2.0*/ 
    /*0*/ <0.04565,0.2362,0.0179>,
    /*1*/ <0.04721,0.23565,0.01887>,<0.04671,0.23747,0.01692>,<0.04409,0.23675,0.01693>,
            <0.0446,0.23493,0.01887>,
    /*2*/ <0.06492,0.16942,-0.04832>,<0.06452,0.17083,-0.04983>,<0.06249,0.17027,-0.04982>,
            <0.06289,0.16886,-0.04832>,
    /*3*/ <0.07403,0.09999,-0.1141>,<0.07375,0.10097,-0.11519>,<0.07229,0.10068,-0.11509>,
            <0.07256,0.09969,-0.114>,
    /*4*/ <0.06964,0.01513,-0.15868>,<0.06948,0.01554,-0.15944>,<0.06861,0.0155,-0.15928>,
            <0.06877,0.01509,-0.15852>,
    /*5*/ <0.04534,-0.07489,-0.18159>,<0.04529,-0.07481,-0.18184>,<0.04503,-0.07476,-0.18177>,
            <0.04508,-0.07484,-0.18152>,
    /*6*/ <0.04518,-0.07483,-0.18168>

    /* stem 0c2.1*/ 
    /*0*/ <0.06727,0.3101,0.02517>,
    /*1*/ <0.06626,0.31025,0.02669>,<0.06859,0.31113,0.02594>,<0.06829,0.30995,0.02365>,
            <0.06596,0.30907,0.02439>,
    /*2*/ <0.10599,0.23443,0.06002>,<0.1078,0.23512,0.05944>,<0.10757,0.23421,0.05766>,
            <0.10577,0.23352,0.05824>,
    /*3*/ <0.13936,0.15572,0.09346>,<0.14068,0.15611,0.09309>,<0.1405,0.15549,0.09181>,
            <0.13918,0.1551,0.09219>,
    /*4*/ <0.15253,0.06762,0.11583>,<0.15335,0.0677,0.11566>,<0.1532,0.06747,0.11486>,
            <0.15238,0.06739,0.11503>,
    /*5*/ <0.14596,-0.02301,0.12912>,<0.14622,-0.02303,0.12907>,<0.14617,-0.02307,0.12882>,
            <0.14591,-0.02304,0.12886>,
    /*6*/ <0.14606,-0.02304,0.12897>

    /* stem 0c2.2*/ 
    /*0*/ <0.07465,0.33961,0.02707>,
    /*1*/ <0.07473,0.33963,0.02527>,<0.07426,0.34137,0.02708>,<0.07457,0.33958,0.02887>,
            <0.07503,0.33785,0.02706>,
    /*2*/ <-0.01333,0.32036,0.02149>,<-0.01369,0.32171,0.02289>,<-0.01346,0.32033,0.02428>,
            <-0.0131,0.31898,0.02288>,
    /*3*/ <-0.0992,0.29453,0.01234>,<-0.09959,0.29545,0.01332>,<-0.09941,0.29446,0.01431>,
            <-0.09902,0.29355,0.01332>,
    /*4*/ <-0.17519,0.24708,0.00176>,<-0.17557,0.24756,0.00233>,<-0.17533,0.24703,0.00293>,
            <-0.17495,0.24656,0.00236>,
    /*5*/ <-0.23652,0.18124,-0.00513>,<-0.23667,0.18136,-0.00496>,<-0.23655,0.18124,-0.00477>,
            <-0.23641,0.18112,-0.00494>,
    /*6*/ <-0.23654,0.18124,-0.00495>

    /* stem 0c2.3*/ 
    /*0*/ <0.08417,0.38789,0.02816>,
    /*1*/ <0.08544,0.38762,0.02934>,<0.08503,0.3893,0.02758>,<0.08291,0.38817,0.02699>,
            <0.08332,0.38648,0.02875>,
    /*2*/ <0.12805,0.3378,-0.02874>,<0.12773,0.3391,-0.03011>,<0.12609,0.33822,-0.03057>,
            <0.12641,0.33691,-0.0292>,
    /*3*/ <0.1691,0.28799,-0.088>,<0.16887,0.28893,-0.08896>,<0.16769,0.28832,-0.08927>,
            <0.16792,0.28738,-0.08831>,
    /*4*/ <0.19926,0.21873,-0.13222>,<0.19921,0.21914,-0.13291>,<0.19845,0.21887,-0.13301>,
            <0.19851,0.21846,-0.13232>,
    /*5*/ <0.21915,0.1377,-0.15874>,<0.21915,0.13777,-0.15897>,<0.21891,0.13772,-0.15899>,
            <0.21891,0.13764,-0.15875>,
    /*6*/ <0.21903,0.13771,-0.15886>

    /* stem 0c2.4*/ 
    /*0*/ <0.08967,0.41576,0.0288>,
    /*1*/ <0.08804,0.41608,0.02922>,<0.08965,0.41711,0.02772>,<0.09131,0.41545,0.02837>,
            <0.08969,0.41441,0.02987>,
    /*2*/ <0.11483,0.46725,0.09302>,<0.11609,0.46805,0.09186>,<0.11737,0.46677,0.09236>,
            <0.11612,0.46596,0.09353>,
    /*3*/ <0.14202,0.5105,0.1623>,<0.14294,0.51113,0.16156>,<0.14382,0.51015,0.16183>,
            <0.1429,0.50953,0.16257>,
    /*4*/ <0.16813,0.53715,0.23987>,<0.16872,0.53757,0.23953>,<0.1692,0.53695,0.23958>,
            <0.16862,0.53653,0.23992>,
    /*5*/ <0.193,0.54437,0.32196>,<0.19319,0.5445,0.32189>,<0.19332,0.5443,0.32187>,
            <0.19313,0.54417,0.32194>,
    /*6*/ <0.19316,0.54433,0.32191>

    /* stem 0c2.5*/ 
    /*0*/ <0.09693,0.46237,0.02726>,
    /*1*/ <0.09743,0.46218,0.02568>,<0.09624,0.46384,0.02687>,<0.09642,0.46256,0.02884>,
            <0.09761,0.4609,0.02765>,
    /*2*/ <0.02536,0.42387,0.00784>,<0.02444,0.42516,0.00876>,<0.02459,0.42416,0.01029>,
            <0.02551,0.42287,0.00937>,
    /*3*/ <-0.04264,0.37921,-0.01094>,<-0.04339,0.38007,-0.01031>,<-0.04324,0.37939,-0.00921>,
            <-0.0425,0.37853,-0.00985>,
    /*4*/ <-0.0996,0.31991,-0.02563>,<-0.10014,0.32034,-0.02529>,<-0.09997,0.32001,-0.02462>,
            <-0.09943,0.31958,-0.02496>,
    /*5*/ <-0.14648,0.25106,-0.03224>,<-0.14667,0.25117,-0.03214>,<-0.14659,0.2511,-0.03193>,
            <-0.14641,0.25099,-0.03203>,
    /*6*/ <-0.14654,0.25108,-0.03209>

    /* stem 0c2.6*/ 
    /*0*/ <0.10494,0.52977,0.02176>,
    /*1*/ <0.10557,0.52981,0.02322>,<0.1056,0.53118,0.02143>,<0.10431,0.52972,0.02029>,
            <0.10428,0.52835,0.02208>,
    /*2*/ <0.17094,0.49293,-0.00419>,<0.17096,0.49399,-0.00558>,<0.16996,0.49286,-0.00646>,
            <0.16993,0.4918,-0.00507>,
    /*3*/ <0.22979,0.44629,-0.03159>,<0.22988,0.447,-0.03261>,<0.22905,0.44627,-0.03319>,
            <0.22896,0.44557,-0.03217>,
    /*4*/ <0.27646,0.38486,-0.05234>,<0.27661,0.38518,-0.05298>,<0.27603,0.38484,-0.05328>,
            <0.27589,0.38452,-0.05264>,
    /*5*/ <0.3078,0.31225,-0.06366>,<0.30787,0.31231,-0.06386>,<0.30767,0.31224,-0.06395>,
            <0.30761,0.31218,-0.06374>,
    /*6*/ <0.30774,0.31225,-0.0638>

    /* stem 0c2.7*/ 
    /*0*/ <0.11557,0.58006,0.02036>,
    /*1*/ <0.11417,0.58043,0.02091>,<0.11613,0.58139,0.02089>,<0.11696,0.57968,0.01982>,
            <0.115,0.57872,0.01983>,
    /*2*/ <0.13144,0.54641,0.08795>,<0.13296,0.54716,0.08794>,<0.1336,0.54583,0.08711>,
            <0.13208,0.54509,0.08712>,
    /*3*/ <0.14741,0.50484,0.15097>,<0.14851,0.50533,0.15103>,<0.14894,0.50445,0.15034>,
            <0.14785,0.50396,0.15028>,
    /*4*/ <0.15713,0.44532,0.19914>,<0.1578,0.44553,0.19926>,<0.15803,0.44513,0.19873>,
            <0.15736,0.44492,0.1986>,
    /*5*/ <0.15825,0.37574,0.23244>,<0.15846,0.37578,0.2325>,<0.15853,0.37569,0.23231>,
            <0.15832,0.37565,0.23225>,
    /*6*/ <0.15839,0.37571,0.23237>

    /* stem 0c2.8*/ 
    /*0*/ <0.12648,0.62017,0.02068>,
    /*1*/ <0.12725,0.61997,0.01941>,<0.12631,0.62162,0.02035>,<0.12572,0.62037,0.02195>,
            <0.12666,0.61872,0.02101>,
    /*2*/ <0.06329,0.6042,-0.01626>,<0.06256,0.60548,-0.01553>,<0.0621,0.60451,-0.01429>,
            <0.06283,0.60323,-0.01502>,
    /*3*/ <0.00051,0.58153,-0.05028>,<-0.00007,0.58241,-0.0498>,<-0.00033,0.58174,-0.04888>,
            <0.00025,0.58086,-0.04936>,
    /*4*/ <-0.05348,0.54081,-0.08239>,<-0.05395,0.54126,-0.08217>,<-0.05403,0.5409,-0.08159>,
            <-0.05356,0.54045,-0.0818>,
    /*5*/ <-0.09683,0.48349,-0.10356>,<-0.097,0.4836,-0.10351>,<-0.097,0.48352,-0.10331>,
            <-0.09682,0.48341,-0.10336>,
    /*6*/ <-0.09691,0.4835,-0.10343>

    /* stem 0c2.9*/ 
    /*0*/ <0.14346,0.67861,0.02162>,
    /*1*/ <0.14439,0.67827,0.02265>,<0.14422,0.67978,0.02131>,<0.14252,0.67895,0.02058>,
            <0.1427,0.67743,0.02192>,
    /*2*/ <0.18291,0.64106,-0.02497>,<0.18277,0.64224,-0.02601>,<0.18146,0.64159,-0.02657>,
            <0.18159,0.64041,-0.02554>,
    /*3*/ <0.21461,0.59915,-0.07378>,<0.21453,0.59996,-0.07454>,<0.21354,0.59958,-0.07486>,
            <0.21361,0.59876,-0.0741>,
    /*4*/ <0.23306,0.54097,-0.11127>,<0.23307,0.54133,-0.11182>,<0.23244,0.54119,-0.11193>,
            <0.23242,0.54084,-0.11137>,
    /*5*/ <0.23475,0.47398,-0.13665>,<0.23477,0.47405,-0.13684>,<0.23456,0.47405,-0.13685>,
            <0.23455,0.47398,-0.13666>,
    /*6*/ <0.23466,0.47401,-0.13675>

    /* stem 0c2.10*/ 
    /*0*/ <0.15994,0.72895,0.02325>,
    /*1*/ <0.15868,0.72938,0.02289>,<0.16045,0.73019,0.02293>,<0.1612,0.72853,0.0236>,
            <0.15943,0.72771,0.02356>,
    /*2*/ <0.14774,0.7503,0.08754>,<0.14911,0.75093,0.08757>,<0.14969,0.74964,0.08809>,
            <0.14833,0.74901,0.08806>,
    /*3*/ <0.13631,0.76643,0.15348>,<0.13727,0.76689,0.15354>,<0.1377,0.76596,0.15385>,
            <0.13673,0.7655,0.15379>,
    /*4*/ <0.1198,0.76846,0.22027>,<0.12035,0.76875,0.22039>,<0.12062,0.76818,0.22048>,
            <0.12007,0.7679,0.22035>,
    /*5*/ <0.09775,0.75486,0.28402>,<0.09791,0.75495,0.28409>,<0.098,0.75478,0.28409>,
            <0.09784,0.75469,0.28402>,
    /*6*/ <0.09787,0.75482,0.28405>

    /* stem 0c2.11*/ 
    /*0*/ <0.18667,0.80076,0.02583>,
    /*1*/ <0.1871,0.80063,0.02462>,<0.18678,0.80205,0.02573>,<0.18623,0.8009,0.02704>,
            <0.18655,0.79948,0.02594>,
    /*2*/ <0.1264,0.80425,0.00248>,<0.12615,0.80535,0.00334>,<0.12572,0.80446,0.00436>,
            <0.12597,0.80336,0.0035>,
    /*3*/ <0.06609,0.79983,-0.0205>,<0.06581,0.80061,-0.01993>,<0.06557,0.79998,-0.01918>,
            <0.06584,0.7992,-0.01975>,
    /*4*/ <0.01007,0.77565,-0.04201>,<0.00978,0.77607,-0.04172>,<0.00974,0.77572,-0.04124>,
            <0.01004,0.7753,-0.04153>,
    /*5*/ <-0.03899,0.73539,-0.0548>,<-0.03911,0.7355,-0.05472>,<-0.03908,0.73542,-0.05456>,
            <-0.03897,0.7353,-0.05464>,
    /*6*/ <-0.03904,0.7354,-0.05468>

    /* stem 0c2.12*/ 
    /*0*/ <0.20226,0.83773,0.02731>,
    /*1*/ <0.2026,0.83754,0.0285>,<0.2023,0.83896,0.0275>,<0.20193,0.83791,0.02612>,
            <0.20223,0.83649,0.02713>,
    /*2*/ <0.26279,0.83839,0.01142>,<0.26256,0.83949,0.01064>,<0.26227,0.83868,0.00958>,
            <0.2625,0.83757,0.01036>,
    /*3*/ <0.32263,0.83352,-0.00619>,<0.32253,0.8343,-0.00676>,<0.32227,0.83373,-0.0075>,
            <0.32237,0.83294,-0.00693>,
    /*4*/ <0.37807,0.81245,-0.02617>,<0.3781,0.81289,-0.02654>,<0.37784,0.81257,-0.02694>,
            <0.3778,0.81213,-0.02658>,
    /*5*/ <0.42741,0.78004,-0.04693>,<0.42744,0.78016,-0.04705>,<0.42733,0.78008,-0.04717>,
            <0.4273,0.77995,-0.04704>,
    /*6*/ <0.42737,0.78006,-0.04705>

    /* stem 0c2.13*/ 
    /*0*/ <0.22806,0.89883,0.03094>,
    /*1*/ <0.2272,0.89922,0.03066>,<0.22807,0.89942,0.03173>,<0.22892,0.89844,0.03121>,
            <0.22805,0.89824,0.03015>,
    /*2*/ <0.19894,0.85783,0.06183>,<0.19961,0.85798,0.06265>,<0.20027,0.85723,0.06226>,
            <0.1996,0.85707,0.06143>,
    /*3*/ <0.17293,0.81281,0.08982>,<0.1734,0.8129,0.09042>,<0.1739,0.81241,0.0901>,
            <0.17343,0.81232,0.08951>,
    /*4*/ <0.14805,0.76169,0.1057>,<0.1483,0.76169,0.10608>,<0.14863,0.76146,0.10586>,
            <0.14838,0.76147,0.10548>,
    /*5*/ <0.12627,0.70687,0.1077>,<0.12634,0.70685,0.10782>,<0.12645,0.70681,0.10775>,
            <0.12638,0.70683,0.10763>,
    /*6*/ <0.12636,0.70684,0.10772>

    /* stem 0c2.14*/ 
    /*0*/ <0.24486,0.93861,0.03422>,
    /*1*/ <0.24551,0.93836,0.0339>,<0.24491,0.93926,0.03382>,<0.24421,0.93886,0.03455>,
            <0.24482,0.93796,0.03463>,
    /*2*/ <0.21546,0.91447,-0.00782>,<0.21499,0.91516,-0.00789>,<0.21445,0.91485,-0.00732>,
            <0.21492,0.91416,-0.00726>,
    /*3*/ <0.18607,0.8858,-0.04691>,<0.18571,0.88627,-0.04699>,<0.18534,0.88607,-0.04657>,
            <0.1857,0.88559,-0.04649>,
    /*4*/ <0.16049,0.84534,-0.07726>,<0.16024,0.84557,-0.07735>,<0.16005,0.84547,-0.07707>,
            <0.1603,0.84524,-0.07698>,
    /*5*/ <0.13973,0.79713,-0.09867>,<0.13965,0.79718,-0.09871>,<0.1396,0.79716,-0.09862>,
            <0.13968,0.79711,-0.09858>,
    /*6*/ <0.13966,0.79714,-0.09865>

    /* stem 0c2.15*/ 
    /*0*/ <0.27378,0.99889,0.04042>,
    /*1*/ <0.27388,0.99878,0.04083>,<0.27417,0.99908,0.04038>,<0.27369,0.999,0.04002>,
            <0.2734,0.99869,0.04046>,
    /*2*/ <0.29511,0.95331,0.02344>,<0.29533,0.95355,0.0231>,<0.29496,0.95348,0.02282>,
            <0.29474,0.95325,0.02316>,
    /*3*/ <0.31064,0.90651,0.00367>,<0.3108,0.90667,0.00343>,<0.31052,0.90666,0.00324>,
            <0.31036,0.9065,0.00348>,
    /*4*/ <0.31483,0.85538,-0.00994>,<0.31494,0.85543,-0.0101>,<0.31477,0.85544,-0.01021>,
            <0.31467,0.85539,-0.01005>,
    /*5*/ <0.30376,0.80494,-0.02237>,<0.30379,0.80495,-0.02242>,<0.30374,0.80497,-0.02245>,
            <0.30371,0.80496,-0.02239>,
    /*6*/ <0.30375,0.80495,-0.02241>

    /* stem 0c2.16*/ 
    /*0*/ <0.29809,1.04161,0.04616>,
    /*1*/ <0.29796,1.0417,0.04607>,<0.29822,1.04168,0.04604>,<0.29823,1.04153,0.04625>,
            <0.29797,1.04155,0.04628>,
    /*2*/ <0.30576,1.08235,0.07493>,<0.30595,1.08233,0.07491>,<0.30596,1.08221,0.07507>,
            <0.30577,1.08223,0.0751>,
    /*3*/ <0.30995,1.12069,0.10747>,<0.31009,1.12068,0.10745>,<0.3101,1.12059,0.10756>,
            <0.30995,1.1206,0.10757>,
    /*4*/ <0.30644,1.14958,0.14869>,<0.30653,1.14958,0.1487>,<0.30653,1.14951,0.14875>,
            <0.30645,1.14951,0.14874>,
    /*5*/ <0.29447,1.16852,0.1939>,<0.29449,1.16852,0.19391>,<0.29449,1.1685,0.19392>,
            <0.29447,1.16849,0.19391>,
    /*6*/ <0.29448,1.16851,0.19391>

    /* stem 0c3*/ 
    /*0*/ <0,0.11335,0>,
    /*1*/ <-0.00501,0.11346,0.00097>,<-0.00086,0.11524,-0.00466>,<0.00501,0.11325,-0.00097>,
            <0.00086,0.11146,0.00466>,
    /*2*/ <0.00561,0.2187,0.04172>,<0.00929,0.22029,0.03672>,<0.01451,0.21851,0.04>,
            <0.01082,0.21693,0.045>,
    /*3*/ <0.01809,0.32563,0.07757>,<0.0213,0.32677,0.07311>,<0.02586,0.32528,0.07601>,
            <0.02265,0.32414,0.08047>,
    /*4*/ <0.02464,0.4352,0.10522>,<0.02737,0.43604,0.10134>,<0.03132,0.43516,0.10394>,
            <0.0286,0.43433,0.10781>,
    /*5*/ <0.02593,0.54613,0.1279>,<0.02819,0.54678,0.12466>,<0.0315,0.5463,0.12687>,
            <0.02924,0.54565,0.13012>,
    /*6*/ <0.02725,0.6538,0.16312>,<0.02907,0.65462,0.16061>,<0.03171,0.65403,0.16233>,
            <0.02989,0.65322,0.16484>,
    /*7*/ <0.03501,0.75612,0.21147>,<0.03638,0.75689,0.20965>,<0.03835,0.75619,0.21083>,
            <0.03699,0.75542,0.21265>,
    /*8*/ <0.04796,0.85851,0.25855>,<0.04886,0.85897,0.25731>,<0.05018,0.85846,0.25807>,
            <0.04927,0.858,0.25931>,
    /*9*/ <0.06053,0.95826,0.31088>,<0.06099,0.95852,0.31027>,<0.06164,0.95825,0.31064>,
            <0.06119,0.95798,0.31125>,
    /*10*/ <0.07676,1.05145,0.37334>

    /* stem 0c3.0*/ 
    /*0*/ <0.01169,0.23323,0.04578>,
    /*1*/ <0.01089,0.23276,0.04746>,<0.01282,0.23451,0.04668>,<0.01249,0.23371,0.0441>,
            <0.01056,0.23196,0.04488>,
    /*2*/ <0.07778,0.16473,0.05959>,<0.07928,0.16608,0.05898>,<0.07903,0.16547,0.05698>,
            <0.07753,0.16411,0.05759>,
    /*3*/ <0.13522,0.08882,0.07261>,<0.1364,0.08964,0.0722>,<0.13619,0.08923,0.07078>,
            <0.13501,0.08841,0.07119>,
    /*4*/ <0.17979,0.00357,0.07359>,<0.18055,0.00396,0.07336>,<0.18035,0.00384,0.0725>,
            <0.17959,0.00345,0.07273>,
    /*5*/ <0.2046,-0.08882,0.06371>,<0.20485,-0.08875,0.06364>,<0.20478,-0.08874,0.06338>,
            <0.20453,-0.08882,0.06345>,
    /*6*/ <0.20469,-0.08878,0.06354>

    /* stem 0c3.1*/ 
    /*0*/ <0.01793,0.28923,0.06461>,
    /*1*/ <0.01723,0.28985,0.063>,<0.01897,0.29077,0.06475>,<0.01864,0.28861,0.06621>,
            <0.0169,0.28769,0.06447>,
    /*2*/ <-0.05126,0.33195,0.10976>,<-0.04991,0.33266,0.11111>,<-0.05017,0.33099,0.11225>,
            <-0.05152,0.33028,0.11089>,
    /*3*/ <-0.12024,0.37263,0.15707>,<-0.11929,0.37314,0.15803>,<-0.11945,0.37194,0.15882>,
            <-0.12041,0.37143,0.15786>,
    /*4*/ <-0.19931,0.39501,0.20058>,<-0.19887,0.39536,0.20122>,<-0.19886,0.39461,0.20163>,
            <-0.19931,0.39426,0.20099>,
    /*5*/ <-0.28492,0.39762,0.23679>,<-0.28483,0.39773,0.23701>,<-0.28479,0.39749,0.23712>,
            <-0.28488,0.39738,0.2369>,
    /*6*/ <-0.28485,0.39755,0.23695>

    /* stem 0c3.2*/ 
    /*0*/ <0.02312,0.34645,0.08211>,
    /*1*/ <0.02482,0.34651,0.08153>,<0.02362,0.34727,0.08363>,<0.02143,0.3464,0.08269>,
            <0.02263,0.34564,0.08059>,
    /*2*/ <0.00896,0.42638,0.04371>,<0.00802,0.42697,0.04534>,<0.00632,0.4263,0.04461>,
            <0.00726,0.42571,0.04298>,
    /*3*/ <-0.01118,0.50205,-0.00029>,<-0.01185,0.50253,0.00083>,<-0.01303,0.50195,0.00037>,
            <-0.01236,0.50147,-0.00075>,
    /*4*/ <-0.03631,0.56229,-0.06193>,<-0.03675,0.5627,-0.06136>,<-0.03741,0.56224,-0.06154>,
            <-0.03697,0.56183,-0.06211>,
    /*5*/ <-0.06635,0.6011,-0.13713>,<-0.0665,0.60125,-0.13699>,<-0.06669,0.60108,-0.137>,
            <-0.06654,0.60093,-0.13714>,
    /*6*/ <-0.06652,0.60109,-0.13706>

    /* stem 0c3.3*/ 
    /*0*/ <0.02646,0.40734,0.09753>,
    /*1*/ <0.02541,0.40705,0.09887>,<0.0267,0.40896,0.09806>,<0.0275,0.40762,0.09618>,
            <0.02621,0.40571,0.09699>,
    /*2*/ <0.09335,0.38146,0.14575>,<0.09436,0.38294,0.14512>,<0.09498,0.3819,0.14366>,
            <0.09398,0.38042,0.14429>,
    /*3*/ <0.159,0.34971,0.19208>,<0.15978,0.35073,0.19168>,<0.16018,0.35001,0.19062>,
            <0.1594,0.34899,0.19102>,
    /*4*/ <0.21995,0.29855,0.22589>,<0.2205,0.29909,0.22571>,<0.22061,0.29875,0.225>,
            <0.22006,0.29821,0.22518>,
    /*5*/ <0.26944,0.23069,0.24628>,<0.26964,0.23083,0.24625>,<0.26964,0.23076,0.24601>,
            <0.26944,0.23062,0.24605>,
    /*6*/ <0.26954,0.23073,0.24615>

    /* stem 0c3.4*/ 
    /*0*/ <0.02822,0.47172,0.11208>,
    /*1*/ <0.02841,0.47205,0.11047>,<0.02911,0.47307,0.11246>,<0.02803,0.47139,0.1137>,
            <0.02734,0.47037,0.1117>,
    /*2*/ <-0.04106,0.51722,0.11194>,<-0.04053,0.51801,0.11349>,<-0.04136,0.51671,0.11444>,
            <-0.0419,0.51592,0.1129>,
    /*3*/ <-0.11427,0.55582,0.1181>,<-0.11389,0.55638,0.1192>,<-0.11436,0.55539,0.11987>,
            <-0.11474,0.55482,0.11878>,
    /*4*/ <-0.19558,0.5718,0.11723>,<-0.19552,0.57219,0.11788>,<-0.19565,0.57155,0.11828>,
            <-0.19572,0.57116,0.11763>,
    /*5*/ <-0.27814,0.56494,0.11391>,<-0.27816,0.56506,0.11411>,<-0.27815,0.56486,0.11423>,
            <-0.27813,0.56474,0.11404>,
    /*6*/ <-0.27814,0.5649,0.11407>

    /* stem 0c3.5*/ 
    /*0*/ <0.02849,0.51168,0.12029>,
    /*1*/ <0.02972,0.51147,0.12131>,<0.02785,0.51277,0.1213>,<0.02725,0.5119,0.11928>,
            <0.02913,0.5106,0.11929>,
    /*2*/ <0.07043,0.57023,0.08386>,<0.06898,0.57124,0.08385>,<0.06851,0.57057,0.08228>,
            <0.06997,0.56956,0.08229>,
    /*3*/ <0.11349,0.6231,0.04066>,<0.11251,0.62388,0.04062>,<0.11212,0.62333,0.03955>,
            <0.11311,0.62255,0.0396>,
    /*4*/ <0.16579,0.65838,-0.00959>,<0.1653,0.65893,-0.00972>,<0.16502,0.65854,-0.01029>,
            <0.16551,0.658,-0.01016>,
    /*5*/ <0.21983,0.67202,-0.06797>,<0.21971,0.6722,-0.06804>,<0.21959,0.67207,-0.06818>,
            <0.21971,0.67189,-0.06811>,
    /*6*/ <0.21971,0.67205,-0.06807>

    /* stem 0c3.6*/ 
    /*0*/ <0.0289,0.57244,0.13599>,
    /*1*/ <0.02736,0.57247,0.13594>,<0.02895,0.57371,0.13511>,<0.03045,0.57242,0.13604>,
            <0.02885,0.57118,0.13688>,
    /*2*/ <0.02641,0.61691,0.19924>,<0.02764,0.61787,0.19859>,<0.0288,0.61687,0.19932>,
            <0.02756,0.61591,0.19997>,
    /*3*/ <0.0254,0.65553,0.26625>,<0.02628,0.65625,0.26585>,<0.0271,0.65549,0.2663>,
            <0.02622,0.65477,0.2667>,
    /*4*/ <0.02327,0.67466,0.34115>,<0.02378,0.67514,0.34104>,<0.02427,0.67465,0.34118>,
            <0.02376,0.67417,0.34129>,
    /*5*/ <0.01932,0.66909,0.41818>,<0.01948,0.66924,0.4182>,<0.01963,0.66909,0.4182>,
            <0.01947,0.66894,0.41818>,
    /*6*/ <0.01947,0.66909,0.41819>

    /* stem 0c3.7*/ 
    /*0*/ <0.02919,0.61356,0.14948>,
    /*1*/ <0.03044,0.61381,0.14869>,<0.0296,0.61463,0.15046>,<0.02795,0.61331,0.15028>,
            <0.02879,0.6125,0.14851>,
    /*2*/ <-0.00623,0.66501,0.10791>,<-0.00688,0.66565,0.10928>,<-0.00816,0.66462,0.10914>,
            <-0.00751,0.66399,0.10777>,
    /*3*/ <-0.04088,0.70963,0.05865>,<-0.04142,0.71018,0.05952>,<-0.0423,0.70942,0.05945>,
            <-0.04176,0.70887,0.05858>,
    /*4*/ <-0.07553,0.74129,0.00016>,<-0.07591,0.74167,0.00059>,<-0.07639,0.74118,0.0006>,
            <-0.07601,0.74079,0.00017>,
    /*5*/ <-0.11145,0.76034,-0.0629>,<-0.11158,0.76047,-0.06279>,<-0.11171,0.76031,-0.06276>,
            <-0.11158,0.76018,-0.06287>,
    /*6*/ <-0.11158,0.76033,-0.06283>

    /* stem 0c3.8*/ 
    /*0*/ <0.03161,0.68411,0.17703>,
    /*1*/ <0.03188,0.6835,0.17828>,<0.03064,0.68495,0.17764>,<0.03134,0.68473,0.17577>,
            <0.03257,0.68328,0.17641>,
    /*2*/ <0.0821,0.73205,0.19082>,<0.08115,0.73317,0.19033>,<0.08168,0.73299,0.18888>,
            <0.08264,0.73187,0.18937>,
    /*3*/ <0.13325,0.77935,0.20423>,<0.13259,0.78016,0.20389>,<0.13297,0.78004,0.20286>,
            <0.13363,0.77922,0.2032>,
    /*4*/ <0.19328,0.81696,0.20872>,<0.19296,0.81749,0.20853>,<0.1931,0.81735,0.20791>,
            <0.19342,0.81682,0.2081>,
    /*5*/ <0.25848,0.84479,0.20527>,<0.25841,0.84496,0.20522>,<0.25842,0.84491,0.20502>,
            <0.2585,0.84473,0.20508>,
    /*6*/ <0.25845,0.84485,0.20515>

    /* stem 0c3.9*/ 
    /*0*/ <0.03558,0.74056,0.20376>,
    /*1*/ <0.03424,0.74058,0.20391>,<0.03573,0.74106,0.20501>,<0.03693,0.74053,0.20362>,
            <0.03544,0.74005,0.20252>,
    /*2*/ <0.0361,0.67787,0.22913>,<0.03726,0.67824,0.22998>,<0.03819,0.67783,0.2289>,
            <0.03703,0.67746,0.22805>,
    /*3*/ <0.03622,0.61298,0.24807>,<0.03704,0.61316,0.2487>,<0.0377,0.61293,0.24791>,
            <0.03688,0.61274,0.24728>,
    /*4*/ <0.03233,0.54549,0.24853>,<0.03281,0.54547,0.24892>,<0.03321,0.54544,0.24844>,
            <0.03272,0.54547,0.24805>,
    /*5*/ <0.02741,0.48083,0.22938>,<0.02756,0.48078,0.22949>,<0.02768,0.48081,0.22935>,
            <0.02754,0.48086,0.22923>,
    /*6*/ <0.02755,0.48082,0.22936>

    /* stem 0c3.10*/ 
    /*0*/ <0.03916,0.77658,0.22056>,
    /*1*/ <0.03955,0.77707,0.21941>,<0.03963,0.77764,0.22117>,<0.03876,0.7761,0.22172>,
            <0.03868,0.77552,0.21996>,
    /*2*/ <-0.01827,0.80698,0.21232>,<-0.01821,0.80743,0.21369>,<-0.01888,0.80623,0.21411>,
            <-0.01894,0.80578,0.21274>,
    /*3*/ <-0.07765,0.83226,0.2014>,<-0.07768,0.83261,0.20236>,<-0.07812,0.83174,0.20267>,
            <-0.07809,0.83139,0.20171>,
    /*4*/ <-0.13774,0.84401,0.17835>,<-0.1379,0.84425,0.17887>,<-0.13808,0.84371,0.17907>,
            <-0.13792,0.84347,0.17854>,
    /*5*/ <-0.19702,0.83825,0.15109>,<-0.1971,0.83833,0.15124>,<-0.19712,0.83816,0.15132>,
            <-0.19704,0.83808,0.15117>,
    /*6*/ <-0.19707,0.8382,0.1512>

    /* stem 0c3.11*/ 
    /*0*/ <0.04195,0.7997,0.23122>,
    /*1*/ <0.04242,0.79916,0.23228>,<0.04262,0.80077,0.23147>,<0.04149,0.80025,0.23016>,
            <0.04128,0.79864,0.23097>,
    /*2*/ <0.09174,0.77611,0.19842>,<0.0919,0.77735,0.19779>,<0.09102,0.77695,0.19677>,
            <0.09086,0.7757,0.1974>,
    /*3*/ <0.14083,0.74889,0.16756>,<0.141,0.74975,0.16707>,<0.14038,0.74945,0.16635>,
            <0.14021,0.7486,0.16683>,
    /*4*/ <0.17902,0.70909,0.13489>,<0.1792,0.70954,0.13455>,<0.17876,0.70942,0.13418>,
            <0.17858,0.70897,0.13452>,
    /*5*/ <0.20291,0.66009,0.10113>,<0.20298,0.6602,0.10101>,<0.20283,0.6602,0.10091>,
            <0.20276,0.66008,0.10103>,
    /*6*/ <0.20287,0.66014,0.10102>

    /* stem 0c3.12*/ 
    /*0*/ <0.04707,0.84198,0.25071>,
    /*1*/ <0.04601,0.84234,0.25022>,<0.04726,0.84312,0.25111>,<0.04814,0.84163,0.2512>,
            <0.04688,0.84084,0.2503>,
    /*2*/ <0.01739,0.82843,0.30297>,<0.01837,0.82904,0.30367>,<0.01904,0.82788,0.30373>,
            <0.01807,0.82727,0.30304>,
    /*3*/ <-0.01126,0.81096,0.35465>,<-0.01058,0.81138,0.35517>,<-0.01008,0.81057,0.35518>,
            <-0.01076,0.81015,0.35466>,
    /*4*/ <-0.04306,0.77827,0.39603>,<-0.04273,0.77846,0.39644>,<-0.04238,0.77802,0.39636>,
            <-0.04271,0.77783,0.39595>,
    /*5*/ <-0.07586,0.73418,0.42384>,<-0.07578,0.73421,0.42399>,<-0.07566,0.7341,0.42395>,
            <-0.07574,0.73406,0.4238>,
    /*6*/ <-0.07576,0.73414,0.42389>

    /* stem 0c3.13*/ 
    /*0*/ <0.05335,0.89399,0.27698>,
    /*1*/ <0.05426,0.89399,0.27678>,<0.05335,0.89493,0.27697>,<0.05244,0.894,0.27718>,
            <0.05334,0.89306,0.27698>,
    /*2*/ <0.0415,0.89381,0.21972>,<0.0408,0.89453,0.21987>,<0.04009,0.89381,0.22003>,
            <0.04079,0.89309,0.21987>,
    /*3*/ <0.03109,0.88653,0.16267>,<0.03058,0.88704,0.1627>,<0.03008,0.88653,0.16285>,
            <0.0306,0.88603,0.16282>,
    /*4*/ <0.02339,0.86633,0.10836>,<0.02307,0.86661,0.1083>,<0.02279,0.86632,0.10845>,
            <0.02311,0.86604,0.10851>,
    /*5*/ <0.01831,0.83132,0.06181>,<0.01821,0.83139,0.06177>,<0.01812,0.83132,0.06183>,
            <0.01823,0.83125,0.06188>,
    /*6*/ <0.01822,0.83132,0.06182>

    /* stem 0c3.14*/ 
    /*0*/ <0.05941,0.94433,0.30344>,
    /*1*/ <0.05899,0.94414,0.30389>,<0.05985,0.94444,0.3039>,<0.05983,0.94452,0.30299>,
            <0.05896,0.94422,0.30298>,
    /*2*/ <0.07693,0.89197,0.29864>,<0.0776,0.8922,0.29865>,<0.07758,0.89227,0.29794>,
            <0.07691,0.89204,0.29794>,
    /*3*/ <0.09364,0.84042,0.28691>,<0.09412,0.84058,0.28691>,<0.09409,0.84068,0.28642>,
            <0.09361,0.84053,0.28642>,
    /*4*/ <0.09935,0.78871,0.26787>,<0.09964,0.78875,0.26785>,<0.09961,0.78885,0.26757>,
            <0.09932,0.78881,0.26759>,
    /*5*/ <0.094,0.74081,0.24053>,<0.09409,0.7408,0.24052>,<0.09408,0.74085,0.24044>,
            <0.09399,0.74085,0.24046>,
    /*6*/ <0.09404,0.74083,0.24049>

    /* stem 0c3.15*/ 
    /*0*/ <0.0637,0.9738,0.3212>,
    /*1*/ <0.06372,0.97406,0.3208>,<0.06406,0.97405,0.32138>,<0.06368,0.97354,0.32159>,
            <0.06335,0.97355,0.32102>,
    /*2*/ <0.0285,1.0083,0.34215>,<0.02876,1.00829,0.3426>,<0.02847,1.00789,0.34276>,
            <0.02821,1.0079,0.34232>,
    /*3*/ <-0.01096,1.0402,0.35923>,<-0.0108,1.04022,0.35956>,<-0.01099,1.03993,0.35967>,
            <-0.01115,1.03991,0.35934>,
    /*4*/ <-0.05807,1.06409,0.36801>,<-0.05801,1.06412,0.36822>,<-0.0581,1.06393,0.36827>,
            <-0.05816,1.0639,0.36807>,
    /*5*/ <-0.10993,1.07701,0.37144>,<-0.10993,1.07702,0.37151>,<-0.10994,1.07696,0.37152>,
            <-0.10995,1.07695,0.37146>,
    /*6*/ <-0.10994,1.07699,0.37148>

    /* stem 0c3.16*/ 
    /*0*/ <0.07203,1.0233,0.35444>,
    /*1*/ <0.07219,1.02325,0.35447>,<0.07209,1.02345,0.35437>,<0.07187,1.02335,0.3544>,
            <0.07197,1.02315,0.3545>,
    /*2*/ <0.07519,1.00152,0.30917>,<0.07512,1.00168,0.30909>,<0.07495,1.0016,0.30911>,
            <0.07502,1.00145,0.30919>,
    /*3*/ <0.07661,0.97617,0.26571>,<0.07656,0.97628,0.26564>,<0.07644,0.97623,0.26567>,
            <0.07649,0.97612,0.26573>,
    /*4*/ <0.07289,0.93936,0.23158>,<0.07285,0.93942,0.23152>,<0.07278,0.9394,0.23155>,
            <0.07281,0.93935,0.2316>,
    /*5*/ <0.06607,0.89701,0.20525>,<0.06606,0.89702,0.20524>,<0.06604,0.89701,0.20525>,
            <0.06605,0.897,0.20526>,
    /*6*/ <0.06605,0.89701,0.20525>

    /* stem 0c4*/ 
    /*0*/ <0,0.11335,0>,
    /*1*/ <-0.00503,0.11362,-0.00082>,<0.0008,0.11664,-0.00382>,<0.00503,0.11309,0.00082>,
            <-0.0008,0.11007,0.00382>,
    /*2*/ <-0.01184,0.20007,0.07218>,<-0.00666,0.20275,0.06952>,<-0.00291,0.1996,0.07364>,
            <-0.00809,0.19691,0.07631>,
    /*3*/ <-0.01733,0.29495,0.13389>,<-0.01277,0.29693,0.13129>,<-0.00951,0.29459,0.13521>,
            <-0.01407,0.29261,0.13782>,
    /*4*/ <-0.02465,0.40185,0.17017>,<-0.02072,0.40299,0.16765>,<-0.01797,0.40191,0.17144>,
            <-0.0219,0.40077,0.17396>,
    /*5*/ <-0.02874,0.51365,0.18839>,<-0.02544,0.51415,0.18617>,<-0.02317,0.51371,0.18945>,
            <-0.02647,0.51321,0.19166>,
    /*6*/ <-0.03042,0.62387,0.21521>,<-0.02778,0.62435,0.21345>,<-0.02596,0.62377,0.21602>,
            <-0.0286,0.62329,0.21778>,
    /*7*/ <-0.03381,0.73407,0.24142>,<-0.03183,0.73445,0.24011>,<-0.03047,0.73404,0.24205>,
            <-0.03245,0.73366,0.24336>,
    /*8*/ <-0.04196,0.84492,0.26325>,<-0.04064,0.84519,0.26238>,<-0.03973,0.84501,0.26369>,
            <-0.04105,0.84473,0.26456>,
    /*9*/ <-0.05035,0.95286,0.29691>,<-0.0497,0.95304,0.29648>,<-0.04924,0.95288,0.29712>,
            <-0.04989,0.9527,0.29754>,
    /*10*/ <-0.06162,1.05986,0.33254>

    /* stem 0c4.0*/ 
    /*0*/ <-0.00853,0.21801,0.08471>,
    /*1*/ <-0.01026,0.21748,0.08536>,<-0.00862,0.21959,0.08579>,<-0.0068,0.21854,0.08407>,
            <-0.00845,0.21643,0.08364>,
    /*2*/ <0.0314,0.17047,0.15775>,<0.03267,0.1721,0.15809>,<0.03407,0.17128,0.15676>,
            <0.0328,0.16965,0.15642>,
    /*3*/ <0.07425,0.11475,0.22293>,<0.07521,0.11585,0.22325>,<0.07614,0.11534,0.22221>,
            <0.07519,0.11424,0.22189>,
    /*4*/ <0.11543,0.04214,0.27004>,<0.11606,0.04268,0.27033>,<0.11655,0.04249,0.26961>,
            <0.11591,0.04195,0.26933>,
    /*5*/ <0.15265,-0.04327,0.29258>,<0.15287,-0.04315,0.29268>,<0.15299,-0.04316,0.29244>,
            <0.15278,-0.04328,0.29234>,
    /*6*/ <0.15282,-0.04321,0.29251>

    /* stem 0c4.1*/ 
    /*0*/ <-0.01198,0.27219,0.11989>,
    /*1*/ <-0.01193,0.2732,0.11834>,<-0.01179,0.27373,0.1209>,<-0.01203,0.27118,0.12144>,
            <-0.01217,0.27065,0.11889>,
    /*2*/ <-0.10381,0.28221,0.12188>,<-0.1037,0.28263,0.12386>,<-0.10389,0.28065,0.12427>,
            <-0.104,0.28024,0.12229>,
    /*3*/ <-0.1961,0.2853,0.11971>,<-0.19613,0.28559,0.12111>,<-0.19618,0.28419,0.12141>,
            <-0.19616,0.28389,0.12>,
    /*4*/ <-0.28588,0.2651,0.11074>,<-0.28601,0.26527,0.11156>,<-0.28585,0.26446,0.11176>,
            <-0.28572,0.26429,0.11093>,
    /*5*/ <-0.36685,0.22536,0.09069>,<-0.36693,0.2254,0.09093>,<-0.36683,0.22516,0.091>,
            <-0.36675,0.22512,0.09075>,
    /*6*/ <-0.36684,0.22526,0.09084>

    /* stem 0c4.2*/ 
    /*0*/ <-0.01585,0.32772,0.14571>,
    /*1*/ <-0.01411,0.32772,0.14611>,<-0.01565,0.3293,0.1449>,<-0.01758,0.32773,0.14531>,
            <-0.01604,0.32615,0.14652>,
    /*2*/ <0.00295,0.28603,0.06925>,<0.00176,0.28726,0.06831>,<0.00026,0.28604,0.06863>,
            <0.00146,0.28482,0.06957>,
    /*3*/ <0.01704,0.23782,-0.00436>,<0.0162,0.23866,-0.00508>,<0.01512,0.23786,-0.00476>,
            <0.01596,0.23702,-0.00404>,
    /*4*/ <0.03035,0.16775,-0.05765>,<0.02989,0.16809,-0.05823>,<0.02922,0.16773,-0.05792>,
            <0.02969,0.16738,-0.05734>,
    /*5*/ <0.03927,0.08557,-0.09085>,<0.03913,0.08563,-0.09105>,<0.03892,0.08556,-0.09093>,
            <0.03906,0.0855,-0.09073>,
    /*6*/ <0.0391,0.08556,-0.09089>

    /* stem 0c4.3*/ 
    /*0*/ <-0.01905,0.37119,0.16042>,
    /*1*/ <-0.01977,0.37064,0.16189>,<-0.01888,0.37278,0.16109>,<-0.01832,0.37174,0.15894>,
            <-0.01921,0.3696,0.15974>,
    /*2*/ <0.0587,0.34964,0.19198>,<0.05938,0.35129,0.19136>,<0.05982,0.35049,0.18969>,
            <0.05913,0.34883,0.19031>,
    /*3*/ <0.13483,0.31647,0.21661>,<0.13545,0.3176,0.21622>,<0.13563,0.31708,0.21499>,
            <0.135,0.31595,0.21538>,
    /*4*/ <0.20315,0.26492,0.22995>,<0.20364,0.26552,0.22975>,<0.20362,0.26529,0.22899>,
            <0.20313,0.26469,0.22919>,
    /*5*/ <0.25978,0.19969,0.2361>,<0.25996,0.19985,0.23604>,<0.25993,0.19979,0.2358>,
            <0.25975,0.19964,0.23586>,
    /*6*/ <0.25986,0.19974,0.23595>

    /* stem 0c4.4*/ 
    /*0*/ <-0.02292,0.44077,0.1771>,
    /*1*/ <-0.02436,0.44084,0.17629>,<-0.02248,0.44222,0.17645>,<-0.02148,0.4407,0.17792>,
            <-0.02337,0.43932,0.17776>,
    /*2*/ <-0.05834,0.48027,0.24065>,<-0.05688,0.48134,0.24077>,<-0.05611,0.48016,0.24191>,
            <-0.05757,0.47909,0.24179>,
    /*3*/ <-0.096,0.51157,0.30735>,<-0.09502,0.51238,0.30753>,<-0.09443,0.5115,0.30828>,
            <-0.09542,0.51069,0.3081>,
    /*4*/ <-0.13673,0.52267,0.37856>,<-0.13621,0.52319,0.37878>,<-0.1358,0.52264,0.3791>,
            <-0.13632,0.52212,0.37888>,
    /*5*/ <-0.1816,0.51493,0.44765>,<-0.18147,0.51508,0.44775>,<-0.18133,0.51491,0.44783>,
            <-0.18146,0.51475,0.44772>,
    /*6*/ <-0.18146,0.51492,0.44774>

    /* stem 0c4.5*/ 
    /*0*/ <-0.02531,0.49826,0.18642>,
    /*1*/ <-0.02383,0.49841,0.18586>,<-0.0255,0.49984,0.18635>,<-0.02679,0.49811,0.18698>,
            <-0.02512,0.49668,0.18649>,
    /*2*/ <-0.05179,0.49188,0.11155>,<-0.05308,0.49298,0.11194>,<-0.05408,0.49164,0.11243>,
            <-0.05279,0.49053,0.11204>,
    /*3*/ <-0.07856,0.47608,0.03821>,<-0.07951,0.47685,0.03839>,<-0.08019,0.47591,0.03883>,
            <-0.07924,0.47514,0.03866>,
    /*4*/ <-0.10158,0.44043,-0.02921>,<-0.10218,0.44085,-0.02922>,<-0.10254,0.44034,-0.02883>,
            <-0.10193,0.43993,-0.02882>,
    /*5*/ <-0.11658,0.3842,-0.08359>,<-0.11678,0.3843,-0.08363>,<-0.11687,0.38417,-0.08347>,
            <-0.11668,0.38408,-0.08343>,
    /*6*/ <-0.11673,0.38419,-0.08353>

    /* stem 0c4.6*/ 
    /*0*/ <-0.02661,0.54615,0.19679>,
    /*1*/ <-0.02632,0.5458,0.19826>,<-0.02636,0.54764,0.19709>,<-0.02691,0.5465,0.19532>,
            <-0.02686,0.54466,0.19648>,
    /*2*/ <0.04815,0.53679,0.18073>,<0.04812,0.53822,0.17983>,<0.04769,0.53734,0.17845>,
            <0.04773,0.53591,0.17936>,
    /*3*/ <0.12222,0.52376,0.16419>,<0.12225,0.52476,0.16353>,<0.12193,0.52414,0.16256>,
            <0.1219,0.52313,0.16322>,
    /*4*/ <0.19092,0.4943,0.1456>,<0.19105,0.49486,0.14519>,<0.19076,0.49452,0.14464>,
            <0.19063,0.49396,0.14505>,
    /*5*/ <0.25185,0.45046,0.1284>,<0.25192,0.45061,0.12826>,<0.25181,0.45052,0.1281>,
            <0.25173,0.45036,0.12823>,
    /*6*/ <0.25183,0.45049,0.12825>

    /* stem 0c4.7*/ 
    /*0*/ <-0.02764,0.59664,0.20903>,
    /*1*/ <-0.02912,0.59661,0.20903>,<-0.02765,0.59737,0.21032>,<-0.02615,0.59667,0.20902>,
            <-0.02763,0.59591,0.20773>,
    /*2*/ <-0.02725,0.53197,0.24553>,<-0.0261,0.53256,0.24653>,<-0.02494,0.53202,0.24552>,
            <-0.02609,0.53143,0.24452>,
    /*3*/ <-0.02626,0.46382,0.27495>,<-0.02545,0.46415,0.2757>,<-0.02462,0.46384,0.27496>,
            <-0.02544,0.4635,0.2742>,
    /*4*/ <-0.02624,0.39033,0.2855>,<-0.02576,0.3904,0.28598>,<-0.02528,0.39033,0.28551>,
            <-0.02576,0.39026,0.28503>,
    /*5*/ <-0.0248,0.31688,0.27467>,<-0.02465,0.31686,0.27482>,<-0.0245,0.31688,0.27467>,
            <-0.02465,0.3169,0.27452>,
    /*6*/ <-0.02465,0.31688,0.27467>

    /* stem 0c4.8*/ 
    /*0*/ <-0.02952,0.66106,0.22444>,
    /*1*/ <-0.02845,0.6613,0.22356>,<-0.02899,0.66199,0.22535>,<-0.0306,0.66081,0.22532>,
            <-0.03006,0.66012,0.22352>,
    /*2*/ <-0.06585,0.7127,0.1926>,<-0.06628,0.71324,0.19399>,<-0.06753,0.71232,0.19397>,
            <-0.0671,0.71178,0.19257>,
    /*3*/ <-0.1056,0.75772,0.1553>,<-0.10596,0.75818,0.15623>,<-0.1068,0.75746,0.15626>,
            <-0.10644,0.75701,0.15533>,
    /*4*/ <-0.15311,0.78614,0.11123>,<-0.15338,0.78646,0.11173>,<-0.15378,0.78596,0.11183>,
            <-0.15351,0.78564,0.11134>,
    /*5*/ <-0.20004,0.79768,0.05964>,<-0.20015,0.79779,0.05976>,<-0.20025,0.79763,0.05982>,
            <-0.20014,0.79752,0.05969>,
    /*6*/ <-0.20015,0.79766,0.05973>

    /* stem 0c4.9*/ 
    /*0*/ <-0.03164,0.72003,0.23841>,
    /*1*/ <-0.03079,0.71982,0.23944>,<-0.03131,0.72134,0.23842>,<-0.03249,0.72025,0.23739>,
            <-0.03196,0.71872,0.23841>,
    /*2*/ <0.01882,0.70773,0.19534>,<0.01841,0.70891,0.19455>,<0.0175,0.70806,0.19375>,
            <0.01791,0.70688,0.19454>,
    /*3*/ <0.06839,0.69002,0.1532>,<0.06816,0.69084,0.15258>,<0.06749,0.69024,0.15204>,
            <0.06772,0.68942,0.15266>,
    /*4*/ <0.11022,0.65605,0.11259>,<0.11017,0.65649,0.11216>,<0.10968,0.65618,0.11192>,
            <0.10974,0.65574,0.11235>,
    /*5*/ <0.14293,0.61199,0.0733>,<0.14293,0.61212,0.07316>,<0.14276,0.61204,0.0731>,
            <0.14276,0.61192,0.07325>,
    /*6*/ <0.14284,0.61202,0.0732>

    /* stem 0c4.10*/ 
    /*0*/ <-0.03539,0.77543,0.24984>,
    /*1*/ <-0.03662,0.77526,0.25018>,<-0.03541,0.77662,0.25032>,<-0.03415,0.77559,0.2495>,
            <-0.03536,0.77423,0.24936>,
    /*2*/ <-0.01763,0.75253,0.3074>,<-0.01669,0.75358,0.30751>,<-0.01572,0.75278,0.30687>,
            <-0.01665,0.75173,0.30676>,
    /*3*/ <0.00318,0.72503,0.36186>,<0.00385,0.72576,0.36197>,<0.00452,0.72522,0.36145>,
            <0.00385,0.72449,0.36134>,
    /*4*/ <0.0245,0.68447,0.40718>,<0.02493,0.68486,0.40732>,<0.02529,0.6846,0.40692>,
            <0.02486,0.68422,0.40678>,
    /*5*/ <0.04145,0.63287,0.44181>,<0.04159,0.63296,0.44188>,<0.04169,0.6329,0.44174>,
            <0.04155,0.63281,0.44167>,
    /*6*/ <0.04157,0.63289,0.44178>

    /* stem 0c4.11*/ 
    /*0*/ <-0.0379,0.80749,0.25613>,
    /*1*/ <-0.03725,0.80775,0.25509>,<-0.03729,0.8084,0.25674>,<-0.03856,0.80724,0.25716>,
            <-0.03852,0.80659,0.25551>,
    /*2*/ <-0.08095,0.84923,0.23784>,<-0.08098,0.84973,0.23911>,<-0.08197,0.84884,0.23944>,
            <-0.08194,0.84833,0.23816>,
    /*3*/ <-0.12713,0.88631,0.21733>,<-0.1272,0.88671,0.21821>,<-0.12786,0.88603,0.21846>,
            <-0.12779,0.88563,0.21758>,
    /*4*/ <-0.17817,0.90751,0.18781>,<-0.17832,0.90781,0.18827>,<-0.17862,0.90736,0.18847>,
            <-0.17847,0.90706,0.188>,
    /*5*/ <-0.22933,0.90966,0.15168>,<-0.22942,0.90976,0.15181>,<-0.22948,0.90961,0.15188>,
            <-0.2294,0.90951,0.15176>,
    /*6*/ <-0.22941,0.90963,0.15178>

    /* stem 0c4.12*/ 
    /*0*/ <-0.04351,0.87707,0.27345>,
    /*1*/ <-0.0432,0.87683,0.27433>,<-0.04348,0.878,0.2737>,<-0.04381,0.87732,0.27257>,
            <-0.04354,0.87614,0.2732>,
    /*2*/ <0.01248,0.88015,0.25566>,<0.01227,0.88107,0.25517>,<0.01201,0.88054,0.2543>,
            <0.01222,0.87962,0.25478>,
    /*3*/ <0.06812,0.87839,0.23669>,<0.06802,0.87904,0.23632>,<0.0678,0.87866,0.23571>,
            <0.0679,0.87801,0.23607>,
    /*4*/ <0.12001,0.85806,0.21794>,<0.12006,0.85842,0.21769>,<0.11985,0.85821,0.21735>,
            <0.1198,0.85785,0.21761>,
    /*5*/ <0.16239,0.82416,0.1952>,<0.16242,0.82426,0.19512>,<0.16233,0.82421,0.19502>,
            <0.1623,0.82411,0.19511>,
    /*6*/ <0.16236,0.82419,0.19511>

    /* stem 0c4.13*/ 
    /*0*/ <-0.04711,0.92048,0.28694>,
    /*1*/ <-0.04775,0.92053,0.28659>,<-0.04737,0.92091,0.28748>,<-0.04647,0.92042,0.2873>,
            <-0.04685,0.92004,0.28641>,
    /*2*/ <-0.06686,0.87517,0.31409>,<-0.06657,0.87546,0.31478>,<-0.06587,0.87508,0.31464>,
            <-0.06617,0.87479,0.31395>,
    /*3*/ <-0.08795,0.82765,0.3358>,<-0.08776,0.8278,0.33632>,<-0.08727,0.82753,0.33622>,
            <-0.08745,0.82738,0.3357>,
    /*4*/ <-0.10101,0.7738,0.34633>,<-0.10091,0.77384,0.34665>,<-0.1006,0.77375,0.34657>,
            <-0.10069,0.77371,0.34625>,
    /*5*/ <-0.10753,0.71779,0.34646>,<-0.10751,0.71779,0.34656>,<-0.10741,0.71777,0.34653>,
            <-0.10743,0.71778,0.34643>,
    /*6*/ <-0.10747,0.71778,0.34649>

    /* stem 0c4.14*/ 
    /*0*/ <-0.05378,0.9889,0.30898>,
    /*1*/ <-0.05352,0.98901,0.30873>,<-0.05393,0.98924,0.30897>,<-0.05403,0.98879,0.30923>,
            <-0.05362,0.98856,0.30898>,
    /*2*/ <-0.08553,0.97419,0.2698>,<-0.08584,0.97437,0.27>,<-0.08592,0.97402,0.27019>,
            <-0.08561,0.97384,0.27>,
    /*3*/ <-0.1148,0.95483,0.23073>,<-0.11504,0.95495,0.23085>,<-0.11509,0.9547,0.23101>,
            <-0.11485,0.95458,0.23089>,
    /*4*/ <-0.13605,0.924,0.1939>,<-0.13621,0.92406,0.19394>,<-0.13622,0.92393,0.19406>,
            <-0.13606,0.92387,0.19401>,
    /*5*/ <-0.14681,0.88301,0.16287>,<-0.14687,0.88302,0.16288>,<-0.14687,0.88298,0.16292>,
            <-0.14681,0.88298,0.16291>,
    /*6*/ <-0.14684,0.883,0.1629>

    /* stem 0c4.15*/ 
    /*0*/ <-0.05829,1.02978,0.32255>,
    /*1*/ <-0.05829,1.02973,0.3227>,<-0.05817,1.02987,0.32258>,<-0.0583,1.02983,0.3224>,
            <-0.05842,1.02968,0.32252>,
    /*2*/ <-0.02622,0.99322,0.31006>,<-0.02613,0.99334,0.30997>,<-0.02622,0.9933,0.30983>,
            <-0.02632,0.99319,0.30992>,
    /*3*/ <0.00324,0.95425,0.29852>,<0.00331,0.95432,0.29845>,<0.00324,0.9543,0.29835>,
            <0.00317,0.95422,0.29842>,
    /*4*/ <0.02375,0.91134,0.2824>,<0.02379,0.91138,0.28235>,<0.02375,0.91137,0.2823>,
            <0.0237,0.91134,0.28234>,
    /*5*/ <0.0317,0.86488,0.2651>,<0.03171,0.86489,0.26509>,<0.0317,0.86489,0.26507>,
            <0.03168,0.86488,0.26509>,
    /*6*/ <0.0317,0.86488,0.26509>

    /* stem 0c5*/ 
    /*0*/ <0,0.11335,0>,
    /*1*/ <-0.00143,0.11346,-0.0049>,<0.00457,0.11521,-0.00129>,<0.00143,0.11325,0.0049>,
            <-0.00457,0.1115,0.00129>,
    /*2*/ <-0.04026,0.219,0.00935>,<-0.03493,0.22055,0.01255>,<-0.03773,0.21881,0.01805>,
            <-0.04306,0.21725,0.01485>,
    /*3*/ <-0.06666,0.32873,0.01989>,<-0.06185,0.32964,0.02265>,<-0.06444,0.32857,0.02751>,
            <-0.06924,0.32766,0.02476>,
    /*4*/ <-0.07927,0.44122,0.02352>,<-0.07508,0.44163,0.02585>,<-0.07738,0.44125,0.03006>,
            <-0.08157,0.44084,0.02773>,
    /*5*/ <-0.07634,0.55457,0.02386>,<-0.07284,0.55449,0.0258>,<-0.07478,0.55454,0.02931>,
            <-0.07828,0.55462,0.02737>,
    /*6*/ <-0.0831,0.66768,0.02664>,<-0.0803,0.66782,0.0282>,<-0.08185,0.66767,0.031>,
            <-0.08465,0.66753,0.02945>,
    /*7*/ <-0.09552,0.78027,0.03103>,<-0.09343,0.78046,0.03219>,<-0.09458,0.78026,0.03429>,
            <-0.09668,0.78007,0.03313>,
    /*8*/ <-0.10876,0.89256,0.03988>,<-0.10736,0.89267,0.04066>,<-0.10812,0.89248,0.04205>,
            <-0.10952,0.89237,0.04128>,
    /*9*/ <-0.13307,1.00295,0.0479>,<-0.13238,1.00307,0.04829>,<-0.13276,1.00294,0.04899>,
            <-0.13345,1.00282,0.04859>,
    /*10*/ <-0.16622,1.11128,0.05015>

    /* stem 0c5.0*/ 
    /*0*/ <-0.04653,0.25006,0.01654>,
    /*1*/ <-0.04837,0.2496,0.01679>,<-0.04673,0.2515,0.01778>,<-0.0447,0.25053,0.01629>,
            <-0.04634,0.24863,0.0153>,
    /*2*/ <-0.02349,0.19136,0.08799>,<-0.02223,0.19283,0.08876>,<-0.02065,0.19208,0.0876>,
            <-0.02192,0.19061,0.08683>,
    /*3*/ <-0.00314,0.13066,0.15846>,<-0.00222,0.13166,0.15906>,<-0.0011,0.1311,0.15827>,
            <-0.00202,0.13011,0.15767>,
    /*4*/ <0.01765,0.05783,0.21627>,<0.01822,0.05834,0.2167>,<0.01886,0.05809,0.21616>,
            <0.01829,0.05758,0.21572>,
    /*5*/ <0.03642,-0.02942,0.24959>,<0.03661,-0.02932,0.24975>,<0.03679,-0.02935,0.24956>,
            <0.0366,-0.02946,0.2494>,
    /*6*/ <0.0366,-0.02939,0.24957>

    /* stem 0c5.1*/ 
    /*0*/ <-0.06222,0.31488,0.02245>,
    /*1*/ <-0.06189,0.31513,0.02066>,<-0.06383,0.31573,0.02226>,<-0.06255,0.31464,0.02424>,
            <-0.0606,0.31404,0.02263>,
    /*2*/ <-0.102,0.23463,0.00274>,<-0.10351,0.2351,0.00398>,<-0.10252,0.23425,0.00551>,
            <-0.10101,0.23379,0.00427>,
    /*3*/ <-0.13509,0.15082,-0.01434>,<-0.1362,0.15108,-0.01347>,<-0.13545,0.15056,-0.01237>,
            <-0.13435,0.1503,-0.01324>,
    /*4*/ <-0.14401,0.06028,-0.026>,<-0.1447,0.06028,-0.02552>,<-0.14423,0.06015,-0.02484>,
            <-0.14354,0.06014,-0.02532>,
    /*5*/ <-0.13087,-0.0299,-0.03607>,<-0.13108,-0.02995,-0.03593>,<-0.13093,-0.02995,-0.03572>,
            <-0.13072,-0.02991,-0.03586>,
    /*6*/ <-0.1309,-0.02993,-0.03589>

    /* stem 0c5.2*/ 
    /*0*/ <-0.06712,0.34252,0.02408>,
    /*1*/ <-0.06587,0.34263,0.02538>,<-0.06729,0.34432,0.02409>,<-0.06837,0.34241,0.02279>,
            <-0.06696,0.34072,0.02407>,
    /*2*/ <-0.00172,0.34892,-0.03772>,<-0.00282,0.35023,-0.03871>,<-0.00366,0.34876,-0.03972>,
            <-0.00256,0.34745,-0.03873>,
    /*3*/ <0.06419,0.34608,-0.09918>,<0.0635,0.34701,-0.09997>,<0.06285,0.34597,-0.10063>,
            <0.06354,0.34504,-0.09984>,
    /*4*/ <0.12376,0.31914,-0.16142>,<0.12344,0.31968,-0.16196>,<0.12291,0.3191,-0.16222>,
            <0.12323,0.31856,-0.16168>,
    /*5*/ <0.17427,0.26806,-0.216>,<0.1742,0.26821,-0.2162>,<0.174,0.26805,-0.21624>,
            <0.17407,0.26791,-0.21604>,
    /*6*/ <0.17413,0.26806,-0.21612>

    /* stem 0c5.3*/ 
    /*0*/ <-0.07119,0.37835,0.02507>,
    /*1*/ <-0.07288,0.37817,0.02461>,<-0.07133,0.3801,0.02489>,<-0.06949,0.37853,0.02552>,
            <-0.07105,0.3766,0.02524>,
    /*2*/ <-0.09617,0.38466,0.1095>,<-0.09497,0.38615,0.10972>,<-0.09354,0.38494,0.11021>,
            <-0.09475,0.38344,0.10999>,
    /*3*/ <-0.11774,0.38342,0.1951>,<-0.11691,0.38449,0.19533>,<-0.11587,0.38362,0.19558>,
            <-0.11671,0.38255,0.19535>,
    /*4*/ <-0.14311,0.3575,0.27548>,<-0.14267,0.35809,0.27582>,<-0.14203,0.35759,0.27586>,
            <-0.14247,0.357,0.27553>,
    /*5*/ <-0.16179,0.31038,0.34776>,<-0.16167,0.31054,0.3479>,<-0.16146,0.31041,0.34787>,
            <-0.16158,0.31025,0.34773>,
    /*6*/ <-0.16163,0.31039,0.34782>

    /* stem 0c5.4*/ 
    /*0*/ <-0.07686,0.42836,0.02644>,
    /*1*/ <-0.07592,0.4285,0.02502>,<-0.07735,0.42999,0.02628>,<-0.07781,0.42821,0.02786>,
            <-0.07637,0.42672,0.02659>,
    /*2*/ <-0.1431,0.40377,-0.02186>,<-0.14421,0.40492,-0.02089>,<-0.14457,0.40354,-0.01966>,
            <-0.14345,0.40239,-0.02064>,
    /*3*/ <-0.21013,0.3685,-0.06191>,<-0.21096,0.36931,-0.06124>,<-0.21106,0.3684,-0.06027>,
            <-0.21024,0.36759,-0.06094>,
    /*4*/ <-0.27077,0.31832,-0.0956>,<-0.27132,0.31876,-0.09524>,<-0.27129,0.31829,-0.09461>,
            <-0.27073,0.31785,-0.09497>,
    /*5*/ <-0.31909,0.25416,-0.12509>,<-0.31928,0.25427,-0.125>,<-0.31925,0.25415,-0.12479>,
            <-0.31905,0.25404,-0.12488>,
    /*6*/ <-0.31917,0.25415,-0.12494>

    /* stem 0c5.5*/ 
    /*0*/ <-0.07748,0.47588,0.02673>,
    /*1*/ <-0.0765,0.47586,0.02807>,<-0.07725,0.47752,0.02658>,<-0.07846,0.4759,0.02538>,
            <-0.07771,0.47424,0.02687>,
    /*2*/ <-0.01063,0.46239,-0.02065>,<-0.01121,0.46368,-0.0218>,<-0.01215,0.46242,-0.02273>,
            <-0.01157,0.46114,-0.02158>,
    /*3*/ <0.05393,0.44178,-0.06862>,<0.05358,0.44267,-0.06948>,<0.05285,0.4418,-0.0701>,
            <0.0532,0.44091,-0.06924>,
    /*4*/ <0.11339,0.40238,-0.11109>,<0.11329,0.40286,-0.11167>,<0.11277,0.40239,-0.11197>,
            <0.11287,0.40191,-0.11138>,
    /*5*/ <0.16367,0.34408,-0.1421>,<0.16367,0.34419,-0.14231>,<0.16349,0.34407,-0.14238>,
            <0.16348,0.34396,-0.14217>,
    /*6*/ <0.16358,0.34408,-0.14224>

    /* stem 0c5.6*/ 
    /*0*/ <-0.07642,0.51917,0.02665>,
    /*1*/ <-0.07803,0.51921,0.02647>,<-0.07633,0.52071,0.02616>,<-0.07482,0.51913,0.02682>,
            <-0.07652,0.51764,0.02714>,
    /*2*/ <-0.0855,0.54416,0.10287>,<-0.08419,0.54532,0.10262>,<-0.08302,0.5441,0.10314>,
            <-0.08433,0.54294,0.10338>,
    /*3*/ <-0.09782,0.56094,0.18078>,<-0.09691,0.5618,0.18074>,<-0.09607,0.56092,0.18107>,
            <-0.09699,0.56006,0.1811>,
    /*4*/ <-0.11289,0.55638,0.25991>,<-0.11238,0.5569,0.26004>,<-0.11186,0.55637,0.26011>,
            <-0.11238,0.55585,0.25998>,
    /*5*/ <-0.12758,0.53188,0.3354>,<-0.12743,0.53204,0.33548>,<-0.12726,0.53188,0.33546>,
            <-0.12742,0.53173,0.33538>,
    /*6*/ <-0.12742,0.53188,0.33543>

    /* stem 0c5.7*/ 
    /*0*/ <-0.07687,0.57607,0.02701>,
    /*1*/ <-0.07665,0.57611,0.02547>,<-0.07777,0.57733,0.02691>,<-0.0771,0.57602,0.02855>,
            <-0.07598,0.5748,0.02711>,
    /*2*/ <-0.13905,0.531,0.01531>,<-0.13992,0.53194,0.01643>,<-0.1394,0.53093,0.01769>,
            <-0.13853,0.52999,0.01657>,
    /*3*/ <-0.19731,0.48059,0.00546>,<-0.19798,0.48122,0.00624>,<-0.19756,0.48054,0.00715>,
            <-0.19688,0.47992,0.00636>,
    /*4*/ <-0.23855,0.4161,-0.00731>,<-0.23906,0.41634,-0.00687>,<-0.23874,0.41602,-0.00632>,
            <-0.23823,0.41578,-0.00676>,
    /*5*/ <-0.26227,0.34276,-0.01684>,<-0.26245,0.3428,-0.01671>,<-0.26233,0.34274,-0.01654>,
            <-0.26216,0.3427,-0.01667>,
    /*6*/ <-0.2623,0.34275,-0.01669>

    /* stem 0c5.8*/ 
    /*0*/ <-0.08143,0.65056,0.02848>,
    /*1*/ <-0.08017,0.65062,0.02925>,<-0.0818,0.65189,0.02899>,<-0.08268,0.6505,0.02772>,
            <-0.08105,0.64923,0.02797>,
    /*2*/ <-0.04683,0.6821,-0.02841>,<-0.04809,0.68308,-0.02861>,<-0.04878,0.682,-0.0296>,
            <-0.04751,0.68102,-0.0294>,
    /*3*/ <-0.01184,0.70668,-0.08841>,<-0.0127,0.70741,-0.08862>,<-0.01322,0.70661,-0.08925>,
            <-0.01236,0.70588,-0.08904>,
    /*4*/ <0.02849,0.7079,-0.15001>,<0.02807,0.70836,-0.15028>,<0.0277,0.70786,-0.15054>,
            <0.02812,0.7074,-0.15027>,
    /*5*/ <0.06893,0.69292,-0.20975>,<0.06882,0.69306,-0.20986>,<0.06868,0.69291,-0.20991>,
            <0.0688,0.69277,-0.2098>,
    /*6*/ <0.06881,0.69292,-0.20983>

    /* stem 0c5.9*/ 
    /*0*/ <-0.08624,0.70134,0.02997>,
    /*1*/ <-0.08751,0.70118,0.03058>,<-0.08589,0.70231,0.03095>,<-0.08496,0.70151,0.02936>,
            <-0.08658,0.70038,0.02899>,
    /*2*/ <-0.06095,0.64981,0.07167>,<-0.05969,0.65068,0.07196>,<-0.05897,0.65006,0.07073>,
            <-0.06023,0.64919,0.07044>,
    /*3*/ <-0.0348,0.59302,0.10526>,<-0.03388,0.59358,0.10551>,<-0.03342,0.59323,0.10457>,
            <-0.03433,0.59267,0.10432>,
    /*4*/ <-0.01748,0.52733,0.1256>,<-0.01689,0.52755,0.1258>,<-0.01665,0.52742,0.12521>,
            <-0.01723,0.52721,0.12501>,
    /*5*/ <-0.00628,0.45776,0.13379>,<-0.00609,0.4578,0.13386>,<-0.00602,0.45779,0.13367>,
            <-0.00621,0.45775,0.1336>,
    /*6*/ <-0.00615,0.45778,0.13373>

    /* stem 0c5.10*/ 
    /*0*/ <-0.09198,0.75272,0.03172>,
    /*1*/ <-0.09136,0.75283,0.03051>,<-0.09192,0.75407,0.03187>,<-0.09259,0.75261,0.03293>,
            <-0.09203,0.75136,0.03157>,
    /*2*/ <-0.15226,0.75848,0.00039>,<-0.1527,0.75945,0.00144>,<-0.15321,0.75831,0.00226>,
            <-0.15278,0.75735,0.00121>,
    /*3*/ <-0.2111,0.76198,-0.03373>,<-0.21148,0.76266,-0.03302>,<-0.21186,0.76186,-0.03244>,
            <-0.21149,0.76117,-0.03316>,
    /*4*/ <-0.26808,0.74757,-0.06829>,<-0.26841,0.74797,-0.06792>,<-0.26853,0.7475,-0.06752>,
            <-0.26821,0.7471,-0.06789>,
    /*5*/ <-0.31828,0.71462,-0.10058>,<-0.31841,0.71473,-0.10049>,<-0.31842,0.7146,-0.10035>,
            <-0.31829,0.71449,-0.10044>,
    /*6*/ <-0.31835,0.71461,-0.10046>

    /* stem 0c5.11*/ 
    /*0*/ <-0.09906,0.81387,0.03515>,
    /*1*/ <-0.09843,0.81386,0.03628>,<-0.09933,0.81512,0.03531>,<-0.09969,0.81388,0.03401>,
            <-0.09879,0.81261,0.03499>,
    /*2*/ <-0.04353,0.82974,0.00558>,<-0.04423,0.83072,0.00482>,<-0.0445,0.82975,0.00382>,
            <-0.0438,0.82877,0.00457>,
    /*3*/ <0.01406,0.83994,-0.02237>,<0.01366,0.84065,-0.02295>,<0.01344,0.83996,-0.02366>,
            <0.01385,0.83924,-0.02307>,
    /*4*/ <0.07334,0.83176,-0.04733>,<0.07323,0.83218,-0.04773>,<0.07302,0.83176,-0.04811>,
            <0.07313,0.83134,-0.0477>,
    /*5*/ <0.12965,0.80947,-0.0706>,<0.12964,0.80959,-0.07073>,<0.12955,0.80947,-0.07084>,
            <0.12956,0.80935,-0.0707>,
    /*6*/ <0.1296,0.80947,-0.07072>

    /* stem 0c5.12*/ 
    /*0*/ <-0.10409,0.85607,0.03827>,
    /*1*/ <-0.1053,0.85595,0.03796>,<-0.10392,0.85686,0.03731>,<-0.10289,0.85619,0.03859>,
            <-0.10426,0.85528,0.03923>,
    /*2*/ <-0.11954,0.90426,0.07512>,<-0.11848,0.90497,0.07463>,<-0.11767,0.90445,0.07561>,
            <-0.11874,0.90375,0.07611>,
    /*3*/ <-0.13773,0.95098,0.11251>,<-0.13699,0.95153,0.1122>,<-0.13643,0.95118,0.11291>,
            <-0.13717,0.95063,0.11323>,
    /*4*/ <-0.15777,0.9864,0.16007>,<-0.15736,0.98679,0.15996>,<-0.157,0.98652,0.16032>,
            <-0.15741,0.98613,0.16043>,
    /*5*/ <-0.17855,1.01106,0.21372>,<-0.17843,1.01119,0.21371>,<-0.17831,1.0111,0.2138>,
            <-0.17843,1.01097,0.21381>,
    /*6*/ <-0.17843,1.01108,0.21376>

    /* stem 0c5.13*/ 
    /*0*/ <-0.11705,0.93136,0.0436>,
    /*1*/ <-0.11636,0.93155,0.04299>,<-0.11765,0.93182,0.04305>,<-0.11774,0.93117,0.0442>,
            <-0.11644,0.93091,0.04414>,
    /*2*/ <-0.12784,0.88189,0.01429>,<-0.12884,0.8821,0.01433>,<-0.12891,0.8816,0.01522>,
            <-0.1279,0.88139,0.01518>,
    /*3*/ <-0.13634,0.82991,-0.01116>,<-0.13706,0.83001,-0.01114>,<-0.1371,0.8297,-0.01049>,
            <-0.13638,0.82959,-0.0105>,
    /*4*/ <-0.13496,0.7736,-0.02696>,<-0.13539,0.77359,-0.02698>,<-0.13541,0.77348,-0.02657>,
            <-0.13498,0.77348,-0.02655>,
    /*5*/ <-0.12386,0.71626,-0.03034>,<-0.12399,0.71624,-0.03035>,<-0.124,0.71623,-0.03022>,
            <-0.12387,0.71625,-0.03021>,
    /*6*/ <-0.12393,0.71624,-0.03028>

    /* stem 0c5.14*/ 
    /*0*/ <-0.12602,0.97184,0.04634>,
    /*1*/ <-0.12557,0.9719,0.0469>,<-0.12591,0.97254,0.04617>,<-0.12647,0.97178,0.04577>,
            <-0.12613,0.97114,0.0465>,
    /*2*/ <-0.0823,0.95725,0.01404>,<-0.08256,0.95774,0.01347>,<-0.083,0.95715,0.01316>,
            <-0.08274,0.95666,0.01373>,
    /*3*/ <-0.03838,0.93915,-0.01608>,<-0.03853,0.93949,-0.01651>,<-0.03885,0.93907,-0.01673>,
            <-0.03869,0.93873,-0.0163>,
    /*4*/ <0.00262,0.91104,-0.04246>,<0.00257,0.91122,-0.04274>,<0.00234,0.91099,-0.04284>,
            <0.0024,0.91081,-0.04256>,
    /*5*/ <0.03432,0.86827,-0.0607>,<0.03432,0.8683,-0.0608>,<0.03423,0.86825,-0.06082>,
            <0.03423,0.86821,-0.06072>,
    /*6*/ <0.03427,0.86826,-0.06076>

    /* stem 0c5.15*/ 
    /*0*/ <-0.14153,1.03098,0.04888>,
    /*1*/ <-0.14189,1.03087,0.04908>,<-0.14168,1.03137,0.04883>,<-0.14118,1.0311,0.04869>,
            <-0.14139,1.0306,0.04893>,
    /*2*/ <-0.12087,1.04482,0.09568>,<-0.12071,1.04521,0.0955>,<-0.12032,1.04499,0.09538>,
            <-0.12048,1.0446,0.09557>,
    /*3*/ <-0.0983,1.05353,0.14283>,<-0.09817,1.05381,0.14272>,<-0.0979,1.05366,0.14262>,
            <-0.09803,1.05338,0.14273>,
    /*4*/ <-0.07293,1.0496,0.1892>,<-0.07284,1.04977,0.18916>,<-0.0727,1.04968,0.18908>,
            <-0.07279,1.04951,0.18911>,
    /*5*/ <-0.0435,1.03114,0.22922>,<-0.04346,1.03119,0.22922>,<-0.04343,1.03116,0.22918>,
            <-0.04346,1.03111,0.22918>,
    /*6*/ <-0.04346,1.03115,0.2292>

    /* stem 0c5.16*/ 
    /*0*/ <-0.15915,1.0883,0.04979>,
    /*1*/ <-0.15911,1.08832,0.04968>,<-0.15912,1.08841,0.04982>,<-0.1592,1.08829,0.04989>,
            <-0.15919,1.08819,0.04975>,
    /*2*/ <-0.20219,1.10768,0.03393>,<-0.2022,1.10776,0.03404>,<-0.20226,1.10766,0.0341>,
            <-0.20225,1.10759,0.03399>,
    /*3*/ <-0.24643,1.12313,0.01711>,<-0.24644,1.12318,0.01718>,<-0.24649,1.12311,0.01723>,
            <-0.24648,1.12305,0.01715>,
    /*4*/ <-0.29228,1.12586,-0.00211>,<-0.2923,1.12589,-0.00207>,<-0.29231,1.12585,-0.00204>,
            <-0.2923,1.12581,-0.00208>,
    /*5*/ <-0.33779,1.11692,-0.02023>,<-0.3378,1.11693,-0.02022>,<-0.3378,1.11692,-0.02021>,
            <-0.33779,1.11691,-0.02022>,
    /*6*/ <-0.3378,1.11692,-0.02022>

    /* stem 0c6*/ 
    /*0*/ <0,0.11335,0>,
    /*1*/ <0.00226,0.11313,-0.00457>,<0.00377,0.11633,0.00172>,<-0.00226,0.11358,0.00457>,
            <-0.00377,0.11038,-0.00172>,
    /*2*/ <-0.05545,0.20513,-0.03703>,<-0.05411,0.20797,-0.03144>,<-0.05948,0.20553,-0.02891>,
            <-0.06082,0.20269,-0.0345>,
    /*3*/ <-0.10253,0.30576,-0.0603>,<-0.10105,0.30765,-0.05523>,<-0.10595,0.30587,-0.05314>,
            <-0.10743,0.30398,-0.05821>,
    /*4*/ <-0.13658,0.41287,-0.07553>,<-0.13512,0.41398,-0.07109>,<-0.13947,0.41286,-0.06937>,
            <-0.14093,0.41175,-0.07382>,
    /*5*/ <-0.1465,0.52583,-0.07739>,<-0.14514,0.52603,-0.07363>,<-0.1489,0.52573,-0.07226>,
            <-0.15026,0.52554,-0.07602>,
    /*6*/ <-0.17113,0.63671,-0.07482>,<-0.17004,0.63689,-0.07181>,<-0.17298,0.63623,-0.0707>,
            <-0.17407,0.63604,-0.07371>,
    /*7*/ <-0.19625,0.74722,-0.07379>,<-0.19544,0.74739,-0.07153>,<-0.19765,0.74689,-0.0707>,
            <-0.19845,0.74672,-0.07296>,
    /*8*/ <-0.22998,0.85549,-0.07315>,<-0.22946,0.85565,-0.07165>,<-0.23089,0.85521,-0.0711>,
            <-0.23142,0.85504,-0.0726>,
    /*9*/ <-0.26557,0.96311,-0.07037>,<-0.2653,0.96318,-0.06962>,<-0.26601,0.96294,-0.06934>,
            <-0.26628,0.96287,-0.07009>,
    /*10*/ <-0.29882,1.07146,-0.07031>

    /* stem 0c6.0*/ 
    /*0*/ <-0.06512,0.22179,-0.03686>,
    /*1*/ <-0.06607,0.221,-0.03833>,<-0.06501,0.22344,-0.03783>,<-0.06417,0.22257,-0.03539>,
            <-0.06524,0.22013,-0.0359>,
    /*2*/ <-0.1491,0.24941,0.00064>,<-0.14827,0.2513,0.00103>,<-0.14762,0.25063,0.00292>,
            <-0.14845,0.24873,0.00253>,
    /*3*/ <-0.2322,0.27034,0.04395>,<-0.23169,0.27171,0.04427>,<-0.23115,0.27121,0.04557>,
            <-0.23165,0.26984,0.04525>,
    /*4*/ <-0.31407,0.27122,0.09405>,<-0.3139,0.27204,0.09432>,<-0.31348,0.27173,0.09502>,
            <-0.31364,0.2709,0.09476>,
    /*5*/ <-0.38751,0.24822,0.15147>,<-0.3875,0.24847,0.15159>,<-0.38732,0.24838,0.15177>,
            <-0.38733,0.24813,0.15166>,
    /*6*/ <-0.38741,0.2483,0.15162>

    /* stem 0c6.1*/ 
    /*0*/ <-0.09057,0.27645,-0.04978>,
    /*1*/ <-0.08895,0.27729,-0.04945>,<-0.09147,0.27795,-0.04915>,<-0.09219,0.27562,-0.05011>,
            <-0.08967,0.27496,-0.05041>,
    /*2*/ <-0.09015,0.31279,-0.13509>,<-0.0921,0.3133,-0.13486>,<-0.09266,0.3115,-0.13561>,
            <-0.09071,0.31099,-0.13584>,
    /*3*/ <-0.08972,0.34105,-0.22343>,<-0.0911,0.34143,-0.22332>,<-0.0915,0.34012,-0.22375>,
            <-0.09012,0.33973,-0.22386>,
    /*4*/ <-0.07501,0.35065,-0.31443>,<-0.07582,0.35091,-0.31454>,<-0.07606,0.3501,-0.31467>,
            <-0.07526,0.34984,-0.31456>,
    /*5*/ <-0.05464,0.3375,-0.40396>,<-0.05488,0.33758,-0.40402>,<-0.05497,0.33733,-0.40401>,
            <-0.05473,0.33725,-0.40394>,
    /*6*/ <-0.05481,0.33742,-0.40398>

    /* stem 0c6.2*/ 
    /*0*/ <-0.11577,0.34234,-0.06209>,
    /*1*/ <-0.11649,0.34235,-0.06047>,<-0.11571,0.34411,-0.06207>,<-0.11504,0.34233,-0.06371>,
            <-0.11582,0.34056,-0.0621>,
    /*2*/ <-0.03527,0.33949,-0.0245>,<-0.03466,0.34086,-0.02574>,<-0.03414,0.33948,-0.02701>,
            <-0.03475,0.33811,-0.02577>,
    /*3*/ <0.04471,0.32839,0.01259>,<0.04523,0.32935,0.01175>,<0.04554,0.32837,0.01082>,
            <0.04501,0.32741,0.01166>,
    /*4*/ <0.12004,0.29575,0.04665>,<0.12047,0.29628,0.04621>,<0.12052,0.29574,0.0456>,
            <0.12009,0.29521,0.04604>,
    /*5*/ <0.18111,0.2369,0.07327>,<0.18129,0.23704,0.07315>,<0.18125,0.2369,0.07294>,
            <0.18107,0.23677,0.07306>,
    /*6*/ <0.18118,0.2369,0.0731>

    /* stem 0c6.3*/ 
    /*0*/ <-0.13318,0.39752,-0.0702>,
    /*1*/ <-0.13398,0.39706,-0.07164>,<-0.13467,0.39809,-0.06955>,<-0.13238,0.39799,-0.06875>,
            <-0.1317,0.39696,-0.07084>,
    /*2*/ <-0.14887,0.31962,-0.03796>,<-0.1494,0.32042,-0.03634>,<-0.14763,0.32034,-0.03572>,
            <-0.1471,0.31954,-0.03734>,
    /*3*/ <-0.15231,0.23927,-0.00813>,<-0.1527,0.23973,-0.00694>,<-0.15143,0.23981,-0.00655>,
            <-0.15104,0.23936,-0.00774>,
    /*4*/ <-0.13888,0.1564,0.00917>,<-0.1391,0.15652,0.00992>,<-0.13835,0.15668,0.01011>,
            <-0.13813,0.15656,0.00936>,
    /*5*/ <-0.1078,0.07715,0.01968>,<-0.10786,0.07716,0.01991>,<-0.10764,0.07725,0.01997>,
            <-0.10758,0.07724,0.01973>,
    /*6*/ <-0.10772,0.0772,0.01982>

    /* stem 0c6.4*/ 
    /*0*/ <-0.1402,0.43828,-0.07299>,
    /*1*/ <-0.13855,0.43843,-0.07278>,<-0.14045,0.43937,-0.07175>,<-0.14185,0.43814,-0.07319>,
            <-0.13995,0.43719,-0.07423>,
    /*2*/ <-0.13761,0.50119,-0.12787>,<-0.13909,0.50193,-0.12707>,<-0.14017,0.50097,-0.12819>,
            <-0.1387,0.50023,-0.12899>,
    /*3*/ <-0.13556,0.55899,-0.18812>,<-0.1366,0.55957,-0.18761>,<-0.13737,0.55883,-0.18835>,
            <-0.13633,0.55825,-0.18886>,
    /*4*/ <-0.13156,0.59625,-0.26278>,<-0.13217,0.59668,-0.2626>,<-0.13263,0.59615,-0.2629>,
            <-0.13202,0.59572,-0.26308>,
    /*5*/ <-0.12736,0.61682,-0.34363>,<-0.12755,0.61696,-0.34361>,<-0.12769,0.61679,-0.34366>,
            <-0.12751,0.61664,-0.34369>,
    /*6*/ <-0.12753,0.6168,-0.34365>

    /* stem 0c6.5*/ 
    /*0*/ <-0.14555,0.5007,-0.0743>,
    /*1*/ <-0.14612,0.50069,-0.0728>,<-0.14447,0.50181,-0.07387>,<-0.14498,0.50072,-0.0758>,
            <-0.14663,0.4996,-0.07472>,
    /*2*/ <-0.09409,0.44264,-0.05408>,<-0.09281,0.44351,-0.05491>,<-0.09321,0.44267,-0.0564>,
            <-0.09449,0.4418,-0.05557>,
    /*3*/ <-0.04995,0.37753,-0.03863>,<-0.04897,0.37806,-0.03919>,<-0.04932,0.37755,-0.04028>,
            <-0.0503,0.37703,-0.03971>,
    /*4*/ <-0.02648,0.30097,-0.03424>,<-0.02583,0.30115,-0.03456>,<-0.02612,0.30102,-0.03522>,
            <-0.02676,0.30084,-0.03491>,
    /*5*/ <-0.02076,0.22113,-0.03051>,<-0.02056,0.22114,-0.0306>,<-0.02065,0.22112,-0.03081>,
            <-0.02086,0.22112,-0.03071>,
    /*6*/ <-0.02071,0.22113,-0.03066>

    /* stem 0c6.6*/ 
    /*0*/ <-0.15083,0.54001,-0.07456>,
    /*1*/ <-0.15217,0.53973,-0.07531>,<-0.15158,0.54097,-0.07358>,<-0.14949,0.54029,-0.07381>,
            <-0.15009,0.53905,-0.07554>,
    /*2*/ <-0.16599,0.47992,-0.02712>,<-0.16553,0.48088,-0.02578>,<-0.16391,0.48035,-0.02596>,
            <-0.16438,0.47939,-0.0273>,
    /*3*/ <-0.17874,0.41417,0.01282>,<-0.17843,0.41473,0.01385>,<-0.17728,0.4144,0.01369>,
            <-0.17758,0.41384,0.01266>,
    /*4*/ <-0.18406,0.34159,0.041>,<-0.18389,0.34183,0.04165>,<-0.1832,0.34173,0.04151>,
            <-0.18337,0.34149,0.04086>,
    /*5*/ <-0.17956,0.26405,0.0483>,<-0.17951,0.26407,0.04852>,<-0.1793,0.26407,0.04846>,
            <-0.17935,0.26405,0.04825>,
    /*6*/ <-0.17943,0.26406,0.04838>

    /* stem 0c6.7*/ 
    /*0*/ <-0.16625,0.61006,-0.07325>,
    /*1*/ <-0.16481,0.61038,-0.07348>,<-0.16659,0.6115,-0.07338>,<-0.16768,0.60974,-0.07303>,
            <-0.1659,0.60863,-0.07312>,
    /*2*/ <-0.17456,0.60134,-0.14648>,<-0.17593,0.60221,-0.14641>,<-0.17678,0.60085,-0.14613>,
            <-0.1754,0.59998,-0.1462>,
    /*3*/ <-0.18181,0.5856,-0.21862>,<-0.1828,0.5862,-0.21865>,<-0.18339,0.58525,-0.21839>,
            <-0.1824,0.58465,-0.21835>,
    /*4*/ <-0.1839,0.5513,-0.28438>,<-0.18449,0.55161,-0.28452>,<-0.18483,0.55109,-0.28424>,
            <-0.18424,0.55078,-0.2841>,
    /*5*/ <-0.18007,0.50014,-0.33799>,<-0.18025,0.50021,-0.33807>,<-0.18036,0.50008,-0.33795>,
            <-0.18018,0.50001,-0.33787>,
    /*6*/ <-0.18021,0.50011,-0.33797>

    /* stem 0c6.8*/ 
    /*0*/ <-0.17981,0.67093,-0.0726>,
    /*1*/ <-0.18012,0.67085,-0.07122>,<-0.17885,0.67193,-0.07233>,<-0.1795,0.67101,-0.07398>,
            <-0.18078,0.66993,-0.07287>,
    /*2*/ <-0.13045,0.62096,-0.06315>,<-0.12946,0.62179,-0.06401>,<-0.12997,0.62108,-0.06529>,
            <-0.13096,0.62024,-0.06443>,
    /*3*/ <-0.08527,0.56631,-0.06106>,<-0.08455,0.56688,-0.06167>,<-0.085,0.56647,-0.06259>,
            <-0.08572,0.5659,-0.06199>,
    /*4*/ <-0.05383,0.50284,-0.06385>,<-0.05335,0.50309,-0.06421>,<-0.05368,0.50295,-0.06476>,
            <-0.05416,0.5027,-0.0644>,
    /*5*/ <-0.03965,0.43383,-0.07159>,<-0.03949,0.43388,-0.07171>,<-0.0396,0.43387,-0.07187>,
            <-0.03976,0.43383,-0.07176>,
    /*6*/ <-0.03963,0.43385,-0.07173>

    /* stem 0c6.9*/ 
    /*0*/ <-0.19216,0.72577,-0.07234>,
    /*1*/ <-0.19278,0.72564,-0.07354>,<-0.19255,0.72707,-0.07229>,<-0.19153,0.72591,-0.07114>,
            <-0.19177,0.72447,-0.0724>,
    /*2*/ <-0.24966,0.70716,-0.04146>,<-0.24948,0.70827,-0.04049>,<-0.24869,0.70737,-0.03961>,
            <-0.24887,0.70626,-0.04058>,
    /*3*/ <-0.30682,0.68238,-0.01477>,<-0.30679,0.68313,-0.01403>,<-0.30623,0.68248,-0.0134>,
            <-0.30625,0.68174,-0.01415>,
    /*4*/ <-0.35353,0.64301,0.01492>,<-0.35358,0.64342,0.01538>,<-0.35313,0.64312,0.01569>,
            <-0.35308,0.64271,0.01523>,
    /*5*/ <-0.38931,0.59124,0.0403>,<-0.38935,0.59135,0.04045>,<-0.38919,0.59127,0.04054>,
            <-0.38916,0.59117,0.04038>,
    /*6*/ <-0.38925,0.59126,0.04042>

    /* stem 0c6.10*/ 
    /*0*/ <-0.20121,0.76084,-0.07223>,
    /*1*/ <-0.19995,0.76123,-0.07221>,<-0.20145,0.76164,-0.07326>,<-0.20247,0.76046,-0.07224>,
            <-0.20098,0.76005,-0.0712>,
    /*2*/ <-0.18459,0.71215,-0.11345>,<-0.18575,0.71247,-0.11426>,<-0.18654,0.71155,-0.11348>,
            <-0.18539,0.71124,-0.11267>,
    /*3*/ <-0.16662,0.6633,-0.15384>,<-0.16743,0.66349,-0.15444>,<-0.16799,0.66283,-0.15389>,
            <-0.16718,0.66264,-0.15329>,
    /*4*/ <-0.14618,0.6049,-0.17657>,<-0.14662,0.6049,-0.17699>,<-0.14699,0.60462,-0.1766>,
            <-0.14655,0.60461,-0.17618>,
    /*5*/ <-0.12548,0.54319,-0.18705>,<-0.12561,0.54317,-0.18718>,<-0.12573,0.54311,-0.18706>,
            <-0.12561,0.54313,-0.18692>,
    /*6*/ <-0.12561,0.54315,-0.18705>

    /* stem 0c6.11*/ 
    /*0*/ <-0.21131,0.7935,-0.07219>,
    /*1*/ <-0.2121,0.79325,-0.07121>,<-0.21218,0.7943,-0.07269>,<-0.21052,0.79374,-0.07317>,
            <-0.21045,0.79269,-0.07169>,
    /*2*/ <-0.18617,0.84179,-0.03836>,<-0.18623,0.8426,-0.03951>,<-0.18495,0.84217,-0.03988>,
            <-0.18489,0.84136,-0.03873>,
    /*3*/ <-0.1577,0.88653,-0.00241>,<-0.1577,0.88716,-0.00319>,<-0.15681,0.88682,-0.00347>,
            <-0.1568,0.88619,-0.0027>,
    /*4*/ <-0.11583,0.91491,0.03699>,<-0.11577,0.91536,0.03661>,<-0.11532,0.91507,0.03635>,
            <-0.11538,0.91463,0.03673>,
    /*5*/ <-0.07064,0.93065,0.07961>,<-0.0706,0.9308,0.07951>,<-0.07048,0.9307,0.07942>,
            <-0.07052,0.93055,0.07951>,
    /*6*/ <-0.07056,0.93068,0.07951>

    /* stem 0c6.12*/ 
    /*0*/ <-0.2221,0.8284,-0.07215>,
    /*1*/ <-0.22223,0.82836,-0.07339>,<-0.22242,0.8296,-0.07216>,<-0.22198,0.82843,-0.07092>,
            <-0.22179,0.82719,-0.07215>,
    /*2*/ <-0.28198,0.81265,-0.06678>,<-0.28213,0.81361,-0.06582>,<-0.28179,0.81271,-0.06486>,
            <-0.28164,0.81175,-0.06582>,
    /*3*/ <-0.34062,0.79323,-0.06004>,<-0.34077,0.7939,-0.05935>,<-0.34049,0.79327,-0.05868>,
            <-0.34034,0.7926,-0.05936>,
    /*4*/ <-0.39311,0.76067,-0.05322>,<-0.39328,0.76103,-0.05281>,<-0.39303,0.7607,-0.05242>,
            <-0.39286,0.76034,-0.05283>,
    /*5*/ <-0.43452,0.71517,-0.04438>,<-0.43459,0.71526,-0.04425>,<-0.43448,0.71518,-0.04413>,
            <-0.43441,0.71509,-0.04426>,
    /*6*/ <-0.4345,0.71517,-0.04425>

    /* stem 0c6.13*/ 
    /*0*/ <-0.24228,0.89141,-0.07136>,
    /*1*/ <-0.24139,0.8917,-0.07122>,<-0.24235,0.89201,-0.07209>,<-0.24317,0.89113,-0.07151>,
            <-0.24221,0.89082,-0.07063>,
    /*2*/ <-0.22196,0.84969,-0.10715>,<-0.22271,0.84992,-0.10783>,<-0.22334,0.84924,-0.10738>,
            <-0.2226,0.849,-0.10669>,
    /*3*/ <-0.20203,0.80713,-0.14215>,<-0.20256,0.80729,-0.14264>,<-0.20301,0.80681,-0.14232>,
            <-0.20248,0.80665,-0.14183>,
    /*4*/ <-0.18083,0.75812,-0.16625>,<-0.18111,0.75816,-0.16657>,<-0.1814,0.75792,-0.16635>,
            <-0.18111,0.75788,-0.16602>,
    /*5*/ <-0.16059,0.7041,-0.17654>,<-0.16067,0.70409,-0.17665>,<-0.16077,0.70404,-0.17658>,
            <-0.16069,0.70404,-0.17647>,
    /*6*/ <-0.16068,0.70407,-0.17656>

    /* stem 0c6.14*/ 
    /*0*/ <-0.2602,0.94601,-0.07021>,
    /*1*/ <-0.26051,0.9459,-0.06965>,<-0.26025,0.94666,-0.07011>,<-0.25989,0.94613,-0.07078>,
            <-0.26016,0.94537,-0.07032>,
    /*2*/ <-0.21166,0.94475,-0.04328>,<-0.21146,0.94534,-0.04363>,<-0.21118,0.94493,-0.04416>,
            <-0.21139,0.94434,-0.0438>,
    /*3*/ <-0.16187,0.9405,-0.01904>,<-0.16171,0.94092,-0.01929>,<-0.16155,0.94063,-0.01967>,
            <-0.16171,0.94021,-0.01943>,
    /*4*/ <-0.11385,0.92237,0.00213>,<-0.11371,0.92261,0.002>,<-0.11366,0.92245,0.00175>,
            <-0.1138,0.92221,0.00188>,
    /*5*/ <-0.07203,0.89047,0.01988>,<-0.07197,0.89053,0.01985>,<-0.07196,0.89049,0.01976>,
            <-0.07202,0.89043,0.01979>,
    /*6*/ <-0.072,0.89048,0.01982>

    /* stem 0c6.15*/ 
    /*0*/ <-0.27751,1.00151,-0.07002>,
    /*1*/ <-0.27773,1.00145,-0.0703>,<-0.2777,1.00182,-0.06995>,<-0.2773,1.00158,-0.06973>,
            <-0.27733,1.00121,-0.07009>,
    /*2*/ <-0.31034,0.97445,-0.0394>,<-0.31032,0.97474,-0.03912>,<-0.31,0.97456,-0.03895>,
            <-0.31003,0.97427,-0.03923>,
    /*3*/ <-0.3412,0.94399,-0.00996>,<-0.34119,0.94419,-0.00975>,<-0.34096,0.94406,-0.00964>,
            <-0.34097,0.94387,-0.00984>,
    /*4*/ <-0.35969,0.90186,0.01516>,<-0.35971,0.90195,0.0153>,<-0.35955,0.90191,0.01535>,
            <-0.35954,0.90182,0.01521>,
    /*5*/ <-0.36584,0.85355,0.03454>,<-0.36585,0.85357,0.03459>,<-0.3658,0.85357,0.0346>,
            <-0.36579,0.85355,0.03455>,
    /*6*/ <-0.36582,0.85356,0.03457>

    /* stem 0c6.16*/ 
    /*0*/ <-0.29449,1.05725,-0.07025>,
    /*1*/ <-0.29442,1.05727,-0.07024>,<-0.29452,1.05731,-0.07022>,<-0.29456,1.05723,-0.07026>,
            <-0.29447,1.05719,-0.07029>,
    /*2*/ <-0.29509,1.08106,-0.11341>,<-0.29516,1.08109,-0.1134>,<-0.2952,1.08103,-0.11343>,
            <-0.29513,1.081,-0.11345>,
    /*3*/ <-0.29204,1.09816,-0.15955>,<-0.29209,1.09819,-0.15954>,<-0.29212,1.09814,-0.15956>,
            <-0.29206,1.09811,-0.15957>,
    /*4*/ <-0.28556,1.10628,-0.20774>,<-0.28559,1.10629,-0.20774>,<-0.2856,1.10627,-0.20775>,
            <-0.28557,1.10625,-0.20775>,
    /*5*/ <-0.27741,1.10265,-0.25623>,<-0.27742,1.10265,-0.25623>,<-0.27743,1.10264,-0.25623>,
            <-0.27742,1.10264,-0.25623>,
    /*6*/ <-0.27742,1.10264,-0.25623>

    /* stem 0c7*/ 
    /*0*/ <0,0.11335,0>,
    /*1*/ <0.00467,0.11337,-0.00206>,<0.00181,0.11573,0.00413>,<-0.00467,0.11334,0.00206>,
            <-0.00181,0.11097,-0.00413>,
    /*2*/ <-0.01739,0.21363,-0.05011>,<-0.01993,0.21574,-0.04461>,<-0.02569,0.21361,-0.04646>,
            <-0.02315,0.21151,-0.05196>,
    /*3*/ <-0.03467,0.31742,-0.09207>,<-0.03685,0.31907,-0.08717>,<-0.04195,0.31753,-0.08892>,
            <-0.03978,0.31589,-0.09383>,
    /*4*/ <-0.05142,0.42584,-0.12125>,<-0.05322,0.42676,-0.11688>,<-0.05763,0.42567,-0.11848>,
            <-0.05582,0.42475,-0.12284>,
    /*5*/ <-0.05799,0.53886,-0.12705>,<-0.05943,0.53898,-0.12331>,<-0.06316,0.53871,-0.12474>,
            <-0.06172,0.53859,-0.12848>,
    /*6*/ <-0.07646,0.65016,-0.13992>,<-0.07761,0.65033,-0.13693>,<-0.08056,0.64972,-0.13803>,
            <-0.07941,0.64956,-0.14102>,
    /*7*/ <-0.0972,0.75793,-0.16799>,<-0.09812,0.75833,-0.1658>,<-0.1003,0.75771,-0.1666>,
            <-0.09939,0.75731,-0.16879>,
    /*8*/ <-0.11643,0.86003,-0.21301>,<-0.11709,0.86052,-0.21163>,<-0.11853,0.86004,-0.21214>,
            <-0.11787,0.85954,-0.21352>,
    /*9*/ <-0.14596,0.95712,-0.26369>,<-0.14629,0.95738,-0.263>,<-0.14699,0.95706,-0.26322>,
            <-0.14666,0.9568,-0.2639>,
    /*10*/ <-0.18645,1.04704,-0.31967>

    /* stem 0c7.0*/ 
    /*0*/ <-0.02367,0.2268,-0.05364>,
    /*1*/ <-0.02317,0.22617,-0.05539>,<-0.02533,0.22746,-0.05435>,<-0.02417,0.22743,-0.05189>,
            <-0.02201,0.22614,-0.05293>,
    /*2*/ <-0.06487,0.14154,-0.03638>,<-0.06654,0.14254,-0.03558>,<-0.06564,0.14252,-0.03367>,
            <-0.06397,0.14152,-0.03448>,
    /*3*/ <-0.09781,0.05398,-0.01381>,<-0.09904,0.05459,-0.01321>,<-0.09836,0.05467,-0.01188>,
            <-0.09713,0.05406,-0.01248>,
    /*4*/ <-0.10588,-0.03854,0.01118>,<-0.10664,-0.03837,0.01158>,<-0.10621,-0.03821,0.01233>,
            <-0.10544,-0.03838,0.01193>,
    /*5*/ <-0.09014,-0.12872,0.04085>,<-0.09037,-0.12872,0.04099>,<-0.09024,-0.12862,0.04121>,
            <-0.09001,-0.12863,0.04107>,
    /*6*/ <-0.09019,-0.12867,0.04103>

    /* stem 0c7.1*/ 
    /*0*/ <-0.03488,0.29623,-0.08186>,
    /*1*/ <-0.03394,0.29695,-0.08045>,<-0.03521,0.29792,-0.08251>,<-0.03582,0.2955,-0.08327>,
            <-0.03455,0.29453,-0.08121>,
    /*2*/ <0.04341,0.293,-0.13044>,<0.04242,0.29375,-0.13204>,<0.04195,0.29188,-0.13263>,
            <0.04294,0.29113,-0.13104>,
    /*3*/ <0.12154,0.2819,-0.17812>,<0.1209,0.28243,-0.17929>,<0.12049,0.28111,-0.17966>,
            <0.12113,0.28058,-0.17849>,
    /*4*/ <0.19915,0.24771,-0.21426>,<0.19891,0.24798,-0.21503>,<0.19853,0.24724,-0.21517>,
            <0.19876,0.24697,-0.21441>,
    /*5*/ <0.27017,0.19263,-0.23477>,<0.27014,0.19269,-0.23502>,<0.26998,0.19248,-0.23505>,
            <0.27,0.19243,-0.23479>,
    /*6*/ <0.27007,0.19256,-0.23491>

    /* stem 0c7.2*/ 
    /*0*/ <-0.04368,0.35329,-0.10021>,
    /*1*/ <-0.04544,0.35305,-0.10014>,<-0.04393,0.35497,-0.10075>,<-0.04191,0.35354,-0.10028>,
            <-0.04342,0.35162,-0.09967>,
    /*2*/ <-0.04542,0.38027,-0.01547>,<-0.04426,0.38176,-0.01594>,<-0.04269,0.38065,-0.01558>,
            <-0.04386,0.37916,-0.01511>,
    /*3*/ <-0.05137,0.40261,0.07031>,<-0.05054,0.4037,0.07009>,<-0.04943,0.40291,0.07037>,
            <-0.05026,0.40183,0.07059>,
    /*4*/ <-0.05383,0.40229,0.15921>,<-0.05334,0.40295,0.15923>,<-0.05268,0.40247,0.15925>,
            <-0.05317,0.40181,0.15923>,
    /*5*/ <-0.05349,0.38001,0.24531>,<-0.05334,0.38021,0.24536>,<-0.05314,0.38006,0.24533>,
            <-0.05329,0.37987,0.24528>,
    /*6*/ <-0.05331,0.38004,0.24532>

    /* stem 0c7.3*/ 
    /*0*/ <-0.04896,0.38861,-0.10979>,
    /*1*/ <-0.04755,0.38855,-0.1108>,<-0.04832,0.39001,-0.10898>,<-0.05038,0.38868,-0.10878>,
            <-0.0496,0.38722,-0.1106>,
    /*2*/ <-0.08693,0.44014,-0.16867>,<-0.08753,0.44127,-0.16726>,<-0.08913,0.44024,-0.16711>,
            <-0.08852,0.43911,-0.16852>,
    /*3*/ <-0.12906,0.48574,-0.22957>,<-0.12952,0.48659,-0.22862>,<-0.13062,0.48581,-0.22846>,
            <-0.13015,0.48496,-0.22941>,
    /*4*/ <-0.1767,0.50996,-0.29816>,<-0.17706,0.51053,-0.29772>,<-0.17763,0.51001,-0.29751>,
            <-0.17727,0.50944,-0.29795>,
    /*5*/ <-0.2291,0.50894,-0.36758>,<-0.22923,0.50912,-0.36748>,<-0.22938,0.50896,-0.36737>,
            <-0.22924,0.50878,-0.36747>,
    /*6*/ <-0.22924,0.50895,-0.36748>

    /* stem 0c7.4*/ 
    /*0*/ <-0.05576,0.44889,-0.1211>,
    /*1*/ <-0.05563,0.44899,-0.11943>,<-0.05439,0.44984,-0.12126>,<-0.05589,0.4488,-0.12276>,
            <-0.05713,0.44794,-0.12093>,
    /*2*/ <-0.00789,0.38031,-0.11964>,<-0.00694,0.38097,-0.12105>,<-0.0081,0.38016,-0.12222>,
            <-0.00905,0.37949,-0.1208>,
    /*3*/ <0.03562,0.30914,-0.11459>,<0.03636,0.30952,-0.1156>,<0.03553,0.30895,-0.11642>,
            <0.03479,0.30857,-0.11542>,
    /*4*/ <0.06064,0.22981,-0.10604>,<0.06113,0.2299,-0.10662>,<0.06059,0.22967,-0.10712>,
            <0.0601,0.22958,-0.10653>,
    /*5*/ <0.06561,0.14683,-0.09676>,<0.06576,0.14682,-0.09694>,<0.06559,0.14679,-0.0971>,
            <0.06543,0.1468,-0.09692>,
    /*6*/ <0.0656,0.14681,-0.09693>

    /* stem 0c7.5*/ 
    /*0*/ <-0.05937,0.51623,-0.12469>,
    /*1*/ <-0.06085,0.51612,-0.12529>,<-0.05894,0.51714,-0.12594>,<-0.05789,0.51634,-0.1241>,
            <-0.0598,0.51533,-0.12345>,
    /*2*/ <-0.08166,0.58188,-0.0847>,<-0.08017,0.58267,-0.08521>,<-0.07936,0.58206,-0.08378>,
            <-0.08084,0.58127,-0.08328>,
    /*3*/ <-0.09841,0.64424,-0.03726>,<-0.09736,0.6448,-0.03762>,<-0.09674,0.64426,-0.03669>,
            <-0.09779,0.6437,-0.03632>,
    /*4*/ <-0.11997,0.68896,0.02551>,<-0.11939,0.6894,0.0254>,<-0.11899,0.68897,0.02584>,
            <-0.11957,0.68854,0.02595>,
    /*5*/ <-0.14535,0.7135,0.09733>,<-0.14518,0.71366,0.09733>,<-0.14504,0.71351,0.09743>,
            <-0.14521,0.71335,0.09743>,
    /*6*/ <-0.1452,0.7135,0.09738>

    /* stem 0c7.6*/ 
    /*0*/ <-0.06614,0.57326,-0.12995>,
    /*1*/ <-0.06531,0.57324,-0.13125>,<-0.06734,0.57384,-0.13072>,<-0.06696,0.57328,-0.12865>,
            <-0.06494,0.57268,-0.12918>,
    /*2*/ <-0.09047,0.50199,-0.14577>,<-0.09204,0.50246,-0.14536>,<-0.09175,0.50202,-0.14376>,
            <-0.09018,0.50156,-0.14416>,
    /*3*/ <-0.10885,0.42828,-0.15776>,<-0.10999,0.42851,-0.15749>,<-0.10977,0.42827,-0.15634>,
            <-0.10863,0.42803,-0.15662>,
    /*4*/ <-0.10603,0.35143,-0.15905>,<-0.10672,0.3514,-0.15891>,<-0.10657,0.35139,-0.15821>,
            <-0.10588,0.35142,-0.15836>,
    /*5*/ <-0.0879,0.27729,-0.14928>,<-0.08811,0.27724,-0.14923>,<-0.08807,0.27728,-0.14902>,
            <-0.08786,0.27733,-0.14907>,
    /*6*/ <-0.08798,0.27729,-0.14915>

    /* stem 0c7.7*/ 
    /*0*/ <-0.07277,0.61436,-0.13479>,
    /*1*/ <-0.07179,0.61465,-0.1337>,<-0.07268,0.61578,-0.13524>,<-0.07375,0.61408,-0.13588>,
            <-0.07286,0.61294,-0.13433>,
    /*2*/ <-0.01568,0.59634,-0.17948>,<-0.01637,0.59722,-0.18068>,<-0.0172,0.5959,-0.18117>,
            <-0.01651,0.59502,-0.17997>,
    /*3*/ <0.04017,0.57504,-0.22426>,<0.03971,0.57565,-0.22514>,<0.0391,0.57472,-0.22547>,
            <0.03956,0.57411,-0.22459>,
    /*4*/ <0.09216,0.53569,-0.26072>,<0.09198,0.536,-0.26131>,<0.09153,0.5355,-0.26143>,
            <0.0917,0.53519,-0.26084>,
    /*5*/ <0.13863,0.48191,-0.28361>,<0.13861,0.48197,-0.28381>,<0.13844,0.48184,-0.28384>,
            <0.13847,0.48177,-0.28364>,
    /*6*/ <0.13854,0.48187,-0.28373>

    /* stem 0c7.8*/ 
    /*0*/ <-0.0855,0.6872,-0.14875>,
    /*1*/ <-0.08689,0.68697,-0.14862>,<-0.08573,0.68859,-0.14883>,<-0.08411,0.68742,-0.14889>,
            <-0.08527,0.68581,-0.14868>,
    /*2*/ <-0.08068,0.69191,-0.07841>,<-0.07979,0.69317,-0.07857>,<-0.07853,0.69226,-0.07861>,
            <-0.07942,0.69101,-0.07845>,
    /*3*/ <-0.07464,0.69056,-0.00803>,<-0.074,0.69145,-0.00807>,<-0.07311,0.69081,-0.00815>,
            <-0.07375,0.68992,-0.00812>,
    /*4*/ <-0.06693,0.67091,0.05939>,<-0.06654,0.67142,0.05949>,<-0.06603,0.67106,0.05933>,
            <-0.06642,0.67055,0.05923>,
    /*5*/ <-0.05678,0.63461,0.11916>,<-0.05665,0.63475,0.11923>,<-0.0565,0.63466,0.11914>,
            <-0.05662,0.63452,0.11908>,
    /*6*/ <-0.05664,0.63463,0.11915>

    /* stem 0c7.9*/ 
    /*0*/ <-0.0931,0.7277,-0.15939>,
    /*1*/ <-0.09305,0.72736,-0.16071>,<-0.09332,0.729,-0.15973>,<-0.09315,0.72803,-0.15806>,
            <-0.09288,0.72639,-0.15904>,
    /*2*/ <-0.16048,0.71599,-0.16025>,<-0.16069,0.71727,-0.15949>,<-0.16056,0.71652,-0.1582>,
            <-0.16035,0.71524,-0.15896>,
    /*3*/ <-0.22536,0.69452,-0.15978>,<-0.22565,0.69539,-0.15924>,<-0.22548,0.69487,-0.15832>,
            <-0.22519,0.69401,-0.15886>,
    /*4*/ <-0.27943,0.65289,-0.15554>,<-0.27974,0.65333,-0.15521>,<-0.27951,0.65309,-0.15467>,
            <-0.2792,0.65265,-0.155>,
    /*5*/ <-0.31863,0.59793,-0.14454>,<-0.31875,0.59804,-0.14443>,<-0.31865,0.598,-0.14427>,
            <-0.31853,0.59789,-0.14438>,
    /*6*/ <-0.31864,0.59796,-0.1444>

    /* stem 0c7.10*/ 
    /*0*/ <-0.10191,0.77505,-0.17493>,
    /*1*/ <-0.10065,0.77538,-0.17472>,<-0.10212,0.77623,-0.17548>,<-0.10316,0.77473,-0.17514>,
            <-0.1017,0.77388,-0.17438>,
    /*2*/ <-0.08468,0.75083,-0.2335>,<-0.08582,0.75149,-0.23409>,<-0.08663,0.75033,-0.23383>,
            <-0.08549,0.74967,-0.23324>,
    /*3*/ <-0.06827,0.72194,-0.29015>,<-0.06906,0.72239,-0.29061>,<-0.06965,0.72159,-0.29038>,
            <-0.06885,0.72114,-0.28991>,
    /*4*/ <-0.05224,0.67751,-0.33581>,<-0.05267,0.67772,-0.33617>,<-0.05306,0.67733,-0.33592>,
            <-0.05262,0.67712,-0.33557>,
    /*5*/ <-0.03554,0.62268,-0.36786>,<-0.03567,0.62272,-0.368>,<-0.0358,0.62262,-0.3679>,
            <-0.03567,0.62259,-0.36777>,
    /*6*/ <-0.03567,0.62265,-0.36788>

    /* stem 0c7.11*/ 
    /*0*/ <-0.11419,0.84207,-0.20462>,
    /*1*/ <-0.11532,0.84208,-0.20412>,<-0.11437,0.8432,-0.20507>,<-0.11306,0.84206,-0.20512>,
            <-0.11401,0.84094,-0.20417>,
    /*2*/ <-0.09184,0.86634,-0.15248>,<-0.09111,0.86721,-0.15322>,<-0.09009,0.86632,-0.15325>,
            <-0.09082,0.86545,-0.15252>,
    /*3*/ <-0.06868,0.88297,-0.09779>,<-0.06812,0.88362,-0.09822>,<-0.06743,0.88297,-0.09831>,
            <-0.06799,0.88232,-0.09788>,
    /*4*/ <-0.04098,0.88047,-0.04267>,<-0.04062,0.88087,-0.04283>,<-0.04027,0.88047,-0.04303>,
            <-0.04063,0.88007,-0.04286>,
    /*5*/ <-0.01736,0.85957,0.01034>,<-0.01723,0.85969,0.01032>,<-0.01714,0.85957,0.01024>,
            <-0.01727,0.85946,0.01025>,
    /*6*/ <-0.01725,0.85957,0.01029>

    /* stem 0c7.12*/ 
    /*0*/ <-0.12475,0.88439,-0.22534>,
    /*1*/ <-0.12436,0.88406,-0.22619>,<-0.12441,0.8853,-0.22553>,<-0.12515,0.88471,-0.22449>,
            <-0.1251,0.88347,-0.22515>,
    /*2*/ <-0.17454,0.89716,-0.25453>,<-0.17459,0.89811,-0.25402>,<-0.17516,0.89766,-0.25322>,
            <-0.17512,0.8967,-0.25373>,
    /*3*/ <-0.22549,0.90253,-0.28395>,<-0.2256,0.90322,-0.28363>,<-0.22598,0.90289,-0.28304>,
            <-0.22586,0.9022,-0.28336>,
    /*4*/ <-0.27852,0.88903,-0.3063>,<-0.27868,0.88943,-0.30616>,<-0.2788,0.88924,-0.30577>,
            <-0.27864,0.88884,-0.30591>,
    /*5*/ <-0.32949,0.86513,-0.3243>,<-0.32956,0.86525,-0.32427>,<-0.32958,0.8652,-0.32414>,
            <-0.32951,0.86508,-0.32418>,
    /*6*/ <-0.32954,0.86517,-0.32422>

    /* stem 0c7.13*/ 
    /*0*/ <-0.14276,0.94466,-0.25693>,
    /*1*/ <-0.14221,0.94493,-0.25674>,<-0.1428,0.94509,-0.2574>,<-0.14331,0.94439,-0.25713>,
            <-0.14272,0.94423,-0.25646>,
    /*2*/ <-0.11392,0.91119,-0.29027>,<-0.11438,0.91132,-0.29079>,<-0.11477,0.91077,-0.29057>,
            <-0.11432,0.91065,-0.29006>,
    /*3*/ <-0.08537,0.87375,-0.31936>,<-0.08567,0.87382,-0.31974>,<-0.08597,0.87346,-0.31957>,
            <-0.08567,0.87339,-0.31918>,
    /*4*/ <-0.0613,0.82703,-0.33677>,<-0.06146,0.82704,-0.33702>,<-0.06167,0.82688,-0.33689>,
            <-0.06151,0.82687,-0.33664>,
    /*5*/ <-0.04175,0.77532,-0.33953>,<-0.04179,0.77531,-0.33961>,<-0.04186,0.77528,-0.33957>,
            <-0.04182,0.77529,-0.33949>,
    /*6*/ <-0.0418,0.7753,-0.33955>

    /* stem 0c7.14*/ 
    /*0*/ <-0.16086,0.98947,-0.28369>,
    /*1*/ <-0.16114,0.98949,-0.28346>,<-0.16098,0.98977,-0.28385>,<-0.16058,0.98945,-0.28392>,
            <-0.16075,0.98917,-0.28352>,
    /*2*/ <-0.1323,1.01861,-0.25083>,<-0.13217,1.01882,-0.25114>,<-0.13187,1.01858,-0.25119>,
            <-0.13199,1.01836,-0.25088>,
    /*3*/ <-0.10411,1.04306,-0.21409>,<-0.10401,1.04323,-0.21428>,<-0.10379,1.04304,-0.21432>,
            <-0.1039,1.04287,-0.21413>,
    /*4*/ <-0.0709,1.05591,-0.17566>,<-0.07082,1.05602,-0.17576>,<-0.07072,1.0559,-0.17581>,
            <-0.07079,1.05579,-0.17571>,
    /*5*/ <-0.03919,1.05739,-0.13399>,<-0.03916,1.05743,-0.13402>,<-0.03913,1.05739,-0.13404>,
            <-0.03916,1.05735,-0.13401>,
    /*6*/ <-0.03916,1.05739,-0.13402>

    /* stem 0c7.15*/ 
    /*0*/ <-0.18097,1.03472,-0.31197>,
    /*1*/ <-0.18095,1.03468,-0.31204>,<-0.18097,1.03479,-0.31201>,<-0.18099,1.03475,-0.3119>,
            <-0.18097,1.03465,-0.31194>,
    /*2*/ <-0.22906,1.02887,-0.32128>,<-0.22908,1.02895,-0.32126>,<-0.22909,1.02892,-0.32118>,
            <-0.22908,1.02884,-0.3212>,
    /*3*/ <-0.27692,1.01951,-0.32878>,<-0.27693,1.01956,-0.32877>,<-0.27694,1.01954,-0.32871>,
            <-0.27692,1.01949,-0.32873>,
    /*4*/ <-0.32218,0.99991,-0.32996>,<-0.32219,0.99995,-0.32995>,<-0.32219,0.99994,-0.32992>,
            <-0.32218,0.99991,-0.32993>,
    /*5*/ <-0.36071,0.96966,-0.3241>,<-0.36071,0.96967,-0.3241>,<-0.36071,0.96967,-0.32409>,
            <-0.3607,0.96966,-0.32409>,
    /*6*/ <-0.36071,0.96966,-0.3241>

    /* stem 0.0*/ 
    /*0*/ <0.00125,0.26291,0.02711>,
    /*1*/ <0.00089,0.26243,0.02891>,<0.00148,0.26472,0.02763>,<0.00161,0.2634,0.0253>,
            <0.00102,0.26111,0.02658>,
    /*2*/ <0.09348,0.24665,0.04267>,<0.09393,0.24842,0.04169>,<0.09403,0.24739,0.03988>,
            <0.09358,0.24562,0.04087>,
    /*3*/ <0.18536,0.22719,0.05634>,<0.18573,0.22844,0.05565>,<0.18578,0.22771,0.05436>,
            <0.1854,0.22646,0.05505>,
    /*4*/ <0.27103,0.18669,0.06218>,<0.27139,0.18738,0.06179>,<0.27126,0.187,0.06102>,
            <0.27091,0.18631,0.06141>,
    /*5*/ <0.34585,0.12828,0.06279>,<0.346,0.12847,0.06267>,<0.34592,0.12838,0.06243>,
            <0.34578,0.12819,0.06255>,
    /*6*/ <0.34589,0.12833,0.06261>

    /* stem 0.1*/ 
    /*0*/ <0.00397,0.31819,0.04243>,
    /*1*/ <0.00287,0.31864,0.04102>,<0.00402,0.31996,0.04294>,<0.00506,0.31775,0.04383>,
            <0.00391,0.31643,0.04191>,
    /*2*/ <-0.07055,0.30528,0.09459>,<-0.06965,0.3063,0.09607>,<-0.06885,0.30459,0.09677>,
            <-0.06974,0.30357,0.09528>,
    /*3*/ <-0.1442,0.28547,0.14577>,<-0.14363,0.28618,0.14687>,<-0.143,0.28498,0.14732>,
            <-0.14357,0.28427,0.14622>,
    /*4*/ <-0.2143,0.24607,0.1902>,<-0.21406,0.24645,0.19091>,<-0.21357,0.24579,0.1911>,
            <-0.21381,0.2454,0.19039>,
    /*5*/ <-0.28205,0.19269,0.22168>,<-0.28201,0.19278,0.22192>,<-0.28184,0.19259,0.22197>,
            <-0.28188,0.19249,0.22173>,
    /*6*/ <-0.28195,0.19264,0.22182>

    /* stem 0.2*/ 
    /*0*/ <0.00556,0.34985,0.05388>,
    /*1*/ <0.00726,0.34954,0.05437>,<0.00553,0.35133,0.05491>,<0.00385,0.35016,0.05339>,
            <0.00558,0.34837,0.05285>,
    /*2*/ <0.03597,0.39853,-0.01551>,<0.03463,0.39992,-0.0151>,<0.03333,0.39901,-0.01628>,
            <0.03467,0.39762,-0.01669>,
    /*3*/ <0.06977,0.44171,-0.08683>,<0.06886,0.44275,-0.08664>,<0.06794,0.4421,-0.08747>,
            <0.06885,0.44106,-0.08767>,
    /*4*/ <0.10177,0.46933,-0.16636>,<0.10127,0.46999,-0.16633>,<0.10068,0.46956,-0.16672>,
            <0.10118,0.4689,-0.16675>,
    /*5*/ <0.12497,0.46998,-0.2534>,<0.12483,0.4702,-0.25343>,<0.12463,0.47006,-0.25349>,
            <0.12477,0.46984,-0.25346>,
    /*6*/ <0.1248,0.47002,-0.25345>

    /* stem 0.3*/ 
    /*0*/ <0.00764,0.39029,0.07219>,
    /*1*/ <0.00618,0.38995,0.0731>,<0.00776,0.39186,0.07296>,<0.0091,0.39063,0.07127>,
            <0.00752,0.38872,0.07141>,
    /*2*/ <0.05498,0.35493,0.13697>,<0.0562,0.35641,0.13686>,<0.05723,0.35546,0.13555>,
            <0.05601,0.35398,0.13567>,
    /*3*/ <0.1008,0.31272,0.19859>,<0.10173,0.31372,0.19859>,<0.10243,0.31306,0.19763>,
            <0.1015,0.31206,0.19763>,
    /*4*/ <0.14248,0.2525,0.24678>,<0.14311,0.253,0.24688>,<0.14345,0.2527,0.24621>,
            <0.14283,0.2522,0.24612>,
    /*5*/ <0.17888,0.17939,0.27869>,<0.17909,0.17952,0.27874>,<0.17918,0.17946,0.27851>,
            <0.17897,0.17933,0.27846>,
    /*6*/ <0.17903,0.17943,0.2786>

    /* stem 0.4*/ 
    /*0*/ <0.00889,0.41453,0.08316>,
    /*1*/ <0.00874,0.41524,0.0816>,<0.01021,0.41558,0.08352>,<0.00904,0.41381,0.08472>,
            <0.00757,0.41347,0.0828>,
    /*2*/ <-0.0465,0.47317,0.11371>,<-0.04537,0.47343,0.1152>,<-0.04628,0.47206,0.11613>,
            <-0.04741,0.47179,0.11464>,
    /*3*/ <-0.10421,0.53003,0.1432>,<-0.10344,0.53025,0.14428>,<-0.10408,0.52927,0.14493>,
            <-0.10484,0.52905,0.14385>,
    /*4*/ <-0.17545,0.57184,0.16803>,<-0.17509,0.57205,0.1687>,<-0.17536,0.57139,0.16905>,
            <-0.17572,0.57118,0.16837>,
    /*5*/ <-0.25598,0.59641,0.18672>,<-0.25591,0.59649,0.18694>,<-0.25595,0.59627,0.18703>,
            <-0.25603,0.59619,0.18681>,
    /*6*/ <-0.25597,0.59634,0.18688>

    /* stem 0.5*/ 
    /*0*/ <0.0117,0.46845,0.10955>,
    /*1*/ <0.01331,0.46819,0.10989>,<0.01153,0.46926,0.11099>,<0.0101,0.46871,0.10921>,
            <0.01188,0.46765,0.10811>,
    /*2*/ <0.03241,0.53966,0.07219>,<0.03104,0.54049,0.07304>,<0.02993,0.54006,0.07167>,
            <0.03131,0.53924,0.07081>,
    /*3*/ <0.05481,0.60611,0.0278>,<0.05386,0.6068,0.02835>,<0.05306,0.60644,0.0274>,
            <0.054,0.60575,0.02685>,
    /*4*/ <0.08055,0.65603,-0.03331>,<0.08003,0.65656,-0.0331>,<0.07952,0.65625,-0.03357>,
            <0.08003,0.65572,-0.03378>,
    /*5*/ <0.10268,0.68238,-0.10889>,<0.10254,0.68257,-0.10887>,<0.10236,0.68245,-0.10896>,
            <0.1025,0.68226,-0.10898>,
    /*6*/ <0.10252,0.68241,-0.10893>

    /* stem 0.6*/ 
    /*0*/ <0.01418,0.51548,0.13387>,
    /*1*/ <0.01282,0.51515,0.13465>,<0.01354,0.51685,0.13335>,<0.01554,0.51581,0.1331>,
            <0.01482,0.5141,0.1344>,
    /*2*/ <0.04104,0.5531,0.19942>,<0.0416,0.55442,0.1984>,<0.04315,0.55361,0.19821>,
            <0.04259,0.55229,0.19922>,
    /*3*/ <0.07522,0.58326,0.26545>,<0.07565,0.58423,0.26479>,<0.0767,0.5836,0.26454>,
            <0.07627,0.58263,0.2652>,
    /*4*/ <0.11615,0.59463,0.33348>,<0.11646,0.59524,0.3332>,<0.11702,0.59483,0.33293>,
            <0.11671,0.59423,0.33322>,
    /*5*/ <0.15541,0.58269,0.40233>,<0.15554,0.58287,0.40229>,<0.15569,0.58274,0.40219>,
            <0.15557,0.58256,0.40222>,
    /*6*/ <0.15555,0.58272,0.40226>

    /* stem 0.7*/ 
    /*0*/ <0.01563,0.55222,0.15094>,
    /*1*/ <0.01526,0.55277,0.14952>,<0.016,0.55367,0.15139>,<0.016,0.55168,0.15235>,
            <0.01525,0.55078,0.15048>,
    /*2*/ <-0.0581,0.56436,0.17345>,<-0.05752,0.56506,0.1749>,<-0.05752,0.56352,0.17564>,
            <-0.0581,0.56282,0.17419>,
    /*3*/ <-0.13302,0.56655,0.19518>,<-0.1327,0.56706,0.19623>,<-0.13259,0.56595,0.19673>,
            <-0.13291,0.56545,0.19567>,
    /*4*/ <-0.2079,0.55299,0.21245>,<-0.20781,0.55329,0.2131>,<-0.20763,0.55265,0.21336>,
            <-0.20773,0.55235,0.21271>,
    /*5*/ <-0.27919,0.5222,0.21987>,<-0.27921,0.52228,0.22007>,<-0.27912,0.52209,0.22015>,
            <-0.27911,0.52201,0.21994>,
    /*6*/ <-0.27916,0.52215,0.22001>

    /* stem 0.8*/ 
    /*0*/ <0.01675,0.61666,0.17527>,
    /*1*/ <0.01794,0.61633,0.17611>,<0.01669,0.61801,0.17591>,<0.01557,0.617,0.17444>,
            <0.01682,0.61532,0.17464>,
    /*2*/ <0.06242,0.64365,0.12318>,<0.06145,0.64495,0.12302>,<0.06058,0.64417,0.12189>,
            <0.06155,0.64287,0.12204>,
    /*3*/ <0.10647,0.66487,0.06717>,<0.10582,0.66582,0.06702>,<0.10516,0.66524,0.06627>,
            <0.10581,0.66429,0.06642>,
    /*4*/ <0.1489,0.66792,0.0062>,<0.14859,0.6685,0.00601>,<0.14812,0.66814,0.00567>,
            <0.14843,0.66756,0.00586>,
    /*5*/ <0.18575,0.6508,-0.05605>,<0.18568,0.65097,-0.05614>,<0.18551,0.65086,-0.05621>,
            <0.18559,0.65069,-0.05612>,
    /*6*/ <0.18563,0.65083,-0.05613>

    /* stem 0.9*/ 
    /*0*/ <0.01827,0.67061,0.1953>,
    /*1*/ <0.01686,0.67062,0.19544>,<0.01841,0.67091,0.19669>,<0.01969,0.6706,0.19517>,
            <0.01814,0.67031,0.19392>,
    /*2*/ <0.01822,0.60091,0.21016>,<0.01943,0.60113,0.21114>,<0.02042,0.6009,0.20996>,
            <0.01922,0.60067,0.20899>,
    /*3*/ <0.02276,0.53033,0.21931>,<0.02361,0.53047,0.22>,<0.02431,0.5304,0.21915>,
            <0.02346,0.53026,0.21846>,
    /*4*/ <0.02061,0.45959,0.2114>,<0.02112,0.45953,0.21181>,<0.02153,0.45957,0.2113>,
            <0.02102,0.45964,0.21089>,
    /*5*/ <0.016,0.39489,0.18191>,<0.01615,0.39483,0.18202>,<0.01628,0.39488,0.18188>,
            <0.01613,0.39494,0.18177>,
    /*6*/ <0.01614,0.39488,0.1819>

    /* stem 0.10*/ 
    /*0*/ <0.02045,0.72571,0.2154>,
    /*1*/ <0.02037,0.72618,0.21412>,<0.02053,0.72699,0.21586>,<0.02053,0.72524,0.21668>,
            <0.02037,0.72443,0.21493>,
    /*2*/ <-0.0475,0.72855,0.21941>,<-0.04738,0.72918,0.22076>,<-0.04738,0.72782,0.22139>,
            <-0.0475,0.7272,0.22004>,
    /*3*/ <-0.11547,0.7285,0.22397>,<-0.11541,0.72895,0.22493>,<-0.11538,0.72799,0.22538>,
            <-0.11544,0.72754,0.22442>,
    /*4*/ <-0.18156,0.71202,0.22286>,<-0.18163,0.71227,0.22343>,<-0.1815,0.71171,0.22369>,
            <-0.18143,0.71146,0.22313>,
    /*5*/ <-0.24154,0.68081,0.2146>,<-0.2416,0.68088,0.21477>,<-0.24153,0.68072,0.21486>,
            <-0.24147,0.68065,0.21468>,
    /*6*/ <-0.24153,0.68076,0.21473>

    /* stem 0.11*/ 
    /*0*/ <0.02245,0.77453,0.23093>,
    /*1*/ <0.02375,0.77445,0.231>,<0.02254,0.77582,0.23073>,<0.02115,0.7746,0.23085>,
            <0.02236,0.77324,0.23112>,
    /*2*/ <0.02675,0.76467,0.16643>,<0.02581,0.76573,0.16623>,<0.02473,0.76479,0.16631>,
            <0.02568,0.76373,0.16652>,
    /*3*/ <0.0286,0.74648,0.10366>,<0.02793,0.74721,0.10342>,<0.02716,0.74657,0.10358>,
            <0.02783,0.74583,0.10382>,
    /*4*/ <0.02919,0.71368,0.04711>,<0.0288,0.71408,0.04687>,<0.02834,0.71374,0.04706>,
            <0.02873,0.71334,0.0473>,
    /*5*/ <0.03178,0.66892,-0.00044>,<0.03166,0.66902,-0.00054>,<0.03152,0.66893,-0.00047>,
            <0.03164,0.66883,-0.00036>,
    /*6*/ <0.03165,0.66893,-0.00045>

    /* stem 0.12*/ 
    /*0*/ <0.02479,0.82928,0.24566>,
    /*1*/ <0.02417,0.82902,0.24671>,<0.0245,0.83049,0.24578>,<0.0254,0.82954,0.2446>,
            <0.02508,0.82807,0.24553>,
    /*2*/ <0.07657,0.83825,0.2792>,<0.07682,0.83939,0.27848>,<0.07752,0.83865,0.27756>,
            <0.07727,0.83752,0.27828>,
    /*3*/ <0.1296,0.83735,0.3119>,<0.12989,0.83817,0.31146>,<0.13031,0.83764,0.31077>,
            <0.13002,0.83682,0.31121>,
    /*4*/ <0.18241,0.82087,0.34063>,<0.18267,0.82134,0.34042>,<0.18283,0.82104,0.33996>,
            <0.18257,0.82057,0.34017>,
    /*5*/ <0.23152,0.78994,0.36339>,<0.23163,0.79007,0.36334>,<0.23165,0.79,0.36318>,
            <0.23155,0.78986,0.36324>,
    /*6*/ <0.23159,0.78997,0.36329>

    /* stem 0.13*/ 
    /*0*/ <0.03063,0.89782,0.26461>,
    /*1*/ <0.03014,0.89809,0.26386>,<0.0304,0.89861,0.26505>,<0.03113,0.89755,0.26536>,
            <0.03087,0.89703,0.26417>,
    /*2*/ <-0.01737,0.87192,0.28581>,<-0.01717,0.87232,0.28673>,<-0.01661,0.8715,0.28697>,
            <-0.01681,0.87109,0.28605>,
    /*3*/ <-0.06277,0.83993,0.30427>,<-0.06268,0.84019,0.30494>,<-0.06223,0.83963,0.30509>,
            <-0.06232,0.83938,0.30441>,
    /*4*/ <-0.10311,0.79901,0.3153>,<-0.10311,0.79912,0.31572>,<-0.1028,0.79883,0.31579>,
            <-0.1028,0.79872,0.31538>,
    /*5*/ <-0.13523,0.7502,0.31865>,<-0.13524,0.75022,0.31878>,<-0.13513,0.75015,0.3188>,
            <-0.13512,0.75013,0.31867>,
    /*6*/ <-0.13518,0.75018,0.31872>

    /* stem 0.14*/ 
    /*0*/ <0.03655,0.94698,0.2785>,
    /*1*/ <0.03716,0.94699,0.27821>,<0.03673,0.94751,0.27889>,<0.03593,0.94697,0.2788>,
            <0.03636,0.94646,0.27811>,
    /*2*/ <0.01794,0.98251,0.23974>,<0.01761,0.98291,0.24027>,<0.01699,0.98249,0.2402>,
            <0.01733,0.98209,0.23966>,
    /*3*/ <-0.00166,1.01441,0.19842>,<-0.00191,1.01471,0.19877>,<-0.00234,1.0144,0.19873>,
            <-0.00209,1.0141,0.19838>,
    /*4*/ <-0.02494,1.03412,0.15172>,<-0.02511,1.03432,0.15189>,<-0.02534,1.03412,0.15192>,
            <-0.02517,1.03391,0.15175>,
    /*5*/ <-0.04895,1.03654,0.10145>,<-0.04901,1.03661,0.10148>,<-0.04908,1.03654,0.10151>,
            <-0.04902,1.03647,0.10147>,
    /*6*/ <-0.04901,1.03654,0.10148>

    /* stem 0.15*/ 
    /*0*/ <0.04302,0.99228,0.28959>,
    /*1*/ <0.04305,0.99219,0.29002>,<0.04329,0.99263,0.28965>,<0.04298,0.99238,0.28916>,
            <0.04274,0.99194,0.28954>,
    /*2*/ <0.08474,0.96065,0.27988>,<0.08492,0.96099,0.27959>,<0.08469,0.9608,0.27921>,
            <0.0845,0.96046,0.27951>,
    /*3*/ <0.12238,0.92497,0.26777>,<0.12253,0.9252,0.26756>,<0.12234,0.92509,0.2673>,
            <0.12219,0.92486,0.26751>,
    /*4*/ <0.14791,0.88015,0.25455>,<0.14803,0.88026,0.25442>,<0.14789,0.88022,0.25427>,
            <0.14777,0.88012,0.25441>,
    /*5*/ <0.16081,0.83099,0.23864>,<0.16085,0.83102,0.2386>,<0.1608,0.83102,0.23856>,
            <0.16077,0.83099,0.2386>,
    /*6*/ <0.16081,0.83101,0.2386>

    /* stem 0.16*/ 
    /*0*/ <0.05075,1.03967,0.29958>,
    /*1*/ <0.05057,1.03972,0.29951>,<0.05076,1.03985,0.29967>,<0.05093,1.03963,0.29965>,
            <0.05075,1.0395,0.29949>,
    /*2*/ <0.02957,1.01943,0.34087>,<0.02972,1.01953,0.34099>,<0.02985,1.01936,0.34098>,
            <0.02971,1.01926,0.34085>,
    /*3*/ <0.00829,0.99559,0.38014>,<0.00839,0.99566,0.38023>,<0.00849,0.99554,0.38021>,
            <0.00839,0.99548,0.38012>,
    /*4*/ <-0.01144,0.95864,0.40857>,<-0.01139,0.95867,0.40864>,<-0.01132,0.95862,0.40862>,
            <-0.01137,0.95859,0.40855>,
    /*5*/ <-0.03022,0.91621,0.42879>,<-0.03021,0.91621,0.42882>,<-0.03019,0.9162,0.42881>,
            <-0.0302,0.91619,0.42878>,
    /*6*/ <-0.0302,0.9162,0.4288>

    }
    normal_vectors { 3646
    /* stem 0*/ 
    /*0*/<-0,-1,-0>,
    /*1*/<0.99999,0.005,-0>,<0,0.005,0.99999>,<-0.99999,0.005,0>,
            <-0,0.005,-0.99999>,
    /*2*/<0.99997,0.00761,0.00038>,<0.00019,-0.06942,0.99759>,<-1,0.00239,-0.00001>,
            <-0.0002,0.07892,-0.99688>,
    /*3*/<0.99987,-0.01563,-0.00379>,<-0.00127,-0.2032,0.97914>,<-0.99966,0.02542,0.00556>,
            <0.00133,0.21223,-0.97722>,
    /*4*/<0.9991,-0.04043,-0.01253>,<-0.00197,-0.33648,0.94169>,<-0.99863,0.04989,0.01555>,
            <0.00241,0.34522,-0.93852>,
    /*5*/<0.9991,-0.04069,-0.01194>,<-0.00683,-0.43144,0.90212>,<-0.99863,0.04974,0.01618>,
            <0.00728,0.44002,-0.89796>,
    /*6*/<0.99963,-0.02665,-0.00566>,<-0.00624,-0.40226,0.9155>,<-0.99931,0.03565,0.00998>,
            <0.00663,0.41121,-0.91151>,
    /*7*/<0.99976,-0.02163,-0.00412>,<-0.00348,-0.34326,0.93923>,<-0.99949,0.03098,0.00762>,
            <0.0037,0.35247,-0.93581>,
    /*8*/<0.99941,-0.03331,-0.00791>,<-0.00211,-0.29661,0.955>,<-0.99902,0.04276,0.01113>,
            <0.00249,0.30609,-0.952>,
    /*9*/<0.99732,-0.07077,-0.01852>,<-0.0009,-0.26098,0.96534>,<-0.99654,0.08037,0.02114>,
            <0.0015,0.27055,-0.9627>,
    /*10*/<0.99132,-0.12767,-0.03154>,<0.0015,-0.23461,0.97209>,<-0.98996,0.13722,0.03406>,
            <-0.00024,0.24424,-0.96971>,
    /*11*/<0.15777,0.96625,0.20362>

    /* stem 0c0*/ 
    /*0*/<-0.35864,-0.85507,0.37448>,
    /*1*/<0.65949,0.05749,0.74951>,<-0.66062,0.52004,0.54142>,<-0.6559,-0.04894,-0.75326>,
            <0.66421,-0.51149,-0.54516>,
    /*2*/<0.65283,0.04091,0.7564>,<-0.66952,0.49911,0.55013>,<-0.64921,-0.03231,-0.75992>,
            <0.67299,-0.49047,-0.55366>,
    /*3*/<0.6456,0.01705,0.76349>,<-0.7056,0.39739,0.5867>,<-0.64236,-0.00806,-0.76636>,
            <0.70834,-0.38872,-0.5892>,
    /*4*/<0.64466,0.01601,0.7643>,<-0.74257,0.24992,0.62139>,<-0.6426,-0.0064,-0.76617>,
            <0.74425,-0.241,-0.6229>,
    /*5*/<0.64478,0.02171,0.76406>,<-0.7481,0.22263,0.62513>,<-0.64337,-0.01191,-0.76547>,
            <0.74961,-0.2132,-0.62661>,
    /*6*/<0.64511,0.02182,0.76378>,<-0.73429,0.29381,0.61196>,<-0.64313,-0.0122,-0.76566>,
            <0.73637,-0.28436,-0.61392>,
    /*7*/<0.64318,0.01406,0.76558>,<-0.71467,0.36894,0.59425>,<-0.6406,-0.00467,-0.76786>,
            <0.71735,-0.35972,-0.59667>,
    /*8*/<0.62824,-0.02924,0.77747>,<-0.70164,0.41058,0.58234>,<-0.62489,0.03835,-0.77977>,
            <0.70486,-0.4015,-0.58479>,
    /*9*/<0.61706,-0.05471,0.78501>,<-0.67928,0.46722,0.56594>,<-0.61331,0.06367,-0.78727>,
            <0.68328,-0.45839,-0.56834>,
    /*10*/<0.43249,0.85462,-0.28736>

    /* stem 0c0.0*/ 
    /*0*/<-0.428,-0.51928,0.73971>,
    /*1*/<0.90551,-0.22677,0.35865>,<-0.01657,0.82565,0.56394>,<-0.90166,0.23144,-0.36531>,
            <0.02042,-0.82098,-0.57059>,
    /*2*/<0.91083,-0.22094,0.34868>,<0.01003,0.85707,0.51511>,<-0.90708,0.2254,-0.35554>,
            <-0.00627,-0.85291,-0.52201>,
    /*3*/<0.93051,-0.20538,0.30327>,<0.0906,0.93652,0.3387>,<-0.92724,0.20861,-0.31099>,
            <-0.08736,-0.9341,-0.34617>,
    /*4*/<0.94498,-0.20437,0.25544>,<0.18994,0.97882,0.07632>,<-0.94243,0.20522,-0.26402>,
            <-0.18763,-0.97861,-0.08436>,
    /*5*/<0.73488,-0.206,-0.64616>,<0.32056,0.47367,-0.82029>,<-0.35496,0.03255,-0.93431>,
            <0.05933,-0.6471,-0.76009>,
    /*6*/<0.2324,-0.1061,-0.96681>

    /* stem 0c0.1*/ 
    /*0*/<-0.88279,-0.04092,-0.46799>,
    /*1*/<-0.42963,0.4545,0.78029>,<0.18474,0.89007,-0.4167>,<0.43757,-0.45413,-0.77608>,
            <-0.1768,-0.8897,0.42091>,
    /*2*/<-0.43297,0.45441,0.77849>,<0.22161,0.89091,-0.39644>,<0.44086,-0.45419,-0.77418>,
            <-0.21378,-0.89088,0.4008>,
    /*3*/<-0.43655,0.4542,0.77661>,<0.37125,0.87736,-0.30398>,<0.44414,-0.45502,-0.77181>,
            <-0.36419,-0.87866,0.30876>,
    /*4*/<-0.42727,0.44793,0.78536>,<0.56935,0.80776,-0.15284>,<0.43392,-0.45086,-0.78003>,
            <-0.56342,-0.81092,0.158>,
    /*5*/<0.27406,-0.13897,0.95162>,<0.8911,0.04346,0.45173>,<0.76124,-0.64727,0.03949>,
            <0.14415,-0.82966,0.53934>,
    /*6*/<0.63332,-0.48096,0.60629>

    /* stem 0c0.2*/ 
    /*0*/<0.99812,0.03276,-0.05171>,
    /*1*/<-0.04868,-0.19902,-0.97879>,<-0.04685,0.97932,-0.19682>,<0.0397,0.19873,0.97925>,
            <0.03787,-0.97961,0.19729>,
    /*2*/<-0.03878,-0.19829,-0.97938>,<-0.10024,0.97581,-0.19427>,<0.0298,0.19774,0.9798>,
            <0.09136,-0.97658,0.19478>,
    /*3*/<-0.0131,-0.19307,-0.9811>,<-0.26343,0.94679,-0.18493>,<0.00429,0.19128,0.98153>,
            <0.25504,-0.94897,0.18551>,
    /*4*/<0.0107,-0.18113,-0.9834>,<-0.47686,0.86322,-0.1657>,<-0.01887,0.17739,0.98396>,
            <0.46928,-0.86724,0.16637>,
    /*5*/<-0.65667,-0.56333,-0.50145>,<-0.99974,-0.00029,-0.02271>,<-0.6825,-0.36487,0.63329>,
            <-0.33938,-0.92787,0.15455>,
    /*6*/<-0.8192,-0.5678,0.08065>

    /* stem 0c0.3*/ 
    /*0*/<-0.6125,0.69857,0.36992>,
    /*1*/<0.55451,0.03958,0.83123>,<0.56879,0.71112,-0.41327>,<-0.549,-0.04587,-0.83456>,
            <-0.56327,-0.7174,0.40994>,
    /*2*/<0.54545,0.05064,0.83661>,<0.59463,0.68061,-0.42801>,<-0.53998,-0.05705,-0.83974>,
            <-0.58933,-0.68713,0.42491>,
    /*3*/<0.54017,0.05628,0.83967>,<0.69237,0.53678,-0.48217>,<-0.5354,-0.06349,-0.84221>,
            <-0.6882,-0.54399,0.48006>,
    /*4*/<0.55227,0.01044,0.8336>,<0.79073,0.30069,-0.53323>,<-0.54947,-0.01883,-0.8353>,
            <-0.78841,-0.30873,0.53206>,
    /*5*/<0.43312,-0.81802,0.37849>,<0.58816,-0.6959,-0.41206>,<-0.20354,-0.78772,-0.58144>,
            <-0.35859,-0.90977,0.20912>,
    /*6*/<0.14044,-0.98227,-0.12415>

    /* stem 0c0.4*/ 
    /*0*/<-0.16854,-0.38294,-0.90827>,
    /*1*/<-0.98141,0.14472,0.12605>,<0.08393,0.91435,-0.39613>,<0.98293,-0.14127,-0.11788>,
            <-0.08241,-0.91091,0.4043>,
    /*2*/<-0.98144,0.14459,0.12599>,<0.09123,0.9301,-0.35579>,<0.98294,-0.14133,-0.11774>,
            <-0.08975,-0.92704,0.36407>,
    /*3*/<-0.98478,0.14025,0.10263>,<0.11777,0.97862,-0.16863>,<0.98595,-0.13816,-0.09394>,
            <-0.11662,-0.97728,0.17698>,
    /*4*/<-0.98604,0.13969,0.09058>,<0.15094,0.98193,0.11412>,<0.98676,-0.14018,-0.08161>,
            <-0.15042,-0.98294,-0.10585>,
    /*5*/<-0.51844,-0.12956,0.84524>,<0.13919,0.34427,0.9285>,<0.61765,-0.28556,0.73278>,
            <-0.03999,-0.75936,0.64944>,
    /*6*/<0.06069,-0.25394,0.96531>

    /* stem 0c0.5*/ 
    /*0*/<0.80523,0.57586,0.14139>,
    /*1*/<0.27687,-0.16243,-0.94708>,<-0.52605,0.79917,-0.29087>,<-0.28412,0.15725,0.94581>,
            <0.5188,-0.80435,0.2896>,
    /*2*/<0.28152,-0.15873,-0.94634>,<-0.59269,0.74655,-0.30229>,<-0.28855,0.15323,0.94512>,
            <0.58603,-0.75221,0.30125>,
    /*3*/<0.28533,-0.15637,-0.94559>,<-0.74185,0.58858,-0.3213>,<-0.29125,0.14961,0.94488>,
            <0.7367,-0.59527,0.32081>,
    /*4*/<0.28406,-0.16206,-0.94501>,<-0.87407,0.36151,-0.32453>,<-0.28814,0.15403,0.94512>,
            <0.87071,-0.36929,0.32479>,
    /*5*/<-0.06544,-0.87499,-0.4797>,<-0.75778,-0.64156,-0.11903>,<-0.39436,-0.68842,0.60873>,
            <0.29801,-0.92177,0.24806>,
    /*6*/<-0.28127,-0.95638,0.07893>

    /* stem 0c0.6*/ 
    /*0*/<-0.15803,0.9142,0.37318>,
    /*1*/<0.85051,-0.07065,0.52118>,<0.50354,0.39565,-0.76805>,<-0.84909,0.06242,-0.52454>,
            <-0.50212,-0.40387,0.7647>,
    /*2*/<0.85449,-0.10223,0.50931>,<0.50837,0.35689,-0.78371>,<-0.85343,0.09398,-0.51267>,
            <-0.50727,-0.36521,0.78058>,
    /*3*/<0.85579,-0.12831,0.50115>,<0.51821,0.19049,-0.83377>,<-0.85554,0.11971,-0.50371>,
            <-0.51828,-0.19889,0.83176>,
    /*4*/<0.85621,-0.1213,0.50219>,<0.50102,-0.04433,-0.8643>,<-0.85705,0.11235,-0.50283>,
            <-0.50205,0.03587,0.86409>,
    /*5*/<0.35178,-0.8701,0.34521>,<0.13803,-0.88689,-0.44087>,<-0.6354,-0.73596,-0.23372>,
            <-0.42164,-0.71912,0.55235>,
    /*6*/<-0.1735,-0.98247,0.0682>

    /* stem 0c0.7*/ 
    /*0*/<-0.45813,-0.80149,-0.38437>,
    /*1*/<-0.83792,0.25252,0.48386>,<-0.28869,0.54735,-0.78554>,<0.84204,-0.24531,-0.4804>,
            <0.29281,-0.54014,0.789>,
    /*2*/<-0.83938,0.25001,0.48264>,<-0.27841,0.56509,-0.77664>,<0.8435,-0.24285,-0.47909>,
            <0.28257,-0.55799,0.78025>,
    /*3*/<-0.83433,0.25664,0.48789>,<-0.21595,0.6606,-0.71901>,<0.83874,-0.24995,-0.48378>,
            <0.22031,-0.65435,0.72339>,
    /*4*/<-0.82545,0.26421,0.49882>,<-0.10755,0.79387,-0.5985>,<0.83035,-0.25887,-0.49347>,
            <0.11231,-0.78909,0.60393>,
    /*5*/<-0.01791,0.53205,0.84652>,<0.42796,0.86771,0.25286>,<0.93434,0.22968,0.27251>,
            <0.48844,-0.106,0.86613>,
    /*6*/<0.5606,0.46597,0.68454>

    /* stem 0c0.8*/ 
    /*0*/<0.67771,-0.647,-0.34943>,
    /*1*/<-0.5134,-0.06883,-0.85539>,<0.52634,0.76201,-0.37724>,<0.5073,0.07465,0.85853>,
            <-0.53244,-0.75619,0.38039>,
    /*2*/<-0.53727,-0.0474,-0.84208>,<0.50068,0.78615,-0.36234>,<0.53127,0.05309,0.84554>,
            <-0.50685,-0.7806,0.36573>,
    /*3*/<-0.55827,-0.03128,-0.82907>,<0.38123,0.87749,-0.291>,<0.55188,0.0361,0.83314>,
            <-0.38761,-0.87331,0.29512>,
    /*4*/<-0.58305,-0.02546,-0.81204>,<0.17278,0.97367,-0.1487>,<0.57601,0.02818,0.81696>,
            <-0.17962,-0.97172,0.1533>,
    /*5*/<-0.99755,0.05923,0.03722>,<-0.6144,0.64867,0.44914>,<-0.29609,0.09105,0.95081>,
            <-0.67916,-0.4984,0.53883>,
    /*6*/<-0.79136,0.09193,0.6044>

    /* stem 0c0.9*/ 
    /*0*/<0.06728,-0.5758,0.81482>,
    /*1*/<0.91275,-0.2911,-0.2866>,<0.40192,0.7656,0.50231>,<-0.91336,0.29629,0.27926>,
            <-0.40252,-0.76042,-0.50964>,
    /*2*/<0.91277,-0.2916,-0.28605>,<0.397,0.79905,0.45157>,<-0.91348,0.29657,0.27857>,
            <-0.39782,-0.79435,-0.45908>,
    /*3*/<0.91146,-0.29023,-0.29155>,<0.37007,0.88716,0.27568>,<-0.91279,0.29403,0.28348>,
            <-0.37152,-0.88408,-0.28352>,
    /*4*/<0.91827,-0.29512,-0.26397>,<0.32065,0.94628,0.04173>,<-0.9202,0.29673,0.25533>,
            <-0.32277,-0.94516,-0.04988>,
    /*5*/<0.34548,-0.15957,-0.92476>,<-0.02551,0.55945,-0.82847>,<-0.72573,0.1762,-0.66503>,
            <-0.35472,-0.54281,-0.76127>,
    /*6*/<-0.23261,0.01018,-0.97252>

    /* stem 0c0.10*/ 
    /*0*/<-0.17645,0.83059,-0.52819>,
    /*1*/<-0.493,0.38576,0.77983>,<0.85227,0.39426,0.34379>,<0.49459,-0.39323,-0.77508>,
            <-0.85068,-0.40174,-0.33904>,
    /*2*/<-0.49171,0.37869,0.7841>,<0.85631,0.37388,0.35629>,<0.49324,-0.38624,-0.77944>,
            <-0.8549,-0.38144,-0.35165>,
    /*3*/<-0.49142,0.37264,0.78718>,<0.87047,0.22875,0.43584>,<0.49214,-0.38056,-0.78292>,
            <-0.8703,-0.23649,-0.43204>,
    /*4*/<-0.49231,0.37327,0.78632>,<0.8442,-0.01474,0.53582>,<0.4909,-0.38161,-0.78319>,
            <-0.84598,0.00693,-0.53317>,
    /*5*/<-0.53907,-0.53311,0.65207>,<0.2125,-0.82229,0.52791>,<0.02775,-0.96724,-0.25233>,
            <-0.7238,-0.678,-0.12818>,
    /*6*/<-0.31279,-0.91781,0.24453>

    /* stem 0c0.11*/ 
    /*0*/<0.33646,-0.93557,0.10727>,
    /*1*/<-0.23387,-0.18865,-0.95379>,<0.91106,0.30003,-0.28276>,<0.23084,0.19707,0.95282>,
            <-0.91409,-0.29161,0.28179>,
    /*2*/<-0.24288,-0.16402,-0.95609>,<0.90771,0.30935,-0.28349>,<0.23987,0.17245,0.95537>,
            <-0.91079,-0.30093,0.28266>,
    /*3*/<-0.25752,-0.13314,-0.95705>,<0.85723,0.426,-0.28929>,<0.25399,0.14141,0.95681>,
            <-0.86112,-0.41816,0.28916>,
    /*4*/<-0.25382,-0.13847,-0.95729>,<0.69436,0.66171,-0.28285>,<0.24833,0.14562,0.95767>,
            <-0.70001,-0.65546,0.28348>,
    /*5*/<-0.77602,0.4175,-0.47274>,<-0.30595,0.94928,-0.0725>,<-0.50087,0.5906,0.63271>,
            <-0.97083,0.05873,0.23245>,
    /*6*/<-0.78111,0.61668,0.09785>

    /* stem 0c0.12*/ 
    /*0*/<-0.38526,0.53227,0.75384>,
    /*1*/<0.84181,-0.13814,0.52179>,<0.3836,0.83322,-0.39824>,<-0.83835,0.13335,-0.52858>,
            <-0.38013,-0.83801,0.39146>,
    /*2*/<0.84289,-0.1403,0.51948>,<0.415,0.78392,-0.46177>,<-0.83959,0.13519,-0.52612>,
            <-0.41193,-0.78922,0.45546>,
    /*3*/<0.8483,-0.15834,0.50529>,<0.47666,0.63807,-0.6047>,<-0.84593,0.15195,-0.51118>,
            <-0.4746,-0.64446,0.59952>,
    /*4*/<0.84966,-0.17789,0.49642>,<0.52174,0.42245,-0.74116>,<-0.84859,0.17017,-0.50094>,
            <-0.52102,-0.42999,0.73732>,
    /*5*/<0.50079,-0.86557,-0.00079>,<0.31587,-0.58836,-0.74435>,<-0.47757,-0.66415,-0.57517>,
            <-0.29265,-0.94127,0.16841>,
    /*6*/<0.0142,-0.93577,-0.35233>

    /* stem 0c0.13*/ 
    /*0*/<0.00638,0.69827,-0.7158>,
    /*1*/<-0.82144,0.4091,0.39733>,<0.57025,0.58267,0.57905>,<0.82139,-0.41467,-0.39162>,
            <-0.5703,-0.58824,-0.57334>,
    /*2*/<-0.82181,0.39769,0.408>,<0.56995,0.55236,0.60833>,<0.82177,-0.4034,-0.40244>,
            <-0.57014,-0.55811,-0.60287>,
    /*3*/<-0.82334,0.38306,0.41879>,<0.55562,0.39301,0.73269>,<0.82276,-0.38944,-0.41401>,
            <-0.55651,-0.39927,-0.72861>,
    /*4*/<-0.83171,0.35452,0.42728>,<0.50245,0.14151,0.85295>,<0.83003,-0.36179,-0.42445>,
            <-0.50434,-0.14826,-0.85068>,
    /*5*/<-0.71398,-0.57961,0.39278>,<0.03728,-0.7531,0.65685>,<0.25516,-0.96168,-0.10028>,
            <-0.49608,-0.78813,-0.36435>,
    /*6*/<-0.28071,-0.94296,0.17896>

    /* stem 0c0.14*/ 
    /*0*/<0.85294,0.43052,-0.29521>,
    /*1*/<-0.28284,-0.10013,-0.95393>,<-0.44259,0.89595,0.03718>,<0.27815,0.09776,0.95555>,
            <0.4379,-0.89832,-0.03556>,
    /*2*/<-0.28048,-0.09885,-0.95476>,<-0.48465,0.87318,0.05175>,<0.27585,0.09636,0.95636>,
            <0.48012,-0.87577,-0.05016>,
    /*3*/<-0.30642,-0.1222,-0.94402>,<-0.62639,0.77189,0.10873>,<0.30225,0.11907,0.94576>,
            <0.62257,-0.77518,-0.10721>,
    /*4*/<-0.31197,-0.13197,-0.94088>,<-0.78746,0.59117,0.17442>,<0.30878,0.12782,0.94251>,
            <0.7847,-0.59528,-0.17286>,
    /*5*/<-0.54021,-0.76371,-0.35345>,<-0.85181,-0.41778,0.31604>,<-0.19304,-0.64456,0.73978>,
            <0.11858,-0.99045,0.07029>,
    /*6*/<-0.44873,-0.86183,0.23643>

    /* stem 0c0.15*/ 
    /*0*/<0.16028,0.8116,0.5618>,
    /*1*/<0.89262,-0.36339,0.2668>,<0.42037,0.45711,-0.78379>,<-0.89325,0.36019,-0.26902>,
            <-0.42101,-0.46031,0.78158>,
    /*2*/<0.89118,-0.36957,0.26308>,<0.40895,0.4051,-0.81771>,<-0.89189,0.36633,-0.26521>,
            <-0.40969,-0.40836,0.81572>,
    /*3*/<0.89113,-0.37027,0.26228>,<0.36165,0.22704,-0.90425>,<-0.8921,0.36678,-0.26386>,
            <-0.36269,-0.23039,0.90298>,
    /*4*/<0.89155,-0.36874,0.263>,<0.27553,-0.01802,-0.96112>,<-0.89289,0.36507,-0.26359>,
            <-0.27684,0.01458,0.96081>,
    /*5*/<0.19224,-0.96473,0.17981>,<-0.18846,-0.82773,-0.52854>,<-0.83468,-0.53639,-0.12484>,
            <-0.45397,-0.67337,0.58351>,
    /*6*/<-0.39323,-0.91882,0.03365>

    /* stem 0c0.16*/ 
    /*0*/<-0.72848,-0.66851,-0.14967>,
    /*1*/<-0.59527,0.51034,0.62065>,<-0.33822,0.5415,-0.76966>,<0.59588,-0.50979,-0.62052>,
            <0.33883,-0.54094,0.76979>,
    /*2*/<-0.59452,0.51098,0.62084>,<-0.30225,0.57343,-0.76146>,<0.59514,-0.51043,-0.6207>,
            <0.30287,-0.5729,0.76161>,
    /*3*/<-0.59059,0.5137,0.62235>,<-0.17908,0.66817,-0.72214>,<0.59124,-0.51322,-0.62213>,
            <0.17972,-0.66773,0.72238>,
    /*4*/<-0.60088,0.5094,0.616>,<0.0426,0.79218,-0.6088>,<0.60155,-0.50906,-0.61563>,
            <-0.04197,-0.79192,0.60919>,
    /*5*/<0.27378,0.46821,0.84013>,<0.72922,0.65748,0.18962>,<0.98294,-0.11697,0.14194>,
            <0.52749,-0.30624,0.79245>,
    /*6*/<0.76951,0.21507,0.60134>

    /* stem 0c1*/ 
    /*0*/<-0.38111,-0.92219,-0.0657>,
    /*1*/<-0.10972,-0.02004,0.99376>,<-0.91585,0.39056,-0.09321>,<0.11353,0.02926,-0.9931>,
            <0.91966,-0.38133,0.09387>,
    /*2*/<-0.1073,-0.01161,0.99416>,<-0.94653,0.30738,-0.09796>,<0.11071,0.02099,-0.99363>,
            <0.94934,-0.29842,0.09847>,
    /*3*/<-0.10852,-0.01565,0.99397>,<-0.98184,0.1575,-0.10577>,<0.11034,0.02546,-0.99357>,
            <0.98321,-0.14852,0.10604>,
    /*4*/<-0.10766,0.01801,0.99402>,<-0.99344,0.04286,-0.10603>,<0.1083,-0.00816,-0.99409>,
            <0.99379,-0.03331,0.10618>,
    /*5*/<-0.11238,0.08455,0.99006>,<-0.99367,-0.01482,-0.11131>,<0.11232,-0.07473,-0.99086>,
            <0.99356,0.02465,0.11061>,
    /*6*/<-0.11095,0.10496,0.98827>,<-0.99339,0.01809,-0.11334>,<0.11099,-0.09503,-0.98927>,
            <0.99363,-0.00821,0.11237>,
    /*7*/<-0.11205,0.09097,0.98953>,<-0.9876,0.10075,-0.12038>,<0.11289,-0.08104,-0.9903>,
            <0.98865,-0.09095,0.11957>,
    /*8*/<-0.11289,0.08486,0.98998>,<-0.97768,0.16811,-0.12601>,<0.11448,-0.07501,-0.99059>,
            <0.97938,-0.15833,0.12545>,
    /*9*/<-0.10815,0.10146,0.98894>,<-0.95817,0.25434,-0.13124>,<0.11045,-0.09175,-0.98964>,
            <0.96075,-0.24473,0.13063>,
    /*10*/<0.31972,0.94522,-0.06595>

    /* stem 0c1.0*/ 
    /*0*/<-0.7081,-0.66101,0.24831>,
    /*1*/<0.43205,-0.12027,0.89379>,<-0.55776,0.74315,0.36963>,<-0.42568,0.12622,-0.89603>,
            <0.56413,-0.7372,-0.37187>,
    /*2*/<0.4318,-0.1206,0.89387>,<-0.52641,0.77097,0.35846>,<-0.42532,0.1264,-0.89617>,
            <0.53296,-0.76535,-0.36082>,
    /*3*/<0.44327,-0.11366,0.88915>,<-0.42282,0.84857,0.31804>,<-0.43633,0.11869,-0.89192>,
            <0.42981,-0.844,-0.32081>,
    /*4*/<0.43077,-0.1189,0.89459>,<-0.2104,0.94941,0.23314>,<-0.42304,0.1222,-0.89783>,
            <0.21788,-0.94688,-0.23653>,
    /*5*/<0.97668,0.04275,0.21039>,<0.70102,0.67929,-0.21713>,<0.51637,0.18314,-0.83656>,
            <0.79193,-0.45341,-0.40899>,
    /*6*/<0.91334,0.13818,-0.38304>

    /* stem 0c1.1*/ 
    /*0*/<0.24819,0.01982,-0.96851>,
    /*1*/<-0.94776,0.21703,-0.23379>,<0.20445,0.97584,0.077>,<0.94552,-0.21721,0.24251>,
            <-0.20668,-0.97602,-0.06829>,
    /*2*/<-0.94826,0.21687,-0.23189>,<0.19695,0.97467,0.10598>,<0.94602,-0.21718,0.2406>,
            <-0.19923,-0.97511,-0.09731>,
    /*3*/<-0.94431,0.21945,-0.24519>,<0.15177,0.95379,0.25931>,<0.94176,-0.2207,0.25374>,
            <-0.15424,-0.95557,-0.2512>,
    /*4*/<-0.93884,0.22583,-0.25994>,<0.06896,0.86356,0.49951>,<0.93582,-0.2293,0.2677>,
            <-0.07184,-0.86734,-0.49251>,
    /*5*/<-0.82462,-0.32738,0.46133>,<-0.27156,-0.00033,0.96242>,<0.25513,-0.59016,0.76591>,
            <-0.29789,-0.91715,0.26475>,
    /*6*/<-0.34837,-0.56128,0.75073>

    /* stem 0c1.2*/ 
    /*0*/<0.6501,0.67398,0.35088>,
    /*1*/<0.47357,-0.00495,-0.88074>,<-0.59479,0.73571,-0.32397>,<-0.47942,-0.00112,0.87759>,
            <0.58894,-0.74177,0.32081>,
    /*2*/<0.47368,-0.00496,-0.88068>,<-0.62243,0.70551,-0.33889>,<-0.47941,-0.00125,0.87759>,
            <0.61685,-0.71182,0.33587>,
    /*3*/<0.48763,0.016,-0.87291>,<-0.71019,0.58635,-0.38965>,<-0.49254,-0.02296,0.86999>,
            <0.7057,-0.59339,0.38712>,
    /*4*/<0.49567,0.03787,-0.86768>,<-0.80858,0.38486,-0.44507>,<-0.49896,-0.04593,0.8654>,
            <0.80584,-0.39277,0.44311>,
    /*5*/<0.10442,-0.76194,-0.63917>,<-0.66516,-0.62433,-0.4096>,<-0.46829,-0.80706,0.35965>,
            <0.3013,-0.94461,0.13009>,
    /*6*/<-0.22259,-0.9598,-0.17099>

    /* stem 0c1.3*/ 
    /*0*/<-0.60936,-0.40939,0.67903>,
    /*1*/<0.77067,-0.0897,0.63089>,<-0.19463,0.90959,0.36711>,<-0.76518,0.09339,-0.637>,
            <0.20011,-0.9059,-0.37322>,
    /*2*/<0.78373,-0.08237,0.61561>,<-0.15456,0.93476,0.31989>,<-0.77835,0.0858,-0.62194>,
            <0.16001,-0.93167,-0.32618>,
    /*3*/<0.7986,-0.07682,0.59694>,<-0.03543,0.98412,0.17392>,<-0.7932,0.07886,-0.60384>,
            <0.04062,-0.98272,-0.18059>,
    /*4*/<0.79926,-0.07807,0.59589>,<0.14529,0.9873,-0.06427>,<-0.79387,0.07763,-0.60311>,
            <-0.14037,-0.98842,0.05757>,
    /*5*/<0.91343,-0.28822,-0.28737>,<0.59282,0.30442,-0.74558>,<-0.00318,-0.19939,-0.97991>,
            <0.31734,-0.79198,-0.52159>,
    /*6*/<0.55682,-0.29829,-0.77523>

    /* stem 0c1.4*/ 
    /*0*/<-0.57371,-0.62846,-0.52525>,
    /*1*/<-0.69563,0.04284,0.71712>,<-0.4256,0.77963,-0.45939>,<0.70079,-0.03718,-0.71239>,
            <0.43077,-0.77397,0.46412>,
    /*2*/<-0.68305,0.05535,0.72828>,<-0.40459,0.80105,-0.44116>,<0.6884,-0.04984,-0.72362>,
            <0.40993,-0.79567,0.44594>,
    /*3*/<-0.67813,0.06023,0.73247>,<-0.28614,0.89751,-0.33556>,<0.68398,-0.05566,-0.72737>,
            <0.29195,-0.89374,0.34058>,
    /*4*/<-0.68844,0.05607,0.72313>,<-0.06244,0.98884,-0.13524>,<0.69485,-0.05405,-0.71712>,
            <0.06839,-0.98766,0.14086>,
    /*5*/<0.18886,0.01577,0.98188>,<0.61812,0.55919,0.55248>,<0.98702,-0.04786,0.15328>,
            <0.55766,-0.59128,0.58258>,
    /*6*/<0.71932,-0.01964,0.6944>

    /* stem 0c1.5*/ 
    /*0*/<0.85376,-0.18427,-0.48696>,
    /*1*/<-0.50745,-0.05409,-0.85998>,<0.12828,0.98216,-0.1375>,<0.49977,0.05575,0.86436>,
            <-0.13597,-0.9805,0.14188>,
    /*2*/<-0.48003,-0.05875,-0.87528>,<0.09314,0.98852,-0.11894>,<0.47221,0.06021,0.87943>,
            <-0.1009,-0.98723,0.12323>,
    /*3*/<-0.44334,-0.0607,-0.8943>,<-0.06744,0.99707,-0.03613>,<0.43527,0.06097,0.89823>,
            <0.05976,-0.99741,0.03997>,
    /*4*/<-0.45708,-0.06738,-0.88687>,<-0.30862,0.94684,0.09088>,<0.44937,0.06518,0.89097>,
            <0.30152,-0.94946,-0.0872>,
    /*5*/<-0.90558,-0.40328,-0.13149>,<-0.87512,0.15965,0.45682>,<-0.36081,-0.31013,0.87957>,
            <-0.3912,-0.87302,0.29122>,
    /*6*/<-0.77468,-0.43641,0.45762>

    /* stem 0c1.6*/ 
    /*0*/<-0.07099,-0.75621,0.65046>,
    /*1*/<0.98937,0.03459,0.14126>,<-0.129,0.65698,0.74279>,<-0.98873,-0.02778,-0.14711>,
            <0.12964,-0.65017,-0.74865>,
    /*2*/<0.98986,0.03902,0.13662>,<-0.12399,0.70947,0.69374>,<-0.98923,-0.03243,-0.14272>,
            <0.12467,-0.70321,-0.69997>,
    /*3*/<0.99096,0.04603,0.12604>,<-0.10803,0.83403,0.54103>,<-0.99026,-0.04058,-0.13318>,
            <0.10878,-0.82929,-0.54812>,
    /*4*/<0.99406,0.05636,0.09314>,<-0.08659,0.94367,0.31935>,<-0.99344,-0.05286,-0.10142>,
            <0.08735,-0.94085,-0.32736>,
    /*5*/<0.61922,0.20462,-0.75809>,<0.00507,0.7342,-0.67891>,<-0.52842,0.13911,-0.83751>,
            <0.08572,-0.39049,-0.91661>,
    /*6*/<0.05554,0.21027,-0.97607>

    /* stem 0c1.7*/ 
    /*0*/<-0.92444,-0.25656,-0.28213>,
    /*1*/<-0.3097,0.09284,0.94629>,<-0.21242,0.96332,-0.16401>,<0.31802,-0.09053,-0.94375>,
            <0.22074,-0.96101,0.16655>,
    /*2*/<-0.30051,0.09498,0.94904>,<-0.18299,0.97077,-0.15531>,<0.30889,-0.09282,-0.94656>,
            <0.19136,-0.96874,0.15785>,
    /*3*/<-0.28329,0.09592,0.95423>,<0.0107,0.99514,-0.09789>,<0.2919,-0.09495,-0.95172>,
            <-0.00263,-0.99495,0.10036>,
    /*4*/<-0.29244,0.0974,0.95131>,<0.27945,0.96011,-0.00985>,<0.30081,-0.09921,-0.94851>,
            <-0.27188,-0.96225,0.01235>,
    /*5*/<0.53163,-0.23801,0.81285>,<0.93114,0.23248,0.28094>,<0.89076,-0.36184,-0.27499>,
            <0.49119,-0.8323,0.2569>,
    /*6*/<0.87011,-0.36694,0.32902>

    /* stem 0c1.8*/ 
    /*0*/<0.85167,-0.17714,-0.49323>,
    /*1*/<-0.51185,-0.04705,-0.85779>,<0.12491,0.98381,-0.12852>,<0.50418,0.04864,0.86223>,
            <-0.13258,-0.98222,0.13295>,
    /*2*/<-0.54005,-0.04236,-0.84057>,<0.09505,0.98941,-0.10972>,<0.53254,0.0438,0.84527>,
            <-0.10265,-0.98813,0.1143>,
    /*3*/<-0.56389,-0.04084,-0.82484>,<-0.05178,0.99854,-0.01525>,<0.55644,0.04119,0.82986>,
            <0.04467,-0.9988,0.02011>,
    /*4*/<-0.56532,-0.04243,-0.82378>,<-0.2464,0.9617,0.1201>,<0.55809,0.04048,0.82879>,
            <0.23967,-0.96397,-0.11544>,
    /*5*/<-0.94576,-0.32336,-0.03124>,<-0.80585,0.2386,0.54192>,<-0.29289,-0.27153,0.91678>,
            <-0.43276,-0.83347,0.34359>,
    /*6*/<-0.75771,-0.36391,0.54171>

    /* stem 0c1.9*/ 
    /*0*/<0.40971,-0.29036,0.86477>,
    /*1*/<0.88376,-0.09934,-0.45727>,<0.21683,0.95291,0.21202>,<-0.88745,0.10195,0.44949>,
            <-0.22052,-0.95029,-0.2198>,
    /*2*/<0.8858,-0.10065,-0.45302>,<0.199,0.96441,0.17413>,<-0.88949,0.10307,0.44518>,
            <-0.20273,-0.96218,-0.18196>,
    /*3*/<0.89014,-0.10244,-0.44403>,<0.12751,0.99153,0.02471>,<-0.89396,0.10374,0.43597>,
            <-0.13129,-0.99081,-0.03248>,
    /*4*/<0.89486,-0.1016,-0.43463>,<-0.0029,0.97171,-0.23614>,<-0.89884,0.10047,0.42661>,
            <-0.00084,-0.97347,0.22881>,
    /*5*/<0.16572,-0.35693,-0.91931>,<-0.39566,0.23286,-0.88839>,<-0.87037,-0.24332,-0.42809>,
            <-0.30892,-0.83305,-0.4589>,
    /*6*/<-0.43105,-0.36719,-0.82424>

    /* stem 0c1.10*/ 
    /*0*/<-0.4808,0.84025,-0.2506>,
    /*1*/<-0.31635,0.09513,0.94386>,<0.81909,0.52931,0.2212>,<0.32067,-0.10269,-0.94161>,
            <-0.81476,-0.53687,-0.21895>,
    /*2*/<-0.31971,0.10162,0.94205>,<0.84571,0.47862,0.236>,<0.3238,-0.10931,-0.93979>,
            <-0.84187,-0.48637,-0.23386>,
    /*3*/<-0.32589,0.11821,0.93799>,<0.90563,0.32231,0.27558>,<0.3288,-0.12648,-0.93589>,
            <-0.90325,-0.33044,-0.27375>,
    /*4*/<-0.32678,0.11257,0.93837>,<0.94533,0.06896,0.31875>,<0.32769,-0.12142,-0.93695>,
            <-0.94509,-0.0774,-0.31753>,
    /*5*/<-0.27278,-0.75305,0.59876>,<0.45841,-0.85196,0.25305>,<0.10819,-0.8692,-0.48247>,
            <-0.62298,-0.77019,-0.13676>,
    /*6*/<-0.10068,-0.99237,0.07114>

    /* stem 0c1.11*/ 
    /*0*/<0.85947,0.44538,-0.25088>,
    /*1*/<-0.27789,-0.01488,-0.9605>,<-0.43539,0.89323,0.11211>,<0.27016,0.01087,0.96276>,
            <0.42765,-0.89724,-0.10985>,
    /*2*/<-0.2743,-0.01293,-0.96156>,<-0.47181,0.87314,0.12256>,<0.26664,0.00874,0.96376>,
            <0.46429,-0.87747,-0.12037>,
    /*3*/<-0.28015,-0.01897,-0.95977>,<-0.60479,0.77964,0.16244>,<0.27307,0.0138,0.96189>,
            <0.59828,-0.78504,-0.16054>,
    /*4*/<-0.30022,-0.05055,-0.95253>,<-0.78788,0.57459,0.22159>,<0.2948,0.04364,0.95456>,
            <0.78327,-0.58147,-0.21994>,
    /*5*/<-0.50687,-0.77071,-0.38611>,<-0.82734,-0.47379,0.3017>,<-0.15463,-0.68913,0.70795>,
            <0.16588,-0.98594,0.02011>,
    /*6*/<-0.40466,-0.89302,0.19688>

    /* stem 0c1.12*/ 
    /*0*/<-0.44414,-0.31633,0.83826>,
    /*1*/<0.89755,-0.15274,0.41361>,<-0.00119,0.93723,0.34872>,<-0.89434,0.15503,-0.41968>,
            <0.00441,-0.93493,-0.35479>,
    /*2*/<0.90493,-0.14786,0.39906>,<0.01193,0.94646,0.32259>,<-0.90182,0.15007,-0.40521>,
            <-0.00877,-0.94438,-0.32874>,
    /*3*/<0.91344,-0.1442,0.38057>,<0.07907,0.98029,0.18108>,<-0.91049,0.14566,-0.38702>,
            <-0.07625,-0.97932,-0.18739>,
    /*4*/<0.90512,-0.14181,0.4008>,<0.19311,0.97797,-0.07921>,<-0.90223,0.14131,-0.40744>,
            <-0.1906,-0.97895,0.07299>,
    /*5*/<0.82204,-0.31946,-0.47138>,<0.4461,0.30119,-0.84278>,<-0.20943,-0.16811,-0.96326>,
            <0.16647,-0.78872,-0.59178>,
    /*6*/<0.37483,-0.29832,-0.87779>

    /* stem 0c1.13*/ 
    /*0*/<-0.83704,0.22057,-0.50072>,
    /*1*/<-0.47475,0.15324,0.86668>,<0.27022,0.96254,-0.02216>,<0.4794,-0.15446,-0.8639>,
            <-0.26556,-0.96377,0.02495>,
    /*2*/<-0.45969,0.14826,0.87561>,<0.3119,0.95011,0.00196>,<0.46435,-0.14963,-0.87292>,
            <-0.30734,-0.9516,0.00077>,
    /*3*/<-0.44504,0.14138,0.88428>,<0.45686,0.88511,0.08861>,<0.44948,-0.14351,-0.88169>,
            <-0.45276,-0.88746,-0.08616>,
    /*4*/<-0.44365,0.13865,0.88541>,<0.66745,0.71052,0.22288>,<0.4473,-0.14212,-0.88302>,
            <-0.66436,-0.71407,-0.22075>,
    /*5*/<0.13416,-0.57363,0.80806>,<0.82735,-0.31591,0.46443>,<0.64648,-0.73266,-0.21277>,
            <-0.04675,-0.9903,0.13082>,
    /*6*/<0.47773,-0.79941,0.3643>

    /* stem 0c1.14*/ 
    /*0*/<0.95804,0.18566,-0.21837>,
    /*1*/<-0.22535,0.00731,-0.97425>,<-0.18101,0.98225,0.04924>,<0.22191,-0.00798,0.97503>,
            <0.17756,-0.98292,-0.04845>,
    /*2*/<-0.23181,0.00575,-0.97274>,<-0.21772,0.97429,0.05787>,<0.22839,-0.00649,0.97355>,
            <0.21432,-0.97509,-0.05709>,
    /*3*/<-0.22763,0.00781,-0.97372>,<-0.36581,0.92619,0.0914>,<0.22431,-0.00896,0.97448>,
            <0.36268,-0.92749,-0.09066>,
    /*4*/<-0.22264,0.01105,-0.97484>,<-0.58512,0.79817,0.14337>,<0.21969,-0.01301,0.97548>,
            <0.58246,-0.80021,-0.1428>,
    /*5*/<-0.6949,-0.5717,-0.43621>,<-0.96103,-0.16703,0.22029>,<-0.4357,-0.58037,0.68799>,
            <-0.16955,-0.98502,0.03149>,
    /*6*/<-0.69206,-0.7052,0.15412>

    /* stem 0c1.15*/ 
    /*0*/<-0.3893,-0.71035,0.58638>,
    /*1*/<0.92124,-0.29337,0.25543>,<-0.00923,0.63997,0.76834>,<-0.92088,0.29404,-0.25598>,
            <0.0096,-0.63931,-0.76889>,
    /*2*/<0.91927,-0.29674,0.25862>,<0.01688,0.6855,0.72788>,<-0.9189,0.29738,-0.25919>,
            <-0.01652,-0.68488,-0.72847>,
    /*3*/<0.92001,-0.29596,0.25688>,<0.07702,0.78024,0.62072>,<-0.91965,0.29651,-0.25755>,
            <-0.07667,-0.77974,-0.62139>,
    /*4*/<0.91724,-0.29907,0.2631>,<0.16011,0.87931,0.44853>,<-0.91689,0.29947,-0.26388>,
            <-0.15979,-0.87897,-0.44931>,
    /*5*/<0.81803,0.03223,-0.57427>,<0.4074,0.73689,-0.53946>,<-0.23515,0.37999,-0.8946>,
            <0.17548,-0.32468,-0.9294>,
    /*6*/<0.3569,0.2524,-0.8994>

    /* stem 0c2*/ 
    /*0*/<-0.35588,-0.92366,-0.14215>,
    /*1*/<-0.50124,0.06576,0.86281>,<-0.78581,0.38293,-0.48566>,<0.50479,-0.05652,-0.86139>,
            <0.78937,-0.37369,0.48708>,
    /*2*/<-0.50114,0.06635,0.86282>,<-0.80218,0.33828,-0.49201>,<0.50451,-0.05703,-0.86152>,
            <0.8053,-0.32903,0.49318>,
    /*3*/<-0.4994,0.07535,0.86309>,<-0.83168,0.23821,-0.50156>,<0.502,-0.06572,-0.86237>,
            <0.83393,-0.22889,0.50216>,
    /*4*/<-0.49486,0.10882,0.86213>,<-0.85436,0.12474,-0.50449>,<0.49667,-0.09902,-0.86227>,
            <0.85579,-0.11526,0.50432>,
    /*5*/<-0.49367,0.13333,0.85937>,<-0.84705,0.15083,-0.50966>,<0.49521,-0.12349,-0.85995>,
            <0.84886,-0.14155,0.50931>,
    /*6*/<-0.49237,0.13547,0.85978>,<-0.8195,0.26068,-0.51036>,<0.49513,-0.12586,-0.85966>,
            <0.82225,-0.25148,0.51056>,
    /*7*/<-0.48464,0.15543,0.8608>,<-0.79853,0.32231,-0.50839>,<0.48799,-0.14602,-0.86055>,
            <0.80197,-0.313,0.50881>,
    /*8*/<-0.48316,0.15661,0.86141>,<-0.78163,0.36635,-0.50481>,<0.487,-0.14741,-0.86087>,
            <0.78554,-0.35721,0.5053>,
    /*9*/<-0.48532,0.15236,0.86096>,<-0.75137,0.43029,-0.5003>,<0.48949,-0.14331,-0.86015>,
            <0.75573,-0.42137,0.50131>,
    /*10*/<0.49119,0.8633,0.11592>

    /* stem 0c2.0*/ 
    /*0*/<-0.18808,0.69127,0.69769>,
    /*1*/<0.81481,-0.29093,0.50145>,<0.55046,0.65968,-0.51167>,<-0.81311,0.28471,-0.50773>,
            <-0.54877,-0.6659,0.50539>,
    /*2*/<0.81898,-0.31085,0.48233>,<0.5564,0.63216,-0.53925>,<-0.81759,0.3046,-0.48863>,
            <-0.55501,-0.63855,0.53312>,
    /*3*/<0.82056,-0.31585,0.47636>,<0.57401,0.48302,-0.66121>,<-0.81992,0.30888,-0.482>,
            <-0.57387,-0.48994,0.65622>,
    /*4*/<0.81888,-0.31826,0.47764>,<0.5503,0.21471,-0.80689>,<-0.81983,0.31011,-0.48136>,
            <-0.55144,-0.2224,0.80402>,
    /*5*/<0.2644,-0.961,0.08108>,<0.09962,-0.72521,-0.68128>,<-0.67205,-0.57415,-0.46764>,
            <-0.50725,-0.80983,0.29474>,
    /*6*/<-0.24938,-0.93909,-0.23647>

    /* stem 0c2.1*/ 
    /*0*/<-0.4301,0.82502,-0.36655>,
    /*1*/<-0.55101,0.07649,0.83098>,<0.71555,0.55567,0.42335>,<0.55488,-0.08391,-0.82769>,
            <-0.71168,-0.56309,-0.42005>,
    /*2*/<-0.55851,0.09201,0.82438>,<0.72903,0.52781,0.43582>,<0.56218,-0.09949,-0.82101>,
            <-0.72543,-0.53537,-0.43259>,
    /*3*/<-0.56684,0.11478,0.81579>,<0.78378,0.37757,0.49308>,<0.56959,-0.12279,-0.81271>,
            <-0.78158,-0.3855,-0.49044>,
    /*4*/<-0.5689,0.14052,0.81031>,<0.82034,0.13601,0.55547>,<0.56964,-0.14925,-0.80823>,
            <-0.82001,-0.14433,-0.55386>,
    /*5*/<-0.38643,-0.71155,0.58683>,<0.41269,-0.79214,0.44968>,<0.26541,-0.90055,-0.34434>,
            <-0.5337,-0.8199,-0.20719>,
    /*6*/<-0.07403,-0.98616,0.14834>

    /* stem 0c2.2*/ 
    /*0*/<0.97584,0.21351,0.04635>,
    /*1*/<0.04002,0.01291,-0.99912>,<-0.21831,0.97587,0.00385>,<-0.0488,-0.01484,0.9987>,
            <0.20953,-0.97779,-0.00427>,
    /*2*/<0.06889,0.02031,-0.99742>,<-0.25545,0.96682,0.00086>,<-0.0776,-0.02239,0.99673>,
            <0.2468,-0.96907,-0.00141>,
    /*3*/<0.1058,0.03371,-0.99382>,<-0.41584,0.90932,-0.01502>,<-0.11416,-0.03685,0.99278>,
            <0.40801,-0.91287,0.01408>,
    /*4*/<0.1025,0.02935,-0.9943>,<-0.63684,0.76989,-0.04128>,<-0.10977,-0.0346,0.99335>,
            <0.63036,-0.77525,0.04034>,
    /*5*/<-0.49907,-0.58491,-0.63939>,<-0.97428,-0.20229,-0.0993>,<-0.61121,-0.60762,0.50717>,
            <-0.13594,-0.99017,-0.03291>,
    /*6*/<-0.67918,-0.7295,-0.08088>

    /* stem 0c2.3*/ 
    /*0*/<-0.48977,0.5695,0.66014>,
    /*1*/<0.72516,-0.16046,0.66962>,<0.48948,0.80411,-0.33736>,<-0.72075,0.15534,-0.67556>,
            <-0.48508,-0.80924,0.33142>,
    /*2*/<0.73045,-0.16673,0.6623>,<0.49046,0.80293,-0.33875>,<-0.72612,0.16161,-0.66831>,
            <-0.48609,-0.80806,0.33278>,
    /*3*/<0.72304,-0.15336,0.67357>,<0.56106,0.70453,-0.43458>,<-0.71895,0.14766,-0.6792>,
            <-0.55762,-0.71043,0.42936>,
    /*4*/<0.70413,-0.09687,0.70344>,<0.6539,0.48511,-0.58059>,<-0.70113,0.08938,-0.70741>,
            <-0.65158,-0.49234,0.5771>,
    /*5*/<0.5903,-0.78986,0.16636>,<0.579,-0.54145,-0.60958>,<-0.21382,-0.7236,-0.65627>,
            <-0.20253,-0.97193,0.1197>,
    /*6*/<0.23031,-0.92582,-0.29969>

    /* stem 0c2.4*/ 
    /*0*/<-0.30708,-0.59542,-0.74241>,
    /*1*/<-0.95021,0.18484,0.25085>,<-0.01075,0.78516,-0.6192>,<0.95298,-0.17948,-0.24417>,
            <0.01351,-0.7798,0.62588>,
    /*2*/<-0.94938,0.18621,0.253>,<0.00661,0.81704,-0.57655>,<0.95217,-0.18106,-0.24617>,
            <-0.00386,-0.81213,0.58346>,
    /*3*/<-0.94862,0.18687,0.25534>,<0.05732,0.89552,-0.44131>,<0.95141,-0.18276,-0.24782>,
            <-0.05465,-0.89197,0.44878>,
    /*4*/<-0.9466,0.18738,0.26239>,<0.12505,0.963,-0.23873>,<0.9493,-0.18509,-0.2541>,
            <-0.12255,-0.96129,0.2468>,
    /*5*/<-0.31243,0.17623,0.93345>,<0.3219,0.6332,0.70387>,<0.77765,-0.03789,0.62756>,
            <0.1433,-0.49486,0.85707>,
    /*6*/<0.28458,0.08463,0.95491>

    /* stem 0c2.5*/ 
    /*0*/<0.86126,0.45913,0.21779>,
    /*1*/<0.29593,-0.1151,-0.94825>,<-0.41418,0.87907,-0.23598>,<-0.30368,0.11097,0.94629>,
            <0.40642,-0.88321,0.23402>,
    /*2*/<0.31022,-0.10678,-0.94465>,<-0.44979,0.8587,-0.24561>,<-0.31784,0.10247,0.94259>,
            <0.44227,-0.86314,0.24369>,
    /*3*/<0.3292,-0.09319,-0.93965>,<-0.57322,0.77067,-0.27837>,<-0.33624,0.08794,0.93766>,
            <0.56666,-0.77613,0.27661>,
    /*4*/<0.32137,-0.1038,-0.94125>,<-0.71545,0.62537,-0.31151>,<-0.32728,0.09713,0.93992>,
            <0.7101,-0.63205,0.31028>,
    /*5*/<-0.27559,-0.74255,-0.61047>,<-0.89892,-0.35523,-0.25645>,<-0.63927,-0.60533,0.47424>,
            <-0.01592,-0.99262,0.12023>,
    /*6*/<-0.55964,-0.82453,-0.08333>

    /* stem 0c2.6*/ 
    /*0*/<-0.81985,0.46149,0.33892>,
    /*1*/<0.39898,0.02589,0.91659>,<0.41791,0.88462,-0.20688>,<-0.3916,-0.03005,-0.91964>,
            <-0.41053,-0.88877,0.20383>,
    /*2*/<0.41284,0.01643,0.91066>,<0.47464,0.84915,-0.23164>,<-0.40566,-0.02086,-0.91378>,
            <-0.46768,-0.8538,0.22871>,
    /*3*/<0.42229,0.00847,0.90642>,<0.61926,0.72795,-0.29429>,<-0.41594,-0.01418,-0.90928>,
            <-0.61357,-0.73378,0.29171>,
    /*4*/<0.413,0.02248,0.91045>,<0.76949,0.52759,-0.35991>,<-0.4081,-0.02978,-0.91245>,
            <-0.76532,-0.53479,0.35818>,
    /*5*/<0.5566,-0.72065,0.41335>,<0.79696,-0.50315,-0.3342>,<0.08774,-0.7648,-0.63827>,
            <-0.15266,-0.98222,0.10929>,
    /*6*/<0.39416,-0.90869,-0.13759>

    /* stem 0c2.7*/ 
    /*0*/<-0.21978,0.4399,-0.87074>,
    /*1*/<-0.90318,0.24127,0.35503>,<0.36725,0.86249,0.3482>,<0.90516,-0.24523,-0.34719>,
            <-0.36527,-0.86645,-0.34037>,
    /*2*/<-0.9004,0.23456,0.36641>,<0.37928,0.83684,0.39477>,<0.9024,-0.23876,-0.3587>,
            <-0.37745,-0.84119,-0.38721>,
    /*3*/<-0.89409,0.20903,0.39613>,<0.41943,0.714,0.56061>,<0.89585,-0.21448,-0.38918>,
            <-0.41817,-0.7196,-0.55436>,
    /*4*/<-0.89267,0.18459,0.41118>,<0.44542,0.49986,0.74279>,<0.89352,-0.19187,-0.40595>,
            <-0.44488,-0.50688,-0.73834>,
    /*5*/<-0.50601,-0.62908,0.5901>,<0.2676,-0.51087,0.81695>,<0.52318,-0.84393,0.11862>,
            <-0.25044,-0.96206,-0.10826>,
    /*6*/<0.0105,-0.90107,0.43354>

    /* stem 0c2.8*/ 
    /*0*/<0.85152,0.21113,0.47994>,
    /*1*/<0.50757,-0.13342,-0.85122>,<-0.11952,0.96748,-0.22294>,<-0.51523,0.13152,0.8469>,
            <0.11186,-0.96938,0.21862>,
    /*2*/<0.50828,-0.13331,-0.85081>,<-0.16025,0.956,-0.24573>,<-0.51592,0.1312,0.84653>,
            <0.1527,-0.9583,0.24153>,
    /*3*/<0.53705,-0.11861,-0.83517>,<-0.30547,0.8935,-0.32915>,<-0.54427,0.1153,0.83095>,
            <0.2986,-0.89718,0.32543>,
    /*4*/<0.55547,-0.10288,-0.82515>,<-0.51374,0.73852,-0.43664>,<-0.56168,0.09743,0.8216>,
            <0.50825,-0.74412,0.43355>,
    /*5*/<-0.15188,-0.68799,-0.70965>,<-0.81728,-0.26028,-0.51411>,<-0.78995,-0.56352,0.24169>,
            <-0.12449,-0.99115,0.04618>,
    /*6*/<-0.57614,-0.76558,-0.28626>

    /* stem 0c2.9*/ 
    /*0*/<-0.54038,0.52025,0.66131>,
    /*1*/<0.65503,-0.2393,0.71671>,<0.53355,0.81813,-0.21444>,<-0.65017,0.23462,-0.72266>,
            <-0.52869,-0.82281,0.20849>,
    /*2*/<0.66959,-0.25565,0.69735>,<0.55903,0.791,-0.24862>,<-0.66503,0.25086,-0.70343>,
            <-0.55453,-0.79598,0.24273>,
    /*3*/<0.67427,-0.25881,0.69165>,<0.65275,0.65138,-0.3868>,<-0.67059,0.25293,-0.69737>,
            <-0.64984,-0.65734,0.3816>,
    /*4*/<0.66969,-0.24429,0.70131>,<0.72952,0.3921,-0.56041>,<-0.66788,0.23661,-0.70566>,
            <-0.72832,-0.39936,0.55682>,
    /*5*/<0.40698,-0.90581,0.11774>,<0.44998,-0.61898,-0.64372>,<-0.36342,-0.62428,-0.69151>,
            <-0.40642,-0.911,0.06999>,
    /*6*/<0.02665,-0.936,-0.35099>

    /* stem 0c2.10*/ 
    /*0*/<0.16306,-0.30534,-0.93818>,
    /*1*/<-0.91606,0.30943,-0.25513>,<0.36746,0.9024,-0.22503>,<0.91459,-0.30668,0.26357>,
            <-0.36893,-0.89966,0.23347>,
    /*2*/<-0.91774,0.31203,-0.24577>,<0.36184,0.91223,-0.1921>,<0.91629,-0.30945,0.25427>,
            <-0.36338,-0.90979,0.20059>,
    /*3*/<-0.9197,0.31338,-0.23653>,<0.33403,0.94105,-0.05329>,<0.91799,-0.31172,0.24521>,
            <-0.33586,-0.93989,0.06177>,
    /*4*/<-0.91801,0.31307,-0.24342>,<0.27604,0.94585,0.1708>,<0.91558,-0.3133,0.2521>,
            <-0.27848,-0.94658,-0.16258>,
    /*5*/<-0.79209,0.02137,0.61003>,<-0.12583,0.37461,0.9186>,<0.26149,-0.34207,0.90256>,
            <-0.40475,-0.6953,0.59392>,
    /*6*/<-0.32458,-0.19618,0.92529>

    /* stem 0c2.11*/ 
    /*0*/<0.93648,-0.05543,0.34632>,
    /*1*/<0.33518,-0.10555,-0.93622>,<0.08424,0.99308,-0.08182>,<-0.34361,0.10605,0.93311>,
            <-0.09267,-0.99258,0.0787>,
    /*2*/<0.34799,-0.10561,-0.93153>,<0.02722,0.99425,-0.10358>,<-0.35639,0.10582,0.92833>,
            <-0.03557,-0.9943,0.10049>,
    /*3*/<0.37684,-0.1011,-0.92074>,<-0.1752,0.96768,-0.18137>,<-0.38512,0.09976,0.91746>,
            <0.16749,-0.96958,0.17849>,
    /*4*/<0.36858,-0.10882,-0.9232>,<-0.44195,0.85453,-0.27288>,<-0.37623,0.10486,0.92057>,
            <0.43523,-0.85872,0.2705>,
    /*5*/<-0.41525,-0.58223,-0.69898>,<-0.93582,-0.06376,-0.34667>,<-0.82103,-0.43526,0.3694>,
            <-0.30038,-0.95367,0.0171>,
    /*6*/<-0.75627,-0.62243,-0.20162>

    /* stem 0c2.12*/ 
    /*0*/<-0.96314,-0.01288,0.26871>,
    /*1*/<0.27185,-0.15094,0.95043>,<0.03265,0.9885,0.14767>,<-0.26319,0.15106,-0.95285>,
            <-0.02398,-0.98838,-0.15009>,
    /*2*/<0.26981,-0.15098,0.951>,<0.07686,0.98783,0.13524>,<-0.26115,0.15088,-0.95343>,
            <-0.06827,-0.98812,-0.13769>,
    /*3*/<0.27499,-0.15299,0.9492>,<0.24988,0.96477,0.08234>,<-0.26647,0.15169,-0.95183>,
            <-0.24186,-0.96659,-0.08487>,
    /*4*/<0.28571,-0.1599,0.94488>,<0.46219,0.88672,0.01>,<-0.27792,0.15644,-0.94778>,
            <-0.45502,-0.89039,-0.01273>,
    /*5*/<0.81005,-0.51703,0.27657>,<0.9583,0.05983,-0.27944>,<0.48103,-0.33082,-0.81189>,
            <0.33275,-0.90764,-0.25586>,
    /*6*/<0.78979,-0.51865,-0.32747>

    /* stem 0c2.13*/ 
    /*0*/<0.48213,0.69985,-0.52703>,
    /*1*/<-0.87782,0.39048,-0.27741>,<0.00984,0.59377,0.80458>,<0.87421,-0.39572,0.28136>,
            <-0.01346,-0.59901,-0.80063>,
    /*2*/<-0.88782,0.37493,-0.26686>,<-0.00855,0.56505,0.82501>,<0.88435,-0.38031,0.27073>,
            <0.00502,-0.57047,-0.8213>,
    /*3*/<-0.89762,0.35751,-0.25782>,<-0.07968,0.44403,0.89246>,<0.89431,-0.36344,0.261>,
            <0.0765,-0.44997,-0.88976>,
    /*4*/<-0.89949,0.35271,-0.2579>,<-0.18096,0.23583,0.9548>,<0.8964,-0.35936,0.25947>,
            <0.17808,-0.24228,-0.95373>,
    /*5*/<-0.8227,-0.55514,-0.12241>,<-0.43614,-0.68524,0.58329>,<0.21406,-0.96079,0.17625>,
            <-0.17247,-0.83063,-0.52945>,
    /*6*/<-0.37238,-0.92749,0.03294>

    /* stem 0c2.14*/ 
    /*0*/<0.5274,0.42242,0.73716>,
    /*1*/<0.84586,-0.32446,-0.42337>,<0.05874,0.84554,-0.53067>,<-0.84907,0.32189,0.41889>,
            <-0.06194,-0.84811,0.52619>,
    /*2*/<0.85046,-0.32049,-0.41714>,<0.03389,0.82419,-0.5653>,<-0.85363,0.31778,0.41271>,
            <-0.03707,-0.82699,0.56099>,
    /*3*/<0.87009,-0.29778,-0.39277>,<-0.05599,0.72625,-0.68515>,<-0.87307,0.29432,0.38875>,
            <0.05306,-0.72981,0.68159>,
    /*4*/<0.89497,-0.25353,-0.36708>,<-0.17115,0.55871,-0.81151>,<-0.89751,0.24894,0.36402>,
            <0.16872,-0.56323,0.80889>,
    /*5*/<0.22507,-0.82616,-0.51652>,<-0.42353,-0.42246,-0.80134>,<-0.81888,-0.56472,-0.10259>,
            <-0.17026,-0.9684,0.18224>,
    /*6*/<-0.36337,-0.85113,-0.37886>

    /* stem 0c2.15*/ 
    /*0*/<-0.40012,0.85665,0.32567>,
    /*1*/<0.22411,-0.25503,0.9406>,<0.88955,0.44778,-0.09054>,<-0.22266,0.25191,-0.94179>,
            <-0.88809,-0.4509,0.08935>,
    /*2*/<0.23456,-0.28124,0.93053>,<0.90849,0.40355,-0.10861>,<-0.23321,0.27811,-0.93181>,
            <-0.90722,-0.40671,0.1074>,
    /*3*/<0.23495,-0.27116,0.93342>,<0.95546,0.2455,-0.16379>,<-0.23406,0.26784,-0.9346>,
            <-0.95482,-0.24874,0.16261>,
    /*4*/<0.23524,-0.25599,0.93762>,<0.96871,-0.00518,-0.24814>,<-0.23522,0.25248,-0.93857>,
            <-0.96893,0.00184,0.24734>,
    /*5*/<-0.03881,-0.93642,0.34873>,<0.37888,-0.85768,-0.34761>,<-0.30107,-0.61585,-0.72807>,
            <-0.71875,-0.69455,-0.03172>,
    /*6*/<-0.20804,-0.95016,-0.2322>

    /* stem 0c2.16*/ 
    /*0*/<-0.15392,-0.80595,-0.57162>,
    /*1*/<-0.7323,0.48203,-0.48103>,<0.66335,0.34522,-0.66392>,<0.73255,-0.48072,0.48196>,
            <-0.6631,-0.34391,0.66485>,
    /*2*/<-0.73204,0.48386,-0.47958>,<0.67098,0.38965,-0.63084>,<0.73226,-0.48257,0.48055>,
            <-0.67079,-0.38838,0.63182>,
    /*3*/<-0.73219,0.50653,-0.45533>,<0.68437,0.53722,-0.49298>,<0.73228,-0.50538,0.45647>,
            <-0.68438,-0.53617,0.49411>,
    /*4*/<-0.73824,0.5254,-0.42304>,<0.65682,0.70417,-0.26968>,<0.73805,-0.52455,0.42441>,
            <-0.65706,-0.70344,0.27099>,
    /*5*/<-0.62155,0.61097,0.4903>,<0.16859,0.74691,0.6432>,<0.23286,0.00287,0.97251>,
            <-0.55727,-0.13307,0.8196>,
    /*6*/<-0.23798,0.37583,0.89561>

    /* stem 0c3*/ 
    /*0*/<-0.08872,-0.92853,-0.3605>,
    /*1*/<-0.98123,0.0249,0.19122>,<-0.16813,0.37534,-0.91151>,<0.98212,-0.01562,-0.18762>,
            <0.16902,-0.36605,0.91512>,
    /*2*/<-0.98009,0.03619,0.19525>,<-0.17021,0.35566,-0.91898>,<0.98107,-0.02688,-0.19177>,
            <0.17112,-0.34633,0.92237>,
    /*3*/<-0.98087,0.02982,0.19237>,<-0.17425,0.29586,-0.9392>,<0.98169,-0.02035,-0.18937>,
            <0.17513,-0.28644,0.94196>,
    /*4*/<-0.98276,-0.00722,0.18473>,<-0.18084,0.22977,-0.9563>,<0.98308,0.01689,-0.18238>,
            <0.18123,-0.22018,0.95848>,
    /*5*/<-0.983,-0.03596,0.18007>,<-0.18391,0.25851,-0.94834>,<0.98301,0.04567,-0.17778>,
            <0.18403,-0.24903,0.95085>,
    /*6*/<-0.98259,-0.03049,0.18329>,<-0.18037,0.375,-0.90931>,<0.98288,0.03988,-0.17989>,
            <0.18062,-0.36601,0.91291>,
    /*7*/<-0.97956,0.00538,0.20106>,<-0.17886,0.43494,-0.88252>,<0.98043,0.00363,-0.19684>,
            <0.17959,-0.42607,0.88668>,
    /*8*/<-0.9775,0.02014,0.20998>,<-0.17807,0.45671,-0.87161>,<0.97855,-0.01118,-0.20571>,
            <0.17917,-0.4478,0.876>,
    /*9*/<-0.97736,0.02058,0.21059>,<-0.16823,0.52677,-0.8332>,<0.97853,-0.01191,-0.20574>,
            <0.16941,-0.51827,0.83827>,
    /*10*/<0.13828,0.82222,0.55212>

    /* stem 0c3.0*/ 
    /*0*/<-0.69369,0.70845,-0.12997>,
    /*1*/<-0.41361,-0.25077,0.87524>,<0.59059,0.65771,0.46756>,<0.41985,0.2444,-0.87407>,
            <-0.58435,-0.66409,-0.46639>,
    /*2*/<-0.4365,-0.22487,0.87115>,<0.62616,0.61793,0.47548>,<0.44245,0.21829,-0.86982>,
            <-0.62032,-0.6246,-0.47442>,
    /*3*/<-0.44974,-0.2091,0.86834>,<0.71953,0.49227,0.48985>,<0.45483,0.20177,-0.86742>,
            <-0.71493,-0.49964,-0.48911>,
    /*4*/<-0.44751,-0.21824,0.86724>,<0.81859,0.28921,0.49625>,<0.4512,0.21002,-0.86735>,
            <-0.81546,-0.29725,-0.49665>,
    /*5*/<-0.05011,-0.9064,0.41943>,<0.70212,-0.68355,0.19946>,<0.46852,-0.66559,-0.58093>,
            <-0.28373,-0.88837,-0.36095>,
    /*6*/<0.25595,-0.96163,-0.0988>

    /* stem 0c3.1*/ 
    /*0*/<0.73815,-0.45419,-0.49884>,
    /*1*/<-0.38226,0.33465,-0.86133>,<0.55482,0.82852,0.07565>,<0.37562,-0.33056,0.86582>,
            <-0.56147,-0.82443,-0.07116>,
    /*2*/<-0.38532,0.33648,-0.85925>,<0.54921,0.8319,0.07946>,<0.37867,-0.33243,0.86377>,
            <-0.55588,-0.82787,-0.07496>,
    /*3*/<-0.38444,0.33593,-0.85986>,<0.4541,0.87993,0.13972>,<0.37744,-0.3324,0.86432>,
            <-0.46113,-0.87694,-0.13542>,
    /*4*/<-0.36956,0.33287,-0.86754>,<0.25595,0.93444,0.2476>,<0.36166,-0.33115,0.87152>,
            <-0.26361,-0.93329,-0.24388>,
    /*5*/<-0.95804,0.21612,-0.18827>,<-0.6649,0.5671,0.48611>,<-0.54958,-0.16787,0.8184>,
            <-0.84265,-0.51885,0.144>,
    /*6*/<-0.92225,0.02952,0.38547>

    /* stem 0c3.2*/ 
    /*0*/<0.17248,-0.88975,0.4226>,
    /*1*/<0.94516,0.03399,-0.32484>,<0.27389,0.45946,0.84492>,<-0.94671,-0.02599,0.32104>,
            <-0.27544,-0.45145,-0.84872>,
    /*2*/<0.94279,0.04437,-0.33043>,<0.26497,0.50016,0.82439>,<-0.9445,-0.03646,0.32649>,
            <-0.26668,-0.49241,-0.82851>,
    /*3*/<0.94047,0.05214,-0.33586>,<0.22469,0.64785,0.72788>,<-0.94258,-0.04489,0.33094>,
            <-0.22686,-0.64128,-0.73301>,
    /*4*/<0.93898,0.05344,-0.33979>,<0.14594,0.83166,0.53576>,<-0.94164,-0.04789,0.33319>,
            <-0.1485,-0.82697,-0.54228>,
    /*5*/<0.27049,0.38386,-0.88288>,<-0.21024,0.87208,-0.4419>,<-0.8105,0.32304,-0.48861>,
            <-0.32973,-0.16521,-0.92951>,
    /*6*/<-0.33033,0.43243,-0.83898>

    /* stem 0c3.3*/ 
    /*0*/<-0.78346,0.29688,-0.54594>,
    /*1*/<-0.60155,-0.16551,0.7815>,<0.14518,0.93935,0.31072>,<0.6086,0.16284,-0.77659>,
            <-0.13813,-0.94202,-0.3058>,
    /*2*/<-0.61043,-0.16181,0.77537>,<0.17332,0.92769,0.33068>,<0.61739,0.15897,-0.77043>,
            <-0.16638,-0.93066,-0.32586>,
    /*3*/<-0.60367,-0.16791,0.77935>,<0.30435,0.85642,0.41703>,<0.61047,0.16407,-0.77486>,
            <-0.29806,-0.86063,-0.41288>,
    /*4*/<-0.5876,-0.18649,0.78736>,<0.49216,0.6902,0.53047>,<0.59368,0.18067,-0.78415>,
            <-0.48676,-0.69608,-0.52776>,
    /*5*/<0.12679,-0.75021,0.64893>,<0.7962,-0.30282,0.5238>,<0.80498,-0.53461,-0.2573>,
            <0.13552,-0.98192,-0.13219>,
    /*6*/<0.56999,-0.78595,0.23957>

    /* stem 0c3.4*/ 
    /*0*/<0.83772,-0.54594,-0.01336>,
    /*1*/<0.11052,0.20165,-0.9732>,<0.53023,0.81625,0.22932>,<-0.11806,-0.19673,0.97332>,
            <-0.53777,-0.81134,-0.2292>,
    /*2*/<0.07775,0.22098,-0.97217>,<0.49791,0.83587,0.2311>,<-0.08538,-0.2163,0.97259>,
            <-0.50561,-0.83129,-0.2309>,
    /*3*/<0.04955,0.23447,-0.97086>,<0.32508,0.91569,0.23629>,<-0.05776,-0.23087,0.97127>,
            <-0.33314,-0.91286,-0.23602>,
    /*4*/<0.03809,0.2336,-0.97159>,<0.0425,0.97052,0.23724>,<-0.04704,-0.23249,0.97146>,
            <-0.05082,-0.97004,-0.23757>,
    /*5*/<-0.79967,0.06536,-0.59688>,<-0.86549,0.49199,0.09419>,<-0.82796,-0.19905,0.52427>,
            <-0.76205,-0.62567,-0.16679>,
    /*6*/<-0.99566,-0.08178,-0.04441>

    /* stem 0c3.5*/ 
    /*0*/<-0.50783,-0.72758,0.46124>,
    /*1*/<0.76714,-0.13118,0.62793>,<-0.39407,0.67599,0.62269>,<-0.76257,0.13773,-0.63208>,
            <0.39864,-0.66944,-0.62684>,
    /*2*/<0.77049,-0.12688,0.6247>,<-0.36693,0.71329,0.59714>,<-0.76587,0.13328,-0.62904>,
            <0.37162,-0.70712,-0.60157>,
    /*3*/<0.75626,-0.14028,0.63906>,<-0.26384,0.82495,0.49985>,<-0.75103,0.14569,-0.644>,
            <0.26889,-0.82019,-0.50497>,
    /*4*/<0.73935,-0.14979,0.65644>,<-0.09568,0.94185,0.32214>,<-0.73341,0.15314,-0.66231>,
            <0.10137,-0.93927,-0.32786>,
    /*5*/<0.97618,0.05046,-0.21102>,<0.54912,0.69881,-0.45839>,<0.12381,0.22466,-0.96654>,
            <0.5508,-0.42371,-0.7191>,
    /*6*/<0.67289,0.1683,-0.72034>

    /* stem 0c3.6*/ 
    /*0*/<0.01678,-0.57463,-0.81824>,
    /*1*/<-0.99936,0.02057,-0.02943>,<0.03367,0.82079,-0.57024>,<0.9992,-0.0154,0.0368>,
            <-0.03382,-0.81562,0.5776>,
    /*2*/<-0.99937,0.02108,-0.02845>,<0.03293,0.84545,-0.53303>,<0.99923,-0.01607,0.03593>,
            <-0.03309,-0.84065,0.54057>,
    /*3*/<-0.99935,0.01984,-0.03018>,<0.02886,0.92815,-0.37109>,<0.99914,-0.01588,0.03829>,
            <-0.02906,-0.92491,0.37906>,
    /*4*/<-0.99899,0.01747,-0.04148>,<0.01907,0.99646,-0.08194>,<0.9986,-0.01596,0.05036>,
            <-0.0194,-0.99573,0.09026>,
    /*5*/<-0.62059,-0.04836,0.78264>,<-0.03725,0.51583,0.85588>,<0.52977,-0.06926,0.84531>,
            <-0.05356,-0.63343,0.77194>,
    /*6*/<-0.05556,-0.07195,0.99586>

    /* stem 0c3.7*/ 
    /*0*/<0.48503,-0.68316,0.54593>,
    /*1*/<0.8296,0.17076,-0.53161>,<0.26777,0.71382,0.64712>,<-0.83396,-0.16461,0.5267>,
            <-0.27214,-0.70767,-0.65203>,
    /*2*/<0.84617,0.14909,-0.51164>,<0.23774,0.75655,0.60919>,<-0.85034,-0.14311,0.5064>,
            <-0.24209,-0.75087,-0.61448>,
    /*3*/<0.87131,0.11942,-0.47599>,<0.15688,0.85364,0.49669>,<-0.87536,-0.11444,0.46973>,
            <-0.16096,-0.84921,-0.50293>,
    /*4*/<0.87912,0.11424,-0.46271>,<0.06188,0.93525,0.34854>,<-0.8833,-0.11081,0.45552>,
            <-0.06594,-0.9323,-0.35563>,
    /*5*/<0.11885,0.27299,-0.95465>,<-0.37509,0.76139,-0.52877>,<-0.89494,0.14304,-0.42264>,
            <-0.40099,-0.34537,-0.84849>,
    /*6*/<-0.47475,0.25449,-0.84252>

    /* stem 0c3.8*/ 
    /*0*/<-0.70859,-0.6821,-0.18065>,
    /*1*/<0.19338,-0.4281,0.8828>,<-0.67631,0.59368,0.43607>,<-0.18701,0.43424,-0.88117>,
            <0.68269,-0.58754,-0.43444>,
    /*2*/<0.18593,-0.4352,0.88093>,<-0.67137,0.5983,0.43737>,<-0.17952,0.44127,-0.87923>,
            <0.6778,-0.59222,-0.43573>,
    /*3*/<0.18906,-0.43353,0.88108>,<-0.58174,0.67414,0.4551>,<-0.18226,0.43926,-0.87968>,
            <0.58869,-0.66891,-0.45389>,
    /*4*/<0.21345,-0.42266,0.88079>,<-0.40701,0.78162,0.47266>,<-0.20564,0.42714,-0.88049>,
            <0.4147,-0.77766,-0.47252>,
    /*5*/<0.87935,0.07597,0.47008>,<0.56481,0.7905,0.23686>,<0.624,0.56196,-0.54298>,
            <0.93849,-0.15259,-0.30976>,
    /*6*/<0.91963,0.39024,-0.0446>

    /* stem 0c3.9*/ 
    /*0*/<-0.0231,0.92735,-0.37348>,
    /*1*/<-0.99384,0.01462,0.10982>,<0.10741,0.36955,0.92298>,<0.99405,-0.02296,-0.10646>,
            <-0.1072,-0.37789,-0.91962>,
    /*2*/<-0.99399,0.02167,0.10727>,<0.10802,0.32233,0.94044>,<0.99411,-0.03009,-0.10411>,
            <-0.10789,-0.33077,-0.93752>,
    /*3*/<-0.99377,0.04326,0.10273>,<0.10533,0.13569,0.98514>,<0.99354,-0.05207,-0.10081>,
            <-0.10554,-0.14417,-0.98391>,
    /*4*/<-0.99341,0.05189,0.10221>,<0.0939,-0.15125,0.98403>,<0.99284,-0.06087,-0.10282>,
            <-0.09452,0.14298,-0.9852>,
    /*5*/<-0.63559,-0.75228,-0.17349>,<-0.0162,-0.94778,0.31851>,<0.50939,-0.81061,-0.28884>,
            <-0.10999,-0.61501,-0.78081>,
    /*6*/<-0.0772,-0.95606,-0.28282>

    /* stem 0c3.10*/ 
    /*0*/<0.88159,-0.45848,0.11223>,
    /*1*/<0.29944,0.37036,-0.8793>,<0.3576,0.81085,0.46329>,<-0.30738,-0.36623,0.87829>,
            <-0.36554,-0.80673,-0.4643>,
    /*2*/<0.30752,0.36647,-0.87814>,<0.31621,0.83132,0.45707>,<-0.3155,-0.36249,0.87696>,
            <-0.32423,-0.82755,-0.4583>,
    /*3*/<0.3549,0.35113,-0.86646>,<0.15264,0.89528,0.41853>,<-0.36306,-0.34802,0.86433>,
            <-0.16066,-0.89289,-0.42063>,
    /*4*/<0.37906,0.34841,-0.85728>,<-0.10134,0.93575,0.33778>,<-0.38735,-0.34741,0.85397>,
            <0.09361,-0.93533,-0.34116>,
    /*5*/<-0.52611,0.12793,-0.84074>,<-0.86473,0.468,-0.18225>,<-0.95069,-0.26915,0.15412>,
            <-0.61198,-0.60921,-0.50433>,
    /*6*/<-0.90339,-0.08639,-0.42002>

    /* stem 0c3.11*/ 
    /*0*/<-0.77089,0.36147,0.52447>,
    /*1*/<0.36738,-0.42746,0.82602>,<0.52624,0.82783,0.19437>,<-0.36044,0.4242,-0.83074>,
            <-0.5193,-0.83108,-0.19909>,
    /*2*/<0.34245,-0.41491,0.84296>,<0.54427,0.81875,0.18279>,<-0.33549,0.41146,-0.84744>,
            <-0.5374,-0.82224,-0.18742>,
    /*3*/<0.31845,-0.39987,0.85947>,<0.65704,0.74661,0.10431>,<-0.3119,0.39556,-0.86386>,
            <-0.65107,-0.75121,-0.10861>,
    /*4*/<0.32443,-0.41049,0.8522>,<0.81212,0.58271,-0.03029>,<-0.31954,0.40453,-0.85688>,
            <-0.80795,-0.58868,0.02595>,
    /*5*/<0.49339,-0.86768,0.0609>,<0.806,-0.34534,-0.48072>,<0.11801,-0.38457,-0.91552>,
            <-0.19463,-0.90684,-0.37385>,
    /*6*/<0.37401,-0.76603,-0.52279>

    /* stem 0c3.12*/ 
    /*0*/<0.46835,0.22448,-0.85455>,
    /*1*/<-0.87143,0.28873,-0.39653>,<0.15563,0.9294,0.33467>,<0.86724,-0.29074,0.40417>,
            <-0.15982,-0.9314,-0.32702>,
    /*2*/<-0.8736,0.2875,-0.39264>,<0.1417,0.92212,0.36003>,<0.86943,-0.28964,0.40026>,
            <-0.1459,-0.92437,-0.35249>,
    /*3*/<-0.86625,0.29369,-0.40418>,<0.05209,0.86108,0.5058>,<0.86182,-0.29678,0.41133>,
            <-0.05625,-0.86462,-0.49928>,
    /*4*/<-0.84333,0.32065,-0.43125>,<-0.0958,0.70508,0.70263>,<0.83851,-0.32582,0.43675>,
            <0.09148,-0.71033,-0.6979>,
    /*5*/<-0.91556,-0.38622,0.11218>,<-0.53189,-0.23225,0.81434>,<0.0388,-0.7814,0.62282>,
            <-0.34481,-0.93531,-0.07938>,
    /*6*/<-0.53634,-0.71427,0.44962>

    /* stem 0c3.13*/ 
    /*0*/<0.21463,0.00317,0.97669>,
    /*1*/<0.97591,-0.00484,-0.21811>,<0.00327,0.99997,-0.00764>,<-0.97745,0.00482,0.21111>,
            <-0.00481,-0.99999,0.00063>,
    /*2*/<0.98005,-0.00368,-0.19873>,<-0.00856,0.9977,-0.06718>,<-0.98145,0.00344,0.1917>,
            <0.0071,-0.99816,0.06025>,
    /*3*/<0.98688,0.00325,-0.16142>,<-0.03965,0.97061,-0.23738>,<-0.98799,-0.00455,0.15446>,
            <0.03852,-0.97224,0.23078>,
    /*4*/<0.99072,0.01685,-0.1349>,<-0.07774,0.8763,-0.47545>,<-0.99152,-0.01982,0.12841>,
            <0.07697,-0.87955,0.46953>,
    /*5*/<0.50364,-0.47416,-0.72216>,<-0.12271,-0.02769,-0.99206>,<-0.6399,-0.50425,-0.57988>,
            <-0.01355,-0.95067,-0.30992>,
    /*6*/<-0.08337,-0.59865,-0.79666>

    /* stem 0c3.14*/ 
    /*0*/<-0.32199,0.94218,0.09288>,
    /*1*/<-0.64843,-0.29362,0.70237>,<0.68987,0.16346,0.70523>,<0.65012,0.28868,-0.70286>,
            <-0.68818,-0.16841,-0.70572>,
    /*2*/<-0.63772,-0.32722,0.69731>,<0.70559,0.11854,0.69864>,<0.63944,0.32233,-0.69801>,
            <-0.70403,-0.12346,-0.69936>,
    /*3*/<-0.63229,-0.34424,0.69405>,<0.74672,-0.03938,0.66397>,<0.63358,0.33933,-0.6953>,
            <-0.74567,0.03464,-0.66542>,
    /*4*/<-0.63278,-0.32863,0.70113>,<0.77427,-0.26806,0.57328>,<0.63305,0.32378,-0.70314>,
            <-0.77427,0.26354,-0.57538>,
    /*5*/<-0.44525,-0.8954,0.00317>,<0.3626,-0.92611,-0.10408>,<0.28483,-0.5186,-0.80618>,
            <-0.52301,-0.48784,-0.6989>,
    /*6*/<-0.09817,-0.86536,-0.49144>

    /* stem 0c3.15*/ 
    /*0*/<0.65752,-0.64038,-0.39696>,
    /*1*/<0.03465,0.55421,-0.83166>,<0.75127,0.53435,0.38738>,<-0.03726,-0.55167,0.83323>,
            <-0.75388,-0.53181,-0.3858>,
    /*2*/<0.04841,0.54207,-0.83894>,<0.71255,0.57053,0.40837>,<-0.0511,-0.53955,0.8404>,
            <-0.7153,-0.56812,-0.40693>,
    /*3*/<0.08055,0.51956,-0.85063>,<0.57132,0.67686,0.46417>,<-0.08363,-0.51731,0.8517>,
            <-0.57442,-0.67489,-0.46321>,
    /*4*/<0.08724,0.51677,-0.85167>,<0.35154,0.78307,0.51305>,<-0.09084,-0.51521,0.85224>,
            <-0.35504,-0.78175,-0.51265>,
    /*5*/<-0.74779,0.49666,-0.44061>,<-0.65316,0.67116,0.35062>,<-0.83401,-0.10081,0.54247>,
            <-0.92861,-0.27532,-0.24876>,
    /*6*/<-0.9682,0.24229,0.06235>

    /* stem 0c3.16*/ 
    /*0*/<-0.06047,0.43185,0.89991>,
    /*1*/<0.9339,-0.29423,0.2031>,<0.35254,0.85238,-0.38621>,<-0.93381,0.29357,-0.20448>,
            <-0.35245,-0.85305,0.38483>,
    /*2*/<0.93392,-0.29445,0.20273>,<0.3548,0.83282,-0.42489>,<-0.93384,0.29376,-0.20409>,
            <-0.35473,-0.83353,0.42355>,
    /*3*/<0.93401,-0.29189,0.20598>,<0.35717,0.7221,-0.59245>,<-0.934,0.29102,-0.20725>,
            <-0.35721,-0.723,0.59132>,
    /*4*/<0.93482,-0.28564,0.21103>,<0.33941,0.5409,-0.76956>,<-0.93495,0.28447,-0.21201>,
            <-0.33956,-0.54203,0.7687>,
    /*5*/<0.42995,-0.85012,-0.30405>,<0.07848,-0.42171,-0.90333>,<-0.64993,-0.52474,-0.54977>,
            <-0.29846,-0.95314,0.04951>,
    /*6*/<-0.13468,-0.84177,-0.52276>

    /* stem 0c4*/ 
    /*0*/<0.06506,-0.7629,-0.64323>,
    /*1*/<-0.98582,0.0559,-0.15824>,<0.15635,0.64822,-0.74523>,<0.98517,-0.04827,0.16467>,
            <-0.157,-0.64059,0.75166>,
    /*2*/<-0.98557,0.05265,-0.16085>,<0.16041,0.59941,-0.7842>,<0.98493,-0.04481,0.16704>,
            <-0.16097,-0.59163,0.78998>,
    /*3*/<-0.9841,0.02324,-0.17608>,<0.17195,0.44228,-0.88024>,<0.98339,-0.01457,0.18094>,
            <-0.1723,-0.43445,0.88406>,
    /*4*/<-0.98264,-0.00507,-0.18547>,<0.17854,0.25066,-0.95147>,<0.98201,0.0146,0.18825>,
            <-0.17901,-0.24234,0.95353>,
    /*5*/<-0.98312,0.01145,-0.18259>,<0.18151,0.20471,-0.96185>,<0.98285,-0.00163,0.18439>,
            <-0.18188,-0.19538,0.96372>,
    /*6*/<-0.98344,0.02067,-0.18003>,<0.17972,0.23886,-0.95428>,<0.98317,-0.01097,0.18236>,
            <-0.17995,-0.2292,0.9566>,
    /*7*/<-0.98223,-0.01054,-0.1874>,<0.18083,0.22277,-0.95795>,<0.98166,0.02027,0.18958>,
            <-0.18127,-0.21302,0.96008>,
    /*8*/<-0.9812,-0.02569,-0.19129>,<0.17853,0.25941,-0.94912>,<0.98047,0.0354,0.19348>,
            <-0.17935,-0.24979,0.95155>,
    /*9*/<-0.98104,-0.02792,-0.1918>,<0.17274,0.32121,-0.93112>,<0.98013,0.03741,0.19479>,
            <-0.1736,-0.31178,0.93416>,
    /*10*/<-0.10432,0.94387,0.31341>

    /* stem 0c4.0*/ 
    /*0*/<-0.43055,0.49176,-0.75683>,
    /*1*/<-0.89958,-0.27677,0.33787>,<-0.04137,0.82409,0.56495>,<0.90345,0.27234,-0.33106>,
            <0.04525,-0.82851,-0.55814>,
    /*2*/<-0.89704,-0.27998,0.34195>,<-0.01554,0.79348,0.6084>,<0.90097,0.27535,-0.33531>,
            <0.01941,-0.79828,-0.60197>,
    /*3*/<-0.89462,-0.28377,0.34515>,<0.06743,0.67726,0.73265>,<0.8986,0.27808,-0.3394>,
            <-0.06367,-0.68308,-0.72757>,
    /*4*/<-0.89217,-0.28978,0.34651>,<0.18524,0.46622,0.86506>,<0.89597,0.28258,-0.34263>,
            <-0.18181,-0.47329,-0.86194>,
    /*5*/<-0.19961,-0.89784,0.39248>,<0.45187,-0.53123,0.71667>,<0.82786,-0.56091,-0.00561>,
            <0.17633,-0.92743,-0.32982>,
    /*6*/<0.38431,-0.89236,0.23666>

    /* stem 0c4.1*/ 
    /*0*/<0.99438,-0.10007,-0.03445>,
    /*1*/<0.0214,0.54598,-0.83752>,<0.09814,0.83253,0.54521>,<-0.03035,-0.54508,0.83783>,
            <-0.10709,-0.83163,-0.5449>,
    /*2*/<0.02963,0.54538,-0.83767>,<0.05446,0.83616,0.54577>,<-0.03859,-0.5446,0.83781>,
            <-0.06339,-0.83557,-0.54571>,
    /*3*/<0.00083,0.54178,-0.84052>,<-0.11664,0.83245,0.54168>,<-0.00981,-0.54212,0.84025>,
            <0.10804,-0.83314,-0.54241>,
    /*4*/<-0.04049,0.52676,-0.84905>,<-0.36611,0.78252,0.50361>,<0.03193,-0.52922,0.84788>,
            <0.35819,-0.78527,-0.50502>,
    /*5*/<-0.74042,-0.04748,-0.67046>,<-0.99272,0.07451,0.09464>,<-0.69238,-0.65184,0.3094>,
            <-0.44001,-0.77379,-0.45568>,
    /*6*/<-0.87648,-0.42779,-0.22087>

    /* stem 0c4.2*/ 
    /*0*/<-0.19591,0.468,0.86174>,
    /*1*/<0.97552,-0.00606,0.21985>,<0.10899,0.88161,-0.45923>,<-0.97375,0.00184,-0.2276>,
            <-0.10722,-0.88582,0.45147>,
    /*2*/<0.97769,-0.01223,0.20971>,<0.11666,0.86078,-0.49543>,<-0.97605,0.00785,-0.2174>,
            <-0.115,-0.8653,0.48789>,
    /*3*/<0.97647,-0.00551,0.2156>,<0.15405,0.73473,-0.66063>,<-0.97492,0,-0.22257>,
            <-0.15282,-0.74043,0.65453>,
    /*4*/<0.97346,0.01238,0.22852>,<0.19216,0.5012,-0.84373>,<-0.97217,-0.01983,-0.23342>,
            <-0.19109,-0.50831,0.83971>,
    /*5*/<0.64587,-0.74416,-0.17055>,<0.20468,-0.53172,-0.82182>,<-0.47499,-0.76383,-0.43699>,
            <-0.03381,-0.97618,0.21431>,
    /*6*/<0.10453,-0.92247,-0.37165>

    /* stem 0c4.3*/ 
    /*0*/<-0.90399,0.24391,-0.35115>,
    /*1*/<-0.41263,-0.3199,0.85288>,<0.09976,0.91479,0.39141>,<0.42076,0.3177,-0.84972>,
            <-0.09163,-0.91699,-0.38825>,
    /*2*/<-0.41371,-0.31969,0.85243>,<0.17011,0.89255,0.41763>,<0.42181,0.31717,-0.8494>,
            <-0.16221,-0.89534,-0.4148>,
    /*3*/<-0.41258,-0.32134,0.85236>,<0.354,0.80564,0.47501>,<0.42033,0.31737,-0.85006>,
            <-0.34688,-0.80985,-0.47309>,
    /*4*/<-0.42408,-0.312,0.85018>,<0.54406,0.66112,0.51664>,<0.43086,0.30622,-0.84888>,
            <-0.53787,-0.66689,-0.51572>,
    /*5*/<0.28071,-0.7861,0.55068>,<0.88961,-0.2787,0.36182>,<0.78503,-0.44742,-0.42842>,
            <0.17608,-0.95478,-0.23956>,
    /*6*/<0.65194,-0.75458,0.07479>

    /* stem 0c4.4*/ 
    /*0*/<0.41445,-0.47658,-0.77531>,
    /*1*/<-0.87156,0.04565,-0.48815>,<0.26617,0.88019,-0.39296>,<0.86783,-0.04136,0.49513>,
            <-0.2699,-0.8759,0.39994>,
    /*2*/<-0.86721,0.04118,-0.49623>,<0.24246,0.90482,-0.35002>,<0.86334,-0.0371,0.50326>,
            <-0.24632,-0.90101,0.35709>,
    /*3*/<-0.86373,0.03757,-0.50255>,<0.15877,0.96671,-0.20067>,<0.85949,-0.0347,0.50997>,
            <-0.16293,-0.96449,0.20789>,
    /*4*/<-0.85277,0.03605,-0.52104>,<0.03624,0.99933,0.00404>,<0.84807,-0.03535,0.5287>,
            <-0.04063,-0.99917,0.00328>,
    /*5*/<-0.92889,-0.05254,0.36661>,<-0.4558,0.49676,0.73857>,<0.0362,-0.10026,0.9943>,
            <-0.43686,-0.64955,0.62229>,
    /*6*/<-0.54608,-0.09347,0.8325>

    /* stem 0c4.5*/ 
    /*0*/<0.34679,0.08161,0.93439>,
    /*1*/<0.92885,0.09561,-0.3579>,<-0.1201,0.99166,-0.04686>,<-0.93197,-0.09634,0.34949>,
            <0.11698,-0.99239,0.03845>,
    /*2*/<0.92859,0.09536,-0.35863>,<-0.14035,0.98485,-0.10182>,<-0.93169,-0.09636,0.35024>,
            <0.13733,-0.9861,0.09354>,
    /*3*/<0.92743,0.09345,-0.36212>,<-0.20306,0.93903,-0.27745>,<-0.93035,-0.09582,0.35393>,
            <0.20041,-0.94183,0.26979>,
    /*4*/<0.92814,0.09353,-0.36029>,<-0.28337,0.80251,-0.52505>,<-0.93048,-0.09821,0.35293>,
            <0.28135,-0.80743,0.51856>,
    /*5*/<0.38535,-0.51911,-0.76291>,<-0.33357,-0.17236,-0.92684>,<-0.68641,-0.63425,-0.35577>,
            <0.03253,-0.9809,-0.19176>,
    /*6*/<-0.18417,-0.70554,-0.68433>

    /* stem 0c4.6*/ 
    /*0*/<-0.9676,0.11797,0.22324>,
    /*1*/<0.19685,-0.22799,0.95356>,<0.16774,0.96607,0.19638>,<-0.18814,0.22693,-0.95557>,
            <-0.15903,-0.96714,-0.19839>,
    /*2*/<0.18572,-0.22641,0.95616>,<0.19139,0.96272,0.19113>,<-0.17702,0.22522,-0.95809>,
            <-0.18273,-0.96401,-0.19313>,
    /*3*/<0.16993,-0.22275,0.95995>,<0.32255,0.93289,0.16026>,<-0.16137,0.22072,-0.9619>,
            <-0.31439,-0.93533,-0.16226>,
    /*4*/<0.14758,-0.21101,0.96628>,<0.51622,0.84947,0.10917>,<-0.13972,0.2071,-0.96829>,
            <-0.50893,-0.85359,-0.11124>,
    /*5*/<0.72145,-0.57811,0.38119>,<0.99114,-0.00618,-0.13267>,<0.57286,-0.35402,-0.73926>,
            <0.30313,-0.92591,-0.22538>,
    /*6*/<0.79176,-0.5702,-0.21904>

    /* stem 0c4.7*/ 
    /*0*/<-0.02078,0.87058,-0.49159>,
    /*1*/<-0.99966,-0.0253,0.00661>,<-0.00658,0.48765,0.87302>,<0.99985,0.01746,-0.00219>,
            <0.00677,-0.49548,-0.86859>,
    /*2*/<-0.9998,-0.01973,0.00372>,<-0.00582,0.4405,0.89774>,<0.99993,0.01178,0.0005>,
            <0.00598,-0.44849,-0.89377>,
    /*3*/<-0.99997,-0.00741,-0.00107>,<-0.00424,0.26634,0.96387>,<0.99999,-0.00109,0.00408>,
            <0.0043,-0.27462,-0.96154>,
    /*4*/<-0.99995,-0.00976,-0.00243>,<-0.00137,-0.00766,0.99997>,<1,0.00076,0.00306>,
            <0.00137,-0.00078,-1>,
    /*5*/<-0.56386,-0.81677,-0.12225>,<0.01047,-0.89259,0.45074>,<0.58826,-0.80026,-0.11632>,
            <0.01392,-0.72434,-0.6893>,
    /*6*/<0.01492,-0.98918,-0.14594>

    /* stem 0c4.8*/ 
    /*0*/<0.52563,-0.72774,0.44058>,
    /*1*/<0.7609,0.178,-0.62397>,<0.3733,0.66649,0.64532>,<-0.76563,-0.17145,0.62001>,
            <-0.37803,-0.65994,-0.64928>,
    /*2*/<0.76492,0.17285,-0.6205>,<0.33838,0.71257,0.61461>,<-0.76971,-0.16648,0.61631>,
            <-0.34324,-0.70649,-0.61891>,
    /*3*/<0.74919,0.18466,-0.63609>,<0.2198,0.83338,0.50712>,<-0.75461,-0.17945,0.63116>,
            <-0.22497,-0.82887,-0.51222>,
    /*4*/<0.73709,0.189,-0.64883>,<0.05403,0.94166,0.3322>,<-0.74307,-0.18589,0.64288>,
            <-0.05975,-0.93927,-0.33795>,
    /*5*/<-0.10772,0.24184,-0.96432>,<-0.55872,0.69226,-0.45674>,<-0.97203,0.02653,-0.23336>,
            <-0.52097,-0.42389,-0.74088>,
    /*6*/<-0.66051,0.16417,-0.73265>

    /* stem 0c4.9*/ 
    /*0*/<-0.73809,0.17997,0.65026>,
    /*1*/<0.63424,-0.15822,0.75677>,<0.2424,0.97018,-0.00029>,<-0.6276,0.1566,-0.76262>,
            <-0.23576,-0.9718,-0.00557>,
    /*2*/<0.62146,-0.15447,0.76806>,<0.2725,0.9618,-0.02604>,<-0.61477,0.15265,-0.77379>,
            <-0.26593,-0.96378,0.02027>,
    /*3*/<0.61424,-0.15278,0.77419>,<0.39712,0.90749,-0.13694>,<-0.60784,0.14984,-0.7798>,
            <-0.39118,-0.91085,0.13167>,
    /*4*/<0.63089,-0.17178,0.75661>,<0.54329,0.79304,-0.27554>,<-0.62563,0.1669,-0.76205>,
            <-0.53847,-0.79802,0.27057>,
    /*5*/<0.76564,-0.64187,-0.04239>,<0.74235,-0.11167,-0.66064>,<0.03135,-0.42663,-0.90388>,
            <0.05462,-0.95679,-0.28561>,
    /*6*/<0.48754,-0.65362,-0.57886>

    /* stem 0c4.10*/ 
    /*0*/<-0.29044,0.35346,-0.88922>,
    /*1*/<-0.95537,-0.12807,0.2662>,<-0.01848,0.92526,0.37889>,<0.95799,0.12489,-0.25819>,
            <0.0211,-0.92844,-0.37088>,
    /*2*/<-0.95101,-0.1338,0.27869>,<-0.00548,0.90927,0.41617>,<0.95375,0.13046,-0.2708>,
            <0.00814,-0.91278,-0.40838>,
    /*3*/<-0.94319,-0.14644,0.29825>,<0.04707,0.83127,0.55387>,<0.94613,0.14211,-0.29092>,
            <-0.0443,-0.83591,-0.54708>,
    /*4*/<-0.94625,-0.14031,0.2914>,<0.12122,0.6748,0.72798>,<0.94898,0.13419,-0.28537>,
            <-0.11862,-0.68095,-0.72266>,
    /*5*/<-0.33733,-0.724,0.60169>,<0.3036,-0.31762,0.8983>,<0.76033,-0.58638,0.27938>,
            <0.11939,-0.9927,-0.01726>,
    /*6*/<0.25876,-0.80159,0.53898>

    /* stem 0c4.11*/ 
    /*0*/<0.69493,-0.66274,0.27901>,
    /*1*/<0.52234,0.20614,-0.82745>,<0.48774,0.72374,0.48817>,<-0.52859,-0.20018,0.82494>,
            <-0.49399,-0.71778,-0.49068>,
    /*2*/<0.5251,0.2036,-0.82632>,<0.45397,0.75447,0.47401>,<-0.53145,-0.19779,0.82368>,
            <-0.46038,-0.74886,-0.47673>,
    /*3*/<0.53844,0.19459,-0.81989>,<0.30372,0.86399,0.40159>,<-0.54527,-0.18977,0.81649>,
            <-0.31043,-0.86,-0.40501>,
    /*4*/<0.56069,0.18762,-0.80649>,<0.04901,0.96556,0.25552>,<-0.56806,-0.18523,0.80187>,
            <-0.05587,-0.96402,-0.2599>,
    /*5*/<-0.33373,0.13653,-0.93273>,<-0.71166,0.59433,-0.37458>,<-0.99674,-0.0792,-0.01536>,
            <-0.61871,-0.537,-0.57344>,
    /*6*/<-0.81388,0.03507,-0.57997>

    /* stem 0c4.12*/ 
    /*0*/<-0.94778,-0.05561,0.31403>,
    /*1*/<0.32099,-0.25718,0.9115>,<0.03357,0.96491,0.26044>,<-0.31399,0.25759,-0.91381>,
            <-0.02658,-0.9645,-0.26276>,
    /*2*/<0.3128,-0.25738,0.91428>,<0.07394,0.96615,0.24717>,<-0.30579,0.25762,-0.91658>,
            <-0.06699,-0.96605,-0.24953>,
    /*3*/<0.27444,-0.25105,0.92825>,<0.26473,0.94666,0.18372>,<-0.26747,0.25019,-0.93052>,
            <-0.25831,-0.94797,-0.1861>,
    /*4*/<0.26598,-0.24931,0.93118>,<0.52567,0.84752,0.0733>,<-0.25975,0.24632,-0.93373>,
            <-0.52015,-0.85072,-0.07561>,
    /*5*/<0.75019,-0.62389,0.21905>,<0.95485,-0.02613,-0.29595>,<0.42868,-0.31928,-0.84516>,
            <0.22396,-0.91698,-0.33013>,
    /*6*/<0.72128,-0.57707,-0.38308>

    /* stem 0c4.13*/ 
    /*0*/<0.34155,0.80427,-0.48631>,
    /*1*/<-0.87291,0.0756,-0.48198>,<-0.35188,0.58676,0.72931>,<0.8709,-0.08033,0.48484>,
            <0.34988,-0.59149,-0.72645>,
    /*2*/<-0.85973,0.10754,-0.4993>,<-0.36754,0.55207,0.74843>,<0.85758,-0.1123,0.50195>,
            <0.36553,-0.5569,-0.74582>,
    /*3*/<-0.85178,0.12532,-0.50869>,<-0.42482,0.39742,0.81338>,<0.84981,-0.13047,0.51068>,
            <0.42304,-0.40252,-0.8118>,
    /*4*/<-0.85542,0.10331,-0.50752>,<-0.48788,0.16652,0.85688>,<0.85422,-0.10901,0.50835>,
            <0.48688,-0.17196,-0.85637>,
    /*5*/<-0.58958,-0.75286,-0.29256>,<-0.38772,-0.77625,0.4971>,<0.39636,-0.8698,0.29385>,
            <0.19451,-0.84637,-0.49581>,
    /*6*/<-0.11824,-0.99298,0.00079>

    /* stem 0c4.14*/ 
    /*0*/<0.60826,0.28164,0.74209>,
    /*1*/<0.67887,0.29723,-0.67141>,<-0.41064,0.91172,-0.0116>,<-0.68083,-0.29813,0.66902>,
            <0.40868,-0.91263,0.00921>,
    /*2*/<0.68224,0.29906,-0.66716>,<-0.44045,0.89644,-0.04906>,<-0.68416,-0.30004,0.66476>,
            <0.43858,-0.89748,0.04668>,
    /*3*/<0.68812,0.30382,-0.65893>,<-0.54006,0.82061,-0.18692>,<-0.68979,-0.30519,0.65654>,
            <0.53857,-0.82209,0.18468>,
    /*4*/<0.6911,0.30922,-0.65327>,<-0.65434,0.65084,-0.38502>,<-0.69224,-0.31129,0.65108>,
            <0.65342,-0.65292,0.38306>,
    /*5*/<0.23278,-0.45668,-0.85864>,<-0.56599,-0.32432,-0.75794>,<-0.56573,-0.81749,-0.10797>,
            <0.23305,-0.94982,-0.20864>,
    /*6*/<-0.20381,-0.77997,-0.5917>

    /* stem 0c4.15*/ 
    /*0*/<-0.63881,0.72724,0.25109>,
    /*1*/<0.0168,-0.31398,0.94928>,<0.76965,0.61011,0.18817>,<-0.01589,0.31294,-0.94964>,
            <-0.76874,-0.61115,-0.18853>,
    /*2*/<0.00596,-0.30074,0.95369>,<0.79031,0.58556,0.18034>,<-0.00506,0.29968,-0.95403>,
            <-0.78944,-0.58663,-0.18069>,
    /*3*/<0.01235,-0.31308,0.94965>,<0.8662,0.47877,0.14312>,<-0.01158,0.31195,-0.95003>,
            <-0.8655,-0.47992,-0.14348>,
    /*4*/<0.02118,-0.34417,0.93867>,<0.95857,0.27379,0.0786>,<-0.02069,0.34292,-0.93914>,
            <-0.95818,-0.27502,-0.07906>,
    /*5*/<0.14141,-0.95496,0.26086>,<0.69906,-0.66596,-0.26043>,<0.11719,-0.5568,-0.82234>,
            <-0.44045,-0.84579,-0.30105>,
    /*6*/<0.15834,-0.92561,-0.34378>

    /* stem 0c5*/ 
    /*0*/<0.344,-0.93116,-0.12087>,
    /*1*/<-0.28162,0.02583,-0.95918>,<0.89455,0.36866,-0.25274>,<0.27818,-0.01652,0.96039>,
            <-0.89799,-0.35934,0.25395>,
    /*2*/<-0.28128,0.02523,-0.95929>,<0.91397,0.31186,-0.25961>,<0.27811,-0.01581,0.96042>,
            <-0.91679,-0.30261,0.26064>,
    /*3*/<-0.27845,0.01239,-0.96037>,<0.94432,0.18762,-0.27029>,<0.27639,-0.00263,0.96104>,
            <-0.94594,-0.17837,0.2709>,
    /*4*/<-0.27721,0.00495,-0.9608>,<0.95959,0.05061,-0.27683>,<0.27644,0.00501,0.96102>,
            <-0.96001,-0.04122,0.27692>,
    /*5*/<-0.27644,0.00856,-0.96099>,<0.96073,0.02494,-0.27635>,<0.27647,0.00144,0.96102>,
            <-0.96091,-0.01532,0.27644>,
    /*6*/<-0.27666,0.007,-0.96094>,<0.95678,0.095,-0.27487>,<0.27592,0.00297,0.96117>,
            <-0.95763,-0.08516,0.27513>,
    /*7*/<-0.27892,0.02468,-0.96>,<0.95307,0.12985,-0.2735>,<0.27782,-0.01476,0.96052>,
            <-0.95423,-0.11996,0.27395>,
    /*8*/<-0.27989,0.02551,-0.95969>,<0.94451,0.18494,-0.27148>,<0.27844,-0.01565,0.96033>,
            <-0.94615,-0.17514,0.27226>,
    /*9*/<-0.26719,-0.02498,-0.96332>,<0.92804,0.26139,-0.26536>,<0.26479,0.03467,0.96368>,
            <-0.93053,-0.25178,0.26593>,
    /*10*/<-0.2938,0.95575,0.01506>

    /* stem 0c5.0*/ 
    /*0*/<-0.25672,0.61227,-0.74781>,
    /*1*/<-0.95979,-0.24711,0.13319>,<-0.10209,0.74918,0.65445>,<0.9621,0.2416,-0.12645>,
            <0.1044,-0.75469,-0.64772>,
    /*2*/<-0.96616,-0.23127,0.11424>,<-0.09986,0.74305,0.66174>,<0.96825,0.22569,-0.10752>,
            <0.10207,-0.74865,-0.65506>,
    /*3*/<-0.97318,-0.21034,0.09319>,<-0.07627,0.67485,0.73401>,<0.97505,0.20429,-0.08681>,
            <0.07817,-0.68108,-0.72803>,
    /*4*/<-0.9774,-0.19434,0.08314>,<-0.02457,0.48467,0.87435>,<0.97924,0.18701,-0.07821>,
            <0.02642,-0.49199,-0.8702>,
    /*5*/<-0.40793,-0.85107,0.33056>,<0.16241,-0.5427,0.82407>,<0.72271,-0.64747,0.24181>,
            <0.15234,-0.95573,-0.25173>,
    /*6*/<0.19256,-0.91669,0.35014>

    /* stem 0c5.1*/ 
    /*0*/<0.43664,0.87717,0.19981>,
    /*1*/<0.17809,0.12846,-0.97559>,<-0.88339,0.45762,-0.10103>,<-0.18202,-0.13635,0.9738>,
            <0.87946,-0.46552,0.09923>,
    /*2*/<0.17818,0.12842,-0.97558>,<-0.90103,0.41972,-0.10943>,<-0.18194,-0.13641,0.9738>,
            <0.89746,-0.42774,0.10769>,
    /*3*/<0.17649,0.1187,-0.97712>,<-0.95822,0.24837,-0.14183>,<-0.17916,-0.12717,0.97557>,
            <0.95626,-0.25661,0.14038>,
    /*4*/<0.17754,0.12154,-0.97658>,<-0.98338,-0.00626,-0.18146>,<-0.17785,-0.13046,0.97537>,
            <0.98358,-0.00213,0.18047>,
    /*5*/<0.21805,-0.72344,-0.65505>,<-0.44348,-0.87289,-0.20345>,<0.01755,-0.8834,0.4683>,
            <0.67907,-0.73388,0.01671>,
    /*6*/<0.14413,-0.98294,-0.11424>

    /* stem 0c5.2*/ 
    /*0*/<-0.71433,-0.07006,0.69629>,
    /*1*/<0.69702,0.05937,0.71459>,<-0.08819,0.9961,0.00329>,<-0.69059,-0.05874,-0.72085>,
            <0.09462,-0.99547,-0.00956>,
    /*2*/<0.68963,0.05906,0.72175>,<-0.05098,0.99818,-0.03208>,<-0.68312,-0.05866,-0.72795>,
            <0.05742,-0.99801,0.0259>,
    /*3*/<0.70715,0.05323,0.70506>,<0.08136,0.98343,-0.16201>,<-0.70077,-0.05413,-0.71133>,
            <-0.07516,-0.98486,0.15622>,
    /*4*/<0.73779,0.03179,0.67428>,<0.27648,0.89617,-0.34705>,<-0.73205,-0.03512,-0.68034>,
            <-0.27122,-0.89985,0.34161>,
    /*5*/<0.88762,-0.44825,-0.10586>,<0.67022,0.01209,-0.74207>,<0.03301,-0.47716,-0.87819>,
            <0.25035,-0.93744,-0.24193>,
    /*6*/<0.56317,-0.5661,-0.60197>

    /* stem 0c5.3*/ 
    /*0*/<0.26815,-0.07301,-0.96061>,
    /*1*/<-0.96135,-0.10149,-0.25596>,<-0.08001,0.99244,-0.09308>,<0.95893,0.10215,0.2646>,
            <0.0776,-0.99178,0.10172>,
    /*2*/<-0.96286,-0.10141,-0.25023>,<-0.09161,0.99454,-0.05006>,<0.96051,0.10188,0.25891>,
            <0.08927,-0.99428,0.05869>,
    /*3*/<-0.95373,-0.09575,-0.28502>,<-0.14272,0.9817,0.12606>,<0.9512,0.09496,0.29361>,
            <0.14059,-0.98303,-0.11783>,
    /*4*/<-0.94586,-0.08433,-0.31344>,<-0.20476,0.90252,0.37885>,<0.94344,0.08112,0.32147>,
            <0.20255,-0.90606,-0.37153>,
    /*5*/<-0.72195,-0.48846,0.49009>,<-0.31389,0.04772,0.94826>,<0.36904,-0.38479,0.84602>,
            <-0.039,-0.92092,0.38778>,
    /*6*/<-0.21589,-0.53419,0.81733>

    /* stem 0c5.4*/ 
    /*0*/<0.7826,0.28864,0.55157>,
    /*1*/<0.5492,0.08415,-0.83144>,<-0.28992,0.95231,-0.09515>,<-0.55625,-0.08675,0.82648>,
            <0.28287,-0.95491,0.09018>,
    /*2*/<0.51984,0.07075,-0.85133>,<-0.33975,0.93183,-0.12751>,<-0.52696,-0.07363,0.8467>,
            <0.33287,-0.93494,0.1228>,
    /*3*/<0.47729,0.04442,-0.87762>,<-0.46372,0.86151,-0.20678>,<-0.48418,-0.04852,0.87362>,
            <0.45727,-0.86587,0.2029>,
    /*4*/<0.47223,0.03663,-0.88072>,<-0.60818,0.73616,-0.29696>,<-0.47827,-0.04231,0.8772>,
            <0.60262,-0.74199,0.29375>,
    /*5*/<-0.18348,-0.58536,-0.78974>,<-0.84779,-0.23235,-0.47673>,<-0.73618,-0.6401,0.21982>,
            <-0.07184,-0.99305,-0.09317>,
    /*6*/<-0.56258,-0.74964,-0.34864>

    /* stem 0c5.5*/ 
    /*0*/<-0.79603,0.16227,0.5831>,
    /*1*/<0.59275,-0.01363,0.80527>,<0.14221,0.98592,-0.08796>,<-0.58558,0.01217,-0.81052>,
            <-0.13504,-0.98738,0.08271>,
    /*2*/<0.59314,-0.01384,0.80498>,<0.17704,0.97763,-0.11352>,<-0.58601,0.01218,-0.81022>,
            <-0.16998,-0.97947,0.10834>,
    /*3*/<0.5858,-0.01082,0.81038>,<0.30583,0.92936,-0.20678>,<-0.57884,0.00805,-0.8154>,
            <-0.29931,-0.93253,0.20201>,
    /*4*/<0.56217,0.00916,0.82697>,<0.49365,0.80056,-0.33972>,<-0.55583,-0.01399,-0.83118>,
            <-0.48802,-0.80563,0.33586>,
    /*5*/<0.81144,-0.55596,0.1802>,<0.82936,-0.16421,-0.53404>,<0.18288,-0.5921,-0.78484>,
            <0.1649,-0.98378,-0.07057>,
    /*6*/<0.60825,-0.7023,-0.36988>

    /* stem 0c5.6*/ 
    /*0*/<0.09711,-0.30922,-0.94602>,
    /*1*/<-0.99408,0.02543,-0.1056>,<0.05628,0.95207,-0.30066>,<0.99321,-0.02265,0.11411>,
            <-0.05715,-0.94929,0.30917>,
    /*2*/<-0.99108,0.01818,-0.13204>,<0.04955,0.96688,-0.25039>,<0.98995,-0.01563,0.14058>,
            <-0.05056,-0.96457,0.25895>,
    /*3*/<-0.98493,0.01169,-0.17257>,<0.02161,0.99743,-0.06836>,<0.98337,-0.01042,0.18133>,
            <-0.02305,-0.99678,0.07681>,
    /*4*/<-0.98234,0.01313,-0.18663>,<-0.02249,0.98236,0.18564>,<0.98062,-0.01421,0.19541>,
            <0.02088,-0.98391,-0.17747>,
    /*5*/<-0.7178,-0.24007,0.65356>,<-0.17838,0.30095,0.93681>,<0.41306,-0.25597,0.87399>,
            <-0.12635,-0.79696,0.59066>,
    /*6*/<-0.18642,-0.30344,0.93444>

    /* stem 0c5.7*/ 
    /*0*/<0.80279,0.58071,0.13531>,
    /*1*/<0.14244,0.02589,-0.98947>,<-0.58171,0.81099,-0.06254>,<-0.14966,-0.03112,0.98825>,
            <0.57448,-0.81622,0.06132>,
    /*2*/<0.14323,0.02639,-0.98934>,<-0.61582,0.78491,-0.06837>,<-0.15034,-0.03178,0.98812>,
            <0.60887,-0.79042,0.06718>,
    /*3*/<0.16506,0.05059,-0.98499>,<-0.74672,0.65815,-0.09621>,<-0.17133,-0.05689,0.98357>,
            <0.74114,-0.66458,0.09508>,
    /*4*/<0.17827,0.07478,-0.98114>,<-0.8912,0.43502,-0.1285>,<-0.18256,-0.08256,0.97972>,
            <0.88767,-0.44256,0.12722>,
    /*5*/<-0.14547,-0.72882,-0.66908>,<-0.78789,-0.58623,-0.18859>,<-0.3524,-0.81431,0.46121>,
            <0.29004,-0.95682,-0.01927>,
    /*6*/<-0.30456,-0.94397,-0.12716>

    /* stem 0c5.8*/ 
    /*0*/<-0.4564,-0.42751,0.78034>,
    /*1*/<0.85435,0.04369,0.51786>,<-0.25343,0.90496,0.34179>,<-0.85024,-0.03984,-0.52488>,
            <0.25753,-0.90111,-0.34881>,
    /*2*/<0.8547,0.04385,0.51727>,<-0.22992,0.92527,0.30167>,<-0.85054,-0.04021,-0.52437>,
            <0.23411,-0.92187,-0.30879>,
    /*3*/<0.84571,0.04018,0.53213>,<-0.12189,0.98454,0.12582>,<-0.84111,-0.03787,-0.53954>,
            <0.12621,-0.98306,-0.13292>,
    /*4*/<0.83386,0.04058,0.55048>,<0.02126,0.99431,-0.10439>,<-0.82886,-0.04093,-0.55796>,
            <-0.01665,-0.9951,0.0975>,
    /*5*/<0.92967,-0.14193,-0.33995>,<0.49733,0.3976,-0.77109>,<-0.02631,-0.19016,-0.9814>,
            <0.406,-0.72968,-0.55021>,
    /*6*/<0.55261,-0.20315,-0.8083>

    /* stem 0c5.9*/ 
    /*0*/<-0.37038,0.72465,-0.58112>,
    /*1*/<-0.89469,-0.11802,0.43082>,<0.24527,0.67623,0.69466>,<0.89802,0.1115,-0.42559>,
            <-0.24194,-0.68275,-0.68943>,
    /*2*/<-0.88902,-0.13006,0.439>,<0.26912,0.62884,0.72948>,<0.89241,0.12336,-0.43403>,
            <-0.26591,-0.63565,-0.72474>,
    /*3*/<-0.8908,-0.12378,0.43722>,<0.33197,0.47151,0.81699>,<0.89373,0.11622,-0.4333>,
            <-0.32925,-0.47898,-0.81374>,
    /*4*/<-0.89672,-0.09805,0.43161>,<0.39413,0.26386,0.88037>,<0.89867,0.08955,-0.42938>,
            <-0.39241,-0.27207,-0.87863>,
    /*5*/<-0.39169,-0.85337,0.34399>,<0.3631,-0.70302,0.61149>,<0.64315,-0.75047,-0.15219>,
            <-0.11166,-0.90077,-0.41969>,
    /*6*/<0.15382,-0.98111,0.11733>

    /* stem 0c5.10*/ 
    /*0*/<0.89123,-0.0833,0.44585>,
    /*1*/<0.44795,0.08116,-0.89037>,<0.03397,0.99361,0.10764>,<-0.45597,-0.08041,0.88635>,
            <-0.04199,-0.99286,-0.11165>,
    /*2*/<0.47598,0.07903,-0.8759>,<0.01787,0.99494,0.09883>,<-0.48385,-0.07835,0.87164>,
            <-0.02582,-0.99435,-0.10299>,
    /*3*/<0.50292,0.07914,-0.86071>,<-0.11431,0.99315,0.02426>,<-0.51065,-0.07928,0.85613>,
            <0.1069,-0.99386,-0.02871>,
    /*4*/<0.5027,0.07777,-0.86096>,<-0.34516,0.93111,-0.11787>,<-0.51005,-0.08032,0.85639>,
            <0.33848,-0.93408,0.11366>,
    /*5*/<-0.30812,-0.3491,-0.88498>,<-0.86059,0.10781,-0.49776>,<-0.89176,-0.44032,0.10433>,
            <-0.33921,-0.89718,-0.28284>,
    /*6*/<-0.73399,-0.48291,-0.47755>

    /* stem 0c5.11*/ 
    /*0*/<-0.84844,-0.24472,0.46931>,
    /*1*/<0.48934,-0.0057,0.87208>,<-0.20692,0.97066,0.12248>,<-0.4817,0.00791,-0.8763>,
            <0.21456,-0.96846,-0.1267>,
    /*2*/<0.4644,-0.01163,0.88555>,<-0.1685,0.98033,0.10275>,<-0.45662,0.01364,-0.88956>,
            <0.17623,-0.97853,-0.10689>,
    /*3*/<0.41281,-0.01596,0.91068>,<-0.00084,0.99974,0.02273>,<-0.40464,0.01673,-0.91432>,
            <0.0086,-0.99961,-0.02638>,
    /*4*/<0.383,-0.00917,0.9237>,<0.22644,0.97044,-0.08345>,<-0.37482,0.00754,-0.92707>,
            <-0.21885,-0.97245,0.0803>,
    /*5*/<0.92707,-0.28447,0.24419>,<0.89554,0.26025,-0.36094>,<0.49452,-0.27722,-0.82377>,
            <0.526,-0.82191,-0.21862>,
    /*6*/<0.86962,-0.34359,-0.35454>

    /* stem 0c5.12*/ 
    /*0*/<0.23189,-0.77137,-0.59264>,
    /*1*/<-0.96407,-0.09273,-0.24893>,<0.13602,0.63254,-0.76249>,<0.96198,0.09967,0.25427>,
            <-0.13811,-0.6256,0.76782>,
    /*2*/<-0.95646,-0.11648,-0.26762>,<0.13234,0.64297,-0.75437>,<0.9541,0.12334,0.27291>,
            <-0.13458,-0.63612,0.75976>,
    /*3*/<-0.94664,-0.14066,-0.28999>,<0.09331,0.74013,-0.66595>,<0.94389,0.14698,0.29575>,
            <-0.09602,-0.73437,0.67192>,
    /*4*/<-0.94447,-0.1447,-0.29502>,<0.02259,0.86619,-0.49921>,<0.94149,0.14942,0.3021>,
            <-0.02542,-0.86205,0.50618>,
    /*5*/<-0.81738,0.23623,0.52544>,<-0.27933,0.84429,0.45733>,<0.26775,0.40674,0.87342>,
            <-0.27028,-0.20134,0.94149>,
    /*6*/<-0.33622,0.39332,0.85572>

    /* stem 0c5.13*/ 
    /*0*/<0.19361,0.84817,0.49307>,
    /*1*/<0.73528,0.20371,-0.64642>,<-0.64942,0.48465,-0.58598>,<-0.73667,-0.20981,0.64288>,
            <0.64803,-0.49075,0.58243>,
    /*2*/<0.73476,0.20076,-0.64793>,<-0.65709,0.44798,-0.60627>,<-0.73607,-0.20693,0.6445>,
            <0.65589,-0.45418,0.60293>,
    /*3*/<0.73476,0.19871,-0.64857>,<-0.67553,0.29678,-0.67497>,<-0.73548,-0.20527,0.64571>,
            <0.67512,-0.30324,0.6725>,
    /*4*/<0.73629,0.19056,-0.64928>,<-0.66828,0.04722,-0.74241>,<-0.73581,-0.19758,0.64772>,
            <0.66906,-0.05386,0.74125>,
    /*5*/<0.58299,-0.69385,-0.42272>,<-0.21514,-0.84669,-0.48665>,<-0.2685,-0.90697,0.32452>,
            <0.52962,-0.75406,0.38845>,
    /*6*/<0.19243,-0.97947,-0.06009>

    /* stem 0c5.14*/ 
    /*0*/<-0.77072,0.26011,0.58167>,
    /*1*/<0.62044,0.08339,0.77981>,<0.15657,0.96115,-0.22734>,<-0.61597,-0.0849,-0.78318>,
            <-0.15209,-0.96266,0.22397>,
    /*2*/<0.60503,0.08919,0.79119>,<0.18316,0.95169,-0.24645>,<-0.60051,-0.09079,-0.79445>,
            <-0.17869,-0.95338,0.24317>,
    /*3*/<0.58755,0.09754,0.80329>,<0.28501,0.90433,-0.31774>,<-0.58306,-0.09968,-0.80629>,
            <-0.2807,-0.90667,0.31489>,
    /*4*/<0.58741,0.0968,0.80348>,<0.47788,0.75957,-0.44122>,<-0.58336,-0.10014,-0.80601>,
            <-0.47427,-0.7631,0.43903>,
    /*5*/<0.80002,-0.56546,0.20056>,<0.79595,-0.24996,-0.55135>,<0.12315,-0.67612,-0.72642>,
            <0.12717,-0.99155,0.02551>,
    /*6*/<0.56494,-0.75979,-0.3218>

    /* stem 0c5.15*/ 
    /*0*/<-0.39515,-0.26268,-0.88026>,
    /*1*/<-0.84599,-0.26706,0.46149>,<-0.3556,0.92752,-0.11513>,<0.8474,0.26799,-0.45835>,
            <0.35701,-0.92658,0.11827>,
    /*2*/<-0.84729,-0.26778,0.45869>,<-0.3348,0.93973,-0.06938>,<0.84872,0.26863,-0.45554>,
            <0.33626,-0.93897,0.07252>,
    /*3*/<-0.8515,-0.26871,0.45027>,<-0.25892,0.96202,0.08646>,<0.85306,0.26908,-0.44708>,
            <0.26049,-0.96187,-0.08342>,
    /*4*/<-0.84297,-0.27286,0.46362>,<-0.12128,0.93814,0.32432>,<0.8448,0.27235,-0.46059>,
            <0.12299,-0.93888,-0.32153>,
    /*5*/<-0.02707,-0.44814,0.89356>,<0.42542,0.23046,0.87516>,<0.93198,-0.12184,0.34143>,
            <0.47946,-0.80042,0.35979>,
    /*6*/<0.55391,-0.34889,0.75595>

    /* stem 0c5.16*/ 
    /*0*/<0.86505,-0.38904,0.31676>,
    /*1*/<0.39333,0.13559,-0.90934>,<0.31035,0.91143,0.27014>,<-0.39427,-0.13517,0.909>,
            <-0.31129,-0.91101,-0.27049>,
    /*2*/<0.39321,0.13563,-0.90939>,<0.27325,0.92714,0.25642>,<-0.39415,-0.13523,0.90904>,
            <-0.2742,-0.92676,-0.25678>,
    /*3*/<0.39149,0.13592,-0.91009>,<0.11634,0.97374,0.19568>,<-0.39247,-0.13565,0.90971>,
            <-0.11729,-0.97355,-0.19606>,
    /*4*/<0.36726,0.13412,-0.9204>,<-0.11059,0.98851,0.10299>,<-0.36827,-0.13413,0.91999>,
            <0.10965,-0.98858,-0.10339>,
    /*5*/<-0.54646,-0.07367,-0.83424>,<-0.86904,0.4166,-0.26686>,<-0.9459,-0.21941,0.23901>,
            <-0.62332,-0.70968,-0.32836>,
    /*6*/<-0.91377,-0.17945,-0.36445>

    /* stem 0c6*/ 
    /*0*/<0.50695,-0.81141,0.29089>,
    /*1*/<0.44112,-0.03966,-0.89657>,<0.73649,0.58689,0.33637>,<-0.44619,0.04777,0.89366>,
            <-0.74156,-0.57878,-0.33928>,
    /*2*/<0.43338,-0.02497,-0.90086>,<0.7714,0.52797,0.35523>,<-0.43826,0.03328,0.89823>,
            <-0.77579,-0.51978,-0.35774>,
    /*3*/<0.42522,-0.00171,-0.90509>,<0.82967,0.40083,0.38856>,<-0.42908,0.01072,0.90321>,
            <-0.83295,-0.39233,-0.39022>,
    /*4*/<0.4226,0.01395,-0.90621>,<0.88467,0.21248,0.415>,<-0.42507,-0.00431,0.90515>,
            <-0.88633,-0.2039,-0.41574>,
    /*5*/<0.41629,0.06711,-0.90675>,<0.89479,0.14132,0.42354>,<-0.41755,-0.05728,0.90685>,
            <-0.89605,-0.13245,-0.42373>,
    /*6*/<0.4073,0.10631,-0.90709>,<0.88551,0.19723,0.42067>,<-0.40943,-0.09664,0.90721>,
            <-0.88767,-0.1876,-0.42054>,
    /*7*/<0.40475,0.11575,-0.90707>,<0.87529,0.23743,0.4213>,<-0.40717,-0.10606,0.90717>,
            <-0.87783,-0.22779,-0.42134>,
    /*8*/<0.39609,0.14153,-0.90724>,<0.86432,0.27607,0.4204>,<-0.39911,-0.132,0.90735>,
            <-0.86732,-0.26657,-0.42035>,
    /*9*/<0.39641,0.13828,-0.9076>,<0.86484,0.27537,0.41979>,<-0.39944,-0.12875,0.90767>,
            <-0.86789,-0.26585,-0.41964>,
    /*10*/<-0.2914,0.95659,-0.00405>

    /* stem 0c6.0*/ 
    /*0*/<0.86692,-0.29405,-0.40247>,
    /*1*/<-0.49877,-0.40995,-0.76366>,<0.05566,0.86409,-0.50025>,<0.49097,0.4126,0.76728>,
            <-0.06347,-0.86144,0.50387>,
    /*2*/<-0.49971,-0.40976,-0.76314>,<0.01659,0.8763,-0.48148>,<0.4919,0.41224,0.76687>,
            <-0.02436,-0.87402,0.48528>,
    /*3*/<-0.4897,-0.41152,-0.76866>,<-0.11873,0.90409,-0.41053>,<0.48185,0.41298,0.77283>,
            <0.11121,-0.90308,0.41482>,
    /*4*/<-0.47865,-0.41083,-0.77596>,<-0.32724,0.90344,-0.27698>,<0.47109,0.41032,0.78084>,
            <0.32022,-0.90446,0.2818>,
    /*5*/<-0.90028,-0.4337,0.03732>,<-0.87575,0.30946,0.37055>,<-0.35353,0.03919,0.9346>,
            <-0.37799,-0.70394,0.60133>,
    /*6*/<-0.76699,-0.24133,0.59455>

    /* stem 0c6.1*/ 
    /*0*/<0.00899,-0.38498,0.92288>,
    /*1*/<0.87502,0.45139,0.1749>,<-0.48395,0.8077,0.33677>,<-0.8751,-0.44792,-0.1832>,
            <0.48387,-0.80423,-0.34508>,
    /*2*/<0.87508,0.45565,0.16314>,<-0.48429,0.82233,0.29873>,<-0.87517,-0.45239,-0.17152>,
            <0.48434,-0.8192,-0.30712>,
    /*3*/<0.87433,0.45472,0.16964>,<-0.47551,0.86885,0.1378>,<-0.87382,-0.45237,-0.17832>,
            <0.47617,-0.8671,-0.14626>,
    /*4*/<0.87639,0.45367,0.16163>,<-0.44386,0.88944,-0.10898>,<-0.87488,-0.45333,-0.17049>,
            <0.44564,-0.88954,0.10064>,
    /*5*/<0.69192,0.14301,-0.70767>,<-0.0541,0.395,-0.91708>,<-0.32637,-0.37147,-0.86919>,
            <0.41964,-0.62345,-0.6597>,
    /*6*/<0.22362,-0.13976,-0.96461>

    /* stem 0c6.2*/ 
    /*0*/<-0.91205,0.03212,-0.40881>,
    /*1*/<-0.40476,0.00492,0.91441>,<0.03549,0.99932,0.01036>,<0.41297,-0.00521,-0.91073>,
            <-0.02728,-0.99961,-0.00668>,
    /*2*/<-0.41238,0.00547,0.91099>,<0.07778,0.99653,0.02977>,<0.42055,-0.00597,-0.90725>,
            <-0.06966,-0.99723,-0.02609>,
    /*3*/<-0.4154,0.00496,0.90963>,<0.23244,0.96741,0.10049>,<0.42343,-0.00665,-0.9059>,
            <-0.22485,-0.96956,-0.09694>,
    /*4*/<-0.40749,-0.00155,0.91321>,<0.48212,0.84905,0.21602>,<0.41484,-0.00249,-0.90989>,
            <-0.47563,-0.85346,-0.21306>,
    /*5*/<0.32514,-0.54309,0.77417>,<0.90777,-0.10923,0.405>,<0.795,-0.53919,-0.27793>,
            <0.21228,-0.97294,0.0912>,
    /*6*/<0.68522,-0.66206,0.30356>

    /* stem 0c6.3*/ 
    /*0*/<0.17573,0.9043,-0.38905>,
    /*1*/<-0.46823,-0.27522,-0.83965>,<-0.86716,0.32565,0.37681>,<0.46665,0.26708,0.84315>,
            <0.86558,-0.33379,-0.3733>,
    /*2*/<-0.46892,-0.28236,-0.83689>,<-0.87703,0.2596,0.40425>,<0.46765,0.27413,0.84033>,
            <0.87605,-0.26779,-0.40103>,
    /*3*/<-0.46972,-0.27143,-0.84006>,<-0.88177,0.07506,0.46567>,<0.46975,0.26284,0.84277>,
            <0.88231,-0.08326,-0.46325>,
    /*4*/<-0.46886,-0.27265,-0.84014>,<-0.84157,-0.14706,0.51975>,<0.47077,0.26401,0.84183>,
            <0.84375,0.13887,-0.51847>,
    /*5*/<0.02948,-0.92156,-0.38711>,<-0.17319,-0.89922,0.40176>,<0.55941,-0.591,0.58118>,
            <0.76206,-0.61329,-0.2077>,
    /*6*/<0.36024,-0.92527,0.11871>

    /* stem 0c6.4*/ 
    /*0*/<-0.01569,-0.7519,0.65909>,
    /*1*/<0.9886,0.09069,0.12017>,<-0.15006,0.65684,0.73895>,<-0.98846,-0.08392,-0.1261>,
            <0.1502,-0.65007,-0.74488>,
    /*2*/<0.98861,0.09048,0.12024>,<-0.1492,0.68873,0.7095>,<-0.98844,-0.08384,-0.12632>,
            <0.1494,-0.68226,-0.71568>,
    /*3*/<0.98912,0.09553,0.11191>,<-0.14334,0.81543,0.56082>,<-0.98884,-0.0898,-0.11887>,
            <0.14375,-0.81052,-0.56779>,
    /*4*/<0.99064,0.10228,0.09035>,<-0.12799,0.9334,0.33524>,<-0.99022,-0.0987,-0.0986>,
            <0.12849,-0.93047,-0.3431>,
    /*5*/<0.6159,0.26026,-0.74359>,<-0.02365,0.75692,-0.65308>,<-0.52647,0.14305,-0.83807>,
            <0.11308,-0.35362,-0.92853>,
    /*6*/<0.05471,0.24671,-0.96754>

    /* stem 0c6.5*/ 
    /*0*/<-0.64744,0.72408,-0.23777>,
    /*1*/<-0.35242,-0.01407,0.93574>,<0.67711,0.68637,0.26536>,<0.35825,0.00755,-0.9336>,
            <-0.67128,-0.69289,-0.26322>,
    /*2*/<-0.35184,-0.01506,0.93594>,<0.72013,0.63437,0.28102>,<0.35746,0.00833,-0.93389>,
            <-0.71482,-0.64121,-0.27909>,
    /*3*/<-0.3443,-0.03261,0.93829>,<0.83958,0.43854,0.32061>,<0.34873,0.02488,-0.93689>,
            <-0.83606,-0.44605,-0.31944>,
    /*4*/<-0.34831,-0.01648,0.93723>,<0.91875,0.18475,0.34895>,<0.35039,0.00776,-0.93657>,
            <-0.91719,-0.19292,-0.34863>,
    /*5*/<-0.14291,-0.80075,0.58169>,<0.59588,-0.76645,0.23977>,<0.25693,-0.82786,-0.49863>,
            <-0.48186,-0.86212,-0.15671>,
    /*6*/<0.06975,-0.99627,0.05081>

    /* stem 0c6.6*/ 
    /*0*/<0.18098,0.76721,-0.61534>,
    /*1*/<-0.86065,-0.18373,-0.47489>,<-0.47821,0.61208,0.62982>,<0.85902,0.17682,0.48043>,
            <0.47658,-0.61899,-0.62428>,
    /*2*/<-0.85641,-0.16273,-0.48997>,<-0.48948,0.56445,0.66468>,<0.85471,0.15563,0.49522>,
            <0.48804,-0.57162,-0.6596>,
    /*3*/<-0.85205,-0.13743,-0.5051>,<-0.51142,0.42829,0.745>,<0.85074,0.12961,0.50935>,
            <0.51038,-0.43606,-0.74119>,
    /*4*/<-0.85167,-0.11628,-0.51102>,<-0.52676,0.19247,0.82794>,<0.85124,0.10765,0.51362>,
            <0.52676,-0.20083,-0.82595>,
    /*5*/<-0.44782,-0.86649,-0.22058>,<-0.25452,-0.78367,0.56664>,<0.5358,-0.75902,0.36987>,
            <0.3425,-0.84173,-0.41735>,
    /*6*/<0.05382,-0.99437,0.09133>

    /* stem 0c6.7*/ 
    /*0*/<0.12697,0.12085,0.98452>,
    /*1*/<0.96429,0.21457,-0.15528>,<-0.23059,0.96853,-0.09372>,<-0.96543,-0.21566,0.14641>,
            <0.22945,-0.96962,0.08486>,
    /*2*/<0.96497,0.21541,-0.14978>,<-0.23612,0.96142,-0.14111>,<-0.96601,-0.2167,0.14093>,
            <0.23511,-0.96292,0.13235>,
    /*3*/<0.96566,0.21633,-0.14389>,<-0.25191,0.91321,-0.32029>,<-0.96634,-0.21883,0.13525>,
            <0.25141,-0.91614,0.31224>,
    /*4*/<0.96595,0.21684,-0.14114>,<-0.25771,0.78048,-0.5696>,<-0.96597,-0.22156,0.13346>,
            <0.25784,-0.78537,0.56277>,
    /*5*/<0.60213,-0.43534,-0.66926>,<-0.10023,-0.16463,-0.98125>,<-0.51068,-0.69006,-0.51287>,
            <0.19168,-0.9607,-0.2008>,
    /*6*/<0.05595,-0.68843,-0.72314>

    /* stem 0c6.8*/ 
    /*0*/<-0.69997,0.70433,-0.11819>,
    /*1*/<-0.21546,-0.05692,0.97485>,<0.68304,0.70466,0.19213>,<0.22175,0.05059,-0.97379>,
            <-0.67674,-0.711,-0.19106>,
    /*2*/<-0.19395,-0.08096,0.97766>,<0.71971,0.66593,0.19637>,<0.20013,0.07449,-0.97693>,
            <-0.71377,-0.67253,-0.19554>,
    /*3*/<-0.16927,-0.11549,0.97878>,<0.82471,0.5275,0.20394>,<0.17458,0.10825,-0.97868>,
            <-0.82002,-0.53478,-0.2039>,
    /*4*/<-0.16411,-0.13407,0.97729>,<0.93337,0.30002,0.19702>,<0.16757,0.12577,-0.97781>,
            <-0.93062,-0.30808,-0.19758>,
    /*5*/<0.0678,-0.87635,0.47687>,<0.71948,-0.69413,0.02298>,<0.25809,-0.71636,-0.64824>,
            <-0.39361,-0.8985,-0.19434>,
    /*6*/<0.19935,-0.9743,-0.10483>

    /* stem 0c6.9*/ 
    /*0*/<0.84019,0.27275,-0.4687>,
    /*1*/<-0.46373,-0.10065,-0.88024>,<-0.29104,0.9557,0.04403>,<0.45616,0.09819,0.88446>,
            <0.28348,-0.95815,-0.03981>,
    /*2*/<-0.42978,-0.08782,-0.89865>,<-0.32984,0.94189,0.0636>,<0.42215,0.08515,0.90252>,
            <0.32237,-0.94474,-0.05959>,
    /*3*/<-0.42976,-0.09263,-0.89818>,<-0.46902,0.87199,0.14019>,<0.42259,0.08887,0.90195>,
            <0.46223,-0.87614,-0.1368>,
    /*4*/<-0.4546,-0.12163,-0.88235>,<-0.65023,0.72258,0.2347>,<0.44873,0.11596,0.88611>,
            <0.64501,-0.72834,-0.23125>,
    /*5*/<-0.69224,-0.69121,-0.20746>,<-0.84685,-0.25797,0.46508>,<-0.17308,-0.55683,0.8124>,
            <-0.01843,-0.99,0.13983>,
    /*6*/<-0.52934,-0.76345,0.37006>

    /* stem 0c6.10*/ 
    /*0*/<-0.23733,0.74321,0.62555>,
    /*1*/<0.95636,0.29207,0.00864>,<-0.17522,0.59696,-0.78291>,<-0.95422,-0.29876,-0.01427>,
            <0.17735,-0.60364,0.77728>,
    /*2*/<0.95161,0.30662,0.02074>,<-0.17324,0.5914,-0.78755>,<-0.9493,-0.31327,-0.02634>,
            <0.17547,-0.5981,0.78198>,
    /*3*/<0.94665,0.32074,0.03116>,<-0.12782,0.46299,-0.8771>,<-0.94405,-0.32781,-0.03611>,
            <0.13039,-0.47004,0.87296>,
    /*4*/<0.94819,0.31616,0.03118>,<-0.05007,0.24546,-0.96811>,<-0.94535,-0.32428,-0.03387>,
            <0.05276,-0.25314,0.96599>,
    /*5*/<0.80618,-0.58114,-0.11108>,<0.24862,-0.67119,-0.69835>,<-0.28591,-0.94667,-0.14856>,
            <0.27164,-0.85659,0.43872>,
    /*6*/<0.31826,-0.9346,-0.15883>

    /* stem 0c6.11*/ 
    /*0*/<-0.4018,-0.75651,-0.516>,
    /*1*/<-0.61606,-0.18851,0.76481>,<-0.67405,0.62859,-0.38799>,<0.61967,0.19531,-0.76017>,
            <0.67766,-0.62178,0.39263>,
    /*2*/<-0.62108,-0.19721,0.75853>,<-0.657,0.6592,-0.36579>,<0.62475,0.20388,-0.75374>,
            <0.66081,-0.65268,0.37059>,
    /*3*/<-0.6159,-0.19481,0.76335>,<-0.55248,0.79636,-0.24615>,<0.62047,0.20058,-0.75815>,
            <0.55709,-0.79152,0.2513>,
    /*4*/<-0.61757,-0.19678,0.7615>,<-0.3885,0.91844,-0.07441>,<0.62351,0.20031,-0.75572>,
            <0.39421,-0.91556,0.07971>,
    /*5*/<0.20673,0.08435,0.97476>,<0.39194,0.74655,0.53763>,<0.94152,0.31568,0.11786>,
            <0.75627,-0.34653,0.55495>,
    /*6*/<0.70241,0.24471,0.66838>

    /* stem 0c6.12*/ 
    /*0*/<0.9621,0.25293,-0.10192>,
    /*1*/<-0.10205,-0.03027,-0.99432>,<-0.25891,0.9659,-0.00286>,<0.09339,0.028,0.99524>,
            <0.25025,-0.96817,0.00377>,
    /*2*/<-0.10305,-0.03064,-0.9942>,<-0.28873,0.95741,0.00036>,<0.09443,0.02823,0.99513>,
            <0.28017,-0.95995,0.00056>,
    /*3*/<-0.10602,-0.03248,-0.99383>,<-0.4267,0.90425,0.01595>,<0.09769,0.02917,0.99479>,
            <0.41885,-0.90793,-0.01504>,
    /*4*/<-0.12415,-0.04903,-0.99105>,<-0.63857,0.76827,0.04469>,<0.1169,0.0438,0.99218>,
            <0.63204,-0.7737,-0.04375>,
    /*5*/<-0.62183,-0.6359,-0.45713>,<-0.96742,-0.20815,0.14414>,<-0.46806,-0.56148,0.6824>,
            <-0.12241,-0.98916,0.08112>,
    /*6*/<-0.66671,-0.73247,0.1378>

    /* stem 0c6.13*/ 
    /*0*/<-0.33496,0.71592,0.61258>,
    /*1*/<0.9405,0.30245,0.15488>,<-0.07318,0.62542,-0.77685>,<-0.93807,-0.30764,-0.15932>,
            <0.07561,-0.63061,0.77241>,
    /*2*/<0.93921,0.30523,0.15723>,<-0.07002,0.61873,-0.78248>,<-0.93675,-0.31044,-0.16164>,
            <0.07247,-0.62395,0.77809>,
    /*3*/<0.93507,0.31446,0.16361>,<-0.02845,0.52924,-0.84799>,<-0.93249,-0.31994,-0.16761>,
            <0.03094,-0.53481,0.84441>,
    /*4*/<0.93282,0.31981,0.16604>,<0.05415,0.3312,-0.94201>,<-0.93019,-0.32607,-0.16861>,
            <-0.05165,-0.33733,0.93997>,
    /*5*/<0.82219,-0.56729,-0.04673>,<0.34127,-0.62468,-0.70237>,<-0.2523,-0.93754,-0.23951>,
            <0.2286,-0.8801,0.41614>,
    /*6*/<0.34868,-0.92073,-0.17513>

    /* stem 0c6.14*/ 
    /*0*/<-0.87855,0.02109,-0.47718>,
    /*1*/<-0.47092,-0.17363,0.86492>,<-0.06228,0.98454,0.16374>,<0.47559,0.17352,-0.86238>,
            <0.06695,-0.98465,-0.16121>,
    /*2*/<-0.45701,-0.17446,0.87219>,<-0.03457,0.9834,0.17811>,<0.46172,0.17428,-0.86974>,
            <0.03926,-0.98367,-0.17564>,
    /*3*/<-0.44729,-0.17584,0.87693>,<0.1086,0.96232,0.24928>,<0.45204,0.17508,-0.87465>,
            <-0.10405,-0.96337,-0.24717>,
    /*4*/<-0.46787,-0.16524,0.86821>,<0.33828,0.8728,0.35182>,<0.47233,0.16313,-0.86619>,
            <-0.33417,-0.87508,-0.35009>,
    /*5*/<0.33522,-0.55672,0.76006>,<0.87224,-0.00608,0.48904>,<0.8937,-0.3829,-0.23387>,
            <0.35664,-0.9335,0.03713>,
    /*6*/<0.75209,-0.57504,0.32202>

    /* stem 0c6.15*/ 
    /*0*/<0.62306,0.51535,-0.5884>,
    /*1*/<-0.59158,-0.18404,-0.78496>,<-0.51379,0.83635,0.19112>,<0.58962,0.18243,0.78681>,
            <0.51184,-0.83797,-0.18927>,
    /*2*/<-0.58724,-0.18015,-0.78911>,<-0.53778,0.81557,0.21363>,<0.58531,0.17848,0.79093>,
            <0.53589,-0.81729,-0.21182>,
    /*3*/<-0.59098,-0.1875,-0.78459>,<-0.65025,0.6845,0.32959>,<0.58931,0.18548,0.78633>,
            <0.64883,-0.68658,-0.32807>,
    /*4*/<-0.5993,-0.21574,-0.7709>,<-0.76384,0.43803,0.474>,<0.59838,0.2131,0.77235>,
            <0.76315,-0.44053,-0.4728>,
    /*5*/<-0.44234,-0.88562,-0.14145>,<-0.55333,-0.57343,0.60415>,<0.24922,-0.62071,0.74338>,
            <0.36022,-0.93287,-0.00224>,
    /*6*/<-0.11822,-0.92209,0.36847>

    /* stem 0c6.16*/ 
    /*0*/<0.01324,-0.48268,0.8757>,
    /*1*/<0.94633,0.28905,0.14462>,<-0.32293,0.82695,0.4603>,<-0.94634,-0.28872,-0.14522>,
            <0.32292,-0.82662,-0.4609>,
    /*2*/<0.94611,0.28418,0.1553>,<-0.32199,0.86429,0.38644>,<-0.9461,-0.28387,-0.1559>,
            <0.322,-0.86401,-0.38704>,
    /*3*/<0.94508,0.2791,0.1701>,<-0.31161,0.92555,0.21508>,<-0.94502,-0.2789,-0.17074>,
            <0.31167,-0.92538,-0.2157>,
    /*4*/<0.94722,0.27982,0.15643>,<-0.28539,0.95841,0.00012>,<-0.94713,-0.27975,-0.1571>,
            <0.28549,-0.95838,-0.00077>,
    /*5*/<0.68413,0.09931,-0.72257>,<-0.01565,0.49312,-0.86982>,<-0.41377,-0.21946,-0.88353>,
            <0.28601,-0.61327,-0.73627>,
    /*6*/<0.16555,-0.07357,-0.98345>

    /* stem 0c7*/ 
    /*0*/<0.19002,-0.88456,0.42596>,
    /*1*/<0.91428,0.00703,-0.40501>,<0.35432,0.47083,0.80795>,<-0.91618,0.00182,0.40076>,
            <-0.35622,-0.46198,-0.81221>,
    /*2*/<0.91582,-0.00058,-0.40158>,<0.36084,0.4382,0.82327>,<-0.91758,0.00951,0.39744>,
            <-0.36255,-0.42928,-0.82721>,
    /*3*/<0.91412,0.01065,-0.40531>,<0.37686,0.35269,0.8565>,<-0.91567,-0.0014,0.40192>,
            <-0.37817,-0.34361,-0.8596>,
    /*4*/<0.91212,0.03144,-0.40873>,<0.3961,0.18749,0.89886>,<-0.91332,-0.02174,0.40665>,
            <-0.39699,-0.1786,-0.90028>,
    /*5*/<0.90903,0.0672,-0.41127>,<0.39987,0.12484,0.90803>,<-0.90999,-0.05732,0.41066>,
            <-0.40069,-0.11581,-0.90886>,
    /*6*/<0.90643,0.08495,-0.41372>,<0.38548,0.24069,0.89077>,<-0.90798,-0.07526,0.4122>,
            <-0.3872,-0.23129,-0.89251>,
    /*7*/<0.91632,0.03567,-0.39885>,<0.36068,0.37191,0.85533>,<-0.91791,-0.02629,0.39591>,
            <-0.36251,-0.3629,-0.85842>,
    /*8*/<0.91618,0.03228,-0.39946>,<0.33573,0.47773,0.81182>,<-0.9182,-0.02341,0.39542>,
            <-0.33766,-0.46908,-0.81606>,
    /*9*/<0.8972,0.08918,-0.43253>,<0.31229,0.56049,0.76703>,<-0.90016,-0.0808,0.42801>,
            <-0.31516,-0.55225,-0.77181>,
    /*10*/<-0.35266,0.79349,-0.49598>

    /* stem 0c7.0*/ 
    /*0*/<0.43212,0.88084,-0.19338>,
    /*1*/<0.25845,-0.33113,-0.9075>,<-0.86534,0.33821,-0.36987>,<-0.26234,0.3232,0.90924>,
            <0.86145,-0.34614,0.37161>,
    /*2*/<0.25854,-0.3312,-0.90745>,<-0.88623,0.29234,-0.35934>,<-0.26223,0.32319,0.90928>,
            <0.88278,-0.30035,0.36124>,
    /*3*/<0.26578,-0.3025,-0.91534>,<-0.93973,0.12422,-0.31857>,<-0.26825,0.29408,0.91737>,
            <0.93785,-0.13233,0.32083>,
    /*4*/<0.26548,-0.26609,-0.92667>,<-0.96274,-0.11857,-0.24305>,<-0.26565,0.25742,0.92907>,
            <0.96309,0.11044,0.24548>,
    /*5*/<0.28645,-0.91399,-0.28735>,<-0.41302,-0.90134,0.13036>,<-0.01717,-0.61983,0.78455>,
            <0.68229,-0.6324,0.36681>,
    /*6*/<0.16472,-0.93827,0.30415>

    /* stem 0c7.1*/ 
    /*0*/<-0.84137,0.04111,0.53889>,
    /*1*/<0.5132,0.39318,0.76291>,<-0.17673,0.91827,-0.35433>,<-0.50562,-0.39355,-0.76776>,
            <0.18431,-0.91864,0.34948>,
    /*2*/<0.51614,0.39282,0.76111>,<-0.14228,0.9156,-0.37609>,<-0.50855,-0.39337,-0.76592>,
            <0.14987,-0.9163,0.37138>,
    /*3*/<0.5217,0.39097,0.75827>,<0.01341,0.8849,-0.46559>,<-0.514,-0.39263,-0.76266>,
            <-0.00605,-0.88702,0.46169>,
    /*4*/<0.5228,0.38924,0.7584>,<0.2553,0.77775,-0.57439>,<-0.51529,-0.39312,-0.76154>,
            <-0.24845,-0.78185,0.57182>,
    /*5*/<0.92996,-0.26097,0.25898>,<0.84302,-0.08309,-0.53142>,<0.33322,-0.71295,-0.61699>,
            <0.42008,-0.89076,0.17343>,
    /*6*/<0.77272,-0.59577,-0.219>

    /* stem 0c7.2*/ 
    /*0*/<0.00432,-0.30547,-0.95219>,
    /*1*/<-0.98973,-0.13603,0.04388>,<-0.14295,0.9436,-0.29863>,<0.98969,0.13878,-0.03531>,
            <0.14291,-0.94085,0.3072>,
    /*2*/<-0.98917,-0.14657,0.00816>,<-0.14393,0.95015,-0.27658>,<0.98881,0.14916,0.00041>,
            <0.14375,-0.94762,0.28521>,
    /*3*/<-0.98765,-0.15416,-0.02812>,<-0.14981,0.98073,-0.12539>,<0.98709,0.15583,0.03691>,
            <0.14935,-0.97966,0.13399>,
    /*4*/<-0.98743,-0.15478,-0.03197>,<-0.15846,0.9788,0.12975>,<0.98719,0.15417,0.04096>,
            <0.15834,-0.9799,-0.12133>,
    /*5*/<-0.56942,-0.29343,0.76789>,<-0.09166,0.34538,0.93398>,<0.56833,-0.11724,0.8144>,
            <0.09057,-0.75603,0.64824>,
    /*6*/<-0.00066,-0.25122,0.96793>

    /* stem 0c7.3*/ 
    /*0*/<0.44924,-0.59308,0.66816>,
    /*1*/<0.81264,-0.03237,-0.58186>,<0.3647,0.80704,0.46442>,<-0.81669,0.03771,0.57585>,
            <-0.36874,-0.8017,-0.47043>,
    /*2*/<0.81186,-0.03156,-0.58299>,<0.34555,0.83089,0.43614>,<-0.81599,0.03675,0.5769>,
            <-0.34971,-0.82588,-0.44229>,
    /*3*/<0.81298,-0.0329,-0.58137>,<0.25807,0.91586,0.30757>,<-0.81747,0.03709,0.57477>,
            <-0.26255,-0.91238,-0.31406>,
    /*4*/<0.80673,-0.03283,-0.59001>,<0.10111,0.99114,0.08611>,<-0.81186,0.03469,0.58282>,
            <-0.10591,-0.99002,-0.09292>,
    /*5*/<-0.02816,-0.03019,-0.99915>,<-0.4771,0.56607,-0.67226>,<-0.95068,0.01074,-0.30998>,
            <-0.50168,-0.58552,-0.63677>,
    /*6*/<-0.59878,-0.0119,-0.80082>

    /* stem 0c7.4*/ 
    /*0*/<-0.57108,0.82089,-0.00203>,
    /*1*/<0.08151,0.05368,0.99523>,<0.81965,0.5645,-0.09755>,<-0.07637,-0.06107,-0.99521>,
            <-0.81451,-0.57188,0.09757>,
    /*2*/<0.06595,0.07747,0.99481>,<0.83754,0.5378,-0.09645>,<-0.06092,-0.0849,-0.99453>,
            <-0.83264,-0.54532,0.09662>,
    /*3*/<0.04792,0.11146,0.99261>,<0.91167,0.40149,-0.08755>,<-0.04372,-0.11937,-0.99189>,
            <-0.90808,-0.40938,0.08825>,
    /*4*/<0.04584,0.1175,0.99202>,<0.9834,0.16916,-0.06564>,<-0.04368,-0.12619,-0.99104>,
            <-0.98186,-0.17751,0.06661>,
    /*5*/<0.07431,-0.74243,0.66579>,<0.62328,-0.77931,0.0648>,<0.02307,-0.87846,-0.47726>,
            <-0.52589,-0.84151,0.12372>,
    /*6*/<0.05957,-0.99154,0.11533>

    /* stem 0c7.5*/ 
    /*0*/<0.26415,-0.82143,-0.50544>,
    /*1*/<-0.92717,-0.06572,-0.36884>,<0.26857,0.56975,-0.77669>,<0.92479,0.07311,0.37338>,
            <-0.27094,-0.56236,0.78124>,
    /*2*/<-0.93676,-0.03544,-0.34816>,<0.25956,0.60103,-0.7559>,<0.93467,0.04272,0.35295>,
            <-0.26187,-0.59386,0.76076>,
    /*3*/<-0.94638,-0.00635,-0.32298>,<0.2124,0.74081,-0.63725>,<0.94432,0.01289,0.32878>,
            <-0.21451,-0.73504,0.6432>,
    /*4*/<-0.9456,-0.00885,-0.32522>,<0.13196,0.90179,-0.41153>,<0.94298,0.01335,0.33259>,
            <-0.13444,-0.89816,0.41862>,
    /*5*/<-0.80564,0.24361,0.53999>,<-0.20989,0.79899,0.56353>,<0.28041,0.25759,0.92467>,
            <-0.31531,-0.29781,0.90105>,
    /*6*/<-0.3213,0.3066,0.89597>

    /* stem 0c7.6*/ 
    /*0*/<0.32461,0.92606,0.19247>,
    /*1*/<0.53508,-0.01687,-0.84463>,<-0.78039,0.37299,-0.50186>,<-0.538,0.00853,0.8429>,
            <0.77747,-0.38133,0.50012>,
    /*2*/<0.53804,-0.00744,-0.84289>,<-0.79483,0.32737,-0.51095>,<-0.54074,-0.00098,0.84119>,
            <0.79229,-0.3358,0.50942>,
    /*3*/<0.54236,0.01793,-0.83996>,<-0.83293,0.12743,-0.53851>,<-0.54383,-0.02675,0.83877>,
            <0.83205,-0.13585,0.53782>,
    /*4*/<0.54241,0.02814,-0.83964>,<-0.82835,-0.15042,-0.53964>,<-0.54161,-0.03712,0.83981>,
            <0.82953,0.14217,0.54006>,
    /*5*/<0.50802,-0.77183,-0.38235>,<-0.26903,-0.94107,-0.20496>,<-0.11891,-0.80306,0.58391>,
            <0.65811,-0.63375,0.40651>,
    /*6*/<0.23803,-0.9634,0.1233>

    /* stem 0c7.7*/ 
    /*0*/<-0.75412,0.24423,0.60963>,
    /*1*/<0.65719,0.1905,0.72925>,<0.06536,0.94949,-0.30691>,<-0.65041,-0.1927,-0.73474>,
            <-0.05857,-0.95169,0.30142>,
    /*2*/<0.65724,0.19044,0.72923>,<0.08134,0.944,-0.31975>,<-0.65045,-0.19273,-0.73469>,
            <-0.07458,-0.94638,0.31433>,
    /*3*/<0.65671,0.1903,0.72974>,<0.19893,0.8899,-0.4105>,<-0.65001,-0.19344,-0.7349>,
            <-0.1926,-0.89345,0.40578>,
    /*4*/<0.64028,0.2048,0.74033>,<0.38974,0.74682,-0.53885>,<-0.63404,-0.21,-0.74424>,
            <-0.38417,-0.75216,0.53542>,
    /*5*/<0.87028,-0.45726,0.18311>,<0.78131,-0.20939,-0.58797>,<0.15161,-0.71844,-0.67886>,
            <0.24052,-0.96625,0.09225>,
    /*6*/<0.62512,-0.71921,-0.30326>

    /* stem 0c7.8*/ 
    /*0*/<-0.08344,-0.06923,-0.9941>,
    /*1*/<-0.98231,-0.1595,0.09809>,<-0.16498,0.98502,-0.05022>,<0.98306,0.16013,-0.08914>,
            <0.16573,-0.98439,0.05917>,
    /*2*/<-0.98306,-0.15982,0.08972>,<-0.16151,0.98685,-0.00661>,<0.98377,0.16023,-0.08076>,
            <0.16229,-0.98662,0.01552>,
    /*3*/<-0.98454,-0.15877,0.07404>,<-0.14583,0.97483,0.16864>,<0.98529,0.15798,-0.0651>,
            <0.14668,-0.97613,-0.16015>,
    /*4*/<-0.98507,-0.15781,0.06887>,<-0.11511,0.90095,0.41837>,<0.9861,0.15473,-0.06046>,
            <0.11615,-0.90435,-0.41068>,
    /*5*/<-0.45377,-0.51129,0.72985>,<0.05668,0.06523,0.99626>,<0.6815,-0.32965,0.65336>,
            <0.17104,-0.90613,0.38688>,
    /*6*/<0.13931,-0.51443,0.84614>

    /* stem 0c7.9*/ 
    /*0*/<0.9859,0.16731,-0.00238>,
    /*1*/<0.03511,-0.24752,-0.96825>,<-0.16703,0.95376,-0.24989>,<-0.04398,0.24601,0.96827>,
            <0.15815,-0.95527,0.24991>,
    /*2*/<0.0535,-0.24316,-0.96851>,<-0.23934,0.93811,-0.25034>,<-0.0623,0.2413,0.96845>,
            <0.23074,-0.94023,0.25045>,
    /*3*/<0.08406,-0.23123,-0.96926>,<-0.46754,0.84905,-0.246>,<-0.09233,0.22765,0.96936>,
            <0.46021,-0.85295,0.24634>,
    /*4*/<0.08461,-0.23417,-0.96851>,<-0.72289,0.6552,-0.21943>,<-0.0913,0.22818,0.96933>,
            <0.71727,-0.66107,0.22024>,
    /*5*/<-0.42198,-0.7988,-0.42878>,<-0.93819,-0.34598,0.00988>,<-0.51434,-0.51657,0.68455>,
            <0.00194,-0.9693,0.24587>,
    /*6*/<-0.57277,-0.80465,0.15646>

    /* stem 0c7.10*/ 
    /*0*/<-0.24749,0.37268,0.89435>,
    /*1*/<0.95663,0.24501,0.1576>,<-0.15928,0.89289,-0.42117>,<-0.9544,-0.24836,-0.16565>,
            <0.1615,-0.89624,0.41312>,
    /*2*/<0.9572,0.24401,0.15564>,<-0.15009,0.87836,-0.45383>,<-0.95497,-0.24752,-0.16362>,
            <0.15236,-0.88199,0.44595>,
    /*3*/<0.96269,0.23193,0.13945>,<-0.10471,0.78876,-0.60572>,<-0.96047,-0.23648,-0.1469>,
            <0.10699,-0.79357,0.59899>,
    /*4*/<0.96741,0.21766,0.12939>,<-0.02948,0.60579,-0.79508>,<-0.96513,-0.22414,-0.13521>,
            <0.03162,-0.61219,0.79008>,
    /*5*/<0.76786,-0.55382,-0.322>,<0.21276,-0.39051,-0.89568>,<-0.34521,-0.80949,-0.47492>,
            <0.20987,-0.97273,0.0988>,
    /*6*/<0.25854,-0.83397,-0.48749>

    /* stem 0c7.11*/ 
    /*0*/<-0.37647,-0.39322,-0.83884>,
    /*1*/<-0.91262,0.01358,0.40858>,<-0.14758,0.92113,-0.3602>,<0.91601,-0.01004,-0.40104>,
            <0.15097,-0.91759,0.36774>,
    /*2*/<-0.91709,0.00957,0.39858>,<-0.12323,0.94469,-0.30393>,<0.92042,-0.0063,-0.39088>,
            <0.12661,-0.94174,0.3116>,
    /*3*/<-0.90807,0.00964,0.41872>,<-0.03295,0.99382,-0.10596>,<0.91174,-0.00791,-0.41069>,
            <0.03626,-0.99286,0.11364>,
    /*4*/<-0.90266,0.00768,0.43029>,<0.08858,0.98026,0.17676>,<0.90646,-0.00874,-0.42221>,
            <-0.08504,-0.98186,-0.16947>,
    /*5*/<-0.21611,-0.26667,0.93925>,<0.39812,0.26524,0.87815>,<0.83547,-0.287,0.46864>,
            <0.2212,-0.81887,0.52964>,
    /*6*/<0.37888,-0.3387,0.86124>

    /* stem 0c7.12*/ 
    /*0*/<0.84758,-0.22031,0.48278>,
    /*1*/<0.39849,-0.32731,-0.85678>,<0.34358,0.9194,-0.19145>,<-0.40489,0.32897,0.85314>,
            <-0.34998,-0.91774,0.18781>,
    /*2*/<0.42142,-0.3317,-0.84403>,<0.29208,0.93032,-0.22178>,<-0.4278,0.33308,0.84026>,
            <-0.29852,-0.92913,0.21819>,
    /*3*/<0.44097,-0.33451,-0.83285>,<0.08509,0.93948,-0.33186>,<-0.44762,0.33458,0.82927>,
            <-0.09132,-0.94,0.32871>,
    /*4*/<0.44307,-0.33476,-0.83164>,<-0.15258,0.88557,-0.43874>,<-0.44978,0.33267,0.82887>,
            <0.14644,-0.88778,0.43635>,
    /*5*/<-0.44304,-0.52167,-0.72909>,<-0.83855,0.15989,-0.52083>,<-0.96381,-0.14111,0.22619>,
            <-0.56826,-0.82265,0.01794>,
    /*6*/<-0.86075,-0.40551,-0.30769>

    /* stem 0c7.13*/ 
    /*0*/<-0.51336,0.60855,0.60509>,
    /*1*/<0.85703,0.41495,0.30548>,<-0.06385,0.67382,-0.73613>,<-0.85436,-0.41812,-0.30863>,
            <0.06652,-0.67698,0.73299>,
    /*2*/<0.85678,0.41522,0.3058>,<-0.03686,0.64095,-0.76669>,<-0.8541,-0.41847,-0.30885>,
            <0.03952,-0.64427,0.76378>,
    /*3*/<0.87503,0.38696,0.29083>,<0.0566,0.50614,-0.86059>,<-0.87251,-0.39076,-0.29333>,
            <-0.05411,-0.5099,0.85853>,
    /*4*/<0.89727,0.34018,0.28138>,<0.19002,0.27307,-0.94304>,<-0.89513,-0.34473,-0.28268>,
            <-0.18804,-0.27742,0.94217>,
    /*5*/<0.81015,-0.57318,0.12298>,<0.43345,-0.67896,-0.59256>,<-0.22916,-0.95192,-0.2033>,
            <0.14751,-0.84608,0.51224>,
    /*6*/<0.35556,-0.93336,-0.04916>

    /* stem 0c7.14*/ 
    /*0*/<-0.54938,-0.55593,-0.6238>,
    /*1*/<-0.77134,0.05346,0.63417>,<-0.31835,0.83043,-0.45721>,<0.77305,-0.05173,-0.63223>,
            <0.32006,-0.8287,0.45915>,
    /*2*/<-0.78658,0.0394,0.61623>,<-0.28983,0.8588,-0.42245>,<0.78825,-0.03773,-0.6142>,
            <0.29155,-0.85721,0.42448>,
    /*3*/<-0.78339,0.03865,0.62033>,<-0.19039,0.93329,-0.30451>,<0.78518,-0.03737,-0.61814>,
            <0.19211,-0.93221,0.30672>,
    /*4*/<-0.7795,0.03823,0.62523>,<-0.05771,0.99014,-0.12767>,<0.78143,-0.03763,-0.62286>,
            <0.05959,-0.98973,0.12993>,
    /*5*/<0.03385,0.04688,0.99833>,<0.50251,0.59938,0.62308>,<0.95312,-0.00057,0.30258>,
            <0.48445,-0.55306,0.67781>,
    /*6*/<0.60417,0.02835,0.79635>

    /* stem 0c7.15*/ 
    /*0*/<0.97512,0.11798,0.18768>,
    /*1*/<0.22052,-0.44452,-0.8682>,<-0.01935,0.88795,-0.45954>,<-0.22121,0.44443,0.86807>,
            <0.01866,-0.88803,0.45941>,
    /*2*/<0.22174,-0.44433,-0.86799>,<-0.0585,0.88245,-0.46675>,<-0.22243,0.44423,0.86786>,
            <0.05782,-0.88256,0.46663>,
    /*3*/<0.21939,-0.4452,-0.86814>,<-0.21865,0.84498,-0.48806>,<-0.22007,0.44503,0.86805>,
            <0.218,-0.84518,0.488>,
    /*4*/<0.21715,-0.44657,-0.868>,<-0.46628,0.73364,-0.49433>,<-0.21778,0.44624,0.86801>,
            <0.46571,-0.73398,0.49436>,
    /*5*/<-0.51158,-0.75808,-0.40448>,<-0.97549,-0.12445,-0.18145>,<-0.76365,-0.24367,0.59788>,
            <-0.29973,-0.87729,0.37486>,
    /*6*/<-0.78085,-0.61339,0.11843>

    /* stem 0.0*/ 
    /*0*/<-0.97451,0.16742,-0.14931>,
    /*1*/<-0.18454,-0.25439,0.94933>,<0.12534,0.95194,0.27947>,<0.19331,0.25288,-0.94799>,
            <-0.11657,-0.95344,-0.27813>,
    /*2*/<-0.1895,-0.25349,0.9486>,<0.14386,0.94846,0.28235>,<0.19825,0.25189,-0.94723>,
            <-0.13512,-0.95014,-0.28103>,
    /*3*/<-0.19006,-0.254,0.94835>,<0.2805,0.91173,0.30012>,<0.19868,0.25162,-0.94721>,
            <-0.2723,-0.91453,-0.29916>,
    /*4*/<-0.19391,-0.25291,0.94786>,<0.49235,0.81014,0.31822>,<0.20181,0.24859,-0.94735>,
            <-0.48507,-0.81463,-0.31794>,
    /*5*/<0.52596,-0.64462,0.55483>,<0.97871,-0.07254,0.19201>,<0.76112,-0.36307,-0.53747>,
            <0.30832,-0.93511,-0.17465>,
    /*6*/<0.78734,-0.61643,0.01062>

    /* stem 0.1*/ 
    /*0*/<0.80194,0.14434,-0.5797>,
    /*1*/<-0.60028,0.2408,-0.76268>,<0.02589,0.95896,0.28236>,<0.59306,-0.24209,0.7679>,
            <-0.03311,-0.96026,-0.27714>,
    /*2*/<-0.5985,0.24112,-0.76398>,<-0.00417,0.95275,0.30372>,<0.59126,-0.24257,0.76913>,
            <-0.00303,-0.95436,-0.29863>,
    /*3*/<-0.60391,0.23826,-0.76061>,<-0.12551,0.91358,0.38682>,<0.59674,-0.2407,0.76549>,
            <0.11859,-0.91639,-0.38231>,
    /*4*/<-0.58965,0.24659,-0.76909>,<-0.29353,0.82367,0.48519>,<0.58271,-0.25077,0.77302>,
            <0.28707,-0.82807,-0.48154>,
    /*5*/<-0.932,-0.3195,-0.17114>,<-0.81291,-0.03112,0.58155>,<-0.27839,-0.62888,0.72595>,
            <-0.39745,-0.91723,-0.02676>,
    /*6*/<-0.74043,-0.58015,0.33939>

    /* stem 0.2*/ 
    /*0*/<-0.32311,-0.54329,0.77488>,
    /*1*/<0.94769,-0.17013,0.27008>,<-0.01344,0.82405,0.56635>,<-0.94478,0.17502,-0.27705>,
            <0.01635,-0.81916,-0.57333>,
    /*2*/<0.93762,-0.18575,0.29387>,<-0.00228,0.84048,0.54184>,<-0.93447,0.19046,-0.30083>,
            <0.00531,-0.83586,-0.54892>,
    /*3*/<0.92915,-0.19666,0.31304>,<0.04328,0.89928,0.43523>,<-0.9258,0.20059,-0.32039>,
            <-0.03998,-0.89582,-0.44262>,
    /*4*/<0.94069,-0.1922,0.27958>,<0.13358,0.97018,0.20224>,<-0.93776,0.19431,-0.28785>,
            <-0.13074,-0.96887,-0.21021>,
    /*5*/<0.75944,-0.10763,-0.64162>,<0.32195,0.57026,-0.75575>,<-0.33147,0.11805,-0.93605>,
            <0.10599,-0.55983,-0.8218>,
    /*6*/<0.2618,0.00637,-0.9651>

    /* stem 0.3*/ 
    /*0*/<-0.5528,0.40026,-0.73089>,
    /*1*/<-0.82808,-0.19538,0.52546>,<0.07001,0.89391,0.44275>,<0.83306,0.19178,-0.51888>,
            <-0.06503,-0.89751,-0.43617>,
    /*2*/<-0.83646,-0.18874,0.5145>,<0.09345,0.87529,0.47448>,<0.84131,0.18494,-0.50794>,
            <-0.08859,-0.87923,-0.46809>,
    /*3*/<-0.84456,-0.18132,0.50382>,<0.18482,0.78402,0.59259>,<0.84916,0.17647,-0.49778>,
            <-0.1805,-0.78912,-0.58712>,
    /*4*/<-0.84133,-0.18819,0.50671>,<0.30443,0.61071,0.731>,<0.84549,0.18163,-0.50215>,
            <-0.30068,-0.61724,-0.72705>,
    /*5*/<-0.14806,-0.79289,0.59111>,<0.53928,-0.38481,0.74907>,<0.8205,-0.57159,0.0075>,
            <0.13314,-0.97961,-0.15049>,
    /*6*/<0.41135,-0.83468,0.36618>

    /* stem 0.4*/ 
    /*0*/<0.64095,-0.67347,-0.36827>,
    /*1*/<-0.08792,0.41755,-0.90439>,<0.75997,0.61507,0.21007>,<0.08215,-0.41149,0.9077>,
            <-0.76574,-0.60901,-0.20676>,
    /*2*/<-0.0798,0.40927,-0.90892>,<0.74834,0.62704,0.21636>,<0.07396,-0.40321,0.91211>,
            <-0.75423,-0.62106,-0.21313>,
    /*3*/<-0.0747,0.40411,-0.91165>,<0.64969,0.71318,0.2632>,<0.06827,-0.39853,0.91461>,
            <-0.65627,-0.70813,-0.2605>,
    /*4*/<-0.08299,0.40657,-0.90984>,<0.45142,0.82923,0.32954>,<0.07526,-0.40263,0.91227>,
            <-0.45901,-0.8259,-0.32742>,
    /*5*/<-0.81123,0.46785,-0.35075>,<-0.5634,0.73455,0.37819>,<-0.71578,0.00093,0.69832>,
            <-0.96355,-0.26578,-0.03064>,
    /*6*/<-0.93411,0.28676,0.21262>

    /* stem 0.5*/ 
    /*0*/<-0.23447,-0.86005,0.45314>,
    /*1*/<0.96756,-0.15235,0.20156>,<-0.10327,0.48957,0.86583>,<-0.96545,0.16009,-0.20564>,
            <0.10538,-0.48182,-0.86991>,
    /*2*/<0.96377,-0.16544,0.20924>,<-0.09014,0.53322,0.84116>,<-0.9615,0.17304,-0.21349>,
            <0.09234,-0.52579,-0.84559>,
    /*3*/<0.95533,-0.18883,0.22736>,<-0.03573,0.68363,0.72895>,<-0.95268,0.19562,-0.23266>,
            <0.0382,-0.67757,-0.73446>,
    /*4*/<0.95467,-0.1916,0.22779>,<0.05398,0.8672,0.49502>,<-0.95196,0.19642,-0.23491>,
            <-0.05145,-0.86337,-0.50195>,
    /*5*/<0.77271,0.14868,-0.61711>,<0.28146,0.79405,-0.53876>,<-0.32995,0.36857,-0.86907>,
            <0.16126,-0.27683,-0.94729>,
    /*6*/<0.27085,0.31642,-0.90913>

    /* stem 0.6*/ 
    /*0*/<-0.34806,-0.47235,-0.80978>,
    /*1*/<-0.84795,-0.20424,0.48916>,<-0.39488,0.85903,-0.32579>,<0.85108,0.2085,-0.48187>,
            <0.39801,-0.85478,0.33308>,
    /*2*/<-0.84111,-0.19684,0.50377>,<-0.37258,0.88545,-0.27779>,<0.84448,0.2009,-0.49648>,
            <0.37595,-0.88168,0.28513>,
    /*3*/<-0.83037,-0.18968,0.52393>,<-0.29354,0.94801,-0.1229>,<0.83441,0.19254,-0.51641>,
            <0.29755,-0.94579,0.13019>,
    /*4*/<-0.8472,-0.19062,0.4959>,<-0.16484,0.98049,0.10708>,<0.8516,0.1912,-0.48807>,
            <0.16926,-0.9805,-0.09984>,
    /*5*/<-0.1039,-0.22655,0.96844>,<0.34716,0.43764,0.82943>,<0.89822,-0.01839,0.43916>,
            <0.44711,-0.68256,0.5781>,
    /*6*/<0.48591,-0.14984,0.86107>

    /* stem 0.7*/ 
    /*0*/<0.94122,-0.15012,-0.30259>,
    /*1*/<-0.24069,0.34757,-0.90624>,<0.23698,0.92647,0.29237>,<0.23221,-0.34622,0.90896>,
            <-0.24546,-0.92512,-0.28965>,
    /*2*/<-0.24618,0.34796,-0.90461>,<0.17775,0.93365,0.31096>,<0.23765,-0.34688,0.9073>,
            <-0.18624,-0.93284,-0.30841>,
    /*3*/<-0.26077,0.3467,-0.901>,<0.0166,0.9345,0.35557>,<0.25209,-0.34691,0.90339>,
            <-0.025,-0.93511,-0.35346>,
    /*4*/<-0.25757,0.34654,-0.90198>,<-0.20878,0.89229,0.40028>,<0.24894,-0.34859,0.90361>,
            <0.20065,-0.89478,-0.39888>,
    /*5*/<-0.8873,-0.11735,-0.44602>,<-0.93387,0.16762,0.31591>,<-0.60841,-0.52533,0.59487>,
            <-0.56176,-0.81025,-0.16707>,
    /*6*/<-0.91496,-0.39314,0.09105>

    /* stem 0.8*/ 
    /*0*/<-0.60192,-0.36647,0.7095>,
    /*1*/<0.79997,-0.22377,0.55675>,<-0.04256,0.90435,0.42466>,<-0.79456,0.22707,-0.56313>,
            <0.04797,-0.90105,-0.43105>,
    /*2*/<0.80274,-0.22236,0.55333>,<-0.01514,0.92003,0.39154>,<-0.79734,0.22548,-0.55982>,
            <0.02052,-0.91713,-0.39807>,
    /*3*/<0.8055,-0.22177,0.54954>,<0.08882,0.96191,0.25855>,<-0.80014,0.22379,-0.5565>,
            <-0.08372,-0.9605,-0.26538>,
    /*4*/<0.80786,-0.22337,0.54541>,<0.24193,0.96954,0.03816>,<-0.80283,0.22311,-0.55289>,
            <-0.23732,-0.97038,-0.04522>,
    /*5*/<0.87341,-0.31865,-0.36826>,<0.58901,0.35628,-0.72535>,<-0.05706,-0.05958,-0.99659>,
            <0.22729,-0.73449,-0.63943>,
    /*6*/<0.49938,-0.23138,-0.83491>

    /* stem 0.9*/ 
    /*0*/<-0.0147,0.97821,-0.20707>,
    /*1*/<-0.99547,0.00055,0.09503>,<0.09314,0.20313,0.97471>,<0.99561,-0.00936,-0.09317>,
            <-0.09301,-0.21194,-0.97285>,
    /*2*/<-0.99474,-0.02491,0.09931>,<0.09463,0.16643,0.9815>,<0.99509,0.01609,-0.09764>,
            <-0.09442,-0.17526,-0.97998>,
    /*3*/<-0.99479,-0.0161,0.10069>,<0.09608,0.00504,0.99536>,<0.99496,0.00715,-0.10005>,
            <-0.09579,-0.01372,-0.99531>,
    /*4*/<-0.9939,0.01965,0.10852>,<0.09833,-0.27536,0.9563>,<0.9935,-0.02847,-0.11023>,
            <-0.09877,0.26724,-0.95856>,
    /*5*/<-0.62892,-0.72746,-0.27435>,<-0.0049,-0.98309,0.18304>,<0.51594,-0.7568,-0.40131>,
            <-0.10806,-0.50106,-0.85864>,
    /*6*/<-0.06911,-0.90796,-0.41332>

    /* stem 0.10*/ 
    /*0*/<0.99664,-0.03633,-0.07341>,
    /*1*/<-0.06098,0.34417,-0.93692>,<0.05482,0.93842,0.34113>,<0.05201,-0.34385,0.93758>,
            <-0.06379,-0.93809,-0.34047>,
    /*2*/<-0.06205,0.34415,-0.93686>,<0.03637,0.93884,0.34242>,<0.05307,-0.34391,0.9375>,
            <-0.04534,-0.93867,-0.34181>,
    /*3*/<-0.06641,0.34328,-0.93688>,<-0.11123,0.93052,0.34895>,<0.05742,-0.34383,0.93727>,
            <0.1026,-0.93157,-0.34879>,
    /*4*/<-0.06067,0.34434,-0.93688>,<-0.3596,0.8686,0.34092>,<0.05207,-0.347,0.93642>,
            <0.35167,-0.87161,-0.34151>,
    /*5*/<-0.74797,-0.17094,-0.64135>,<-0.99127,0.09792,0.08833>,<-0.69191,-0.57537,0.43614>,
            <-0.44854,-0.84419,-0.29352>,
    /*6*/<-0.88081,-0.45653,-0.12553>

    /* stem 0.11*/ 
    /*0*/<-0.05038,0.14993,0.98741>,
    /*1*/<0.99671,-0.05926,0.05529>,<0.06703,0.98628,-0.15089>,<-0.99626,0.05791,-0.06418>,
            <-0.06658,-0.98762,0.142>,
    /*2*/<0.99687,-0.06032,0.05119>,<0.06991,0.9739,-0.21595>,<-0.99647,0.05867,-0.06003>,
            <-0.06952,-0.97581,0.20728>,
    /*3*/<0.99694,-0.0624,0.04704>,<0.0762,0.91542,-0.39522>,<-0.99669,0.05936,-0.05552>,
            <-0.076,-0.91881,0.38732>,
    /*4*/<0.99656,-0.04898,0.06681>,<0.08229,0.79743,-0.59777>,<-0.99626,0.04401,-0.07432>,
            <-0.08215,-0.80255,0.5909>,
    /*5*/<0.60986,-0.57553,-0.54482>,<0.08137,-0.14044,-0.98674>,<-0.5377,-0.54431,-0.6439>,
            <-0.00921,-0.97935,-0.20194>,
    /*6*/<0.04414,-0.68503,-0.72717>

    /* stem 0.12*/ 
    /*0*/<-0.83833,-0.14709,-0.52495>,
    /*1*/<-0.48926,-0.20566,0.84754>,<-0.22886,0.96802,0.10281>,<0.49681,0.20699,-0.84282>,
            <0.2364,-0.96669,-0.09809>,
    /*2*/<-0.50266,-0.20691,0.83936>,<-0.16161,0.97606,0.14553>,<0.51021,0.20786,-0.83455>,
            <0.16913,-0.97547,-0.14093>,
    /*3*/<-0.51638,-0.20737,0.83087>,<0.0181,0.96727,0.2531>,<0.52407,0.20666,-0.82622>,
            <-0.01084,-0.96848,-0.24884>,
    /*4*/<-0.51655,-0.20845,0.8305>,<0.23587,0.89762,0.37234>,<0.52407,0.20551,-0.82651>,
            <-0.2289,-0.90089,-0.36877>,
    /*5*/<0.34235,-0.52559,0.77881>,<0.83525,0.07929,0.54412>,<0.94166,-0.28692,-0.17593>,
            <0.4487,-0.89175,0.05873>,
    /*6*/<0.78546,-0.49703,0.3688>

    /* stem 0.13*/ 
    /*0*/<0.8138,0.44623,-0.37229>,
    /*1*/<-0.52779,0.28773,-0.79915>,<-0.25242,0.84524,0.47102>,<0.52193,-0.29095,0.80183>,
            <0.24656,-0.84845,-0.46834>,
    /*2*/<-0.52767,0.2877,-0.79925>,<-0.30135,0.81638,0.49266>,<0.52186,-0.2911,0.80182>,
            <0.29567,-0.81992,-0.49022>,
    /*3*/<-0.52304,0.29108,-0.80106>,<-0.43163,0.7206,0.54262>,<0.51756,-0.29531,0.80308>,
            <0.42652,-0.72495,-0.54086>,
    /*4*/<-0.52128,0.2925,-0.80169>,<-0.58527,0.56096,0.58547>,<0.51653,-0.29782,0.80281>,
            <0.58095,-0.56628,-0.58465>,
    /*5*/<-0.75005,-0.51245,-0.41811>,<-0.82609,-0.40969,0.38694>,<-0.14995,-0.84891,0.50682>,
            <-0.07388,-0.95163,-0.29824>,
    /*6*/<-0.55067,-0.83296,0.05428>

    /* stem 0.14*/ 
    /*0*/<0.34208,-0.63684,0.69095>,
    /*1*/<0.90025,0.01584,-0.43508>,<0.26519,0.77261,0.57684>,<-0.90213,-0.01235,0.43129>,
            <-0.26707,-0.76912,-0.58063>,
    /*2*/<0.90288,0.01126,-0.42975>,<0.25128,0.79785,0.54799>,<-0.90474,-0.00785,0.42588>,
            <-0.25319,-0.79455,-0.55189>,
    /*3*/<0.90164,0.0117,-0.43232>,<0.18994,0.88618,0.42262>,<-0.90369,-0.00885,0.4281>,
            <-0.19194,-0.88372,-0.42684>,
    /*4*/<0.89981,0.01213,-0.43612>,<0.07612,0.98044,0.18148>,<-0.90211,-0.01061,0.43137>,
            <-0.07833,-0.97942,-0.18601>,
    /*5*/<0.17134,0.04225,-0.98431>,<-0.3451,0.61157,-0.71196>,<-0.87083,0.02875,-0.49075>,
            <-0.35435,-0.54057,-0.76303>,
    /*6*/<-0.42807,0.04345,-0.9027>

    /* stem 0.15*/ 
    /*0*/<-0.78303,0.59269,0.18862>,
    /*1*/<0.07199,-0.21781,0.97333>,<0.61944,0.77462,0.12754>,<-0.06905,0.21559,-0.97404>,
            <-0.6165,-0.77684,-0.12824>,
    /*2*/<0.08111,-0.22563,0.97083>,<0.66229,0.7402,0.11605>,<-0.07825,0.22334,-0.9716>,
            <-0.65952,-0.74256,-0.1168>,
    /*3*/<0.08941,-0.23445,0.96801>,<0.79746,0.59911,0.07157>,<-0.08695,0.23174,-0.96888>,
            <-0.79533,-0.60183,-0.07242>,
    /*4*/<0.09824,-0.25753,0.96126>,<0.92693,0.37524,0.00258>,<-0.09666,0.25428,-0.96229>,
            <-0.92565,-0.37837,-0.0035>,
    /*5*/<0.25593,-0.91628,0.30809>,<0.75466,-0.60377,-0.25681>,<0.14009,-0.59265,-0.79319>,
            <-0.35865,-0.90513,-0.22827>,
    /*6*/<0.2424,-0.92362,-0.29693>

    /* stem 0.16*/ 
    /*0*/<0.41558,0.40051,-0.81663>,
    /*1*/<-0.90902,0.22243,-0.35243>,<0.04012,0.88844,0.45723>,<0.90829,-0.22314,0.35387>,
            <-0.04086,-0.88915,-0.45579>,
    /*2*/<-0.90818,0.22329,-0.35404>,<0.02308,0.87136,0.49009>,<0.90744,-0.22403,0.35546>,
            <-0.02381,-0.87213,-0.48869>,
    /*3*/<-0.90935,0.22122,-0.35233>,<-0.06515,0.75951,0.64722>,<0.90862,-0.22219,0.35362>,
            <0.06447,-0.76052,-0.64611>,
    /*4*/<-0.90813,0.22358,-0.354>,<-0.17219,0.57302,0.80125>,<0.90744,-0.22492,0.35492>,
            <0.17157,-0.5743,-0.80047>,
    /*5*/<-0.82603,-0.55067,0.12014>,<-0.42282,-0.39942,0.81344>,<0.21858,-0.8182,0.53176>,
            <-0.18463,-0.96944,-0.16155>,
    /*6*/<-0.37191,-0.83809,0.39912>

    }
    face_indices { 6656
    /* stem 0*/ 
    /*0*/ <0,1,2>,<0,2,3>,<0,3,4>,<0,4,1>,
    /*1*/ <1,5,2>,<2,5,6>,<2,6,3>,<3,6,7>,<3,7,4>,
            <4,7,8>,<4,8,1>,<1,8,5>,
    /*2*/ <5,9,6>,<6,9,10>,<6,10,7>,<7,10,11>,<7,11,8>,
            <8,11,12>,<8,12,5>,<5,12,9>,
    /*3*/ <9,13,10>,<10,13,14>,<10,14,11>,<11,14,15>,<11,15,12>,
            <12,15,16>,<12,16,9>,<9,16,13>,
    /*4*/ <13,17,14>,<14,17,18>,<14,18,15>,<15,18,19>,<15,19,16>,
            <16,19,20>,<16,20,13>,<13,20,17>,
    /*5*/ <17,21,18>,<18,21,22>,<18,22,19>,<19,22,23>,<19,23,20>,
            <20,23,24>,<20,24,17>,<17,24,21>,
    /*6*/ <21,25,22>,<22,25,26>,<22,26,23>,<23,26,27>,<23,27,24>,
            <24,27,28>,<24,28,21>,<21,28,25>,
    /*7*/ <25,29,26>,<26,29,30>,<26,30,27>,<27,30,31>,<27,31,28>,
            <28,31,32>,<28,32,25>,<25,32,29>,
    /*8*/ <29,33,30>,<30,33,34>,<30,34,31>,<31,34,35>,<31,35,32>,
            <32,35,36>,<32,36,29>,<29,36,33>,
    /*9*/ <33,37,34>,<34,37,38>,<34,38,35>,<35,38,39>,<35,39,36>,
            <36,39,40>,<36,40,33>,<33,40,37>,
    /*10*/ <37,41,38>,<38,41,39>,<39,41,40>,<40,41,37>

    /* stem 0c0*/ 
    /*0*/ <42,43,44>,<42,44,45>,<42,45,46>,<42,46,43>,
    /*1*/ <43,47,44>,<44,47,48>,<44,48,45>,<45,48,49>,<45,49,46>,
            <46,49,50>,<46,50,43>,<43,50,47>,
    /*2*/ <47,51,48>,<48,51,52>,<48,52,49>,<49,52,53>,<49,53,50>,
            <50,53,54>,<50,54,47>,<47,54,51>,
    /*3*/ <51,55,52>,<52,55,56>,<52,56,53>,<53,56,57>,<53,57,54>,
            <54,57,58>,<54,58,51>,<51,58,55>,
    /*4*/ <55,59,56>,<56,59,60>,<56,60,57>,<57,60,61>,<57,61,58>,
            <58,61,62>,<58,62,55>,<55,62,59>,
    /*5*/ <59,63,60>,<60,63,64>,<60,64,61>,<61,64,65>,<61,65,62>,
            <62,65,66>,<62,66,59>,<59,66,63>,
    /*6*/ <63,67,64>,<64,67,68>,<64,68,65>,<65,68,69>,<65,69,66>,
            <66,69,70>,<66,70,63>,<63,70,67>,
    /*7*/ <67,71,68>,<68,71,72>,<68,72,69>,<69,72,73>,<69,73,70>,
            <70,73,74>,<70,74,67>,<67,74,71>,
    /*8*/ <71,75,72>,<72,75,76>,<72,76,73>,<73,76,77>,<73,77,74>,
            <74,77,78>,<74,78,71>,<71,78,75>,
    /*9*/ <75,79,76>,<76,79,77>,<77,79,78>,<78,79,75>

    /* stem 0c0.0*/ 
    /*0*/ <80,81,82>,<80,82,83>,<80,83,84>,<80,84,81>,
    /*1*/ <81,85,82>,<82,85,86>,<82,86,83>,<83,86,87>,<83,87,84>,
            <84,87,88>,<84,88,81>,<81,88,85>,
    /*2*/ <85,89,86>,<86,89,90>,<86,90,87>,<87,90,91>,<87,91,88>,
            <88,91,92>,<88,92,85>,<85,92,89>,
    /*3*/ <89,93,90>,<90,93,94>,<90,94,91>,<91,94,95>,<91,95,92>,
            <92,95,96>,<92,96,89>,<89,96,93>,
    /*4*/ <93,97,94>,<94,97,98>,<94,98,95>,<95,98,99>,<95,99,96>,
            <96,99,100>,<96,100,93>,<93,100,97>,
    /*5*/ <97,101,98>,<98,101,99>,<99,101,100>,<100,101,97>

    /* stem 0c0.1*/ 
    /*0*/ <102,103,104>,<102,104,105>,<102,105,106>,<102,106,103>,
    /*1*/ <103,107,104>,<104,107,108>,<104,108,105>,<105,108,109>,<105,109,106>,
            <106,109,110>,<106,110,103>,<103,110,107>,
    /*2*/ <107,111,108>,<108,111,112>,<108,112,109>,<109,112,113>,<109,113,110>,
            <110,113,114>,<110,114,107>,<107,114,111>,
    /*3*/ <111,115,112>,<112,115,116>,<112,116,113>,<113,116,117>,<113,117,114>,
            <114,117,118>,<114,118,111>,<111,118,115>,
    /*4*/ <115,119,116>,<116,119,120>,<116,120,117>,<117,120,121>,<117,121,118>,
            <118,121,122>,<118,122,115>,<115,122,119>,
    /*5*/ <119,123,120>,<120,123,121>,<121,123,122>,<122,123,119>

    /* stem 0c0.2*/ 
    /*0*/ <124,125,126>,<124,126,127>,<124,127,128>,<124,128,125>,
    /*1*/ <125,129,126>,<126,129,130>,<126,130,127>,<127,130,131>,<127,131,128>,
            <128,131,132>,<128,132,125>,<125,132,129>,
    /*2*/ <129,133,130>,<130,133,134>,<130,134,131>,<131,134,135>,<131,135,132>,
            <132,135,136>,<132,136,129>,<129,136,133>,
    /*3*/ <133,137,134>,<134,137,138>,<134,138,135>,<135,138,139>,<135,139,136>,
            <136,139,140>,<136,140,133>,<133,140,137>,
    /*4*/ <137,141,138>,<138,141,142>,<138,142,139>,<139,142,143>,<139,143,140>,
            <140,143,144>,<140,144,137>,<137,144,141>,
    /*5*/ <141,145,142>,<142,145,143>,<143,145,144>,<144,145,141>

    /* stem 0c0.3*/ 
    /*0*/ <146,147,148>,<146,148,149>,<146,149,150>,<146,150,147>,
    /*1*/ <147,151,148>,<148,151,152>,<148,152,149>,<149,152,153>,<149,153,150>,
            <150,153,154>,<150,154,147>,<147,154,151>,
    /*2*/ <151,155,152>,<152,155,156>,<152,156,153>,<153,156,157>,<153,157,154>,
            <154,157,158>,<154,158,151>,<151,158,155>,
    /*3*/ <155,159,156>,<156,159,160>,<156,160,157>,<157,160,161>,<157,161,158>,
            <158,161,162>,<158,162,155>,<155,162,159>,
    /*4*/ <159,163,160>,<160,163,164>,<160,164,161>,<161,164,165>,<161,165,162>,
            <162,165,166>,<162,166,159>,<159,166,163>,
    /*5*/ <163,167,164>,<164,167,165>,<165,167,166>,<166,167,163>

    /* stem 0c0.4*/ 
    /*0*/ <168,169,170>,<168,170,171>,<168,171,172>,<168,172,169>,
    /*1*/ <169,173,170>,<170,173,174>,<170,174,171>,<171,174,175>,<171,175,172>,
            <172,175,176>,<172,176,169>,<169,176,173>,
    /*2*/ <173,177,174>,<174,177,178>,<174,178,175>,<175,178,179>,<175,179,176>,
            <176,179,180>,<176,180,173>,<173,180,177>,
    /*3*/ <177,181,178>,<178,181,182>,<178,182,179>,<179,182,183>,<179,183,180>,
            <180,183,184>,<180,184,177>,<177,184,181>,
    /*4*/ <181,185,182>,<182,185,186>,<182,186,183>,<183,186,187>,<183,187,184>,
            <184,187,188>,<184,188,181>,<181,188,185>,
    /*5*/ <185,189,186>,<186,189,187>,<187,189,188>,<188,189,185>

    /* stem 0c0.5*/ 
    /*0*/ <190,191,192>,<190,192,193>,<190,193,194>,<190,194,191>,
    /*1*/ <191,195,192>,<192,195,196>,<192,196,193>,<193,196,197>,<193,197,194>,
            <194,197,198>,<194,198,191>,<191,198,195>,
    /*2*/ <195,199,196>,<196,199,200>,<196,200,197>,<197,200,201>,<197,201,198>,
            <198,201,202>,<198,202,195>,<195,202,199>,
    /*3*/ <199,203,200>,<200,203,204>,<200,204,201>,<201,204,205>,<201,205,202>,
            <202,205,206>,<202,206,199>,<199,206,203>,
    /*4*/ <203,207,204>,<204,207,208>,<204,208,205>,<205,208,209>,<205,209,206>,
            <206,209,210>,<206,210,203>,<203,210,207>,
    /*5*/ <207,211,208>,<208,211,209>,<209,211,210>,<210,211,207>

    /* stem 0c0.6*/ 
    /*0*/ <212,213,214>,<212,214,215>,<212,215,216>,<212,216,213>,
    /*1*/ <213,217,214>,<214,217,218>,<214,218,215>,<215,218,219>,<215,219,216>,
            <216,219,220>,<216,220,213>,<213,220,217>,
    /*2*/ <217,221,218>,<218,221,222>,<218,222,219>,<219,222,223>,<219,223,220>,
            <220,223,224>,<220,224,217>,<217,224,221>,
    /*3*/ <221,225,222>,<222,225,226>,<222,226,223>,<223,226,227>,<223,227,224>,
            <224,227,228>,<224,228,221>,<221,228,225>,
    /*4*/ <225,229,226>,<226,229,230>,<226,230,227>,<227,230,231>,<227,231,228>,
            <228,231,232>,<228,232,225>,<225,232,229>,
    /*5*/ <229,233,230>,<230,233,231>,<231,233,232>,<232,233,229>

    /* stem 0c0.7*/ 
    /*0*/ <234,235,236>,<234,236,237>,<234,237,238>,<234,238,235>,
    /*1*/ <235,239,236>,<236,239,240>,<236,240,237>,<237,240,241>,<237,241,238>,
            <238,241,242>,<238,242,235>,<235,242,239>,
    /*2*/ <239,243,240>,<240,243,244>,<240,244,241>,<241,244,245>,<241,245,242>,
            <242,245,246>,<242,246,239>,<239,246,243>,
    /*3*/ <243,247,244>,<244,247,248>,<244,248,245>,<245,248,249>,<245,249,246>,
            <246,249,250>,<246,250,243>,<243,250,247>,
    /*4*/ <247,251,248>,<248,251,252>,<248,252,249>,<249,252,253>,<249,253,250>,
            <250,253,254>,<250,254,247>,<247,254,251>,
    /*5*/ <251,255,252>,<252,255,253>,<253,255,254>,<254,255,251>

    /* stem 0c0.8*/ 
    /*0*/ <256,257,258>,<256,258,259>,<256,259,260>,<256,260,257>,
    /*1*/ <257,261,258>,<258,261,262>,<258,262,259>,<259,262,263>,<259,263,260>,
            <260,263,264>,<260,264,257>,<257,264,261>,
    /*2*/ <261,265,262>,<262,265,266>,<262,266,263>,<263,266,267>,<263,267,264>,
            <264,267,268>,<264,268,261>,<261,268,265>,
    /*3*/ <265,269,266>,<266,269,270>,<266,270,267>,<267,270,271>,<267,271,268>,
            <268,271,272>,<268,272,265>,<265,272,269>,
    /*4*/ <269,273,270>,<270,273,274>,<270,274,271>,<271,274,275>,<271,275,272>,
            <272,275,276>,<272,276,269>,<269,276,273>,
    /*5*/ <273,277,274>,<274,277,275>,<275,277,276>,<276,277,273>

    /* stem 0c0.9*/ 
    /*0*/ <278,279,280>,<278,280,281>,<278,281,282>,<278,282,279>,
    /*1*/ <279,283,280>,<280,283,284>,<280,284,281>,<281,284,285>,<281,285,282>,
            <282,285,286>,<282,286,279>,<279,286,283>,
    /*2*/ <283,287,284>,<284,287,288>,<284,288,285>,<285,288,289>,<285,289,286>,
            <286,289,290>,<286,290,283>,<283,290,287>,
    /*3*/ <287,291,288>,<288,291,292>,<288,292,289>,<289,292,293>,<289,293,290>,
            <290,293,294>,<290,294,287>,<287,294,291>,
    /*4*/ <291,295,292>,<292,295,296>,<292,296,293>,<293,296,297>,<293,297,294>,
            <294,297,298>,<294,298,291>,<291,298,295>,
    /*5*/ <295,299,296>,<296,299,297>,<297,299,298>,<298,299,295>

    /* stem 0c0.10*/ 
    /*0*/ <300,301,302>,<300,302,303>,<300,303,304>,<300,304,301>,
    /*1*/ <301,305,302>,<302,305,306>,<302,306,303>,<303,306,307>,<303,307,304>,
            <304,307,308>,<304,308,301>,<301,308,305>,
    /*2*/ <305,309,306>,<306,309,310>,<306,310,307>,<307,310,311>,<307,311,308>,
            <308,311,312>,<308,312,305>,<305,312,309>,
    /*3*/ <309,313,310>,<310,313,314>,<310,314,311>,<311,314,315>,<311,315,312>,
            <312,315,316>,<312,316,309>,<309,316,313>,
    /*4*/ <313,317,314>,<314,317,318>,<314,318,315>,<315,318,319>,<315,319,316>,
            <316,319,320>,<316,320,313>,<313,320,317>,
    /*5*/ <317,321,318>,<318,321,319>,<319,321,320>,<320,321,317>

    /* stem 0c0.11*/ 
    /*0*/ <322,323,324>,<322,324,325>,<322,325,326>,<322,326,323>,
    /*1*/ <323,327,324>,<324,327,328>,<324,328,325>,<325,328,329>,<325,329,326>,
            <326,329,330>,<326,330,323>,<323,330,327>,
    /*2*/ <327,331,328>,<328,331,332>,<328,332,329>,<329,332,333>,<329,333,330>,
            <330,333,334>,<330,334,327>,<327,334,331>,
    /*3*/ <331,335,332>,<332,335,336>,<332,336,333>,<333,336,337>,<333,337,334>,
            <334,337,338>,<334,338,331>,<331,338,335>,
    /*4*/ <335,339,336>,<336,339,340>,<336,340,337>,<337,340,341>,<337,341,338>,
            <338,341,342>,<338,342,335>,<335,342,339>,
    /*5*/ <339,343,340>,<340,343,341>,<341,343,342>,<342,343,339>

    /* stem 0c0.12*/ 
    /*0*/ <344,345,346>,<344,346,347>,<344,347,348>,<344,348,345>,
    /*1*/ <345,349,346>,<346,349,350>,<346,350,347>,<347,350,351>,<347,351,348>,
            <348,351,352>,<348,352,345>,<345,352,349>,
    /*2*/ <349,353,350>,<350,353,354>,<350,354,351>,<351,354,355>,<351,355,352>,
            <352,355,356>,<352,356,349>,<349,356,353>,
    /*3*/ <353,357,354>,<354,357,358>,<354,358,355>,<355,358,359>,<355,359,356>,
            <356,359,360>,<356,360,353>,<353,360,357>,
    /*4*/ <357,361,358>,<358,361,362>,<358,362,359>,<359,362,363>,<359,363,360>,
            <360,363,364>,<360,364,357>,<357,364,361>,
    /*5*/ <361,365,362>,<362,365,363>,<363,365,364>,<364,365,361>

    /* stem 0c0.13*/ 
    /*0*/ <366,367,368>,<366,368,369>,<366,369,370>,<366,370,367>,
    /*1*/ <367,371,368>,<368,371,372>,<368,372,369>,<369,372,373>,<369,373,370>,
            <370,373,374>,<370,374,367>,<367,374,371>,
    /*2*/ <371,375,372>,<372,375,376>,<372,376,373>,<373,376,377>,<373,377,374>,
            <374,377,378>,<374,378,371>,<371,378,375>,
    /*3*/ <375,379,376>,<376,379,380>,<376,380,377>,<377,380,381>,<377,381,378>,
            <378,381,382>,<378,382,375>,<375,382,379>,
    /*4*/ <379,383,380>,<380,383,384>,<380,384,381>,<381,384,385>,<381,385,382>,
            <382,385,386>,<382,386,379>,<379,386,383>,
    /*5*/ <383,387,384>,<384,387,385>,<385,387,386>,<386,387,383>

    /* stem 0c0.14*/ 
    /*0*/ <388,389,390>,<388,390,391>,<388,391,392>,<388,392,389>,
    /*1*/ <389,393,390>,<390,393,394>,<390,394,391>,<391,394,395>,<391,395,392>,
            <392,395,396>,<392,396,389>,<389,396,393>,
    /*2*/ <393,397,394>,<394,397,398>,<394,398,395>,<395,398,399>,<395,399,396>,
            <396,399,400>,<396,400,393>,<393,400,397>,
    /*3*/ <397,401,398>,<398,401,402>,<398,402,399>,<399,402,403>,<399,403,400>,
            <400,403,404>,<400,404,397>,<397,404,401>,
    /*4*/ <401,405,402>,<402,405,406>,<402,406,403>,<403,406,407>,<403,407,404>,
            <404,407,408>,<404,408,401>,<401,408,405>,
    /*5*/ <405,409,406>,<406,409,407>,<407,409,408>,<408,409,405>

    /* stem 0c0.15*/ 
    /*0*/ <410,411,412>,<410,412,413>,<410,413,414>,<410,414,411>,
    /*1*/ <411,415,412>,<412,415,416>,<412,416,413>,<413,416,417>,<413,417,414>,
            <414,417,418>,<414,418,411>,<411,418,415>,
    /*2*/ <415,419,416>,<416,419,420>,<416,420,417>,<417,420,421>,<417,421,418>,
            <418,421,422>,<418,422,415>,<415,422,419>,
    /*3*/ <419,423,420>,<420,423,424>,<420,424,421>,<421,424,425>,<421,425,422>,
            <422,425,426>,<422,426,419>,<419,426,423>,
    /*4*/ <423,427,424>,<424,427,428>,<424,428,425>,<425,428,429>,<425,429,426>,
            <426,429,430>,<426,430,423>,<423,430,427>,
    /*5*/ <427,431,428>,<428,431,429>,<429,431,430>,<430,431,427>

    /* stem 0c0.16*/ 
    /*0*/ <432,433,434>,<432,434,435>,<432,435,436>,<432,436,433>,
    /*1*/ <433,437,434>,<434,437,438>,<434,438,435>,<435,438,439>,<435,439,436>,
            <436,439,440>,<436,440,433>,<433,440,437>,
    /*2*/ <437,441,438>,<438,441,442>,<438,442,439>,<439,442,443>,<439,443,440>,
            <440,443,444>,<440,444,437>,<437,444,441>,
    /*3*/ <441,445,442>,<442,445,446>,<442,446,443>,<443,446,447>,<443,447,444>,
            <444,447,448>,<444,448,441>,<441,448,445>,
    /*4*/ <445,449,446>,<446,449,450>,<446,450,447>,<447,450,451>,<447,451,448>,
            <448,451,452>,<448,452,445>,<445,452,449>,
    /*5*/ <449,453,450>,<450,453,451>,<451,453,452>,<452,453,449>

    /* stem 0c1*/ 
    /*0*/ <454,455,456>,<454,456,457>,<454,457,458>,<454,458,455>,
    /*1*/ <455,459,456>,<456,459,460>,<456,460,457>,<457,460,461>,<457,461,458>,
            <458,461,462>,<458,462,455>,<455,462,459>,
    /*2*/ <459,463,460>,<460,463,464>,<460,464,461>,<461,464,465>,<461,465,462>,
            <462,465,466>,<462,466,459>,<459,466,463>,
    /*3*/ <463,467,464>,<464,467,468>,<464,468,465>,<465,468,469>,<465,469,466>,
            <466,469,470>,<466,470,463>,<463,470,467>,
    /*4*/ <467,471,468>,<468,471,472>,<468,472,469>,<469,472,473>,<469,473,470>,
            <470,473,474>,<470,474,467>,<467,474,471>,
    /*5*/ <471,475,472>,<472,475,476>,<472,476,473>,<473,476,477>,<473,477,474>,
            <474,477,478>,<474,478,471>,<471,478,475>,
    /*6*/ <475,479,476>,<476,479,480>,<476,480,477>,<477,480,481>,<477,481,478>,
            <478,481,482>,<478,482,475>,<475,482,479>,
    /*7*/ <479,483,480>,<480,483,484>,<480,484,481>,<481,484,485>,<481,485,482>,
            <482,485,486>,<482,486,479>,<479,486,483>,
    /*8*/ <483,487,484>,<484,487,488>,<484,488,485>,<485,488,489>,<485,489,486>,
            <486,489,490>,<486,490,483>,<483,490,487>,
    /*9*/ <487,491,488>,<488,491,489>,<489,491,490>,<490,491,487>

    /* stem 0c1.0*/ 
    /*0*/ <492,493,494>,<492,494,495>,<492,495,496>,<492,496,493>,
    /*1*/ <493,497,494>,<494,497,498>,<494,498,495>,<495,498,499>,<495,499,496>,
            <496,499,500>,<496,500,493>,<493,500,497>,
    /*2*/ <497,501,498>,<498,501,502>,<498,502,499>,<499,502,503>,<499,503,500>,
            <500,503,504>,<500,504,497>,<497,504,501>,
    /*3*/ <501,505,502>,<502,505,506>,<502,506,503>,<503,506,507>,<503,507,504>,
            <504,507,508>,<504,508,501>,<501,508,505>,
    /*4*/ <505,509,506>,<506,509,510>,<506,510,507>,<507,510,511>,<507,511,508>,
            <508,511,512>,<508,512,505>,<505,512,509>,
    /*5*/ <509,513,510>,<510,513,511>,<511,513,512>,<512,513,509>

    /* stem 0c1.1*/ 
    /*0*/ <514,515,516>,<514,516,517>,<514,517,518>,<514,518,515>,
    /*1*/ <515,519,516>,<516,519,520>,<516,520,517>,<517,520,521>,<517,521,518>,
            <518,521,522>,<518,522,515>,<515,522,519>,
    /*2*/ <519,523,520>,<520,523,524>,<520,524,521>,<521,524,525>,<521,525,522>,
            <522,525,526>,<522,526,519>,<519,526,523>,
    /*3*/ <523,527,524>,<524,527,528>,<524,528,525>,<525,528,529>,<525,529,526>,
            <526,529,530>,<526,530,523>,<523,530,527>,
    /*4*/ <527,531,528>,<528,531,532>,<528,532,529>,<529,532,533>,<529,533,530>,
            <530,533,534>,<530,534,527>,<527,534,531>,
    /*5*/ <531,535,532>,<532,535,533>,<533,535,534>,<534,535,531>

    /* stem 0c1.2*/ 
    /*0*/ <536,537,538>,<536,538,539>,<536,539,540>,<536,540,537>,
    /*1*/ <537,541,538>,<538,541,542>,<538,542,539>,<539,542,543>,<539,543,540>,
            <540,543,544>,<540,544,537>,<537,544,541>,
    /*2*/ <541,545,542>,<542,545,546>,<542,546,543>,<543,546,547>,<543,547,544>,
            <544,547,548>,<544,548,541>,<541,548,545>,
    /*3*/ <545,549,546>,<546,549,550>,<546,550,547>,<547,550,551>,<547,551,548>,
            <548,551,552>,<548,552,545>,<545,552,549>,
    /*4*/ <549,553,550>,<550,553,554>,<550,554,551>,<551,554,555>,<551,555,552>,
            <552,555,556>,<552,556,549>,<549,556,553>,
    /*5*/ <553,557,554>,<554,557,555>,<555,557,556>,<556,557,553>

    /* stem 0c1.3*/ 
    /*0*/ <558,559,560>,<558,560,561>,<558,561,562>,<558,562,559>,
    /*1*/ <559,563,560>,<560,563,564>,<560,564,561>,<561,564,565>,<561,565,562>,
            <562,565,566>,<562,566,559>,<559,566,563>,
    /*2*/ <563,567,564>,<564,567,568>,<564,568,565>,<565,568,569>,<565,569,566>,
            <566,569,570>,<566,570,563>,<563,570,567>,
    /*3*/ <567,571,568>,<568,571,572>,<568,572,569>,<569,572,573>,<569,573,570>,
            <570,573,574>,<570,574,567>,<567,574,571>,
    /*4*/ <571,575,572>,<572,575,576>,<572,576,573>,<573,576,577>,<573,577,574>,
            <574,577,578>,<574,578,571>,<571,578,575>,
    /*5*/ <575,579,576>,<576,579,577>,<577,579,578>,<578,579,575>

    /* stem 0c1.4*/ 
    /*0*/ <580,581,582>,<580,582,583>,<580,583,584>,<580,584,581>,
    /*1*/ <581,585,582>,<582,585,586>,<582,586,583>,<583,586,587>,<583,587,584>,
            <584,587,588>,<584,588,581>,<581,588,585>,
    /*2*/ <585,589,586>,<586,589,590>,<586,590,587>,<587,590,591>,<587,591,588>,
            <588,591,592>,<588,592,585>,<585,592,589>,
    /*3*/ <589,593,590>,<590,593,594>,<590,594,591>,<591,594,595>,<591,595,592>,
            <592,595,596>,<592,596,589>,<589,596,593>,
    /*4*/ <593,597,594>,<594,597,598>,<594,598,595>,<595,598,599>,<595,599,596>,
            <596,599,600>,<596,600,593>,<593,600,597>,
    /*5*/ <597,601,598>,<598,601,599>,<599,601,600>,<600,601,597>

    /* stem 0c1.5*/ 
    /*0*/ <602,603,604>,<602,604,605>,<602,605,606>,<602,606,603>,
    /*1*/ <603,607,604>,<604,607,608>,<604,608,605>,<605,608,609>,<605,609,606>,
            <606,609,610>,<606,610,603>,<603,610,607>,
    /*2*/ <607,611,608>,<608,611,612>,<608,612,609>,<609,612,613>,<609,613,610>,
            <610,613,614>,<610,614,607>,<607,614,611>,
    /*3*/ <611,615,612>,<612,615,616>,<612,616,613>,<613,616,617>,<613,617,614>,
            <614,617,618>,<614,618,611>,<611,618,615>,
    /*4*/ <615,619,616>,<616,619,620>,<616,620,617>,<617,620,621>,<617,621,618>,
            <618,621,622>,<618,622,615>,<615,622,619>,
    /*5*/ <619,623,620>,<620,623,621>,<621,623,622>,<622,623,619>

    /* stem 0c1.6*/ 
    /*0*/ <624,625,626>,<624,626,627>,<624,627,628>,<624,628,625>,
    /*1*/ <625,629,626>,<626,629,630>,<626,630,627>,<627,630,631>,<627,631,628>,
            <628,631,632>,<628,632,625>,<625,632,629>,
    /*2*/ <629,633,630>,<630,633,634>,<630,634,631>,<631,634,635>,<631,635,632>,
            <632,635,636>,<632,636,629>,<629,636,633>,
    /*3*/ <633,637,634>,<634,637,638>,<634,638,635>,<635,638,639>,<635,639,636>,
            <636,639,640>,<636,640,633>,<633,640,637>,
    /*4*/ <637,641,638>,<638,641,642>,<638,642,639>,<639,642,643>,<639,643,640>,
            <640,643,644>,<640,644,637>,<637,644,641>,
    /*5*/ <641,645,642>,<642,645,643>,<643,645,644>,<644,645,641>

    /* stem 0c1.7*/ 
    /*0*/ <646,647,648>,<646,648,649>,<646,649,650>,<646,650,647>,
    /*1*/ <647,651,648>,<648,651,652>,<648,652,649>,<649,652,653>,<649,653,650>,
            <650,653,654>,<650,654,647>,<647,654,651>,
    /*2*/ <651,655,652>,<652,655,656>,<652,656,653>,<653,656,657>,<653,657,654>,
            <654,657,658>,<654,658,651>,<651,658,655>,
    /*3*/ <655,659,656>,<656,659,660>,<656,660,657>,<657,660,661>,<657,661,658>,
            <658,661,662>,<658,662,655>,<655,662,659>,
    /*4*/ <659,663,660>,<660,663,664>,<660,664,661>,<661,664,665>,<661,665,662>,
            <662,665,666>,<662,666,659>,<659,666,663>,
    /*5*/ <663,667,664>,<664,667,665>,<665,667,666>,<666,667,663>

    /* stem 0c1.8*/ 
    /*0*/ <668,669,670>,<668,670,671>,<668,671,672>,<668,672,669>,
    /*1*/ <669,673,670>,<670,673,674>,<670,674,671>,<671,674,675>,<671,675,672>,
            <672,675,676>,<672,676,669>,<669,676,673>,
    /*2*/ <673,677,674>,<674,677,678>,<674,678,675>,<675,678,679>,<675,679,676>,
            <676,679,680>,<676,680,673>,<673,680,677>,
    /*3*/ <677,681,678>,<678,681,682>,<678,682,679>,<679,682,683>,<679,683,680>,
            <680,683,684>,<680,684,677>,<677,684,681>,
    /*4*/ <681,685,682>,<682,685,686>,<682,686,683>,<683,686,687>,<683,687,684>,
            <684,687,688>,<684,688,681>,<681,688,685>,
    /*5*/ <685,689,686>,<686,689,687>,<687,689,688>,<688,689,685>

    /* stem 0c1.9*/ 
    /*0*/ <690,691,692>,<690,692,693>,<690,693,694>,<690,694,691>,
    /*1*/ <691,695,692>,<692,695,696>,<692,696,693>,<693,696,697>,<693,697,694>,
            <694,697,698>,<694,698,691>,<691,698,695>,
    /*2*/ <695,699,696>,<696,699,700>,<696,700,697>,<697,700,701>,<697,701,698>,
            <698,701,702>,<698,702,695>,<695,702,699>,
    /*3*/ <699,703,700>,<700,703,704>,<700,704,701>,<701,704,705>,<701,705,702>,
            <702,705,706>,<702,706,699>,<699,706,703>,
    /*4*/ <703,707,704>,<704,707,708>,<704,708,705>,<705,708,709>,<705,709,706>,
            <706,709,710>,<706,710,703>,<703,710,707>,
    /*5*/ <707,711,708>,<708,711,709>,<709,711,710>,<710,711,707>

    /* stem 0c1.10*/ 
    /*0*/ <712,713,714>,<712,714,715>,<712,715,716>,<712,716,713>,
    /*1*/ <713,717,714>,<714,717,718>,<714,718,715>,<715,718,719>,<715,719,716>,
            <716,719,720>,<716,720,713>,<713,720,717>,
    /*2*/ <717,721,718>,<718,721,722>,<718,722,719>,<719,722,723>,<719,723,720>,
            <720,723,724>,<720,724,717>,<717,724,721>,
    /*3*/ <721,725,722>,<722,725,726>,<722,726,723>,<723,726,727>,<723,727,724>,
            <724,727,728>,<724,728,721>,<721,728,725>,
    /*4*/ <725,729,726>,<726,729,730>,<726,730,727>,<727,730,731>,<727,731,728>,
            <728,731,732>,<728,732,725>,<725,732,729>,
    /*5*/ <729,733,730>,<730,733,731>,<731,733,732>,<732,733,729>

    /* stem 0c1.11*/ 
    /*0*/ <734,735,736>,<734,736,737>,<734,737,738>,<734,738,735>,
    /*1*/ <735,739,736>,<736,739,740>,<736,740,737>,<737,740,741>,<737,741,738>,
            <738,741,742>,<738,742,735>,<735,742,739>,
    /*2*/ <739,743,740>,<740,743,744>,<740,744,741>,<741,744,745>,<741,745,742>,
            <742,745,746>,<742,746,739>,<739,746,743>,
    /*3*/ <743,747,744>,<744,747,748>,<744,748,745>,<745,748,749>,<745,749,746>,
            <746,749,750>,<746,750,743>,<743,750,747>,
    /*4*/ <747,751,748>,<748,751,752>,<748,752,749>,<749,752,753>,<749,753,750>,
            <750,753,754>,<750,754,747>,<747,754,751>,
    /*5*/ <751,755,752>,<752,755,753>,<753,755,754>,<754,755,751>

    /* stem 0c1.12*/ 
    /*0*/ <756,757,758>,<756,758,759>,<756,759,760>,<756,760,757>,
    /*1*/ <757,761,758>,<758,761,762>,<758,762,759>,<759,762,763>,<759,763,760>,
            <760,763,764>,<760,764,757>,<757,764,761>,
    /*2*/ <761,765,762>,<762,765,766>,<762,766,763>,<763,766,767>,<763,767,764>,
            <764,767,768>,<764,768,761>,<761,768,765>,
    /*3*/ <765,769,766>,<766,769,770>,<766,770,767>,<767,770,771>,<767,771,768>,
            <768,771,772>,<768,772,765>,<765,772,769>,
    /*4*/ <769,773,770>,<770,773,774>,<770,774,771>,<771,774,775>,<771,775,772>,
            <772,775,776>,<772,776,769>,<769,776,773>,
    /*5*/ <773,777,774>,<774,777,775>,<775,777,776>,<776,777,773>

    /* stem 0c1.13*/ 
    /*0*/ <778,779,780>,<778,780,781>,<778,781,782>,<778,782,779>,
    /*1*/ <779,783,780>,<780,783,784>,<780,784,781>,<781,784,785>,<781,785,782>,
            <782,785,786>,<782,786,779>,<779,786,783>,
    /*2*/ <783,787,784>,<784,787,788>,<784,788,785>,<785,788,789>,<785,789,786>,
            <786,789,790>,<786,790,783>,<783,790,787>,
    /*3*/ <787,791,788>,<788,791,792>,<788,792,789>,<789,792,793>,<789,793,790>,
            <790,793,794>,<790,794,787>,<787,794,791>,
    /*4*/ <791,795,792>,<792,795,796>,<792,796,793>,<793,796,797>,<793,797,794>,
            <794,797,798>,<794,798,791>,<791,798,795>,
    /*5*/ <795,799,796>,<796,799,797>,<797,799,798>,<798,799,795>

    /* stem 0c1.14*/ 
    /*0*/ <800,801,802>,<800,802,803>,<800,803,804>,<800,804,801>,
    /*1*/ <801,805,802>,<802,805,806>,<802,806,803>,<803,806,807>,<803,807,804>,
            <804,807,808>,<804,808,801>,<801,808,805>,
    /*2*/ <805,809,806>,<806,809,810>,<806,810,807>,<807,810,811>,<807,811,808>,
            <808,811,812>,<808,812,805>,<805,812,809>,
    /*3*/ <809,813,810>,<810,813,814>,<810,814,811>,<811,814,815>,<811,815,812>,
            <812,815,816>,<812,816,809>,<809,816,813>,
    /*4*/ <813,817,814>,<814,817,818>,<814,818,815>,<815,818,819>,<815,819,816>,
            <816,819,820>,<816,820,813>,<813,820,817>,
    /*5*/ <817,821,818>,<818,821,819>,<819,821,820>,<820,821,817>

    /* stem 0c1.15*/ 
    /*0*/ <822,823,824>,<822,824,825>,<822,825,826>,<822,826,823>,
    /*1*/ <823,827,824>,<824,827,828>,<824,828,825>,<825,828,829>,<825,829,826>,
            <826,829,830>,<826,830,823>,<823,830,827>,
    /*2*/ <827,831,828>,<828,831,832>,<828,832,829>,<829,832,833>,<829,833,830>,
            <830,833,834>,<830,834,827>,<827,834,831>,
    /*3*/ <831,835,832>,<832,835,836>,<832,836,833>,<833,836,837>,<833,837,834>,
            <834,837,838>,<834,838,831>,<831,838,835>,
    /*4*/ <835,839,836>,<836,839,840>,<836,840,837>,<837,840,841>,<837,841,838>,
            <838,841,842>,<838,842,835>,<835,842,839>,
    /*5*/ <839,843,840>,<840,843,841>,<841,843,842>,<842,843,839>

    /* stem 0c2*/ 
    /*0*/ <844,845,846>,<844,846,847>,<844,847,848>,<844,848,845>,
    /*1*/ <845,849,846>,<846,849,850>,<846,850,847>,<847,850,851>,<847,851,848>,
            <848,851,852>,<848,852,845>,<845,852,849>,
    /*2*/ <849,853,850>,<850,853,854>,<850,854,851>,<851,854,855>,<851,855,852>,
            <852,855,856>,<852,856,849>,<849,856,853>,
    /*3*/ <853,857,854>,<854,857,858>,<854,858,855>,<855,858,859>,<855,859,856>,
            <856,859,860>,<856,860,853>,<853,860,857>,
    /*4*/ <857,861,858>,<858,861,862>,<858,862,859>,<859,862,863>,<859,863,860>,
            <860,863,864>,<860,864,857>,<857,864,861>,
    /*5*/ <861,865,862>,<862,865,866>,<862,866,863>,<863,866,867>,<863,867,864>,
            <864,867,868>,<864,868,861>,<861,868,865>,
    /*6*/ <865,869,866>,<866,869,870>,<866,870,867>,<867,870,871>,<867,871,868>,
            <868,871,872>,<868,872,865>,<865,872,869>,
    /*7*/ <869,873,870>,<870,873,874>,<870,874,871>,<871,874,875>,<871,875,872>,
            <872,875,876>,<872,876,869>,<869,876,873>,
    /*8*/ <873,877,874>,<874,877,878>,<874,878,875>,<875,878,879>,<875,879,876>,
            <876,879,880>,<876,880,873>,<873,880,877>,
    /*9*/ <877,881,878>,<878,881,879>,<879,881,880>,<880,881,877>

    /* stem 0c2.0*/ 
    /*0*/ <882,883,884>,<882,884,885>,<882,885,886>,<882,886,883>,
    /*1*/ <883,887,884>,<884,887,888>,<884,888,885>,<885,888,889>,<885,889,886>,
            <886,889,890>,<886,890,883>,<883,890,887>,
    /*2*/ <887,891,888>,<888,891,892>,<888,892,889>,<889,892,893>,<889,893,890>,
            <890,893,894>,<890,894,887>,<887,894,891>,
    /*3*/ <891,895,892>,<892,895,896>,<892,896,893>,<893,896,897>,<893,897,894>,
            <894,897,898>,<894,898,891>,<891,898,895>,
    /*4*/ <895,899,896>,<896,899,900>,<896,900,897>,<897,900,901>,<897,901,898>,
            <898,901,902>,<898,902,895>,<895,902,899>,
    /*5*/ <899,903,900>,<900,903,901>,<901,903,902>,<902,903,899>

    /* stem 0c2.1*/ 
    /*0*/ <904,905,906>,<904,906,907>,<904,907,908>,<904,908,905>,
    /*1*/ <905,909,906>,<906,909,910>,<906,910,907>,<907,910,911>,<907,911,908>,
            <908,911,912>,<908,912,905>,<905,912,909>,
    /*2*/ <909,913,910>,<910,913,914>,<910,914,911>,<911,914,915>,<911,915,912>,
            <912,915,916>,<912,916,909>,<909,916,913>,
    /*3*/ <913,917,914>,<914,917,918>,<914,918,915>,<915,918,919>,<915,919,916>,
            <916,919,920>,<916,920,913>,<913,920,917>,
    /*4*/ <917,921,918>,<918,921,922>,<918,922,919>,<919,922,923>,<919,923,920>,
            <920,923,924>,<920,924,917>,<917,924,921>,
    /*5*/ <921,925,922>,<922,925,923>,<923,925,924>,<924,925,921>

    /* stem 0c2.2*/ 
    /*0*/ <926,927,928>,<926,928,929>,<926,929,930>,<926,930,927>,
    /*1*/ <927,931,928>,<928,931,932>,<928,932,929>,<929,932,933>,<929,933,930>,
            <930,933,934>,<930,934,927>,<927,934,931>,
    /*2*/ <931,935,932>,<932,935,936>,<932,936,933>,<933,936,937>,<933,937,934>,
            <934,937,938>,<934,938,931>,<931,938,935>,
    /*3*/ <935,939,936>,<936,939,940>,<936,940,937>,<937,940,941>,<937,941,938>,
            <938,941,942>,<938,942,935>,<935,942,939>,
    /*4*/ <939,943,940>,<940,943,944>,<940,944,941>,<941,944,945>,<941,945,942>,
            <942,945,946>,<942,946,939>,<939,946,943>,
    /*5*/ <943,947,944>,<944,947,945>,<945,947,946>,<946,947,943>

    /* stem 0c2.3*/ 
    /*0*/ <948,949,950>,<948,950,951>,<948,951,952>,<948,952,949>,
    /*1*/ <949,953,950>,<950,953,954>,<950,954,951>,<951,954,955>,<951,955,952>,
            <952,955,956>,<952,956,949>,<949,956,953>,
    /*2*/ <953,957,954>,<954,957,958>,<954,958,955>,<955,958,959>,<955,959,956>,
            <956,959,960>,<956,960,953>,<953,960,957>,
    /*3*/ <957,961,958>,<958,961,962>,<958,962,959>,<959,962,963>,<959,963,960>,
            <960,963,964>,<960,964,957>,<957,964,961>,
    /*4*/ <961,965,962>,<962,965,966>,<962,966,963>,<963,966,967>,<963,967,964>,
            <964,967,968>,<964,968,961>,<961,968,965>,
    /*5*/ <965,969,966>,<966,969,967>,<967,969,968>,<968,969,965>

    /* stem 0c2.4*/ 
    /*0*/ <970,971,972>,<970,972,973>,<970,973,974>,<970,974,971>,
    /*1*/ <971,975,972>,<972,975,976>,<972,976,973>,<973,976,977>,<973,977,974>,
            <974,977,978>,<974,978,971>,<971,978,975>,
    /*2*/ <975,979,976>,<976,979,980>,<976,980,977>,<977,980,981>,<977,981,978>,
            <978,981,982>,<978,982,975>,<975,982,979>,
    /*3*/ <979,983,980>,<980,983,984>,<980,984,981>,<981,984,985>,<981,985,982>,
            <982,985,986>,<982,986,979>,<979,986,983>,
    /*4*/ <983,987,984>,<984,987,988>,<984,988,985>,<985,988,989>,<985,989,986>,
            <986,989,990>,<986,990,983>,<983,990,987>,
    /*5*/ <987,991,988>,<988,991,989>,<989,991,990>,<990,991,987>

    /* stem 0c2.5*/ 
    /*0*/ <992,993,994>,<992,994,995>,<992,995,996>,<992,996,993>,
    /*1*/ <993,997,994>,<994,997,998>,<994,998,995>,<995,998,999>,<995,999,996>,
            <996,999,1000>,<996,1000,993>,<993,1000,997>,
    /*2*/ <997,1001,998>,<998,1001,1002>,<998,1002,999>,<999,1002,1003>,<999,1003,1000>,
            <1000,1003,1004>,<1000,1004,997>,<997,1004,1001>,
    /*3*/ <1001,1005,1002>,<1002,1005,1006>,<1002,1006,1003>,<1003,1006,1007>,<1003,1007,1004>,
            <1004,1007,1008>,<1004,1008,1001>,<1001,1008,1005>,
    /*4*/ <1005,1009,1006>,<1006,1009,1010>,<1006,1010,1007>,<1007,1010,1011>,<1007,1011,1008>,
            <1008,1011,1012>,<1008,1012,1005>,<1005,1012,1009>,
    /*5*/ <1009,1013,1010>,<1010,1013,1011>,<1011,1013,1012>,<1012,1013,1009>

    /* stem 0c2.6*/ 
    /*0*/ <1014,1015,1016>,<1014,1016,1017>,<1014,1017,1018>,<1014,1018,1015>,
    /*1*/ <1015,1019,1016>,<1016,1019,1020>,<1016,1020,1017>,<1017,1020,1021>,<1017,1021,1018>,
            <1018,1021,1022>,<1018,1022,1015>,<1015,1022,1019>,
    /*2*/ <1019,1023,1020>,<1020,1023,1024>,<1020,1024,1021>,<1021,1024,1025>,<1021,1025,1022>,
            <1022,1025,1026>,<1022,1026,1019>,<1019,1026,1023>,
    /*3*/ <1023,1027,1024>,<1024,1027,1028>,<1024,1028,1025>,<1025,1028,1029>,<1025,1029,1026>,
            <1026,1029,1030>,<1026,1030,1023>,<1023,1030,1027>,
    /*4*/ <1027,1031,1028>,<1028,1031,1032>,<1028,1032,1029>,<1029,1032,1033>,<1029,1033,1030>,
            <1030,1033,1034>,<1030,1034,1027>,<1027,1034,1031>,
    /*5*/ <1031,1035,1032>,<1032,1035,1033>,<1033,1035,1034>,<1034,1035,1031>

    /* stem 0c2.7*/ 
    /*0*/ <1036,1037,1038>,<1036,1038,1039>,<1036,1039,1040>,<1036,1040,1037>,
    /*1*/ <1037,1041,1038>,<1038,1041,1042>,<1038,1042,1039>,<1039,1042,1043>,<1039,1043,1040>,
            <1040,1043,1044>,<1040,1044,1037>,<1037,1044,1041>,
    /*2*/ <1041,1045,1042>,<1042,1045,1046>,<1042,1046,1043>,<1043,1046,1047>,<1043,1047,1044>,
            <1044,1047,1048>,<1044,1048,1041>,<1041,1048,1045>,
    /*3*/ <1045,1049,1046>,<1046,1049,1050>,<1046,1050,1047>,<1047,1050,1051>,<1047,1051,1048>,
            <1048,1051,1052>,<1048,1052,1045>,<1045,1052,1049>,
    /*4*/ <1049,1053,1050>,<1050,1053,1054>,<1050,1054,1051>,<1051,1054,1055>,<1051,1055,1052>,
            <1052,1055,1056>,<1052,1056,1049>,<1049,1056,1053>,
    /*5*/ <1053,1057,1054>,<1054,1057,1055>,<1055,1057,1056>,<1056,1057,1053>

    /* stem 0c2.8*/ 
    /*0*/ <1058,1059,1060>,<1058,1060,1061>,<1058,1061,1062>,<1058,1062,1059>,
    /*1*/ <1059,1063,1060>,<1060,1063,1064>,<1060,1064,1061>,<1061,1064,1065>,<1061,1065,1062>,
            <1062,1065,1066>,<1062,1066,1059>,<1059,1066,1063>,
    /*2*/ <1063,1067,1064>,<1064,1067,1068>,<1064,1068,1065>,<1065,1068,1069>,<1065,1069,1066>,
            <1066,1069,1070>,<1066,1070,1063>,<1063,1070,1067>,
    /*3*/ <1067,1071,1068>,<1068,1071,1072>,<1068,1072,1069>,<1069,1072,1073>,<1069,1073,1070>,
            <1070,1073,1074>,<1070,1074,1067>,<1067,1074,1071>,
    /*4*/ <1071,1075,1072>,<1072,1075,1076>,<1072,1076,1073>,<1073,1076,1077>,<1073,1077,1074>,
            <1074,1077,1078>,<1074,1078,1071>,<1071,1078,1075>,
    /*5*/ <1075,1079,1076>,<1076,1079,1077>,<1077,1079,1078>,<1078,1079,1075>

    /* stem 0c2.9*/ 
    /*0*/ <1080,1081,1082>,<1080,1082,1083>,<1080,1083,1084>,<1080,1084,1081>,
    /*1*/ <1081,1085,1082>,<1082,1085,1086>,<1082,1086,1083>,<1083,1086,1087>,<1083,1087,1084>,
            <1084,1087,1088>,<1084,1088,1081>,<1081,1088,1085>,
    /*2*/ <1085,1089,1086>,<1086,1089,1090>,<1086,1090,1087>,<1087,1090,1091>,<1087,1091,1088>,
            <1088,1091,1092>,<1088,1092,1085>,<1085,1092,1089>,
    /*3*/ <1089,1093,1090>,<1090,1093,1094>,<1090,1094,1091>,<1091,1094,1095>,<1091,1095,1092>,
            <1092,1095,1096>,<1092,1096,1089>,<1089,1096,1093>,
    /*4*/ <1093,1097,1094>,<1094,1097,1098>,<1094,1098,1095>,<1095,1098,1099>,<1095,1099,1096>,
            <1096,1099,1100>,<1096,1100,1093>,<1093,1100,1097>,
    /*5*/ <1097,1101,1098>,<1098,1101,1099>,<1099,1101,1100>,<1100,1101,1097>

    /* stem 0c2.10*/ 
    /*0*/ <1102,1103,1104>,<1102,1104,1105>,<1102,1105,1106>,<1102,1106,1103>,
    /*1*/ <1103,1107,1104>,<1104,1107,1108>,<1104,1108,1105>,<1105,1108,1109>,<1105,1109,1106>,
            <1106,1109,1110>,<1106,1110,1103>,<1103,1110,1107>,
    /*2*/ <1107,1111,1108>,<1108,1111,1112>,<1108,1112,1109>,<1109,1112,1113>,<1109,1113,1110>,
            <1110,1113,1114>,<1110,1114,1107>,<1107,1114,1111>,
    /*3*/ <1111,1115,1112>,<1112,1115,1116>,<1112,1116,1113>,<1113,1116,1117>,<1113,1117,1114>,
            <1114,1117,1118>,<1114,1118,1111>,<1111,1118,1115>,
    /*4*/ <1115,1119,1116>,<1116,1119,1120>,<1116,1120,1117>,<1117,1120,1121>,<1117,1121,1118>,
            <1118,1121,1122>,<1118,1122,1115>,<1115,1122,1119>,
    /*5*/ <1119,1123,1120>,<1120,1123,1121>,<1121,1123,1122>,<1122,1123,1119>

    /* stem 0c2.11*/ 
    /*0*/ <1124,1125,1126>,<1124,1126,1127>,<1124,1127,1128>,<1124,1128,1125>,
    /*1*/ <1125,1129,1126>,<1126,1129,1130>,<1126,1130,1127>,<1127,1130,1131>,<1127,1131,1128>,
            <1128,1131,1132>,<1128,1132,1125>,<1125,1132,1129>,
    /*2*/ <1129,1133,1130>,<1130,1133,1134>,<1130,1134,1131>,<1131,1134,1135>,<1131,1135,1132>,
            <1132,1135,1136>,<1132,1136,1129>,<1129,1136,1133>,
    /*3*/ <1133,1137,1134>,<1134,1137,1138>,<1134,1138,1135>,<1135,1138,1139>,<1135,1139,1136>,
            <1136,1139,1140>,<1136,1140,1133>,<1133,1140,1137>,
    /*4*/ <1137,1141,1138>,<1138,1141,1142>,<1138,1142,1139>,<1139,1142,1143>,<1139,1143,1140>,
            <1140,1143,1144>,<1140,1144,1137>,<1137,1144,1141>,
    /*5*/ <1141,1145,1142>,<1142,1145,1143>,<1143,1145,1144>,<1144,1145,1141>

    /* stem 0c2.12*/ 
    /*0*/ <1146,1147,1148>,<1146,1148,1149>,<1146,1149,1150>,<1146,1150,1147>,
    /*1*/ <1147,1151,1148>,<1148,1151,1152>,<1148,1152,1149>,<1149,1152,1153>,<1149,1153,1150>,
            <1150,1153,1154>,<1150,1154,1147>,<1147,1154,1151>,
    /*2*/ <1151,1155,1152>,<1152,1155,1156>,<1152,1156,1153>,<1153,1156,1157>,<1153,1157,1154>,
            <1154,1157,1158>,<1154,1158,1151>,<1151,1158,1155>,
    /*3*/ <1155,1159,1156>,<1156,1159,1160>,<1156,1160,1157>,<1157,1160,1161>,<1157,1161,1158>,
            <1158,1161,1162>,<1158,1162,1155>,<1155,1162,1159>,
    /*4*/ <1159,1163,1160>,<1160,1163,1164>,<1160,1164,1161>,<1161,1164,1165>,<1161,1165,1162>,
            <1162,1165,1166>,<1162,1166,1159>,<1159,1166,1163>,
    /*5*/ <1163,1167,1164>,<1164,1167,1165>,<1165,1167,1166>,<1166,1167,1163>

    /* stem 0c2.13*/ 
    /*0*/ <1168,1169,1170>,<1168,1170,1171>,<1168,1171,1172>,<1168,1172,1169>,
    /*1*/ <1169,1173,1170>,<1170,1173,1174>,<1170,1174,1171>,<1171,1174,1175>,<1171,1175,1172>,
            <1172,1175,1176>,<1172,1176,1169>,<1169,1176,1173>,
    /*2*/ <1173,1177,1174>,<1174,1177,1178>,<1174,1178,1175>,<1175,1178,1179>,<1175,1179,1176>,
            <1176,1179,1180>,<1176,1180,1173>,<1173,1180,1177>,
    /*3*/ <1177,1181,1178>,<1178,1181,1182>,<1178,1182,1179>,<1179,1182,1183>,<1179,1183,1180>,
            <1180,1183,1184>,<1180,1184,1177>,<1177,1184,1181>,
    /*4*/ <1181,1185,1182>,<1182,1185,1186>,<1182,1186,1183>,<1183,1186,1187>,<1183,1187,1184>,
            <1184,1187,1188>,<1184,1188,1181>,<1181,1188,1185>,
    /*5*/ <1185,1189,1186>,<1186,1189,1187>,<1187,1189,1188>,<1188,1189,1185>

    /* stem 0c2.14*/ 
    /*0*/ <1190,1191,1192>,<1190,1192,1193>,<1190,1193,1194>,<1190,1194,1191>,
    /*1*/ <1191,1195,1192>,<1192,1195,1196>,<1192,1196,1193>,<1193,1196,1197>,<1193,1197,1194>,
            <1194,1197,1198>,<1194,1198,1191>,<1191,1198,1195>,
    /*2*/ <1195,1199,1196>,<1196,1199,1200>,<1196,1200,1197>,<1197,1200,1201>,<1197,1201,1198>,
            <1198,1201,1202>,<1198,1202,1195>,<1195,1202,1199>,
    /*3*/ <1199,1203,1200>,<1200,1203,1204>,<1200,1204,1201>,<1201,1204,1205>,<1201,1205,1202>,
            <1202,1205,1206>,<1202,1206,1199>,<1199,1206,1203>,
    /*4*/ <1203,1207,1204>,<1204,1207,1208>,<1204,1208,1205>,<1205,1208,1209>,<1205,1209,1206>,
            <1206,1209,1210>,<1206,1210,1203>,<1203,1210,1207>,
    /*5*/ <1207,1211,1208>,<1208,1211,1209>,<1209,1211,1210>,<1210,1211,1207>

    /* stem 0c2.15*/ 
    /*0*/ <1212,1213,1214>,<1212,1214,1215>,<1212,1215,1216>,<1212,1216,1213>,
    /*1*/ <1213,1217,1214>,<1214,1217,1218>,<1214,1218,1215>,<1215,1218,1219>,<1215,1219,1216>,
            <1216,1219,1220>,<1216,1220,1213>,<1213,1220,1217>,
    /*2*/ <1217,1221,1218>,<1218,1221,1222>,<1218,1222,1219>,<1219,1222,1223>,<1219,1223,1220>,
            <1220,1223,1224>,<1220,1224,1217>,<1217,1224,1221>,
    /*3*/ <1221,1225,1222>,<1222,1225,1226>,<1222,1226,1223>,<1223,1226,1227>,<1223,1227,1224>,
            <1224,1227,1228>,<1224,1228,1221>,<1221,1228,1225>,
    /*4*/ <1225,1229,1226>,<1226,1229,1230>,<1226,1230,1227>,<1227,1230,1231>,<1227,1231,1228>,
            <1228,1231,1232>,<1228,1232,1225>,<1225,1232,1229>,
    /*5*/ <1229,1233,1230>,<1230,1233,1231>,<1231,1233,1232>,<1232,1233,1229>

    /* stem 0c2.16*/ 
    /*0*/ <1234,1235,1236>,<1234,1236,1237>,<1234,1237,1238>,<1234,1238,1235>,
    /*1*/ <1235,1239,1236>,<1236,1239,1240>,<1236,1240,1237>,<1237,1240,1241>,<1237,1241,1238>,
            <1238,1241,1242>,<1238,1242,1235>,<1235,1242,1239>,
    /*2*/ <1239,1243,1240>,<1240,1243,1244>,<1240,1244,1241>,<1241,1244,1245>,<1241,1245,1242>,
            <1242,1245,1246>,<1242,1246,1239>,<1239,1246,1243>,
    /*3*/ <1243,1247,1244>,<1244,1247,1248>,<1244,1248,1245>,<1245,1248,1249>,<1245,1249,1246>,
            <1246,1249,1250>,<1246,1250,1243>,<1243,1250,1247>,
    /*4*/ <1247,1251,1248>,<1248,1251,1252>,<1248,1252,1249>,<1249,1252,1253>,<1249,1253,1250>,
            <1250,1253,1254>,<1250,1254,1247>,<1247,1254,1251>,
    /*5*/ <1251,1255,1252>,<1252,1255,1253>,<1253,1255,1254>,<1254,1255,1251>

    /* stem 0c3*/ 
    /*0*/ <1256,1257,1258>,<1256,1258,1259>,<1256,1259,1260>,<1256,1260,1257>,
    /*1*/ <1257,1261,1258>,<1258,1261,1262>,<1258,1262,1259>,<1259,1262,1263>,<1259,1263,1260>,
            <1260,1263,1264>,<1260,1264,1257>,<1257,1264,1261>,
    /*2*/ <1261,1265,1262>,<1262,1265,1266>,<1262,1266,1263>,<1263,1266,1267>,<1263,1267,1264>,
            <1264,1267,1268>,<1264,1268,1261>,<1261,1268,1265>,
    /*3*/ <1265,1269,1266>,<1266,1269,1270>,<1266,1270,1267>,<1267,1270,1271>,<1267,1271,1268>,
            <1268,1271,1272>,<1268,1272,1265>,<1265,1272,1269>,
    /*4*/ <1269,1273,1270>,<1270,1273,1274>,<1270,1274,1271>,<1271,1274,1275>,<1271,1275,1272>,
            <1272,1275,1276>,<1272,1276,1269>,<1269,1276,1273>,
    /*5*/ <1273,1277,1274>,<1274,1277,1278>,<1274,1278,1275>,<1275,1278,1279>,<1275,1279,1276>,
            <1276,1279,1280>,<1276,1280,1273>,<1273,1280,1277>,
    /*6*/ <1277,1281,1278>,<1278,1281,1282>,<1278,1282,1279>,<1279,1282,1283>,<1279,1283,1280>,
            <1280,1283,1284>,<1280,1284,1277>,<1277,1284,1281>,
    /*7*/ <1281,1285,1282>,<1282,1285,1286>,<1282,1286,1283>,<1283,1286,1287>,<1283,1287,1284>,
            <1284,1287,1288>,<1284,1288,1281>,<1281,1288,1285>,
    /*8*/ <1285,1289,1286>,<1286,1289,1290>,<1286,1290,1287>,<1287,1290,1291>,<1287,1291,1288>,
            <1288,1291,1292>,<1288,1292,1285>,<1285,1292,1289>,
    /*9*/ <1289,1293,1290>,<1290,1293,1291>,<1291,1293,1292>,<1292,1293,1289>

    /* stem 0c3.0*/ 
    /*0*/ <1294,1295,1296>,<1294,1296,1297>,<1294,1297,1298>,<1294,1298,1295>,
    /*1*/ <1295,1299,1296>,<1296,1299,1300>,<1296,1300,1297>,<1297,1300,1301>,<1297,1301,1298>,
            <1298,1301,1302>,<1298,1302,1295>,<1295,1302,1299>,
    /*2*/ <1299,1303,1300>,<1300,1303,1304>,<1300,1304,1301>,<1301,1304,1305>,<1301,1305,1302>,
            <1302,1305,1306>,<1302,1306,1299>,<1299,1306,1303>,
    /*3*/ <1303,1307,1304>,<1304,1307,1308>,<1304,1308,1305>,<1305,1308,1309>,<1305,1309,1306>,
            <1306,1309,1310>,<1306,1310,1303>,<1303,1310,1307>,
    /*4*/ <1307,1311,1308>,<1308,1311,1312>,<1308,1312,1309>,<1309,1312,1313>,<1309,1313,1310>,
            <1310,1313,1314>,<1310,1314,1307>,<1307,1314,1311>,
    /*5*/ <1311,1315,1312>,<1312,1315,1313>,<1313,1315,1314>,<1314,1315,1311>

    /* stem 0c3.1*/ 
    /*0*/ <1316,1317,1318>,<1316,1318,1319>,<1316,1319,1320>,<1316,1320,1317>,
    /*1*/ <1317,1321,1318>,<1318,1321,1322>,<1318,1322,1319>,<1319,1322,1323>,<1319,1323,1320>,
            <1320,1323,1324>,<1320,1324,1317>,<1317,1324,1321>,
    /*2*/ <1321,1325,1322>,<1322,1325,1326>,<1322,1326,1323>,<1323,1326,1327>,<1323,1327,1324>,
            <1324,1327,1328>,<1324,1328,1321>,<1321,1328,1325>,
    /*3*/ <1325,1329,1326>,<1326,1329,1330>,<1326,1330,1327>,<1327,1330,1331>,<1327,1331,1328>,
            <1328,1331,1332>,<1328,1332,1325>,<1325,1332,1329>,
    /*4*/ <1329,1333,1330>,<1330,1333,1334>,<1330,1334,1331>,<1331,1334,1335>,<1331,1335,1332>,
            <1332,1335,1336>,<1332,1336,1329>,<1329,1336,1333>,
    /*5*/ <1333,1337,1334>,<1334,1337,1335>,<1335,1337,1336>,<1336,1337,1333>

    /* stem 0c3.2*/ 
    /*0*/ <1338,1339,1340>,<1338,1340,1341>,<1338,1341,1342>,<1338,1342,1339>,
    /*1*/ <1339,1343,1340>,<1340,1343,1344>,<1340,1344,1341>,<1341,1344,1345>,<1341,1345,1342>,
            <1342,1345,1346>,<1342,1346,1339>,<1339,1346,1343>,
    /*2*/ <1343,1347,1344>,<1344,1347,1348>,<1344,1348,1345>,<1345,1348,1349>,<1345,1349,1346>,
            <1346,1349,1350>,<1346,1350,1343>,<1343,1350,1347>,
    /*3*/ <1347,1351,1348>,<1348,1351,1352>,<1348,1352,1349>,<1349,1352,1353>,<1349,1353,1350>,
            <1350,1353,1354>,<1350,1354,1347>,<1347,1354,1351>,
    /*4*/ <1351,1355,1352>,<1352,1355,1356>,<1352,1356,1353>,<1353,1356,1357>,<1353,1357,1354>,
            <1354,1357,1358>,<1354,1358,1351>,<1351,1358,1355>,
    /*5*/ <1355,1359,1356>,<1356,1359,1357>,<1357,1359,1358>,<1358,1359,1355>

    /* stem 0c3.3*/ 
    /*0*/ <1360,1361,1362>,<1360,1362,1363>,<1360,1363,1364>,<1360,1364,1361>,
    /*1*/ <1361,1365,1362>,<1362,1365,1366>,<1362,1366,1363>,<1363,1366,1367>,<1363,1367,1364>,
            <1364,1367,1368>,<1364,1368,1361>,<1361,1368,1365>,
    /*2*/ <1365,1369,1366>,<1366,1369,1370>,<1366,1370,1367>,<1367,1370,1371>,<1367,1371,1368>,
            <1368,1371,1372>,<1368,1372,1365>,<1365,1372,1369>,
    /*3*/ <1369,1373,1370>,<1370,1373,1374>,<1370,1374,1371>,<1371,1374,1375>,<1371,1375,1372>,
            <1372,1375,1376>,<1372,1376,1369>,<1369,1376,1373>,
    /*4*/ <1373,1377,1374>,<1374,1377,1378>,<1374,1378,1375>,<1375,1378,1379>,<1375,1379,1376>,
            <1376,1379,1380>,<1376,1380,1373>,<1373,1380,1377>,
    /*5*/ <1377,1381,1378>,<1378,1381,1379>,<1379,1381,1380>,<1380,1381,1377>

    /* stem 0c3.4*/ 
    /*0*/ <1382,1383,1384>,<1382,1384,1385>,<1382,1385,1386>,<1382,1386,1383>,
    /*1*/ <1383,1387,1384>,<1384,1387,1388>,<1384,1388,1385>,<1385,1388,1389>,<1385,1389,1386>,
            <1386,1389,1390>,<1386,1390,1383>,<1383,1390,1387>,
    /*2*/ <1387,1391,1388>,<1388,1391,1392>,<1388,1392,1389>,<1389,1392,1393>,<1389,1393,1390>,
            <1390,1393,1394>,<1390,1394,1387>,<1387,1394,1391>,
    /*3*/ <1391,1395,1392>,<1392,1395,1396>,<1392,1396,1393>,<1393,1396,1397>,<1393,1397,1394>,
            <1394,1397,1398>,<1394,1398,1391>,<1391,1398,1395>,
    /*4*/ <1395,1399,1396>,<1396,1399,1400>,<1396,1400,1397>,<1397,1400,1401>,<1397,1401,1398>,
            <1398,1401,1402>,<1398,1402,1395>,<1395,1402,1399>,
    /*5*/ <1399,1403,1400>,<1400,1403,1401>,<1401,1403,1402>,<1402,1403,1399>

    /* stem 0c3.5*/ 
    /*0*/ <1404,1405,1406>,<1404,1406,1407>,<1404,1407,1408>,<1404,1408,1405>,
    /*1*/ <1405,1409,1406>,<1406,1409,1410>,<1406,1410,1407>,<1407,1410,1411>,<1407,1411,1408>,
            <1408,1411,1412>,<1408,1412,1405>,<1405,1412,1409>,
    /*2*/ <1409,1413,1410>,<1410,1413,1414>,<1410,1414,1411>,<1411,1414,1415>,<1411,1415,1412>,
            <1412,1415,1416>,<1412,1416,1409>,<1409,1416,1413>,
    /*3*/ <1413,1417,1414>,<1414,1417,1418>,<1414,1418,1415>,<1415,1418,1419>,<1415,1419,1416>,
            <1416,1419,1420>,<1416,1420,1413>,<1413,1420,1417>,
    /*4*/ <1417,1421,1418>,<1418,1421,1422>,<1418,1422,1419>,<1419,1422,1423>,<1419,1423,1420>,
            <1420,1423,1424>,<1420,1424,1417>,<1417,1424,1421>,
    /*5*/ <1421,1425,1422>,<1422,1425,1423>,<1423,1425,1424>,<1424,1425,1421>

    /* stem 0c3.6*/ 
    /*0*/ <1426,1427,1428>,<1426,1428,1429>,<1426,1429,1430>,<1426,1430,1427>,
    /*1*/ <1427,1431,1428>,<1428,1431,1432>,<1428,1432,1429>,<1429,1432,1433>,<1429,1433,1430>,
            <1430,1433,1434>,<1430,1434,1427>,<1427,1434,1431>,
    /*2*/ <1431,1435,1432>,<1432,1435,1436>,<1432,1436,1433>,<1433,1436,1437>,<1433,1437,1434>,
            <1434,1437,1438>,<1434,1438,1431>,<1431,1438,1435>,
    /*3*/ <1435,1439,1436>,<1436,1439,1440>,<1436,1440,1437>,<1437,1440,1441>,<1437,1441,1438>,
            <1438,1441,1442>,<1438,1442,1435>,<1435,1442,1439>,
    /*4*/ <1439,1443,1440>,<1440,1443,1444>,<1440,1444,1441>,<1441,1444,1445>,<1441,1445,1442>,
            <1442,1445,1446>,<1442,1446,1439>,<1439,1446,1443>,
    /*5*/ <1443,1447,1444>,<1444,1447,1445>,<1445,1447,1446>,<1446,1447,1443>

    /* stem 0c3.7*/ 
    /*0*/ <1448,1449,1450>,<1448,1450,1451>,<1448,1451,1452>,<1448,1452,1449>,
    /*1*/ <1449,1453,1450>,<1450,1453,1454>,<1450,1454,1451>,<1451,1454,1455>,<1451,1455,1452>,
            <1452,1455,1456>,<1452,1456,1449>,<1449,1456,1453>,
    /*2*/ <1453,1457,1454>,<1454,1457,1458>,<1454,1458,1455>,<1455,1458,1459>,<1455,1459,1456>,
            <1456,1459,1460>,<1456,1460,1453>,<1453,1460,1457>,
    /*3*/ <1457,1461,1458>,<1458,1461,1462>,<1458,1462,1459>,<1459,1462,1463>,<1459,1463,1460>,
            <1460,1463,1464>,<1460,1464,1457>,<1457,1464,1461>,
    /*4*/ <1461,1465,1462>,<1462,1465,1466>,<1462,1466,1463>,<1463,1466,1467>,<1463,1467,1464>,
            <1464,1467,1468>,<1464,1468,1461>,<1461,1468,1465>,
    /*5*/ <1465,1469,1466>,<1466,1469,1467>,<1467,1469,1468>,<1468,1469,1465>

    /* stem 0c3.8*/ 
    /*0*/ <1470,1471,1472>,<1470,1472,1473>,<1470,1473,1474>,<1470,1474,1471>,
    /*1*/ <1471,1475,1472>,<1472,1475,1476>,<1472,1476,1473>,<1473,1476,1477>,<1473,1477,1474>,
            <1474,1477,1478>,<1474,1478,1471>,<1471,1478,1475>,
    /*2*/ <1475,1479,1476>,<1476,1479,1480>,<1476,1480,1477>,<1477,1480,1481>,<1477,1481,1478>,
            <1478,1481,1482>,<1478,1482,1475>,<1475,1482,1479>,
    /*3*/ <1479,1483,1480>,<1480,1483,1484>,<1480,1484,1481>,<1481,1484,1485>,<1481,1485,1482>,
            <1482,1485,1486>,<1482,1486,1479>,<1479,1486,1483>,
    /*4*/ <1483,1487,1484>,<1484,1487,1488>,<1484,1488,1485>,<1485,1488,1489>,<1485,1489,1486>,
            <1486,1489,1490>,<1486,1490,1483>,<1483,1490,1487>,
    /*5*/ <1487,1491,1488>,<1488,1491,1489>,<1489,1491,1490>,<1490,1491,1487>

    /* stem 0c3.9*/ 
    /*0*/ <1492,1493,1494>,<1492,1494,1495>,<1492,1495,1496>,<1492,1496,1493>,
    /*1*/ <1493,1497,1494>,<1494,1497,1498>,<1494,1498,1495>,<1495,1498,1499>,<1495,1499,1496>,
            <1496,1499,1500>,<1496,1500,1493>,<1493,1500,1497>,
    /*2*/ <1497,1501,1498>,<1498,1501,1502>,<1498,1502,1499>,<1499,1502,1503>,<1499,1503,1500>,
            <1500,1503,1504>,<1500,1504,1497>,<1497,1504,1501>,
    /*3*/ <1501,1505,1502>,<1502,1505,1506>,<1502,1506,1503>,<1503,1506,1507>,<1503,1507,1504>,
            <1504,1507,1508>,<1504,1508,1501>,<1501,1508,1505>,
    /*4*/ <1505,1509,1506>,<1506,1509,1510>,<1506,1510,1507>,<1507,1510,1511>,<1507,1511,1508>,
            <1508,1511,1512>,<1508,1512,1505>,<1505,1512,1509>,
    /*5*/ <1509,1513,1510>,<1510,1513,1511>,<1511,1513,1512>,<1512,1513,1509>

    /* stem 0c3.10*/ 
    /*0*/ <1514,1515,1516>,<1514,1516,1517>,<1514,1517,1518>,<1514,1518,1515>,
    /*1*/ <1515,1519,1516>,<1516,1519,1520>,<1516,1520,1517>,<1517,1520,1521>,<1517,1521,1518>,
            <1518,1521,1522>,<1518,1522,1515>,<1515,1522,1519>,
    /*2*/ <1519,1523,1520>,<1520,1523,1524>,<1520,1524,1521>,<1521,1524,1525>,<1521,1525,1522>,
            <1522,1525,1526>,<1522,1526,1519>,<1519,1526,1523>,
    /*3*/ <1523,1527,1524>,<1524,1527,1528>,<1524,1528,1525>,<1525,1528,1529>,<1525,1529,1526>,
            <1526,1529,1530>,<1526,1530,1523>,<1523,1530,1527>,
    /*4*/ <1527,1531,1528>,<1528,1531,1532>,<1528,1532,1529>,<1529,1532,1533>,<1529,1533,1530>,
            <1530,1533,1534>,<1530,1534,1527>,<1527,1534,1531>,
    /*5*/ <1531,1535,1532>,<1532,1535,1533>,<1533,1535,1534>,<1534,1535,1531>

    /* stem 0c3.11*/ 
    /*0*/ <1536,1537,1538>,<1536,1538,1539>,<1536,1539,1540>,<1536,1540,1537>,
    /*1*/ <1537,1541,1538>,<1538,1541,1542>,<1538,1542,1539>,<1539,1542,1543>,<1539,1543,1540>,
            <1540,1543,1544>,<1540,1544,1537>,<1537,1544,1541>,
    /*2*/ <1541,1545,1542>,<1542,1545,1546>,<1542,1546,1543>,<1543,1546,1547>,<1543,1547,1544>,
            <1544,1547,1548>,<1544,1548,1541>,<1541,1548,1545>,
    /*3*/ <1545,1549,1546>,<1546,1549,1550>,<1546,1550,1547>,<1547,1550,1551>,<1547,1551,1548>,
            <1548,1551,1552>,<1548,1552,1545>,<1545,1552,1549>,
    /*4*/ <1549,1553,1550>,<1550,1553,1554>,<1550,1554,1551>,<1551,1554,1555>,<1551,1555,1552>,
            <1552,1555,1556>,<1552,1556,1549>,<1549,1556,1553>,
    /*5*/ <1553,1557,1554>,<1554,1557,1555>,<1555,1557,1556>,<1556,1557,1553>

    /* stem 0c3.12*/ 
    /*0*/ <1558,1559,1560>,<1558,1560,1561>,<1558,1561,1562>,<1558,1562,1559>,
    /*1*/ <1559,1563,1560>,<1560,1563,1564>,<1560,1564,1561>,<1561,1564,1565>,<1561,1565,1562>,
            <1562,1565,1566>,<1562,1566,1559>,<1559,1566,1563>,
    /*2*/ <1563,1567,1564>,<1564,1567,1568>,<1564,1568,1565>,<1565,1568,1569>,<1565,1569,1566>,
            <1566,1569,1570>,<1566,1570,1563>,<1563,1570,1567>,
    /*3*/ <1567,1571,1568>,<1568,1571,1572>,<1568,1572,1569>,<1569,1572,1573>,<1569,1573,1570>,
            <1570,1573,1574>,<1570,1574,1567>,<1567,1574,1571>,
    /*4*/ <1571,1575,1572>,<1572,1575,1576>,<1572,1576,1573>,<1573,1576,1577>,<1573,1577,1574>,
            <1574,1577,1578>,<1574,1578,1571>,<1571,1578,1575>,
    /*5*/ <1575,1579,1576>,<1576,1579,1577>,<1577,1579,1578>,<1578,1579,1575>

    /* stem 0c3.13*/ 
    /*0*/ <1580,1581,1582>,<1580,1582,1583>,<1580,1583,1584>,<1580,1584,1581>,
    /*1*/ <1581,1585,1582>,<1582,1585,1586>,<1582,1586,1583>,<1583,1586,1587>,<1583,1587,1584>,
            <1584,1587,1588>,<1584,1588,1581>,<1581,1588,1585>,
    /*2*/ <1585,1589,1586>,<1586,1589,1590>,<1586,1590,1587>,<1587,1590,1591>,<1587,1591,1588>,
            <1588,1591,1592>,<1588,1592,1585>,<1585,1592,1589>,
    /*3*/ <1589,1593,1590>,<1590,1593,1594>,<1590,1594,1591>,<1591,1594,1595>,<1591,1595,1592>,
            <1592,1595,1596>,<1592,1596,1589>,<1589,1596,1593>,
    /*4*/ <1593,1597,1594>,<1594,1597,1598>,<1594,1598,1595>,<1595,1598,1599>,<1595,1599,1596>,
            <1596,1599,1600>,<1596,1600,1593>,<1593,1600,1597>,
    /*5*/ <1597,1601,1598>,<1598,1601,1599>,<1599,1601,1600>,<1600,1601,1597>

    /* stem 0c3.14*/ 
    /*0*/ <1602,1603,1604>,<1602,1604,1605>,<1602,1605,1606>,<1602,1606,1603>,
    /*1*/ <1603,1607,1604>,<1604,1607,1608>,<1604,1608,1605>,<1605,1608,1609>,<1605,1609,1606>,
            <1606,1609,1610>,<1606,1610,1603>,<1603,1610,1607>,
    /*2*/ <1607,1611,1608>,<1608,1611,1612>,<1608,1612,1609>,<1609,1612,1613>,<1609,1613,1610>,
            <1610,1613,1614>,<1610,1614,1607>,<1607,1614,1611>,
    /*3*/ <1611,1615,1612>,<1612,1615,1616>,<1612,1616,1613>,<1613,1616,1617>,<1613,1617,1614>,
            <1614,1617,1618>,<1614,1618,1611>,<1611,1618,1615>,
    /*4*/ <1615,1619,1616>,<1616,1619,1620>,<1616,1620,1617>,<1617,1620,1621>,<1617,1621,1618>,
            <1618,1621,1622>,<1618,1622,1615>,<1615,1622,1619>,
    /*5*/ <1619,1623,1620>,<1620,1623,1621>,<1621,1623,1622>,<1622,1623,1619>

    /* stem 0c3.15*/ 
    /*0*/ <1624,1625,1626>,<1624,1626,1627>,<1624,1627,1628>,<1624,1628,1625>,
    /*1*/ <1625,1629,1626>,<1626,1629,1630>,<1626,1630,1627>,<1627,1630,1631>,<1627,1631,1628>,
            <1628,1631,1632>,<1628,1632,1625>,<1625,1632,1629>,
    /*2*/ <1629,1633,1630>,<1630,1633,1634>,<1630,1634,1631>,<1631,1634,1635>,<1631,1635,1632>,
            <1632,1635,1636>,<1632,1636,1629>,<1629,1636,1633>,
    /*3*/ <1633,1637,1634>,<1634,1637,1638>,<1634,1638,1635>,<1635,1638,1639>,<1635,1639,1636>,
            <1636,1639,1640>,<1636,1640,1633>,<1633,1640,1637>,
    /*4*/ <1637,1641,1638>,<1638,1641,1642>,<1638,1642,1639>,<1639,1642,1643>,<1639,1643,1640>,
            <1640,1643,1644>,<1640,1644,1637>,<1637,1644,1641>,
    /*5*/ <1641,1645,1642>,<1642,1645,1643>,<1643,1645,1644>,<1644,1645,1641>

    /* stem 0c3.16*/ 
    /*0*/ <1646,1647,1648>,<1646,1648,1649>,<1646,1649,1650>,<1646,1650,1647>,
    /*1*/ <1647,1651,1648>,<1648,1651,1652>,<1648,1652,1649>,<1649,1652,1653>,<1649,1653,1650>,
            <1650,1653,1654>,<1650,1654,1647>,<1647,1654,1651>,
    /*2*/ <1651,1655,1652>,<1652,1655,1656>,<1652,1656,1653>,<1653,1656,1657>,<1653,1657,1654>,
            <1654,1657,1658>,<1654,1658,1651>,<1651,1658,1655>,
    /*3*/ <1655,1659,1656>,<1656,1659,1660>,<1656,1660,1657>,<1657,1660,1661>,<1657,1661,1658>,
            <1658,1661,1662>,<1658,1662,1655>,<1655,1662,1659>,
    /*4*/ <1659,1663,1660>,<1660,1663,1664>,<1660,1664,1661>,<1661,1664,1665>,<1661,1665,1662>,
            <1662,1665,1666>,<1662,1666,1659>,<1659,1666,1663>,
    /*5*/ <1663,1667,1664>,<1664,1667,1665>,<1665,1667,1666>,<1666,1667,1663>

    /* stem 0c4*/ 
    /*0*/ <1668,1669,1670>,<1668,1670,1671>,<1668,1671,1672>,<1668,1672,1669>,
    /*1*/ <1669,1673,1670>,<1670,1673,1674>,<1670,1674,1671>,<1671,1674,1675>,<1671,1675,1672>,
            <1672,1675,1676>,<1672,1676,1669>,<1669,1676,1673>,
    /*2*/ <1673,1677,1674>,<1674,1677,1678>,<1674,1678,1675>,<1675,1678,1679>,<1675,1679,1676>,
            <1676,1679,1680>,<1676,1680,1673>,<1673,1680,1677>,
    /*3*/ <1677,1681,1678>,<1678,1681,1682>,<1678,1682,1679>,<1679,1682,1683>,<1679,1683,1680>,
            <1680,1683,1684>,<1680,1684,1677>,<1677,1684,1681>,
    /*4*/ <1681,1685,1682>,<1682,1685,1686>,<1682,1686,1683>,<1683,1686,1687>,<1683,1687,1684>,
            <1684,1687,1688>,<1684,1688,1681>,<1681,1688,1685>,
    /*5*/ <1685,1689,1686>,<1686,1689,1690>,<1686,1690,1687>,<1687,1690,1691>,<1687,1691,1688>,
            <1688,1691,1692>,<1688,1692,1685>,<1685,1692,1689>,
    /*6*/ <1689,1693,1690>,<1690,1693,1694>,<1690,1694,1691>,<1691,1694,1695>,<1691,1695,1692>,
            <1692,1695,1696>,<1692,1696,1689>,<1689,1696,1693>,
    /*7*/ <1693,1697,1694>,<1694,1697,1698>,<1694,1698,1695>,<1695,1698,1699>,<1695,1699,1696>,
            <1696,1699,1700>,<1696,1700,1693>,<1693,1700,1697>,
    /*8*/ <1697,1701,1698>,<1698,1701,1702>,<1698,1702,1699>,<1699,1702,1703>,<1699,1703,1700>,
            <1700,1703,1704>,<1700,1704,1697>,<1697,1704,1701>,
    /*9*/ <1701,1705,1702>,<1702,1705,1703>,<1703,1705,1704>,<1704,1705,1701>

    /* stem 0c4.0*/ 
    /*0*/ <1706,1707,1708>,<1706,1708,1709>,<1706,1709,1710>,<1706,1710,1707>,
    /*1*/ <1707,1711,1708>,<1708,1711,1712>,<1708,1712,1709>,<1709,1712,1713>,<1709,1713,1710>,
            <1710,1713,1714>,<1710,1714,1707>,<1707,1714,1711>,
    /*2*/ <1711,1715,1712>,<1712,1715,1716>,<1712,1716,1713>,<1713,1716,1717>,<1713,1717,1714>,
            <1714,1717,1718>,<1714,1718,1711>,<1711,1718,1715>,
    /*3*/ <1715,1719,1716>,<1716,1719,1720>,<1716,1720,1717>,<1717,1720,1721>,<1717,1721,1718>,
            <1718,1721,1722>,<1718,1722,1715>,<1715,1722,1719>,
    /*4*/ <1719,1723,1720>,<1720,1723,1724>,<1720,1724,1721>,<1721,1724,1725>,<1721,1725,1722>,
            <1722,1725,1726>,<1722,1726,1719>,<1719,1726,1723>,
    /*5*/ <1723,1727,1724>,<1724,1727,1725>,<1725,1727,1726>,<1726,1727,1723>

    /* stem 0c4.1*/ 
    /*0*/ <1728,1729,1730>,<1728,1730,1731>,<1728,1731,1732>,<1728,1732,1729>,
    /*1*/ <1729,1733,1730>,<1730,1733,1734>,<1730,1734,1731>,<1731,1734,1735>,<1731,1735,1732>,
            <1732,1735,1736>,<1732,1736,1729>,<1729,1736,1733>,
    /*2*/ <1733,1737,1734>,<1734,1737,1738>,<1734,1738,1735>,<1735,1738,1739>,<1735,1739,1736>,
            <1736,1739,1740>,<1736,1740,1733>,<1733,1740,1737>,
    /*3*/ <1737,1741,1738>,<1738,1741,1742>,<1738,1742,1739>,<1739,1742,1743>,<1739,1743,1740>,
            <1740,1743,1744>,<1740,1744,1737>,<1737,1744,1741>,
    /*4*/ <1741,1745,1742>,<1742,1745,1746>,<1742,1746,1743>,<1743,1746,1747>,<1743,1747,1744>,
            <1744,1747,1748>,<1744,1748,1741>,<1741,1748,1745>,
    /*5*/ <1745,1749,1746>,<1746,1749,1747>,<1747,1749,1748>,<1748,1749,1745>

    /* stem 0c4.2*/ 
    /*0*/ <1750,1751,1752>,<1750,1752,1753>,<1750,1753,1754>,<1750,1754,1751>,
    /*1*/ <1751,1755,1752>,<1752,1755,1756>,<1752,1756,1753>,<1753,1756,1757>,<1753,1757,1754>,
            <1754,1757,1758>,<1754,1758,1751>,<1751,1758,1755>,
    /*2*/ <1755,1759,1756>,<1756,1759,1760>,<1756,1760,1757>,<1757,1760,1761>,<1757,1761,1758>,
            <1758,1761,1762>,<1758,1762,1755>,<1755,1762,1759>,
    /*3*/ <1759,1763,1760>,<1760,1763,1764>,<1760,1764,1761>,<1761,1764,1765>,<1761,1765,1762>,
            <1762,1765,1766>,<1762,1766,1759>,<1759,1766,1763>,
    /*4*/ <1763,1767,1764>,<1764,1767,1768>,<1764,1768,1765>,<1765,1768,1769>,<1765,1769,1766>,
            <1766,1769,1770>,<1766,1770,1763>,<1763,1770,1767>,
    /*5*/ <1767,1771,1768>,<1768,1771,1769>,<1769,1771,1770>,<1770,1771,1767>

    /* stem 0c4.3*/ 
    /*0*/ <1772,1773,1774>,<1772,1774,1775>,<1772,1775,1776>,<1772,1776,1773>,
    /*1*/ <1773,1777,1774>,<1774,1777,1778>,<1774,1778,1775>,<1775,1778,1779>,<1775,1779,1776>,
            <1776,1779,1780>,<1776,1780,1773>,<1773,1780,1777>,
    /*2*/ <1777,1781,1778>,<1778,1781,1782>,<1778,1782,1779>,<1779,1782,1783>,<1779,1783,1780>,
            <1780,1783,1784>,<1780,1784,1777>,<1777,1784,1781>,
    /*3*/ <1781,1785,1782>,<1782,1785,1786>,<1782,1786,1783>,<1783,1786,1787>,<1783,1787,1784>,
            <1784,1787,1788>,<1784,1788,1781>,<1781,1788,1785>,
    /*4*/ <1785,1789,1786>,<1786,1789,1790>,<1786,1790,1787>,<1787,1790,1791>,<1787,1791,1788>,
            <1788,1791,1792>,<1788,1792,1785>,<1785,1792,1789>,
    /*5*/ <1789,1793,1790>,<1790,1793,1791>,<1791,1793,1792>,<1792,1793,1789>

    /* stem 0c4.4*/ 
    /*0*/ <1794,1795,1796>,<1794,1796,1797>,<1794,1797,1798>,<1794,1798,1795>,
    /*1*/ <1795,1799,1796>,<1796,1799,1800>,<1796,1800,1797>,<1797,1800,1801>,<1797,1801,1798>,
            <1798,1801,1802>,<1798,1802,1795>,<1795,1802,1799>,
    /*2*/ <1799,1803,1800>,<1800,1803,1804>,<1800,1804,1801>,<1801,1804,1805>,<1801,1805,1802>,
            <1802,1805,1806>,<1802,1806,1799>,<1799,1806,1803>,
    /*3*/ <1803,1807,1804>,<1804,1807,1808>,<1804,1808,1805>,<1805,1808,1809>,<1805,1809,1806>,
            <1806,1809,1810>,<1806,1810,1803>,<1803,1810,1807>,
    /*4*/ <1807,1811,1808>,<1808,1811,1812>,<1808,1812,1809>,<1809,1812,1813>,<1809,1813,1810>,
            <1810,1813,1814>,<1810,1814,1807>,<1807,1814,1811>,
    /*5*/ <1811,1815,1812>,<1812,1815,1813>,<1813,1815,1814>,<1814,1815,1811>

    /* stem 0c4.5*/ 
    /*0*/ <1816,1817,1818>,<1816,1818,1819>,<1816,1819,1820>,<1816,1820,1817>,
    /*1*/ <1817,1821,1818>,<1818,1821,1822>,<1818,1822,1819>,<1819,1822,1823>,<1819,1823,1820>,
            <1820,1823,1824>,<1820,1824,1817>,<1817,1824,1821>,
    /*2*/ <1821,1825,1822>,<1822,1825,1826>,<1822,1826,1823>,<1823,1826,1827>,<1823,1827,1824>,
            <1824,1827,1828>,<1824,1828,1821>,<1821,1828,1825>,
    /*3*/ <1825,1829,1826>,<1826,1829,1830>,<1826,1830,1827>,<1827,1830,1831>,<1827,1831,1828>,
            <1828,1831,1832>,<1828,1832,1825>,<1825,1832,1829>,
    /*4*/ <1829,1833,1830>,<1830,1833,1834>,<1830,1834,1831>,<1831,1834,1835>,<1831,1835,1832>,
            <1832,1835,1836>,<1832,1836,1829>,<1829,1836,1833>,
    /*5*/ <1833,1837,1834>,<1834,1837,1835>,<1835,1837,1836>,<1836,1837,1833>

    /* stem 0c4.6*/ 
    /*0*/ <1838,1839,1840>,<1838,1840,1841>,<1838,1841,1842>,<1838,1842,1839>,
    /*1*/ <1839,1843,1840>,<1840,1843,1844>,<1840,1844,1841>,<1841,1844,1845>,<1841,1845,1842>,
            <1842,1845,1846>,<1842,1846,1839>,<1839,1846,1843>,
    /*2*/ <1843,1847,1844>,<1844,1847,1848>,<1844,1848,1845>,<1845,1848,1849>,<1845,1849,1846>,
            <1846,1849,1850>,<1846,1850,1843>,<1843,1850,1847>,
    /*3*/ <1847,1851,1848>,<1848,1851,1852>,<1848,1852,1849>,<1849,1852,1853>,<1849,1853,1850>,
            <1850,1853,1854>,<1850,1854,1847>,<1847,1854,1851>,
    /*4*/ <1851,1855,1852>,<1852,1855,1856>,<1852,1856,1853>,<1853,1856,1857>,<1853,1857,1854>,
            <1854,1857,1858>,<1854,1858,1851>,<1851,1858,1855>,
    /*5*/ <1855,1859,1856>,<1856,1859,1857>,<1857,1859,1858>,<1858,1859,1855>

    /* stem 0c4.7*/ 
    /*0*/ <1860,1861,1862>,<1860,1862,1863>,<1860,1863,1864>,<1860,1864,1861>,
    /*1*/ <1861,1865,1862>,<1862,1865,1866>,<1862,1866,1863>,<1863,1866,1867>,<1863,1867,1864>,
            <1864,1867,1868>,<1864,1868,1861>,<1861,1868,1865>,
    /*2*/ <1865,1869,1866>,<1866,1869,1870>,<1866,1870,1867>,<1867,1870,1871>,<1867,1871,1868>,
            <1868,1871,1872>,<1868,1872,1865>,<1865,1872,1869>,
    /*3*/ <1869,1873,1870>,<1870,1873,1874>,<1870,1874,1871>,<1871,1874,1875>,<1871,1875,1872>,
            <1872,1875,1876>,<1872,1876,1869>,<1869,1876,1873>,
    /*4*/ <1873,1877,1874>,<1874,1877,1878>,<1874,1878,1875>,<1875,1878,1879>,<1875,1879,1876>,
            <1876,1879,1880>,<1876,1880,1873>,<1873,1880,1877>,
    /*5*/ <1877,1881,1878>,<1878,1881,1879>,<1879,1881,1880>,<1880,1881,1877>

    /* stem 0c4.8*/ 
    /*0*/ <1882,1883,1884>,<1882,1884,1885>,<1882,1885,1886>,<1882,1886,1883>,
    /*1*/ <1883,1887,1884>,<1884,1887,1888>,<1884,1888,1885>,<1885,1888,1889>,<1885,1889,1886>,
            <1886,1889,1890>,<1886,1890,1883>,<1883,1890,1887>,
    /*2*/ <1887,1891,1888>,<1888,1891,1892>,<1888,1892,1889>,<1889,1892,1893>,<1889,1893,1890>,
            <1890,1893,1894>,<1890,1894,1887>,<1887,1894,1891>,
    /*3*/ <1891,1895,1892>,<1892,1895,1896>,<1892,1896,1893>,<1893,1896,1897>,<1893,1897,1894>,
            <1894,1897,1898>,<1894,1898,1891>,<1891,1898,1895>,
    /*4*/ <1895,1899,1896>,<1896,1899,1900>,<1896,1900,1897>,<1897,1900,1901>,<1897,1901,1898>,
            <1898,1901,1902>,<1898,1902,1895>,<1895,1902,1899>,
    /*5*/ <1899,1903,1900>,<1900,1903,1901>,<1901,1903,1902>,<1902,1903,1899>

    /* stem 0c4.9*/ 
    /*0*/ <1904,1905,1906>,<1904,1906,1907>,<1904,1907,1908>,<1904,1908,1905>,
    /*1*/ <1905,1909,1906>,<1906,1909,1910>,<1906,1910,1907>,<1907,1910,1911>,<1907,1911,1908>,
            <1908,1911,1912>,<1908,1912,1905>,<1905,1912,1909>,
    /*2*/ <1909,1913,1910>,<1910,1913,1914>,<1910,1914,1911>,<1911,1914,1915>,<1911,1915,1912>,
            <1912,1915,1916>,<1912,1916,1909>,<1909,1916,1913>,
    /*3*/ <1913,1917,1914>,<1914,1917,1918>,<1914,1918,1915>,<1915,1918,1919>,<1915,1919,1916>,
            <1916,1919,1920>,<1916,1920,1913>,<1913,1920,1917>,
    /*4*/ <1917,1921,1918>,<1918,1921,1922>,<1918,1922,1919>,<1919,1922,1923>,<1919,1923,1920>,
            <1920,1923,1924>,<1920,1924,1917>,<1917,1924,1921>,
    /*5*/ <1921,1925,1922>,<1922,1925,1923>,<1923,1925,1924>,<1924,1925,1921>

    /* stem 0c4.10*/ 
    /*0*/ <1926,1927,1928>,<1926,1928,1929>,<1926,1929,1930>,<1926,1930,1927>,
    /*1*/ <1927,1931,1928>,<1928,1931,1932>,<1928,1932,1929>,<1929,1932,1933>,<1929,1933,1930>,
            <1930,1933,1934>,<1930,1934,1927>,<1927,1934,1931>,
    /*2*/ <1931,1935,1932>,<1932,1935,1936>,<1932,1936,1933>,<1933,1936,1937>,<1933,1937,1934>,
            <1934,1937,1938>,<1934,1938,1931>,<1931,1938,1935>,
    /*3*/ <1935,1939,1936>,<1936,1939,1940>,<1936,1940,1937>,<1937,1940,1941>,<1937,1941,1938>,
            <1938,1941,1942>,<1938,1942,1935>,<1935,1942,1939>,
    /*4*/ <1939,1943,1940>,<1940,1943,1944>,<1940,1944,1941>,<1941,1944,1945>,<1941,1945,1942>,
            <1942,1945,1946>,<1942,1946,1939>,<1939,1946,1943>,
    /*5*/ <1943,1947,1944>,<1944,1947,1945>,<1945,1947,1946>,<1946,1947,1943>

    /* stem 0c4.11*/ 
    /*0*/ <1948,1949,1950>,<1948,1950,1951>,<1948,1951,1952>,<1948,1952,1949>,
    /*1*/ <1949,1953,1950>,<1950,1953,1954>,<1950,1954,1951>,<1951,1954,1955>,<1951,1955,1952>,
            <1952,1955,1956>,<1952,1956,1949>,<1949,1956,1953>,
    /*2*/ <1953,1957,1954>,<1954,1957,1958>,<1954,1958,1955>,<1955,1958,1959>,<1955,1959,1956>,
            <1956,1959,1960>,<1956,1960,1953>,<1953,1960,1957>,
    /*3*/ <1957,1961,1958>,<1958,1961,1962>,<1958,1962,1959>,<1959,1962,1963>,<1959,1963,1960>,
            <1960,1963,1964>,<1960,1964,1957>,<1957,1964,1961>,
    /*4*/ <1961,1965,1962>,<1962,1965,1966>,<1962,1966,1963>,<1963,1966,1967>,<1963,1967,1964>,
            <1964,1967,1968>,<1964,1968,1961>,<1961,1968,1965>,
    /*5*/ <1965,1969,1966>,<1966,1969,1967>,<1967,1969,1968>,<1968,1969,1965>

    /* stem 0c4.12*/ 
    /*0*/ <1970,1971,1972>,<1970,1972,1973>,<1970,1973,1974>,<1970,1974,1971>,
    /*1*/ <1971,1975,1972>,<1972,1975,1976>,<1972,1976,1973>,<1973,1976,1977>,<1973,1977,1974>,
            <1974,1977,1978>,<1974,1978,1971>,<1971,1978,1975>,
    /*2*/ <1975,1979,1976>,<1976,1979,1980>,<1976,1980,1977>,<1977,1980,1981>,<1977,1981,1978>,
            <1978,1981,1982>,<1978,1982,1975>,<1975,1982,1979>,
    /*3*/ <1979,1983,1980>,<1980,1983,1984>,<1980,1984,1981>,<1981,1984,1985>,<1981,1985,1982>,
            <1982,1985,1986>,<1982,1986,1979>,<1979,1986,1983>,
    /*4*/ <1983,1987,1984>,<1984,1987,1988>,<1984,1988,1985>,<1985,1988,1989>,<1985,1989,1986>,
            <1986,1989,1990>,<1986,1990,1983>,<1983,1990,1987>,
    /*5*/ <1987,1991,1988>,<1988,1991,1989>,<1989,1991,1990>,<1990,1991,1987>

    /* stem 0c4.13*/ 
    /*0*/ <1992,1993,1994>,<1992,1994,1995>,<1992,1995,1996>,<1992,1996,1993>,
    /*1*/ <1993,1997,1994>,<1994,1997,1998>,<1994,1998,1995>,<1995,1998,1999>,<1995,1999,1996>,
            <1996,1999,2000>,<1996,2000,1993>,<1993,2000,1997>,
    /*2*/ <1997,2001,1998>,<1998,2001,2002>,<1998,2002,1999>,<1999,2002,2003>,<1999,2003,2000>,
            <2000,2003,2004>,<2000,2004,1997>,<1997,2004,2001>,
    /*3*/ <2001,2005,2002>,<2002,2005,2006>,<2002,2006,2003>,<2003,2006,2007>,<2003,2007,2004>,
            <2004,2007,2008>,<2004,2008,2001>,<2001,2008,2005>,
    /*4*/ <2005,2009,2006>,<2006,2009,2010>,<2006,2010,2007>,<2007,2010,2011>,<2007,2011,2008>,
            <2008,2011,2012>,<2008,2012,2005>,<2005,2012,2009>,
    /*5*/ <2009,2013,2010>,<2010,2013,2011>,<2011,2013,2012>,<2012,2013,2009>

    /* stem 0c4.14*/ 
    /*0*/ <2014,2015,2016>,<2014,2016,2017>,<2014,2017,2018>,<2014,2018,2015>,
    /*1*/ <2015,2019,2016>,<2016,2019,2020>,<2016,2020,2017>,<2017,2020,2021>,<2017,2021,2018>,
            <2018,2021,2022>,<2018,2022,2015>,<2015,2022,2019>,
    /*2*/ <2019,2023,2020>,<2020,2023,2024>,<2020,2024,2021>,<2021,2024,2025>,<2021,2025,2022>,
            <2022,2025,2026>,<2022,2026,2019>,<2019,2026,2023>,
    /*3*/ <2023,2027,2024>,<2024,2027,2028>,<2024,2028,2025>,<2025,2028,2029>,<2025,2029,2026>,
            <2026,2029,2030>,<2026,2030,2023>,<2023,2030,2027>,
    /*4*/ <2027,2031,2028>,<2028,2031,2032>,<2028,2032,2029>,<2029,2032,2033>,<2029,2033,2030>,
            <2030,2033,2034>,<2030,2034,2027>,<2027,2034,2031>,
    /*5*/ <2031,2035,2032>,<2032,2035,2033>,<2033,2035,2034>,<2034,2035,2031>

    /* stem 0c4.15*/ 
    /*0*/ <2036,2037,2038>,<2036,2038,2039>,<2036,2039,2040>,<2036,2040,2037>,
    /*1*/ <2037,2041,2038>,<2038,2041,2042>,<2038,2042,2039>,<2039,2042,2043>,<2039,2043,2040>,
            <2040,2043,2044>,<2040,2044,2037>,<2037,2044,2041>,
    /*2*/ <2041,2045,2042>,<2042,2045,2046>,<2042,2046,2043>,<2043,2046,2047>,<2043,2047,2044>,
            <2044,2047,2048>,<2044,2048,2041>,<2041,2048,2045>,
    /*3*/ <2045,2049,2046>,<2046,2049,2050>,<2046,2050,2047>,<2047,2050,2051>,<2047,2051,2048>,
            <2048,2051,2052>,<2048,2052,2045>,<2045,2052,2049>,
    /*4*/ <2049,2053,2050>,<2050,2053,2054>,<2050,2054,2051>,<2051,2054,2055>,<2051,2055,2052>,
            <2052,2055,2056>,<2052,2056,2049>,<2049,2056,2053>,
    /*5*/ <2053,2057,2054>,<2054,2057,2055>,<2055,2057,2056>,<2056,2057,2053>

    /* stem 0c5*/ 
    /*0*/ <2058,2059,2060>,<2058,2060,2061>,<2058,2061,2062>,<2058,2062,2059>,
    /*1*/ <2059,2063,2060>,<2060,2063,2064>,<2060,2064,2061>,<2061,2064,2065>,<2061,2065,2062>,
            <2062,2065,2066>,<2062,2066,2059>,<2059,2066,2063>,
    /*2*/ <2063,2067,2064>,<2064,2067,2068>,<2064,2068,2065>,<2065,2068,2069>,<2065,2069,2066>,
            <2066,2069,2070>,<2066,2070,2063>,<2063,2070,2067>,
    /*3*/ <2067,2071,2068>,<2068,2071,2072>,<2068,2072,2069>,<2069,2072,2073>,<2069,2073,2070>,
            <2070,2073,2074>,<2070,2074,2067>,<2067,2074,2071>,
    /*4*/ <2071,2075,2072>,<2072,2075,2076>,<2072,2076,2073>,<2073,2076,2077>,<2073,2077,2074>,
            <2074,2077,2078>,<2074,2078,2071>,<2071,2078,2075>,
    /*5*/ <2075,2079,2076>,<2076,2079,2080>,<2076,2080,2077>,<2077,2080,2081>,<2077,2081,2078>,
            <2078,2081,2082>,<2078,2082,2075>,<2075,2082,2079>,
    /*6*/ <2079,2083,2080>,<2080,2083,2084>,<2080,2084,2081>,<2081,2084,2085>,<2081,2085,2082>,
            <2082,2085,2086>,<2082,2086,2079>,<2079,2086,2083>,
    /*7*/ <2083,2087,2084>,<2084,2087,2088>,<2084,2088,2085>,<2085,2088,2089>,<2085,2089,2086>,
            <2086,2089,2090>,<2086,2090,2083>,<2083,2090,2087>,
    /*8*/ <2087,2091,2088>,<2088,2091,2092>,<2088,2092,2089>,<2089,2092,2093>,<2089,2093,2090>,
            <2090,2093,2094>,<2090,2094,2087>,<2087,2094,2091>,
    /*9*/ <2091,2095,2092>,<2092,2095,2093>,<2093,2095,2094>,<2094,2095,2091>

    /* stem 0c5.0*/ 
    /*0*/ <2096,2097,2098>,<2096,2098,2099>,<2096,2099,2100>,<2096,2100,2097>,
    /*1*/ <2097,2101,2098>,<2098,2101,2102>,<2098,2102,2099>,<2099,2102,2103>,<2099,2103,2100>,
            <2100,2103,2104>,<2100,2104,2097>,<2097,2104,2101>,
    /*2*/ <2101,2105,2102>,<2102,2105,2106>,<2102,2106,2103>,<2103,2106,2107>,<2103,2107,2104>,
            <2104,2107,2108>,<2104,2108,2101>,<2101,2108,2105>,
    /*3*/ <2105,2109,2106>,<2106,2109,2110>,<2106,2110,2107>,<2107,2110,2111>,<2107,2111,2108>,
            <2108,2111,2112>,<2108,2112,2105>,<2105,2112,2109>,
    /*4*/ <2109,2113,2110>,<2110,2113,2114>,<2110,2114,2111>,<2111,2114,2115>,<2111,2115,2112>,
            <2112,2115,2116>,<2112,2116,2109>,<2109,2116,2113>,
    /*5*/ <2113,2117,2114>,<2114,2117,2115>,<2115,2117,2116>,<2116,2117,2113>

    /* stem 0c5.1*/ 
    /*0*/ <2118,2119,2120>,<2118,2120,2121>,<2118,2121,2122>,<2118,2122,2119>,
    /*1*/ <2119,2123,2120>,<2120,2123,2124>,<2120,2124,2121>,<2121,2124,2125>,<2121,2125,2122>,
            <2122,2125,2126>,<2122,2126,2119>,<2119,2126,2123>,
    /*2*/ <2123,2127,2124>,<2124,2127,2128>,<2124,2128,2125>,<2125,2128,2129>,<2125,2129,2126>,
            <2126,2129,2130>,<2126,2130,2123>,<2123,2130,2127>,
    /*3*/ <2127,2131,2128>,<2128,2131,2132>,<2128,2132,2129>,<2129,2132,2133>,<2129,2133,2130>,
            <2130,2133,2134>,<2130,2134,2127>,<2127,2134,2131>,
    /*4*/ <2131,2135,2132>,<2132,2135,2136>,<2132,2136,2133>,<2133,2136,2137>,<2133,2137,2134>,
            <2134,2137,2138>,<2134,2138,2131>,<2131,2138,2135>,
    /*5*/ <2135,2139,2136>,<2136,2139,2137>,<2137,2139,2138>,<2138,2139,2135>

    /* stem 0c5.2*/ 
    /*0*/ <2140,2141,2142>,<2140,2142,2143>,<2140,2143,2144>,<2140,2144,2141>,
    /*1*/ <2141,2145,2142>,<2142,2145,2146>,<2142,2146,2143>,<2143,2146,2147>,<2143,2147,2144>,
            <2144,2147,2148>,<2144,2148,2141>,<2141,2148,2145>,
    /*2*/ <2145,2149,2146>,<2146,2149,2150>,<2146,2150,2147>,<2147,2150,2151>,<2147,2151,2148>,
            <2148,2151,2152>,<2148,2152,2145>,<2145,2152,2149>,
    /*3*/ <2149,2153,2150>,<2150,2153,2154>,<2150,2154,2151>,<2151,2154,2155>,<2151,2155,2152>,
            <2152,2155,2156>,<2152,2156,2149>,<2149,2156,2153>,
    /*4*/ <2153,2157,2154>,<2154,2157,2158>,<2154,2158,2155>,<2155,2158,2159>,<2155,2159,2156>,
            <2156,2159,2160>,<2156,2160,2153>,<2153,2160,2157>,
    /*5*/ <2157,2161,2158>,<2158,2161,2159>,<2159,2161,2160>,<2160,2161,2157>

    /* stem 0c5.3*/ 
    /*0*/ <2162,2163,2164>,<2162,2164,2165>,<2162,2165,2166>,<2162,2166,2163>,
    /*1*/ <2163,2167,2164>,<2164,2167,2168>,<2164,2168,2165>,<2165,2168,2169>,<2165,2169,2166>,
            <2166,2169,2170>,<2166,2170,2163>,<2163,2170,2167>,
    /*2*/ <2167,2171,2168>,<2168,2171,2172>,<2168,2172,2169>,<2169,2172,2173>,<2169,2173,2170>,
            <2170,2173,2174>,<2170,2174,2167>,<2167,2174,2171>,
    /*3*/ <2171,2175,2172>,<2172,2175,2176>,<2172,2176,2173>,<2173,2176,2177>,<2173,2177,2174>,
            <2174,2177,2178>,<2174,2178,2171>,<2171,2178,2175>,
    /*4*/ <2175,2179,2176>,<2176,2179,2180>,<2176,2180,2177>,<2177,2180,2181>,<2177,2181,2178>,
            <2178,2181,2182>,<2178,2182,2175>,<2175,2182,2179>,
    /*5*/ <2179,2183,2180>,<2180,2183,2181>,<2181,2183,2182>,<2182,2183,2179>

    /* stem 0c5.4*/ 
    /*0*/ <2184,2185,2186>,<2184,2186,2187>,<2184,2187,2188>,<2184,2188,2185>,
    /*1*/ <2185,2189,2186>,<2186,2189,2190>,<2186,2190,2187>,<2187,2190,2191>,<2187,2191,2188>,
            <2188,2191,2192>,<2188,2192,2185>,<2185,2192,2189>,
    /*2*/ <2189,2193,2190>,<2190,2193,2194>,<2190,2194,2191>,<2191,2194,2195>,<2191,2195,2192>,
            <2192,2195,2196>,<2192,2196,2189>,<2189,2196,2193>,
    /*3*/ <2193,2197,2194>,<2194,2197,2198>,<2194,2198,2195>,<2195,2198,2199>,<2195,2199,2196>,
            <2196,2199,2200>,<2196,2200,2193>,<2193,2200,2197>,
    /*4*/ <2197,2201,2198>,<2198,2201,2202>,<2198,2202,2199>,<2199,2202,2203>,<2199,2203,2200>,
            <2200,2203,2204>,<2200,2204,2197>,<2197,2204,2201>,
    /*5*/ <2201,2205,2202>,<2202,2205,2203>,<2203,2205,2204>,<2204,2205,2201>

    /* stem 0c5.5*/ 
    /*0*/ <2206,2207,2208>,<2206,2208,2209>,<2206,2209,2210>,<2206,2210,2207>,
    /*1*/ <2207,2211,2208>,<2208,2211,2212>,<2208,2212,2209>,<2209,2212,2213>,<2209,2213,2210>,
            <2210,2213,2214>,<2210,2214,2207>,<2207,2214,2211>,
    /*2*/ <2211,2215,2212>,<2212,2215,2216>,<2212,2216,2213>,<2213,2216,2217>,<2213,2217,2214>,
            <2214,2217,2218>,<2214,2218,2211>,<2211,2218,2215>,
    /*3*/ <2215,2219,2216>,<2216,2219,2220>,<2216,2220,2217>,<2217,2220,2221>,<2217,2221,2218>,
            <2218,2221,2222>,<2218,2222,2215>,<2215,2222,2219>,
    /*4*/ <2219,2223,2220>,<2220,2223,2224>,<2220,2224,2221>,<2221,2224,2225>,<2221,2225,2222>,
            <2222,2225,2226>,<2222,2226,2219>,<2219,2226,2223>,
    /*5*/ <2223,2227,2224>,<2224,2227,2225>,<2225,2227,2226>,<2226,2227,2223>

    /* stem 0c5.6*/ 
    /*0*/ <2228,2229,2230>,<2228,2230,2231>,<2228,2231,2232>,<2228,2232,2229>,
    /*1*/ <2229,2233,2230>,<2230,2233,2234>,<2230,2234,2231>,<2231,2234,2235>,<2231,2235,2232>,
            <2232,2235,2236>,<2232,2236,2229>,<2229,2236,2233>,
    /*2*/ <2233,2237,2234>,<2234,2237,2238>,<2234,2238,2235>,<2235,2238,2239>,<2235,2239,2236>,
            <2236,2239,2240>,<2236,2240,2233>,<2233,2240,2237>,
    /*3*/ <2237,2241,2238>,<2238,2241,2242>,<2238,2242,2239>,<2239,2242,2243>,<2239,2243,2240>,
            <2240,2243,2244>,<2240,2244,2237>,<2237,2244,2241>,
    /*4*/ <2241,2245,2242>,<2242,2245,2246>,<2242,2246,2243>,<2243,2246,2247>,<2243,2247,2244>,
            <2244,2247,2248>,<2244,2248,2241>,<2241,2248,2245>,
    /*5*/ <2245,2249,2246>,<2246,2249,2247>,<2247,2249,2248>,<2248,2249,2245>

    /* stem 0c5.7*/ 
    /*0*/ <2250,2251,2252>,<2250,2252,2253>,<2250,2253,2254>,<2250,2254,2251>,
    /*1*/ <2251,2255,2252>,<2252,2255,2256>,<2252,2256,2253>,<2253,2256,2257>,<2253,2257,2254>,
            <2254,2257,2258>,<2254,2258,2251>,<2251,2258,2255>,
    /*2*/ <2255,2259,2256>,<2256,2259,2260>,<2256,2260,2257>,<2257,2260,2261>,<2257,2261,2258>,
            <2258,2261,2262>,<2258,2262,2255>,<2255,2262,2259>,
    /*3*/ <2259,2263,2260>,<2260,2263,2264>,<2260,2264,2261>,<2261,2264,2265>,<2261,2265,2262>,
            <2262,2265,2266>,<2262,2266,2259>,<2259,2266,2263>,
    /*4*/ <2263,2267,2264>,<2264,2267,2268>,<2264,2268,2265>,<2265,2268,2269>,<2265,2269,2266>,
            <2266,2269,2270>,<2266,2270,2263>,<2263,2270,2267>,
    /*5*/ <2267,2271,2268>,<2268,2271,2269>,<2269,2271,2270>,<2270,2271,2267>

    /* stem 0c5.8*/ 
    /*0*/ <2272,2273,2274>,<2272,2274,2275>,<2272,2275,2276>,<2272,2276,2273>,
    /*1*/ <2273,2277,2274>,<2274,2277,2278>,<2274,2278,2275>,<2275,2278,2279>,<2275,2279,2276>,
            <2276,2279,2280>,<2276,2280,2273>,<2273,2280,2277>,
    /*2*/ <2277,2281,2278>,<2278,2281,2282>,<2278,2282,2279>,<2279,2282,2283>,<2279,2283,2280>,
            <2280,2283,2284>,<2280,2284,2277>,<2277,2284,2281>,
    /*3*/ <2281,2285,2282>,<2282,2285,2286>,<2282,2286,2283>,<2283,2286,2287>,<2283,2287,2284>,
            <2284,2287,2288>,<2284,2288,2281>,<2281,2288,2285>,
    /*4*/ <2285,2289,2286>,<2286,2289,2290>,<2286,2290,2287>,<2287,2290,2291>,<2287,2291,2288>,
            <2288,2291,2292>,<2288,2292,2285>,<2285,2292,2289>,
    /*5*/ <2289,2293,2290>,<2290,2293,2291>,<2291,2293,2292>,<2292,2293,2289>

    /* stem 0c5.9*/ 
    /*0*/ <2294,2295,2296>,<2294,2296,2297>,<2294,2297,2298>,<2294,2298,2295>,
    /*1*/ <2295,2299,2296>,<2296,2299,2300>,<2296,2300,2297>,<2297,2300,2301>,<2297,2301,2298>,
            <2298,2301,2302>,<2298,2302,2295>,<2295,2302,2299>,
    /*2*/ <2299,2303,2300>,<2300,2303,2304>,<2300,2304,2301>,<2301,2304,2305>,<2301,2305,2302>,
            <2302,2305,2306>,<2302,2306,2299>,<2299,2306,2303>,
    /*3*/ <2303,2307,2304>,<2304,2307,2308>,<2304,2308,2305>,<2305,2308,2309>,<2305,2309,2306>,
            <2306,2309,2310>,<2306,2310,2303>,<2303,2310,2307>,
    /*4*/ <2307,2311,2308>,<2308,2311,2312>,<2308,2312,2309>,<2309,2312,2313>,<2309,2313,2310>,
            <2310,2313,2314>,<2310,2314,2307>,<2307,2314,2311>,
    /*5*/ <2311,2315,2312>,<2312,2315,2313>,<2313,2315,2314>,<2314,2315,2311>

    /* stem 0c5.10*/ 
    /*0*/ <2316,2317,2318>,<2316,2318,2319>,<2316,2319,2320>,<2316,2320,2317>,
    /*1*/ <2317,2321,2318>,<2318,2321,2322>,<2318,2322,2319>,<2319,2322,2323>,<2319,2323,2320>,
            <2320,2323,2324>,<2320,2324,2317>,<2317,2324,2321>,
    /*2*/ <2321,2325,2322>,<2322,2325,2326>,<2322,2326,2323>,<2323,2326,2327>,<2323,2327,2324>,
            <2324,2327,2328>,<2324,2328,2321>,<2321,2328,2325>,
    /*3*/ <2325,2329,2326>,<2326,2329,2330>,<2326,2330,2327>,<2327,2330,2331>,<2327,2331,2328>,
            <2328,2331,2332>,<2328,2332,2325>,<2325,2332,2329>,
    /*4*/ <2329,2333,2330>,<2330,2333,2334>,<2330,2334,2331>,<2331,2334,2335>,<2331,2335,2332>,
            <2332,2335,2336>,<2332,2336,2329>,<2329,2336,2333>,
    /*5*/ <2333,2337,2334>,<2334,2337,2335>,<2335,2337,2336>,<2336,2337,2333>

    /* stem 0c5.11*/ 
    /*0*/ <2338,2339,2340>,<2338,2340,2341>,<2338,2341,2342>,<2338,2342,2339>,
    /*1*/ <2339,2343,2340>,<2340,2343,2344>,<2340,2344,2341>,<2341,2344,2345>,<2341,2345,2342>,
            <2342,2345,2346>,<2342,2346,2339>,<2339,2346,2343>,
    /*2*/ <2343,2347,2344>,<2344,2347,2348>,<2344,2348,2345>,<2345,2348,2349>,<2345,2349,2346>,
            <2346,2349,2350>,<2346,2350,2343>,<2343,2350,2347>,
    /*3*/ <2347,2351,2348>,<2348,2351,2352>,<2348,2352,2349>,<2349,2352,2353>,<2349,2353,2350>,
            <2350,2353,2354>,<2350,2354,2347>,<2347,2354,2351>,
    /*4*/ <2351,2355,2352>,<2352,2355,2356>,<2352,2356,2353>,<2353,2356,2357>,<2353,2357,2354>,
            <2354,2357,2358>,<2354,2358,2351>,<2351,2358,2355>,
    /*5*/ <2355,2359,2356>,<2356,2359,2357>,<2357,2359,2358>,<2358,2359,2355>

    /* stem 0c5.12*/ 
    /*0*/ <2360,2361,2362>,<2360,2362,2363>,<2360,2363,2364>,<2360,2364,2361>,
    /*1*/ <2361,2365,2362>,<2362,2365,2366>,<2362,2366,2363>,<2363,2366,2367>,<2363,2367,2364>,
            <2364,2367,2368>,<2364,2368,2361>,<2361,2368,2365>,
    /*2*/ <2365,2369,2366>,<2366,2369,2370>,<2366,2370,2367>,<2367,2370,2371>,<2367,2371,2368>,
            <2368,2371,2372>,<2368,2372,2365>,<2365,2372,2369>,
    /*3*/ <2369,2373,2370>,<2370,2373,2374>,<2370,2374,2371>,<2371,2374,2375>,<2371,2375,2372>,
            <2372,2375,2376>,<2372,2376,2369>,<2369,2376,2373>,
    /*4*/ <2373,2377,2374>,<2374,2377,2378>,<2374,2378,2375>,<2375,2378,2379>,<2375,2379,2376>,
            <2376,2379,2380>,<2376,2380,2373>,<2373,2380,2377>,
    /*5*/ <2377,2381,2378>,<2378,2381,2379>,<2379,2381,2380>,<2380,2381,2377>

    /* stem 0c5.13*/ 
    /*0*/ <2382,2383,2384>,<2382,2384,2385>,<2382,2385,2386>,<2382,2386,2383>,
    /*1*/ <2383,2387,2384>,<2384,2387,2388>,<2384,2388,2385>,<2385,2388,2389>,<2385,2389,2386>,
            <2386,2389,2390>,<2386,2390,2383>,<2383,2390,2387>,
    /*2*/ <2387,2391,2388>,<2388,2391,2392>,<2388,2392,2389>,<2389,2392,2393>,<2389,2393,2390>,
            <2390,2393,2394>,<2390,2394,2387>,<2387,2394,2391>,
    /*3*/ <2391,2395,2392>,<2392,2395,2396>,<2392,2396,2393>,<2393,2396,2397>,<2393,2397,2394>,
            <2394,2397,2398>,<2394,2398,2391>,<2391,2398,2395>,
    /*4*/ <2395,2399,2396>,<2396,2399,2400>,<2396,2400,2397>,<2397,2400,2401>,<2397,2401,2398>,
            <2398,2401,2402>,<2398,2402,2395>,<2395,2402,2399>,
    /*5*/ <2399,2403,2400>,<2400,2403,2401>,<2401,2403,2402>,<2402,2403,2399>

    /* stem 0c5.14*/ 
    /*0*/ <2404,2405,2406>,<2404,2406,2407>,<2404,2407,2408>,<2404,2408,2405>,
    /*1*/ <2405,2409,2406>,<2406,2409,2410>,<2406,2410,2407>,<2407,2410,2411>,<2407,2411,2408>,
            <2408,2411,2412>,<2408,2412,2405>,<2405,2412,2409>,
    /*2*/ <2409,2413,2410>,<2410,2413,2414>,<2410,2414,2411>,<2411,2414,2415>,<2411,2415,2412>,
            <2412,2415,2416>,<2412,2416,2409>,<2409,2416,2413>,
    /*3*/ <2413,2417,2414>,<2414,2417,2418>,<2414,2418,2415>,<2415,2418,2419>,<2415,2419,2416>,
            <2416,2419,2420>,<2416,2420,2413>,<2413,2420,2417>,
    /*4*/ <2417,2421,2418>,<2418,2421,2422>,<2418,2422,2419>,<2419,2422,2423>,<2419,2423,2420>,
            <2420,2423,2424>,<2420,2424,2417>,<2417,2424,2421>,
    /*5*/ <2421,2425,2422>,<2422,2425,2423>,<2423,2425,2424>,<2424,2425,2421>

    /* stem 0c5.15*/ 
    /*0*/ <2426,2427,2428>,<2426,2428,2429>,<2426,2429,2430>,<2426,2430,2427>,
    /*1*/ <2427,2431,2428>,<2428,2431,2432>,<2428,2432,2429>,<2429,2432,2433>,<2429,2433,2430>,
            <2430,2433,2434>,<2430,2434,2427>,<2427,2434,2431>,
    /*2*/ <2431,2435,2432>,<2432,2435,2436>,<2432,2436,2433>,<2433,2436,2437>,<2433,2437,2434>,
            <2434,2437,2438>,<2434,2438,2431>,<2431,2438,2435>,
    /*3*/ <2435,2439,2436>,<2436,2439,2440>,<2436,2440,2437>,<2437,2440,2441>,<2437,2441,2438>,
            <2438,2441,2442>,<2438,2442,2435>,<2435,2442,2439>,
    /*4*/ <2439,2443,2440>,<2440,2443,2444>,<2440,2444,2441>,<2441,2444,2445>,<2441,2445,2442>,
            <2442,2445,2446>,<2442,2446,2439>,<2439,2446,2443>,
    /*5*/ <2443,2447,2444>,<2444,2447,2445>,<2445,2447,2446>,<2446,2447,2443>

    /* stem 0c5.16*/ 
    /*0*/ <2448,2449,2450>,<2448,2450,2451>,<2448,2451,2452>,<2448,2452,2449>,
    /*1*/ <2449,2453,2450>,<2450,2453,2454>,<2450,2454,2451>,<2451,2454,2455>,<2451,2455,2452>,
            <2452,2455,2456>,<2452,2456,2449>,<2449,2456,2453>,
    /*2*/ <2453,2457,2454>,<2454,2457,2458>,<2454,2458,2455>,<2455,2458,2459>,<2455,2459,2456>,
            <2456,2459,2460>,<2456,2460,2453>,<2453,2460,2457>,
    /*3*/ <2457,2461,2458>,<2458,2461,2462>,<2458,2462,2459>,<2459,2462,2463>,<2459,2463,2460>,
            <2460,2463,2464>,<2460,2464,2457>,<2457,2464,2461>,
    /*4*/ <2461,2465,2462>,<2462,2465,2466>,<2462,2466,2463>,<2463,2466,2467>,<2463,2467,2464>,
            <2464,2467,2468>,<2464,2468,2461>,<2461,2468,2465>,
    /*5*/ <2465,2469,2466>,<2466,2469,2467>,<2467,2469,2468>,<2468,2469,2465>

    /* stem 0c6*/ 
    /*0*/ <2470,2471,2472>,<2470,2472,2473>,<2470,2473,2474>,<2470,2474,2471>,
    /*1*/ <2471,2475,2472>,<2472,2475,2476>,<2472,2476,2473>,<2473,2476,2477>,<2473,2477,2474>,
            <2474,2477,2478>,<2474,2478,2471>,<2471,2478,2475>,
    /*2*/ <2475,2479,2476>,<2476,2479,2480>,<2476,2480,2477>,<2477,2480,2481>,<2477,2481,2478>,
            <2478,2481,2482>,<2478,2482,2475>,<2475,2482,2479>,
    /*3*/ <2479,2483,2480>,<2480,2483,2484>,<2480,2484,2481>,<2481,2484,2485>,<2481,2485,2482>,
            <2482,2485,2486>,<2482,2486,2479>,<2479,2486,2483>,
    /*4*/ <2483,2487,2484>,<2484,2487,2488>,<2484,2488,2485>,<2485,2488,2489>,<2485,2489,2486>,
            <2486,2489,2490>,<2486,2490,2483>,<2483,2490,2487>,
    /*5*/ <2487,2491,2488>,<2488,2491,2492>,<2488,2492,2489>,<2489,2492,2493>,<2489,2493,2490>,
            <2490,2493,2494>,<2490,2494,2487>,<2487,2494,2491>,
    /*6*/ <2491,2495,2492>,<2492,2495,2496>,<2492,2496,2493>,<2493,2496,2497>,<2493,2497,2494>,
            <2494,2497,2498>,<2494,2498,2491>,<2491,2498,2495>,
    /*7*/ <2495,2499,2496>,<2496,2499,2500>,<2496,2500,2497>,<2497,2500,2501>,<2497,2501,2498>,
            <2498,2501,2502>,<2498,2502,2495>,<2495,2502,2499>,
    /*8*/ <2499,2503,2500>,<2500,2503,2504>,<2500,2504,2501>,<2501,2504,2505>,<2501,2505,2502>,
            <2502,2505,2506>,<2502,2506,2499>,<2499,2506,2503>,
    /*9*/ <2503,2507,2504>,<2504,2507,2505>,<2505,2507,2506>,<2506,2507,2503>

    /* stem 0c6.0*/ 
    /*0*/ <2508,2509,2510>,<2508,2510,2511>,<2508,2511,2512>,<2508,2512,2509>,
    /*1*/ <2509,2513,2510>,<2510,2513,2514>,<2510,2514,2511>,<2511,2514,2515>,<2511,2515,2512>,
            <2512,2515,2516>,<2512,2516,2509>,<2509,2516,2513>,
    /*2*/ <2513,2517,2514>,<2514,2517,2518>,<2514,2518,2515>,<2515,2518,2519>,<2515,2519,2516>,
            <2516,2519,2520>,<2516,2520,2513>,<2513,2520,2517>,
    /*3*/ <2517,2521,2518>,<2518,2521,2522>,<2518,2522,2519>,<2519,2522,2523>,<2519,2523,2520>,
            <2520,2523,2524>,<2520,2524,2517>,<2517,2524,2521>,
    /*4*/ <2521,2525,2522>,<2522,2525,2526>,<2522,2526,2523>,<2523,2526,2527>,<2523,2527,2524>,
            <2524,2527,2528>,<2524,2528,2521>,<2521,2528,2525>,
    /*5*/ <2525,2529,2526>,<2526,2529,2527>,<2527,2529,2528>,<2528,2529,2525>

    /* stem 0c6.1*/ 
    /*0*/ <2530,2531,2532>,<2530,2532,2533>,<2530,2533,2534>,<2530,2534,2531>,
    /*1*/ <2531,2535,2532>,<2532,2535,2536>,<2532,2536,2533>,<2533,2536,2537>,<2533,2537,2534>,
            <2534,2537,2538>,<2534,2538,2531>,<2531,2538,2535>,
    /*2*/ <2535,2539,2536>,<2536,2539,2540>,<2536,2540,2537>,<2537,2540,2541>,<2537,2541,2538>,
            <2538,2541,2542>,<2538,2542,2535>,<2535,2542,2539>,
    /*3*/ <2539,2543,2540>,<2540,2543,2544>,<2540,2544,2541>,<2541,2544,2545>,<2541,2545,2542>,
            <2542,2545,2546>,<2542,2546,2539>,<2539,2546,2543>,
    /*4*/ <2543,2547,2544>,<2544,2547,2548>,<2544,2548,2545>,<2545,2548,2549>,<2545,2549,2546>,
            <2546,2549,2550>,<2546,2550,2543>,<2543,2550,2547>,
    /*5*/ <2547,2551,2548>,<2548,2551,2549>,<2549,2551,2550>,<2550,2551,2547>

    /* stem 0c6.2*/ 
    /*0*/ <2552,2553,2554>,<2552,2554,2555>,<2552,2555,2556>,<2552,2556,2553>,
    /*1*/ <2553,2557,2554>,<2554,2557,2558>,<2554,2558,2555>,<2555,2558,2559>,<2555,2559,2556>,
            <2556,2559,2560>,<2556,2560,2553>,<2553,2560,2557>,
    /*2*/ <2557,2561,2558>,<2558,2561,2562>,<2558,2562,2559>,<2559,2562,2563>,<2559,2563,2560>,
            <2560,2563,2564>,<2560,2564,2557>,<2557,2564,2561>,
    /*3*/ <2561,2565,2562>,<2562,2565,2566>,<2562,2566,2563>,<2563,2566,2567>,<2563,2567,2564>,
            <2564,2567,2568>,<2564,2568,2561>,<2561,2568,2565>,
    /*4*/ <2565,2569,2566>,<2566,2569,2570>,<2566,2570,2567>,<2567,2570,2571>,<2567,2571,2568>,
            <2568,2571,2572>,<2568,2572,2565>,<2565,2572,2569>,
    /*5*/ <2569,2573,2570>,<2570,2573,2571>,<2571,2573,2572>,<2572,2573,2569>

    /* stem 0c6.3*/ 
    /*0*/ <2574,2575,2576>,<2574,2576,2577>,<2574,2577,2578>,<2574,2578,2575>,
    /*1*/ <2575,2579,2576>,<2576,2579,2580>,<2576,2580,2577>,<2577,2580,2581>,<2577,2581,2578>,
            <2578,2581,2582>,<2578,2582,2575>,<2575,2582,2579>,
    /*2*/ <2579,2583,2580>,<2580,2583,2584>,<2580,2584,2581>,<2581,2584,2585>,<2581,2585,2582>,
            <2582,2585,2586>,<2582,2586,2579>,<2579,2586,2583>,
    /*3*/ <2583,2587,2584>,<2584,2587,2588>,<2584,2588,2585>,<2585,2588,2589>,<2585,2589,2586>,
            <2586,2589,2590>,<2586,2590,2583>,<2583,2590,2587>,
    /*4*/ <2587,2591,2588>,<2588,2591,2592>,<2588,2592,2589>,<2589,2592,2593>,<2589,2593,2590>,
            <2590,2593,2594>,<2590,2594,2587>,<2587,2594,2591>,
    /*5*/ <2591,2595,2592>,<2592,2595,2593>,<2593,2595,2594>,<2594,2595,2591>

    /* stem 0c6.4*/ 
    /*0*/ <2596,2597,2598>,<2596,2598,2599>,<2596,2599,2600>,<2596,2600,2597>,
    /*1*/ <2597,2601,2598>,<2598,2601,2602>,<2598,2602,2599>,<2599,2602,2603>,<2599,2603,2600>,
            <2600,2603,2604>,<2600,2604,2597>,<2597,2604,2601>,
    /*2*/ <2601,2605,2602>,<2602,2605,2606>,<2602,2606,2603>,<2603,2606,2607>,<2603,2607,2604>,
            <2604,2607,2608>,<2604,2608,2601>,<2601,2608,2605>,
    /*3*/ <2605,2609,2606>,<2606,2609,2610>,<2606,2610,2607>,<2607,2610,2611>,<2607,2611,2608>,
            <2608,2611,2612>,<2608,2612,2605>,<2605,2612,2609>,
    /*4*/ <2609,2613,2610>,<2610,2613,2614>,<2610,2614,2611>,<2611,2614,2615>,<2611,2615,2612>,
            <2612,2615,2616>,<2612,2616,2609>,<2609,2616,2613>,
    /*5*/ <2613,2617,2614>,<2614,2617,2615>,<2615,2617,2616>,<2616,2617,2613>

    /* stem 0c6.5*/ 
    /*0*/ <2618,2619,2620>,<2618,2620,2621>,<2618,2621,2622>,<2618,2622,2619>,
    /*1*/ <2619,2623,2620>,<2620,2623,2624>,<2620,2624,2621>,<2621,2624,2625>,<2621,2625,2622>,
            <2622,2625,2626>,<2622,2626,2619>,<2619,2626,2623>,
    /*2*/ <2623,2627,2624>,<2624,2627,2628>,<2624,2628,2625>,<2625,2628,2629>,<2625,2629,2626>,
            <2626,2629,2630>,<2626,2630,2623>,<2623,2630,2627>,
    /*3*/ <2627,2631,2628>,<2628,2631,2632>,<2628,2632,2629>,<2629,2632,2633>,<2629,2633,2630>,
            <2630,2633,2634>,<2630,2634,2627>,<2627,2634,2631>,
    /*4*/ <2631,2635,2632>,<2632,2635,2636>,<2632,2636,2633>,<2633,2636,2637>,<2633,2637,2634>,
            <2634,2637,2638>,<2634,2638,2631>,<2631,2638,2635>,
    /*5*/ <2635,2639,2636>,<2636,2639,2637>,<2637,2639,2638>,<2638,2639,2635>

    /* stem 0c6.6*/ 
    /*0*/ <2640,2641,2642>,<2640,2642,2643>,<2640,2643,2644>,<2640,2644,2641>,
    /*1*/ <2641,2645,2642>,<2642,2645,2646>,<2642,2646,2643>,<2643,2646,2647>,<2643,2647,2644>,
            <2644,2647,2648>,<2644,2648,2641>,<2641,2648,2645>,
    /*2*/ <2645,2649,2646>,<2646,2649,2650>,<2646,2650,2647>,<2647,2650,2651>,<2647,2651,2648>,
            <2648,2651,2652>,<2648,2652,2645>,<2645,2652,2649>,
    /*3*/ <2649,2653,2650>,<2650,2653,2654>,<2650,2654,2651>,<2651,2654,2655>,<2651,2655,2652>,
            <2652,2655,2656>,<2652,2656,2649>,<2649,2656,2653>,
    /*4*/ <2653,2657,2654>,<2654,2657,2658>,<2654,2658,2655>,<2655,2658,2659>,<2655,2659,2656>,
            <2656,2659,2660>,<2656,2660,2653>,<2653,2660,2657>,
    /*5*/ <2657,2661,2658>,<2658,2661,2659>,<2659,2661,2660>,<2660,2661,2657>

    /* stem 0c6.7*/ 
    /*0*/ <2662,2663,2664>,<2662,2664,2665>,<2662,2665,2666>,<2662,2666,2663>,
    /*1*/ <2663,2667,2664>,<2664,2667,2668>,<2664,2668,2665>,<2665,2668,2669>,<2665,2669,2666>,
            <2666,2669,2670>,<2666,2670,2663>,<2663,2670,2667>,
    /*2*/ <2667,2671,2668>,<2668,2671,2672>,<2668,2672,2669>,<2669,2672,2673>,<2669,2673,2670>,
            <2670,2673,2674>,<2670,2674,2667>,<2667,2674,2671>,
    /*3*/ <2671,2675,2672>,<2672,2675,2676>,<2672,2676,2673>,<2673,2676,2677>,<2673,2677,2674>,
            <2674,2677,2678>,<2674,2678,2671>,<2671,2678,2675>,
    /*4*/ <2675,2679,2676>,<2676,2679,2680>,<2676,2680,2677>,<2677,2680,2681>,<2677,2681,2678>,
            <2678,2681,2682>,<2678,2682,2675>,<2675,2682,2679>,
    /*5*/ <2679,2683,2680>,<2680,2683,2681>,<2681,2683,2682>,<2682,2683,2679>

    /* stem 0c6.8*/ 
    /*0*/ <2684,2685,2686>,<2684,2686,2687>,<2684,2687,2688>,<2684,2688,2685>,
    /*1*/ <2685,2689,2686>,<2686,2689,2690>,<2686,2690,2687>,<2687,2690,2691>,<2687,2691,2688>,
            <2688,2691,2692>,<2688,2692,2685>,<2685,2692,2689>,
    /*2*/ <2689,2693,2690>,<2690,2693,2694>,<2690,2694,2691>,<2691,2694,2695>,<2691,2695,2692>,
            <2692,2695,2696>,<2692,2696,2689>,<2689,2696,2693>,
    /*3*/ <2693,2697,2694>,<2694,2697,2698>,<2694,2698,2695>,<2695,2698,2699>,<2695,2699,2696>,
            <2696,2699,2700>,<2696,2700,2693>,<2693,2700,2697>,
    /*4*/ <2697,2701,2698>,<2698,2701,2702>,<2698,2702,2699>,<2699,2702,2703>,<2699,2703,2700>,
            <2700,2703,2704>,<2700,2704,2697>,<2697,2704,2701>,
    /*5*/ <2701,2705,2702>,<2702,2705,2703>,<2703,2705,2704>,<2704,2705,2701>

    /* stem 0c6.9*/ 
    /*0*/ <2706,2707,2708>,<2706,2708,2709>,<2706,2709,2710>,<2706,2710,2707>,
    /*1*/ <2707,2711,2708>,<2708,2711,2712>,<2708,2712,2709>,<2709,2712,2713>,<2709,2713,2710>,
            <2710,2713,2714>,<2710,2714,2707>,<2707,2714,2711>,
    /*2*/ <2711,2715,2712>,<2712,2715,2716>,<2712,2716,2713>,<2713,2716,2717>,<2713,2717,2714>,
            <2714,2717,2718>,<2714,2718,2711>,<2711,2718,2715>,
    /*3*/ <2715,2719,2716>,<2716,2719,2720>,<2716,2720,2717>,<2717,2720,2721>,<2717,2721,2718>,
            <2718,2721,2722>,<2718,2722,2715>,<2715,2722,2719>,
    /*4*/ <2719,2723,2720>,<2720,2723,2724>,<2720,2724,2721>,<2721,2724,2725>,<2721,2725,2722>,
            <2722,2725,2726>,<2722,2726,2719>,<2719,2726,2723>,
    /*5*/ <2723,2727,2724>,<2724,2727,2725>,<2725,2727,2726>,<2726,2727,2723>

    /* stem 0c6.10*/ 
    /*0*/ <2728,2729,2730>,<2728,2730,2731>,<2728,2731,2732>,<2728,2732,2729>,
    /*1*/ <2729,2733,2730>,<2730,2733,2734>,<2730,2734,2731>,<2731,2734,2735>,<2731,2735,2732>,
            <2732,2735,2736>,<2732,2736,2729>,<2729,2736,2733>,
    /*2*/ <2733,2737,2734>,<2734,2737,2738>,<2734,2738,2735>,<2735,2738,2739>,<2735,2739,2736>,
            <2736,2739,2740>,<2736,2740,2733>,<2733,2740,2737>,
    /*3*/ <2737,2741,2738>,<2738,2741,2742>,<2738,2742,2739>,<2739,2742,2743>,<2739,2743,2740>,
            <2740,2743,2744>,<2740,2744,2737>,<2737,2744,2741>,
    /*4*/ <2741,2745,2742>,<2742,2745,2746>,<2742,2746,2743>,<2743,2746,2747>,<2743,2747,2744>,
            <2744,2747,2748>,<2744,2748,2741>,<2741,2748,2745>,
    /*5*/ <2745,2749,2746>,<2746,2749,2747>,<2747,2749,2748>,<2748,2749,2745>

    /* stem 0c6.11*/ 
    /*0*/ <2750,2751,2752>,<2750,2752,2753>,<2750,2753,2754>,<2750,2754,2751>,
    /*1*/ <2751,2755,2752>,<2752,2755,2756>,<2752,2756,2753>,<2753,2756,2757>,<2753,2757,2754>,
            <2754,2757,2758>,<2754,2758,2751>,<2751,2758,2755>,
    /*2*/ <2755,2759,2756>,<2756,2759,2760>,<2756,2760,2757>,<2757,2760,2761>,<2757,2761,2758>,
            <2758,2761,2762>,<2758,2762,2755>,<2755,2762,2759>,
    /*3*/ <2759,2763,2760>,<2760,2763,2764>,<2760,2764,2761>,<2761,2764,2765>,<2761,2765,2762>,
            <2762,2765,2766>,<2762,2766,2759>,<2759,2766,2763>,
    /*4*/ <2763,2767,2764>,<2764,2767,2768>,<2764,2768,2765>,<2765,2768,2769>,<2765,2769,2766>,
            <2766,2769,2770>,<2766,2770,2763>,<2763,2770,2767>,
    /*5*/ <2767,2771,2768>,<2768,2771,2769>,<2769,2771,2770>,<2770,2771,2767>

    /* stem 0c6.12*/ 
    /*0*/ <2772,2773,2774>,<2772,2774,2775>,<2772,2775,2776>,<2772,2776,2773>,
    /*1*/ <2773,2777,2774>,<2774,2777,2778>,<2774,2778,2775>,<2775,2778,2779>,<2775,2779,2776>,
            <2776,2779,2780>,<2776,2780,2773>,<2773,2780,2777>,
    /*2*/ <2777,2781,2778>,<2778,2781,2782>,<2778,2782,2779>,<2779,2782,2783>,<2779,2783,2780>,
            <2780,2783,2784>,<2780,2784,2777>,<2777,2784,2781>,
    /*3*/ <2781,2785,2782>,<2782,2785,2786>,<2782,2786,2783>,<2783,2786,2787>,<2783,2787,2784>,
            <2784,2787,2788>,<2784,2788,2781>,<2781,2788,2785>,
    /*4*/ <2785,2789,2786>,<2786,2789,2790>,<2786,2790,2787>,<2787,2790,2791>,<2787,2791,2788>,
            <2788,2791,2792>,<2788,2792,2785>,<2785,2792,2789>,
    /*5*/ <2789,2793,2790>,<2790,2793,2791>,<2791,2793,2792>,<2792,2793,2789>

    /* stem 0c6.13*/ 
    /*0*/ <2794,2795,2796>,<2794,2796,2797>,<2794,2797,2798>,<2794,2798,2795>,
    /*1*/ <2795,2799,2796>,<2796,2799,2800>,<2796,2800,2797>,<2797,2800,2801>,<2797,2801,2798>,
            <2798,2801,2802>,<2798,2802,2795>,<2795,2802,2799>,
    /*2*/ <2799,2803,2800>,<2800,2803,2804>,<2800,2804,2801>,<2801,2804,2805>,<2801,2805,2802>,
            <2802,2805,2806>,<2802,2806,2799>,<2799,2806,2803>,
    /*3*/ <2803,2807,2804>,<2804,2807,2808>,<2804,2808,2805>,<2805,2808,2809>,<2805,2809,2806>,
            <2806,2809,2810>,<2806,2810,2803>,<2803,2810,2807>,
    /*4*/ <2807,2811,2808>,<2808,2811,2812>,<2808,2812,2809>,<2809,2812,2813>,<2809,2813,2810>,
            <2810,2813,2814>,<2810,2814,2807>,<2807,2814,2811>,
    /*5*/ <2811,2815,2812>,<2812,2815,2813>,<2813,2815,2814>,<2814,2815,2811>

    /* stem 0c6.14*/ 
    /*0*/ <2816,2817,2818>,<2816,2818,2819>,<2816,2819,2820>,<2816,2820,2817>,
    /*1*/ <2817,2821,2818>,<2818,2821,2822>,<2818,2822,2819>,<2819,2822,2823>,<2819,2823,2820>,
            <2820,2823,2824>,<2820,2824,2817>,<2817,2824,2821>,
    /*2*/ <2821,2825,2822>,<2822,2825,2826>,<2822,2826,2823>,<2823,2826,2827>,<2823,2827,2824>,
            <2824,2827,2828>,<2824,2828,2821>,<2821,2828,2825>,
    /*3*/ <2825,2829,2826>,<2826,2829,2830>,<2826,2830,2827>,<2827,2830,2831>,<2827,2831,2828>,
            <2828,2831,2832>,<2828,2832,2825>,<2825,2832,2829>,
    /*4*/ <2829,2833,2830>,<2830,2833,2834>,<2830,2834,2831>,<2831,2834,2835>,<2831,2835,2832>,
            <2832,2835,2836>,<2832,2836,2829>,<2829,2836,2833>,
    /*5*/ <2833,2837,2834>,<2834,2837,2835>,<2835,2837,2836>,<2836,2837,2833>

    /* stem 0c6.15*/ 
    /*0*/ <2838,2839,2840>,<2838,2840,2841>,<2838,2841,2842>,<2838,2842,2839>,
    /*1*/ <2839,2843,2840>,<2840,2843,2844>,<2840,2844,2841>,<2841,2844,2845>,<2841,2845,2842>,
            <2842,2845,2846>,<2842,2846,2839>,<2839,2846,2843>,
    /*2*/ <2843,2847,2844>,<2844,2847,2848>,<2844,2848,2845>,<2845,2848,2849>,<2845,2849,2846>,
            <2846,2849,2850>,<2846,2850,2843>,<2843,2850,2847>,
    /*3*/ <2847,2851,2848>,<2848,2851,2852>,<2848,2852,2849>,<2849,2852,2853>,<2849,2853,2850>,
            <2850,2853,2854>,<2850,2854,2847>,<2847,2854,2851>,
    /*4*/ <2851,2855,2852>,<2852,2855,2856>,<2852,2856,2853>,<2853,2856,2857>,<2853,2857,2854>,
            <2854,2857,2858>,<2854,2858,2851>,<2851,2858,2855>,
    /*5*/ <2855,2859,2856>,<2856,2859,2857>,<2857,2859,2858>,<2858,2859,2855>

    /* stem 0c6.16*/ 
    /*0*/ <2860,2861,2862>,<2860,2862,2863>,<2860,2863,2864>,<2860,2864,2861>,
    /*1*/ <2861,2865,2862>,<2862,2865,2866>,<2862,2866,2863>,<2863,2866,2867>,<2863,2867,2864>,
            <2864,2867,2868>,<2864,2868,2861>,<2861,2868,2865>,
    /*2*/ <2865,2869,2866>,<2866,2869,2870>,<2866,2870,2867>,<2867,2870,2871>,<2867,2871,2868>,
            <2868,2871,2872>,<2868,2872,2865>,<2865,2872,2869>,
    /*3*/ <2869,2873,2870>,<2870,2873,2874>,<2870,2874,2871>,<2871,2874,2875>,<2871,2875,2872>,
            <2872,2875,2876>,<2872,2876,2869>,<2869,2876,2873>,
    /*4*/ <2873,2877,2874>,<2874,2877,2878>,<2874,2878,2875>,<2875,2878,2879>,<2875,2879,2876>,
            <2876,2879,2880>,<2876,2880,2873>,<2873,2880,2877>,
    /*5*/ <2877,2881,2878>,<2878,2881,2879>,<2879,2881,2880>,<2880,2881,2877>

    /* stem 0c7*/ 
    /*0*/ <2882,2883,2884>,<2882,2884,2885>,<2882,2885,2886>,<2882,2886,2883>,
    /*1*/ <2883,2887,2884>,<2884,2887,2888>,<2884,2888,2885>,<2885,2888,2889>,<2885,2889,2886>,
            <2886,2889,2890>,<2886,2890,2883>,<2883,2890,2887>,
    /*2*/ <2887,2891,2888>,<2888,2891,2892>,<2888,2892,2889>,<2889,2892,2893>,<2889,2893,2890>,
            <2890,2893,2894>,<2890,2894,2887>,<2887,2894,2891>,
    /*3*/ <2891,2895,2892>,<2892,2895,2896>,<2892,2896,2893>,<2893,2896,2897>,<2893,2897,2894>,
            <2894,2897,2898>,<2894,2898,2891>,<2891,2898,2895>,
    /*4*/ <2895,2899,2896>,<2896,2899,2900>,<2896,2900,2897>,<2897,2900,2901>,<2897,2901,2898>,
            <2898,2901,2902>,<2898,2902,2895>,<2895,2902,2899>,
    /*5*/ <2899,2903,2900>,<2900,2903,2904>,<2900,2904,2901>,<2901,2904,2905>,<2901,2905,2902>,
            <2902,2905,2906>,<2902,2906,2899>,<2899,2906,2903>,
    /*6*/ <2903,2907,2904>,<2904,2907,2908>,<2904,2908,2905>,<2905,2908,2909>,<2905,2909,2906>,
            <2906,2909,2910>,<2906,2910,2903>,<2903,2910,2907>,
    /*7*/ <2907,2911,2908>,<2908,2911,2912>,<2908,2912,2909>,<2909,2912,2913>,<2909,2913,2910>,
            <2910,2913,2914>,<2910,2914,2907>,<2907,2914,2911>,
    /*8*/ <2911,2915,2912>,<2912,2915,2916>,<2912,2916,2913>,<2913,2916,2917>,<2913,2917,2914>,
            <2914,2917,2918>,<2914,2918,2911>,<2911,2918,2915>,
    /*9*/ <2915,2919,2916>,<2916,2919,2917>,<2917,2919,2918>,<2918,2919,2915>

    /* stem 0c7.0*/ 
    /*0*/ <2920,2921,2922>,<2920,2922,2923>,<2920,2923,2924>,<2920,2924,2921>,
    /*1*/ <2921,2925,2922>,<2922,2925,2926>,<2922,2926,2923>,<2923,2926,2927>,<2923,2927,2924>,
            <2924,2927,2928>,<2924,2928,2921>,<2921,2928,2925>,
    /*2*/ <2925,2929,2926>,<2926,2929,2930>,<2926,2930,2927>,<2927,2930,2931>,<2927,2931,2928>,
            <2928,2931,2932>,<2928,2932,2925>,<2925,2932,2929>,
    /*3*/ <2929,2933,2930>,<2930,2933,2934>,<2930,2934,2931>,<2931,2934,2935>,<2931,2935,2932>,
            <2932,2935,2936>,<2932,2936,2929>,<2929,2936,2933>,
    /*4*/ <2933,2937,2934>,<2934,2937,2938>,<2934,2938,2935>,<2935,2938,2939>,<2935,2939,2936>,
            <2936,2939,2940>,<2936,2940,2933>,<2933,2940,2937>,
    /*5*/ <2937,2941,2938>,<2938,2941,2939>,<2939,2941,2940>,<2940,2941,2937>

    /* stem 0c7.1*/ 
    /*0*/ <2942,2943,2944>,<2942,2944,2945>,<2942,2945,2946>,<2942,2946,2943>,
    /*1*/ <2943,2947,2944>,<2944,2947,2948>,<2944,2948,2945>,<2945,2948,2949>,<2945,2949,2946>,
            <2946,2949,2950>,<2946,2950,2943>,<2943,2950,2947>,
    /*2*/ <2947,2951,2948>,<2948,2951,2952>,<2948,2952,2949>,<2949,2952,2953>,<2949,2953,2950>,
            <2950,2953,2954>,<2950,2954,2947>,<2947,2954,2951>,
    /*3*/ <2951,2955,2952>,<2952,2955,2956>,<2952,2956,2953>,<2953,2956,2957>,<2953,2957,2954>,
            <2954,2957,2958>,<2954,2958,2951>,<2951,2958,2955>,
    /*4*/ <2955,2959,2956>,<2956,2959,2960>,<2956,2960,2957>,<2957,2960,2961>,<2957,2961,2958>,
            <2958,2961,2962>,<2958,2962,2955>,<2955,2962,2959>,
    /*5*/ <2959,2963,2960>,<2960,2963,2961>,<2961,2963,2962>,<2962,2963,2959>

    /* stem 0c7.2*/ 
    /*0*/ <2964,2965,2966>,<2964,2966,2967>,<2964,2967,2968>,<2964,2968,2965>,
    /*1*/ <2965,2969,2966>,<2966,2969,2970>,<2966,2970,2967>,<2967,2970,2971>,<2967,2971,2968>,
            <2968,2971,2972>,<2968,2972,2965>,<2965,2972,2969>,
    /*2*/ <2969,2973,2970>,<2970,2973,2974>,<2970,2974,2971>,<2971,2974,2975>,<2971,2975,2972>,
            <2972,2975,2976>,<2972,2976,2969>,<2969,2976,2973>,
    /*3*/ <2973,2977,2974>,<2974,2977,2978>,<2974,2978,2975>,<2975,2978,2979>,<2975,2979,2976>,
            <2976,2979,2980>,<2976,2980,2973>,<2973,2980,2977>,
    /*4*/ <2977,2981,2978>,<2978,2981,2982>,<2978,2982,2979>,<2979,2982,2983>,<2979,2983,2980>,
            <2980,2983,2984>,<2980,2984,2977>,<2977,2984,2981>,
    /*5*/ <2981,2985,2982>,<2982,2985,2983>,<2983,2985,2984>,<2984,2985,2981>

    /* stem 0c7.3*/ 
    /*0*/ <2986,2987,2988>,<2986,2988,2989>,<2986,2989,2990>,<2986,2990,2987>,
    /*1*/ <2987,2991,2988>,<2988,2991,2992>,<2988,2992,2989>,<2989,2992,2993>,<2989,2993,2990>,
            <2990,2993,2994>,<2990,2994,2987>,<2987,2994,2991>,
    /*2*/ <2991,2995,2992>,<2992,2995,2996>,<2992,2996,2993>,<2993,2996,2997>,<2993,2997,2994>,
            <2994,2997,2998>,<2994,2998,2991>,<2991,2998,2995>,
    /*3*/ <2995,2999,2996>,<2996,2999,3000>,<2996,3000,2997>,<2997,3000,3001>,<2997,3001,2998>,
            <2998,3001,3002>,<2998,3002,2995>,<2995,3002,2999>,
    /*4*/ <2999,3003,3000>,<3000,3003,3004>,<3000,3004,3001>,<3001,3004,3005>,<3001,3005,3002>,
            <3002,3005,3006>,<3002,3006,2999>,<2999,3006,3003>,
    /*5*/ <3003,3007,3004>,<3004,3007,3005>,<3005,3007,3006>,<3006,3007,3003>

    /* stem 0c7.4*/ 
    /*0*/ <3008,3009,3010>,<3008,3010,3011>,<3008,3011,3012>,<3008,3012,3009>,
    /*1*/ <3009,3013,3010>,<3010,3013,3014>,<3010,3014,3011>,<3011,3014,3015>,<3011,3015,3012>,
            <3012,3015,3016>,<3012,3016,3009>,<3009,3016,3013>,
    /*2*/ <3013,3017,3014>,<3014,3017,3018>,<3014,3018,3015>,<3015,3018,3019>,<3015,3019,3016>,
            <3016,3019,3020>,<3016,3020,3013>,<3013,3020,3017>,
    /*3*/ <3017,3021,3018>,<3018,3021,3022>,<3018,3022,3019>,<3019,3022,3023>,<3019,3023,3020>,
            <3020,3023,3024>,<3020,3024,3017>,<3017,3024,3021>,
    /*4*/ <3021,3025,3022>,<3022,3025,3026>,<3022,3026,3023>,<3023,3026,3027>,<3023,3027,3024>,
            <3024,3027,3028>,<3024,3028,3021>,<3021,3028,3025>,
    /*5*/ <3025,3029,3026>,<3026,3029,3027>,<3027,3029,3028>,<3028,3029,3025>

    /* stem 0c7.5*/ 
    /*0*/ <3030,3031,3032>,<3030,3032,3033>,<3030,3033,3034>,<3030,3034,3031>,
    /*1*/ <3031,3035,3032>,<3032,3035,3036>,<3032,3036,3033>,<3033,3036,3037>,<3033,3037,3034>,
            <3034,3037,3038>,<3034,3038,3031>,<3031,3038,3035>,
    /*2*/ <3035,3039,3036>,<3036,3039,3040>,<3036,3040,3037>,<3037,3040,3041>,<3037,3041,3038>,
            <3038,3041,3042>,<3038,3042,3035>,<3035,3042,3039>,
    /*3*/ <3039,3043,3040>,<3040,3043,3044>,<3040,3044,3041>,<3041,3044,3045>,<3041,3045,3042>,
            <3042,3045,3046>,<3042,3046,3039>,<3039,3046,3043>,
    /*4*/ <3043,3047,3044>,<3044,3047,3048>,<3044,3048,3045>,<3045,3048,3049>,<3045,3049,3046>,
            <3046,3049,3050>,<3046,3050,3043>,<3043,3050,3047>,
    /*5*/ <3047,3051,3048>,<3048,3051,3049>,<3049,3051,3050>,<3050,3051,3047>

    /* stem 0c7.6*/ 
    /*0*/ <3052,3053,3054>,<3052,3054,3055>,<3052,3055,3056>,<3052,3056,3053>,
    /*1*/ <3053,3057,3054>,<3054,3057,3058>,<3054,3058,3055>,<3055,3058,3059>,<3055,3059,3056>,
            <3056,3059,3060>,<3056,3060,3053>,<3053,3060,3057>,
    /*2*/ <3057,3061,3058>,<3058,3061,3062>,<3058,3062,3059>,<3059,3062,3063>,<3059,3063,3060>,
            <3060,3063,3064>,<3060,3064,3057>,<3057,3064,3061>,
    /*3*/ <3061,3065,3062>,<3062,3065,3066>,<3062,3066,3063>,<3063,3066,3067>,<3063,3067,3064>,
            <3064,3067,3068>,<3064,3068,3061>,<3061,3068,3065>,
    /*4*/ <3065,3069,3066>,<3066,3069,3070>,<3066,3070,3067>,<3067,3070,3071>,<3067,3071,3068>,
            <3068,3071,3072>,<3068,3072,3065>,<3065,3072,3069>,
    /*5*/ <3069,3073,3070>,<3070,3073,3071>,<3071,3073,3072>,<3072,3073,3069>

    /* stem 0c7.7*/ 
    /*0*/ <3074,3075,3076>,<3074,3076,3077>,<3074,3077,3078>,<3074,3078,3075>,
    /*1*/ <3075,3079,3076>,<3076,3079,3080>,<3076,3080,3077>,<3077,3080,3081>,<3077,3081,3078>,
            <3078,3081,3082>,<3078,3082,3075>,<3075,3082,3079>,
    /*2*/ <3079,3083,3080>,<3080,3083,3084>,<3080,3084,3081>,<3081,3084,3085>,<3081,3085,3082>,
            <3082,3085,3086>,<3082,3086,3079>,<3079,3086,3083>,
    /*3*/ <3083,3087,3084>,<3084,3087,3088>,<3084,3088,3085>,<3085,3088,3089>,<3085,3089,3086>,
            <3086,3089,3090>,<3086,3090,3083>,<3083,3090,3087>,
    /*4*/ <3087,3091,3088>,<3088,3091,3092>,<3088,3092,3089>,<3089,3092,3093>,<3089,3093,3090>,
            <3090,3093,3094>,<3090,3094,3087>,<3087,3094,3091>,
    /*5*/ <3091,3095,3092>,<3092,3095,3093>,<3093,3095,3094>,<3094,3095,3091>

    /* stem 0c7.8*/ 
    /*0*/ <3096,3097,3098>,<3096,3098,3099>,<3096,3099,3100>,<3096,3100,3097>,
    /*1*/ <3097,3101,3098>,<3098,3101,3102>,<3098,3102,3099>,<3099,3102,3103>,<3099,3103,3100>,
            <3100,3103,3104>,<3100,3104,3097>,<3097,3104,3101>,
    /*2*/ <3101,3105,3102>,<3102,3105,3106>,<3102,3106,3103>,<3103,3106,3107>,<3103,3107,3104>,
            <3104,3107,3108>,<3104,3108,3101>,<3101,3108,3105>,
    /*3*/ <3105,3109,3106>,<3106,3109,3110>,<3106,3110,3107>,<3107,3110,3111>,<3107,3111,3108>,
            <3108,3111,3112>,<3108,3112,3105>,<3105,3112,3109>,
    /*4*/ <3109,3113,3110>,<3110,3113,3114>,<3110,3114,3111>,<3111,3114,3115>,<3111,3115,3112>,
            <3112,3115,3116>,<3112,3116,3109>,<3109,3116,3113>,
    /*5*/ <3113,3117,3114>,<3114,3117,3115>,<3115,3117,3116>,<3116,3117,3113>

    /* stem 0c7.9*/ 
    /*0*/ <3118,3119,3120>,<3118,3120,3121>,<3118,3121,3122>,<3118,3122,3119>,
    /*1*/ <3119,3123,3120>,<3120,3123,3124>,<3120,3124,3121>,<3121,3124,3125>,<3121,3125,3122>,
            <3122,3125,3126>,<3122,3126,3119>,<3119,3126,3123>,
    /*2*/ <3123,3127,3124>,<3124,3127,3128>,<3124,3128,3125>,<3125,3128,3129>,<3125,3129,3126>,
            <3126,3129,3130>,<3126,3130,3123>,<3123,3130,3127>,
    /*3*/ <3127,3131,3128>,<3128,3131,3132>,<3128,3132,3129>,<3129,3132,3133>,<3129,3133,3130>,
            <3130,3133,3134>,<3130,3134,3127>,<3127,3134,3131>,
    /*4*/ <3131,3135,3132>,<3132,3135,3136>,<3132,3136,3133>,<3133,3136,3137>,<3133,3137,3134>,
            <3134,3137,3138>,<3134,3138,3131>,<3131,3138,3135>,
    /*5*/ <3135,3139,3136>,<3136,3139,3137>,<3137,3139,3138>,<3138,3139,3135>

    /* stem 0c7.10*/ 
    /*0*/ <3140,3141,3142>,<3140,3142,3143>,<3140,3143,3144>,<3140,3144,3141>,
    /*1*/ <3141,3145,3142>,<3142,3145,3146>,<3142,3146,3143>,<3143,3146,3147>,<3143,3147,3144>,
            <3144,3147,3148>,<3144,3148,3141>,<3141,3148,3145>,
    /*2*/ <3145,3149,3146>,<3146,3149,3150>,<3146,3150,3147>,<3147,3150,3151>,<3147,3151,3148>,
            <3148,3151,3152>,<3148,3152,3145>,<3145,3152,3149>,
    /*3*/ <3149,3153,3150>,<3150,3153,3154>,<3150,3154,3151>,<3151,3154,3155>,<3151,3155,3152>,
            <3152,3155,3156>,<3152,3156,3149>,<3149,3156,3153>,
    /*4*/ <3153,3157,3154>,<3154,3157,3158>,<3154,3158,3155>,<3155,3158,3159>,<3155,3159,3156>,
            <3156,3159,3160>,<3156,3160,3153>,<3153,3160,3157>,
    /*5*/ <3157,3161,3158>,<3158,3161,3159>,<3159,3161,3160>,<3160,3161,3157>

    /* stem 0c7.11*/ 
    /*0*/ <3162,3163,3164>,<3162,3164,3165>,<3162,3165,3166>,<3162,3166,3163>,
    /*1*/ <3163,3167,3164>,<3164,3167,3168>,<3164,3168,3165>,<3165,3168,3169>,<3165,3169,3166>,
            <3166,3169,3170>,<3166,3170,3163>,<3163,3170,3167>,
    /*2*/ <3167,3171,3168>,<3168,3171,3172>,<3168,3172,3169>,<3169,3172,3173>,<3169,3173,3170>,
            <3170,3173,3174>,<3170,3174,3167>,<3167,3174,3171>,
    /*3*/ <3171,3175,3172>,<3172,3175,3176>,<3172,3176,3173>,<3173,3176,3177>,<3173,3177,3174>,
            <3174,3177,3178>,<3174,3178,3171>,<3171,3178,3175>,
    /*4*/ <3175,3179,3176>,<3176,3179,3180>,<3176,3180,3177>,<3177,3180,3181>,<3177,3181,3178>,
            <3178,3181,3182>,<3178,3182,3175>,<3175,3182,3179>,
    /*5*/ <3179,3183,3180>,<3180,3183,3181>,<3181,3183,3182>,<3182,3183,3179>

    /* stem 0c7.12*/ 
    /*0*/ <3184,3185,3186>,<3184,3186,3187>,<3184,3187,3188>,<3184,3188,3185>,
    /*1*/ <3185,3189,3186>,<3186,3189,3190>,<3186,3190,3187>,<3187,3190,3191>,<3187,3191,3188>,
            <3188,3191,3192>,<3188,3192,3185>,<3185,3192,3189>,
    /*2*/ <3189,3193,3190>,<3190,3193,3194>,<3190,3194,3191>,<3191,3194,3195>,<3191,3195,3192>,
            <3192,3195,3196>,<3192,3196,3189>,<3189,3196,3193>,
    /*3*/ <3193,3197,3194>,<3194,3197,3198>,<3194,3198,3195>,<3195,3198,3199>,<3195,3199,3196>,
            <3196,3199,3200>,<3196,3200,3193>,<3193,3200,3197>,
    /*4*/ <3197,3201,3198>,<3198,3201,3202>,<3198,3202,3199>,<3199,3202,3203>,<3199,3203,3200>,
            <3200,3203,3204>,<3200,3204,3197>,<3197,3204,3201>,
    /*5*/ <3201,3205,3202>,<3202,3205,3203>,<3203,3205,3204>,<3204,3205,3201>

    /* stem 0c7.13*/ 
    /*0*/ <3206,3207,3208>,<3206,3208,3209>,<3206,3209,3210>,<3206,3210,3207>,
    /*1*/ <3207,3211,3208>,<3208,3211,3212>,<3208,3212,3209>,<3209,3212,3213>,<3209,3213,3210>,
            <3210,3213,3214>,<3210,3214,3207>,<3207,3214,3211>,
    /*2*/ <3211,3215,3212>,<3212,3215,3216>,<3212,3216,3213>,<3213,3216,3217>,<3213,3217,3214>,
            <3214,3217,3218>,<3214,3218,3211>,<3211,3218,3215>,
    /*3*/ <3215,3219,3216>,<3216,3219,3220>,<3216,3220,3217>,<3217,3220,3221>,<3217,3221,3218>,
            <3218,3221,3222>,<3218,3222,3215>,<3215,3222,3219>,
    /*4*/ <3219,3223,3220>,<3220,3223,3224>,<3220,3224,3221>,<3221,3224,3225>,<3221,3225,3222>,
            <3222,3225,3226>,<3222,3226,3219>,<3219,3226,3223>,
    /*5*/ <3223,3227,3224>,<3224,3227,3225>,<3225,3227,3226>,<3226,3227,3223>

    /* stem 0c7.14*/ 
    /*0*/ <3228,3229,3230>,<3228,3230,3231>,<3228,3231,3232>,<3228,3232,3229>,
    /*1*/ <3229,3233,3230>,<3230,3233,3234>,<3230,3234,3231>,<3231,3234,3235>,<3231,3235,3232>,
            <3232,3235,3236>,<3232,3236,3229>,<3229,3236,3233>,
    /*2*/ <3233,3237,3234>,<3234,3237,3238>,<3234,3238,3235>,<3235,3238,3239>,<3235,3239,3236>,
            <3236,3239,3240>,<3236,3240,3233>,<3233,3240,3237>,
    /*3*/ <3237,3241,3238>,<3238,3241,3242>,<3238,3242,3239>,<3239,3242,3243>,<3239,3243,3240>,
            <3240,3243,3244>,<3240,3244,3237>,<3237,3244,3241>,
    /*4*/ <3241,3245,3242>,<3242,3245,3246>,<3242,3246,3243>,<3243,3246,3247>,<3243,3247,3244>,
            <3244,3247,3248>,<3244,3248,3241>,<3241,3248,3245>,
    /*5*/ <3245,3249,3246>,<3246,3249,3247>,<3247,3249,3248>,<3248,3249,3245>

    /* stem 0c7.15*/ 
    /*0*/ <3250,3251,3252>,<3250,3252,3253>,<3250,3253,3254>,<3250,3254,3251>,
    /*1*/ <3251,3255,3252>,<3252,3255,3256>,<3252,3256,3253>,<3253,3256,3257>,<3253,3257,3254>,
            <3254,3257,3258>,<3254,3258,3251>,<3251,3258,3255>,
    /*2*/ <3255,3259,3256>,<3256,3259,3260>,<3256,3260,3257>,<3257,3260,3261>,<3257,3261,3258>,
            <3258,3261,3262>,<3258,3262,3255>,<3255,3262,3259>,
    /*3*/ <3259,3263,3260>,<3260,3263,3264>,<3260,3264,3261>,<3261,3264,3265>,<3261,3265,3262>,
            <3262,3265,3266>,<3262,3266,3259>,<3259,3266,3263>,
    /*4*/ <3263,3267,3264>,<3264,3267,3268>,<3264,3268,3265>,<3265,3268,3269>,<3265,3269,3266>,
            <3266,3269,3270>,<3266,3270,3263>,<3263,3270,3267>,
    /*5*/ <3267,3271,3268>,<3268,3271,3269>,<3269,3271,3270>,<3270,3271,3267>

    /* stem 0.0*/ 
    /*0*/ <3272,3273,3274>,<3272,3274,3275>,<3272,3275,3276>,<3272,3276,3273>,
    /*1*/ <3273,3277,3274>,<3274,3277,3278>,<3274,3278,3275>,<3275,3278,3279>,<3275,3279,3276>,
            <3276,3279,3280>,<3276,3280,3273>,<3273,3280,3277>,
    /*2*/ <3277,3281,3278>,<3278,3281,3282>,<3278,3282,3279>,<3279,3282,3283>,<3279,3283,3280>,
            <3280,3283,3284>,<3280,3284,3277>,<3277,3284,3281>,
    /*3*/ <3281,3285,3282>,<3282,3285,3286>,<3282,3286,3283>,<3283,3286,3287>,<3283,3287,3284>,
            <3284,3287,3288>,<3284,3288,3281>,<3281,3288,3285>,
    /*4*/ <3285,3289,3286>,<3286,3289,3290>,<3286,3290,3287>,<3287,3290,3291>,<3287,3291,3288>,
            <3288,3291,3292>,<3288,3292,3285>,<3285,3292,3289>,
    /*5*/ <3289,3293,3290>,<3290,3293,3291>,<3291,3293,3292>,<3292,3293,3289>

    /* stem 0.1*/ 
    /*0*/ <3294,3295,3296>,<3294,3296,3297>,<3294,3297,3298>,<3294,3298,3295>,
    /*1*/ <3295,3299,3296>,<3296,3299,3300>,<3296,3300,3297>,<3297,3300,3301>,<3297,3301,3298>,
            <3298,3301,3302>,<3298,3302,3295>,<3295,3302,3299>,
    /*2*/ <3299,3303,3300>,<3300,3303,3304>,<3300,3304,3301>,<3301,3304,3305>,<3301,3305,3302>,
            <3302,3305,3306>,<3302,3306,3299>,<3299,3306,3303>,
    /*3*/ <3303,3307,3304>,<3304,3307,3308>,<3304,3308,3305>,<3305,3308,3309>,<3305,3309,3306>,
            <3306,3309,3310>,<3306,3310,3303>,<3303,3310,3307>,
    /*4*/ <3307,3311,3308>,<3308,3311,3312>,<3308,3312,3309>,<3309,3312,3313>,<3309,3313,3310>,
            <3310,3313,3314>,<3310,3314,3307>,<3307,3314,3311>,
    /*5*/ <3311,3315,3312>,<3312,3315,3313>,<3313,3315,3314>,<3314,3315,3311>

    /* stem 0.2*/ 
    /*0*/ <3316,3317,3318>,<3316,3318,3319>,<3316,3319,3320>,<3316,3320,3317>,
    /*1*/ <3317,3321,3318>,<3318,3321,3322>,<3318,3322,3319>,<3319,3322,3323>,<3319,3323,3320>,
            <3320,3323,3324>,<3320,3324,3317>,<3317,3324,3321>,
    /*2*/ <3321,3325,3322>,<3322,3325,3326>,<3322,3326,3323>,<3323,3326,3327>,<3323,3327,3324>,
            <3324,3327,3328>,<3324,3328,3321>,<3321,3328,3325>,
    /*3*/ <3325,3329,3326>,<3326,3329,3330>,<3326,3330,3327>,<3327,3330,3331>,<3327,3331,3328>,
            <3328,3331,3332>,<3328,3332,3325>,<3325,3332,3329>,
    /*4*/ <3329,3333,3330>,<3330,3333,3334>,<3330,3334,3331>,<3331,3334,3335>,<3331,3335,3332>,
            <3332,3335,3336>,<3332,3336,3329>,<3329,3336,3333>,
    /*5*/ <3333,3337,3334>,<3334,3337,3335>,<3335,3337,3336>,<3336,3337,3333>

    /* stem 0.3*/ 
    /*0*/ <3338,3339,3340>,<3338,3340,3341>,<3338,3341,3342>,<3338,3342,3339>,
    /*1*/ <3339,3343,3340>,<3340,3343,3344>,<3340,3344,3341>,<3341,3344,3345>,<3341,3345,3342>,
            <3342,3345,3346>,<3342,3346,3339>,<3339,3346,3343>,
    /*2*/ <3343,3347,3344>,<3344,3347,3348>,<3344,3348,3345>,<3345,3348,3349>,<3345,3349,3346>,
            <3346,3349,3350>,<3346,3350,3343>,<3343,3350,3347>,
    /*3*/ <3347,3351,3348>,<3348,3351,3352>,<3348,3352,3349>,<3349,3352,3353>,<3349,3353,3350>,
            <3350,3353,3354>,<3350,3354,3347>,<3347,3354,3351>,
    /*4*/ <3351,3355,3352>,<3352,3355,3356>,<3352,3356,3353>,<3353,3356,3357>,<3353,3357,3354>,
            <3354,3357,3358>,<3354,3358,3351>,<3351,3358,3355>,
    /*5*/ <3355,3359,3356>,<3356,3359,3357>,<3357,3359,3358>,<3358,3359,3355>

    /* stem 0.4*/ 
    /*0*/ <3360,3361,3362>,<3360,3362,3363>,<3360,3363,3364>,<3360,3364,3361>,
    /*1*/ <3361,3365,3362>,<3362,3365,3366>,<3362,3366,3363>,<3363,3366,3367>,<3363,3367,3364>,
            <3364,3367,3368>,<3364,3368,3361>,<3361,3368,3365>,
    /*2*/ <3365,3369,3366>,<3366,3369,3370>,<3366,3370,3367>,<3367,3370,3371>,<3367,3371,3368>,
            <3368,3371,3372>,<3368,3372,3365>,<3365,3372,3369>,
    /*3*/ <3369,3373,3370>,<3370,3373,3374>,<3370,3374,3371>,<3371,3374,3375>,<3371,3375,3372>,
            <3372,3375,3376>,<3372,3376,3369>,<3369,3376,3373>,
    /*4*/ <3373,3377,3374>,<3374,3377,3378>,<3374,3378,3375>,<3375,3378,3379>,<3375,3379,3376>,
            <3376,3379,3380>,<3376,3380,3373>,<3373,3380,3377>,
    /*5*/ <3377,3381,3378>,<3378,3381,3379>,<3379,3381,3380>,<3380,3381,3377>

    /* stem 0.5*/ 
    /*0*/ <3382,3383,3384>,<3382,3384,3385>,<3382,3385,3386>,<3382,3386,3383>,
    /*1*/ <3383,3387,3384>,<3384,3387,3388>,<3384,3388,3385>,<3385,3388,3389>,<3385,3389,3386>,
            <3386,3389,3390>,<3386,3390,3383>,<3383,3390,3387>,
    /*2*/ <3387,3391,3388>,<3388,3391,3392>,<3388,3392,3389>,<3389,3392,3393>,<3389,3393,3390>,
            <3390,3393,3394>,<3390,3394,3387>,<3387,3394,3391>,
    /*3*/ <3391,3395,3392>,<3392,3395,3396>,<3392,3396,3393>,<3393,3396,3397>,<3393,3397,3394>,
            <3394,3397,3398>,<3394,3398,3391>,<3391,3398,3395>,
    /*4*/ <3395,3399,3396>,<3396,3399,3400>,<3396,3400,3397>,<3397,3400,3401>,<3397,3401,3398>,
            <3398,3401,3402>,<3398,3402,3395>,<3395,3402,3399>,
    /*5*/ <3399,3403,3400>,<3400,3403,3401>,<3401,3403,3402>,<3402,3403,3399>

    /* stem 0.6*/ 
    /*0*/ <3404,3405,3406>,<3404,3406,3407>,<3404,3407,3408>,<3404,3408,3405>,
    /*1*/ <3405,3409,3406>,<3406,3409,3410>,<3406,3410,3407>,<3407,3410,3411>,<3407,3411,3408>,
            <3408,3411,3412>,<3408,3412,3405>,<3405,3412,3409>,
    /*2*/ <3409,3413,3410>,<3410,3413,3414>,<3410,3414,3411>,<3411,3414,3415>,<3411,3415,3412>,
            <3412,3415,3416>,<3412,3416,3409>,<3409,3416,3413>,
    /*3*/ <3413,3417,3414>,<3414,3417,3418>,<3414,3418,3415>,<3415,3418,3419>,<3415,3419,3416>,
            <3416,3419,3420>,<3416,3420,3413>,<3413,3420,3417>,
    /*4*/ <3417,3421,3418>,<3418,3421,3422>,<3418,3422,3419>,<3419,3422,3423>,<3419,3423,3420>,
            <3420,3423,3424>,<3420,3424,3417>,<3417,3424,3421>,
    /*5*/ <3421,3425,3422>,<3422,3425,3423>,<3423,3425,3424>,<3424,3425,3421>

    /* stem 0.7*/ 
    /*0*/ <3426,3427,3428>,<3426,3428,3429>,<3426,3429,3430>,<3426,3430,3427>,
    /*1*/ <3427,3431,3428>,<3428,3431,3432>,<3428,3432,3429>,<3429,3432,3433>,<3429,3433,3430>,
            <3430,3433,3434>,<3430,3434,3427>,<3427,3434,3431>,
    /*2*/ <3431,3435,3432>,<3432,3435,3436>,<3432,3436,3433>,<3433,3436,3437>,<3433,3437,3434>,
            <3434,3437,3438>,<3434,3438,3431>,<3431,3438,3435>,
    /*3*/ <3435,3439,3436>,<3436,3439,3440>,<3436,3440,3437>,<3437,3440,3441>,<3437,3441,3438>,
            <3438,3441,3442>,<3438,3442,3435>,<3435,3442,3439>,
    /*4*/ <3439,3443,3440>,<3440,3443,3444>,<3440,3444,3441>,<3441,3444,3445>,<3441,3445,3442>,
            <3442,3445,3446>,<3442,3446,3439>,<3439,3446,3443>,
    /*5*/ <3443,3447,3444>,<3444,3447,3445>,<3445,3447,3446>,<3446,3447,3443>

    /* stem 0.8*/ 
    /*0*/ <3448,3449,3450>,<3448,3450,3451>,<3448,3451,3452>,<3448,3452,3449>,
    /*1*/ <3449,3453,3450>,<3450,3453,3454>,<3450,3454,3451>,<3451,3454,3455>,<3451,3455,3452>,
            <3452,3455,3456>,<3452,3456,3449>,<3449,3456,3453>,
    /*2*/ <3453,3457,3454>,<3454,3457,3458>,<3454,3458,3455>,<3455,3458,3459>,<3455,3459,3456>,
            <3456,3459,3460>,<3456,3460,3453>,<3453,3460,3457>,
    /*3*/ <3457,3461,3458>,<3458,3461,3462>,<3458,3462,3459>,<3459,3462,3463>,<3459,3463,3460>,
            <3460,3463,3464>,<3460,3464,3457>,<3457,3464,3461>,
    /*4*/ <3461,3465,3462>,<3462,3465,3466>,<3462,3466,3463>,<3463,3466,3467>,<3463,3467,3464>,
            <3464,3467,3468>,<3464,3468,3461>,<3461,3468,3465>,
    /*5*/ <3465,3469,3466>,<3466,3469,3467>,<3467,3469,3468>,<3468,3469,3465>

    /* stem 0.9*/ 
    /*0*/ <3470,3471,3472>,<3470,3472,3473>,<3470,3473,3474>,<3470,3474,3471>,
    /*1*/ <3471,3475,3472>,<3472,3475,3476>,<3472,3476,3473>,<3473,3476,3477>,<3473,3477,3474>,
            <3474,3477,3478>,<3474,3478,3471>,<3471,3478,3475>,
    /*2*/ <3475,3479,3476>,<3476,3479,3480>,<3476,3480,3477>,<3477,3480,3481>,<3477,3481,3478>,
            <3478,3481,3482>,<3478,3482,3475>,<3475,3482,3479>,
    /*3*/ <3479,3483,3480>,<3480,3483,3484>,<3480,3484,3481>,<3481,3484,3485>,<3481,3485,3482>,
            <3482,3485,3486>,<3482,3486,3479>,<3479,3486,3483>,
    /*4*/ <3483,3487,3484>,<3484,3487,3488>,<3484,3488,3485>,<3485,3488,3489>,<3485,3489,3486>,
            <3486,3489,3490>,<3486,3490,3483>,<3483,3490,3487>,
    /*5*/ <3487,3491,3488>,<3488,3491,3489>,<3489,3491,3490>,<3490,3491,3487>

    /* stem 0.10*/ 
    /*0*/ <3492,3493,3494>,<3492,3494,3495>,<3492,3495,3496>,<3492,3496,3493>,
    /*1*/ <3493,3497,3494>,<3494,3497,3498>,<3494,3498,3495>,<3495,3498,3499>,<3495,3499,3496>,
            <3496,3499,3500>,<3496,3500,3493>,<3493,3500,3497>,
    /*2*/ <3497,3501,3498>,<3498,3501,3502>,<3498,3502,3499>,<3499,3502,3503>,<3499,3503,3500>,
            <3500,3503,3504>,<3500,3504,3497>,<3497,3504,3501>,
    /*3*/ <3501,3505,3502>,<3502,3505,3506>,<3502,3506,3503>,<3503,3506,3507>,<3503,3507,3504>,
            <3504,3507,3508>,<3504,3508,3501>,<3501,3508,3505>,
    /*4*/ <3505,3509,3506>,<3506,3509,3510>,<3506,3510,3507>,<3507,3510,3511>,<3507,3511,3508>,
            <3508,3511,3512>,<3508,3512,3505>,<3505,3512,3509>,
    /*5*/ <3509,3513,3510>,<3510,3513,3511>,<3511,3513,3512>,<3512,3513,3509>

    /* stem 0.11*/ 
    /*0*/ <3514,3515,3516>,<3514,3516,3517>,<3514,3517,3518>,<3514,3518,3515>,
    /*1*/ <3515,3519,3516>,<3516,3519,3520>,<3516,3520,3517>,<3517,3520,3521>,<3517,3521,3518>,
            <3518,3521,3522>,<3518,3522,3515>,<3515,3522,3519>,
    /*2*/ <3519,3523,3520>,<3520,3523,3524>,<3520,3524,3521>,<3521,3524,3525>,<3521,3525,3522>,
            <3522,3525,3526>,<3522,3526,3519>,<3519,3526,3523>,
    /*3*/ <3523,3527,3524>,<3524,3527,3528>,<3524,3528,3525>,<3525,3528,3529>,<3525,3529,3526>,
            <3526,3529,3530>,<3526,3530,3523>,<3523,3530,3527>,
    /*4*/ <3527,3531,3528>,<3528,3531,3532>,<3528,3532,3529>,<3529,3532,3533>,<3529,3533,3530>,
            <3530,3533,3534>,<3530,3534,3527>,<3527,3534,3531>,
    /*5*/ <3531,3535,3532>,<3532,3535,3533>,<3533,3535,3534>,<3534,3535,3531>

    /* stem 0.12*/ 
    /*0*/ <3536,3537,3538>,<3536,3538,3539>,<3536,3539,3540>,<3536,3540,3537>,
    /*1*/ <3537,3541,3538>,<3538,3541,3542>,<3538,3542,3539>,<3539,3542,3543>,<3539,3543,3540>,
            <3540,3543,3544>,<3540,3544,3537>,<3537,3544,3541>,
    /*2*/ <3541,3545,3542>,<3542,3545,3546>,<3542,3546,3543>,<3543,3546,3547>,<3543,3547,3544>,
            <3544,3547,3548>,<3544,3548,3541>,<3541,3548,3545>,
    /*3*/ <3545,3549,3546>,<3546,3549,3550>,<3546,3550,3547>,<3547,3550,3551>,<3547,3551,3548>,
            <3548,3551,3552>,<3548,3552,3545>,<3545,3552,3549>,
    /*4*/ <3549,3553,3550>,<3550,3553,3554>,<3550,3554,3551>,<3551,3554,3555>,<3551,3555,3552>,
            <3552,3555,3556>,<3552,3556,3549>,<3549,3556,3553>,
    /*5*/ <3553,3557,3554>,<3554,3557,3555>,<3555,3557,3556>,<3556,3557,3553>

    /* stem 0.13*/ 
    /*0*/ <3558,3559,3560>,<3558,3560,3561>,<3558,3561,3562>,<3558,3562,3559>,
    /*1*/ <3559,3563,3560>,<3560,3563,3564>,<3560,3564,3561>,<3561,3564,3565>,<3561,3565,3562>,
            <3562,3565,3566>,<3562,3566,3559>,<3559,3566,3563>,
    /*2*/ <3563,3567,3564>,<3564,3567,3568>,<3564,3568,3565>,<3565,3568,3569>,<3565,3569,3566>,
            <3566,3569,3570>,<3566,3570,3563>,<3563,3570,3567>,
    /*3*/ <3567,3571,3568>,<3568,3571,3572>,<3568,3572,3569>,<3569,3572,3573>,<3569,3573,3570>,
            <3570,3573,3574>,<3570,3574,3567>,<3567,3574,3571>,
    /*4*/ <3571,3575,3572>,<3572,3575,3576>,<3572,3576,3573>,<3573,3576,3577>,<3573,3577,3574>,
            <3574,3577,3578>,<3574,3578,3571>,<3571,3578,3575>,
    /*5*/ <3575,3579,3576>,<3576,3579,3577>,<3577,3579,3578>,<3578,3579,3575>

    /* stem 0.14*/ 
    /*0*/ <3580,3581,3582>,<3580,3582,3583>,<3580,3583,3584>,<3580,3584,3581>,
    /*1*/ <3581,3585,3582>,<3582,3585,3586>,<3582,3586,3583>,<3583,3586,3587>,<3583,3587,3584>,
            <3584,3587,3588>,<3584,3588,3581>,<3581,3588,3585>,
    /*2*/ <3585,3589,3586>,<3586,3589,3590>,<3586,3590,3587>,<3587,3590,3591>,<3587,3591,3588>,
            <3588,3591,3592>,<3588,3592,3585>,<3585,3592,3589>,
    /*3*/ <3589,3593,3590>,<3590,3593,3594>,<3590,3594,3591>,<3591,3594,3595>,<3591,3595,3592>,
            <3592,3595,3596>,<3592,3596,3589>,<3589,3596,3593>,
    /*4*/ <3593,3597,3594>,<3594,3597,3598>,<3594,3598,3595>,<3595,3598,3599>,<3595,3599,3596>,
            <3596,3599,3600>,<3596,3600,3593>,<3593,3600,3597>,
    /*5*/ <3597,3601,3598>,<3598,3601,3599>,<3599,3601,3600>,<3600,3601,3597>

    /* stem 0.15*/ 
    /*0*/ <3602,3603,3604>,<3602,3604,3605>,<3602,3605,3606>,<3602,3606,3603>,
    /*1*/ <3603,3607,3604>,<3604,3607,3608>,<3604,3608,3605>,<3605,3608,3609>,<3605,3609,3606>,
            <3606,3609,3610>,<3606,3610,3603>,<3603,3610,3607>,
    /*2*/ <3607,3611,3608>,<3608,3611,3612>,<3608,3612,3609>,<3609,3612,3613>,<3609,3613,3610>,
            <3610,3613,3614>,<3610,3614,3607>,<3607,3614,3611>,
    /*3*/ <3611,3615,3612>,<3612,3615,3616>,<3612,3616,3613>,<3613,3616,3617>,<3613,3617,3614>,
            <3614,3617,3618>,<3614,3618,3611>,<3611,3618,3615>,
    /*4*/ <3615,3619,3616>,<3616,3619,3620>,<3616,3620,3617>,<3617,3620,3621>,<3617,3621,3618>,
            <3618,3621,3622>,<3618,3622,3615>,<3615,3622,3619>,
    /*5*/ <3619,3623,3620>,<3620,3623,3621>,<3621,3623,3622>,<3622,3623,3619>

    /* stem 0.16*/ 
    /*0*/ <3624,3625,3626>,<3624,3626,3627>,<3624,3627,3628>,<3624,3628,3625>,
    /*1*/ <3625,3629,3626>,<3626,3629,3630>,<3626,3630,3627>,<3627,3630,3631>,<3627,3631,3628>,
            <3628,3631,3632>,<3628,3632,3625>,<3625,3632,3629>,
    /*2*/ <3629,3633,3630>,<3630,3633,3634>,<3630,3634,3631>,<3631,3634,3635>,<3631,3635,3632>,
            <3632,3635,3636>,<3632,3636,3629>,<3629,3636,3633>,
    /*3*/ <3633,3637,3634>,<3634,3637,3638>,<3634,3638,3635>,<3635,3638,3639>,<3635,3639,3636>,
            <3636,3639,3640>,<3636,3640,3633>,<3633,3640,3637>,
    /*4*/ <3637,3641,3638>,<3638,3641,3642>,<3638,3642,3639>,<3639,3642,3643>,<3639,3643,3640>,
            <3640,3643,3644>,<3640,3644,3637>,<3637,3644,3641>,
    /*5*/ <3641,3645,3642>,<3642,3645,3643>,<3643,3645,3644>,<3644,3645,3641>

    }
  }
#declare moss_13_leaves = mesh2 {
     vertex_vectors { 7192
<0.00586,0.24082,-0.11315>,<0.01833,0.24307,-0.11424>,<0.04739,0.25119,-0.11564>,
              <0.07484,0.26334,-0.11519>,<0.08471,0.27217,-0.11325>,<0.07148,0.27181,-0.11129>,
              <0.04318,0.26179,-0.11076>,<0.01648,0.24775,-0.11209><0.14675,0.23079,-0.16113>,<0.14464,0.24326,-0.16257>,<0.13735,0.27208,-0.16787>,
              <0.12672,0.29899,-0.17591>,<0.11919,0.30833,-0.18181>,<0.11973,0.29497,-0.18165>,
              <0.12859,0.26705,-0.17507>,<0.14078,0.24104,-0.16574><0.07055,0.32787,-0.29746>,<0.08283,0.32554,-0.29511>,<0.11229,0.323,-0.28897>,
              <0.14145,0.32511,-0.28213>,<0.15325,0.33036,-0.27862>,<0.14082,0.33488,-0.28064>,
              <0.1115,0.33523,-0.28711>,<0.08248,0.33093,-0.29429><0.22597,0.28474,-0.27561>,<0.21773,0.2937,-0.27932>,<0.19621,0.31269,-0.28872>,
              <0.17225,0.32771,-0.29881>,<0.16002,0.3302,-0.30363>,<0.16711,0.31937,-0.30025>,
              <0.18977,0.30224,-0.29052>,<0.21489,0.28909,-0.28011><0.11383,0.2791,-0.40788>,<0.12435,0.28319,-0.40201>,<0.14813,0.29574,-0.38827>,
              <0.16949,0.31227,-0.37515>,<0.17605,0.32288,-0.37031>,<0.16439,0.32066,-0.37647>,
              <0.14174,0.30624,-0.38992>,<0.12153,0.28782,-0.40274><0.01131,0.27817,-0.09519>,<0.02202,0.27848,-0.08834>,<0.04861,0.28107,-0.07424>,
              <0.07625,0.28642,-0.06381>,<0.0887,0.29124,-0.06294>,<0.07848,0.29223,-0.07152>,
              <0.0514,0.28834,-0.08389>,<0.02326,0.28169,-0.09259><0.12148,0.29715,0.04044>,<0.13202,0.29925,0.03363>,<0.15734,0.30121,0.01727>,
              <0.18246,0.29846,0.00106>,<0.19268,0.29289,-0.00553>,<0.18205,0.28857,0.00135>,
              <0.15683,0.28882,0.01764>,<0.1318,0.29379,0.03379><0.22834,0.23376,-0.03126>,<0.23029,0.23975,-0.02021>,<0.23658,0.25599,0.00447>,
              <0.24528,0.27491,0.0261>,<0.25115,0.28526,0.0322>,<0.25034,0.28054,0.01971>,
              <0.24291,0.26304,-0.00354>,<0.23308,0.24286,-0.02374><0.25567,0.28852,0.13794>,<0.26533,0.28678,0.12983>,<0.28697,0.27996,0.10991>,
              <0.30609,0.26917,0.08942>,<0.31165,0.26099,0.08042>,<0.30082,0.26087,0.08827>,
              <0.28036,0.26956,0.10846>,<0.26242,0.2822,0.1292><0.10904,0.33514,-0.14075>,<0.09928,0.33341,-0.13278>,<0.07646,0.33223,-0.11303>,
              <0.05477,0.33557,-0.09254>,<0.04683,0.34121,-0.08336>,<0.05712,0.34507,-0.091>,
              <0.07941,0.34412,-0.11109>,<0.10058,0.33865,-0.13192><0.10889,0.31788,-0.06335>,<0.09818,0.32267,-0.06826>,<0.07126,0.33258,-0.0777>,
              <0.04273,0.33995,-0.08349>,<0.02942,0.34064,-0.08246>,<0.03937,0.33466,-0.07583>,
              <0.06705,0.32594,-0.06811>,<0.09632,0.31975,-0.06403><-0.0011,0.30357,-0.13978>,<-0.01013,0.30559,-0.13106>,<-0.03011,0.31297,-0.10964>,
              <-0.04732,0.32414,-0.08772>,<-0.05185,0.33233,-0.07816>,<-0.04151,0.33209,-0.08665>,
              <-0.02284,0.32293,-0.1083>,<-0.00692,0.30998,-0.13046><-0.18768,0.26827,-0.11178>,<-0.18053,0.2765,-0.10522>,<-0.16114,0.29438,-0.09051>,
              <-0.13853,0.30924,-0.07749>,<-0.12614,0.31257,-0.07369>,<-0.13178,0.30293,-0.08105>,
              <-0.15268,0.28647,-0.09497>,<-0.17681,0.27302,-0.10718><-0.18771,0.27286,0.01589>,<-0.18842,0.27067,0.00338>,<-0.19187,0.26796,-0.0265>,
              <-0.19795,0.26914,-0.05588>,<-0.20294,0.27327,-0.06758>,<-0.20348,0.27729,-0.05483>,
              <-0.19879,0.27817,-0.02519>,<-0.19147,0.27517,0.00396><0.05593,0.43147,-0.09668>,<0.06412,0.42174,-0.09627>,<0.08508,0.40003,-0.09755>,
              <0.10784,0.38102,-0.10227>,<0.11895,0.37568,-0.10745>,<0.11161,0.38667,-0.10947>,
              <0.0898,0.40711,-0.10658>,<0.0662,0.42486,-0.10025><0.11791,0.4058,-0.05712>,<0.12261,0.39994,-0.06739>,<0.13215,0.38358,-0.09091>,
              <0.13896,0.36388,-0.11252>,<0.13921,0.35258,-0.11968>,<0.13322,0.35687,-0.10851>,
              <0.12497,0.3748,-0.08589>,<0.11945,0.39607,-0.06517><0.12648,0.30601,-0.17844>,<0.13612,0.29965,-0.17312>,<0.16089,0.28623,-0.16223>,
              <0.18788,0.27577,-0.15427>,<0.20116,0.2742,-0.15372>,<0.19256,0.28196,-0.16042>,
              <0.16675,0.29399,-0.16994>,<0.13871,0.30307,-0.17652><0.19347,0.2352,-0.08816>,<0.20054,0.23396,-0.09868>,<0.21478,0.22993,-0.125>,
              <0.22481,0.22434,-0.15274>,<0.22499,0.22056,-0.16557>,<0.21595,0.22107,-0.15573>,
              <0.20369,0.22583,-0.12874>,<0.19564,0.23216,-0.10033><0.15904,0.19808,-0.19589>,<0.16985,0.19488,-0.18999>,<0.19692,0.18773,-0.17866>,
              <0.22545,0.18144,-0.17174>,<0.23864,0.17964,-0.17301>,<0.22852,0.18324,-0.18098>,
              <0.20077,0.18999,-0.19024>,<0.17155,0.19588,-0.19509><0.21349,0.1125,-0.10288>,<0.22065,0.11564,-0.11291>,<0.2351,0.12288,-0.13842>,
              <0.24527,0.12961,-0.16586>,<0.24546,0.13192,-0.17904>,<0.23629,0.12854,-0.1699>,
              <0.22385,0.12154,-0.14349>,<0.21569,0.11505,-0.11515><0.08044,0.39336,-0.16639>,<0.08401,0.39728,-0.15482>,<0.09346,0.40916,-0.12871>,
              <0.10416,0.42466,-0.10534>,<0.10978,0.4345,-0.09822>,<0.10681,0.43229,-0.11108>,
              <0.09677,0.41871,-0.1359>,<0.08547,0.40149,-0.15799><0.06781,0.43693,0.05628>,<0.07603,0.44648,0.05451>,<0.09774,0.46701,0.05011>,
              <0.12224,0.48375,0.04553>,<0.13502,0.48712,0.04346>,<0.12811,0.47578,0.04514>,
              <0.10509,0.45704,0.04963>,<0.07927,0.44208,0.0543><0.20291,0.43736,0.10113>,<0.19244,0.4431,0.10554>,<0.16898,0.45937,0.11538>,
              <0.14825,0.4793,0.12401>,<0.14222,0.49099,0.12644>,<0.15397,0.48697,0.12146>,
              <0.17615,0.46898,0.11219>,<0.1956,0.44733,0.10414><0.06826,0.45009,0.14152>,<0.07803,0.45822,0.14224>,<0.103,0.47517,0.14306>,
              <0.13008,0.48815,0.14248>,<0.14326,0.48977,0.14092>,<0.13448,0.47978,0.13953>,
              <0.10852,0.46469,0.13937>,<0.08046,0.45359,0.14062><0.21148,0.42585,0.17118>,<0.20024,0.43128,0.17363>,<0.17501,0.44686,0.17939>,
              <0.15269,0.46615,0.18494>,<0.14616,0.47764,0.18704>,<0.15877,0.47396,0.1845>,
              <0.18263,0.45663,0.17884>,<0.20359,0.43559,0.17339><0.15617,0.52127,-0.15698>,<0.14797,0.51266,-0.15247>,<0.12782,0.49423,-0.13956>,
              <0.10714,0.4794,-0.12363>,<0.09807,0.47662,-0.1142>,<0.10602,0.48692,-0.1173>,
              <0.12642,0.50366,-0.13162>,<0.14735,0.51681,-0.14897><0.11574,0.47641,-0.12294>,<0.10397,0.47198,-0.12488>,<0.0767,0.45927,-0.12748>,
              <0.05115,0.44349,-0.12693>,<0.04219,0.43409,-0.12374>,<0.05477,0.43708,-0.12031>,
              <0.08123,0.45123,-0.11919>,<0.10597,0.46844,-0.12123><0.08471,0.44809,-0.15675>,<0.07496,0.44027,-0.1544>,<0.05106,0.42358,-0.14651>,
              <0.02663,0.41019,-0.13529>,<0.01602,0.40775,-0.12752>,<0.02553,0.41713,-0.12831>,
              <0.04967,0.43227,-0.13776>,<0.07435,0.4441,-0.15055><-0.06554,0.32197,-0.21106>,<-0.06398,0.32409,-0.19861>,<-0.05731,0.3284,-0.16948>,
              <-0.04629,0.3315,-0.14172>,<-0.03764,0.33165,-0.13151>,<-0.03717,0.32897,-0.14461>,
              <-0.04588,0.32522,-0.1731>,<-0.05894,0.32269,-0.20021><-0.04383,0.22517,-0.04646>,<-0.04497,0.22699,-0.059>,<-0.05053,0.23227,-0.08821>,
              <-0.06032,0.23892,-0.11581>,<-0.06833,0.24296,-0.12573>,<-0.06917,0.24179,-0.11243>,
              <-0.06163,0.23586,-0.08398>,<-0.04987,0.22857,-0.05713><0.09863,0.63117,-0.11088>,<0.10169,0.61883,-0.11138>,<0.1109,0.59027,-0.11483>,
              <0.12284,0.56358,-0.12165>,<0.13035,0.55427,-0.12764>,<0.12857,0.56748,-0.12872>,
              <0.11808,0.59516,-0.12369>,<0.10486,0.62098,-0.11529><0.14991,0.58802,-0.10151>,<0.14931,0.57842,-0.10984>,<0.14639,0.55407,-0.12746>,
              <0.14126,0.52792,-0.14131>,<0.13707,0.51541,-0.14351>,<0.13663,0.52417,-0.1334>,
              <0.14059,0.54936,-0.11756>,<0.14675,0.57635,-0.10548><0.09537,0.52232,-0.17346>,<0.10074,0.51116,-0.17056>,<0.11558,0.48528,-0.16585>,
              <0.1332,0.461,-0.1646>,<0.14311,0.45244,-0.16733>,<0.13904,0.46436,-0.17185>,
              <0.1229,0.48949,-0.17494>,<0.10397,0.51301,-0.17456><0.15003,0.4699,-0.11436>,<0.15192,0.46183,-0.12402>,<0.15334,0.4424,-0.14709>,
              <0.15007,0.42303,-0.1698>,<0.14429,0.41505,-0.17885>,<0.14019,0.42314,-0.16902>,
              <0.14098,0.44255,-0.14611>,<0.14647,0.4619,-0.12359><0.06897,0.39766,-0.16601>,<0.07997,0.39126,-0.16625>,<0.10589,0.3762,-0.16988>,
              <0.13087,0.36171,-0.17811>,<0.14033,0.35624,-0.18582>,<0.12889,0.3629,-0.18773>,
              <0.10341,0.37769,-0.18195>,<0.07887,0.39192,-0.17157><0.14159,0.25217,-0.10083>,<0.14201,0.25475,-0.11329>,<0.14004,0.26153,-0.14265>,
              <0.13353,0.26916,-0.17095>,<0.1266,0.27311,-0.18168>,<0.12405,0.27094,-0.16873>,
              <0.12815,0.26376,-0.13987>,<0.13678,0.25573,-0.11206><0.14513,0.5665,-0.1418>,<0.14627,0.57786,-0.13618>,<0.14915,0.60602,-0.12565>,
              <0.15218,0.6353,-0.11971>,<0.15358,0.64847,-0.12156>,<0.15251,0.63763,-0.12933>,
              <0.14957,0.60895,-0.1377>,<0.14646,0.57915,-0.14149><0.1455,0.62118,-0.05041>,<0.14707,0.63121,-0.05808>,<0.15336,0.65365,-0.07728>,
              <0.16341,0.67343,-0.09751>,<0.17111,0.67913,-0.10685>,<0.1713,0.66785,-0.09966>,
              <0.16325,0.64666,-0.07998>,<0.15143,0.62812,-0.05927><0.2136,0.62557,-0.12517>,<0.20925,0.6354,-0.11836>,<0.1986,0.66023,-0.10486>,
              <0.18773,0.6867,-0.09578>,<0.18304,0.69922,-0.09617>,<0.1873,0.69017,-0.10505>,
              <0.19805,0.66457,-0.11647>,<0.20901,0.63731,-0.12348><0.18599,0.71453,0.00587>,<0.18834,0.72153,-0.00449>,<0.19619,0.7362,-0.02969>,
              <0.20735,0.74751,-0.05517>,<0.21507,0.74904,-0.06598>,<0.21428,0.74046,-0.05575>,
              <0.20487,0.72737,-0.03042>,<0.19216,0.71764,-0.00481><0.30925,0.74755,-0.07708>,<0.29991,0.7509,-0.06911>,<0.2768,0.76078,-0.05238>,
              <0.25281,0.77336,-0.03941>,<0.24207,0.78111,-0.03758>,<0.25099,0.77903,-0.04732>,
              <0.27452,0.76788,-0.06229>,<0.29891,0.75403,-0.07348><0.21076,0.79891,0.05074>,<0.21647,0.80073,0.03952>,<0.23143,0.80237,0.01333>,
              <0.24813,0.79984,-0.01149>,<0.25668,0.79487,-0.0205>,<0.25179,0.79109,-0.00864>,
              <0.23601,0.79141,0.01691>,<0.21849,0.7959,0.04109><0.17286,0.60034,-0.18772>,<0.16667,0.60832,-0.17998>,<0.15419,0.6293,-0.16219>,
              <0.14543,0.65285,-0.14577>,<0.14528,0.66504,-0.14025>,<0.1532,0.65827,-0.14863>,
              <0.16394,0.63608,-0.16578>,<0.17097,0.61131,-0.18156><0.1656,0.63955,-0.16653>,<0.16004,0.64948,-0.16084>,<0.14454,0.67116,-0.14663>,
              <0.12593,0.68937,-0.13168>,<0.1153,0.69366,-0.12479>,<0.11939,0.6821,-0.13013>,
              <0.13635,0.66205,-0.14469>,<0.15643,0.64547,-0.15999><0.13914,0.68667,-0.11113>,<0.12793,0.69162,-0.10769>,<0.10214,0.70588,-0.1011>,
              <0.07826,0.72362,-0.09706>,<0.07015,0.73424,-0.09778>,<0.08226,0.73092,-0.10241>,
              <0.10716,0.71503,-0.1078>,<0.13014,0.69565,-0.11065><-0.02107,0.69614,-0.06801>,<-0.01454,0.70691,-0.06982>,<0.00351,0.73084,-0.07354>,
              <0.02497,0.75165,-0.07631>,<0.03707,0.75735,-0.07656>,<0.03214,0.74512,-0.0743>,
              <0.01249,0.72266,-0.07102>,<-0.01058,0.7033,-0.06871><0.0961,0.72394,-0.07608>,<0.08418,0.72763,-0.0736>,<0.05663,0.73909,-0.06893>,
              <0.03095,0.75442,-0.06622>,<0.02207,0.76439,-0.06695>,<0.03487,0.76252,-0.07035>,
              <0.06154,0.74924,-0.0741>,<0.08634,0.73211,-0.07588><-0.09731,0.75689,0.02521>,<-0.08902,0.76293,0.01767>,<-0.068,0.77453,-0.00064>,
              <-0.04544,0.78168,-0.01912>,<-0.03465,0.78045,-0.02693>,<-0.04221,0.77233,-0.01947>,
              <-0.06396,0.76281,-0.00108>,<-0.08724,0.75776,0.01748><0.11308,0.66921,-0.13084>,<0.12166,0.67576,-0.13758>,<0.1404,0.69383,-0.1529>,
              <0.15617,0.71527,-0.16678>,<0.15992,0.72733,-0.17119>,<0.14995,0.72237,-0.16378>,
              <0.1326,0.70272,-0.14914>,<0.11822,0.67968,-0.13593><0.19444,0.67542,-0.13882>,<0.19074,0.68631,-0.14427>,<0.18007,0.71046,-0.15893>,
              <0.16676,0.7314,-0.17584>,<0.15878,0.73706,-0.18496>,<0.16125,0.72467,-0.18057>,
              <0.17316,0.70203,-0.16485>,<0.1877,0.68259,-0.14688><0.08805,0.7169,-0.21171>,<0.09903,0.72201,-0.21561>,<0.12401,0.73683,-0.22389>,
              <0.14666,0.7554,-0.23049>,<0.15387,0.76661,-0.23164>,<0.14179,0.76326,-0.22696>,
              <0.1179,0.74668,-0.21946>,<0.09634,0.72635,-0.21366><0.19814,0.73055,-0.29752>,<0.19198,0.74167,-0.29699>,<0.1748,0.76649,-0.29624>,
              <0.1541,0.78825,-0.29628>,<0.14224,0.79439,-0.29703>,<0.14675,0.78183,-0.29793>,
              <0.16558,0.75844,-0.29831>,<0.18792,0.73812,-0.29791><0.06505,0.75856,-0.29495>,<0.07719,0.7617,-0.29711>,<0.10522,0.77203,-0.30152>,
              <0.13134,0.7865,-0.30469>,<0.14036,0.79638,-0.30485>,<0.12732,0.79518,-0.3021>,
              <0.10019,0.7829,-0.29828>,<0.07497,0.76649,-0.29569><0.18393,0.76046,-0.42649>,<0.17602,0.76909,-0.42152>,<0.15508,0.78742,-0.4098>,
              <0.13136,0.80197,-0.39851>,<0.11892,0.80443,-0.39424>,<0.12553,0.79401,-0.39942>,
              <0.14777,0.77746,-0.41094>,<0.1728,0.7647,-0.42202><0.17805,0.82586,-0.19968>,<0.17565,0.81502,-0.19347>,<0.17297,0.78895,-0.17846>,
              <0.17501,0.76302,-0.16345>,<0.18029,0.75243,-0.15722>,<0.18491,0.76334,-0.16343>,
              <0.18537,0.78934,-0.17844>,<0.18111,0.81519,-0.19345><0.14776,0.79844,-0.12869>,<0.15581,0.78876,-0.13051>,<0.17251,0.76392,-0.13453>,
              <0.18509,0.73687,-0.13798>,<0.18641,0.72359,-0.13889>,<0.17642,0.73224,-0.1368>,
              <0.16165,0.75811,-0.13305>,<0.15102,0.7862,-0.12986><0.15261,0.76664,-0.18065>,<0.15562,0.75794,-0.17187>,<0.16559,0.73726,-0.15224>,
              <0.17961,0.71709,-0.13497>,<0.18922,0.70921,-0.13003>,<0.18812,0.71816,-0.13992>,
              <0.17625,0.7386,-0.15844>,<0.16033,0.75853,-0.1746><0.1341,0.71955,-0.08396>,<0.14497,0.71312,-0.08546>,<0.16923,0.69596,-0.09086>,
              <0.19049,0.67636,-0.09895>,<0.19647,0.66594,-0.10484>,<0.18418,0.67123,-0.10461>,
              <0.16133,0.68954,-0.09794>,<0.14149,0.71029,-0.08858><0.1534,0.66879,-0.16398>,<0.15736,0.66543,-0.15237>,<0.16955,0.6571,-0.12603>,
              <0.1857,0.64843,-0.10224>,<0.1961,0.64454,-0.09479>,<0.194,0.64774,-0.1076>,
              <0.17995,0.65623,-0.13274>,<0.16195,0.66505,-0.15533><0.13089,0.63382,-0.0345>,<0.14016,0.62562,-0.03747>,<0.16084,0.60592,-0.04726>,
              <0.17896,0.58633,-0.06103>,<0.18407,0.57833,-0.07045>,<0.1736,0.58658,-0.06935>,
              <0.15412,0.60623,-0.05769>,<0.1372,0.62576,-0.04206><0.14389,0.50936,-0.13001>,<0.1459,0.51611,-0.11941>,<0.15366,0.53177,-0.09479>,
              <0.16582,0.54648,-0.0716>,<0.17498,0.55167,-0.06335>,<0.17503,0.54447,-0.07463>,
              <0.16521,0.52926,-0.09858>,<0.15099,0.515,-0.12108><0.2203,0.79842,-0.14128>,<0.21086,0.80547,-0.14609>,<0.19059,0.82358,-0.15924>,
              <0.17409,0.84334,-0.1747>,<0.1708,0.85308,-0.18326>,<0.18201,0.8468,-0.17953>,
              <0.20051,0.82792,-0.1653>,<0.21523,0.80738,-0.14876><0.15182,0.83097,-0.24945>,<0.1554,0.83965,-0.24086>,<0.16108,0.85998,-0.21926>,
              <0.16232,0.87937,-0.19637>,<0.15866,0.88653,-0.18568>,<0.153,0.87741,-0.19366>,
              <0.1494,0.85752,-0.21586>,<0.15025,0.83856,-0.23936><0.21505,0.89074,-0.13735>,<0.20372,0.89287,-0.14273>,<0.17835,0.89908,-0.15789>,
              <0.15597,0.90688,-0.17633>,<0.14952,0.91162,-0.18705>,<0.16226,0.91024,-0.18321>,
              <0.18622,0.90328,-0.16651>,<0.20719,0.89473,-0.14653><0.06241,0.90257,-0.16361>,<0.07208,0.90861,-0.16927>,<0.09677,0.92196,-0.18039>,
              <0.12353,0.93348,-0.18769>,<0.13654,0.93653,-0.18711>,<0.12784,0.92963,-0.17964>,
              <0.10218,0.91714,-0.17032>,<0.07446,0.90648,-0.16483><0.06318,0.96896,-0.12087>,<0.06932,0.96714,-0.13187>,<0.08623,0.96439,-0.15675>,
              <0.10626,0.96412,-0.17911>,<0.11751,0.96633,-0.18601>,<0.11284,0.96931,-0.17383>,
              <0.09447,0.97089,-0.15013>,<0.07296,0.97001,-0.12896><-0.0131,1.01043,-0.14112>,<-0.00314,1.01248,-0.14877>,<0.02218,1.01574,-0.16491>,
              <0.0494,1.01647,-0.17756>,<0.06247,1.0144,-0.17951>,<0.05341,1.01116,-0.17022>,
              <0.0272,1.00909,-0.15572>,<-0.00092,1.00955,-0.14471><0.14193,0.86066,-0.17353>,<0.1506,0.85205,-0.17708>,<0.17269,0.83393,-0.18686>,
              <0.19651,0.8198,-0.19847>,<0.208,0.8177,-0.20499>,<0.20013,0.82818,-0.2023>,
              <0.17723,0.84443,-0.19166>,<0.15261,0.85668,-0.17919><0.21273,0.83715,-0.14233>,<0.21493,0.83466,-0.15461>,<0.21833,0.8263,-0.18343>,
              <0.21883,0.81443,-0.211>,<0.21631,0.80621,-0.22126>,<0.21274,0.80706,-0.20839>,
              <0.21071,0.81707,-0.18016>,<0.21157,0.83059,-0.15317><0.15603,0.82689,-0.2027>,<0.16635,0.82013,-0.20581>,<0.19099,0.80576,-0.21574>,
              <0.21516,0.79429,-0.22937>,<0.22475,0.79228,-0.23848>,<0.21421,0.8004,-0.23711>,
              <0.18979,0.81341,-0.22544>,<0.16583,0.8235,-0.21008><0.2565,0.78032,-0.18723>,<0.25573,0.77959,-0.19991>,<0.25169,0.77574,-0.22959>,
              <0.24439,0.76879,-0.25788>,<0.2383,0.76299,-0.26828>,<0.23754,0.76227,-0.25494>,
              <0.24311,0.76757,-0.22592>,<0.25195,0.77598,-0.19829><0.16691,0.73439,-0.26946>,<0.17922,0.73155,-0.27103>,<0.20826,0.72631,-0.27744>,
              <0.23631,0.72347,-0.28778>,<0.24699,0.72456,-0.29576>,<0.23421,0.72852,-0.29604>,
              <0.20564,0.73263,-0.28779>,<0.17806,0.73434,-0.2756><0.27853,0.69898,-0.22942>,<0.27692,0.70006,-0.242>,<0.27016,0.70192,-0.27137>,
              <0.25906,0.70268,-0.29926>,<0.25039,0.70196,-0.30942>,<0.24996,0.70036,-0.29614>,
              <0.25875,0.69901,-0.26747>,<0.27189,0.69877,-0.24028><0.16625,0.67591,-0.32103>,<0.17859,0.67406,-0.31854>,<0.20844,0.67067,-0.31547>,
              <0.23839,0.66893,-0.31683>,<0.25088,0.66974,-0.32155>,<0.23858,0.67236,-0.32611>,
              <0.20869,0.67498,-0.3271>,<0.1787,0.67595,-0.32367><0.19905,0.92575,-0.23793>,<0.19787,0.91552,-0.23046>,<0.19811,0.89113,-0.21265>,
              <0.20304,0.86722,-0.19517>,<0.20948,0.85775,-0.18826>,<0.21287,0.8682,-0.19589>,
              <0.21042,0.89237,-0.21354>,<0.20329,0.91606,-0.23086><0.14279,0.87591,-0.16897>,<0.15366,0.87039,-0.16533>,<0.17859,0.85485,-0.15831>,
              <0.20154,0.83598,-0.15398>,<0.20918,0.82502,-0.1547>,<0.19738,0.82897,-0.1596>,
              <0.17338,0.84607,-0.16536>,<0.15137,0.86652,-0.16843><0.18742,0.81569,-0.20544>,<0.18788,0.81148,-0.19344>,<0.19194,0.8023,-0.16496>,
              <0.20041,0.79461,-0.1372>,<0.20807,0.79283,-0.12638>,<0.20968,0.79775,-0.13871>,
              <0.20355,0.80623,-0.16686>,<0.193,0.81321,-0.19428><0.15384,0.8243,-0.08258>,<0.16313,0.81575,-0.08413>,<0.18326,0.79392,-0.08964>,
              <0.19992,0.77033,-0.09784>,<0.20358,0.7589,-0.10376>,<0.19266,0.76663,-0.10347>,
              <0.17416,0.78929,-0.0967>,<0.15912,0.8137,-0.08724><0.17049,0.73104,-0.17366>,<0.17208,0.73219,-0.16108>,<0.17886,0.73488,-0.13178>,
              <0.19009,0.73742,-0.10405>,<0.19892,0.73834,-0.09404>,<0.19942,0.73712,-0.10735>,
              <0.19055,0.7345,-0.13592>,<0.17723,0.73202,-0.16291><0.13702,0.77611,-0.06071>,<0.14671,0.76796,-0.06203>,<0.16858,0.74799,-0.06792>,
              <0.18818,0.72757,-0.07793>,<0.19417,0.71868,-0.08594>,<0.18341,0.72661,-0.08656>,
              <0.16261,0.7468,-0.07873>,<0.14407,0.76743,-0.06679><0.17376,0.66266,-0.15949>,<0.17289,0.66726,-0.14765>,<0.17388,0.67802,-0.11946>,
              <0.17954,0.6883,-0.09182>,<0.18626,0.69211,-0.08089>,<0.18932,0.68729,-0.09299>,
              <0.18614,0.67675,-0.12093>,<0.17829,0.66669,-0.1483><0.26096,0.95007,-0.26949>,<0.25359,0.94395,-0.26113>,<0.23693,0.93153,-0.23921>,
              <0.222,0.92267,-0.21472>,<0.21744,0.92233,-0.20214>,<0.22563,0.93012,-0.2093>,
              <0.24148,0.94087,-0.23243>,<0.25559,0.94807,-0.25813><0.27863,0.92383,-0.18717>,<0.26633,0.9236,-0.19042>,<0.2367,0.92117,-0.19574>,
              <0.20718,0.91589,-0.19729>,<0.19506,0.91103,-0.1944>,<0.20741,0.90993,-0.18939>,
              <0.23699,0.9137,-0.18583>,<0.26645,0.92031,-0.18605><0.22699,0.90579,-0.23155>,<0.21664,0.90115,-0.22579>,<0.19228,0.89249,-0.21018>,
              <0.16886,0.88769,-0.192>,<0.16005,0.88932,-0.18207>,<0.17084,0.89577,-0.18664>,
              <0.19476,0.90262,-0.20345>,<0.21773,0.90561,-0.22283><0.09251,0.89159,-0.24258>,<0.09842,0.89127,-0.23132>,<0.11453,0.8887,-0.20591>,
              <0.13344,0.88344,-0.18319>,<0.1439,0.87874,-0.1763>,<0.13931,0.8778,-0.18883>,
              <0.12188,0.88163,-0.21298>,<0.10166,0.88815,-0.23444><0.12183,0.86324,-0.07815>,<0.12279,0.85873,-0.09001>,<0.1229,0.85004,-0.11893>,
              <0.11967,0.84465,-0.14829>,<0.1152,0.84552,-0.16087>,<0.11267,0.85158,-0.14921>,
              <0.11412,0.85872,-0.12009>,<0.11892,0.86256,-0.09052><0.03772,0.82544,-0.20645>,<0.04612,0.82751,-0.19712>,<0.06816,0.83105,-0.17678>,
              <0.09282,0.83242,-0.1597>,<0.1055,0.83095,-0.1557>,<0.09832,0.82786,-0.16656>,
              <0.07505,0.82534,-0.18537>,<0.04916,0.82499,-0.20091><0.08804,0.79327,-0.06315>,<0.0907,0.79307,-0.07559>,<0.09442,0.79418,-0.10554>,
              <0.09407,0.79769,-0.13536>,<0.09011,0.80139,-0.14759>,<0.08554,0.80271,-0.13509>,
              <0.08373,0.80047,-0.1052>,<0.08599,0.79584,-0.07544><0.21676,1.01817,-0.19361>,<0.22075,1.00666,-0.19726>,<0.23136,0.98068,-0.20843>,
              <0.24344,0.95747,-0.22315>,<0.24982,0.95043,-0.23257>,<0.24652,0.96324,-0.23058>,
              <0.23522,0.98792,-0.21774>,<0.22245,1.00985,-0.20136><0.27144,1.0098,-0.18632>,<0.27002,1.00106,-0.19546>,<0.26442,0.9791,-0.21543>,
              <0.25553,0.95588,-0.23226>,<0.24876,0.94507,-0.23628>,<0.24863,0.95322,-0.22567>,
              <0.25578,0.97577,-0.20718>,<0.26621,0.99959,-0.19182><0.20581,0.9905,-0.2136>,<0.2113,0.97943,-0.21663>,<0.22478,0.95431,-0.22661>,
              <0.23857,0.93162,-0.24063>,<0.24458,0.9245,-0.25022>,<0.23923,0.93671,-0.24909>,
              <0.22561,0.96069,-0.23722>,<0.21167,0.98224,-0.2213><0.24887,0.94182,-0.18887>,<0.25005,0.93597,-0.20011>,<0.24981,0.92176,-0.22676>,
              <0.24491,0.90742,-0.25268>,<0.2385,0.90134,-0.26273>,<0.23513,0.90712,-0.25114>,
              <0.23756,0.92139,-0.22484>,<0.24465,0.93581,-0.19926><0.15752,0.89422,-0.28106>,<0.16589,0.88488,-0.27889>,<0.18653,0.86294,-0.2767>,
              <0.20783,0.84192,-0.27908>,<0.21727,0.83406,-0.28438>,<0.20921,0.84382,-0.2887>,
              <0.18827,0.86534,-0.28874>,<0.16666,0.88594,-0.2842><0.22758,0.80033,-0.20279>,<0.22735,0.80146,-0.21546>,<0.22391,0.80516,-0.24524>,
              <0.21617,0.81035,-0.27378>,<0.20891,0.81388,-0.28445>,<0.20712,0.81344,-0.2712>,
              <0.21258,0.80904,-0.242>,<0.22235,0.80316,-0.21404><0.1344,0.83207,-0.2462>,<0.14531,0.82629,-0.24926>,<0.17029,0.81271,-0.25945>,
              <0.1932,0.79969,-0.27384>,<0.20076,0.79484,-0.28375>,<0.18888,0.80088,-0.28266>,
              <0.16487,0.8142,-0.2705>,<0.14292,0.82695,-0.25414><0.23626,0.96713,-0.24389>,<0.24417,0.9766,-0.24076>,<0.26271,1,-0.23624>,
              <0.28046,1.02422,-0.23629>,<0.28706,1.03502,-0.24061>,<0.27879,1.02594,-0.2459>,
              <0.26061,1.00215,-0.24827>,<0.24324,0.97755,-0.24607><0.26937,1.02688,-0.16708>,<0.27335,1.03304,-0.17747>,<0.28516,1.04569,-0.20222>,
              <0.30027,1.055,-0.22645>,<0.30962,1.05572,-0.23598>,<0.30719,1.048,-0.22533>,
              <0.29383,1.03692,-0.20083>,<0.27717,1.02917,-0.17686><0.30944,0.98901,-0.25861>,<0.31209,0.99976,-0.25233>,<0.31786,1.02674,-0.24005>,
              <0.3227,1.05529,-0.23212>,<0.32383,1.06859,-0.23293>,<0.32075,1.05859,-0.24125>,
              <0.31541,1.03087,-0.25149>,<0.31101,1.00158,-0.25737><0.31531,1.09007,-0.14813>,<0.31905,1.09231,-0.16009>,<0.32993,1.09534,-0.1881>,
              <0.34358,1.09478,-0.21483>,<0.35186,1.09117,-0.22471>,<0.34942,1.08724,-0.21215>,
              <0.33724,1.0859,-0.18474>,<0.32228,1.08815,-0.15861><0.41156,1.03152,-0.22953>,<0.40649,1.0421,-0.2246>,<0.39433,1.06829,-0.21576>,
              <0.38229,1.09547,-0.21153>,<0.37741,1.10765,-0.21412>,<0.38253,1.09754,-0.22121>,
              <0.39464,1.07088,-0.22789>,<0.40663,1.04324,-0.22995><0.37884,1.1252,-0.12166>,<0.38065,1.12688,-0.13415>,<0.38634,1.12816,-0.16378>,
              <0.39407,1.12524,-0.19264>,<0.39918,1.1201,-0.20388>,<0.39834,1.11645,-0.19104>,
              <0.39168,1.11714,-0.16177>,<0.383,1.12203,-0.13326><0.45356,1.06341,-0.2372>,<0.44688,1.07052,-0.22903>,<0.43089,1.08953,-0.21185>,
              <0.4151,1.1113,-0.1985>,<0.40875,1.12291,-0.19656>,<0.41552,1.11709,-0.20652>,
              <0.43142,1.09679,-0.2219>,<0.44711,1.07372,-0.23346><0.39382,1.15269,-0.11012>,<0.39796,1.15147,-0.12209>,<0.40808,1.1456,-0.14993>,
              <0.41839,1.13528,-0.17618>,<0.42283,1.12684,-0.18555>,<0.41877,1.12597,-0.17284>,
              <0.40856,1.13393,-0.14574>,<0.39817,1.14633,-0.12024><0.03713,0.2106,-0.02958>,<0.04495,0.21892,-0.02396>,<0.06205,0.24084,-0.01216>,
              <0.07645,0.26556,-0.00305>,<0.07989,0.27843,-0.0018>,<0.0708,0.27143,-0.00868>,
              <0.05497,0.24819,-0.01922>,<0.04183,0.22216,-0.02707><0.17205,0.28982,0.032>,<0.1693,0.29991,0.02475>,<0.16357,0.32212,0.00511>,
              <0.15917,0.34113,-0.01771>,<0.1586,0.34598,-0.03016>,<0.16197,0.33439,-0.02441>,
              <0.16708,0.31368,-0.00327>,<0.17085,0.29618,0.02105><0.19135,0.35901,-0.1295>,<0.19735,0.36097,-0.11845>,<0.21021,0.36838,-0.09215>,
              <0.22065,0.37979,-0.06641>,<0.22269,0.38828,-0.05628>,<0.21555,0.3882,-0.0676>,
              <0.20383,0.37891,-0.09363>,<0.19454,0.36562,-0.11911><0.33052,0.3923,-0.0146>,<0.32525,0.39845,-0.02441>,<0.31273,0.41038,-0.04918>,
              <0.30053,0.41788,-0.07556>,<0.29576,0.41684,-0.08802>,<0.30118,0.40861,-0.07897>,
              <0.31355,0.39876,-0.05345>,<0.32561,0.39333,-0.0263><0.05855,0.31241,-0.06789>,<0.05677,0.31129,-0.05534>,<0.05522,0.31005,-0.02521>,
              <0.05781,0.31106,0.00469>,<0.06278,0.31358,0.01685>,<0.06651,0.31576,0.00419>,
              <0.06612,0.31594,-0.02583>,<0.06157,0.31388,-0.05562><-0.02416,0.30238,0.06944>,<-0.01632,0.30606,0.07876>,<0.00321,0.31187,0.10105>,
              <0.02367,0.31307,0.12299>,<0.03302,0.30923,0.13176>,<0.02562,0.30339,0.12227>,
              <0.00565,0.29974,0.10015>,<-0.01525,0.30071,0.07837><0.07717,0.25872,0.12067>,<0.06735,0.2639,0.12688>,<0.04595,0.27848,0.14242>,
              <0.02801,0.29616,0.15876>,<0.02383,0.3064,0.16629>,<0.03528,0.30267,0.16046>,
              <0.05505,0.28663,0.14455>,<0.07136,0.2675,0.12782><-0.06321,0.29658,0.17506>,<-0.05379,0.29828,0.18344>,<-0.03061,0.29943,0.20276>,
              <-0.00677,0.29611,0.22071>,<0.00373,0.29054,0.22686>,<-0.00538,0.28674,0.21783>,
              <-0.02888,0.28769,0.19915>,<-0.05303,0.29311,0.18185><0.03991,0.21511,0.24103>,<0.02996,0.22225,0.24448>,<0.00829,0.24083,0.25434>,
              <-0.00982,0.26144,0.26653>,<-0.01397,0.2719,0.27377>,<-0.00234,0.26572,0.27142>,
              <0.01765,0.24619,0.26046>,<0.03409,0.22461,0.24718><0.11703,0.38569,-0.0029>,<0.10906,0.37577,-0.00319>,<0.08805,0.35409,-0.00267>,
              <0.06435,0.33581,-0.00029>,<0.052,0.33144,0.00243>,<0.05871,0.34296,0.0036>,
              <0.08098,0.36304,0.00221>,<0.10595,0.37972,-0.00104><0.0667,0.29705,-0.01596>,<0.05537,0.29349,-0.02051>,<0.02817,0.2833,-0.02878>,
              <0.00121,0.27076,-0.03297>,<-0.00972,0.26334,-0.03088>,<0.00173,0.2658,-0.02442>,
              <0.02881,0.27709,-0.01806>,<0.05565,0.29075,-0.01578><-0.01075,0.25035,0.02449>,<-0.01296,0.24538,0.013>,<-0.02116,0.23433,-0.01389>,
              <-0.03364,0.22474,-0.03946>,<-0.04285,0.22213,-0.04881>,<-0.04265,0.22779,-0.03669>,
              <-0.03244,0.23815,-0.01042>,<-0.01793,0.24706,0.01452><-0.13121,0.1782,-0.12903>,<-0.1243,0.17629,-0.11853>,<-0.10596,0.17012,-0.09534>,
              <-0.08516,0.16162,-0.07542>,<-0.07422,0.1559,-0.07025>,<-0.07998,0.15672,-0.0823>,
              <-0.09948,0.16398,-0.10395>,<-0.12144,0.17358,-0.12232><-0.08034,0.14817,0.00853>,<-0.07787,0.14566,-0.0037>,<-0.07494,0.14041,-0.03329>,
              <-0.07656,0.13637,-0.063>,<-0.08151,0.13584,-0.07541>,<-0.08612,0.13892,-0.06324>,
              <-0.08692,0.14361,-0.03359>,<-0.08316,0.14707,-0.00383><0.02611,0.38829,-0.01895>,<0.03817,0.39212,-0.01769>,<0.06578,0.40407,-0.01505>,
              <0.09109,0.4201,-0.01301>,<0.09941,0.43057,-0.01274>,<0.08626,0.42865,-0.01429>,
              <0.05974,0.41479,-0.01664>,<0.03551,0.39684,-0.01839><0.1213,0.3969,0.02016>,<0.12334,0.40662,0.01221>,<0.12717,0.42786,-0.00891>,
              <0.12936,0.44576,-0.03292>,<0.12873,0.45002,-0.04558>,<0.12592,0.43873,-0.03899>,
              <0.12286,0.41906,-0.01651>,<0.12144,0.40274,0.00886><0.0902,0.4089,-0.09467>,<0.10107,0.41459,-0.0913>,<0.12554,0.43075,-0.08408>,
              <0.14734,0.45056,-0.07824>,<0.15387,0.46218,-0.07713>,<0.14176,0.45819,-0.08116>,
              <0.11854,0.44032,-0.08773>,<0.09798,0.41881,-0.09291><0.26331,0.41457,-0.12615>,<0.25871,0.42558,-0.13057>,<0.24606,0.45004,-0.14297>,
              <0.2311,0.47131,-0.15797>,<0.22272,0.47713,-0.16662>,<0.22624,0.46463,-0.16342>,
              <0.23997,0.44166,-0.1498>,<0.25602,0.42188,-0.13358><0.22698,0.40998,-0.29632>,<0.23525,0.4138,-0.28744>,<0.2544,0.42573,-0.26736>,
              <0.27229,0.44173,-0.24932>,<0.27853,0.45218,-0.24377>,<0.26967,0.45027,-0.25361>,
              <0.25111,0.43643,-0.27273>,<0.2338,0.41852,-0.28981><0.07293,0.42308,-0.02634>,<0.07524,0.43087,-0.01654>,<0.08104,0.4516,0.00464>,
              <0.0872,0.47523,0.02211>,<0.09008,0.48774,0.02587>,<0.08794,0.48131,0.01433>,
              <0.08197,0.45922,-0.00511>,<0.07565,0.43423,-0.02084><0.08536,0.46353,0.0888>,<0.08998,0.47501,0.08587>,<0.10334,0.50081,0.07765>,
              <0.12003,0.52373,0.06773>,<0.13005,0.5305,0.06202>,<0.12699,0.51765,0.06416>,
              <0.11206,0.49321,0.07318>,<0.09382,0.47166,0.0839><0.18802,0.50781,0.02033>,<0.18381,0.51253,0.03137>,<0.17315,0.52631,0.05604>,
              <0.16173,0.54366,0.07772>,<0.15629,0.55421,0.08389>,<0.16015,0.55116,0.07145>,
              <0.17117,0.53571,0.04819>,<0.18294,0.51667,0.02791><0.15529,0.54955,0.18525>,<0.16158,0.55729,0.17735>,<0.17829,0.57326,0.15792>,
              <0.19731,0.58515,0.13796>,<0.20735,0.58624,0.12919>,<0.20215,0.57659,0.13684>,
              <0.18435,0.56253,0.15652>,<0.16425,0.55255,0.17673><0.30771,0.54866,0.12898>,<0.29938,0.55366,0.1372>,<0.28029,0.56826,0.15549>,
              <0.26277,0.58666,0.17149>,<0.25698,0.59787,0.17595>,<0.26605,0.59466,0.16665>,
              <0.2844,0.57827,0.14944>,<0.30119,0.55808,0.13452><0.11272,0.49675,-0.03627>,<0.10299,0.49888,-0.02836>,<0.08143,0.50639,-0.00858>,
              <0.0628,0.51747,0.01219>,<0.05782,0.52541,0.02173>,<0.06892,0.52496,0.01429>,
              <0.08911,0.51578,-0.00596>,<0.10637,0.50302,-0.0272><0.02157,0.49923,-0.03948>,<0.02154,0.50638,-0.02895>,<0.02264,0.5209,-0.0025>,
              <0.02547,0.53133,0.02552>,<0.02827,0.53179,0.03859>,<0.0291,0.52272,0.0288>,
              <0.02719,0.51012,0.00161>,<0.02355,0.50162,-0.02714><0.00675,0.49227,0.10853>,<-0.00351,0.49765,0.10326>,<-0.02694,0.51304,0.09204>,
              <-0.04838,0.53206,0.08308>,<-0.05538,0.54335,0.0815>,<-0.04418,0.53967,0.08783>,
              <-0.02169,0.52258,0.09799>,<-0.00119,0.50185,0.10588><-0.07357,0.52868,0.00517>,<-0.07387,0.53336,0.01699>,<-0.07366,0.54173,0.04601>,
              <-0.07202,0.54565,0.07573>,<-0.07,0.5431,0.08871>,<-0.06903,0.53632,0.07721>,
              <-0.06992,0.53005,0.04787>,<-0.07222,0.52821,0.01781><-0.07955,0.47483,0.15803>,<-0.08741,0.48117,0.15029>,<-0.10542,0.49874,0.13358>,
              <-0.12202,0.51966,0.11987>,<-0.12757,0.53149,0.117>,<-0.11906,0.52672,0.12615>,
              <-0.10171,0.50758,0.14145>,<-0.08577,0.48507,0.15376><-0.17866,0.45279,0.08044>,<-0.17819,0.46339,0.08747>,<-0.17519,0.48701,0.10604>,
              <-0.16941,0.50768,0.12704>,<-0.16441,0.51347,0.13802>,<-0.16359,0.50149,0.13212>,
              <-0.16789,0.47925,0.11241>,<-0.17497,0.45997,0.09027><0.03382,0.51449,0.00118>,<0.04258,0.52362,-0.00015>,<0.06107,0.54731,-0.00313>,
              <0.07556,0.57348,-0.00576>,<0.07781,0.58664,-0.00652>,<0.06717,0.57867,-0.00502>,
              <0.05055,0.55382,-0.0022>,<0.03794,0.52649,0.00026><0.13462,0.58103,-0.0205>,<0.12789,0.59136,-0.02362>,<0.11068,0.61422,-0.03327>,
              <0.09203,0.63393,-0.04613>,<0.08295,0.63914,-0.05446>,<0.08901,0.62732,-0.05285>,
              <0.10689,0.60594,-0.04169>,<0.12622,0.58771,-0.02733><0.03273,0.6032,-0.10911>,<0.04264,0.61054,-0.10597>,<0.06413,0.63006,-0.09763>,
              <0.08193,0.65229,-0.08814>,<0.08585,0.66406,-0.08312>,<0.07421,0.65799,-0.08571>,
              <0.05445,0.6372,-0.09459>,<0.03838,0.61369,-0.10463><0.16248,0.65176,-0.10649>,<0.15273,0.65984,-0.10779>,<0.12823,0.67684,-0.11254>,
              <0.10224,0.69006,-0.11972>,<0.0901,0.692,-0.12498>,<0.09915,0.68215,-0.12482>,
              <0.12435,0.66693,-0.11892>,<0.15102,0.65547,-0.1106><0.01975,0.68975,-0.21243>,<0.03199,0.69158,-0.20948>,<0.06028,0.69882,-0.20178>,
              <0.08667,0.71029,-0.19322>,<0.09582,0.71902,-0.18885>,<0.08269,0.71917,-0.19139>,
              <0.05529,0.70995,-0.1995>,<0.02979,0.69649,-0.20848><0.17296,0.68871,-0.22893>,<0.16312,0.69621,-0.22597>,<0.13796,0.71178,-0.21995>,
              <0.11065,0.72351,-0.21563>,<0.09734,0.72475,-0.21544>,<0.10617,0.71543,-0.2192>,
              <0.13234,0.70167,-0.22443>,<0.16064,0.69175,-0.22794><0.05681,0.6081,-0.04543>,<0.06457,0.61091,-0.03575>,<0.08322,0.62037,-0.01396>,
              <0.10174,0.6339,0.00542>,<0.10929,0.64331,0.01118>,<0.10147,0.64241,0.00037>,
              <0.08288,0.63104,-0.02029>,<0.06442,0.61561,-0.03854><0.11594,0.60569,0.06613>,<0.12333,0.6154,0.06255>,<0.14201,0.63661,0.05189>,
              <0.16196,0.65441,0.03823>,<0.17141,0.65859,0.02973>,<0.16462,0.64727,0.0319>,
              <0.14534,0.62766,0.04397>,<0.1248,0.61146,0.05905><0.18826,0.60326,-0.01729>,<0.19023,0.6105,-0.00702>,<0.19522,0.63007,0.01544>,
              <0.20054,0.65275,0.03438>,<0.20306,0.66508,0.03892>,<0.20124,0.65931,0.02699>,
              <0.1961,0.63828,0.00618>,<0.19062,0.61412,-0.0111><0.22585,0.64242,0.12996>,<0.23242,0.64747,0.12031>,<0.24813,0.65666,0.0962>,
              <0.26359,0.66128,0.07088>,<0.26977,0.65892,0.05926>,<0.26309,0.65173,0.06834>,
              <0.24749,0.64468,0.09301>,<0.23214,0.6422,0.1189><0.2866,0.60609,-0.00352>,<0.28624,0.61104,0.0082>,<0.28666,0.6253,0.03481>,
              <0.28902,0.64306,0.05891>,<0.29181,0.65369,0.06653>,<0.29308,0.65039,0.05363>,
              <0.29175,0.63448,0.0282>,<0.28849,0.61508,0.00528><0.28373,0.59957,0.14108>,<0.28898,0.60808,0.13321>,<0.30148,0.62607,0.11241>,
              <0.31371,0.6402,0.08891>,<0.31853,0.64243,0.07663>,<0.31315,0.63211,0.08323>,
              <0.30078,0.61593,0.10529>,<0.28867,0.60361,0.13007><0.10169,0.66119,-0.01971>,<0.09044,0.6635,-0.01423>,<0.0648,0.67179,-0.00061>,
              <0.04143,0.68418,0.0136>,<0.03388,0.69315,0.02004>,<0.0462,0.69277,0.01483>,
              <0.07078,0.68255,0.00093>,<0.09308,0.66824,-0.01355><-0.00242,0.65928,-0.03602>,<-0.0028,0.66725,-0.02611>,<-0.00234,0.68398,-0.00097>,
              <0.0002,0.6969,0.02601>,<0.00322,0.69867,0.03892>,<0.00459,0.68891,0.02988>,
              <0.00315,0.67397,0.00388>,<-0.00038,0.66284,-0.02398><0.04052,0.64658,0.06163>,<0.02965,0.65289,0.05959>,<0.00515,0.67021,0.05623>,
              <-0.01676,0.69072,0.0552>,<-0.02339,0.7022,0.05695>,<-0.01131,0.69739,0.06008>,
              <0.01198,0.67857,0.06235>,<0.03266,0.65657,0.06229><-0.12208,0.62855,0.05928>,<-0.12046,0.63976,0.06509>,<-0.11494,0.66485,0.08096>,
              <-0.10698,0.68699,0.09961>,<-0.1014,0.6934,0.10994>,<-0.10187,0.68082,0.10543>,
              <-0.10854,0.65711,0.08825>,<-0.11764,0.63635,0.0683><-0.05794,0.64038,0.16098>,<-0.06714,0.64499,0.15349>,<-0.08873,0.65855,0.13731>,
              <-0.10941,0.67575,0.12397>,<-0.11711,0.68631,0.12112>,<-0.10748,0.68342,0.12994>,
              <-0.08632,0.66815,0.14479>,<-0.06607,0.64922,0.15679><-0.18707,0.61117,0.09718>,<-0.18302,0.62184,0.10281>,<-0.17153,0.6454,0.11782>,
              <-0.15745,0.66564,0.13495>,<-0.14917,0.67091,0.14404>,<-0.152,0.65868,0.13941>,
              <-0.16471,0.63668,0.12341>,<-0.18001,0.618,0.10528><0.01328,0.72795,0.00826>,<0.02133,0.73093,-0.00112>,<0.03951,0.74093,-0.02307>,
              <0.05578,0.7551,-0.04395>,<0.06073,0.7649,-0.05159>,<0.05178,0.76388,-0.0417>,
              <0.0345,0.75192,-0.02026>,<0.01912,0.73578,0.00012><0.11583,0.74079,-0.02296>,<0.10745,0.74775,-0.02954>,<0.08613,0.76166,-0.04577>,
              <0.06312,0.7712,-0.06255>,<0.05201,0.77103,-0.07>,<0.05959,0.76201,-0.06367>,
              <0.08171,0.75016,-0.04718>,<0.10551,0.74268,-0.03016><-0.02573,0.73839,-0.0692>,<-0.01634,0.74239,-0.0768>,<0.00496,0.75474,-0.09429>,
              <0.02422,0.77113,-0.11047>,<0.03027,0.78172,-0.11596>,<0.01992,0.77963,-0.10775>,
              <-0.00043,0.76538,-0.09088>,<-0.01872,0.74708,-0.0753><0.10104,0.75769,-0.11008>,<0.09065,0.7642,-0.11345>,<0.06442,0.77704,-0.12117>,
              <0.0365,0.78552,-0.12825>,<0.02334,0.78494,-0.13057>,<0.03294,0.77638,-0.12689>,
              <0.05996,0.76559,-0.11948>,<0.08868,0.75916,-0.1127><-0.05489,0.73356,-0.14129>,<-0.04591,0.7387,-0.14869>,<-0.02642,0.75337,-0.1665>,
              <-0.01022,0.77142,-0.1842>,<-0.0066,0.78207,-0.19144>,<-0.01713,0.77851,-0.18399>,
              <-0.03507,0.76226,-0.16623>,<-0.04972,0.74262,-0.14857><0.04754,0.73079,-0.25267>,<0.03738,0.73814,-0.25051>,<0.01198,0.75315,-0.24406>,
              <-0.01474,0.76403,-0.23573>,<-0.02704,0.76466,-0.23053>,<-0.0175,0.75537,-0.23181>,
              <0.00852,0.7423,-0.23914>,<0.03586,0.73336,-0.24834><0.06053,0.88739,-0.04399>,<0.06248,0.87578,-0.03918>,<0.07011,0.84878,-0.028>,
              <0.08214,0.82336,-0.01748>,<0.09126,0.81431,-0.01375>,<0.09137,0.82667,-0.01887>,
              <0.08168,0.85292,-0.02974>,<0.06758,0.8776,-0.03995><0.06097,0.83552,0.01881>,<0.07088,0.82773,0.01709>,<0.09249,0.80739,0.0115>,
              <0.1106,0.78472,0.00375>,<0.11481,0.77315,-0.00147>,<0.10325,0.77985,-0.00076>,
              <0.08329,0.80128,0.00584>,<0.06683,0.82504,0.0146><0.08764,0.76223,-0.04193>,<0.09281,0.75555,-0.03241>,<0.10781,0.74015,-0.0112>,
              <0.12656,0.72584,0.00738>,<0.13786,0.72093,0.01259>,<0.13445,0.72812,0.00184>,
              <0.11769,0.74301,-0.01813>,<0.09717,0.75681,-0.03547><0.09263,0.74696,0.05459>,<0.10239,0.73951,0.05125>,<0.12374,0.72072,0.04111>,
              <0.14178,0.70072,0.02783>,<0.14614,0.6913,0.01939>,<0.13482,0.69819,0.02126>,
              <0.11502,0.71754,0.03288>,<0.09854,0.73811,0.04762><0.10193,0.66518,-0.04026>,<0.10715,0.6633,-0.0288>,<0.12225,0.65905,-0.003>,
              <0.14115,0.65523,0.02002>,<0.15254,0.65403,0.02694>,<0.1491,0.65611,0.01418>,
              <0.13221,0.66016,-0.01032>,<0.11154,0.66379,-0.03203><0.07352,0.58958,0.0732>,<0.08574,0.58927,0.06968>,<0.11376,0.58857,0.05844>,
              <0.13953,0.588,0.04304>,<0.1481,0.58787,0.03277>,<0.13482,0.58824,0.03434>,
              <0.10785,0.58888,0.04753>,<0.08314,0.5894,0.06488><0.12311,0.87353,-0.07035>,<0.11422,0.86764,-0.06341>,<0.09401,0.8554,-0.0446>,
              <0.07571,0.84616,-0.02267>,<0.06991,0.84513,-0.01065>,<0.0797,0.85243,-0.01613>,
              <0.09901,0.86326,-0.03641>,<0.11642,0.8711,-0.0598><0.1266,0.85702,0.00484>,<0.11419,0.85579,0.00232>,<0.08489,0.85014,-0.0023>,
              <0.05657,0.84044,-0.0047>,<0.04577,0.83263,-0.00361>,<0.05865,0.83195,-0.00004>,
              <0.08749,0.83951,0.00354>,<0.11534,0.8511,0.00489><0.09416,0.82841,-0.03621>,<0.08262,0.82484,-0.0322>,<0.05556,0.81843,-0.02042>,
              <0.02971,0.8153,-0.00547>,<0.02014,0.81708,0.0037>,<0.03224,0.82219,0.00117>,
              <0.05873,0.82706,-0.01209>,<0.08402,0.82865,-0.02853><-0.00761,0.83335,-0.07313>,<-0.0063,0.83226,-0.06052>,<-0.00179,0.82701,-0.03112>,
              <0.00476,0.8178,-0.00331>,<0.00938,0.81027,0.00674>,<0.00902,0.80949,-0.00661>,
              <0.00355,0.8166,-0.03527>,<-0.00395,0.82767,-0.06234><0.03081,0.73356,0.04834>,<0.01988,0.73616,0.04237>,<-0.00686,0.74393,0.03069>,
              <-0.03415,0.75393,0.02313>,<-0.04596,0.76017,0.02387>,<-0.03528,0.75861,0.03178>,
              <-0.00828,0.74979,0.04153>,<0.01926,0.73875,0.04715><-0.04539,0.72731,-0.0529>,<-0.05013,0.72952,-0.0413>,<-0.05882,0.73357,-0.01266>,
              <-0.0633,0.73568,0.01695>,<-0.06123,0.73474,0.03013>,<-0.05451,0.73163,0.019>,
              <-0.04779,0.72849,-0.0101>,<-0.04528,0.72728,-0.04017><-0.12152,0.69437,0.09451>,<-0.1116,0.69702,0.08699>,<-0.09007,0.70459,0.06722>,
              <-0.07216,0.71393,0.045>,<-0.06815,0.71947,0.0335>,<-0.07977,0.71765,0.03987>,
              <-0.0996,0.70925,0.0608>,<-0.1158,0.69908,0.08416><0.03203,0.90737,-0.01566>,<0.04439,0.90851,-0.01848>,<0.07337,0.91423,-0.02477>,
              <0.10106,0.92443,-0.03028>,<0.11133,0.93286,-0.03185>,<0.09838,0.93382,-0.02867>,
              <0.07,0.926,-0.02274>,<0.0429,0.9137,-0.01759><0.12631,0.88801,-0.00605>,<0.12837,0.89816,-0.01343>,<0.13166,0.92083,-0.03311>,
              <0.13237,0.94071,-0.0556>,<0.13025,0.94633,-0.06755>,<0.12698,0.93486,-0.06149>,
              <0.1249,0.9135,-0.04049>,<0.1254,0.89493,-0.01668><0.0704,0.91611,-0.10525>,<0.0826,0.91952,-0.10409>,<0.1106,0.93053,-0.10146>,
              <0.13641,0.9457,-0.0991>,<0.14503,0.9559,-0.09836>,<0.1318,0.95444,-0.09964>,
              <0.10483,0.94148,-0.10215>,<0.08006,0.92436,-0.10439><0.18737,0.90335,-0.07719>,<0.18508,0.91391,-0.08391>,<0.17757,0.93734,-0.10142>,
              <0.16705,0.95767,-0.12085>,<0.15987,0.96319,-0.1307>,<0.16074,0.95118,-0.12487>,
              <0.16967,0.9292,-0.10646>,<0.1816,0.91032,-0.08614><0.09698,0.9593,-0.19951>,<0.10884,0.95722,-0.1954>,<0.13731,0.95533,-0.18548>,
              <0.16552,0.95816,-0.1756>,<0.17697,0.96375,-0.17155>,<0.165,0.96805,-0.17568>,
              <0.13665,0.96772,-0.18558>,<0.10855,0.96268,-0.19544><0.23176,0.92936,-0.12001>,<0.2255,0.93669,-0.12833>,<0.2088,0.95167,-0.14854>,
              <0.1897,0.9626,-0.16896>,<0.17953,0.96332,-0.17762>,<0.18465,0.95409,-0.1694>,
              <0.20249,0.94101,-0.14909>,<0.22272,0.93199,-0.12857><0.12394,0.91505,-0.24064>,<0.13481,0.91821,-0.23483>,<0.16011,0.92858,-0.222>,
              <0.18399,0.94307,-0.21099>,<0.19256,0.95294,-0.20814>,<0.18103,0.95172,-0.2148>,
              <0.15639,0.93941,-0.22677>,<0.13317,0.92299,-0.23693><0.0507,0.99335,-0.06498>,<0.0597,0.98941,-0.05689>,<0.08305,0.98166,-0.03938>,
              <0.10885,0.97659,-0.02488>,<0.12184,0.97701,-0.02171>,<0.11399,0.98221,-0.03122>,
              <0.08949,0.98869,-0.04731>,<0.06254,0.99251,-0.06039><0.06443,0.98361,0.01341>,<0.07685,0.98437,0.01078>,<0.10625,0.98318,0.00395>,
              <0.13472,0.97741,-0.00363>,<0.14566,0.97073,-0.00747>,<0.1328,0.96782,-0.00519>,
              <0.10384,0.97117,0.00199>,<0.07579,0.97908,0.00992><0.15567,0.93207,-0.05017>,<0.1602,0.93322,-0.03833>,<0.17266,0.93826,-0.01128>,
              <0.18743,0.9467,0.01346>,<0.19572,0.9534,0.02154>,<0.19228,0.95385,0.00862>,
              <0.17874,0.94722,-0.01734>,<0.16288,0.93717,-0.041><0.14677,0.92197,0.0702>,<0.15854,0.92598,0.0675>,<0.18648,0.93345,0.0588>,
              <0.21369,0.93761,0.04682>,<0.22429,0.93621,0.03878>,<0.21218,0.93065,0.03994>,
              <0.18458,0.92473,0.05018>,<0.1577,0.92214,0.0637><0.21269,0.89037,-0.02598>,<0.21457,0.89397,-0.01392>,<0.22108,0.90454,0.01361>,
              <0.23054,0.91791,0.03877>,<0.23724,0.92609,0.04697>,<0.23674,0.92381,0.0338>,
              <0.22885,0.91193,0.00738>,<0.218,0.89723,-0.01667><0.16977,0.90871,0.08472>,<0.18199,0.91139,0.08245>,<0.2107,0.91622,0.07442>,
              <0.23819,0.91855,0.06257>,<0.24844,0.91717,0.05408>,<0.23564,0.91332,0.05456>,
              <0.2075,0.90966,0.06438>,<0.18058,0.9085,0.07802><0.24795,0.82288,0.01305>,<0.24913,0.83062,0.02308>,<0.25427,0.85029,0.04541>,
              <0.26286,0.87148,0.06487>,<0.26965,0.88167,0.07026>,<0.27009,0.87464,0.05889>,
              <0.26333,0.85425,0.0379>,<0.25312,0.83236,0.01978><0.1831,1.04028,-0.08971>,<0.17391,1.03633,-0.08184>,<0.1527,1.02944,-0.06147>,
              <0.13298,1.02651,-0.03902>,<0.12621,1.02902,-0.02776>,<0.1361,1.03483,-0.03465>,
              <0.15661,1.03986,-0.05599>,<0.17563,1.04093,-0.07943><0.1684,1.02224,-0.01238>,<0.15602,1.0246,-0.01413>,<0.12611,1.02736,-0.01731>,
              <0.09618,1.02567,-0.01891>,<0.08375,1.02079,-0.01808>,<0.09611,1.01634,-0.01559>,
              <0.12603,1.01567,-0.01315>,<0.15598,1.01945,-0.0123><0.14265,1.01831,-0.04873>,<0.13096,1.01545,-0.04458>,<0.10318,1.01145,-0.03343>,
              <0.07604,1.01182,-0.0206>,<0.06539,1.01606,-0.0137>,<0.07738,1.02097,-0.01706>,
              <0.10486,1.02292,-0.029>,<0.1317,1.02051,-0.04263><0.02629,0.99111,-0.08884>,<0.02795,0.99623,-0.07731>,<0.03396,1.00617,-0.04944>,
              <0.04296,1.01246,-0.02149>,<0.0495,1.01164,-0.00985>,<0.04925,1.00481,-0.02135>,
              <0.04183,0.99658,-0.04926>,<0.03142,0.99201,-0.07723><-0.09197,0.97069,0.03136>,<-0.07957,0.97009,0.02858>,<-0.05051,0.97128,0.02046>,
              <-0.02277,0.97647,0.0102>,<-0.01252,0.98237,0.00395>,<-0.02555,0.98485,0.00572>,
              <-0.05399,0.98178,0.01484>,<-0.08111,0.97471,0.02611><0.01725,0.93906,-0.06064>,<0.00998,0.94572,-0.05259>,<-0.00572,0.96017,-0.03123>,
              <-0.01864,0.97219,-0.00693>,<-0.02137,0.97488,0.00589>,<-0.0128,0.96708,-0.00078>,
              <0.0016,0.95377,-0.02353>,<0.0132,0.94289,-0.0492><-0.10721,0.88379,0.03471>,<-0.09707,0.89121,0.0327>,<-0.07489,0.91072,0.02645>,
              <-0.05617,0.93266,0.01808>,<-0.05167,0.94401,0.01263>,<-0.06343,0.93773,0.01365>,
              <-0.08398,0.91707,0.02089>,<-0.10108,0.89401,0.03025><0.08956,1.04099,-0.04588>,<0.1007,1.04711,-0.04548>,<0.1256,1.0641,-0.04356>,
              <0.14746,1.08441,-0.04021>,<0.15367,1.09594,-0.03747>,<0.1411,1.09137,-0.03721>,
              <0.11763,1.07283,-0.0398>,<0.09719,1.05096,-0.04382><0.18277,1.04255,-0.03693>,<0.18195,1.0552,-0.03802>,<0.17852,1.08475,-0.04325>,
              <0.1729,1.1128,-0.05238>,<0.1685,1.12301,-0.05982>,<0.16829,1.10965,-0.06056>,
              <0.17275,1.08081,-0.0535>,<0.17941,1.05347,-0.04254><0.09452,1.10472,-0.08844>,<0.10701,1.10625,-0.08657>,<0.13595,1.11238,-0.08052>,
              <0.16307,1.1222,-0.07215>,<0.17258,1.12973,-0.06651>,<0.15923,1.12993,-0.0673>,
              <0.13114,1.12207,-0.07444>,<0.10489,1.11052,-0.08389><0.2121,1.06555,-0.0693>,<0.20908,1.07791,-0.06903>,<0.20014,1.1067,-0.07079>,
              <0.18867,1.13391,-0.07622>,<0.18156,1.1437,-0.08192>,<0.18339,1.1306,-0.08392>,
              <0.19352,1.10255,-0.08043>,<0.20617,1.07608,-0.07327><0.12658,1.12547,-0.14268>,<0.13772,1.12829,-0.13722>,<0.16291,1.13766,-0.12346>,
              <0.18556,1.15092,-0.10887>,<0.19255,1.16006,-0.10205>,<0.18021,1.15907,-0.10713>,
              <0.15621,1.14787,-0.12127>,<0.13476,1.13279,-0.13625><0.28094,1.14179,-0.11433>,<0.27062,1.14916,-0.11522>,<0.24512,1.16476,-0.11953>,
              <0.21878,1.17704,-0.12707>,<0.20707,1.17901,-0.13324>,<0.217,1.17007,-0.13387>,
              <0.2429,1.15603,-0.12805>,<0.26964,1.14531,-0.11898><0.15346,1.14349,-0.19069>,<0.16323,1.14678,-0.18324>,<0.1851,1.15733,-0.16528>,
              <0.20435,1.17181,-0.14736>,<0.20987,1.1815,-0.13998>,<0.19887,1.18006,-0.14745>,
              <0.17823,1.16766,-0.16539>,<0.16021,1.15133,-0.18329><0.30322,1.15965,-0.18031>,<0.29263,1.16641,-0.17831>,<0.26605,1.18043,-0.17533>,
              <0.23794,1.19099,-0.17517>,<0.22486,1.19211,-0.17775>,<0.23473,1.18372,-0.18108>,
              <0.26203,1.17132,-0.18273>,<0.29086,1.16239,-0.18157><-0.0051,0.26062,0.01313>,<0.00241,0.2506,0.01083>,<0.02184,0.22867,0.00354>,
              <0.04326,0.21011,-0.00639>,<0.05398,0.2056,-0.01299>,<0.04739,0.21719,-0.01194>,
              <0.02703,0.23754,-0.00341>,<0.00469,0.25451,0.00777><0.09012,0.14387,-0.01406>,<0.08939,0.14209,-0.02664>,<0.08511,0.13625,-0.05596>,
              <0.07705,0.12807,-0.0837>,<0.07015,0.12249,-0.09371>,<0.0691,0.12318,-0.08039>,
              <0.07515,0.13012,-0.05181>,<0.085,0.13939,-0.02481><0.00681,0.12873,-0.11421>,<0.01582,0.11976,-0.11375>,<0.0382,0.09955,-0.11536>,
              <0.06149,0.08148,-0.12107>,<0.072,0.07602,-0.12729>,<0.06342,0.086,-0.12967>,
              <0.04061,0.1052,-0.12614>,<0.01689,0.12226,-0.1185><0.08647,-0.09524,-0.11158>,<0.08366,-0.08911,-0.12237>,<0.0741,-0.07434,-0.14692>,
              <0.06041,-0.0596,-0.1692>,<0.05084,-0.05352,-0.17632>,<0.05171,-0.05967,-0.16447>,
              <0.06321,-0.07443,-0.14098>,<0.07885,-0.08915,-0.11975><0.05828,0.35417,-0.00949>,<0.05901,0.34304,-0.00337>,<0.06358,0.31745,0.01201>,
              <0.07234,0.29381,0.02832>,<0.07992,0.28585,0.03594>,<0.08115,0.2979,0.03026>,
              <0.07461,0.32257,0.01444>,<0.06388,0.34529,-0.0023><0.05617,0.28468,0.07415>,<0.0662,0.27684,0.07418>,<0.0883,0.25633,0.07257>,
              <0.10724,0.23341,0.0684>,<0.11212,0.22165,0.06428>,<0.10061,0.22836,0.06305>,
              <0.07999,0.25,0.06587>,<0.06253,0.27405,0.07123><0.09337,0.2194,0.01417>,<0.0961,0.21322,0.02495>,<0.10552,0.19906,0.04991>,
              <0.11922,0.18606,0.07325>,<0.12891,0.18177,0.0814>,<0.1282,0.18849,0.06986>,
              <0.11677,0.2021,0.04566>,<0.10106,0.21455,0.02308><0.07051,0.10883,0.11452>,<0.08261,0.10558,0.11672>,<0.11144,0.09689,0.11904>,
              <0.13967,0.0869,0.11686>,<0.15081,0.08155,0.11173>,<0.13842,0.08419,0.10742>,
              <0.10987,0.09349,0.10721>,<0.08192,0.10408,0.11151><0.13895,-0.0308,0.04569>,<0.13745,-0.02707,0.05777>,<0.13697,-0.01817,0.08662>,
              <0.14119,-0.00945,0.11504>,<0.14734,-0.00599,0.1264>,<0.15104,-0.0098,0.11413>,
              <0.14932,-0.01862,0.08548>,<0.1429,-0.02726,0.05726><0.13151,0.34703,0.00142>,<0.11989,0.3426,0.00413>,<0.09169,0.33489,0.01169>,
              <0.06325,0.33165,0.02077>,<0.05125,0.33449,0.02596>,<0.06277,0.34101,0.02396>,
              <0.09108,0.34662,0.01569>,<0.11962,0.34777,0.0059><-0.00323,0.3052,0.1021>,<-0.00468,0.30864,0.08994>,<-0.01051,0.31486,0.06097>,
              <-0.01981,0.31795,0.03258>,<-0.02693,0.31627,0.02138>,<-0.0271,0.31136,0.03382>,
              <-0.01964,0.30661,0.06251>,<-0.00871,0.305,0.09062><-0.18401,0.30087,0.03711>,<-0.17195,0.29735,0.03511>,<-0.14309,0.29141,0.02849>,
              <-0.11463,0.28931,0.01916>,<-0.10321,0.29206,0.01276>,<-0.11546,0.29738,0.01349>,
              <-0.14413,0.30152,0.02138>,<-0.17241,0.30181,0.03198><-0.09077,0.25106,-0.05712>,<-0.09971,0.25537,-0.04916>,<-0.12006,0.26341,-0.02834>,
              <-0.13855,0.26784,-0.0051>,<-0.14446,0.26629,0.0068>,<-0.13465,0.26028,-0.00003>,
              <-0.11518,0.25394,-0.02198>,<-0.09756,0.2512,-0.04636><-0.18616,0.1549,0.06086>,<-0.18938,0.1602,0.04975>,<-0.1988,0.1747,0.02499>,
              <-0.21068,0.19176,0.00333>,<-0.21792,0.20124,-0.00273>,<-0.21586,0.19714,0.00983>,
              <-0.20528,0.18144,0.03314>,<-0.19224,0.16317,0.05334><0.03363,0.39981,0.01307>,<0.04386,0.39225,0.01263>,<0.06919,0.37615,0.00935>,
              <0.09551,0.36327,0.00278>,<0.10733,0.36097,-0.00305>,<0.09757,0.37004,-0.00415>,
              <0.07177,0.38464,0.00068>,<0.04499,0.396,0.0088><0.09645,0.35275,0.03897>,<0.10383,0.3512,0.02872>,<0.11905,0.34589,0.00318>,
              <0.13035,0.33823,-0.02356>,<0.13135,0.33284,-0.03577>,<0.12214,0.33329,-0.02608>,
              <0.10876,0.33971,0.00002>,<0.0993,0.34847,0.02733><0.09733,0.30632,-0.10909>,<0.1077,0.29989,-0.10549>,<0.13385,0.28622,-0.09905>,
              <0.16169,0.2754,-0.09598>,<0.1748,0.27357,-0.09788>,<0.16522,0.28134,-0.10307>,
              <0.13828,0.29367,-0.10793>,<0.10965,0.30317,-0.10941><0.18993,0.21704,-0.04122>,<0.19288,0.22031,-0.05316>,<0.19722,0.22681,-0.08233>,
              <0.19735,0.23121,-0.11203>,<0.19347,0.23108,-0.12483>,<0.18854,0.22683,-0.11314>,
              <0.18618,0.22131,-0.08372>,<0.18802,0.21789,-0.05377><0.11578,0.22038,-0.13859>,<0.12794,0.21841,-0.13542>,<0.15754,0.21472,-0.13068>,
              <0.18749,0.21264,-0.13037>,<0.20023,0.21329,-0.13439>,<0.18823,0.21602,-0.13965>,
              <0.15847,0.21896,-0.14231>,<0.12835,0.22028,-0.14054><0.10409,0.3715,0.00622>,<0.10241,0.37989,0.01564>,<0.09986,0.40185,0.03621>,
              <0.09959,0.42637,0.05355>,<0.10162,0.43892,0.05768>,<0.10437,0.43174,0.04674>,
              <0.10585,0.40858,0.02768>,<0.10505,0.38286,0.01188><0.04326,0.42685,0.0963>,<0.05276,0.43527,0.09547>,<0.07721,0.45296,0.09425>,
              <0.10392,0.46668,0.0942>,<0.11711,0.46863,0.09529>,<0.10867,0.45834,0.09667>,
              <0.08316,0.44252,0.09734>,<0.05538,0.43067,0.09683><0.19473,0.45708,0.10274>,<0.18587,0.46133,0.11083>,<0.16497,0.47407,0.12851>,
              <0.14478,0.49056,0.14341>,<0.13709,0.50091,0.14698>,<0.14628,0.49842,0.13758>,
              <0.16685,0.48392,0.12121>,<0.1867,0.46567,0.10761><0.09194,0.47228,0.2249>,<0.09938,0.48174,0.22075>,<0.11932,0.50213,0.21082>,
              <0.14223,0.51887,0.20101>,<0.15452,0.52237,0.19706>,<0.14849,0.5112,0.20127>,
              <0.12715,0.49252,0.21114>,<0.10284,0.4775,0.22089><0.24284,0.48189,0.30358>,<0.23234,0.48905,0.30293>,<0.20913,0.50814,0.29997>,
              <0.18914,0.52997,0.2949>,<0.18389,0.54158,0.29082>,<0.19591,0.5357,0.29048>,
              <0.2176,0.51532,0.29444>,<0.23607,0.49221,0.30049><0.11189,0.44419,-0.00403>,<0.09999,0.43967,-0.00382>,<0.07119,0.43101,-0.00114>,
              <0.04224,0.42574,0.00482>,<0.0301,0.42675,0.01036>,<0.04192,0.43287,0.01169>,
              <0.0708,0.43994,0.00747>,<0.09982,0.44361,-0.00003><0.06773,0.42782,0.06586>,<0.06075,0.42743,0.05523>,<0.04224,0.42468,0.03153>,
              <0.02127,0.41918,0.01076>,<0.01025,0.41432,0.00492>,<0.01608,0.41342,0.01693>,
              <0.03575,0.41747,0.03925>,<0.05788,0.42425,0.05864><0.01176,0.40494,0.06793>,<0.00758,0.40047,0.05677>,<-0.00429,0.39221,0.03026>,
              <-0.01888,0.38776,0.0044>,<-0.02746,0.38949,-0.00571>,<-0.02456,0.39575,0.00575>,
              <-0.01141,0.40223,0.03195>,<0.00444,0.40489,0.05752><0.00019,0.32995,-0.05304>,<-0.01171,0.3335,-0.05027>,<-0.0396,0.34049,-0.04102>,
              <-0.06621,0.34509,-0.0279>,<-0.07605,0.34474,-0.01884>,<-0.06355,0.34006,-0.0198>,
              <-0.03626,0.33419,-0.03086>,<-0.01024,0.33072,-0.04579><-0.09736,0.31317,0.05612>,<-0.09719,0.31008,0.04378>,<-0.09936,0.30439,0.0142>,
              <-0.1054,0.30137,-0.01506>,<-0.11155,0.30263,-0.02688>,<-0.11354,0.30698,-0.01438>,
              <-0.10955,0.31141,0.01505>,<-0.10169,0.31318,0.04415><0.03974,0.55996,0.00976>,<0.04986,0.55276,0.01254>,<0.07549,0.53752,0.01733>,
              <0.10294,0.5255,0.01917>,<0.11602,0.52353,0.01718>,<0.10676,0.53224,0.01301>,
              <0.08027,0.54597,0.0096>,<0.05197,0.55648,0.00914><0.10403,0.51722,0.0562>,<0.11418,0.51635,0.04858>,<0.13687,0.51191,0.02914>,
              <0.1568,0.50396,0.00814>,<0.16248,0.49738,-0.00203>,<0.15104,0.49661,0.00486>,
              <0.12965,0.5027,0.02503>,<0.111,0.51229,0.04676><0.12274,0.4836,-0.04569>,<0.13341,0.47942,-0.04016>,<0.16024,0.47148,-0.02881>,
              <0.1887,0.46681,-0.02046>,<0.20202,0.46794,-0.01981>,<0.19211,0.47366,-0.02675>,
              <0.16451,0.48006,-0.03669>,<0.13529,0.4832,-0.04364><0.21387,0.46694,0.04005>,<0.21939,0.46417,0.02892>,<0.23026,0.45554,0.00211>,
              <0.23744,0.44396,-0.02465>,<0.23695,0.4364,-0.03568>,<0.2297,0.43778,-0.02452>,
              <0.22056,0.4478,0.00227>,<0.21511,0.46076,0.029><0.18949,0.38994,-0.08447>,<0.19979,0.38979,-0.077>,<0.22563,0.39107,-0.06143>,
              <0.25298,0.39481,-0.0496>,<0.26571,0.39867,-0.04822>,<0.25612,0.39998,-0.05745>,
              <0.22957,0.39754,-0.07126>,<0.20152,0.39265,-0.08133><0.2692,0.35111,0.02496>,<0.27458,0.35273,0.01354>,<0.28477,0.35536,-0.01476>,
              <0.29079,0.35609,-0.04417>,<0.28936,0.35461,-0.05739>,<0.28203,0.35211,-0.04649>,
              <0.27379,0.35036,-0.01766>,<0.26974,0.35052,0.01226><0.12405,0.58328,-0.01862>,<0.12279,0.57753,-0.00734>,<0.12156,0.56613,0.0206>,
              <0.12305,0.55843,0.04958>,<0.12622,0.55873,0.06258>,<0.12876,0.56622,0.05179>,
              <0.12871,0.57588,0.02336>,<0.12595,0.58183,-0.00612><0.06266,0.56708,0.05969>,<0.07314,0.56534,0.06669>,<0.0985,0.55869,0.08168>,
              <0.12397,0.54833,0.09374>,<0.13462,0.54056,0.096>,<0.12419,0.54055,0.08762>,
              <0.09878,0.54895,0.07401>,<0.07326,0.56104,0.06331><0.13492,0.51032,0.04425>,<0.13353,0.51062,0.0569>,<0.13307,0.51252,0.08703>,
              <0.13695,0.51618,0.11658>,<0.14263,0.51935,0.12827>,<0.14605,0.51988,0.11535>,
              <0.14447,0.51716,0.08549>,<0.13856,0.51267,0.05622><0.07344,0.45845,0.1851>,<0.0856,0.45875,0.18883>,<0.11505,0.45751,0.1954>,
              <0.14464,0.45329,0.1983>,<0.15702,0.44875,0.19606>,<0.14492,0.44706,0.19061>,
              <0.11541,0.4497,0.18577>,<0.08576,0.45531,0.18458><0.18672,0.39944,0.13347>,<0.17997,0.40209,0.14392>,<0.16655,0.40932,0.16999>,
              <0.15749,0.41783,0.19733>,<0.15784,0.42254,0.20984>,<0.16665,0.42049,0.19999>,
              <0.17802,0.41266,0.17332>,<0.18502,0.40356,0.14539><0.08025,0.36355,0.2032>,<0.09065,0.36812,0.20894>,<0.11692,0.37786,0.2202>,
              <0.14497,0.38566,0.22755>,<0.15826,0.38706,0.22692>,<0.1487,0.38157,0.21934>,
              <0.12159,0.37274,0.20991>,<0.0927,0.36586,0.20441><0.18208,0.61833,-0.01175>,<0.16968,0.61557,-0.01107>,<0.14002,0.61123,-0.00735>,
              <0.11079,0.61042,-0.00052>,<0.09909,0.61338,0.00524>,<0.11169,0.61779,0.00602>,
              <0.14115,0.62048,0.00085>,<0.17017,0.61964,-0.00745><0.10365,0.57452,0.02061>,<0.09567,0.57913,0.01184>,<0.07452,0.58848,-0.00759>,
              <0.05053,0.59514,-0.02437>,<0.03793,0.59537,-0.02885>,<0.04457,0.58949,-0.01883>,
              <0.06705,0.58141,-0.00065>,<0.09238,0.57602,0.0149><0.00134,0.60264,0.04562>,<0.00597,0.59848,0.03453>,<0.01638,0.5914,0.00708>,
              <0.02563,0.58879,-0.02137>,<0.02836,0.5919,-0.03409>,<0.02318,0.59815,-0.02346>,
              <0.01332,0.60313,0.00446>,<0.00462,0.60365,0.03337><0.04704,0.52699,-0.07428>,<0.03598,0.53313,-0.07557>,<0.00867,0.54601,-0.07631>,
              <-0.01952,0.55595,-0.07346>,<-0.03202,0.55731,-0.06891>,<-0.02137,0.54979,-0.06593>,
              <0.00635,0.53829,-0.06688>,<0.03495,0.52973,-0.07141><-0.08577,0.50088,-0.00888>,<-0.08171,0.50135,-0.02093>,<-0.07438,0.50442,-0.05007>,
              <-0.07076,0.5104,-0.07927>,<-0.07274,0.51562,-0.09142>,<-0.07854,0.51653,-0.0794>,
              <-0.08413,0.51209,-0.05024>,<-0.08601,0.50473,-0.02101><-0.13445,0.45589,-0.15126>,<-0.12939,0.46367,-0.14255>,<-0.11469,0.48081,-0.1225>,
              <-0.09624,0.49548,-0.10389>,<-0.08508,0.49923,-0.09755>,<-0.08838,0.49029,-0.10694>,
              <-0.10484,0.47431,-0.12631>,<-0.12505,0.46081,-0.14423><0.08809,0.69299,0.00599>,<0.09856,0.68576,0.006>,<0.12469,0.67072,0.00427>,
              <0.15214,0.65937,-0.00012>,<0.16474,0.65812,-0.00443>,<0.15489,0.66708,-0.00569>,
              <0.12814,0.68039,-0.00271>,<0.10008,0.69002,0.00293><0.17187,0.63064,0.03073>,<0.17787,0.63072,0.01951>,<0.18983,0.62919,-0.00818>,
              <0.19796,0.62503,-0.03678>,<0.19776,0.62083,-0.04948>,<0.18997,0.61951,-0.03869>,
              <0.1798,0.62228,-0.01057>,<0.17346,0.62768,0.01846><0.12748,0.66359,-0.0635>,<0.13645,0.65492,-0.06099>,<0.15981,0.63652,-0.05574>,
              <0.18572,0.62189,-0.05169>,<0.19885,0.61939,-0.05115>,<0.19108,0.62983,-0.05422>,
              <0.16652,0.64646,-0.05891>,<0.13941,0.65931,-0.06239><0.22167,0.5278,-0.02544>,<0.2255,0.53165,-0.03695>,<0.23187,0.53984,-0.06531>,
              <0.23391,0.54637,-0.09455>,<0.23069,0.54752,-0.10748>,<0.22482,0.5429,-0.09638>,
              <0.22049,0.53548,-0.06761>,<0.22048,0.52973,-0.03796><0.15246,0.56642,-0.11465>,<0.16383,0.56148,-0.11178>,<0.19173,0.55064,-0.10774>,
              <0.22031,0.54146,-0.10806>,<0.2328,0.53922,-0.1123>,<0.22176,0.54494,-0.11722>,
              <0.19354,0.555,-0.11921>,<0.16463,0.5634,-0.11683><0.21042,0.45307,-0.05868>,<0.21648,0.45902,-0.06815>,<0.22813,0.47335,-0.09205>,
              <0.23532,0.48757,-0.1175>,<0.23411,0.49338,-0.12948>,<0.22596,0.48738,-0.12073>,
              <0.21641,0.4731,-0.09611>,<0.21131,0.45892,-0.06994><0.16917,0.69508,-0.02789>,<0.16557,0.69909,-0.01636>,<0.15883,0.71107,0.01053>,
              <0.15498,0.72649,0.036>,<0.15612,0.73611,0.04523>,<0.16108,0.73371,0.03304>,
              <0.16646,0.72011,0.00681>,<0.16894,0.70308,-0.018><0.07196,0.73424,0.06643>,<0.08238,0.73974,0.07124>,<0.10803,0.74997,0.08347>,
              <0.13441,0.75565,0.09665>,<0.14602,0.75371,0.103>,<0.13594,0.74607,0.09864>,
              <0.10995,0.73798,0.08596>,<0.08323,0.73445,0.07234><0.19597,0.71013,0.1108>,<0.186,0.71586,0.11625>,<0.16376,0.73211,0.12863>,
              <0.14429,0.75201,0.13987>,<0.13882,0.76368,0.14345>,<0.15009,0.75966,0.13747>,
              <0.17103,0.7417,0.12563>,<0.18921,0.72008,0.11492><0.0506,0.72449,0.20031>,<0.05978,0.73321,0.20153>,<0.08355,0.75157,0.20472>,
              <0.10971,0.76588,0.20831>,<0.12278,0.768,0.21016>,<0.11472,0.75737,0.20913>,
              <0.08983,0.74092,0.20575>,<0.06255,0.72852,0.20198><0.14954,0.68832,0.22234>,<0.14231,0.69878,0.22292>,<0.12775,0.72518,0.22468>,
              <0.11754,0.75333,0.22695>,<0.11741,0.76663,0.22837>,<0.12668,0.75699,0.22803>,
              <0.13919,0.72977,0.22603>,<0.14735,0.7008,0.22352><0.01595,0.74233,0.2745>,<0.02774,0.74698,0.27558>,<0.05674,0.75514,0.27773>,
              <0.08652,0.7587,0.2792>,<0.09959,0.75585,0.27917>,<0.08816,0.74904,0.27778>,
              <0.0588,0.74304,0.27595>,<0.02865,0.74164,0.27479><0.25501,0.78747,-0.00041>,<0.24245,0.78718,0.00155>,<0.21294,0.78918,0.00765>,
              <0.18469,0.79521,0.01585>,<0.17417,0.8015,0.02121>,<0.18733,0.80368,0.02024>,
              <0.21625,0.79979,0.01315>,<0.24391,0.79186,0.00397><0.19325,0.76977,0.06615>,<0.18755,0.77632,0.05685>,<0.17149,0.79029,0.03542>,
              <0.15195,0.80147,0.01556>,<0.14059,0.80349,0.00879>,<0.14465,0.79563,0.01883>,
              <0.16234,0.78297,0.03952>,<0.18352,0.7731,0.05865><0.03003,0.79376,0.05497>,<0.03724,0.79207,0.04463>,<0.05418,0.7911,0.01964>,
              <0.07037,0.79478,-0.00537>,<0.07639,0.80069,-0.01576>,<0.06882,0.80456,-0.00543>,
              <0.05223,0.80335,0.01957>,<0.03639,0.79747,0.04459><0.13568,0.78556,-0.01885>,<0.12367,0.78915,-0.02107>,<0.09432,0.79508,-0.025>,
              <0.0644,0.79685,-0.02675>,<0.05147,0.79369,-0.02543>,<0.0632,0.78814,-0.02219>,
              <0.09282,0.78417,-0.01929>,<0.12301,0.78434,-0.01856><0.00351,0.74241,0.03552>,<0.00891,0.74646,0.02473>,<0.01985,0.75848,-0.00072>,
              <0.02763,0.7739,-0.02528>,<0.02788,0.78347,-0.03462>,<0.021,0.78102,-0.02342>,
              <0.01155,0.7674,0.00162>,<0.00525,0.75039,0.02577><-0.09632,0.70951,-0.08627>,<-0.08779,0.71669,-0.08014>,<-0.06541,0.73174,-0.06655>,
              <-0.04035,0.74335,-0.05477>,<-0.02746,0.74494,-0.05159>,<-0.03473,0.73614,-0.05857>,
              <-0.05837,0.72271,-0.07131>,<-0.08468,0.71271,-0.08224><0.13718,0.83036,-0.00442>,<0.14886,0.82884,0.00038>,<0.17708,0.82819,0.01111>,
              <0.20533,0.83206,0.02053>,<0.21706,0.83792,0.02318>,<0.20539,0.84157,0.01776>,
              <0.17715,0.8401,0.00765>,<0.14889,0.83409,-0.00114><0.18756,0.80967,0.06138>,<0.19745,0.81581,0.05624>,<0.22073,0.82841,0.0417>,
              <0.2431,0.83768,0.02395>,<0.25151,0.83838,0.01357>,<0.24119,0.83068,0.0172>,
              <0.21834,0.81965,0.03325>,<0.1964,0.81195,0.05252><0.2179,0.83331,-0.04847>,<0.22746,0.83111,-0.04037>,<0.25073,0.8289,-0.02126>,
              <0.27431,0.83135,-0.00282>,<0.28435,0.83674,0.00418>,<0.27492,0.84113,-0.00424>,
              <0.25151,0.84116,-0.02303>,<0.2278,0.83652,-0.04115><0.25261,0.807,0.06797>,<0.25946,0.81355,0.05948>,<0.27541,0.82668,0.03745>,
              <0.29045,0.8358,0.01311>,<0.29582,0.8358,0.00086>,<0.28854,0.82737,0.00827>,
              <0.27303,0.81613,0.03138>,<0.25841,0.80889,0.0568><0.29433,0.80919,-0.07881>,<0.30202,0.80874,-0.06867>,<0.32122,0.81047,-0.04543>,
              <0.34142,0.81643,-0.02402>,<0.35071,0.82287,-0.01688>,<0.34349,0.82531,-0.02788>,
              <0.32382,0.82159,-0.05026>,<0.30316,0.81365,-0.0708><0.38626,0.74948,0.0329>,<0.38915,0.7587,0.02461>,<0.39454,0.77891,0.00283>,
              <0.39759,0.79604,-0.02164>,<0.39665,0.80023,-0.03431>,<0.39266,0.78956,-0.02729>,
              <0.38837,0.7708,-0.00424>,<0.38642,0.75513,0.02149><0.36925,0.77655,-0.11274>,<0.37392,0.77661,-0.1009>,<0.38634,0.77941,-0.07352>,
              <0.40051,0.78619,-0.04794>,<0.40803,0.79276,-0.03903>,<0.4042,0.79457,-0.05171>,
              <0.39095,0.7899,-0.07825>,<0.37595,0.78124,-0.10299><0.24586,0.95145,-0.01181>,<0.24015,0.94162,-0.00611>,<0.22868,0.91854,0.00964>,
              <0.22074,0.89645,0.02836>,<0.22076,0.88824,0.03892>,<0.22813,0.89854,0.03462>,
              <0.23794,0.92115,0.01747>,<0.24423,0.94277,-0.00265><0.17289,0.92524,0.00033>,<0.17821,0.91893,0.01002>,<0.19075,0.90147,0.03123>,
              <0.20283,0.88064,0.04916>,<0.2074,0.86885,0.05352>,<0.20187,0.87357,0.0423>,
              <0.18954,0.89261,0.02262>,<0.17768,0.91503,0.00622><0.23851,0.88978,0.00883>,<0.23054,0.88246,0.01552>,<0.21297,0.86618,0.03392>,
              <0.19795,0.852,0.05571>,<0.1941,0.84809,0.06791>,<0.20327,0.85639,0.06281>,
              <0.21964,0.87169,0.04282>,<0.23348,0.88489,0.01944><0.11985,0.84932,0.04226>,<0.12597,0.84372,0.05191>,<0.14182,0.82863,0.07272>,
              <0.15929,0.81117,0.08979>,<0.16806,0.80171,0.09334>,<0.1627,0.8062,0.08193>,
              <0.14609,0.8224,0.06288>,<0.12785,0.84098,0.04757><0.18256,0.76457,0.02157>,<0.17604,0.76645,0.03234>,<0.16326,0.77083,0.05934>,
              <0.15492,0.77498,0.08789>,<0.15566,0.77647,0.10116>,<0.16427,0.77448,0.09112>,
              <0.17496,0.77021,0.06339>,<0.1812,0.76618,0.03412><0.09732,0.79989,0.05055>,<0.10315,0.79493,0.06072>,<0.11897,0.78189,0.08289>,
              <0.13745,0.76725,0.10149>,<0.14758,0.75969,0.10585>,<0.143,0.7639,0.09401>,
              <0.12593,0.77769,0.07351>,<0.10622,0.79308,0.05658><0.17759,0.69214,0.04331>,<0.16918,0.69775,0.05104>,<0.15141,0.71106,0.07151>,
              <0.13747,0.72401,0.09474>,<0.13528,0.72904,0.10694>,<0.14548,0.72327,0.1005>,
              <0.16146,0.71013,0.07874>,<0.17361,0.69734,0.05422><0.19182,0.96403,0.08538>,<0.19796,0.95667,0.07701>,<0.21298,0.94174,0.05549>,
              <0.22831,0.93108,0.03197>,<0.23495,0.93067,0.02037>,<0.22895,0.94003,0.0278>,
              <0.21379,0.95296,0.05026>,<0.19831,0.96162,0.07471><0.24445,0.93756,0.08438>,<0.24353,0.93655,0.07173>,<0.23879,0.93252,0.04218>,
              <0.23026,0.92611,0.01412>,<0.22316,0.92123,0.00389>,<0.22229,0.92112,0.01723>,
              <0.22881,0.92627,0.04609>,<0.23913,0.93379,0.07346><0.16001,0.92617,0.05085>,<0.16819,0.92143,0.04234>,<0.18666,0.91237,0.02023>,
              <0.2032,0.90692,-0.00424>,<0.20824,0.90806,-0.01658>,<0.19915,0.9145,-0.00917>,
              <0.18159,0.92186,0.01405>,<0.16596,0.92561,0.03962><0.2336,0.88303,0.01797>,<0.22811,0.88408,0.00654>,<0.21264,0.88515,-0.01937>,
              <0.19384,0.88403,-0.04275>,<0.18292,0.8815,-0.05007>,<0.18686,0.87942,-0.03745>,
              <0.20389,0.87938,-0.01273>,<0.22425,0.88154,0.00947><0.10574,0.8909,-0.01682>,<0.11612,0.88528,-0.02157>,<0.14056,0.8739,-0.03517>,
              <0.16406,0.86581,-0.05202>,<0.17291,0.86555,-0.06204>,<0.16209,0.87272,-0.05882>,
              <0.13809,0.88256,-0.0437>,<0.11503,0.8891,-0.02533><0.22045,0.79403,-0.04893>,<0.21171,0.79928,-0.05654>,<0.18884,0.81065,-0.07267>,
              <0.16333,0.82001,-0.08544>,<0.15028,0.82201,-0.08758>,<0.15778,0.81582,-0.07839>,
              <0.18189,0.8054,-0.06384>,<0.20864,0.79697,-0.05265><0.08482,0.79088,-0.0375>,<0.09565,0.79273,-0.04391>,<0.11971,0.79875,-0.06114>,
              <0.14062,0.8071,-0.081>,<0.14633,0.81275,-0.0917>,<0.13402,0.812,-0.08652>,
              <0.11144,0.80489,-0.06805>,<0.092,0.79544,-0.04696><0.23589,1.0591,0.02868>,<0.23993,1.04709,0.02979>,<0.25237,1.01969,0.03239>,
              <0.26886,0.99473,0.03486>,<0.2795,0.98666,0.03577>,<0.27736,0.99981,0.03461>,
              <0.26301,1.02607,0.03207>,<0.24462,1.0499,0.02965><0.26059,1.03477,0.07384>,<0.26718,1.02595,0.06748>,<0.28016,1.0036,0.05185>,
              <0.28869,0.97969,0.03582>,<0.28807,0.96831,0.0288>,<0.27939,0.97641,0.03498>,
              <0.2685,0.99949,0.05079>,<0.26204,1.02413,0.06701><0.26201,1.00505,-0.01182>,<0.26533,0.99354,-0.00752>,<0.27611,0.96716,0.00248>,
              <0.29107,0.94291,0.01194>,<0.30119,0.93485,0.01533>,<0.29984,0.94735,0.01078>,
              <0.2871,0.97273,0.00103>,<0.27017,0.996,-0.00816><0.2481,0.9568,0.05773>,<0.25844,0.95143,0.05261>,<0.28133,0.93833,0.03791>,
              <0.3011,0.925,0.01966>,<0.30637,0.91927,0.00878>,<0.29457,0.92453,0.01224>,
              <0.27314,0.93773,0.02861>,<0.25482,0.95117,0.04851><0.27677,0.94412,-0.04837>,<0.27959,0.93446,-0.04059>,<0.2892,0.91178,-0.02312>,
              <0.30298,0.89007,-0.00761>,<0.31261,0.88198,-0.00305>,<0.31174,0.8921,-0.01176>,
              <0.30018,0.91432,-0.02831>,<0.28443,0.93558,-0.04288><0.26778,0.83246,0.05854>,<0.27651,0.83308,0.0493>,<0.29493,0.83526,0.02547>,
              <0.30936,0.83845,-0.00067>,<0.31158,0.84072,-0.01366>,<0.30098,0.84058,-0.00551>,
              <0.28444,0.83792,0.01941>,<0.27188,0.83426,0.04663><0.24008,0.86571,-0.04915>,<0.24889,0.85996,-0.04199>,<0.27158,0.8463,-0.02749>,
              <0.29643,0.83298,-0.01717>,<0.30875,0.82777,-0.01683>,<0.30095,0.83367,-0.02596>,
              <0.27724,0.84717,-0.03849>,<0.25138,0.86035,-0.04684><0.30415,0.97565,0.04063>,<0.30182,0.98734,0.0451>,<0.29839,1.01608,0.05371>,
              <0.29828,1.04562,0.05907>,<0.30134,1.05861,0.05822>,<0.30523,1.04731,0.05222>,
              <0.3071,1.01819,0.04513>,<0.30566,0.98827,0.04131><0.22688,1.04215,0.08206>,<0.23726,1.0484,0.07815>,<0.26342,1.06173,0.07108>,
              <0.29125,1.07242,0.06754>,<0.30435,1.07438,0.0694>,<0.29476,1.06689,0.07496>,
              <0.26782,1.0548,0.08038>,<0.2392,1.04535,0.08226><0.31032,1.00248,0.09028>,<0.30729,1.01483,0.08979>,<0.30277,1.04457,0.08718>,
              <0.30247,1.07422,0.08245>,<0.30631,1.08641,0.07851>,<0.31132,1.07402,0.07801>,
              <0.31386,1.04432,0.08161>,<0.31218,1.01472,0.08733><0.22501,1.12292,0.0995>,<0.23761,1.1234,0.09781>,<0.26777,1.12275,0.09626>,
              <0.29751,1.11938,0.09855>,<0.30946,1.11542,0.10309>,<0.29666,1.11366,0.10659>,
              <0.2667,1.11559,0.10633>,<0.23714,1.12024,0.10225><0.3304,1.04822,0.14279>,<0.32481,1.05921,0.13962>,<0.31422,1.08608,0.13081>,
              <0.30796,1.11347,0.12022>,<0.30945,1.12531,0.11417>,<0.31708,1.11457,0.1165>,
              <0.32563,1.08745,0.12615>,<0.32985,1.05981,0.13757><0.22599,1.14611,0.1748>,<0.2372,1.14878,0.16942>,<0.26495,1.1527,0.15815>,
              <0.29369,1.15279,0.14946>,<0.30653,1.14923,0.14827>,<0.29578,1.14476,0.15486>,
              <0.26757,1.14264,0.16492>,<0.23836,1.14435,0.17241><0.36026,1.11482,0.2122>,<0.34957,1.11981,0.20746>,<0.32597,1.13357,0.19457>,
              <0.30573,1.14988,0.17955>,<0.30048,1.15903,0.17131>,<0.31275,1.15522,0.17506>,
              <0.33477,1.14027,0.18895>,<0.35345,1.12277,0.20497><0.21605,1.17107,0.20161>,<0.22803,1.17243,0.19754>,<0.25696,1.1728,0.1889>,
              <0.28592,1.1688,0.18205>,<0.29794,1.16304,0.18089>,<0.28597,1.15964,0.1858>,
              <0.25702,1.16132,0.19359>,<0.22805,1.16737,0.19961><0.01778,0.2445,-0.00043>,<0.02122,0.23464,0.00683>,<0.03165,0.21299,0.02513>,
              <0.04528,0.19462,0.04457>,<0.05394,0.19008,0.0537>,<0.05201,0.20148,0.04697>,
              <0.04007,0.22159,0.02814>,<0.02493,0.23842,0.00816><0.03984,0.13234,0.07405>,<0.05218,0.12972,0.07576>,<0.08145,0.12239,0.07695>,
              <0.10996,0.11355,0.07373>,<0.12106,0.10847,0.06827>,<0.10837,0.11038,0.06449>,
              <0.07945,0.11842,0.06537>,<0.0513,0.12797,0.07065><0.13411,0.13052,0.00826>,<0.13309,0.12116,0.01682>,<0.13327,0.1,0.03836>,
              <0.13746,0.08098,0.06122>,<0.14294,0.07511,0.07191>,<0.14584,0.08547,0.06397>,
              <0.14378,0.10563,0.04181>,<0.13772,0.12365,0.01834><0.11107,-0.02203,0.11171>,<0.12322,-0.0208,0.10814>,<0.15109,-0.0182,0.0968>,
              <0.17674,-0.01618,0.08132>,<0.18528,-0.01588,0.07103>,<0.17209,-0.01737,0.07266>,
              <0.14527,-0.0197,0.08594>,<0.12065,-0.02146,0.10336><0.04103,0.25442,0.07568>,<0.03028,0.26112,0.07688>,<0.0065,0.27932,0.08078>,
              <-0.01401,0.30057,0.08619>,<-0.01944,0.31223,0.08987>,<-0.00716,0.30696,0.08938>,
              <0.01509,0.28733,0.08477>,<0.03407,0.26465,0.07864><-0.11759,0.3351,0.0609>,<-0.11307,0.3406,0.07145>,<-0.10307,0.35108,0.09795>,
              <-0.09443,0.35731,0.12602>,<-0.09212,0.35592,0.13912>,<-0.09728,0.34842,0.12931>,
              <-0.10664,0.33994,0.10207>,<-0.11465,0.33569,0.07327><-0.12762,0.30839,0.21155>,<-0.13277,0.31768,0.20454>,<-0.14328,0.34169,0.18954>,
              <-0.15091,0.36808,0.17742>,<-0.15138,0.38125,0.17512>,<-0.14489,0.37308,0.18349>,
              <-0.13573,0.34795,0.19714>,<-0.12944,0.32044,0.20789><-0.22305,0.37821,0.11857>,<-0.21694,0.38264,0.12881>,<-0.20263,0.39033,0.15427>,
              <-0.18902,0.39348,0.18085>,<-0.18403,0.39053,0.19291>,<-0.19047,0.38397,0.18319>,
              <-0.20445,0.37841,0.1572>,<-0.21774,0.37739,0.1301><-0.32194,0.33796,0.20408>,<-0.31174,0.34498,0.20699>,<-0.28948,0.3638,0.2149>,
              <-0.27079,0.3854,0.22415>,<-0.26639,0.39696,0.22924>,<-0.27827,0.39124,0.22696>,
              <-0.29885,0.37112,0.21842>,<-0.31587,0.34821,0.20854><-0.00722,0.32615,0.02507>,<-0.00178,0.33664,0.02979>,<0.00837,0.36285,0.04083>,
              <0.01403,0.3904,0.05135>,<0.01215,0.40307,0.05521>,<0.0046,0.39321,0.05025>,
              <-0.00344,0.36637,0.03946>,<-0.00699,0.33819,0.02918><0.06155,0.40405,0.0627>,<0.05244,0.41253,0.0601>,<0.03068,0.43145,0.05111>,
              <0.00929,0.448,0.03806>,<0.00078,0.45262,0.02884>,<0.01007,0.44302,0.02953>,
              <0.03165,0.42522,0.04043>,<0.05286,0.40978,0.05539><-0.09475,0.48284,-0.01425>,<-0.08334,0.48733,-0.01765>,<-0.05655,0.50002,-0.02342>,
              <-0.0309,0.51548,-0.02555>,<-0.02134,0.52449,-0.02301>,<-0.03329,0.5213,-0.01791>,
              <-0.05955,0.50731,-0.01385>,<-0.08466,0.49055,-0.01343><0.03341,0.52833,-0.09871>,<0.02556,0.53304,-0.08987>,<0.0048,0.54228,-0.06998>,
              <-0.01867,0.54833,-0.05226>,<-0.03094,0.54785,-0.04696>,<-0.02436,0.54164,-0.05681>,
              <-0.00233,0.53389,-0.07569>,<0.02241,0.52934,-0.09239><-0.11593,0.52911,-0.0639>,<-0.10389,0.53249,-0.06627>,<-0.07581,0.54295,-0.07005>,
              <-0.0492,0.55683,-0.07095>,<-0.03956,0.5658,-0.0686>,<-0.05229,0.56403,-0.06488>,
              <-0.07968,0.55196,-0.06246>,<-0.1056,0.53647,-0.06292><0.03552,0.41187,0.0408>,<0.03795,0.40687,0.05225>,<0.04503,0.39768,0.08013>,
              <0.05394,0.39282,0.10839>,<0.05935,0.39487,0.12045>,<0.05778,0.40191,0.10918>,
              <0.04984,0.40907,0.08112>,<0.04007,0.41189,0.05268><0.08142,0.31459,0.17533>,<0.09138,0.32133,0.17948>,<0.11663,0.33604,0.18709>,
              <0.14371,0.34839,0.19105>,<0.15665,0.35129,0.18925>,<0.14755,0.34344,0.18337>,
              <0.12143,0.32984,0.17748>,<0.09349,0.3186,0.17525><0.15646,0.35852,0.10968>,<0.15569,0.35471,0.12179>,<0.15587,0.3479,0.15121>,
              <0.1591,0.34469,0.18089>,<0.16329,0.34673,0.19343>,<0.16549,0.35223,0.18143>,
              <0.16388,0.35735,0.15189>,<0.15922,0.35888,0.12209><0.12061,0.3025,0.24123>,<0.13252,0.30642,0.23912>,<0.16093,0.31365,0.23186>,
              <0.1888,0.31749,0.22135>,<0.19983,0.31591,0.21395>,<0.18765,0.31039,0.21454>,
              <0.1595,0.30476,0.22333>,<0.13189,0.3025,0.23536><0.2739,0.2114,0.16428>,<0.27005,0.21403,0.17611>,<0.26325,0.22224,0.20437>,
              <0.26022,0.23324,0.23214>,<0.26251,0.24041,0.2432>,<0.26814,0.23909,0.23113>,
              <0.27317,0.22957,0.2031>,<0.27442,0.21726,0.17555><0.04737,0.4288,0.11932>,<0.0379,0.43688,0.11671>,<0.01689,0.45812,0.11228>,
              <-0.00134,0.48192,0.11066>,<-0.00628,0.4942,0.11263>,<0.0045,0.48732,0.11656>,
              <0.0242,0.46488,0.11967>,<0.04112,0.43986,0.11997><0.01368,0.48259,0.14341>,<0.00466,0.49097,0.14021>,<-0.0182,0.50855,0.13124>,
              <-0.04272,0.52211,0.12044>,<-0.05443,0.52395,0.11424>,<-0.04619,0.51368,0.11658>,
              <-0.02255,0.49799,0.12641>,<0.00275,0.48632,0.13808><-0.11101,0.47937,0.15694>,<-0.11266,0.48936,0.14923>,<-0.11516,0.51474,0.13307>,
              <-0.11547,0.54206,0.12061>,<-0.11354,0.55519,0.11893>,<-0.11086,0.54611,0.12838>,
              <-0.10939,0.51982,0.1428>,<-0.11011,0.49159,0.15352><-0.17041,0.55862,0.03368>,<-0.17001,0.5625,0.04579>,<-0.16964,0.5688,0.07532>,
              <-0.17014,0.57048,0.10529>,<-0.17118,0.56684,0.11813>,<-0.17199,0.5608,0.10622>,
              <-0.17195,0.55667,0.07648>,<-0.17103,0.55715,0.0463><-0.26595,0.50836,0.10691>,<-0.25565,0.51561,0.10873>,<-0.23306,0.53525,0.11276>,
              <-0.21389,0.55809,0.11624>,<-0.20915,0.57057,0.11715>,<-0.22105,0.56482,0.11506>,
              <-0.24204,0.54368,0.11129>,<-0.25961,0.51933,0.10808><-0.00371,0.45748,0.07818>,<0.00393,0.46544,0.08451>,<0.02042,0.48663,0.09835>,
              <0.03395,0.51077,0.11>,<0.03677,0.52355,0.11277>,<0.02773,0.51697,0.10542>,
              <0.01264,0.4944,0.09261>,<0.0005,0.46887,0.08198><0.05546,0.48297,0.13344>,<0.05542,0.49511,0.12962>,<0.05612,0.52288,0.11777>,
              <0.05802,0.54834,0.10198>,<0.05993,0.55673,0.09174>,<0.06053,0.54351,0.09371>,
              <0.05926,0.51683,0.10741>,<0.0568,0.49244,0.12505><0.03479,0.52133,0.02534>,<0.04212,0.52711,0.03398>,<0.05775,0.54328,0.05414>,
              <0.07024,0.56282,0.07321>,<0.07248,0.57407,0.08008>,<0.06368,0.56988,0.07093>,
              <0.04952,0.55212,0.05128>,<0.0385,0.531,0.03273><0.17612,0.57367,0.05589>,<0.17038,0.58459,0.05277>,<0.15621,0.60925,0.04261>,
              <0.14153,0.63133,0.02854>,<0.13497,0.63807,0.01902>,<0.14046,0.62594,0.0203>,
              <0.15487,0.60249,0.0323>,<0.16979,0.58161,0.04822><0.13757,0.632,-0.09169>,<0.14445,0.63383,-0.08114>,<0.15986,0.6411,-0.05621>,
              <0.17348,0.65266,-0.03207>,<0.17744,0.66147,-0.02283>,<0.16972,0.66166,-0.03375>,
              <0.15515,0.65238,-0.05831>,<0.14237,0.63881,-0.08207><0.25868,0.61839,-0.0109>,<0.25012,0.62735,-0.0138>,<0.22883,0.64674,-0.0229>,
              <0.2066,0.66277,-0.03518>,<0.19651,0.66624,-0.04324>,<0.20463,0.65571,-0.04183>,
              <0.22636,0.6379,-0.03124>,<0.24903,0.62345,-0.01748><0.05974,0.52437,0.10531>,<0.05332,0.53161,0.11357>,<0.03994,0.55108,0.13238>,
              <0.02974,0.57357,0.14946>,<0.02851,0.58573,0.15491>,<0.03643,0.57991,0.14583>,
              <0.04832,0.55902,0.12783>,<0.05702,0.53511,0.11157><-0.02806,0.56972,0.20747>,<-0.02178,0.58066,0.20914>,<-0.00456,0.60494,0.2142>,
              <0.01576,0.62603,0.22085>,<0.02708,0.63176,0.22508>,<0.02225,0.61932,0.22416>,
              <0.00358,0.59654,0.21835>,<-0.01819,0.57696,0.21096><0.08152,0.57327,0.21831>,<0.07171,0.58072,0.22148>,<0.0501,0.60079,0.228>,
              <0.03163,0.62396,0.23284>,<0.02692,0.63648,0.23326>,<0.0382,0.63047,0.2293>,
              <0.05833,0.60895,0.22356>,<0.07533,0.58432,0.21952><-0.04483,0.61645,0.29331>,<-0.03603,0.62564,0.29359>,<-0.01314,0.64529,0.295>,
              <0.01226,0.66109,0.29753>,<0.02515,0.66403,0.29961>,<0.01753,0.65304,0.29985>,
              <-0.00654,0.63519,0.29792>,<-0.03312,0.62119,0.29488><0.09357,0.62658,0.35347>,<0.08171,0.6312,0.35376>,<0.05483,0.64494,0.35446>,
              <0.03057,0.66261,0.35515>,<0.02297,0.67362,0.35543>,<0.03606,0.67086,0.35514>,
              <0.06171,0.65527,0.35444>,<0.08475,0.63575,0.35376><-0.04503,0.61934,0.41249>,<-0.03711,0.62898,0.40997>,<-0.01605,0.64982,0.40411>,
              <0.00796,0.66698,0.3986>,<0.02067,0.67065,0.39664>,<0.01415,0.65928,0.39933>,
              <-0.0083,0.64017,0.40502>,<-0.0337,0.62473,0.41037><-0.03578,0.56633,0.15408>,<-0.02605,0.57383,0.15075>,<-0.00475,0.594,0.14358>,
              <0.01325,0.6173,0.13768>,<0.01761,0.62988,0.13644>,<0.00633,0.62385,0.14037>,
              <-0.01342,0.60222,0.14694>,<-0.02987,0.57745,0.15224><0.02814,0.60874,0.15607>,<0.02332,0.61918,0.15063>,<0.01103,0.64217,0.13538>,
              <-0.00227,0.6618,0.11696>,<-0.00871,0.66679,0.10635>,<-0.00436,0.65477,0.1103>,
              <0.0084,0.63336,0.12704>,<0.02217,0.6153,0.14695><-0.10104,0.67611,-0.01315>,<-0.09223,0.68025,-0.00496>,<-0.07284,0.69273,0.01454>,
              <-0.05628,0.70897,0.03362>,<-0.05209,0.71921,0.04113>,<-0.06224,0.71683,0.03274>,
              <-0.08029,0.70259,0.01344>,<-0.09551,0.68459,-0.00545><-0.01556,0.6915,0.05041>,<-0.02385,0.70013,0.04606>,<-0.04383,0.7188,0.03326>,
              <-0.0638,0.73426,0.01701>,<-0.07206,0.73763,0.00704>,<-0.06377,0.7275,0.00978>,
              <-0.04379,0.71033,0.0242>,<-0.02383,0.69639,0.04206><-0.13732,0.69491,0.03448>,<-0.12809,0.6998,0.02722>,<-0.10645,0.71398,0.01163>,
              <-0.08579,0.73171,-0.00103>,<-0.07815,0.74241,-0.00351>,<-0.08784,0.73919,0.00513>,
              <-0.10902,0.72335,0.01934>,<-0.12922,0.70393,0.03062><0.03225,0.64834,0.10691>,<0.03502,0.65282,0.11849>,<0.03984,0.66585,0.1453>,
              <0.04182,0.68223,0.17039>,<0.03996,0.69216,0.17916>,<0.03585,0.68925,0.16676>,
              <0.03237,0.67465,0.14076>,<0.03173,0.65669,0.11649><0.03529,0.63669,0.19167>,<0.03778,0.64913,0.19263>,<0.04589,0.67822,0.19281>,
              <0.05714,0.70589,0.18976>,<0.06476,0.71602,0.18548>,<0.06374,0.70292,0.18301>,
              <0.05416,0.67449,0.18434>,<0.04143,0.64749,0.1889><0.11608,0.76213,0.11372>,<0.11781,0.76029,0.12619>,<0.11973,0.75801,0.15624>,
              <0.11825,0.75901,0.18621>,<0.11445,0.76251,0.19855>,<0.11113,0.76589,0.18605>,
              <0.11081,0.76663,0.15603>,<0.11388,0.76409,0.1261><0.14427,0.72111,0.25872>,<0.14259,0.73207,0.25248>,<0.14037,0.75691,0.23545>,
              <0.14088,0.7793,0.21545>,<0.14367,0.78628,0.20438>,<0.14663,0.77417,0.20923>,
              <0.14757,0.75048,0.22766>,<0.14577,0.72923,0.24905><0.17358,0.82308,0.12398>,<0.17488,0.81806,0.1356>,<0.17627,0.80849,0.16421>,
              <0.17502,0.80275,0.19365>,<0.17203,0.80396,0.20663>,<0.16949,0.81077,0.19541>,
              <0.16934,0.81855,0.1664>,<0.17183,0.82249,0.13657><0.26172,0.7985,0.2776>,<0.25581,0.80538,0.26867>,<0.24321,0.81994,0.24541>,
              <0.23309,0.83143,0.21958>,<0.23123,0.8333,0.20647>,<0.2383,0.82497,0.21419>,
              <0.24974,0.81185,0.23865>,<0.25869,0.80181,0.26569><0.0549,0.79726,0.18241>,<0.05135,0.78519,0.18425>,<0.04368,0.7569,0.19155>,
              <0.0374,0.72994,0.20317>,<0.0361,0.72001,0.21204>,<0.0403,0.7327,0.21223>,
              <0.04732,0.76037,0.2029>,<0.05295,0.78671,0.18925><0.00141,0.75668,0.19644>,<0.00606,0.74704,0.20332>,<0.01792,0.72287,0.21699>,
              <0.03075,0.69734,0.22625>,<0.03696,0.6855,0.22594>,<0.03275,0.6945,0.21698>,
              <0.02044,0.71931,0.20538>,<0.00717,0.74547,0.1982><0.07116,0.74383,0.20202>,<0.06523,0.7327,0.20373>,<0.05198,0.70648,0.21075>,
              <0.04039,0.68121,0.22208>,<0.03713,0.67164,0.23083>,<0.04384,0.6832,0.23115>,
              <0.05631,0.70898,0.2221>,<0.06713,0.7338,0.20874><-0.0166,0.67119,0.21481>,<-0.00953,0.66357,0.22214>,<0.00843,0.64432,0.23694>,
              <0.02772,0.62382,0.24739>,<0.03697,0.61416,0.24764>,<0.03052,0.6212,0.23827>,
              <0.01193,0.64103,0.22551>,<-0.00798,0.66211,0.2171><0.08309,0.61539,0.1934>,<0.0739,0.60919,0.19965>,<0.05408,0.59417,0.21679>,
              <0.03784,0.57905,0.23701>,<0.03446,0.57269,0.24829>,<0.04533,0.57884,0.24349>,
              <0.06347,0.59391,0.2249>,<0.07804,0.60908,0.20323><-0.02504,0.56298,0.19039>,<-0.0188,0.55724,0.19988>,<-0.00141,0.54412,0.2208>,
              <0.01946,0.53212,0.23874>,<0.03138,0.5282,0.24338>,<0.02677,0.53447,0.2325>,
              <0.00775,0.54706,0.21297>,<-0.01476,0.55854,0.19643><0.08057,0.49144,0.16617>,<0.07091,0.49258,0.17437>,<0.04992,0.49442,0.19601>,
              <0.03249,0.49489,0.22045>,<0.0286,0.4938,0.2332>,<0.03993,0.49202,0.22632>,
              <0.05925,0.49083,0.20337>,<0.07502,0.49099,0.17761><0.07196,0.72923,0.21443>,<0.06203,0.73699,0.21273>,<0.03953,0.75707,0.21105>,
              <0.01928,0.77916,0.21301>,<0.013,0.79018,0.21724>,<0.02399,0.78336,0.22064>,
              <0.04543,0.76234,0.22061>,<0.06463,0.73932,0.21695><0.03694,0.76106,0.25559>,<0.02984,0.77011,0.25017>,<0.01126,0.78935,0.23614>,
              <-0.00946,0.80463,0.22068>,<-0.02005,0.80724,0.21294>,<-0.01395,0.79632,0.21769>,
              <0.00563,0.77894,0.23239>,<0.02736,0.76553,0.24852><-0.08264,0.74367,0.22419>,<-0.07559,0.75389,0.2214>,<-0.06145,0.77979,0.21498>,
              <-0.05163,0.80753,0.20902>,<-0.05162,0.82075,0.20699>,<-0.06069,0.8114,0.21>,
              <-0.0728,0.78463,0.2162>,<-0.0806,0.75603,0.22194><-0.03623,0.84876,0.23568>,<-0.04725,0.8498,0.22939>,<-0.07314,0.84929,0.21386>,
              <-0.09798,0.84421,0.19778>,<-0.10729,0.83781,0.19061>,<-0.09578,0.83462,0.19664>,
              <-0.07038,0.83728,0.21244>,<-0.04603,0.8445,0.22877><-0.17986,0.77899,0.1552>,<-0.17044,0.78654,0.15921>,<-0.15012,0.80674,0.16877>,
              <-0.13347,0.82991,0.17811>,<-0.13001,0.8423,0.18178>,<-0.14115,0.83614,0.17766>,
              <-0.15974,0.81455,0.16821>,<-0.17468,0.78998,0.15897><-0.1786,0.81048,0.08049>,<-0.17847,0.81737,0.09118>,<-0.17822,0.83106,0.1181>,
              <-0.17806,0.84033,0.14666>,<-0.17808,0.84002,0.16003>,<-0.17825,0.83105,0.15011>,
              <-0.17846,0.81944,0.12242>,<-0.17858,0.81225,0.09309><-0.02242,0.82507,0.19109>,<-0.01293,0.81832,0.19622>,<0.01112,0.80492,0.20863>,
              <0.03691,0.7959,0.22108>,<0.04924,0.79629,0.22627>,<0.04057,0.8051,0.22115>,
              <0.0157,0.81644,0.20873>,<-0.01091,0.8234,0.19626><0.00896,0.77795,0.22841>,<0.02148,0.77913,0.22647>,<0.05074,0.78058,0.21915>,
              <0.07855,0.77997,0.20784>,<0.0887,0.77778,0.19942>,<0.0755,0.77564,0.19948>,
              <0.04692,0.77516,0.20867>,<0.01979,0.77673,0.22185><0.04037,0.79046,0.13774>,<0.04854,0.78495,0.14579>,<0.06959,0.77444,0.16472>,
              <0.09266,0.76813,0.18288>,<0.1041,0.76946,0.18968>,<0.09688,0.77694,0.18126>,
              <0.07488,0.78548,0.16269>,<0.05087,0.78981,0.1449><0.06303,0.73077,0.2187>,<0.07386,0.73569,0.21419>,<0.09893,0.74595,0.20083>,
              <0.12236,0.7538,0.18377>,<0.13053,0.75477,0.17323>,<0.11893,0.74872,0.176>,
              <0.09463,0.73959,0.19109>,<0.07197,0.73288,0.20989><0.10423,0.73412,0.08752>,<0.11154,0.7307,0.09736>,<0.13078,0.72487,0.1199>,
              <0.15241,0.72267,0.1406>,<0.16362,0.72517,0.14746>,<0.15744,0.73029,0.13676>,
              <0.13707,0.73442,0.11509>,<0.11432,0.73491,0.09524><0.1564,0.63741,0.17975>,<0.16306,0.64576,0.17284>,<0.17697,0.66494,0.15412>,
              <0.18764,0.68263,0.13232>,<0.189,0.68855,0.1204>,<0.18082,0.67949,0.12587>,
              <0.16843,0.66101,0.14603>,<0.15929,0.64403,0.16928><0.13949,0.67648,0.04795>,<0.146,0.67475,0.05875>,<0.16354,0.6726,0.08324>,
              <0.18382,0.67348,0.10536>,<0.19479,0.67668,0.11231>,<0.18957,0.67983,0.1004>,
              <0.17074,0.68056,0.07702>,<0.14917,0.67826,0.05601><0.09112,0.85336,0.1907>,<0.08279,0.84929,0.19942>,<0.06408,0.84185,0.22192>,
              <0.04747,0.83802,0.24664>,<0.04255,0.83982,0.25895>,<0.05187,0.84558,0.25127>,
              <0.06959,0.85133,0.22773>,<0.08522,0.85347,0.20198><-0.02356,0.80847,0.24865>,<-0.02101,0.81238,0.26049>,<-0.01307,0.81925,0.2888>,
              <-0.00246,0.82225,0.31673>,<0.00445,0.81987,0.32793>,<0.00315,0.81414,0.31591>,
              <-0.00604,0.80908,0.28778>,<-0.01791,0.80789,0.26004><0.06725,0.79048,0.2995>,<0.05559,0.79218,0.3043>,<0.02907,0.79854,0.31727>,
              <0.00502,0.80833,0.33234>,<-0.00263,0.81561,0.34056>,<0.0102,0.81553,0.33675>,
              <0.03556,0.80755,0.32279>,<0.05845,0.79615,0.30673><-0.0509,0.82142,0.2832>,<-0.04653,0.82177,0.29515>,<-0.03464,0.82001,0.32285>,
              <-0.02073,0.81434,0.34885>,<-0.01308,0.80831,0.35802>,<-0.01651,0.80612,0.34528>,
              <-0.02935,0.80972,0.31838>,<-0.0442,0.81723,0.29318><0.0426,0.75476,0.35896>,<0.03046,0.75822,0.36054>,<0.00265,0.76847,0.36633>,
              <-0.0229,0.78159,0.37511>,<-0.03135,0.78972,0.38155>,<-0.01814,0.78761,0.38137>,
              <0.00861,0.77601,0.37417>,<0.03308,0.76154,0.364><-0.11747,0.7564,0.34825>,<-0.1107,0.75783,0.35892>,<-0.09271,0.75909,0.38315>,
              <-0.07227,0.75706,0.40505>,<-0.0615,0.75313,0.41194>,<-0.06712,0.75016,0.40017>,
              <-0.08626,0.75044,0.37704>,<-0.10785,0.75401,0.35623><-0.03037,0.88697,0.28733>,<-0.01822,0.88537,0.28393>,<0.01061,0.88452,0.27498>,
              <0.03866,0.88818,0.26491>,<0.04955,0.89394,0.25969>,<0.03702,0.89766,0.26256>,
              <0.00856,0.89639,0.27204>,<-0.01912,0.89061,0.28264><0.02338,0.87155,0.31578>,<0.02792,0.87692,0.30518>,<0.03722,0.88748,0.27846>,
              <0.04402,0.8944,0.25004>,<0.04449,0.89386,0.23669>,<0.03878,0.88679,0.2465>,
              <0.03065,0.87793,0.27401>,<0.02502,0.87271,0.30322><-0.04141,0.8706,0.22575>,<-0.02877,0.87164,0.22479>,<0.00076,0.87663,0.22087>,
              <0.02877,0.88536,0.2145>,<0.03895,0.8925,0.20956>,<0.0256,0.89321,0.20936>,
              <-0.00322,0.88647,0.21444>,<-0.03052,0.87598,0.22196><0.04281,0.86146,0.25416>,<0.04247,0.86774,0.2431>,<0.04034,0.88015,0.21565>,
              <0.03621,0.88844,0.18709>,<0.03263,0.88799,0.17421>,<0.03203,0.87977,0.18475>,
              <0.0351,0.8693,0.21272>,<0.04016,0.86295,0.2418><-0.04861,0.8485,0.15162>,<-0.0364,0.85158,0.15346>,<-0.00788,0.8612,0.15587>,
              <0.01922,0.87411,0.1552>,<0.02911,0.88255,0.15204>,<0.01623,0.88101,0.14876>,
              <-0.01162,0.86985,0.1478>,<-0.03805,0.85539,0.14991><0.03195,0.8243,0.19828>,<0.03292,0.83334,0.18938>,<0.03316,0.85321,0.16664>,
              <0.03025,0.87013,0.142>,<0.02607,0.87436,0.13002>,<0.02362,0.86393,0.13803>,
              <0.02486,0.84545,0.16166>,<0.02926,0.82992,0.18718><-0.05507,0.85178,0.07062>,<-0.04412,0.85122,0.07706>,<-0.0172,0.85228,0.09071>,
              <0.01043,0.85702,0.10146>,<0.02255,0.86241,0.1032>,<0.01193,0.8647,0.0954>,
              <-0.01533,0.86191,0.08311>,<-0.04329,0.85546,0.07371><0.05169,1.0034,0.2762>,<0.05192,0.99083,0.27818>,<0.05468,0.96152,0.28492>,
              <0.06079,0.93377,0.29462>,<0.06645,0.92373,0.30141>,<0.06779,0.93703,0.30082>,
              <0.06346,0.96561,0.29269>,<0.05579,0.99263,0.2816><0.05245,0.99146,0.26921>,<0.05241,0.98,0.27474>,<0.05523,0.95255,0.28701>,
              <0.06247,0.92542,0.29763>,<0.06961,0.91448,0.3005>,<0.07173,0.92608,0.2942>,
              <0.06684,0.95339,0.2827>,<0.05753,0.98037,0.27284><0.09026,0.9578,0.27332>,<0.0879,0.94532,0.27405>,<0.0836,0.91577,0.27855>,
              <0.08138,0.8871,0.2872>,<0.08243,0.87605,0.29467>,<0.08576,0.88895,0.29589>,
              <0.08909,0.91809,0.28944>,<0.09032,0.94634,0.27884><0.018,0.88231,0.28475>,<0.02885,0.87643,0.28783>,<0.05522,0.86236,0.29216>,
              <0.08184,0.84848,0.29178>,<0.09311,0.84291,0.2872>,<0.08237,0.84888,0.2819>,
              <0.05588,0.86286,0.27978>,<0.02914,0.87665,0.28238><0.11629,0.91852,0.26377>,<0.11134,0.90686,0.26493>,<0.10131,0.87887,0.2702>,
              <0.09418,0.85112,0.27919>,<0.09394,0.83986,0.28641>,<0.10025,0.85164,0.287>,
              <0.10892,0.87952,0.27998>,<0.11469,0.90715,0.26924><0.02098,0.81158,0.24095>,<0.03132,0.80813,0.24751>,<0.05751,0.80083,0.26065>,
              <0.08555,0.79508,0.26974>,<0.09889,0.79416,0.26969>,<0.08942,0.79835,0.26123>,
              <0.06236,0.80492,0.24999>,<0.03346,0.80993,0.24281><0.07226,0.84535,0.21688>,<0.07381,0.83564,0.22497>,<0.08013,0.81206,0.24274>,
              <0.09036,0.78824,0.25788>,<0.09827,0.77814,0.26168>,<0.09856,0.78772,0.25235>,
              <0.0904,0.81142,0.23581>,<0.07833,0.83536,0.22191><0.09755,0.90919,0.28201>,<0.09017,0.91862,0.2863>,<0.07488,0.94165,0.29845>,
              <0.06343,0.96508,0.31333>,<0.06229,0.97517,0.32205>,<0.07148,0.96593,0.31903>,
              <0.08497,0.9427,0.3056>,<0.09461,0.91908,0.28944><0.1268,0.97805,0.34476>,<0.1147,0.98194,0.34518>,<0.08546,0.98936,0.34373>,
              <0.05621,0.99383,0.33862>,<0.04409,0.9929,0.33304>,<0.05619,0.98762,0.3309>,
              <0.08543,0.98159,0.33407>,<0.11468,0.97851,0.34091><0.05609,0.93043,0.35013>,<0.0496,0.94111,0.34773>,<0.03641,0.96796,0.34355>,
              <0.02695,0.9964,0.34177>,<0.02653,1.00968,0.3433>,<0.03477,0.99975,0.34683>,
              <0.04621,0.97216,0.34988>,<0.05392,0.94297,0.35053><-0.02678,1.02475,0.27425>,<-0.02107,1.02764,0.28525>,<-0.00909,1.03219,0.31259>,
              <0.00018,1.03306,0.34114>,<0.00148,1.02997,0.35409>,<-0.00549,1.02535,0.34365>,
              <-0.01621,1.02253,0.31574>,<-0.02421,1.02338,0.28664><0.00297,0.9729,0.40484>,<-0.00165,0.98169,0.39688>,<-0.01069,1.00454,0.37933>,
              <-0.01657,1.02985,0.36428>,<-0.01602,1.04263,0.36038>,<-0.00992,1.03499,0.36951>,
              <-0.00236,1.01099,0.38589>,<0.00202,0.98453,0.39977><-0.10551,1.04873,0.3>,<-0.09755,1.05324,0.30885>,<-0.07928,1.06141,0.33146>,
              <-0.06242,1.06549,0.35597>,<-0.05676,1.06334,0.3679>,<-0.06537,1.05691,0.35994>,
              <-0.08298,1.05066,0.33643>,<-0.09918,1.0485,0.31104><-0.11604,1.0077,0.32263>,<-0.1088,1.01615,0.3288>,<-0.09421,1.0374,0.34454>,
              <-0.08399,1.05992,0.36156>,<-0.08385,1.07046,0.3698>,<-0.09313,1.06261,0.36423>,
              <-0.10567,1.04076,0.34789>,<-0.11385,1.01763,0.33028><-0.13006,1.09411,0.29675>,<-0.12399,1.09361,0.30792>,<-0.11018,1.08942,0.33445>,
              <-0.09767,1.08074,0.36033>,<-0.09371,1.07292,0.37044>,<-0.1004,1.07132,0.35896>,
              <-0.11359,1.07761,0.33274>,<-0.12549,1.0884,0.30716><-0.00412,1.04985,0.3602>,<0.00646,1.04287,0.35904>,<0.03278,1.0287,0.35477>,
              <0.06027,1.01852,0.34828>,<0.07276,1.01805,0.34351>,<0.06273,1.0269,0.34362>,
              <0.03586,1.0392,0.34893>,<0.00782,1.04751,0.35647><0.03735,0.98614,0.36359>,<0.04506,0.98796,0.35363>,<0.06129,0.9908,0.32832>,
              <0.07392,0.99126,0.30109>,<0.07578,0.98922,0.288>,<0.06638,0.98628,0.29705>,
              <0.05184,0.98456,0.32326>,<0.04089,0.98521,0.3514><-0.00521,0.99882,0.25829>,<0.00597,0.99394,0.2619>,<0.03382,0.9848,0.26918>,
              <0.06296,0.97967,0.27432>,<0.07623,0.9813,0.27442>,<0.06565,0.98806,0.2698>,
              <0.0372,0.99531,0.26353>,<0.00746,0.99857,0.2594><0.04833,0.9569,0.33563>,<0.05467,0.95916,0.32483>,<0.06726,0.96344,0.29772>,
              <0.07576,0.96598,0.26903>,<0.07544,0.96539,0.25567>,<0.06718,0.96232,0.26573>,
              <0.05651,0.95885,0.29358>,<0.04993,0.95714,0.32301><-0.01017,0.9325,0.21881>,<0.00182,0.93206,0.22304>,<0.03099,0.93295,0.23083>,
              <0.06048,0.93679,0.23494>,<0.07301,0.94114,0.23319>,<0.06118,0.94295,0.22722>,
              <0.03186,0.94068,0.22116>,<0.00221,0.93546,0.21878><0.06613,0.90706,0.3081>,<0.06948,0.91174,0.29675>,<0.07468,0.92198,0.26882>,
              <0.07551,0.93061,0.24007>,<0.07176,0.93267,0.2274>,<0.06636,0.92724,0.23836>,
              <0.06321,0.91775,0.26668>,<0.06443,0.90988,0.29581><-0.00358,0.90168,0.15906>,<0.00534,0.89997,0.16798>,<0.0284,0.89746,0.18732>,
              <0.05378,0.89739,0.20336>,<0.06648,0.89966,0.2069>,<0.05866,0.90252,0.19643>,
              <0.03451,0.90388,0.17864>,<0.00803,0.9028,0.16415><0.00608,0.25529,0.02039>,<0.00485,0.24667,0.02967>,<0.00162,0.22858,0.05364>,
              <-0.00197,0.21457,0.07995>,<-0.00379,0.21259,0.09305>,<-0.00272,0.22312,0.08487>,
              <0.00067,0.2393,0.05981>,<0.00443,0.2514,0.03239><-0.00054,0.12246,0.15237>,<0.00735,0.12453,0.16214>,<0.02829,0.12824,0.18358>,
              <0.05209,0.13002,0.2018>,<0.06463,0.12893,0.20632>,<0.05809,0.12595,0.19505>,
              <0.0358,0.12315,0.17512>,<0.01066,0.12229,0.15841><0.13928,0.11065,0.18297>,<0.13192,0.10381,0.19077>,<0.1155,0.08931,0.21157>,
              <0.10113,0.07787,0.23532>,<0.09709,0.07601,0.24793>,<0.10541,0.0843,0.24152>,
              <0.12086,0.09736,0.21934>,<0.13428,0.10735,0.1942><0.04987,-0.01366,0.26011>,<0.06057,-0.00897,0.26517>,<0.08729,0.00158,0.27449>,
              <0.11538,0.01094,0.27945>,<0.1283,0.01372,0.27741>,<0.11826,0.00848,0.2703>,
              <0.09089,-0.00151,0.26303>,<0.06216,-0.01033,0.26011><0.16252,-0.00452,0.20139>,<0.15622,-0.00548,0.2124>,<0.14367,-0.00639,0.23986>,
              <0.13514,-0.00517,0.26862>,<0.13537,-0.00268,0.28176>,<0.14355,-0.00073,0.27136>,
              <0.15421,-0.00082,0.24329>,<0.16086,-0.00303,0.21392><-0.00678,0.24289,0.13238>,<-0.01851,0.24642,0.12894>,<-0.04614,0.25702,0.12289>,
              <-0.07273,0.27072,0.12025>,<-0.08276,0.27931,0.12234>,<-0.07055,0.27723,0.12738>,
              <-0.04341,0.26518,0.13183>,<-0.01731,0.25002,0.13288><-0.0571,0.27096,0.18574>,<-0.06486,0.27524,0.17661>,<-0.08408,0.28248,0.15447>,
              <-0.10404,0.28507,0.13219>,<-0.113,0.28176,0.12283>,<-0.10559,0.27529,0.13189>,
              <-0.08602,0.27024,0.15409>,<-0.06571,0.26984,0.17644><-0.30882,0.21026,0.13351>,<-0.29868,0.2177,0.13154>,<-0.27657,0.23747,0.12587>,
              <-0.25803,0.26001,0.11881>,<-0.2537,0.27194,0.11459>,<-0.26551,0.26581,0.11591>,
              <-0.28595,0.24473,0.12223>,<-0.30281,0.2209,0.12994><-0.33903,0.25799,0.01461>,<-0.34135,0.25703,0.02708>,<-0.34538,0.25206,0.05659>,
              <-0.34708,0.2431,0.0852>,<-0.34558,0.23564,0.0962>,<-0.34216,0.23472,0.0833>,
              <-0.33922,0.24156,0.05421>,<-0.33863,0.2524,0.02603><-0.0864,0.33748,0.11857>,<-0.07518,0.33153,0.11935>,<-0.04771,0.319,0.11874>,
              <-0.01966,0.30923,0.11435>,<-0.00749,0.30778,0.10897>,<-0.01844,0.31502,0.10641>,
              <-0.04619,0.32625,0.1088>,<-0.07451,0.33473,0.11497><-0.05842,0.32945,0.16084>,<-0.04881,0.3274,0.15276>,<-0.02773,0.32035,0.13231>,
              <-0.00986,0.31013,0.11045>,<-0.00547,0.30294,0.10006>,<-0.01659,0.3035,0.10748>,
              <-0.03616,0.31204,0.12859>,<-0.05252,0.32373,0.15112><-0.07142,0.29935,0.02717>,<-0.06113,0.29286,0.0309>,<-0.03504,0.27977,0.03864>,
              <-0.00706,0.27057,0.04448>,<0.0063,0.27041,0.04512>,<-0.00311,0.27873,0.0405>,
              <-0.03009,0.28999,0.03366>,<-0.05895,0.29737,0.0287><0.0622,0.24403,0.04756>,<0.05757,0.24163,0.03596>,<0.04465,0.23394,0.00976>,
              <0.02914,0.22342,-0.01369>,<0.02027,0.2164,-0.02084>,<0.02369,0.21748,-0.00795>,
              <0.03782,0.22649,0.01696>,<0.05456,0.23834,0.03913><-0.0319,0.13017,-0.0133>,<-0.02071,0.13183,-0.01913>,<0.00423,0.1366,-0.03547>,
              <0.02609,0.1425,-0.05519>,<0.03225,0.14601,-0.06654>,<0.01961,0.14488,-0.06229>,
              <-0.00388,0.13958,-0.04436>,<-0.02429,0.13315,-0.02305><-0.01924,0.38699,0.09106>,<-0.01596,0.38111,0.10186>,<-0.00785,0.36995,0.12872>,
              <0.00058,0.36334,0.15677>,<0.00435,0.36488,0.16951>,<0.00122,0.3729,0.15927>,
              <-0.00704,0.38192,0.13185>,<-0.01561,0.38639,0.10324><-0.01959,0.33531,0.163>,<-0.00906,0.33875,0.16927>,<0.01751,0.34558,0.18189>,
              <0.04583,0.35022,0.19072>,<0.0592,0.35008,0.19081>,<0.0495,0.34561,0.18276>,
              <0.02211,0.33981,0.17192>,<-0.00704,0.3362,0.16488><0.10589,0.34716,0.12674>,<0.10611,0.34159,0.13817>,<0.10765,0.33101,0.16642>,
              <0.11073,0.3248,0.19563>,<0.11345,0.32632,0.20864>,<0.11395,0.33394,0.19766>,
              <0.11169,0.34247,0.16896>,<0.10789,0.34663,0.13929><0.09943,0.24637,0.22331>,<0.10978,0.25331,0.22588>,<0.13535,0.26904,0.22916>,
              <0.16176,0.28328,0.22806>,<0.1735,0.28776,0.22347>,<0.16354,0.28012,0.21884>,
              <0.13758,0.26509,0.21762>,<0.11077,0.25156,0.22079><0.21211,0.27382,0.14702>,<0.20979,0.26962,0.1588>,<0.20649,0.26153,0.18771>,
              <0.2067,0.25653,0.21732>,<0.21007,0.25737,0.23024>,<0.21404,0.26302,0.21878>,
              <0.21569,0.26966,0.18954>,<0.21384,0.2732,0.15961><0.02884,0.40167,0.15328>,<0.01864,0.40642,0.15921>,<-0.00424,0.42044,0.17307>,
              <-0.02447,0.43831,0.18623>,<-0.03036,0.44932,0.19102>,<-0.01892,0.44638,0.18475>,
              <0.00272,0.43055,0.17122>,<0.0217,0.41087,0.1584><-0.07981,0.42492,0.15538>,<-0.07519,0.4335,0.16356>,<-0.06368,0.45154,0.18488>,
              <-0.05165,0.46552,0.20857>,<-0.04618,0.46751,0.22061>,<-0.05056,0.45703,0.21355>,
              <-0.06231,0.4409,0.19111>,<-0.07458,0.42882,0.16631><-0.02532,0.43768,0.29015>,<-0.03564,0.44506,0.28913>,<-0.05822,0.46499,0.28691>,
              <-0.07733,0.48808,0.28505>,<-0.08197,0.50061,0.28461>,<-0.07002,0.49472,0.2858>,
              <-0.04907,0.47331,0.28785>,<-0.0316,0.44873,0.28955><-0.1378,0.45299,0.26801>,<-0.13373,0.46362,0.27369>,<-0.12205,0.48711,0.28866>,
              <-0.10759,0.50729,0.30554>,<-0.09898,0.51255,0.31432>,<-0.10174,0.50037,0.30954>,
              <-0.11473,0.47844,0.29367>,<-0.1305,0.4598,0.2759><-0.06968,0.45655,0.37827>,<-0.0793,0.46382,0.37421>,<-0.1003,0.4835,0.36505>,
              <-0.11795,0.50636,0.35685>,<-0.12212,0.51882,0.35436>,<-0.11093,0.51305,0.35887>,
              <-0.0915,0.49187,0.36758>,<-0.07542,0.46751,0.37533><-0.24983,0.4817,0.41472>,<-0.24003,0.48919,0.41784>,<-0.21526,0.50441,0.42601>,
              <-0.18883,0.51532,0.43518>,<-0.17633,0.5158,0.43991>,<-0.18535,0.50629,0.43726>,
              <-0.2109,0.49309,0.42862>,<-0.23811,0.4842,0.41898><-0.11389,0.49398,0.19155>,<-0.1018,0.49179,0.18824>,<-0.07311,0.48937,0.17912>,
              <-0.04517,0.49128,0.16829>,<-0.03431,0.49614,0.16219>,<-0.04675,0.50037,0.16468>,
              <-0.07508,0.50075,0.17461>,<-0.10267,0.49681,0.18625><-0.07047,0.48578,0.1882>,<-0.06717,0.4889,0.17631>,<-0.06047,0.49361,0.14725>,
              <-0.05569,0.49404,0.11761>,<-0.05553,0.49021,0.10479>,<-0.05974,0.48508,0.1164>,
              <-0.06553,0.48239,0.14574>,<-0.0694,0.48396,0.17565><-0.14657,0.44371,0.06464>,<-0.13454,0.4475,0.06637>,<-0.10653,0.45862,0.06831>,
              <-0.08004,0.47269,0.06691>,<-0.0705,0.48129,0.06318>,<-0.08324,0.47888,0.05987>,
              <-0.11054,0.46638,0.0595>,<-0.13631,0.45092,0.06248><-0.01458,0.42556,-0.01606>,<-0.02581,0.43151,-0.01645>,<-0.05354,0.44345,-0.01553>,
              <-0.08216,0.45171,-0.01179>,<-0.09486,0.45168,-0.00759>,<-0.08405,0.444,-0.00587>,
              <-0.0559,0.43379,-0.00812>,<-0.02685,0.42725,-0.01318><-0.13031,0.34189,-0.00936>,<-0.12514,0.34971,-0.01796>,<-0.11548,0.36985,-0.03829>,
              <-0.11009,0.3919,-0.05794>,<-0.11186,0.40283,-0.06545>,<-0.11903,0.39591,-0.05652>,
              <-0.12668,0.37488,-0.03651>,<-0.13007,0.35193,-0.01718><-0.04242,0.55237,0.12184>,<-0.03514,0.54812,0.13136>,<-0.01729,0.54095,0.15465>,
              <0.00095,0.53846,0.17837>,<0.00888,0.54183,0.1886>,<0.00178,0.54828,0.17928>,
              <-0.01625,0.55325,0.15579>,<-0.03468,0.55354,0.13187><-0.07029,0.53232,0.1911>,<-0.05804,0.53539,0.19264>,<-0.02836,0.54078,0.19398>,
              <0.0015,0.5431,0.19172>,<0.01401,0.5412,0.18741>,<0.00184,0.53669,0.18418>,
              <-0.02792,0.53275,0.18453>,<-0.05785,0.53185,0.18848><0.01847,0.53055,0.10542>,<0.02477,0.52844,0.11627>,<0.04075,0.52632,0.14181>,
              <0.05785,0.52868,0.16638>,<0.06599,0.53387,0.17564>,<0.06021,0.53808,0.16434>,
              <0.04371,0.53809,0.13925>,<0.02608,0.53363,0.11514><0.06628,0.5127,0.2223>,<0.07581,0.51643,0.21474>,<0.09786,0.52279,0.19511>,
              <0.11846,0.52517,0.17339>,<0.12562,0.52242,0.16243>,<0.11541,0.51683,0.16901>,
              <0.09404,0.51233,0.18963>,<0.07413,0.51182,0.21232><0.12902,0.50717,0.07446>,<0.13269,0.50467,0.08638>,<0.14274,0.50151,0.11469>,
              <0.15455,0.50265,0.14227>,<0.16111,0.50718,0.15301>,<0.15827,0.5117,0.14075>,
              <0.14739,0.51285,0.11279>,<0.13474,0.50968,0.08555><0.17869,0.45251,0.21378>,<0.18442,0.45874,0.20429>,<0.19683,0.47145,0.17987>,
              <0.2071,0.48061,0.15318>,<0.20934,0.48108,0.14>,<0.2026,0.47318,0.14843>,
              <0.1912,0.46214,0.17392>,<0.18194,0.45464,0.20167><-0.00355,0.65401,0.18089>,<-0.00663,0.64205,0.18391>,<-0.01453,0.61467,0.19392>,
              <-0.0231,0.58957,0.20801>,<-0.02727,0.58132,0.21767>,<-0.0245,0.59436,0.21656>,
              <-0.01629,0.62067,0.20464>,<-0.00741,0.64469,0.18864><-0.06442,0.60346,0.20626>,<-0.05885,0.59504,0.214>,<-0.04536,0.5732,0.22992>,
              <-0.03185,0.54912,0.2417>,<-0.02622,0.53703,0.24269>,<-0.03177,0.54439,0.233>,
              <-0.04527,0.56728,0.21902>,<-0.05881,0.59242,0.20919><0.01821,0.51829,0.21538>,<0.01013,0.51068,0.22159>,<-0.00746,0.49326,0.23888>,
              <-0.02216,0.47726,0.25962>,<-0.02552,0.47198,0.27144>,<-0.01607,0.48026,0.26683>,
              <0.00016,0.49701,0.24793>,<0.01349,0.51234,0.22558><-0.08096,0.48714,0.24144>,<-0.07412,0.47989,0.24934>,<-0.05614,0.46195,0.26569>,
              <-0.03598,0.44336,0.27791>,<-0.02557,0.43504,0.27909>,<-0.03138,0.44198,0.26924>,
              <-0.05039,0.46023,0.25484>,<-0.07158,0.47913,0.24456><0.03071,0.45274,0.23131>,<0.02077,0.44682,0.23661>,<-0.00129,0.43291,0.25183>,
              <-0.02045,0.4196,0.27074>,<-0.02566,0.41464,0.28202>,<-0.01435,0.42085,0.27844>,
              <0.00634,0.43447,0.26149>,<0.02414,0.44751,0.24086><-0.06209,0.42421,0.21812>,<-0.05922,0.4184,0.22907>,<-0.04947,0.40473,0.25418>,
              <-0.03548,0.39161,0.27728>,<-0.02571,0.38669,0.28497>,<-0.02659,0.39275,0.27308>,
              <-0.03833,0.40616,0.24891>,<-0.0543,0.41903,0.22675><-0.07366,0.60056,0.23592>,<-0.06625,0.61048,0.233>,<-0.05124,0.6357,0.22587>,
              <-0.04055,0.6628,0.21862>,<-0.04018,0.67581,0.21551>,<-0.04962,0.66677,0.21837>,
              <-0.0626,0.64067,0.22555>,<-0.07126,0.61267,0.23286><-0.01165,0.67154,0.24973>,<-0.02,0.67896,0.24363>,<-0.03945,0.69472,0.22674>,
              <-0.05783,0.70726,0.20658>,<-0.06445,0.70941,0.19516>,<-0.0556,0.70048,0.19972>,
              <-0.03665,0.68623,0.21815>,<-0.01876,0.67521,0.23984><-0.16404,0.71355,0.11275>,<-0.1536,0.71802,0.11849>,<-0.13054,0.73095,0.13308>,
              <-0.11072,0.74712,0.1488>,<-0.10556,0.75686,0.15639>,<-0.11753,0.75391,0.15119>,
              <-0.13906,0.73945,0.13607>,<-0.15736,0.72176,0.1198><-0.05153,0.74373,0.21891>,<-0.06005,0.74827,0.21063>,<-0.08006,0.75638,0.18951>,
              <-0.09921,0.76016,0.1667>,<-0.10634,0.75767,0.15565>,<-0.09741,0.7511,0.16313>,
              <-0.0778,0.74503,0.18505>,<-0.05905,0.74327,0.20866><-0.166,0.71126,0.08438>,<-0.15888,0.71876,0.09179>,<-0.14418,0.73867,0.10908>,
              <-0.13322,0.76131,0.12548>,<-0.1322,0.77325,0.13143>,<-0.14108,0.76703,0.1236>,
              <-0.15402,0.74584,0.10672>,<-0.16322,0.72192,0.09075><-0.10602,0.76535,0.13919>,<-0.11538,0.77156,0.13323>,<-0.13824,0.78368,0.11765>,
              <-0.1615,0.79143,0.10032>,<-0.17151,0.79054,0.09149>,<-0.16234,0.78227,0.09663>,
              <-0.13929,0.77221,0.11303>,<-0.11584,0.76651,0.13119><-0.09958,0.72656,0.19671>,<-0.08891,0.72279,0.20252>,<-0.06235,0.71652,0.21546>,
              <-0.03461,0.71451,0.22678>,<-0.02201,0.71769,0.22993>,<-0.03212,0.72346,0.22335>,
              <-0.05923,0.72773,0.21117>,<-0.08753,0.72773,0.20063><-0.08271,0.7114,0.24714>,<-0.07054,0.71363,0.24415>,<-0.04198,0.71678,0.23488>,
              <-0.01462,0.7166,0.2225>,<-0.00443,0.7134,0.21445>,<-0.01717,0.70961,0.21597>,
              <-0.04517,0.70802,0.2267>,<-0.07195,0.70976,0.24055><-0.02153,0.67962,0.12348>,<-0.01203,0.68009,0.13193>,<0.0115,0.68371,0.15052>,
              <0.03591,0.69108,0.16638>,<0.04685,0.69766,0.17038>,<0.03776,0.69894,0.16065>,
              <0.01382,0.69356,0.14334>,<-0.011,0.68443,0.12877><0.03972,0.67219,0.21665>,<0.0469,0.67561,0.20672>,<0.06261,0.68144,0.1816>,
              <0.07585,0.68366,0.15474>,<0.07901,0.68117,0.14198>,<0.07066,0.67605,0.15109>,
              <0.05611,0.67191,0.17703>,<0.04404,0.67141,0.20471><0.04895,0.64472,0.05511>,<0.05636,0.64471,0.06546>,<0.07521,0.64722,0.08891>,
              <0.09554,0.65359,0.11008>,<0.10534,0.65985,0.11669>,<0.09862,0.66168,0.10527>,
              <0.07908,0.65735,0.08289>,<0.05806,0.64917,0.0628><0.11009,0.58381,0.1596>,<0.11405,0.59285,0.15156>,<0.12159,0.61301,0.13038>,
              <0.12613,0.63071,0.10655>,<0.12518,0.63571,0.09418>,<0.11981,0.62551,0.10097>,
              <0.11368,0.6065,0.12339>,<0.11056,0.58997,0.14848><0.07374,0.58751,0.04059>,<0.08155,0.59186,0.04964>,<0.10089,0.60438,0.06917>,
              <0.12097,0.61995,0.08516>,<0.12998,0.62926,0.08848>,<0.12252,0.62635,0.07776>,
              <0.10284,0.61239,0.0599>,<0.08241,0.59539,0.04556><-0.0063,0.78184,0.19843>,<-0.01061,0.77704,0.20939>,<-0.01936,0.76793,0.23682>,
              <-0.02561,0.76255,0.26569>,<-0.02586,0.76383,0.27901>,<-0.02038,0.77039,0.26872>,
              <-0.0128,0.77775,0.24061>,<-0.00772,0.78137,0.21106><-0.06259,0.73362,0.26522>,<-0.05641,0.73629,0.27602>,<-0.03945,0.74094,0.30057>,
              <-0.01937,0.7429,0.3228>,<-0.00813,0.74119,0.32984>,<-0.01283,0.73726,0.31796>,
              <-0.03126,0.73387,0.29449>,<-0.05281,0.73317,0.27334><0.04279,0.74781,0.2719>,<0.03516,0.74355,0.28115>,<0.01768,0.73602,0.3046>,
              <0.00165,0.73265,0.32976>,<-0.00363,0.73515,0.34179>,<0.00469,0.74136,0.33336>,
              <0.02148,0.74694,0.3091>,<0.03683,0.74836,0.28313><-0.05369,0.68324,0.33764>,<-0.04537,0.68795,0.34604>,<-0.02346,0.69765,0.36442>,
              <0.00122,0.70484,0.37994>,<0.01406,0.70544,0.38367>,<0.00705,0.69955,0.37392>,
              <-0.01617,0.69103,0.35688>,<-0.04216,0.68503,0.34272><0.07715,0.64313,0.35215>,<0.06824,0.64508,0.36102>,<0.04917,0.65142,0.38356>,
              <0.03377,0.66021,0.4078>,<0.03084,0.66614,0.41942>,<0.04147,0.66533,0.41134>,
              <0.05882,0.65784,0.38801>,<0.07249,0.64791,0.36298><-0.02613,0.59193,0.41329>,<-0.01822,0.60045,0.41846>,<0.00268,0.61965,0.42877>,
              <0.02631,0.63679,0.43582>,<0.03864,0.64196,0.43568>,<0.03201,0.63247,0.42898>,
              <0.00983,0.61424,0.4202>,<-0.01507,0.59806,0.41468><-0.08382,0.75044,0.28046>,<-0.07713,0.76011,0.27559>,<-0.06383,0.7847,0.26418>,
              <-0.05483,0.81119,0.25326>,<-0.05514,0.82393,0.24921>,<-0.06385,0.81515,0.2543>,
              <-0.07513,0.78967,0.26549>,<-0.08211,0.7623,0.27617><-0.02483,0.79126,0.2733>,<-0.03193,0.80133,0.2701>,<-0.05006,0.82343,0.26038>,
              <-0.0697,0.84224,0.24764>,<-0.07925,0.84692,0.23953>,<-0.07286,0.83531,0.24131>,
              <-0.05402,0.81475,0.25245>,<-0.03367,0.7975,0.2666><-0.17513,0.82213,0.1903>,<-0.16552,0.82959,0.19402>,<-0.14484,0.8494,0.20361>,
              <-0.12793,0.87189,0.21408>,<-0.12447,0.88373,0.21926>,<-0.13585,0.87753,0.21596>,
              <-0.15477,0.85646,0.20595>,<-0.1699,0.8327,0.19506><-0.08204,0.86578,0.24078>,<-0.09185,0.87268,0.23653>,<-0.11601,0.88657,0.22491>,
              <-0.14091,0.89628,0.21123>,<-0.15192,0.89637,0.20362>,<-0.14245,0.88751,0.2069>,
              <-0.11794,0.87558,0.21949>,<-0.0927,0.86784,0.23414><-0.22859,0.8609,0.16188>,<-0.2174,0.86451,0.16674>,<-0.19215,0.8758,0.17886>,
              <-0.16954,0.89096,0.19155>,<-0.16266,0.90086,0.19733>,<-0.1751,0.89907,0.19273>,
              <-0.19911,0.88596,0.18035>,<-0.22047,0.86899,0.1674><-0.12529,0.87901,0.2133>,<-0.1349,0.88583,0.20851>,<-0.15889,0.89938,0.19615>,
              <-0.18408,0.90853,0.18259>,<-0.19563,0.90818,0.17586>,<-0.18658,0.89928,0.18009>,
              <-0.16202,0.8878,0.19301>,<-0.13628,0.88072,0.20712><-0.26239,0.86593,0.10926>,<-0.25371,0.86997,0.11765>,<-0.23445,0.8823,0.13736>,
              <-0.21771,0.89854,0.15628>,<-0.21316,0.90893,0.16336>,<-0.22302,0.90673,0.1546>,
              <-0.2411,0.89256,0.13527>,<-0.25665,0.87449,0.11672><-0.07245,0.87219,0.19957>,<-0.06461,0.87039,0.20943>,<-0.04576,0.86916,0.23298>,
              <-0.02701,0.87263,0.25618>,<-0.01934,0.87849,0.26544>,<-0.02723,0.8825,0.25542>,
              <-0.04604,0.88152,0.23203>,<-0.06474,0.87584,0.20901><-0.02508,0.83733,0.2806>,<-0.01581,0.84544,0.2774>,<0.00684,0.86278,0.26749>,
              <0.02988,0.87678,0.25428>,<0.03979,0.87944,0.24569>,<0.0307,0.86977,0.24733>,
              <0.00786,0.854,0.25879>,<-0.01536,0.84156,0.27357><0.03378,0.84625,0.1652>,<0.03799,0.84856,0.17698>,<0.04848,0.85693,0.20404>,
              <0.05947,0.86949,0.229>,<0.06448,0.87864,0.23737>,<0.0605,0.8783,0.2246>,
              <0.04978,0.86797,0.19853>,<0.03856,0.85343,0.17455><0.03384,0.83592,0.28345>,<0.04237,0.843,0.2772>,<0.06241,0.85776,0.26009>,
              <0.08163,0.86899,0.23995>,<0.08883,0.87034,0.22875>,<0.07992,0.86161,0.23358>,
              <0.06026,0.84851,0.25211>,<0.04142,0.83892,0.27368><0.08396,0.85372,0.14109>,<0.08649,0.85257,0.15351>,<0.09365,0.85266,0.18284>,
              <0.10241,0.85709,0.21122>,<0.10754,0.863,0.22207>,<0.10576,0.86619,0.2092>,
              <0.09785,0.86406,0.18032>,<0.08834,0.85759,0.15239><0.07926,0.82564,0.28386>,<0.08654,0.83215,0.2757>,<0.10278,0.84571,0.25414>,
              <0.11699,0.85604,0.2298>,<0.12098,0.8573,0.21709>,<0.11275,0.84928,0.22394>,
              <0.09746,0.83723,0.24681>,<0.0842,0.82841,0.27246><0.12718,0.83435,0.12129>,<0.12834,0.83261,0.13384>,<0.13288,0.83096,0.16365>,
              <0.14005,0.83316,0.19273>,<0.14548,0.8377,0.20408>,<0.14555,0.84125,0.19118>,
              <0.13978,0.84109,0.16172>,<0.13138,0.83708,0.13299><-0.00784,0.96554,0.27066>,<-0.01408,0.95462,0.27258>,<-0.02996,0.92994,0.27972>,
              <-0.04709,0.90783,0.29063>,<-0.05535,0.90106,0.29868>,<-0.0497,0.91318,0.29853>,
              <-0.03323,0.93666,0.28963>,<-0.01552,0.95758,0.27695><-0.08428,0.9144,0.25768>,<-0.08452,0.90773,0.26851>,<-0.083,0.89005,0.29295>,
              <-0.07828,0.87003,0.31482>,<-0.07334,0.85952,0.32147>,<-0.0716,0.8651,0.30943>,
              <-0.07462,0.88387,0.2862>,<-0.08083,0.905,0.26554><-0.01161,0.87823,0.29946>,<-0.02239,0.87176,0.30143>,<-0.0478,0.85733,0.30904>,
              <-0.0723,0.84466,0.32093>,<-0.08158,0.84108,0.32987>,<-0.07037,0.84838,0.3299>,
              <-0.04539,0.86198,0.32028>,<-0.02133,0.87382,0.30639><-0.09725,0.8707,0.2687>,<-0.09857,0.86419,0.27956>,<-0.09889,0.84765,0.30482>,
              <-0.09487,0.82986,0.32867>,<-0.08914,0.82132,0.33723>,<-0.08579,0.82725,0.32571>,
              <-0.08751,0.84438,0.30111>,<-0.09356,0.86275,0.27792><-0.02138,0.80262,0.30928>,<-0.03356,0.79997,0.31185>,<-0.06176,0.79408,0.32088>,
              <-0.08817,0.78895,0.33422>,<-0.09743,0.78755,0.34378>,<-0.0844,0.79056,0.34323>,
              <-0.05704,0.79609,0.33218>,<-0.03148,0.80086,0.31682><-0.13597,0.77152,0.27072>,<-0.13369,0.76882,0.28294>,<-0.12534,0.76203,0.31116>,
              <-0.11271,0.75478,0.33742>,<-0.10347,0.75137,0.34647>,<-0.10375,0.75386,0.33333>,
              <-0.1141,0.76087,0.30603>,<-0.12874,0.76831,0.28068><-0.10091,0.7154,0.42951>,<-0.09889,0.71785,0.41719>,<-0.09714,0.7238,0.38763>,
              <-0.1001,0.72975,0.35835>,<-0.10575,0.73223,0.34648>,<-0.10998,0.72977,0.35893>,
              <-0.10952,0.72383,0.38836>,<-0.10435,0.71787,0.41751><-0.12612,1.00224,0.35188>,<-0.11604,0.99755,0.3457>,<-0.0924,0.98877,0.32908>,
              <-0.06983,0.9838,0.30991>,<-0.06149,0.98533,0.29956>,<-0.07208,0.99181,0.30454>,
              <-0.09521,0.99881,0.32236>,<-0.11728,1.00198,0.34273><-0.07377,1.00112,0.34309>,<-0.07582,0.99934,0.33066>,<-0.08105,0.99214,0.3018>,
              <-0.08669,0.98057,0.27467>,<-0.08941,0.97167,0.26507>,<-0.08755,0.9714,0.27831>,
              <-0.08213,0.98065,0.30635>,<-0.0763,0.99428,0.33267><-0.192,0.9399,0.2539>,<-0.17932,0.94041,0.25294>,<-0.14963,0.94401,0.24877>,
              <-0.12131,0.95116,0.24183>,<-0.11087,0.95746,0.23633>,<-0.12419,0.95862,0.23599>,
              <-0.15324,0.95336,0.24146>,<-0.18091,0.94454,0.24972><-0.10788,0.95863,0.31272>,<-0.10729,0.95978,0.30006>,<-0.10796,0.96026,0.26987>,
              <-0.11177,0.95727,0.24024>,<-0.11631,0.95278,0.22849>,<-0.11838,0.94999,0.24141>,
              <-0.11624,0.95114,0.27133>,<-0.11094,0.95576,0.30071><-0.20357,0.90555,0.22557>,<-0.1913,0.90889,0.22552>,<-0.1628,0.91856,0.22295>,
              <-0.13603,0.93063,0.2167>,<-0.12656,0.93789,0.21065>,<-0.13964,0.93567,0.20898>,
              <-0.16733,0.92488,0.21328>,<-0.19329,0.91168,0.22125><-0.12354,0.89179,0.26236>,<-0.12388,0.89555,0.2502>,<-0.1272,0.90274,0.22106>,
              <-0.13429,0.9071,0.19221>,<-0.14076,0.90625,0.18054>,<-0.14219,0.90116,0.19283>,
              <-0.1371,0.8953,0.22183>,<-0.12824,0.89227,0.25054><-0.20622,0.84801,0.18589>,<-0.19582,0.85524,0.18714>,<-0.1718,0.87355,0.18736>,
              <-0.14944,0.89318,0.18335>,<-0.14173,0.90256,0.17773>,<-0.15291,0.89596,0.1745>,
              <-0.17614,0.87702,0.17627>,<-0.19773,0.85677,0.18225><-0.10428,1.09062,0.28612>,<-0.0995,1.07985,0.29094>,<-0.08567,1.05594,0.30315>,
              <-0.0684,1.03515,0.31622>,<-0.05801,1.02946,0.32244>,<-0.06118,1.04168,0.31802>,
              <-0.07662,1.06413,0.30541>,<-0.09551,1.08346,0.29193><-0.10129,1.0575,0.331>,<-0.0902,1.05133,0.33013>,<-0.06529,1.03471,0.32618>,
              <-0.04319,1.01553,0.31945>,<-0.03668,1.00517,0.31405>,<-0.04909,1.01013,0.31362>,
              <-0.07268,1.02795,0.31887>,<-0.09346,1.04835,0.3269><-0.0539,1.04781,0.25485>,<-0.05147,1.0376,0.26204>,<-0.04331,1.01493,0.28025>,
              <-0.03169,0.99523,0.2997>,<-0.02365,0.98986,0.30894>,<-0.02446,1.00146,0.30233>,
              <-0.03424,1.02274,0.28354>,<-0.04747,1.04105,0.2635><-0.08967,0.99585,0.30509>,<-0.07757,0.99269,0.30746>,<-0.04867,0.98438,0.31014>,
              <-0.02019,0.97504,0.30824>,<-0.0088,0.97022,0.30314>,<-0.0211,0.9729,0.29861>,
              <-0.04981,0.98169,0.29808>,<-0.07808,0.99151,0.30214><-0.00341,0.97135,0.21837>,<-0.00292,0.96356,0.22842>,<0.00097,0.94633,0.25292>,
              <0.0089,0.93149,0.27778>,<0.01599,0.92759,0.28843>,<0.0174,0.9365,0.27856>,
              <0.01162,0.95261,0.25389>,<0.00178,0.96632,0.22885><-0.04827,0.88004,0.31479>,<-0.03629,0.88326,0.31195>,<-0.00872,0.89087,0.30226>,
              <0.01682,0.89826,0.28832>,<0.0255,0.90111,0.27854>,<0.01257,0.89779,0.27939>,
              <-0.01405,0.89029,0.29108>,<-0.03864,0.883,0.30702><0.02189,0.88126,0.18243>,<0.02067,0.87823,0.19472>,<0.02077,0.87166,0.2242>,
              <0.02545,0.86619,0.25335>,<0.03168,0.86498,0.26512>,<0.03505,0.86853,0.25267>,
              <0.0328,0.87458,0.22335>,<0.02598,0.87952,0.19435><-0.00989,0.29307,-0.03453>,<-0.0148,0.28364,-0.02754>,<-0.02669,0.26328,-0.00867>,
              <-0.03861,0.24655,0.01323>,<-0.04358,0.24302,0.02514>,<-0.03869,0.25416,0.01957>,
              <-0.02678,0.27281,-0.00073>,<-0.01484,0.28784,-0.02404><-0.06597,0.17987,0.05957>,<-0.05956,0.17878,0.0705>,<-0.0424,0.17435,0.09496>,
              <-0.02273,0.16719,0.11648>,<-0.01222,0.16167,0.12265>,<-0.01745,0.16149,0.11034>,
              <-0.03579,0.1672,0.08726>,<-0.05665,0.17563,0.06711><0.03944,0.19521,0.0721>,<0.03181,0.18744,0.07867>,<0.01374,0.17107,0.0965>,
              <-0.00377,0.15833,0.11729>,<-0.01051,0.15646,0.1287>,<-0.00262,0.16594,0.12352>,
              <0.01519,0.1806,0.1043>,<0.03244,0.19164,0.08211><-0.0601,0.12321,0.11226>,<-0.0526,0.12346,0.12254>,<-0.03269,0.12265,0.14523>,
              <-0.01004,0.1197,0.16472>,<0.00191,0.11647,0.16979>,<-0.00431,0.11522,0.15801>,
              <-0.0255,0.11703,0.13682>,<-0.04943,0.12098,0.11883><0.0869,-0.03653,0.18156>,<0.07703,-0.03457,0.18935>,<0.05561,-0.02863,0.20978>,
              <0.03778,-0.02087,0.23266>,<0.03378,-0.01594,0.24444>,<0.04534,-0.01704,0.23779>,
              <0.06507,-0.02384,0.21621>,<0.08121,-0.03246,0.19218><-0.04561,0.35985,0.04874>,<-0.04757,0.34811,0.04425>,<-0.05513,0.32108,0.0331>,
              <-0.06694,0.29604,0.02147>,<-0.07583,0.28754,0.01622>,<-0.07587,0.30021,0.02049>,
              <-0.06631,0.32631,0.03186>,<-0.0525,0.35041,0.0437><-0.07847,0.20658,-0.05067>,<-0.08859,0.20006,-0.04656>,<-0.1107,0.18308,-0.03495>,
              <-0.12929,0.16424,-0.02078>,<-0.1337,0.15468,-0.01252>,<-0.12193,0.16033,-0.01544>,
              <-0.10147,0.17819,-0.02825>,<-0.08452,0.1979,-0.04361><-0.08387,0.11372,0.03401>,<-0.0904,0.10968,0.02386>,<-0.10837,0.09998,0.00161>,
              <-0.12964,0.09035,-0.01727>,<-0.14156,0.08643,-0.02192>,<-0.13657,0.0905,-0.01019>,
              <-0.11705,0.10017,0.01047>,<-0.09423,0.10976,0.02777><-0.19877,0.09624,-0.07211>,<-0.19238,0.08959,-0.06335>,<-0.17488,0.07368,-0.04457>,
              <-0.15429,0.05798,-0.02936>,<-0.14287,0.05168,-0.02641>,<-0.14782,0.05843,-0.03684>,
              <-0.16677,0.07425,-0.05394>,<-0.1888,0.08984,-0.06748><-0.06766,-0.04091,0.01817>,<-0.07523,-0.03811,0.00834>,<-0.09555,-0.0319,-0.01312>,
              <-0.11898,-0.02657,-0.03112>,<-0.1316,-0.02517,-0.03534>,<-0.12549,-0.02838,-0.02388>,
              <-0.10371,-0.03418,-0.00405>,<-0.07882,-0.03911,0.01234><-0.0856,0.3272,0.00032>,<-0.07364,0.3277,-0.00399>,<-0.04576,0.33185,-0.01483>,
              <-0.01939,0.34043,-0.02634>,<-0.00987,0.34814,-0.03172>,<-0.02254,0.34971,-0.02772>,
              <-0.04971,0.34348,-0.01657>,<-0.07538,0.33283,-0.00476><0.02873,0.32243,0.02036>,<0.02862,0.32857,0.00922>,<0.0271,0.34063,-0.01843>,
              <0.0237,0.34851,-0.0472>,<0.02053,0.34785,-0.06018>,<0.01976,0.33975,-0.04957>,
              <0.02216,0.32965,-0.02139>,<0.02644,0.32373,0.00791><0.00268,0.3225,-0.1384>,<0.01489,0.32207,-0.13483>,<0.04414,0.32388,-0.12753>,
              <0.07306,0.32995,-0.12221>,<0.08473,0.33649,-0.12186>,<0.07236,0.33892,-0.12635>,
              <0.04327,0.33511,-0.13272>,<0.01451,0.32702,-0.13712><0.16263,0.25833,-0.11066>,<0.16122,0.26668,-0.12016>,<0.1555,0.28479,-0.14364>,
              <0.14629,0.29983,-0.16794>,<0.13919,0.30318,-0.17877>,<0.13897,0.29339,-0.16966>,
              <0.14633,0.27672,-0.1458>,<0.15718,0.26312,-0.12111><0.1066,0.22703,-0.2441>,<0.11604,0.232,-0.23717>,<0.13829,0.24626,-0.22256>,
              <0.1597,0.26392,-0.21111>,<0.16779,0.27443,-0.20934>,<0.15796,0.27105,-0.21775>,
              <0.1361,0.25519,-0.23088>,<0.11508,0.23594,-0.24084><-0.00915,0.36868,0.02504>,<-0.02047,0.36788,0.0308>,<-0.04713,0.36901,0.04494>,
              <-0.07282,0.37474,0.0594>,<-0.08253,0.38144,0.0657>,<-0.07075,0.3844,0.06009>,
              <-0.04455,0.38111,0.0458>,<-0.01933,0.37321,0.03119><-0.13883,0.36857,0.06144>,<-0.13413,0.37351,0.07218>,<-0.12192,0.38243,0.09832>,
              <-0.1084,0.38683,0.12476>,<-0.10157,0.38441,0.13601>,<-0.10566,0.37734,0.12541>,
              <-0.11848,0.37054,0.09913>,<-0.13261,0.36826,0.07254><-0.04793,0.35084,0.22769>,<-0.06064,0.35122,0.228>,<-0.09055,0.35494,0.2299>,
              <-0.11928,0.36289,0.23354>,<-0.13006,0.37016,0.23667>,<-0.11679,0.37176,0.23718>,
              <-0.08744,0.36606,0.23446>,<-0.05927,0.35612,0.23001><-0.17955,0.28403,0.24524>,<-0.17727,0.29427,0.25243>,<-0.16903,0.31747,0.26992>,
              <-0.15668,0.33835,0.28761>,<-0.14771,0.34483,0.29513>,<-0.14806,0.33349,0.28804>,
              <-0.15823,0.31138,0.27045>,<-0.17251,0.29159,0.25266><-0.07491,0.30083,0.33426>,<-0.08722,0.30222,0.33134>,<-0.11635,0.30816,0.326>,
              <-0.14458,0.31797,0.3232>,<-0.15545,0.32568,0.32443>,<-0.14273,0.3261,0.32854>,
              <-0.11402,0.31835,0.33269>,<-0.08619,0.30671,0.33429><-0.09923,0.41625,0.05877>,<-0.10376,0.41224,0.04758>,<-0.11593,0.40543,0.02079>,
              <-0.12994,0.40296,-0.00566>,<-0.13747,0.406,-0.01628>,<-0.13381,0.41205,-0.00492>,
              <-0.12077,0.41682,0.0217>,<-0.1059,0.41726,0.04798><-0.11847,0.36077,-0.07498>,<-0.1305,0.36475,-0.07383>,<-0.15939,0.37204,-0.06894>,
              <-0.18806,0.37587,-0.06086>,<-0.19971,0.37419,-0.05452>,<-0.18757,0.36858,-0.05417>,
              <-0.15879,0.36292,-0.06056>,<-0.13023,0.36072,-0.07014><-0.21802,0.35301,0.00978>,<-0.21847,0.35046,-0.00268>,<-0.22155,0.34669,-0.03249>,
              <-0.22764,0.34654,-0.06189>,<-0.23298,0.34988,-0.07369>,<-0.23394,0.35413,-0.06104>,
              <-0.22945,0.3562,-0.03143>,<-0.22195,0.35465,-0.00221><-0.19319,0.30917,-0.13594>,<-0.20411,0.31349,-0.13103>,<-0.22972,0.32156,-0.11722>,
              <-0.25422,0.32612,-0.10047>,<-0.26331,0.32471,-0.09076>,<-0.25187,0.31875,-0.09429>,
              <-0.22678,0.31232,-0.10948>,<-0.20281,0.30941,-0.12762><-0.24658,0.27695,-0.02666>,<-0.2489,0.2808,-0.03856>,<-0.25681,0.29147,-0.06568>,
              <-0.26822,0.30419,-0.09038>,<-0.27623,0.31138,-0.09833>,<-0.27555,0.30848,-0.08529>,
              <-0.266,0.29685,-0.0593>,<-0.25295,0.28317,-0.03575><-0.11078,0.48205,-0.05338>,<-0.10403,0.47797,-0.04339>,<-0.08701,0.47119,-0.01938>,
              <-0.06893,0.469,0.00449>,<-0.06044,0.47241,0.01425>,<-0.0667,0.47864,0.0042>,
              <-0.08421,0.48327,-0.01975>,<-0.10279,0.4833,-0.04356><0.02335,0.44483,0.03753>,<0.02447,0.44827,0.02533>,<0.02585,0.45373,-0.00434>,
              <0.02523,0.45494,-0.03433>,<0.02309,0.45143,-0.04706>,<0.02103,0.44599,-0.03502>,
              <0.0206,0.44253,-0.0052>,<0.02216,0.44333,0.02495><-0.02863,0.42363,-0.06761>,<-0.01604,0.4244,-0.06595>,<0.01386,0.42831,-0.06426>,
              <0.043,0.43532,-0.06605>,<0.05436,0.44115,-0.07005>,<0.04141,0.44184,-0.07333>,
              <0.01187,0.43647,-0.07339>,<-0.01691,0.42799,-0.06998><0.12721,0.38371,-0.02867>,<0.12615,0.38904,-0.04017>,<0.12179,0.39936,-0.06822>,
              <0.11475,0.40582,-0.09668>,<0.10931,0.40487,-0.10887>,<0.10911,0.39773,-0.09756>,
              <0.11473,0.38922,-0.06932>,<0.12303,0.38457,-0.04066><0.0878,0.30763,-0.15802>,<0.09701,0.31408,-0.15206>,<0.11891,0.33125,-0.14033>,
              <0.14031,0.35085,-0.13262>,<0.14871,0.36125,-0.1332>,<0.13926,0.35594,-0.14104>,
              <0.1176,0.33763,-0.15088>,<0.09643,0.31689,-0.15671><-0.019,0.48671,-0.0208>,<-0.029,0.48942,-0.01342>,<-0.0514,0.49855,0.00465>,
              <-0.07117,0.51158,0.02312>,<-0.07688,0.52064,0.03114>,<-0.06564,0.51976,0.02394>,
              <-0.04448,0.50879,0.00568>,<-0.02595,0.49393,-0.01297><-0.10935,0.48958,0.03235>,<-0.10719,0.49912,0.04048>,<-0.1001,0.5199,0.06121>,
              <-0.09016,0.5373,0.08358>,<-0.08338,0.54131,0.09439>,<-0.0842,0.53018,0.08702>,
              <-0.09263,0.51099,0.06552>,<-0.1039,0.49519,0.04238><-0.01018,0.5218,0.08252>,<-0.02199,0.52275,0.08718>,<-0.04965,0.52803,0.09809>,
              <-0.07604,0.53784,0.10852>,<-0.08579,0.54615,0.11238>,<-0.07339,0.54733,0.10749>,
              <-0.04633,0.53992,0.09681>,<-0.02052,0.52799,0.08661><-0.15689,0.51604,0.159>,<-0.15036,0.52466,0.1657>,<-0.13286,0.54287,0.18226>,
              <-0.11278,0.55717,0.19941>,<-0.10205,0.55942,0.20706>,<-0.10738,0.54897,0.20064>,
              <-0.12608,0.53259,0.18381>,<-0.14737,0.52013,0.16638><-0.03601,0.52418,0.28885>,<-0.04858,0.52529,0.28718>,<-0.07811,0.53082,0.28414>,
              <-0.10643,0.54067,0.28259>,<-0.11703,0.5488,0.28334>,<-0.1039,0.54972,0.28571>,
              <-0.07493,0.54216,0.28805>,<-0.04718,0.53029,0.28891><-0.20475,0.51453,0.30362>,<-0.19387,0.52021,0.307>,<-0.1667,0.531,0.31457>,
              <-0.13814,0.53736,0.32128>,<-0.12499,0.53584,0.32326>,<-0.13521,0.52807,0.31948>,
              <-0.16304,0.51936,0.31231>,<-0.19226,0.51508,0.306><-0.04456,0.59785,0.06142>,<-0.0519,0.58943,0.05532>,<-0.07155,0.57154,0.04098>,
              <-0.09412,0.5573,0.02722>,<-0.10622,0.55484,0.02206>,<-0.10025,0.56498,0.02843>,
              <-0.07923,0.58116,0.0425>,<-0.05529,0.59368,0.05599><-0.1298,0.55678,0.08615>,<-0.13207,0.55322,0.07414>,<-0.13889,0.54231,0.04682>,
              <-0.14774,0.52795,0.02198>,<-0.15332,0.51876,0.01403>,<-0.15202,0.5207,0.0272>,
              <-0.14424,0.53323,0.05336>,<-0.13443,0.54921,0.07703><-0.12091,0.53031,0.07129>,<-0.12672,0.52418,0.06177>,<-0.14282,0.51162,0.03952>,
              <-0.16203,0.50243,0.01835>,<-0.17291,0.5018,0.0106>,<-0.16856,0.50952,0.02062>,
              <-0.15101,0.52049,0.04237>,<-0.13033,0.52809,0.06303><-0.14458,0.44995,-0.03885>,<-0.15684,0.45036,-0.03548>,<-0.18511,0.45,-0.02485>,
              <-0.21136,0.44761,-0.01047>,<-0.22034,0.44472,-0.00099>,<-0.20713,0.44335,-0.0026>,
              <-0.17981,0.44466,-0.01499>,<-0.15451,0.448,-0.03113><-0.19275,0.39281,0.05812>,<-0.1982,0.39307,0.04662>,<-0.21373,0.39444,0.02076>,
              <-0.23285,0.39693,-0.00225>,<-0.24415,0.39901,-0.00911>,<-0.24039,0.39928,0.00373>,
              <-0.22317,0.39738,0.02825>,<-0.20236,0.39436,0.04993><-0.12099,0.61788,-0.04319>,<-0.11295,0.62172,-0.03411>,<-0.09437,0.63371,-0.01354>,
              <-0.07706,0.64978,0.00501>,<-0.07108,0.66025,0.01079>,<-0.07971,0.65832,0.00076>,
              <-0.09769,0.64441,-0.01886>,<-0.11441,0.62644,-0.03646><-0.01202,0.61902,0.0376>,<-0.01728,0.62878,0.03136>,<-0.03185,0.64996,0.01551>,
              <-0.04926,0.66754,-0.0015>,<-0.05913,0.67145,-0.00965>,<-0.05519,0.66,-0.00395>,
              <-0.03929,0.64051,0.01245>,<-0.02056,0.62462,0.03001><-0.10449,0.65362,-0.03559>,<-0.09272,0.65697,-0.03908>,<-0.06565,0.66784,-0.04688>,
              <-0.04058,0.68288,-0.05374>,<-0.03207,0.69302,-0.05568>,<-0.04478,0.69162,-0.05175>,
              <-0.07092,0.67879,-0.04439>,<-0.09504,0.6618,-0.03798><0.04441,0.65527,-0.0566>,<0.03931,0.66495,-0.0631>,<0.02522,0.68591,-0.07965>,
              <0.00842,0.70324,-0.09751>,<-0.00108,0.70699,-0.10616>,<0.00275,0.6956,-0.10028>,
              <0.01812,0.67635,-0.08312>,<0.03618,0.66073,-0.06463><-0.06101,0.6601,-0.13122>,<-0.04934,0.66475,-0.1292>,<-0.02283,0.67857,-0.12494>,
              <0.00118,0.69629,-0.12158>,<0.00877,0.70729,-0.12105>,<-0.00408,0.70447,-0.12349>,
              <-0.02941,0.68882,-0.12733>,<-0.05224,0.66927,-0.13026><0.13064,0.65287,-0.17293>,<0.12194,0.66145,-0.17651>,<0.09949,0.67942,-0.18572>,
              <0.07483,0.69331,-0.19574>,<0.06254,0.69522,-0.20065>,<0.07019,0.68473,-0.19745>,
              <0.09368,0.66867,-0.18786>,<0.11938,0.65671,-0.17746><-0.05954,0.75114,-0.0179>,<-0.06361,0.74078,-0.01173>,<-0.07238,0.71758,0.0055>,
              <-0.07955,0.69709,0.02625>,<-0.08103,0.69116,0.03814>,<-0.07621,0.70279,0.03362>,
              <-0.06819,0.72472,0.01475>,<-0.06177,0.74393,-0.00765><-0.10319,0.71893,0.00045>,<-0.09965,0.71243,0.0108>,<-0.08934,0.69542,0.03353>,
              <-0.07639,0.67646,0.05288>,<-0.06856,0.66675,0.05771>,<-0.07086,0.67233,0.04577>,
              <-0.08241,0.69026,0.02463>,<-0.09659,0.71015,0.00688><-0.02919,0.67827,0.01425>,<-0.03436,0.67019,0.02262>,<-0.04473,0.65221,0.04456>,
              <-0.05189,0.6365,0.06912>,<-0.05186,0.63213,0.08176>,<-0.04519,0.64127,0.07463>,
              <-0.03633,0.65819,0.05146>,<-0.03066,0.67283,0.02566><-0.09666,0.59578,0.07304>,<-0.08758,0.59238,0.08128>,<-0.06445,0.5833,0.09844>,
              <-0.03948,0.57287,0.11146>,<-0.02741,0.5673,0.11296>,<-0.03563,0.57006,0.10278>,
              <-0.05963,0.57978,0.08757>,<-0.08546,0.59083,0.07649><0.02253,0.60136,0.05941>,<0.01403,0.59417,0.06557>,<-0.0048,0.57801,0.08279>,
              <-0.02104,0.56362,0.10354>,<-0.02534,0.55932,0.11545>,<-0.01563,0.56733,0.11095>,
              <0.00199,0.58266,0.09207>,<0.01702,0.59623,0.06966><-0.08663,0.44168,0.1141>,<-0.07576,0.44558,0.11944>,<-0.04867,0.45452,0.12935>,
              <-0.0203,0.46274,0.13478>,<-0.00736,0.46546,0.13281>,<-0.01763,0.46122,0.12536>,
              <-0.04532,0.45262,0.11756>,<-0.07428,0.44474,0.11424><-0.04342,0.73381,0.06944>,<-0.05266,0.73486,0.06075>,<-0.07568,0.73967,0.04182>,
              <-0.09982,0.74789,0.02596>,<-0.11086,0.75448,0.02228>,<-0.10215,0.75502,0.03241>,
              <-0.0786,0.74862,0.0499>,<-0.05394,0.73881,0.06432><-0.12287,0.74037,0.09943>,<-0.12241,0.74525,0.08769>,<-0.12193,0.754,0.05879>,
              <-0.12239,0.7582,0.02906>,<-0.12346,0.75566,0.01597>,<-0.12436,0.74865,0.02732>,
              <-0.1244,0.74204,0.05661>,<-0.1235,0.73997,0.08673><-0.13668,0.71998,0.05806>,<-0.14096,0.72363,0.04665>,<-0.15206,0.73489,0.02092>,
              <-0.16429,0.74982,-0.00208>,<-0.17043,0.75946,-0.00904>,<-0.16668,0.75753,0.00366>,
              <-0.15505,0.74455,0.02811>,<-0.14228,0.72789,0.04982><-0.12968,0.73588,-0.07026>,<-0.13901,0.74215,-0.06429>,<-0.16203,0.75431,-0.04899>,
              <-0.18582,0.76202,-0.03238>,<-0.1964,0.76101,-0.02425>,<-0.18744,0.75265,-0.0296>,
              <-0.16405,0.74258,-0.04552>,<-0.1399,0.73697,-0.06276><-0.23949,0.70437,0.01581>,<-0.23908,0.70958,0.00421>,<-0.23935,0.72446,-0.02207>,
              <-0.24151,0.7428,-0.04575>,<-0.24417,0.75364,-0.05312>,<-0.24546,0.75006,-0.04029>,
              <-0.24431,0.73355,-0.01524>,<-0.24127,0.71359,0.00722><-0.35874,0.72508,-0.11309>,<-0.34853,0.72932,-0.1068>,<-0.32284,0.73686,-0.09283>,
              <-0.2956,0.74034,-0.08069>,<-0.28286,0.73796,-0.07737>,<-0.29235,0.73181,-0.08452>,
              <-0.31876,0.72617,-0.09763>,<-0.34673,0.72461,-0.10892><-0.30637,0.68427,-0.01463>,<-0.30298,0.68909,-0.02591>,<-0.29656,0.70301,-0.05193>,
              <-0.29277,0.72039,-0.07611>,<-0.29368,0.73084,-0.08441>,<-0.2983,0.72765,-0.07227>,
              <-0.30348,0.71211,-0.04711>,<-0.30603,0.6931,-0.02378><-0.12758,0.7908,-0.04116>,<-0.12162,0.79213,-0.02999>,<-0.10726,0.79827,-0.00415>,
              <-0.09291,0.80883,0.02003>,<-0.087,0.81735,0.02847>,<-0.09296,0.81809,0.01652>,
              <-0.10732,0.80988,-0.00854>,<-0.12165,0.79725,-0.03193><0.00627,0.7912,0.06267>,<0.00263,0.79954,0.05378>,<-0.00768,0.81707,0.03145>,
              <-0.02029,0.83068,0.00784>,<-0.02766,0.83263,-0.00315>,<-0.0251,0.82245,0.00515>,
              <-0.01371,0.80677,0.02807>,<-0.00003,0.795,0.05229><-0.06975,0.81043,-0.04934>,<-0.05809,0.81193,-0.04447>,<-0.03089,0.81849,-0.0331>,
              <-0.00512,0.82951,-0.02233>,<0.00421,0.83826,-0.01844>,<-0.00812,0.83886,-0.02359>,
              <-0.03464,0.83021,-0.03468>,<-0.05974,0.81709,-0.04517><0.0233,0.82907,0.05886>,<0.02327,0.83321,0.04683>,<0.02255,0.84016,0.01745>,
              <0.02085,0.84252,-0.01243>,<0.01922,0.83919,-0.02528>,<0.01878,0.8329,-0.01349>,
              <0.01997,0.8281,0.01613>,<0.02213,0.82789,0.04625><0.00263,0.77943,-0.08033>,<0.01058,0.78555,-0.07251>,<0.02893,0.8026,-0.05563>,
              <0.04601,0.82304,-0.04177>,<0.05189,0.83469,-0.03887>,<0.04335,0.83016,-0.04811>,
              <0.0256,0.81152,-0.06357>,<0.00911,0.78949,-0.07601><0.12648,0.75103,-0.01277>,<0.12508,0.76246,-0.0182>,<0.12034,0.78813,-0.03339>,
              <0.11356,0.81093,-0.05171>,<0.10883,0.81767,-0.06225>,<0.10928,0.8049,-0.0583>,
              <0.11497,0.78058,-0.04164>,<0.12271,0.75913,-0.02184><-0.06707,0.80431,0.05875>,<-0.07577,0.81358,0.0582>,<-0.09408,0.83756,0.05679>,
              <-0.10833,0.86394,0.05523>,<-0.11042,0.87713,0.05445>,<-0.09982,0.86899,0.05493>,
              <-0.08342,0.84389,0.05641>,<-0.07107,0.81637,0.05804><-0.15082,0.82562,0.02405>,<-0.14583,0.83671,0.0278>,<-0.1334,0.86167,0.0394>,
              <-0.12039,0.88391,0.05481>,<-0.11447,0.89058,0.06478>,<-0.11919,0.87821,0.06282>,
              <-0.13189,0.85453,0.04943>,<-0.14516,0.83356,0.03222><-0.06696,0.85155,0.11022>,<-0.07693,0.85841,0.1063>,<-0.0986,0.87686,0.09619>,
              <-0.11664,0.89815,0.0851>,<-0.1207,0.90964,0.07959>,<-0.10901,0.90412,0.08305>,
              <-0.08905,0.88434,0.09362>,<-0.07272,0.86171,0.10517><-0.19992,0.89299,0.10758>,<-0.19154,0.9024,0.10582>,<-0.17023,0.92373,0.10418>,
              <-0.14728,0.94296,0.10643>,<-0.13624,0.94896,0.11102>,<-0.14385,0.93855,0.1146>,
              <-0.16593,0.91821,0.11442>,<-0.18965,0.89996,0.11034><-0.08145,0.96596,0.19361>,<-0.09298,0.96552,0.18823>,<-0.11952,0.96699,0.17391>,
              <-0.14415,0.97227,0.15756>,<-0.15255,0.97804,0.14889>,<-0.14013,0.98026,0.15332>,
              <-0.11448,0.977,0.16859>,<-0.09075,0.96993,0.18589><-0.23961,0.96566,0.14961>,<-0.22851,0.97167,0.1512>,<-0.20132,0.9836,0.15674>,
              <-0.17354,0.99161,0.16485>,<-0.16148,0.99125,0.17062>,<-0.1723,0.9834,0.17024>,
              <-0.19977,0.97331,0.1635>,<-0.22782,0.96714,0.15418><-0.13005,0.98109,0.27047>,<-0.13829,0.98272,0.26091>,<-0.1561,0.98891,0.23732>,
              <-0.17074,0.99852,0.21293>,<-0.17384,1.00571,0.20209>,<-0.16412,1.00569,0.21127>,
              <-0.1478,0.9979,0.23524>,<-0.13463,0.98668,0.26><-0.10802,0.98455,0.07912>,<-0.10749,0.97327,0.07326>,<-0.109,0.94715,0.05818>,
              <-0.11469,0.92269,0.04171>,<-0.12098,0.91413,0.03358>,<-0.12348,0.9262,0.03879>,
              <-0.12001,0.95154,0.05452>,<-0.11235,0.97521,0.07164><-0.14,0.95836,0.06857>,<-0.13627,0.94985,0.05989>,<-0.12926,0.92763,0.04067>,
              <-0.12526,0.9029,0.02411>,<-0.12642,0.89032,0.01974>,<-0.13156,0.89766,0.02967>,
              <-0.13715,0.92105,0.04763>,<-0.13975,0.94695,0.06296><-0.1255,0.8823,0.06766>,<-0.1243,0.87532,0.05709>,<-0.12437,0.85944,0.0314>,
              <-0.12892,0.84505,0.00544>,<-0.135,0.84049,-0.00556>,<-0.1383,0.84816,0.00488>,
              <-0.13613,0.86334,0.0307>,<-0.12948,0.87703,0.05678><-0.08082,0.88767,-0.02455>,<-0.09032,0.87922,-0.02502>,<-0.11172,0.85796,-0.02354>,
              <-0.13083,0.83544,-0.01813>,<-0.13658,0.82492,-0.01221>,<-0.12601,0.83278,-0.0099>,
              <-0.10569,0.85463,-0.01323>,<-0.08766,0.87775,-0.02047><-0.10629,0.77581,0.05315>,<-0.10795,0.77556,0.04054>,<-0.11491,0.77495,0.01116>,
              <-0.12631,0.77434,-0.01662>,<-0.1352,0.77409,-0.02661>,<-0.13562,0.77434,-0.01324>,
              <-0.12658,0.77495,0.01538>,<-0.11309,0.77556,0.0424><-0.16734,0.7974,-0.09405>,<-0.1646,0.7916,-0.08306>,<-0.15522,0.77761,-0.058>,
              <-0.14166,0.76365,-0.03513>,<-0.13212,0.75791,-0.02772>,<-0.13289,0.76373,-0.03974>,
              <-0.14424,0.77771,-0.06377>,<-0.15976,0.79164,-0.08561><-0.10595,0.71185,0.05088>,<-0.10634,0.71492,0.03854>,<-0.11029,0.72182,0.00941>,
              <-0.11879,0.72795,-0.01873>,<-0.12659,0.72976,-0.02945>,<-0.12833,0.72632,-0.01664>,
              <-0.12224,0.71978,0.01203>,<-0.11161,0.71402,0.0397><-0.16802,0.97945,-0.02646>,<-0.16088,0.97525,-0.0168>,<-0.1422,0.96778,0.00572>,
              <-0.12133,0.96432,0.02704>,<-0.11064,0.96665,0.03473>,<-0.11675,0.97272,0.0245>,
              <-0.13646,0.97831,0.00255>,<-0.15835,0.9799,-0.0182><-0.02096,0.94582,0.0738>,<-0.02577,0.94861,0.06235>,<-0.03882,0.95267,0.03542>,
              <-0.05409,0.95269,0.00957>,<-0.06248,0.94892,-0.00014>,<-0.05872,0.94423,0.01181>,
              <-0.04462,0.94207,0.03824>,<-0.02832,0.94394,0.06359><-0.10592,0.9076,0.03125>,<-0.09484,0.91069,0.02581>,<-0.07009,0.92013,0.01132>,
              <-0.04834,0.93258,-0.00522>,<-0.04216,0.94057,-0.01399>,<-0.05465,0.93889,-0.00951>,
              <-0.07799,0.92804,0.00594>,<-0.09833,0.91417,0.02344><-0.01088,0.9214,0.06146>,<-0.01256,0.92554,0.04955>,<-0.01895,0.93352,0.02113>,
              <-0.0289,0.93842,-0.00678>,<-0.03634,0.93756,-0.01785>,<-0.03633,0.93197,-0.0057>,
              <-0.02827,0.92544,0.02248>,<-0.01666,0.92198,0.05014><-0.07831,0.8875,-0.05996>,<-0.06645,0.88897,-0.05559>,<-0.03814,0.89498,-0.04696>,
              <-0.01032,0.9047,-0.04122>,<0.00076,0.9122,-0.04155>,<-0.01133,0.91246,-0.04727>,
              <-0.03941,0.90472,-0.05455>,<-0.06701,0.89326,-0.05894><0.0143,0.88943,0.03829>,<0.0152,0.89363,0.02631>,<0.01476,0.90203,-0.00269>,
              <0.01038,0.90784,-0.03182>,<0.00487,0.90781,-0.04401>,<0.00211,0.9024,-0.03209>,
              <0.00441,0.89521,-0.00303>,<0.01064,0.89062,0.02617><-0.05595,0.86589,-0.08415>,<-0.0453,0.86747,-0.07737>,<-0.01913,0.8732,-0.06343>,
              <0.00774,0.88182,-0.05317>,<0.01952,0.8881,-0.05236>,<0.0092,0.88788,-0.06086>,
              <-0.0173,0.88079,-0.07307>,<-0.04449,0.87081,-0.08162><-0.0964,1.00045,-0.00343>,<-0.10361,1.00334,0.00665>,<-0.11921,1.01287,0.03069>,
              <-0.13211,1.02623,0.05427>,<-0.13492,1.03538,0.06362>,<-0.12644,1.0343,0.05333>,
              <-0.11211,1.02297,0.0295>,<-0.10048,1.0078,0.00612><-0.17197,1.00166,0.01002>,<-0.16724,1.00937,0.01896>,<-0.15423,1.02534,0.04105>,
              <-0.13884,1.03731,0.06389>,<-0.13023,1.0385,0.07406>,<-0.13385,1.0289,0.06547>,
              <-0.14798,1.01481,0.04303>,<-0.16448,1.00473,0.01984><-0.05709,1.03904,0.04112>,<-0.06602,1.03729,0.05001>,<-0.08775,1.03616,0.07095>,
              <-0.10974,1.03967,0.09109>,<-0.11909,1.04549,0.09869>,<-0.11028,1.04942,0.08942>,
              <-0.08842,1.04837,0.06886>,<-0.06631,1.04268,0.04909><-0.16211,1.01561,0.14952>,<-0.15229,1.02332,0.15197>,<-0.12718,1.03919,0.15744>,
              <-0.09996,1.05088,0.16228>,<-0.08669,1.05181,0.16368>,<-0.09551,1.04214,0.16094>,
              <-0.12161,1.02823,0.15576>,<-0.14984,1.01849,0.15123><-0.009,1.03682,0.13144>,<-0.02022,1.03623,0.1374>,<-0.04669,1.03786,0.15186>,
              <-0.07221,1.04412,0.16639>,<-0.08189,1.05106,0.17247>,<-0.07023,1.05383,0.16654>,
              <-0.04421,1.05002,0.15205>,<-0.01913,1.04158,0.13749><-0.14103,1.00026,0.1845>,<-0.1324,1.0094,0.18649>,<-0.10985,1.02917,0.19>,
              <-0.08471,1.0455,0.1916>,<-0.07185,1.04903,0.19045>,<-0.07927,1.03828,0.18756>,
              <-0.10304,1.02012,0.18495>,<-0.1294,1.00541,0.18426><0.02988,1.03356,0.1901>,<0.01797,1.03114,0.19387>,<-0.01033,1.02822,0.20401>,
              <-0.03795,1.02972,0.21569>,<-0.04875,1.03448,0.22198>,<-0.03653,1.03897,0.21892>,
              <-0.00855,1.03982,0.20806>,<0.01875,1.03625,0.19566><-0.11134,1.04689,0.08646>,<-0.12009,1.05172,0.0786>,<-0.14101,1.06561,0.06181>,
              <-0.16159,1.08283,0.04834>,<-0.16981,1.09309,0.04588>,<-0.1609,1.08983,0.05531>,
              <-0.14014,1.07438,0.07054>,<-0.11971,1.05559,0.08244><-0.16994,1.05526,0.10868>,<-0.17171,1.06423,0.09984>,<-0.1769,1.0833,0.077>,
              <-0.18346,1.09844,0.05191>,<-0.18747,1.10104,0.03942>,<-0.18634,1.09022,0.04721>,
              <-0.18051,1.073,0.0711>,<-0.1733,1.05969,0.09724><-0.28206,1.0645,0.03847>,<-0.27021,1.06902,0.03747>,<-0.24334,1.08255,0.03485>,
              <-0.21907,1.09999,0.03196>,<-0.21147,1.1109,0.03049>,<-0.22455,1.10822,0.03136>,
              <-0.2502,1.09285,0.03411>,<-0.27324,1.07357,0.03714><-0.19072,1.08938,0.08053>,<-0.19775,1.09651,0.07267>,<-0.21501,1.11086,0.05246>,
              <-0.2327,1.1209,0.03038>,<-0.24043,1.12101,0.01946>,<-0.23361,1.11186,0.02644>,
              <-0.21615,1.09953,0.04753>,<-0.19825,1.09152,0.07049><-0.32989,1.08154,-0.00214>,<-0.31807,1.08538,0.00061>,<-0.29098,1.09733,0.00654>,
              <-0.26605,1.11335,0.01141>,<-0.25776,1.12379,0.01243>,<-0.27059,1.12186,0.00918>,
              <-0.29667,1.108,0.00374>,<-0.32058,1.09008,-0.00063><-0.23064,1.06849,0.04738>,<-0.23607,1.0788,0.04227>,<-0.25075,1.10135,0.02856>,
              <-0.2678,1.12037,0.01278>,<-0.27709,1.12495,0.00431>,<-0.27277,1.11298,0.00845>,
              <-0.25698,1.09209,0.02313>,<-0.23882,1.07471,0.03988><-0.32515,1.06007,0.04644>,<-0.32229,1.06735,0.03639>,<-0.31611,1.08703,0.01434>,
              <-0.31101,1.10991,-0.00442>,<-0.30992,1.12239,-0.0091>,<-0.31329,1.11662,0.00249>,
              <-0.31896,1.09544,0.023>,<-0.32354,1.07106,0.04021><-0.07885,0.20873,-0.10645>,<-0.0802,0.20928,-0.09381>,<-0.08382,0.2136,-0.06414>,
              <-0.08801,0.22243,-0.03575>,<-0.09028,0.23032,-0.02519>,<-0.08919,0.23189,-0.03843>,
              <-0.0853,0.22545,-0.06749>,<-0.08085,0.2145,-0.09529><-0.1986,0.19067,-0.02623>,<-0.19202,0.20056,-0.02167>,<-0.17386,0.22259,-0.01182>,
              <-0.1523,0.24186,-0.00372>,<-0.14018,0.24724,-0.00202>,<-0.14516,0.23606,-0.00741>,
              <-0.16492,0.21533,-0.01643>,<-0.18808,0.19736,-0.0237><-0.15031,0.23394,0.08575>,<-0.15973,0.23597,0.07744>,<-0.18155,0.24378,0.05807>,
              <-0.20196,0.25598,0.03974>,<-0.20909,0.26515,0.03311>,<-0.19901,0.26518,0.0419>,
              <-0.17785,0.25531,0.06079>,<-0.1581,0.24105,0.07864><-0.30953,0.21964,0.01613>,<-0.30749,0.22936,0.02407>,<-0.30185,0.25037,0.04502>,
              <-0.29515,0.26764,0.06865>,<-0.29138,0.27128,0.08096>,<-0.29292,0.2598,0.07428>,
              <-0.29906,0.24055,0.05207>,<-0.30626,0.22503,0.02718><-0.44853,0.2501,0.15771>,<-0.43624,0.24814,0.15505>,<-0.40693,0.24643,0.14797>,
              <-0.37816,0.24931,0.13989>,<-0.36674,0.25481,0.1356>,<-0.37928,0.25892,0.13778>,
              <-0.40834,0.25847,0.14533>,<-0.43686,0.25344,0.15389><-0.09599,0.23788,-0.04725>,<-0.09283,0.24599,-0.05653>,<-0.088,0.26663,-0.07804>,
              <-0.08739,0.28888,-0.09819>,<-0.09111,0.2996,-0.10527>,<-0.09626,0.29225,-0.09536>,
              <-0.09911,0.27085,-0.07448>,<-0.09773,0.24785,-0.05496><-0.01745,0.29379,-0.15494>,<-0.02732,0.30115,-0.15815>,<-0.05219,0.31604,-0.16664>,
              <-0.0786,0.32662,-0.17624>,<-0.09099,0.32694,-0.18126>,<-0.08185,0.31756,-0.17857>,
              <-0.05626,0.30469,-0.16956>,<-0.02912,0.29614,-0.15944><-0.11325,0.26405,-0.2267>,<-0.10684,0.27471,-0.22938>,<-0.09434,0.30145,-0.23575>,
              <-0.0863,0.3297,-0.24197>,<-0.08716,0.34282,-0.24441>,<-0.09567,0.33288,-0.24166>,
              <-0.10608,0.30543,-0.23536>,<-0.11202,0.27646,-0.22921><0.00559,0.32765,-0.30452>,<-0.00562,0.33359,-0.3055>,<-0.03347,0.34492,-0.30834>,
              <-0.0625,0.35173,-0.31186>,<-0.07563,0.35031,-0.31397>,<-0.06498,0.34225,-0.31331>,
              <-0.03657,0.33304,-0.31016>,<-0.00699,0.32835,-0.30631><-0.12682,0.28479,-0.35255>,<-0.11631,0.29184,-0.3513>,<-0.09315,0.31103,-0.34855>,
              <-0.07337,0.3335,-0.34617>,<-0.06835,0.34588,-0.34555>,<-0.08046,0.34037,-0.34697>,
              <-0.10203,0.31964,-0.34955>,<-0.12022,0.29564,-0.35174><-0.13949,0.32781,-0.04569>,<-0.12703,0.3271,-0.04317>,<-0.09726,0.32829,-0.03824>,
              <-0.06793,0.33384,-0.03506>,<-0.05618,0.34024,-0.03538>,<-0.06884,0.343,-0.03872>,
              <-0.09841,0.33976,-0.04283>,<-0.12754,0.33216,-0.04519><-0.07182,0.33037,0.05>,<-0.06543,0.33419,0.03968>,<-0.05098,0.34055,0.01394>,
              <-0.03795,0.34259,-0.01304>,<-0.0339,0.33937,-0.02538>,<-0.04096,0.33352,-0.01564>,
              <-0.05474,0.32919,0.01068>,<-0.06709,0.32918,0.03824><0.05865,0.27664,-0.04596>,<0.06041,0.28005,-0.03383>,<0.0662,0.29053,-0.00611>,
              <0.07427,0.30441,0.01927>,<0.07976,0.31334,0.02757>,<0.07908,0.31152,0.01433>,
              <0.07222,0.29944,-0.01229>,<0.06307,0.28398,-0.03656><0.08041,0.22895,0.09189>,<0.08972,0.23709,0.0889>,<0.11195,0.25502,0.07908>,
              <0.13382,0.27034,0.06535>,<0.14255,0.27423,0.05599>,<0.13307,0.26486,0.05714>,
              <0.11101,0.24815,0.06879>,<0.08931,0.23406,0.08436><0.18047,0.18484,0.00747>,<0.17827,0.19137,0.01817>,<0.17498,0.20899,0.04248>,
              <0.17473,0.22941,0.06449>,<0.17747,0.24049,0.07146>,<0.18109,0.23528,0.05968>,
              <0.18295,0.21634,0.03645>,<0.18179,0.19461,0.01552><-0.14464,0.42024,-0.0797>,<-0.14529,0.40777,-0.07724>,<-0.14599,0.37887,-0.06853>,
              <-0.14539,0.35175,-0.05565>,<-0.14393,0.3422,-0.0464>,<-0.14268,0.35551,-0.0469>,
              <-0.14259,0.38357,-0.05757>,<-0.14379,0.40985,-0.07241><-0.17426,0.38404,-0.07549>,<-0.17296,0.37357,-0.06837>,<-0.16699,0.34858,-0.0525>,
              <-0.15675,0.324,-0.03861>,<-0.14851,0.31422,-0.03472>,<-0.14781,0.32488,-0.04277>,
              <-0.15578,0.34967,-0.05771>,<-0.16802,0.37405,-0.07067><-0.10517,0.26529,0.03403>,<-0.10904,0.25516,0.02738>,<-0.12066,0.23103,0.01342>,
              <-0.13575,0.20742,0.00263>,<-0.14526,0.19813,0.00113>,<-0.14302,0.20851,0.00927>,
              <-0.12977,0.23239,0.02174>,<-0.11305,0.25576,0.03105><-0.08796,0.19537,-0.05557>,<-0.09767,0.19143,-0.04835>,<-0.11891,0.18256,-0.02879>,
              <-0.13683,0.17467,-0.00603>,<-0.14113,0.17232,0.00641>,<-0.12986,0.17672,0.00071>,
              <-0.11019,0.18513,-0.02036>,<-0.09383,0.19256,-0.04463><-0.14943,0.10934,0.0885>,<-0.14116,0.10528,0.07972>,<-0.12393,0.09538,0.05697>,
              <-0.11081,0.08535,0.0319>,<-0.10923,0.08107,0.01933>,<-0.11942,0.08506,0.02701>,
              <-0.13472,0.09502,0.05085>,<-0.14592,0.10512,0.07702><-0.16036,0.38561,-0.06157>,<-0.15549,0.39555,-0.06785>,<-0.14584,0.42088,-0.08116>,
              <-0.13939,0.44827,-0.09165>,<-0.13972,0.46153,-0.09336>,<-0.14609,0.45255,-0.08576>,
              <-0.15424,0.42626,-0.07378>,<-0.15919,0.39791,-0.0646><-0.06999,0.46548,-0.1455>,<-0.07857,0.47471,-0.14377>,<-0.10092,0.49486,-0.14121>,
              <-0.12571,0.5118,-0.14111>,<-0.13827,0.5158,-0.14336>,<-0.13084,0.50506,-0.14624>,
              <-0.10734,0.48642,-0.14764>,<-0.08141,0.47099,-0.1466><-0.18495,0.47655,-0.18915>,<-0.17588,0.48542,-0.18828>,<-0.15633,0.50814,-0.18455>,
              <-0.14034,0.5328,-0.1784>,<-0.13706,0.54484,-0.17359>,<-0.1478,0.53687,-0.17333>,
              <-0.16568,0.51325,-0.17819>,<-0.18,0.48768,-0.18547><-0.06784,0.54267,-0.27641>,<-0.07564,0.55122,-0.27114>,<-0.09648,0.56971,-0.25948>,
              <-0.12033,0.58493,-0.24942>,<-0.13304,0.58816,-0.24677>,<-0.12664,0.57808,-0.25279>,
              <-0.10439,0.56113,-0.2637>,<-0.07913,0.54744,-0.273><-0.21082,0.5986,-0.34189>,<-0.19818,0.59811,-0.34056>,<-0.16832,0.59983,-0.33636>,
              <-0.13947,0.60592,-0.33065>,<-0.12847,0.61253,-0.32688>,<-0.14159,0.61506,-0.32751>,
              <-0.17098,0.61129,-0.33242>,<-0.19935,0.60316,-0.33882><-0.18739,0.53416,-0.06222>,<-0.17953,0.52421,-0.06111>,<-0.15903,0.50205,-0.06043>,
              <-0.13621,0.48267,-0.06278>,<-0.12459,0.47726,-0.0666>,<-0.13136,0.48852,-0.06913>,
              <-0.15295,0.50937,-0.06839>,<-0.17685,0.52744,-0.06461><-0.12325,0.50196,0.00514>,<-0.11799,0.49615,-0.00488>,<-0.10742,0.48001,-0.02811>,
              <-0.10005,0.46071,-0.0499>,<-0.09999,0.44975,-0.05757>,<-0.10674,0.45408,-0.04686>,
              <-0.11581,0.4717,-0.02431>,<-0.12169,0.49248,-0.0032><-0.14235,0.45315,-0.05952>,<-0.1331,0.44531,-0.05567>,<-0.10938,0.42797,-0.04871>,
              <-0.08358,0.41301,-0.04524>,<-0.07093,0.40905,-0.04709>,<-0.07921,0.41802,-0.05258>,
              <-0.10391,0.43424,-0.0579>,<-0.13069,0.44808,-0.05973><-0.0514,0.43237,0.02514>,<-0.04857,0.42508,0.01511>,<-0.04468,0.40659,-0.00845>,
              <-0.04521,0.3868,-0.03102>,<-0.04958,0.37737,-0.03944>,<-0.05449,0.38405,-0.02895>,
              <-0.05631,0.40315,-0.00585>,<-0.0537,0.42356,0.01626><-0.10597,0.30451,-0.05506>,<-0.09488,0.30196,-0.04935>,<-0.0673,0.29599,-0.03859>,
              <-0.03849,0.29026,-0.03238>,<-0.0254,0.28812,-0.03408>,<-0.0359,0.29078,-0.04192>,
              <-0.06406,0.29664,-0.05054>,<-0.09345,0.30225,-0.05462><-0.07189,0.26162,0.03698>,<-0.06255,0.26154,0.02834>,<-0.04257,0.26111,0.00571>,
              <-0.02645,0.26033,-0.01962>,<-0.0234,0.25967,-0.03263>,<-0.03456,0.25959,-0.02525>,
              <-0.05273,0.26019,-0.00135>,<-0.06703,0.26113,0.02523><-0.18638,0.58253,-0.10696>,<-0.18375,0.57167,-0.10088>,<-0.17523,0.54741,-0.08504>,
              <-0.16346,0.5261,-0.06746>,<-0.15554,0.52004,-0.05855>,<-0.15665,0.53229,-0.06381>,
              <-0.16669,0.55517,-0.08047>,<-0.17998,0.57509,-0.09886><-0.24089,0.49772,0.00144>,<-0.22959,0.49193,0.00222>,<-0.20347,0.47679,0.00145>,
              <-0.17911,0.45989,-0.00333>,<-0.17068,0.45124,-0.00908>,<-0.18281,0.45621,-0.01175>,
              <-0.2081,0.47217,-0.00909>,<-0.23163,0.4899,-0.00242><-0.18296,0.49902,-0.06461>,<-0.18351,0.48912,-0.05664>,<-0.18248,0.4669,-0.03621>,
              <-0.17788,0.44721,-0.01401>,<-0.17263,0.44144,-0.00315>,<-0.1704,0.45253,-0.01029>,
              <-0.1731,0.47356,-0.03155>,<-0.17938,0.49206,-0.05458><-0.19759,0.35224,-0.04346>,<-0.19807,0.35201,-0.03075>,<-0.19629,0.35055,-0.00064>,
              <-0.19008,0.34769,0.0286>,<-0.18336,0.3452,0.03989>,<-0.1808,0.34478,0.02677>,
              <-0.18466,0.3469,-0.00293>,<-0.19294,0.35041,-0.03176><-0.10387,0.3594,0.0471>,<-0.1152,0.35472,0.0437>,<-0.14285,0.34369,0.0386>,
              <-0.17092,0.33304,0.03819>,<-0.18295,0.32899,0.04242>,<-0.17181,0.33385,0.04802>,
              <-0.14397,0.34471,0.05092>,<-0.1157,0.35517,0.04913><-0.17619,0.60174,-0.02491>,<-0.17397,0.59999,-0.03732>,<-0.17027,0.59841,-0.06725>,
              <-0.16907,0.60084,-0.09715>,<-0.17092,0.60561,-0.10951>,<-0.17431,0.60925,-0.09709>,
              <-0.17684,0.60894,-0.06718>,<-0.17687,0.60463,-0.03728><-0.10796,0.59046,-0.08374>,<-0.11652,0.59451,-0.09223>,<-0.1385,0.60166,-0.11167>,
              <-0.16246,0.60484,-0.12948>,<-0.17425,0.60244,-0.13533>,<-0.16662,0.59653,-0.12607>,
              <-0.14371,0.59125,-0.10739>,<-0.11882,0.58992,-0.09035><-0.20325,0.58838,-0.07912>,<-0.19794,0.58752,-0.09065>,<-0.18679,0.5881,-0.11871>,
              <-0.17814,0.59266,-0.1471>,<-0.1769,0.5983,-0.15917>,<-0.18338,0.60104,-0.14779>,
              <-0.19336,0.59859,-0.11958>,<-0.20084,0.59215,-0.09103><-0.10722,0.55927,-0.20743>,<-0.11736,0.56345,-0.21389>,<-0.14297,0.57103,-0.22798>,
              <-0.1703,0.57485,-0.2398>,<-0.18325,0.57291,-0.24257>,<-0.17392,0.56697,-0.23504>,
              <-0.1475,0.56115,-0.22201>,<-0.11935,0.55909,-0.21126><-0.23624,0.53909,-0.19488>,<-0.22679,0.54102,-0.20318>,<-0.20598,0.54799,-0.22391>,
              <-0.18816,0.55846,-0.2457>,<-0.1836,0.56607,-0.25571>,<-0.19446,0.56578,-0.2479>,
              <-0.21386,0.55716,-0.22667>,<-0.23027,0.54506,-0.20439><-0.09968,0.50919,-0.29889>,<-0.11109,0.51309,-0.30298>,<-0.13937,0.52024,-0.31079>,
              <-0.16878,0.524,-0.31551>,<-0.18202,0.52238,-0.31457>,<-0.17115,0.5169,-0.30903>,
              <-0.14234,0.51134,-0.30267>,<-0.1124,0.50917,-0.2994><-0.21958,0.69948,-0.0551>,<-0.21113,0.68996,-0.05515>,<-0.18959,0.66892,-0.05744>,
              <-0.16632,0.65079,-0.06302>,<-0.15505,0.64601,-0.06842>,<-0.16268,0.6569,-0.06991>,
              <-0.18503,0.67657,-0.06607>,<-0.20912,0.69334,-0.05895><-0.17023,0.69263,-0.00396>,<-0.1653,0.68677,-0.01412>,<-0.15556,0.67055,-0.03766>,
              <-0.14906,0.65124,-0.05972>,<-0.14941,0.64034,-0.06746>,<-0.15586,0.64476,-0.05661>,
              <-0.16408,0.66242,-0.03377>,<-0.16906,0.68318,-0.0124><-0.17791,0.61689,-0.05665>,<-0.16691,0.61064,-0.05525>,<-0.13986,0.59724,-0.05447>,
              <-0.11206,0.58635,-0.05762>,<-0.09983,0.5842,-0.06261>,<-0.11048,0.59163,-0.06585>,
              <-0.13788,0.60385,-0.06479>,<-0.16604,0.61356,-0.0598><-0.11365,0.5979,0.01134>,<-0.10689,0.59384,0.00136>,<-0.09348,0.58333,-0.02358>,
              <-0.0845,0.57176,-0.04979>,<-0.08493,0.56598,-0.06184>,<-0.09377,0.56954,-0.05246>,
              <-0.1051,0.58055,-0.02693>,<-0.11201,0.59262,-0.00012><-0.13759,0.52786,-0.08491>,<-0.12669,0.52408,-0.07954>,<-0.0994,0.51629,-0.06922>,
              <-0.07062,0.51054,-0.0629>,<-0.0573,0.51006,-0.06402>,<-0.06749,0.5148,-0.07127>,
              <-0.09549,0.52163,-0.07972>,<-0.12497,0.52643,-0.08417><-0.05473,0.42787,0.01074>,<-0.0504,0.43176,-0.00057>,<-0.04299,0.44078,-0.02843>,
              <-0.0402,0.44922,-0.05711>,<-0.04338,0.45218,-0.06976>,<-0.04988,0.44802,-0.05884>,
              <-0.05512,0.43927,-0.03059>,<-0.05574,0.4311,-0.00153><-0.22794,0.73243,-0.14309>,<-0.2273,0.72819,-0.13111>,<-0.22401,0.72055,-0.10208>,
              <-0.21808,0.71683,-0.07288>,<-0.21315,0.71896,-0.06063>,<-0.21255,0.72503,-0.07253>,
              <-0.21708,0.73083,-0.10164>,<-0.22424,0.73272,-0.13092><-0.32071,0.70019,-0.08422>,<-0.31126,0.70303,-0.0762>,<-0.28705,0.70789,-0.0588>,
              <-0.26078,0.70973,-0.04439>,<-0.24795,0.70766,-0.04122>,<-0.25643,0.70341,-0.05065>,
              <-0.2816,0.69997,-0.06664>,<-0.30885,0.69954,-0.07966><-0.25081,0.71349,-0.11808>,<-0.25356,0.70935,-0.10636>,<-0.25888,0.70214,-0.07752>,
              <-0.26221,0.69913,-0.04784>,<-0.26173,0.70182,-0.03474>,<-0.25806,0.70794,-0.04606>,
              <-0.25367,0.71318,-0.0753>,<-0.25126,0.71422,-0.10538><-0.38054,0.65369,-0.03918>,<-0.37067,0.65978,-0.03393>,<-0.34544,0.67244,-0.0232>,
              <-0.31809,0.68206,-0.01539>,<-0.30477,0.68319,-0.01489>,<-0.31365,0.67568,-0.02151>,
              <-0.33987,0.66444,-0.03087>,<-0.36822,0.65625,-0.03731><-0.27288,0.66899,0.05998>,<-0.28086,0.66511,0.05086>,<-0.30158,0.65828,0.02997>,
              <-0.32448,0.65528,0.01078>,<-0.33601,0.65763,0.00443>,<-0.32905,0.66331,0.01434>,
              <-0.30731,0.66834,0.03443>,<-0.28339,0.66955,0.05282><-0.32588,0.60454,-0.05333>,<-0.33256,0.61043,-0.04424>,<-0.34639,0.62328,-0.02067>,
              <-0.35678,0.63405,0.00536>,<-0.35784,0.63656,0.01846>,<-0.34955,0.62969,0.01053>,
              <-0.33733,0.61782,-0.0142>,<-0.32856,0.60803,-0.04139><-0.45577,0.55777,0.07476>,<-0.44416,0.56137,0.07101>,<-0.41799,0.57196,0.06028>,
              <-0.39463,0.58541,0.04706>,<-0.38758,0.59367,0.03925>,<-0.40051,0.59142,0.04184>,
              <-0.42536,0.57948,0.05373>,<-0.44741,0.56469,0.06812><-0.21345,0.80921,-0.03282>,<-0.2088,0.79909,-0.03896>,<-0.20001,0.77547,-0.05561>,
              <-0.19487,0.75311,-0.07497>,<-0.19616,0.74502,-0.08555>,<-0.20252,0.75573,-0.08068>,
              <-0.2096,0.77876,-0.06276>,<-0.21303,0.80054,-0.04212><-0.1358,0.75055,-0.06809>,<-0.14208,0.74533,-0.07785>,<-0.15785,0.73073,-0.09907>,
              <-0.17451,0.71311,-0.11678>,<-0.18225,0.70298,-0.12081>,<-0.17638,0.70677,-0.10941>,
              <-0.1602,0.72279,-0.08984>,<-0.14312,0.74183,-0.07378><-0.20135,0.67432,-0.07247>,<-0.19421,0.67241,-0.08283>,<-0.17971,0.66878,-0.10907>,
              <-0.1693,0.66663,-0.13715>,<-0.16882,0.66712,-0.15051>,<-0.17788,0.66972,-0.14101>,
              <-0.19046,0.67266,-0.1139>,<-0.19895,0.67412,-0.08496><-0.10745,0.71051,-0.14293>,<-0.11594,0.70241,-0.14786>,<-0.13583,0.68158,-0.15695>,
              <-0.1548,0.65883,-0.16183>,<-0.16181,0.6476,-0.15989>,<-0.1529,0.6548,-0.15298>,
              <-0.13344,0.67653,-0.14587>,<-0.11489,0.70018,-0.14297><-0.18862,0.59954,-0.09921>,<-0.18047,0.60126,-0.10884>,<-0.16359,0.60572,-0.13348>,
              <-0.1509,0.61066,-0.16023>,<-0.14958,0.61316,-0.17331>,<-0.15969,0.61167,-0.16468>,
              <-0.1746,0.60699,-0.13904>,<-0.18533,0.60181,-0.11129><-0.07266,0.6181,-0.1406>,<-0.08142,0.61388,-0.1488>,<-0.10375,0.60278,-0.16583>,
              <-0.12784,0.59031,-0.17871>,<-0.13947,0.58386,-0.18013>,<-0.13154,0.58744,-0.16998>,
              <-0.10838,0.59919,-0.1549>,<-0.08346,0.6123,-0.14398><-0.24539,0.75773,-0.1083>,<-0.23692,0.76386,-0.10106>,<-0.21881,0.7807,-0.08372>,
              <-0.20427,0.80063,-0.0666>,<-0.2016,0.81178,-0.05972>,<-0.21175,0.80711,-0.06707>,
              <-0.22818,0.78881,-0.0843>,<-0.24105,0.76744,-0.10132><-0.20499,0.75209,-0.00484>,<-0.20483,0.76375,-0.00993>,<-0.20321,0.79014,-0.02452>,
              <-0.19974,0.8139,-0.04255>,<-0.19656,0.82126,-0.05325>,<-0.19585,0.80837,-0.04978>,
              <-0.19834,0.78321,-0.03358>,<-0.20269,0.76069,-0.01393><-0.20253,0.82995,-0.09004>,<-0.19592,0.83324,-0.07968>,<-0.18218,0.8434,-0.05479>,
              <-0.17177,0.8569,-0.03007>,<-0.17059,0.86562,-0.01999>,<-0.17877,0.86389,-0.03043>,
              <-0.19095,0.85216,-0.05525>,<-0.19979,0.8371,-0.07989><-0.1368,0.8443,0.0681>,<-0.14027,0.85278,0.05927>,<-0.14801,0.8707,0.03623>,
              <-0.15481,0.88479,0.0106>,<-0.15673,0.88703,-0.00245>,<-0.15282,0.87675,0.00517>,
              <-0.14553,0.86063,0.02942>,<-0.13917,0.84834,0.05627><-0.04057,0.90457,0.01032>,<-0.05252,0.90291,0.01436>,<-0.08152,0.9017,0.02271>,
              <-0.11073,0.90471,0.02897>,<-0.12303,0.90993,0.02958>,<-0.11119,0.91357,0.02456>,
              <-0.08209,0.91279,0.01719>,<-0.05277,0.9078,0.01192><-0.13175,0.86371,0.10586>,<-0.12897,0.87357,0.0983>,<-0.11956,0.89578,0.08013>,
              <-0.10607,0.91561,0.06207>,<-0.09665,0.92158,0.05468>,<-0.09752,0.91061,0.06228>,
              <-0.10885,0.88952,0.0804>,<-0.12425,0.87081,0.09842><0.00566,0.90118,0.08755>,<-0.0069,0.90316,0.08728>,<-0.03613,0.91044,0.08511>,
              <-0.06369,0.9215,0.08066>,<-0.07353,0.92964,0.07668>,<-0.06018,0.92944,0.07588>,
              <-0.03174,0.92038,0.07912>,<-0.00497,0.90754,0.08464><-0.2418,0.82699,-0.14956>,<-0.24582,0.82313,-0.13813>,<-0.25444,0.81667,-0.10991>,
              <-0.26139,0.81454,-0.08078>,<-0.26271,0.81772,-0.06785>,<-0.25791,0.82361,-0.07886>,
              <-0.25007,0.82803,-0.1075>,<-0.2439,0.82813,-0.13707><-0.23309,0.79713,-0.11245>,<-0.244,0.80052,-0.10685>,<-0.26939,0.80632,-0.09156>,
              <-0.29334,0.80852,-0.07358>,<-0.30191,0.80605,-0.06361>,<-0.29032,0.80096,-0.06795>,
              <-0.26561,0.79685,-0.0845>,<-0.24234,0.79635,-0.10374><-0.28804,0.78801,-0.13513>,<-0.29517,0.78703,-0.12464>,<-0.31088,0.78738,-0.09885>,
              <-0.32434,0.79181,-0.07238>,<-0.32778,0.79748,-0.06076>,<-0.31959,0.80038,-0.07093>,
              <-0.30493,0.79811,-0.09704>,<-0.29255,0.79176,-0.12384><-0.43677,0.78785,-0.07957>,<-0.4251,0.78957,-0.0748>,<-0.39656,0.79117,-0.06506>,
              <-0.36747,0.78891,-0.05799>,<-0.3549,0.78436,-0.05757>,<-0.36631,0.78083,-0.06359>,
              <-0.39511,0.78104,-0.07208>,<-0.42446,0.78511,-0.0779><-0.31742,0.75719,0.00841>,<-0.32404,0.75775,-0.00244>,<-0.34129,0.76143,-0.02695>,
              <-0.36043,0.76863,-0.04894>,<-0.37014,0.77491,-0.05567>,<-0.3644,0.776,-0.04364>,
              <-0.34626,0.77066,-0.02031>,<-0.32623,0.76182,0.00049><-0.49664,0.69216,-0.0513>,<-0.48647,0.69934,-0.04868>,<-0.46086,0.71482,-0.04465>,
              <-0.43365,0.72751,-0.04407>,<-0.42088,0.73014,-0.04707>,<-0.4303,0.72164,-0.05131>,
              <-0.45666,0.70747,-0.05372>,<-0.48462,0.6961,-0.05268><-0.25924,0.94085,-0.02484>,<-0.25454,0.93079,-0.03107>,<-0.24489,0.90795,-0.0483>,
              <-0.2378,0.88726,-0.06888>,<-0.23727,0.88071,-0.08053>,<-0.24317,0.89177,-0.07587>,
              <-0.25162,0.9136,-0.05706>,<-0.2575,0.93328,-0.03493><-0.18599,0.90536,-0.04579>,<-0.19118,0.89984,-0.05602>,<-0.20439,0.8845,-0.07842>,
              <-0.21864,0.86609,-0.09739>,<-0.22552,0.8556,-0.10201>,<-0.22083,0.85967,-0.09017>,
              <-0.20713,0.87646,-0.06938>,<-0.19239,0.8963,-0.05203><-0.24574,0.87172,-0.04323>,<-0.23937,0.86598,-0.05263>,<-0.22656,0.85316,-0.07678>,
              <-0.21762,0.84189,-0.10314>,<-0.21755,0.83869,-0.11613>,<-0.22574,0.84516,-0.10776>,
              <-0.23673,0.85725,-0.08258>,<-0.24386,0.86779,-0.05518><-0.15476,0.87575,-0.09444>,<-0.16333,0.86967,-0.10162>,<-0.18337,0.85287,-0.11672>,
              <-0.20246,0.83288,-0.12846>,<-0.20946,0.82161,-0.13018>,<-0.20044,0.82621,-0.12143>,
              <-0.18085,0.8445,-0.10791>,<-0.16222,0.86598,-0.09773><-0.24679,0.79518,-0.08361>,<-0.23717,0.79361,-0.09179>,<-0.21628,0.79072,-0.11341>,
              <-0.19892,0.78921,-0.13786>,<-0.19504,0.78986,-0.15065>,<-0.20631,0.79208,-0.1438>,
              <-0.22554,0.79432,-0.12085>,<-0.24125,0.79519,-0.09507><-0.12075,0.80903,-0.12312>,<-0.12996,0.80483,-0.13083>,<-0.15268,0.793,-0.14683>,
              <-0.1761,0.77863,-0.15893>,<-0.18648,0.7703,-0.16026>,<-0.17761,0.77331,-0.15072>,
              <-0.15456,0.78633,-0.13655>,<-0.13079,0.80189,-0.12629><-0.23039,0.74317,-0.09924>,<-0.22088,0.74497,-0.10749>,<-0.20045,0.7495,-0.12927>,
              <-0.18384,0.75428,-0.15382>,<-0.18053,0.75649,-0.16659>,<-0.19183,0.7548,-0.15963>,
              <-0.21047,0.75016,-0.13656>,<-0.2253,0.74526,-0.11071><-0.32457,0.93352,-0.0493>,<-0.31185,0.93311,-0.04927>,<-0.28174,0.93462,-0.05102>,
              <-0.25252,0.93987,-0.0555>,<-0.24125,0.94556,-0.05992>,<-0.25438,0.94772,-0.06123>,
              <-0.28408,0.94446,-0.0582>,<-0.31288,0.93745,-0.05244><-0.27084,0.91965,0.01525>,<-0.26254,0.92517,0.00734>,<-0.24395,0.93645,-0.01362>,
              <-0.22755,0.94463,-0.0374>,<-0.2228,0.94512,-0.0499>,<-0.23213,0.93814,-0.04332>,
              <-0.24969,0.92832,-0.02103>,<-0.26507,0.92159,0.00407><-0.29226,0.92531,-0.04758>,<-0.27972,0.92583,-0.04552>,<-0.24996,0.92975,-0.04213>,
              <-0.22102,0.93767,-0.04111>,<-0.20978,0.9447,-0.04292>,<-0.22271,0.94606,-0.04609>,
              <-0.25208,0.94026,-0.04836>,<-0.28065,0.93047,-0.04827><-0.20524,0.90189,0.04138>,<-0.20075,0.90976,0.03245>,<-0.19131,0.92653,0.00917>,
              <-0.18401,0.93997,-0.01667>,<-0.18299,0.9424,-0.02978>,<-0.18848,0.93296,-0.02205>,
              <-0.19691,0.91776,0.00243>,<-0.20322,0.90589,0.02947><-0.2131,0.93124,-0.04984>,<-0.20265,0.92877,-0.04302>,<-0.17689,0.92573,-0.02755>,
              <-0.15037,0.92711,-0.01354>,<-0.13866,0.93184,-0.00912>,<-0.14876,0.93639,-0.01662>,
              <-0.17487,0.93735,-0.03141>,<-0.20176,0.93389,-0.04472><-0.19098,0.88635,-0.00013>,<-0.18085,0.89393,0.0012>,<-0.15513,0.90963,0.00319>,
              <-0.12751,0.92141,0.00335>,<-0.11429,0.92261,0.0017>,<-0.12353,0.91319,-0.00048>,
              <-0.15015,0.89934,-0.00162>,<-0.17865,0.88939,-0.00092><-0.01799,0.86198,-0.02879>,<-0.02883,0.86504,-0.02287>,<-0.05311,0.87485,-0.00783>,
              <-0.07458,0.88827,0.00832>,<-0.08082,0.89723,0.01604>,<-0.06866,0.89587,0.01063>,
              <-0.0457,0.88436,-0.00493>,<-0.02556,0.86924,-0.02159><-0.31886,1.02523,-0.12859>,<-0.31675,1.01802,-0.11832>,<-0.30955,1.0029,-0.09319>,
              <-0.29917,0.99123,-0.06755>,<-0.29188,0.98963,-0.05645>,<-0.29249,0.99846,-0.06648>,
              <-0.30119,1.01196,-0.09185>,<-0.31306,1.02202,-0.11773><-0.37891,1.00213,-0.07841>,<-0.36866,1.00013,-0.07114>,<-0.34322,0.9937,-0.05619>,
              <-0.31671,0.98489,-0.04518>,<-0.30474,0.979,-0.04431>,<-0.31449,0.97988,-0.05342>,
              <-0.34043,0.98742,-0.06652>,<-0.36743,0.99736,-0.07569><-0.31857,1.01016,-0.1109>,<-0.31905,1.0022,-0.10098>,<-0.31885,0.98555,-0.07579>,
              <-0.3166,0.97271,-0.04874>,<-0.31374,0.97098,-0.03578>,<-0.3123,0.98073,-0.04483>,
              <-0.31346,0.99559,-0.07089>,<-0.31667,1.00663,-0.09882><-0.40927,0.97726,-0.02748>,<-0.3968,0.97647,-0.02507>,<-0.36713,0.97229,-0.02134>,
              <-0.3381,0.96464,-0.02077>,<-0.32668,0.95823,-0.02349>,<-0.33945,0.95739,-0.02737>,
              <-0.36882,0.9632,-0.02962>,<-0.39755,0.97247,-0.02872><-0.27817,0.96098,0.03302>,<-0.28697,0.95435,0.02666>,<-0.30997,0.9402,0.01313>,
              <-0.33559,0.92885,0.00235>,<-0.34867,0.92678,0.00045>,<-0.3411,0.93473,0.0081>,
              <-0.31687,0.94756,0.02034>,<-0.29001,0.95759,0.02984><-0.31501,0.89606,-0.06498>,<-0.32299,0.89946,-0.05567>,<-0.33971,0.90677,-0.03161>,
              <-0.35258,0.91276,-0.00515>,<-0.3543,0.91399,0.00806>,<-0.34451,0.90997,-0.00012>,
              <-0.3296,0.90328,-0.02531>,<-0.31854,0.89792,-0.0529><-0.42095,0.89448,0.08397>,<-0.41073,0.89119,0.07715>,<-0.38796,0.88443,0.05849>,
              <-0.36808,0.87946,0.03655>,<-0.36255,0.87907,0.02437>,<-0.37413,0.88319,0.02966>,
              <-0.39554,0.88911,0.04986>,<-0.41407,0.89325,0.07334><-0.35542,0.80894,-0.03617>,<-0.35946,0.81645,-0.02672>,<-0.36627,0.83394,-0.00307>,
              <-0.36864,0.8505,0.02187>,<-0.36545,0.85647,0.0334>,<-0.35932,0.84852,0.02456>,
              <-0.35459,0.83146,0.00031>,<-0.35431,0.81535,-0.02524><-0.30785,1.01145,-0.02493>,<-0.30458,1.01766,-0.03554>,<-0.29823,1.03484,-0.05955>,
              <-0.29422,1.05533,-0.08113>,<-0.29476,1.06692,-0.08779>,<-0.29913,1.06226,-0.07604>,
              <-0.30438,1.04353,-0.05317>,<-0.30729,1.02149,-0.03273><-0.21789,1.05327,-0.1229>,<-0.22792,1.061,-0.1242>,<-0.25335,1.07684,-0.12799>,
              <-0.28063,1.08845,-0.13274>,<-0.29367,1.08928,-0.13563>,<-0.28451,1.07957,-0.13479>,
              <-0.25821,1.06571,-0.13055>,<-0.23006,1.05609,-0.12533><-0.33415,1.02633,-0.13553>,<-0.32604,1.03518,-0.13974>,<-0.30872,1.05827,-0.14863>,
              <-0.29482,1.08396,-0.15556>,<-0.29227,1.09705,-0.1566>,<-0.30199,1.08943,-0.15146>,
              <-0.3177,1.06511,-0.1435>,<-0.33,1.03819,-0.13748><-0.20705,1.08816,-0.16158>,<-0.21894,1.09259,-0.16256>,<-0.24803,1.10021,-0.16538>,
              <-0.2777,1.10319,-0.16888>,<-0.29054,1.10007,-0.17097>,<-0.27893,1.09347,-0.1703>,
              <-0.24956,1.08803,-0.16716>,<-0.21962,1.08722,-0.16335><-0.35243,1.05138,-0.18175>,<-0.34134,1.057,-0.1845>,<-0.31636,1.07297,-0.19022>,
              <-0.29404,1.09259,-0.19454>,<-0.2873,1.10413,-0.19502>,<-0.29963,1.10022,-0.19162>,
              <-0.32336,1.08254,-0.18655>,<-0.34443,1.06122,-0.18288><-0.20068,1.08758,-0.22661>,<-0.21224,1.09285,-0.22591>,<-0.24079,1.10251,-0.22399>,
              <-0.27031,1.10756,-0.22173>,<-0.28344,1.10532,-0.22048>,<-0.27233,1.09789,-0.22103>,
              <-0.24333,1.09039,-0.22311>,<-0.21336,1.08751,-0.22552><-0.34247,1.04752,-0.25293>,<-0.33144,1.05377,-0.25182>,<-0.30694,1.07113,-0.24863>,
              <-0.28561,1.09189,-0.24467>,<-0.27976,1.10369,-0.24232>,<-0.29228,1.09903,-0.24308>,
              <-0.31529,1.08008,-0.24663>,<-0.33513,1.05772,-0.25094><-0.0228,0.28006,-0.08567>,<-0.0239,0.26775,-0.08262>,<-0.02728,0.23948,-0.07255>,
              <-0.03172,0.21336,-0.05842>,<-0.03458,0.20456,-0.04876>,<-0.03398,0.21788,-0.0499>,
              <-0.0301,0.24514,-0.06188>,<-0.02515,0.27025,-0.07791><-0.03102,0.18172,-0.06985>,<-0.03941,0.17318,-0.06553>,<-0.05716,0.15205,-0.05327>,
              <-0.07115,0.13011,-0.03829>,<-0.0734,0.12026,-0.02952>,<-0.06325,0.12841,-0.03257>,
              <-0.04726,0.14993,-0.0461>,<-0.03504,0.17225,-0.06237><-0.06065,0.11332,-0.03297>,<-0.06704,0.10235,-0.03212>,<-0.08162,0.07638,-0.02708>,
              <-0.0949,0.05119,-0.01758>,<-0.09919,0.04148,-0.00944>,<-0.09219,0.05281,-0.00819>,
              <-0.07822,0.07841,-0.01533>,<-0.06554,0.10324,-0.02693><-0.03587,-0.0264,-0.034>,<-0.04742,-0.02922,-0.02947>,<-0.07381,-0.03502,-0.01598>,
              <-0.09794,-0.03931,0.00137>,<-0.10581,-0.03967,0.01217>,<-0.0932,-0.03613,0.00946>,
              <-0.06787,-0.03104,-0.00584>,<-0.04481,-0.02746,-0.025><-0.16955,-0.06508,0.05627>,<-0.15767,-0.06949,0.05509>,<-0.13019,-0.08064,0.04936>,
              <-0.10451,-0.09252,0.03932>,<-0.09555,-0.09813,0.03113>,<-0.10827,-0.09406,0.03029>,
              <-0.1349,-0.08257,0.03804>,<-0.15975,-0.07034,0.0501><-0.07833,0.28432,-0.05928>,<-0.06651,0.28378,-0.06397>,<-0.03924,0.28485,-0.07691>,
              <-0.01387,0.28949,-0.09227>,<-0.00513,0.29477,-0.10091>,<-0.01784,0.297,-0.09736>,
              <-0.04422,0.29425,-0.08329>,<-0.0687,0.28793,-0.06679><0.09345,0.27467,-0.07677>,<0.09384,0.27889,-0.08876>,<0.09397,0.2861,-0.11809>,
              <0.09285,0.28879,-0.14797>,<0.09121,0.28566,-0.16087>,<0.09023,0.27932,-0.14914>,
              <0.09069,0.27423,-0.11955>,<0.0924,0.27366,-0.08941><0.10373,0.20813,-0.21636>,<0.11395,0.21429,-0.21194>,<0.13775,0.23095,-0.20371>,
              <0.16028,0.25027,-0.19915>,<0.1684,0.26079,-0.20071>,<0.15758,0.25588,-0.20685>,
              <0.13438,0.23797,-0.21336>,<0.11246,0.21739,-0.2162><0.26293,0.21591,-0.1447>,<0.26125,0.21799,-0.15714>,<0.25539,0.22052,-0.18665>,
              <0.24682,0.21926,-0.2154>,<0.24072,0.21519,-0.22659>,<0.24112,0.21132,-0.21379>,
              <0.24826,0.21057,-0.18463>,<0.25811,0.21361,-0.15624><-0.08543,0.32475,-0.14441>,<-0.07947,0.32755,-0.13352>,<-0.06492,0.337,-0.1088>,
              <-0.05012,0.35053,-0.08645>,<-0.04377,0.35997,-0.07941>,<-0.04962,0.35909,-0.09141>,
              <-0.06428,0.34772,-0.11502>,<-0.07919,0.33227,-0.13626><-0.112,0.3265,-0.01826>,<-0.10307,0.33547,-0.01967>,<-0.08034,0.3547,-0.02469>,
              <-0.05581,0.37032,-0.03216>,<-0.04396,0.3734,-0.03755>,<-0.05204,0.36274,-0.03729>,
              <-0.07561,0.3452,-0.03112>,<-0.10099,0.33128,-0.0225><0.02363,0.34692,0.01426>,<0.01179,0.35116,0.01621>,<-0.01512,0.36404,0.02091>,
              <-0.0395,0.38091,0.02561>,<-0.04724,0.39165,0.02756>,<-0.03422,0.38929,0.02561>,
              <-0.0085,0.37453,0.0209>,<0.01471,0.35578,0.0162><-0.13026,0.37201,0.14012>,<-0.11993,0.37901,0.14262>,<-0.09391,0.39299,0.1489>,
              <-0.06624,0.40256,0.15557>,<-0.05324,0.40238,0.15869>,<-0.06279,0.39331,0.15638>,
              <-0.08959,0.3814,0.14991>,<-0.11803,0.3739,0.14307><0.0251,0.35807,0.20527>,<0.0126,0.36035,0.20467>,<-0.01642,0.36869,0.20382>,
              <-0.04366,0.38131,0.20389>,<-0.05329,0.39055,0.20479>,<-0.03995,0.39028,0.20583>,
              <-0.01177,0.37993,0.20625>,<0.01464,0.3653,0.20574><-0.05622,0.33676,-0.06085>,<-0.05507,0.34392,-0.0713>,<-0.05353,0.36323,-0.09447>,
              <-0.05388,0.38555,-0.11455>,<-0.0558,0.39764,-0.11996>,<-0.05784,0.39189,-0.10805>,
              <-0.05849,0.37117,-0.08633>,<-0.05725,0.34742,-0.06771><-0.03682,0.36449,-0.16197>,<-0.04148,0.37632,-0.16231>,<-0.05533,0.40315,-0.16275>,
              <-0.07307,0.42738,-0.16261>,<-0.08407,0.43496,-0.16201>,<-0.08123,0.42191,-0.16139>,
              <-0.06556,0.3963,-0.16123>,<-0.04599,0.3733,-0.16164><-0.17678,0.42096,-0.19088>,<-0.16829,0.42792,-0.19731>,<-0.14884,0.44675,-0.2107>,
              <-0.13098,0.46864,-0.22086>,<-0.12507,0.48058,-0.22204>,<-0.13431,0.47506,-0.2141>,
              <-0.15301,0.45479,-0.20223>,<-0.17013,0.43146,-0.19357><-0.11431,0.44739,-0.31936>,<-0.11952,0.45743,-0.31353>,<-0.13426,0.47942,-0.29899>,
              <-0.15224,0.49804,-0.28378>,<-0.16272,0.5026,-0.27684>,<-0.15903,0.49098,-0.28235>,
              <-0.14278,0.47057,-0.29721>,<-0.12328,0.45353,-0.31274><-0.26426,0.46165,-0.29935>,<-0.25389,0.46644,-0.30495>,<-0.23017,0.48054,-0.31722>,
              <-0.20844,0.49847,-0.32761>,<-0.20131,0.50951,-0.33013>,<-0.21262,0.50652,-0.32364>,
              <-0.23541,0.49062,-0.31225>,<-0.2562,0.47089,-0.30276><-0.16269,0.47747,-0.40814>,<-0.16968,0.48463,-0.40027>,<-0.18768,0.49902,-0.38076>,
              <-0.2074,0.50909,-0.36048>,<-0.21718,0.50919,-0.35135>,<-0.21099,0.5,-0.35885>,
              <-0.19218,0.48764,-0.37872>,<-0.17166,0.47961,-0.39937><-0.09101,0.49128,-0.12011>,<-0.08514,0.48007,-0.11874>,<-0.06894,0.45464,-0.11717>,
              <-0.04964,0.43165,-0.11818>,<-0.03875,0.42444,-0.12104>,<-0.04316,0.4368,-0.12362>,
              <-0.06082,0.46108,-0.12398>,<-0.08157,0.48291,-0.12175><-0.03387,0.43137,-0.06652>,<-0.02699,0.42403,-0.07431>,<-0.01319,0.40495,-0.09323>,
              <-0.00364,0.38384,-0.11232>,<-0.00367,0.37317,-0.12039>,<-0.01256,0.37955,-0.11269>,
              <-0.02436,0.39958,-0.09369>,<-0.03191,0.42166,-0.07451><-0.03302,0.34691,-0.13623>,<-0.02379,0.34018,-0.13063>,<-0.00031,0.32447,-0.11996>,
              <0.02496,0.30957,-0.11357>,<0.03712,0.30416,-0.11496>,<0.02873,0.31127,-0.12257>,
              <0.00441,0.3266,-0.13123>,<-0.02171,0.34112,-0.1356><0.02655,0.29036,-0.03772>,<0.033,0.28579,-0.04769>,<0.04565,0.27377,-0.07234>,
              <0.0539,0.26025,-0.09785>,<0.05319,0.25325,-0.10922>,<0.04468,0.25711,-0.09965>,
              <0.0341,0.26983,-0.0746>,<0.02791,0.28405,-0.04869><-0.01002,0.17237,-0.1423>,<-0.00059,0.1738,-0.13388>,<0.02369,0.1773,-0.11627>,
              <0.05028,0.18084,-0.10278>,<0.06346,0.18234,-0.10106>,<0.05512,0.18092,-0.11142>,
              <0.02975,0.17741,-0.1271>,<0.00208,0.17385,-0.13865><-0.05607,0.44562,-0.16254>,<-0.05708,0.45523,-0.15427>,<-0.05914,0.47993,-0.13701>,
              <-0.06059,0.50689,-0.12386>,<-0.06063,0.52017,-0.12227>,<-0.05934,0.51162,-0.13247>,
              <-0.05757,0.48586,-0.1478>,<-0.05639,0.45784,-0.15902><-0.11939,0.53727,-0.02309>,<-0.11645,0.54721,-0.03048>,<-0.10679,0.56942,-0.04851>,
              <-0.09323,0.58898,-0.06683>,<-0.08396,0.59458,-0.07467>,<-0.08507,0.5834,-0.06741>,
              <-0.09656,0.56244,-0.04924>,<-0.11194,0.54413,-0.0308><-0.04354,0.58731,-0.09782>,<-0.05012,0.59234,-0.08816>,<-0.06696,0.6062,-0.06726>,
              <-0.08525,0.62264,-0.05004>,<-0.09419,0.63189,-0.04636>,<-0.08829,0.62807,-0.05774>,
              <-0.07077,0.613,-0.07691>,<-0.0518,0.59534,-0.09241><-0.18348,0.63948,-0.02398>,<-0.17324,0.64661,-0.02149>,<-0.14838,0.66165,-0.01326>,
              <-0.12331,0.67339,-0.00164>,<-0.11272,0.67517,0.00634>,<-0.12286,0.66649,0.00544>,
              <-0.14782,0.65299,-0.00438>,<-0.173,0.6428,-0.01758><-0.08647,0.67579,0.13215>,<-0.09508,0.6776,0.12296>,<-0.11408,0.68453,0.10054>,
              <-0.13042,0.69535,0.07778>,<-0.13468,0.70347,0.06804>,<-0.12481,0.70348,0.07708>,
              <-0.10706,0.69472,0.09966>,<-0.09198,0.68209,0.12257><-0.04352,0.62603,-0.15223>,<-0.04687,0.61376,-0.15195>,<-0.05634,0.58527,-0.1487>,
              <-0.06789,0.55848,-0.14158>,<-0.07464,0.549,-0.135>,<-0.07228,0.56207,-0.13346>,
              <-0.06183,0.58976,-0.13853>,<-0.04929,0.61574,-0.14746><-0.04093,0.59983,-0.14289>,<-0.04864,0.58983,-0.1445>,<-0.06543,0.56478,-0.14602>,
              <-0.07946,0.53831,-0.14397>,<-0.08269,0.52603,-0.13977>,<-0.07369,0.53536,-0.13649>,
              <-0.05819,0.56108,-0.13665>,<-0.04545,0.5882,-0.14037><-0.1182,0.49701,-0.09682>,<-0.11426,0.48745,-0.10423>,<-0.1074,0.46522,-0.12349>,
              <-0.10458,0.44429,-0.14483>,<-0.10719,0.43684,-0.15563>,<-0.11304,0.44701,-0.1492>,
              <-0.118,0.46863,-0.12896>,<-0.11893,0.48895,-0.10664><-0.12245,0.46364,-0.21452>,<-0.12302,0.45468,-0.2055>,<-0.12138,0.43304,-0.1845>,
              <-0.11516,0.41135,-0.16469>,<-0.10829,0.40233,-0.15759>,<-0.10557,0.41127,-0.16716>,
              <-0.10936,0.43293,-0.1876>,<-0.11773,0.45464,-0.20687><-0.09841,0.3966,-0.08139>,<-0.09691,0.39163,-0.09301>,<-0.09641,0.37952,-0.12067>,
              <-0.10059,0.36724,-0.14775>,<-0.10671,0.36199,-0.15842>,<-0.11041,0.36687,-0.14653>,
              <-0.10871,0.37907,-0.11914>,<-0.10234,0.39143,-0.09233><-0.09762,0.2939,-0.23379>,<-0.09912,0.29192,-0.22131>,<-0.09967,0.28768,-0.19142>,
              <-0.09559,0.28425,-0.16187>,<-0.08954,0.2836,-0.14996>,<-0.08586,0.28596,-0.1626>,
              <-0.08749,0.28981,-0.19233>,<-0.09375,0.29286,-0.22172><-0.11302,0.62069,-0.08848>,<-0.10302,0.61741,-0.09565>,<-0.08061,0.61122,-0.11492>,
              <-0.06077,0.60764,-0.13717>,<-0.05497,0.6086,-0.14918>,<-0.06617,0.6131,-0.14342>,
              <-0.08737,0.61807,-0.12275>,<-0.10601,0.62043,-0.0991><-0.03641,0.60665,-0.08214>,<-0.0346,0.60829,-0.09463>,<-0.03177,0.60951,-0.12467>,
              <-0.03125,0.60661,-0.15456>,<-0.03319,0.60155,-0.16678>,<-0.03608,0.59798,-0.15422>,
              <-0.03783,0.59869,-0.12425>,<-0.03728,0.60352,-0.09445><-0.0432,0.54191,-0.18346>,<-0.0315,0.54611,-0.18616>,<-0.00502,0.55783,-0.19475>,
              <0.01878,0.57192,-0.20641>,<0.02614,0.57999,-0.21414>,<0.01318,0.57691,-0.21289>,
              <-0.01204,0.56407,-0.20285>,<-0.03459,0.54886,-0.18974><0.06773,0.59403,-0.14996>,<0.0654,0.593,-0.16242>,<0.05856,0.58785,-0.19139>,
              <0.04991,0.57868,-0.21864>,<0.04463,0.57112,-0.22833>,<0.04612,0.57027,-0.21506>,
              <0.0538,0.5773,-0.1869>,<0.0633,0.58835,-0.16045><0.01165,0.50221,-0.26913>,<0.02333,0.50577,-0.26555>,<0.05084,0.51647,-0.25912>,
              <0.07729,0.53032,-0.25604>,<0.08727,0.53903,-0.2579>,<0.0751,0.53696,-0.26306>,
              <0.04809,0.52478,-0.26791>,<0.02212,0.50944,-0.26942><0.15711,0.50443,-0.19843>,<0.15336,0.50624,-0.21046>,<0.14229,0.50842,-0.23847>,
              <0.12818,0.50733,-0.26495>,<0.11948,0.5038,-0.27448>,<0.12181,0.50045,-0.26174>,
              <0.13431,0.49981,-0.23445>,<0.14984,0.50244,-0.20868><-0.13548,0.6776,-0.20069>,<-0.12816,0.67648,-0.19034>,<-0.11028,0.67686,-0.16601>,
              <-0.09209,0.68184,-0.14265>,<-0.08425,0.68823,-0.13389>,<-0.09142,0.69151,-0.1447>,
              <-0.10945,0.68897,-0.16858>,<-0.1278,0.68182,-0.19148><-0.1601,0.66799,-0.07535>,<-0.14895,0.67379,-0.07727>,<-0.12154,0.685,-0.0832>,
              <-0.09341,0.69196,-0.09106>,<-0.08108,0.69086,-0.09615>,<-0.0919,0.68306,-0.09514>,
              <-0.11965,0.67385,-0.0883>,<-0.14812,0.66888,-0.07952><-0.11697,0.68169,-0.14561>,<-0.11169,0.68052,-0.13409>,<-0.09863,0.68075,-0.10686>,
              <-0.08505,0.6856,-0.08052>,<-0.07895,0.69193,-0.07044>,<-0.08398,0.69526,-0.08238>,
              <-0.09729,0.69286,-0.10919>,<-0.1111,0.68586,-0.13511><-0.13309,0.64803,0.04149>,<-0.12402,0.6558,0.03711>,<-0.10247,0.67255,0.02417>,
              <-0.08147,0.68625,0.00766>,<-0.07327,0.68906,-0.00253>,<-0.08259,0.67986,0.00018>,
              <-0.10388,0.66454,0.01479>,<-0.12464,0.65227,0.03298><0.00275,0.62941,0.03307>,<-0.00909,0.63384,0.03453>,<-0.03592,0.64696,0.03897>,
              <-0.06012,0.66375,0.04481>,<-0.06767,0.67415,0.04853>,<-0.0546,0.67144,0.04772>,
              <-0.029,0.65659,0.04262>,<-0.00604,0.63808,0.03614><-0.10675,0.59749,0.03978>,<-0.10274,0.60799,0.04575>,<-0.09038,0.63176,0.05969>,
              <-0.07401,0.65315,0.07294>,<-0.06345,0.65978,0.07779>,<-0.06557,0.64817,0.0715>,
              <-0.07982,0.62551,0.05788>,<-0.09808,0.60523,0.04495><-0.06525,0.7386,-0.23372>,<-0.07096,0.73404,-0.22331>,<-0.08471,0.72611,-0.19762>,
              <-0.09842,0.72283,-0.17111>,<-0.10407,0.72583,-0.15936>,<-0.09834,0.73258,-0.16939>,
              <-0.08461,0.73833,-0.19547>,<-0.07091,0.73943,-0.22236><-0.05972,0.70741,-0.16579>,<-0.07194,0.71069,-0.16708>,<-0.10151,0.71682,-0.16762>,
              <-0.13115,0.72025,-0.16428>,<-0.1435,0.71914,-0.15927>,<-0.13131,0.7146,-0.15616>,
              <-0.10171,0.70973,-0.15744>,<-0.07203,0.70757,-0.16259><-0.12985,0.71277,-0.23046>,<-0.13773,0.71017,-0.22081>,<-0.15545,0.70661,-0.19661>,
              <-0.17119,0.70712,-0.17105>,<-0.17587,0.71116,-0.15918>,<-0.16707,0.71566,-0.16819>,
              <-0.15028,0.71731,-0.19303>,<-0.13545,0.71489,-0.21923><-0.28835,0.68621,-0.21824>,<-0.28119,0.68871,-0.20803>,<-0.26198,0.69296,-0.18511>,
              <-0.23991,0.69452,-0.16481>,<-0.22808,0.69264,-0.15886>,<-0.23391,0.68888,-0.1703>,
              <-0.25446,0.68589,-0.19198>,<-0.27787,0.6856,-0.21106><-0.22099,0.66793,-0.0806>,<-0.2249,0.66604,-0.09255>,<-0.23618,0.66383,-0.12048>,
              <-0.25023,0.66517,-0.14698>,<-0.25865,0.66906,-0.15662>,<-0.25603,0.67262,-0.144>,
              <-0.24345,0.67316,-0.11674>,<-0.22811,0.67016,-0.09091><-0.36548,0.61412,-0.18183>,<-0.35562,0.619,-0.17544>,<-0.33041,0.62929,-0.16238>,
              <-0.30308,0.63732,-0.15288>,<-0.28977,0.63852,-0.15229>,<-0.29864,0.63257,-0.16035>,
              <-0.32484,0.62335,-0.17174>,<-0.35317,0.61638,-0.17957><-0.13378,0.78785,-0.1266>,<-0.12719,0.78227,-0.13595>,<-0.11238,0.77138,-0.15991>,
              <-0.09922,0.76437,-0.18598>,<-0.09532,0.76513,-0.19875>,<-0.10268,0.77254,-0.19039>,
              <-0.11671,0.7816,-0.16544>,<-0.1291,0.78677,-0.13839><-0.03985,0.77856,-0.1634>,<-0.04672,0.77728,-0.17403>,<-0.06334,0.77129,-0.19852>,
              <-0.08001,0.76093,-0.22125>,<-0.08695,0.75252,-0.229>,<-0.08009,0.75174,-0.21754>,
              <-0.06345,0.75979,-0.19388>,<-0.04677,0.77221,-0.17198><-0.13686,0.7428,-0.19631>,<-0.12714,0.74003,-0.20403>,<-0.10502,0.73576,-0.22415>,
              <-0.08494,0.73514,-0.24647>,<-0.07854,0.7383,-0.25778>,<-0.08922,0.74278,-0.25108>,
              <-0.11038,0.74534,-0.22993>,<-0.1295,0.74426,-0.20658><-0.01095,0.73601,-0.22515>,<-0.01905,0.73678,-0.23493>,<-0.03935,0.73587,-0.25726>,
              <-0.06078,0.7308,-0.27768>,<-0.07071,0.72478,-0.28433>,<-0.06313,0.72206,-0.27365>,
              <-0.0423,0.72492,-0.25222>,<-0.02034,0.73195,-0.2327><-0.10527,0.67365,-0.24448>,<-0.09651,0.67676,-0.25317>,<-0.07802,0.68529,-0.27547>,
              <-0.06353,0.69532,-0.29978>,<-0.06128,0.70089,-0.31173>,<-0.07192,0.69848,-0.30398>,
              <-0.08853,0.68925,-0.28074>,<-0.10115,0.67851,-0.25549><0.01695,0.64107,-0.29359>,<0.00965,0.64401,-0.30359>,<-0.00992,0.64943,-0.32594>,
              <-0.03242,0.65232,-0.34561>,<-0.0445,0.65114,-0.35123>,<-0.03858,0.64701,-0.33997>,
              <-0.01764,0.64278,-0.31887>,<0.00625,0.64108,-0.30047><-0.0922,0.57238,-0.33187>,<-0.08224,0.57968,-0.33495>,<-0.06042,0.59833,-0.34434>,
              <-0.04195,0.61852,-0.35667>,<-0.03743,0.62835,-0.36455>,<-0.04896,0.62177,-0.36286>,
              <-0.06921,0.6024,-0.35209>,<-0.08612,0.58147,-0.33837><-0.14818,0.81649,-0.23883>,<-0.14073,0.8196,-0.229>,<-0.12358,0.8299,-0.20637>,
              <-0.10773,0.84443,-0.18541>,<-0.10238,0.85441,-0.1783>,<-0.11044,0.85328,-0.18891>,
              <-0.12697,0.841,-0.21076>,<-0.14222,0.82449,-0.23093><-0.15279,0.81413,-0.12202>,<-0.14547,0.82327,-0.12699>,<-0.12664,0.84276,-0.14032>,
              <-0.10608,0.85834,-0.15568>,<-0.09593,0.86114,-0.16394>,<-0.10244,0.85017,-0.15992>,
              <-0.12209,0.83251,-0.14564>,<-0.14346,0.81876,-0.12933><-0.13119,0.82206,-0.21261>,<-0.1251,0.8263,-0.20227>,<-0.1106,0.83913,-0.17909>,
              <-0.09642,0.85585,-0.15858>,<-0.09084,0.86642,-0.15257>,<-0.09708,0.864,-0.16416>,
              <-0.11143,0.84935,-0.18609>,<-0.12547,0.83081,-0.20536><-0.08944,0.82153,-0.02575>,<-0.08491,0.83219,-0.03103>,<-0.07371,0.85584,-0.04609>,
              <-0.06211,0.87638,-0.06467>,<-0.05694,0.88196,-0.07567>,<-0.06128,0.86983,-0.07206>,
              <-0.07267,0.84764,-0.05534>,<-0.08446,0.82857,-0.0351><-0.05626,0.84575,-0.13137>,<-0.05494,0.84844,-0.119>,<-0.05164,0.85776,-0.09047>,
              <-0.04817,0.87136,-0.06393>,<-0.04656,0.88101,-0.0548>,<-0.0478,0.88033,-0.0681>,
              <-0.05118,0.869,-0.0957>,<-0.05474,0.85339,-0.12131><-0.0674,0.86169,0.04124>,<-0.06235,0.86659,0.03065>,<-0.05098,0.87555,0.00414>,
              <-0.04088,0.88017,-0.02376>,<-0.03788,0.87802,-0.03662>,<-0.04353,0.87108,-0.02667>,
              <-0.0543,0.86416,0.00049>,<-0.06381,0.86157,0.02904><-0.03558,0.84178,-0.09029>,<-0.03491,0.84306,-0.07764>,<-0.03249,0.84902,-0.04814>,
              <-0.02884,0.85927,-0.02015>,<-0.02617,0.86755,-0.00999>,<-0.02625,0.86828,-0.02335>,
              <-0.02925,0.8603,-0.05214>,<-0.03348,0.84804,-0.07941><-0.07843,0.87031,-0.28117>,<-0.08937,0.87066,-0.27468>,<-0.11515,0.87453,-0.25944>,
              <-0.13999,0.88298,-0.24483>,<-0.14938,0.89079,-0.23937>,<-0.13799,0.89259,-0.24615>,
              <-0.11266,0.88657,-0.2611>,<-0.08827,0.87596,-0.27541><-0.12228,0.8477,-0.25863>,<-0.13081,0.85685,-0.26093>,<-0.15297,0.87706,-0.2645>,
              <-0.17745,0.89443,-0.2651>,<-0.18978,0.89896,-0.26256>,<-0.18233,0.88848,-0.25887>,
              <-0.15908,0.8696,-0.25669>,<-0.13351,0.85356,-0.25749><-0.23101,0.90531,-0.19542>,<-0.22953,0.90211,-0.20764>,<-0.22555,0.89748,-0.23722>,
              <-0.22096,0.89754,-0.26689>,<-0.21849,0.90195,-0.27928>,<-0.21968,0.90735,-0.2671>,
              <-0.22395,0.90978,-0.23747>,<-0.22882,0.90753,-0.20776><-0.18386,0.85848,-0.33048>,<-0.1932,0.86624,-0.32669>,<-0.21623,0.88245,-0.31577>,
              <-0.23996,0.89483,-0.30217>,<-0.25046,0.89637,-0.29403>,<-0.24146,0.88681,-0.29656>,
              <-0.2181,0.8724,-0.30874>,<-0.19403,0.86181,-0.32359><-0.27589,0.88171,-0.21584>,<-0.27291,0.88086,-0.22818>,<-0.26665,0.88178,-0.25771>,
              <-0.26175,0.88719,-0.28684>,<-0.26102,0.89366,-0.29852>,<-0.26464,0.89663,-0.28599>,
              <-0.27026,0.8936,-0.25665>,<-0.27451,0.88607,-0.22772><-0.38144,0.80417,-0.33134>,<-0.37526,0.8152,-0.32994>,<-0.358,0.83977,-0.32671>,
              <-0.3372,0.86122,-0.32371>,<-0.32527,0.86718,-0.3227>,<-0.32979,0.85468,-0.32421>,
              <-0.34871,0.83157,-0.32733>,<-0.37117,0.81159,-0.33021><-0.17902,0.99168,-0.21055>,<-0.17191,0.98265,-0.21603>,<-0.156,0.96235,-0.23173>,
              <-0.14195,0.94427,-0.25115>,<-0.13787,0.93887,-0.26269>,<-0.14585,0.94894,-0.25896>,
              <-0.16089,0.9682,-0.24151>,<-0.17407,0.98523,-0.22034><-0.10801,0.97919,-0.21279>,<-0.11107,0.97346,-0.22373>,<-0.1181,0.9572,-0.24819>,
              <-0.12455,0.93729,-0.26972>,<-0.12669,0.92561,-0.27588>,<-0.12335,0.92962,-0.26356>,
              <-0.11659,0.9476,-0.24048>,<-0.11041,0.96922,-0.22033><-0.15105,0.92736,-0.22887>,<-0.14247,0.92328,-0.23734>,<-0.12429,0.91389,-0.25955>,
              <-0.10994,0.90517,-0.28444>,<-0.10759,0.90218,-0.29726>,<-0.11797,0.90656,-0.29006>,
              <-0.13436,0.91564,-0.26659>,<-0.14691,0.92405,-0.24044><-0.05369,0.94062,-0.26443>,<-0.05967,0.93396,-0.27346>,<-0.07377,0.91576,-0.293>,
              <-0.08736,0.89436,-0.30911>,<-0.0925,0.8825,-0.31255>,<-0.08627,0.88766,-0.3019>,
              <-0.07241,0.90737,-0.28397>,<-0.05907,0.93026,-0.26948><-0.14096,0.85303,-0.27327>,<-0.12964,0.85256,-0.27906>,<-0.10425,0.85204,-0.29541>,
              <-0.08179,0.85245,-0.31533>,<-0.07524,0.85349,-0.32695>,<-0.08794,0.8544,-0.32285>,
              <-0.11195,0.85448,-0.30482>,<-0.13304,0.85364,-0.28321><-0.03235,0.88611,-0.26401>,<-0.03681,0.88214,-0.27525>,<-0.04927,0.87087,-0.30034>,
              <-0.06428,0.85706,-0.32238>,<-0.07289,0.84896,-0.32864>,<-0.06963,0.85173,-0.31597>,
              <-0.05597,0.8642,-0.29231>,<-0.03976,0.87919,-0.27171><-0.10268,0.74204,-0.29391>,<-0.09271,0.74859,-0.29834>,<-0.07054,0.7643,-0.31153>,
              <-0.05126,0.77989,-0.32845>,<-0.04597,0.78624,-0.33897>,<-0.0573,0.77965,-0.33629>,
              <-0.07811,0.76399,-0.32135>,<-0.09605,0.74845,-0.30267><-0.19263,0.93847,-0.29862>,<-0.18514,0.9464,-0.29207>,<-0.16801,0.96735,-0.27866>,
              <-0.15232,0.99099,-0.26884>,<-0.14717,1.00332,-0.26815>,<-0.15534,0.99665,-0.27638>,
              <-0.17179,0.97444,-0.28811>,<-0.18681,0.94953,-0.29624><-0.15958,0.95954,-0.19653>,<-0.15669,0.97012,-0.20299>,<-0.14844,0.9934,-0.22037>,
              <-0.1383,1.0133,-0.24043>,<-0.13231,1.01836,-0.25127>,<-0.13431,1.0062,-0.24607>,
              <-0.14345,0.98451,-0.22743>,<-0.15449,0.9662,-0.2061><-0.16217,0.97008,-0.30707>,<-0.15639,0.97534,-0.29703>,<-0.14357,0.99054,-0.2743>,
              <-0.13245,1.00951,-0.25385>,<-0.12942,1.0209,-0.24753>,<-0.13599,1.01741,-0.25865>,
              <-0.14802,1.00044,-0.28031>,<-0.15835,0.97971,-0.29968><-0.11637,0.99898,-0.14331>,<-0.11587,1.00751,-0.15274>,<-0.11331,1.02559,-0.17679>,
              <-0.10869,1.03989,-0.20279>,<-0.10485,1.04227,-0.21538>,<-0.10438,1.03197,-0.20686>,
              <-0.10791,1.01566,-0.1819>,<-0.11349,1.00313,-0.15499><-0.12484,1.00206,-0.28313>,<-0.12096,1.00576,-0.27159>,<-0.1123,1.01744,-0.24512>,
              <-0.1047,1.03321,-0.22073>,<-0.10255,1.04359,-0.21258>,<-0.10692,1.04181,-0.22509>,
              <-0.11508,1.02822,-0.25059>,<-0.12219,1.01052,-0.274><-0.07436,1.01596,-0.10614>,<-0.07538,1.02385,-0.11607>,<-0.07699,1.0402,-0.14141>,
              <-0.07733,1.0525,-0.1688>,<-0.07627,1.05379,-0.18207>,<-0.07466,1.04399,-0.1731>,
              <-0.07364,1.02955,-0.1468>,<-0.0739,1.01915,-0.11845><-0.03208,0.99457,-0.20953>,<-0.0355,1.00193,-0.19973>,<-0.04396,1.02167,-0.17849>,
              <-0.05273,1.04437,-0.16092>,<-0.05665,1.05657,-0.15707>,<-0.05337,1.05061,-0.16858>,
              <-0.04477,1.02947,-0.1881>,<-0.03586,1.00537,-0.20396><-0.04936,1.04279,-0.06492>,<-0.0497,1.04754,-0.07672>,<-0.05028,1.05593,-0.10572>,
              <-0.05048,1.05968,-0.13551>,<-0.05022,1.05687,-0.14859>,<-0.0497,1.04994,-0.13716>,
              <-0.0493,1.04373,-0.10779>,<-0.04927,1.04216,-0.07763><-0.13935,1.0437,-0.38035>,<-0.14676,1.03949,-0.3709>,<-0.16485,1.03243,-0.34777>,
              <-0.18325,1.03006,-0.32416>,<-0.19117,1.03348,-0.31393>,<-0.18391,1.03989,-0.32316>,
              <-0.16567,1.04475,-0.34651>,<-0.14712,1.04492,-0.37035><-0.13377,1.01379,-0.29918>,<-0.14483,1.01722,-0.30444>,<-0.17244,1.0244,-0.31435>,
              <-0.2014,1.02991,-0.32005>,<-0.21466,1.03064,-0.31846>,<-0.20423,1.02643,-0.31122>,
              <-0.17599,1.02004,-0.30329>,<-0.14639,1.0153,-0.29957><-0.18618,1.03606,-0.37131>,<-0.19634,1.03154,-0.36511>,<-0.22102,1.0237,-0.34957>,
              <-0.24596,1.0205,-0.33316>,<-0.25653,1.02352,-0.32554>,<-0.2465,1.03022,-0.33133>,
              <-0.2217,1.03588,-0.34728>,<-0.19664,1.03691,-0.3641><-0.31421,0.95683,-0.38899>,<-0.31364,0.96568,-0.37986>,<-0.30923,0.98631,-0.35825>,
              <-0.30028,1.00583,-0.33726>,<-0.29231,1.01286,-0.32915>,<-0.29075,1.00349,-0.33857>,
              <-0.29729,0.98338,-0.35988>,<-0.30837,0.96439,-0.38058><-0.31121,1.00473,-0.24515>,<-0.31091,1.00187,-0.25754>,<-0.31143,0.99785,-0.28747>,
              <-0.31385,0.99815,-0.31739>,<-0.31662,1.00234,-0.32979>,<-0.31781,1.00722,-0.3174>,
              <-0.3164,1.00922,-0.28747>,<-0.3131,1.00688,-0.25754><-0.35222,0.92847,-0.37709>,<-0.35147,0.93851,-0.36932>,<-0.34665,0.96231,-0.35136>,
              <-0.33732,0.98544,-0.33463>,<-0.32923,0.99439,-0.32887>,<-0.32787,0.98404,-0.33723>,
              <-0.3348,0.96056,-0.35461>,<-0.34624,0.93774,-0.37075><-0.33453,0.96162,-0.24465>,<-0.33458,0.96243,-0.25734>,<-0.3365,0.96678,-0.28717>,
              <-0.34114,0.97478,-0.31573>,<-0.34561,0.98152,-0.32639>,<-0.34684,0.98244,-0.3131>,
              <-0.34365,0.97637,-0.28386>,<-0.33773,0.96665,-0.25589><-0.04151,0.26975,-0.03472>,<-0.03434,0.2659,-0.02494>,<-0.01598,0.25951,-0.00183>,
              <0.00399,0.25749,0.0205>,<0.01377,0.26076,0.02902>,<0.00736,0.26666,0.01887>,
              <-0.01176,0.271,-0.00387>,<-0.03248,0.27096,-0.02584><0.04088,0.21105,0.05448>,<0.05224,0.21669,0.05558>,<0.07983,0.22896,0.05544>,
              <0.10771,0.2392,0.05104>,<0.11953,0.24153,0.04523>,<0.10832,0.23493,0.04213>,
              <0.08059,0.22362,0.04427>,<0.05257,0.21434,0.05066><0.16275,0.2159,-0.01832>,<0.16738,0.21407,-0.00661>,<0.1799,0.21235,0.02082>,
              <0.19449,0.21467,0.04696>,<0.20247,0.21943,0.05658>,<0.19882,0.22316,0.04427>,
              <0.18532,0.22298,0.01745>,<0.16977,0.21876,-0.00809><0.20322,0.1444,0.1061>,<0.21091,0.15347,0.10158>,<0.22908,0.1735,0.08815>,
              <0.24664,0.19076,0.07096>,<0.25333,0.1953,0.0603>,<0.24534,0.18493,0.06306>,
              <0.22746,0.1662,0.07825>,<0.2102,0.15025,0.09722><0.33089,0.08677,-0.0088>,<0.33123,0.09135,0.00306>,<0.33354,0.10463,0.03009>,
              <0.3381,0.12126,0.05467>,<0.34211,0.13129,0.06256>,<0.34283,0.12828,0.04954>,
              <0.33946,0.11343,0.02367>,<0.33384,0.09523,0.00023><0.04406,0.3076,0.02998>,<0.03195,0.30648,0.03372>,<0.00389,0.30576,0.04487>,
              <-0.02239,0.30804,0.05921>,<-0.03161,0.31179,0.06814>,<-0.01867,0.31432,0.0659>,
              <0.00856,0.31363,0.05325>,<0.034,0.30995,0.03742><-0.08268,0.31655,0.0246>,<-0.08367,0.31683,0.03728>,<-0.08569,0.31446,0.06732>,
              <-0.08715,0.30747,0.09648>,<-0.08724,0.30026,0.10775>,<-0.08598,0.29781,0.09466>,
              <-0.08423,0.30235,0.06503>,<-0.08303,0.3115,0.03627><-0.11123,0.21341,0.16133>,<-0.12196,0.22011,0.15998>,<-0.14664,0.23751,0.1593>,
              <-0.16945,0.25677,0.16255>,<-0.17714,0.26648,0.16758>,<-0.16554,0.26066,0.17078>,
              <-0.14174,0.24238,0.16961>,<-0.1198,0.22226,0.16452><-0.26195,0.20257,0.12392>,<-0.26107,0.20757,0.13559>,<-0.25702,0.21716,0.16394>,
              <-0.2501,0.22303,0.19256>,<-0.24452,0.22196,0.20467>,<-0.24406,0.21521,0.19313>,
              <-0.24945,0.20736,0.16466>,<-0.25773,0.20325,0.13591><-0.31813,0.13497,0.24516>,<-0.30909,0.14308,0.24138>,<-0.28987,0.16437,0.23191>,
              <-0.27459,0.1882,0.2219>,<-0.27196,0.20046,0.21725>,<-0.28285,0.19354,0.22077>,
              <-0.30022,0.17106,0.2305>,<-0.31365,0.14603,0.24076><-0.04308,0.31513,0.01079>,<-0.03231,0.32147,0.01321>,<-0.00828,0.33907,0.01818>,
              <0.01281,0.36012,0.02186>,<0.01878,0.37209,0.02217>,<0.00664,0.36737,0.01914>,
              <-0.01601,0.34815,0.01478>,<-0.03572,0.32547,0.01171><0.11928,0.37892,-0.05713>,<0.11288,0.38967,-0.05941>,<0.09609,0.41363,-0.06691>,
              <0.07731,0.43455,-0.07744>,<0.06765,0.44038,-0.08463>,<0.07311,0.4282,-0.08377>,
              <0.09084,0.40567,-0.07485>,<0.11056,0.38616,-0.0629><0.00635,0.44858,-0.15575>,<0.01874,0.44734,-0.15314>,<0.04809,0.44733,-0.14603>,
              <0.07659,0.45179,-0.1377>,<0.0876,0.45785,-0.13311>,<0.07481,0.46119,-0.13515>,
              <0.04585,0.4591,-0.14283>,<0.01775,0.45253,-0.15173><0.17137,0.42751,-0.14558>,<0.16258,0.43604,-0.14903>,<0.13996,0.45389,-0.15809>,
              <0.11527,0.46764,-0.16823>,<0.1031,0.46949,-0.17345>,<0.11092,0.45905,-0.17051>,
              <0.13451,0.44312,-0.16094>,<0.16017,0.43129,-0.15029><0.04423,0.45863,-0.27252>,<0.05574,0.45758,-0.26721>,<0.08309,0.45813,-0.25442>,
              <0.10977,0.46336,-0.24166>,<0.12018,0.46991,-0.23641>,<0.10834,0.47316,-0.24173>,
              <0.08131,0.47041,-0.25451>,<0.05496,0.46299,-0.26725><0.04812,0.39023,0.03878>,<0.04662,0.38398,0.04976>,<0.04392,0.37171,0.07722>,
              <0.04262,0.3637,0.10613>,<0.0434,0.36439,0.11946>,<0.04557,0.37265,0.10917>,
              <0.04761,0.38292,0.08103>,<0.04825,0.38892,0.05143><0.00684,0.32534,0.1356>,<0.01696,0.32774,0.14293>,<0.04257,0.33161,0.15847>,
              <0.06995,0.33257,0.17074>,<0.08297,0.33023,0.17277>,<0.07368,0.32646,0.1639>,
              <0.04724,0.32396,0.1499>,<0.01902,0.32437,0.13915><0.17597,0.28125,0.16469>,<0.16854,0.27681,0.17401>,<0.15222,0.26836,0.19798>,
              <0.13832,0.26333,0.22411>,<0.13483,0.26447,0.23697>,<0.14339,0.27052,0.22866>,
              <0.15857,0.27736,0.20368>,<0.17134,0.28077,0.17653><0.07333,0.20641,0.26297>,<0.08518,0.21077,0.26459>,<0.11396,0.21983,0.26572>,
              <0.14304,0.2267,0.26269>,<0.15535,0.22748,0.25752>,<0.14364,0.22208,0.25395>,
              <0.11472,0.21405,0.25477>,<0.08551,0.20822,0.25976><0.18155,0.19166,0.18394>,<0.17631,0.19359,0.19537>,<0.16636,0.19983,0.2232>,
              <0.1605,0.20841,0.25137>,<0.16191,0.21416,0.26336>,<0.16907,0.21333,0.25209>,
              <0.17709,0.20599,0.2241>,<0.18103,0.19631,0.19577><-0.01251,0.39341,0.13173>,<-0.01931,0.40347,0.12792>,<-0.03322,0.42909,0.12004>,
              <-0.04334,0.45673,0.11413>,<-0.04398,0.47008,0.11354>,<-0.03541,0.46097,0.11827>,
              <-0.02328,0.4344,0.12523>,<-0.01493,0.40581,0.13021><0.02595,0.43827,0.1179>,<0.01583,0.44586,0.11923>,<-0.00975,0.46186,0.12074>,
              <-0.03704,0.47431,0.11963>,<-0.04997,0.47615,0.11673>,<-0.04066,0.46689,0.11417>,
              <-0.01428,0.45256,0.11389>,<0.01383,0.44176,0.11621><-0.23332,0.51944,0.13893>,<-0.2222,0.52502,0.1416>,<-0.1974,0.54028,0.14962>,
              <-0.17568,0.55823,0.16001>,<-0.16958,0.56818,0.16654>,<-0.18214,0.56386,0.16498>,
              <-0.20549,0.54734,0.15585>,<-0.22576,0.52813,0.14435><-0.25088,0.58148,0.10084>,<-0.24481,0.58439,0.11164>,<-0.23098,0.58843,0.13818>,
              <-0.2184,0.58798,0.16544>,<-0.21435,0.58357,0.1774>,<-0.22101,0.57855,0.16694>,
              <-0.23426,0.57662,0.14007>,<-0.24625,0.57918,0.11247><-0.28435,0.54256,0.13358>,<-0.27452,0.54789,0.13965>,<-0.25323,0.56243,0.15537>,
              <-0.23559,0.57948,0.17268>,<-0.23173,0.5889,0.18136>,<-0.24327,0.58475,0.17604>,
              <-0.26285,0.56903,0.15957>,<-0.27877,0.5508,0.1415><-0.01279,0.43839,0.04565>,<-0.00556,0.44615,0.05268>,<0.0092,0.46646,0.06946>,
              <0.0199,0.48916,0.08595>,<0.02052,0.5008,0.09251>,<0.01138,0.49416,0.08534>,
              <-0.00147,0.47273,0.0687>,<-0.01026,0.44891,0.05235><0.10481,0.53975,0.07559>,<0.09616,0.54853,0.07244>,<0.07577,0.56826,0.0621>,
              <0.05612,0.58579,0.04765>,<0.04868,0.59097,0.03782>,<0.05768,0.58115,0.03905>,
              <0.07772,0.56245,0.05131>,<0.09702,0.54597,0.06768><-0.00642,0.62645,-0.04397>,<0.00492,0.62437,-0.0386>,<0.03127,0.62184,-0.02406>,
              <0.05605,0.62308,-0.00715>,<0.06484,0.62712,0.00208>,<0.05276,0.63098,-0.00217>,
              <0.02715,0.63174,-0.01782>,<0.0031,0.62873,-0.03585><0.14927,0.60754,-0.03976>,<0.13992,0.61528,-0.03594>,<0.11612,0.63263,-0.02928>,
              <0.09046,0.64797,-0.02646>,<0.07809,0.65243,-0.0289>,<0.08657,0.64375,-0.03453>,
              <0.11124,0.62734,-0.03939>,<0.13777,0.61295,-0.0404><0.03517,0.64069,-0.12761>,<0.04486,0.64258,-0.11958>,<0.06652,0.64973,-0.09978>,
              <0.08558,0.66076,-0.07937>,<0.09103,0.66898,-0.07034>,<0.08012,0.66892,-0.07808>,
              <0.05968,0.65995,-0.09817>,<0.04184,0.64709,-0.11887><0.05294,0.48252,0.10387>,<0.04821,0.48799,0.11435>,<0.03805,0.50363,0.1381>,
              <0.02977,0.52294,0.15955>,<0.02811,0.53438,0.16628>,<0.03371,0.53063,0.15472>,
              <0.04299,0.51327,0.13205>,<0.05039,0.49224,0.11168><-0.01733,0.47557,0.13232>,<-0.01269,0.48605,0.13784>,<0.00103,0.50951,0.15101>,
              <0.01854,0.53016,0.16399>,<0.02936,0.53607,0.16918>,<0.0265,0.52427,0.16358>,
              <0.01099,0.50213,0.15049>,<-0.0083,0.4828,0.13761><0.1342,0.55249,0.20794>,<0.12509,0.55419,0.21666>,<0.1033,0.56113,0.23639>,
              <0.08181,0.57233,0.25411>,<0.07319,0.58097,0.25958>,<0.08243,0.58127,0.24992>,
              <0.10408,0.57233,0.23113>,<0.12544,0.55913,0.21434><0.03201,0.53669,0.31821>,<0.03971,0.5465,0.31569>,<0.0602,0.56771,0.30917>,
              <0.08352,0.5852,0.30198>,<0.09584,0.58896,0.29836>,<0.08946,0.57741,0.30056>,
              <0.06764,0.55794,0.3074>,<0.043,0.54219,0.31491><0.18869,0.5779,0.29235>,<0.17818,0.57749,0.29951>,<0.15354,0.57956,0.31684>,
              <0.13,0.58622,0.33425>,<0.12129,0.59328,0.34154>,<0.13232,0.59584,0.33442>,
              <0.15645,0.59162,0.31705>,<0.17946,0.58281,0.2996><0.07804,0.53829,0.4043>,<0.08531,0.54783,0.40005>,<0.10448,0.56832,0.3889>,
              <0.12608,0.58501,0.37639>,<0.13731,0.58834,0.36993>,<0.13118,0.57701,0.37353>,
              <0.11087,0.55831,0.38532>,<0.08812,0.54341,0.39848><0.07587,0.53104,0.11906>,<0.06378,0.5329,0.12255>,<0.03615,0.53916,0.13302>,
              <0.0109,0.54809,0.14658>,<0.00266,0.55429,0.15511>,<0.01587,0.55368,0.15307>,
              <0.04238,0.54617,0.14115>,<0.06652,0.53599,0.12613><0.0012,0.55901,0.21786>,<-0.00964,0.56253,0.21222>,<-0.03605,0.56791,0.19858>,
              <-0.06277,0.56858,0.18491>,<-0.07414,0.56444,0.17921>,<-0.06344,0.55871,0.18483>,
              <-0.03689,0.55554,0.19849>,<-0.01002,0.55708,0.21218><-0.03795,0.50587,0.18517>,<-0.04804,0.51337,0.18317>,<-0.071,0.53284,0.1808>,
              <-0.0919,0.55436,0.18215>,<-0.09861,0.5652,0.18619>,<-0.08756,0.55866,0.18994>,
              <-0.06556,0.53822,0.19056>,<-0.04564,0.51574,0.18747><-0.16955,0.57137,0.11937>,<-0.16937,0.57244,0.13204>,<-0.1685,0.57195,0.16223>,
              <-0.16701,0.56682,0.19177>,<-0.1658,0.56034,0.20341>,<-0.1657,0.55709,0.19044>,
              <-0.16686,0.55976,0.16055>,<-0.16864,0.56707,0.13131><-0.32106,0.45185,0.21256>,<-0.3122,0.46087,0.214>,<-0.29342,0.48432,0.21704>,
              <-0.27857,0.51031,0.21938>,<-0.2761,0.52346,0.21971>,<-0.2868,0.51563,0.21793>,
              <-0.30374,0.49098,0.21522>,<-0.31675,0.4638,0.2132><-0.05166,0.58812,0.13787>,<-0.04017,0.59005,0.14299>,<-0.01357,0.59763,0.15509>,
              <0.01134,0.6096,0.16685>,<0.02005,0.61867,0.17138>,<0.00776,0.6188,0.1661>,
              <-0.01804,0.60916,0.15416>,<-0.04215,0.59514,0.14257><0.00505,0.58198,0.18755>,<0.01134,0.59173,0.18232>,<0.02656,0.61313,0.1674>,
              <0.04184,0.63131,0.14903>,<0.04822,0.63582,0.13818>,<0.04196,0.62456,0.14179>,
              <0.02672,0.60467,0.15832>,<0.01141,0.588,0.17831><0.01682,0.62048,0.05215>,<0.02678,0.62257,0.05978>,<0.04979,0.63053,0.07766>,
              <0.07121,0.64285,0.09471>,<0.07859,0.65206,0.101>,<0.06789,0.65202,0.09299>,
              <0.04563,0.64201,0.0755>,<0.02495,0.62763,0.05883><0.10792,0.62883,0.14256>,<0.10822,0.63657,0.13247>,<0.10834,0.65248,0.1068>,
              <0.10757,0.66419,0.07916>,<0.10642,0.6651,0.06587>,<0.1057,0.65538,0.07503>,
              <0.106,0.64145,0.10163>,<0.10718,0.63171,0.13019><0.08557,0.6191,-0.02454>,<0.09394,0.62388,-0.01623>,<0.11292,0.638,0.00254>,
              <0.13008,0.65601,0.01936>,<0.13548,0.66712,0.02449>,<0.12625,0.66417,0.01526>,
              <0.10812,0.64823,-0.00259>,<0.09182,0.62839,-0.01849><0.20506,0.62228,0.04534>,<0.19982,0.63048,0.03714>,<0.18585,0.64755,0.01652>,
              <0.16986,0.66054,-0.00533>,<0.16135,0.66208,-0.01554>,<0.16564,0.65196,-0.00791>,
              <0.18056,0.63681,0.01329>,<0.19749,0.62574,0.03571><0.02694,0.7512,0.18115>,<0.02517,0.73861,0.18064>,<0.02147,0.70869,0.18247>,
              <0.01866,0.67949,0.18888>,<0.01831,0.66808,0.19584>,<0.0205,0.681,0.1985>,
              <0.02378,0.71058,0.19451>,<0.02618,0.73944,0.18595><-0.0136,0.68223,0.19884>,<-0.00838,0.6714,0.20302>,<0.00376,0.64466,0.21006>,
              <0.0152,0.61701,0.21253>,<0.01927,0.60469,0.20926>,<0.01371,0.61509,0.20293>,
              <0.0019,0.64226,0.19804>,<-0.0092,0.67034,0.19771><0.06055,0.62733,0.18925>,<0.05384,0.61661,0.19065>,<0.03885,0.59114,0.19688>,
              <0.0257,0.56629,0.20741>,<0.02197,0.55658,0.21582>,<0.02954,0.56759,0.21645>,
              <0.04367,0.59277,0.20819>,<0.05596,0.61733,0.19564><-0.0218,0.55512,0.17223>,<-0.0174,0.54636,0.18034>,<-0.0044,0.5255,0.19789>,
              <0.01216,0.50507,0.21238>,<0.02237,0.49702,0.21552>,<0.01965,0.50599,0.20597>,
              <0.00498,0.52664,0.18985>,<-0.01326,0.54686,0.1768><0.07042,0.52312,0.15955>,<0.06116,0.51702,0.16578>,<0.04124,0.50195,0.18275>,
              <0.02501,0.48633,0.20261>,<0.02176,0.47935,0.21355>,<0.03276,0.48519,0.20867>,
              <0.05094,0.50052,0.19034>,<0.06544,0.51639,0.16913><-0.04982,0.42776,0.14215>,<-0.0415,0.42519,0.15142>,<-0.01958,0.42025,0.1716>,
              <0.00508,0.41722,0.18845>,<0.01788,0.41775,0.19231>,<0.01085,0.42122,0.18147>,
              <-0.01236,0.42527,0.16285>,<-0.03831,0.4274,0.14756><0.07707,0.70907,0.20641>,<0.06436,0.70955,0.20638>,<0.03442,0.7131,0.20816>,
              <0.00563,0.72028,0.21275>,<-0.00522,0.72665,0.21729>,<0.00803,0.72787,0.21864>,
              <0.03743,0.72262,0.21554>,<0.06568,0.71374,0.20963><0.03841,0.73136,0.27149>,<0.02833,0.7335,0.26402>,<0.00439,0.73556,0.24573>,
              <-0.01899,0.73295,0.22707>,<-0.02813,0.72748,0.21898>,<-0.01778,0.72315,0.22627>,
              <0.00589,0.72329,0.24473>,<0.029,0.72809,0.26358><-0.00033,0.68393,0.23497>,<-0.0115,0.68864,0.23112>,<-0.03762,0.70205,0.22404>,
              <-0.06245,0.71851,0.22031>,<-0.07153,0.72821,0.22191>,<-0.05975,0.72493,0.22734>,
              <-0.03424,0.71009,0.23285>,<-0.01001,0.69219,0.235><-0.13118,0.74144,0.14203>,<-0.13304,0.74123,0.15461>,<-0.13692,0.73772,0.18436>,
              <-0.13987,0.72968,0.21314>,<-0.14023,0.7221,0.22415>,<-0.13794,0.72018,0.21111>,
              <-0.1345,0.72582,0.18182>,<-0.13197,0.73599,0.1535><-0.22233,0.65313,0.24843>,<-0.21248,0.66049,0.24516>,<-0.19115,0.68019,0.23685>,
              <-0.1735,0.70276,0.22787>,<-0.16964,0.71481,0.22353>,<-0.18122,0.7088,0.22648>,
              <-0.20083,0.68775,0.23511>,<-0.21675,0.66383,0.2444><-0.19495,0.71611,0.13713>,<-0.19652,0.71671,0.14974>,<-0.19889,0.7154,0.17982>,
              <-0.1991,0.70993,0.20934>,<-0.19717,0.70376,0.22105>,<-0.19458,0.7012,0.20818>,
              <-0.19323,0.70446,0.17836>,<-0.19403,0.71189,0.1491><-0.27258,0.63647,0.22835>,<-0.26192,0.64341,0.22793>,<-0.23834,0.66216,0.22579>,
              <-0.218,0.68392,0.22198>,<-0.21261,0.69575,0.21885>,<-0.22479,0.69023,0.2185>,
              <-0.24685,0.67007,0.22142>,<-0.26567,0.6469,0.226><-0.05857,0.77796,0.24086>,<-0.04634,0.77492,0.23909>,<-0.01713,0.77017,0.23308>,
              <0.01162,0.76932,0.22445>,<0.02309,0.77263,0.21842>,<0.01064,0.7775,0.21896>,
              <-0.01835,0.78042,0.2262>,<-0.04688,0.77944,0.23605><0.00813,0.74217,0.21709>,<0.01233,0.74635,0.20583>,<0.0208,0.75394,0.17786>,
              <0.02672,0.75774,0.14867>,<0.0268,0.75575,0.13544>,<0.0214,0.74979,0.14613>,
              <0.01413,0.74398,0.17467>,<0.00939,0.74196,0.20443><-0.05473,0.73133,0.10746>,<-0.04235,0.73188,0.11036>,<-0.01287,0.73576,0.11561>,
              <0.01602,0.74351,0.11822>,<0.02743,0.75035,0.11682>,<0.01478,0.75162,0.11268>,
              <-0.01443,0.74593,0.10867>,<-0.04304,0.73636,0.1073><0.04609,0.72348,0.15383>,<0.045,0.72635,0.14148>,<0.04065,0.73068,0.11191>,
              <0.0337,0.73108,0.0827>,<0.02839,0.72756,0.07094>,<0.02826,0.72284,0.08346>,
              <0.03383,0.72036,0.11286>,<0.042,0.7218,0.1419><-0.05032,0.68281,0.02243>,<-0.0386,0.68458,0.02707>,<-0.0104,0.69085,0.03586>,
              <0.01768,0.70013,0.04102>,<0.02921,0.70679,0.03974>,<0.01744,0.70644,0.03339>,
              <-0.01071,0.69875,0.02631>,<-0.03874,0.68806,0.02286><0.05928,0.62298,0.06733>,<0.05743,0.63258,0.05919>,<0.05035,0.65408,0.0392>,
              <0.03931,0.67305,0.0187>,<0.03103,0.67852,0.00973>,<0.03103,0.66773,0.01763>,
              <0.03997,0.64742,0.03786>,<0.05286,0.62965,0.0586><0.02397,0.80814,0.17971>,<0.02615,0.80935,0.19218>,<0.03241,0.81503,0.22118>,
              <0.04017,0.82484,0.24847>,<0.04479,0.83279,0.25818>,<0.04332,0.83352,0.24491>,
              <0.03635,0.82591,0.21671>,<0.02789,0.81415,0.19022><0.00328,0.79415,0.25998>,<0.01217,0.80243,0.26375>,<0.03533,0.82028,0.2713>,
              <0.06103,0.8349,0.27653>,<0.07406,0.83793,0.27651>,<0.06636,0.82813,0.27165>,
              <0.042,0.8118,0.26518>,<0.01511,0.79869,0.26105><0.11665,0.83605,0.21182>,<0.11485,0.8336,0.22417>,<0.11063,0.8308,0.25395>,
              <0.10661,0.83272,0.28364>,<0.10512,0.83794,0.29586>,<0.10701,0.84261,0.28347>,
              <0.11114,0.8432,0.25374>,<0.11507,0.83906,0.22408><0.06353,0.80726,0.33805>,<0.07454,0.81346,0.33649>,<0.10157,0.82578,0.33109>,
              <0.12932,0.83414,0.32324>,<0.14149,0.83387,0.31768>,<0.13082,0.82582,0.31808>,
              <0.10345,0.81536,0.32464>,<0.07536,0.80886,0.33365><0.21278,0.81033,0.26144>,<0.20714,0.8094,0.2728>,<0.19449,0.81015,0.30022>,
              <0.18331,0.81538,0.32759>,<0.18006,0.82176,0.33889>,<0.1864,0.82479,0.3275>,
              <0.19836,0.82194,0.30011>,<0.20885,0.8146,0.27276><0.14849,0.74513,0.36702>,<0.15509,0.75599,0.36649>,<0.17206,0.78068,0.36267>,
              <0.19058,0.80305,0.35505>,<0.19972,0.81014,0.34832>,<0.19385,0.79818,0.34707>,
              <0.17615,0.77458,0.35267>,<0.1569,0.7533,0.36208><0.25976,0.77899,0.28512>,<0.25258,0.7793,0.29562>,<0.23683,0.78276,0.32115>,
              <0.22346,0.79027,0.34697>,<0.22017,0.7972,0.35792>,<0.22847,0.79879,0.34756>,
              <0.2431,0.79343,0.32189>,<0.25534,0.78401,0.29594><0.09057,0.92683,0.23425>,<0.08034,0.91993,0.23735>,<0.0557,0.90544,0.24711>,
              <0.03118,0.89421,0.26029>,<0.02112,0.8926,0.26896>,<0.0314,0.90102,0.26746>,
              <0.05599,0.91398,0.2561>,<0.08046,0.9237,0.24131><0.04419,0.90883,0.31523>,<0.03314,0.9049,0.3103>,<0.00758,0.89277,0.29973>,
              <-0.01629,0.87672,0.29114>,<-0.0246,0.86637,0.28945>,<-0.01276,0.86846,0.29531>,
              <0.01201,0.88243,0.30495>,<0.0351,0.90033,0.3126><0.03292,0.85056,0.29944>,<0.02055,0.84817,0.29762>,<-0.00936,0.84458,0.29547>,
              <-0.03936,0.84428,0.29671>,<-0.05187,0.84724,0.30041>,<-0.03954,0.85117,0.30382>,
              <-0.00959,0.85322,0.30438>,<0.02045,0.85198,0.30154><-0.08798,0.86815,0.23451>,<-0.0874,0.86417,0.24658>,<-0.08439,0.85234,0.2742>,
              <-0.07895,0.83717,0.29953>,<-0.07442,0.82775,0.30788>,<-0.07385,0.83017,0.29474>,
              <-0.078,0.84357,0.26819>,<-0.08458,0.8603,0.24393><-0.0159,0.77437,0.30612>,<-0.02785,0.77847,0.30463>,<-0.05597,0.78945,0.30388>,
              <-0.08299,0.80207,0.30742>,<-0.09314,0.80884,0.31291>,<-0.08067,0.8055,0.31641>,
              <-0.05306,0.79375,0.31515>,<-0.02657,0.78037,0.3096><-0.13657,0.80886,0.23905>,<-0.13519,0.80658,0.2515>,<-0.12953,0.79942,0.28028>,
              <-0.12034,0.78976,0.30719>,<-0.11321,0.78341,0.31656>,<-0.11292,0.78452,0.30323>,
              <-0.12024,0.79286,0.27533>,<-0.1311,0.80369,0.24931><-0.16316,0.71386,0.37555>,<-0.15528,0.72028,0.36789>,<-0.13908,0.7368,0.34848>,
              <-0.12711,0.75489,0.32772>,<-0.12614,0.76385,0.31783>,<-0.13601,0.75817,0.32485>,
              <-0.15022,0.74091,0.3449>,<-0.16019,0.72209,0.36631><-0.02465,0.89524,0.27888>,<-0.01454,0.90271,0.27691>,<0.0075,0.92282,0.27224>,
              <0.026,0.94603,0.2677>,<0.03032,0.95857,0.26593>,<0.01855,0.95255,0.26796>,
              <-0.00183,0.93099,0.27256>,<-0.01866,0.90632,0.27705><0.04062,0.91654,0.27789>,<0.03805,0.92826,0.27365>,<0.03058,0.95474,0.26119>,
              <0.02118,0.97849,0.24541>,<0.01548,0.98576,0.23574>,<0.01714,0.97276,0.23842>,
              <0.02551,0.94756,0.25243>,<0.03582,0.9251,0.26979><-0.03624,0.94282,0.16805>,<-0.02847,0.95097,0.17399>,<-0.01229,0.97236,0.18787>,
              <0,0.99636,0.20108>,<0.00145,1.00875,0.20592>,<-0.00814,1.00182,0.19967>,
              <-0.02249,0.97921,0.1861>,<-0.03296,0.95399,0.17321><0.04199,0.96651,0.21068>,<0.03501,0.97669,0.20761>,<0.01707,0.99911,0.19824>,
              <-0.00252,1.01823,0.18591>,<-0.01217,1.02307,0.17802>,<-0.00597,1.01134,0.17969>,
              <0.01275,0.99047,0.19045>,<0.03311,0.97289,0.20418><-0.08924,1.01678,0.10954>,<-0.07841,1.01638,0.11621>,<-0.05334,1.01828,0.13294>,
              <-0.02988,1.02451,0.15061>,<-0.02168,1.03117,0.15882>,<-0.03326,1.03361,0.15259>,
              <-0.05757,1.02967,0.13542>,<-0.08028,1.0214,0.1173><0.02281,0.97545,0.17261>,<0.01639,0.98602,0.16961>,<-0.00057,1.00935,0.16066>,
              <-0.01975,1.02938,0.14917>,<-0.02979,1.03459,0.14202>,<-0.02442,1.02247,0.14383>,
              <-0.00641,1.00069,0.15397>,<0.01382,0.9822,0.16666><-0.08706,1.00491,0.04253>,<-0.07987,1.00701,0.05281>,<-0.06373,1.01493,0.07708>,
              <-0.04944,1.02711,0.10051>,<-0.04525,1.03616,0.10943>,<-0.0533,1.03605,0.09875>,
              <-0.06857,1.02614,0.07487>,<-0.082,1.01195,0.05184><0.00609,1.01972,0.23832>,<0.01252,1.01163,0.24576>,<0.0302,0.99424,0.26299>,
              <0.05117,0.98006,0.27913>,<0.06295,0.9772,0.28479>,<0.05807,0.98679,0.27684>,
              <0.03884,1.00267,0.26012>,<0.01633,1.01535,0.24449><0.01556,0.97118,0.28587>,<0.02801,0.96881,0.28692>,<0.05746,0.96211,0.28654>,
              <0.08596,0.95395,0.28177>,<0.09687,0.94919,0.27567>,<0.08397,0.95088,0.27256>,
              <0.05497,0.95827,0.27501>,<0.02692,0.96712,0.28184><0.06587,0.95881,0.20523>,<0.07105,0.95313,0.21536>,<0.08569,0.94158,0.23913>,
              <0.10353,0.93334,0.26182>,<0.11393,0.93301,0.27022>,<0.11026,0.94025,0.25959>,
              <0.09412,0.95024,0.23633>,<0.07477,0.95694,0.21413><0.0465,0.92442,0.28682>,<0.05918,0.9236,0.28615>,<0.08893,0.92103,0.28159>,
              <0.11736,0.91756,0.27259>,<0.12791,0.91529,0.26469>,<0.11461,0.91568,0.26326>,
              <0.08548,0.91868,0.26991>,<0.05767,0.92257,0.281><0.09893,0.90004,0.18584>,<0.10349,0.89663,0.19722>,<0.1169,0.89004,0.22347>,
              <0.13389,0.88592,0.24788>,<0.14429,0.88653,0.25627>,<0.1414,0.8911,0.24403>,
              <0.12631,0.89653,0.21865>,<0.10764,0.89949,0.19509><0.08203,0.83063,0.28359>,<0.0936,0.83516,0.28085>,<0.1202,0.84589,0.27141>,
              <0.1448,0.85632,0.25771>,<0.15311,0.86034,0.24803>,<0.1406,0.85566,0.24877>,
              <0.11494,0.84508,0.26021>,<0.09128,0.8348,0.27591><0.10858,0.84034,0.17339>,<0.11371,0.83977,0.18502>,<0.12842,0.83958,0.21139>,
              <0.14665,0.84119,0.23519>,<0.15751,0.84356,0.24264>,<0.15404,0.84498,0.2298>,
              <0.13767,0.84432,0.20463>,<0.11779,0.84186,0.18204><0.08855,1.05687,0.2492>,<0.08038,1.05149,0.25734>,<0.06229,1.04045,0.27885>,
              <0.04665,1.03232,0.30316>,<0.04247,1.03169,0.31585>,<0.05179,1.03843,0.30902>,
              <0.06873,1.0481,0.2862>,<0.08322,1.05487,0.26058><0.01319,1.03315,0.25602>,<0.0142,1.03344,0.2687>,<0.01851,1.03174,0.29854>,
              <0.02562,1.02643,0.32722>,<0.03119,1.02082,0.33801>,<0.03149,1.01883,0.32479>,
              <0.02587,1.02223,0.29549>,<0.01744,1.02925,0.26735><0.08016,1.02329,0.27983>,<0.07061,1.02094,0.28791>,<0.04959,1.01682,0.3092>,
              <0.03166,1.01504,0.33322>,<0.02711,1.01649,0.34571>,<0.03811,1.01993,0.33891>,
              <0.05767,1.02296,0.31634>,<0.07417,1.02365,0.29106><-0.01404,0.99999,0.28898>,<-0.01162,1.00236,0.30125>,<-0.00376,1.00577,0.33021>,
              <0.00716,1.00572,0.35818>,<0.01455,1.00245,0.36884>,<0.01357,0.99846,0.35611>,
              <0.00427,0.99668,0.32761>,<-0.00808,0.99835,0.30011><0.06893,0.94348,0.37883>,<0.05642,0.94478,0.38072>,<0.02741,0.94961,0.38761>,
              <0.00024,0.95702,0.39801>,<-0.0093,0.96251,0.40561>,<0.00407,0.96242,0.40537>,
              <0.03222,0.95638,0.39683>,<0.05854,0.94776,0.38478><-0.0735,0.97202,0.35516>,<-0.06628,0.97024,0.36549>,<-0.04736,0.96428,0.38826>,
              <-0.02617,0.95577,0.40776>,<-0.01527,0.94986,0.41277>,<-0.02142,0.95044,0.4009>,
              <-0.0414,0.9576,0.37967>,<-0.06366,0.9673,0.36171><0.03496,0.88537,0.38101>,<0.02479,0.89205,0.38476>,<0.00237,0.90884,0.39604>,
              <-0.01687,0.92666,0.41066>,<-0.02186,0.93501,0.41984>,<-0.0102,0.92882,0.41765>,
              <0.01072,0.91154,0.40481>,<0.02848,0.89324,0.38863>     }
     face_indices { 5394
<0,1,7>,<1,6,7>,<1,2,6>,<2,5,6>,<2,3,5>,
              <3,4,5>
<8,9,15>,<9,14,15>,<9,10,14>,<10,13,14>,<10,11,13>,
              <11,12,13>
<16,17,23>,<17,22,23>,<17,18,22>,<18,21,22>,<18,19,21>,
              <19,20,21>
<24,25,31>,<25,30,31>,<25,26,30>,<26,29,30>,<26,27,29>,
              <27,28,29>
<32,33,39>,<33,38,39>,<33,34,38>,<34,37,38>,<34,35,37>,
              <35,36,37>
<40,41,47>,<41,46,47>,<41,42,46>,<42,45,46>,<42,43,45>,
              <43,44,45>
<48,49,55>,<49,54,55>,<49,50,54>,<50,53,54>,<50,51,53>,
              <51,52,53>
<56,57,63>,<57,62,63>,<57,58,62>,<58,61,62>,<58,59,61>,
              <59,60,61>
<64,65,71>,<65,70,71>,<65,66,70>,<66,69,70>,<66,67,69>,
              <67,68,69>
<72,73,79>,<73,78,79>,<73,74,78>,<74,77,78>,<74,75,77>,
              <75,76,77>
<80,81,87>,<81,86,87>,<81,82,86>,<82,85,86>,<82,83,85>,
              <83,84,85>
<88,89,95>,<89,94,95>,<89,90,94>,<90,93,94>,<90,91,93>,
              <91,92,93>
<96,97,103>,<97,102,103>,<97,98,102>,<98,101,102>,<98,99,101>,
              <99,100,101>
<104,105,111>,<105,110,111>,<105,106,110>,<106,109,110>,<106,107,109>,
              <107,108,109>
<112,113,119>,<113,118,119>,<113,114,118>,<114,117,118>,<114,115,117>,
              <115,116,117>
<120,121,127>,<121,126,127>,<121,122,126>,<122,125,126>,<122,123,125>,
              <123,124,125>
<128,129,135>,<129,134,135>,<129,130,134>,<130,133,134>,<130,131,133>,
              <131,132,133>
<136,137,143>,<137,142,143>,<137,138,142>,<138,141,142>,<138,139,141>,
              <139,140,141>
<144,145,151>,<145,150,151>,<145,146,150>,<146,149,150>,<146,147,149>,
              <147,148,149>
<152,153,159>,<153,158,159>,<153,154,158>,<154,157,158>,<154,155,157>,
              <155,156,157>
<160,161,167>,<161,166,167>,<161,162,166>,<162,165,166>,<162,163,165>,
              <163,164,165>
<168,169,175>,<169,174,175>,<169,170,174>,<170,173,174>,<170,171,173>,
              <171,172,173>
<176,177,183>,<177,182,183>,<177,178,182>,<178,181,182>,<178,179,181>,
              <179,180,181>
<184,185,191>,<185,190,191>,<185,186,190>,<186,189,190>,<186,187,189>,
              <187,188,189>
<192,193,199>,<193,198,199>,<193,194,198>,<194,197,198>,<194,195,197>,
              <195,196,197>
<200,201,207>,<201,206,207>,<201,202,206>,<202,205,206>,<202,203,205>,
              <203,204,205>
<208,209,215>,<209,214,215>,<209,210,214>,<210,213,214>,<210,211,213>,
              <211,212,213>
<216,217,223>,<217,222,223>,<217,218,222>,<218,221,222>,<218,219,221>,
              <219,220,221>
<224,225,231>,<225,230,231>,<225,226,230>,<226,229,230>,<226,227,229>,
              <227,228,229>
<232,233,239>,<233,238,239>,<233,234,238>,<234,237,238>,<234,235,237>,
              <235,236,237>
<240,241,247>,<241,246,247>,<241,242,246>,<242,245,246>,<242,243,245>,
              <243,244,245>
<248,249,255>,<249,254,255>,<249,250,254>,<250,253,254>,<250,251,253>,
              <251,252,253>
<256,257,263>,<257,262,263>,<257,258,262>,<258,261,262>,<258,259,261>,
              <259,260,261>
<264,265,271>,<265,270,271>,<265,266,270>,<266,269,270>,<266,267,269>,
              <267,268,269>
<272,273,279>,<273,278,279>,<273,274,278>,<274,277,278>,<274,275,277>,
              <275,276,277>
<280,281,287>,<281,286,287>,<281,282,286>,<282,285,286>,<282,283,285>,
              <283,284,285>
<288,289,295>,<289,294,295>,<289,290,294>,<290,293,294>,<290,291,293>,
              <291,292,293>
<296,297,303>,<297,302,303>,<297,298,302>,<298,301,302>,<298,299,301>,
              <299,300,301>
<304,305,311>,<305,310,311>,<305,306,310>,<306,309,310>,<306,307,309>,
              <307,308,309>
<312,313,319>,<313,318,319>,<313,314,318>,<314,317,318>,<314,315,317>,
              <315,316,317>
<320,321,327>,<321,326,327>,<321,322,326>,<322,325,326>,<322,323,325>,
              <323,324,325>
<328,329,335>,<329,334,335>,<329,330,334>,<330,333,334>,<330,331,333>,
              <331,332,333>
<336,337,343>,<337,342,343>,<337,338,342>,<338,341,342>,<338,339,341>,
              <339,340,341>
<344,345,351>,<345,350,351>,<345,346,350>,<346,349,350>,<346,347,349>,
              <347,348,349>
<352,353,359>,<353,358,359>,<353,354,358>,<354,357,358>,<354,355,357>,
              <355,356,357>
<360,361,367>,<361,366,367>,<361,362,366>,<362,365,366>,<362,363,365>,
              <363,364,365>
<368,369,375>,<369,374,375>,<369,370,374>,<370,373,374>,<370,371,373>,
              <371,372,373>
<376,377,383>,<377,382,383>,<377,378,382>,<378,381,382>,<378,379,381>,
              <379,380,381>
<384,385,391>,<385,390,391>,<385,386,390>,<386,389,390>,<386,387,389>,
              <387,388,389>
<392,393,399>,<393,398,399>,<393,394,398>,<394,397,398>,<394,395,397>,
              <395,396,397>
<400,401,407>,<401,406,407>,<401,402,406>,<402,405,406>,<402,403,405>,
              <403,404,405>
<408,409,415>,<409,414,415>,<409,410,414>,<410,413,414>,<410,411,413>,
              <411,412,413>
<416,417,423>,<417,422,423>,<417,418,422>,<418,421,422>,<418,419,421>,
              <419,420,421>
<424,425,431>,<425,430,431>,<425,426,430>,<426,429,430>,<426,427,429>,
              <427,428,429>
<432,433,439>,<433,438,439>,<433,434,438>,<434,437,438>,<434,435,437>,
              <435,436,437>
<440,441,447>,<441,446,447>,<441,442,446>,<442,445,446>,<442,443,445>,
              <443,444,445>
<448,449,455>,<449,454,455>,<449,450,454>,<450,453,454>,<450,451,453>,
              <451,452,453>
<456,457,463>,<457,462,463>,<457,458,462>,<458,461,462>,<458,459,461>,
              <459,460,461>
<464,465,471>,<465,470,471>,<465,466,470>,<466,469,470>,<466,467,469>,
              <467,468,469>
<472,473,479>,<473,478,479>,<473,474,478>,<474,477,478>,<474,475,477>,
              <475,476,477>
<480,481,487>,<481,486,487>,<481,482,486>,<482,485,486>,<482,483,485>,
              <483,484,485>
<488,489,495>,<489,494,495>,<489,490,494>,<490,493,494>,<490,491,493>,
              <491,492,493>
<496,497,503>,<497,502,503>,<497,498,502>,<498,501,502>,<498,499,501>,
              <499,500,501>
<504,505,511>,<505,510,511>,<505,506,510>,<506,509,510>,<506,507,509>,
              <507,508,509>
<512,513,519>,<513,518,519>,<513,514,518>,<514,517,518>,<514,515,517>,
              <515,516,517>
<520,521,527>,<521,526,527>,<521,522,526>,<522,525,526>,<522,523,525>,
              <523,524,525>
<528,529,535>,<529,534,535>,<529,530,534>,<530,533,534>,<530,531,533>,
              <531,532,533>
<536,537,543>,<537,542,543>,<537,538,542>,<538,541,542>,<538,539,541>,
              <539,540,541>
<544,545,551>,<545,550,551>,<545,546,550>,<546,549,550>,<546,547,549>,
              <547,548,549>
<552,553,559>,<553,558,559>,<553,554,558>,<554,557,558>,<554,555,557>,
              <555,556,557>
<560,561,567>,<561,566,567>,<561,562,566>,<562,565,566>,<562,563,565>,
              <563,564,565>
<568,569,575>,<569,574,575>,<569,570,574>,<570,573,574>,<570,571,573>,
              <571,572,573>
<576,577,583>,<577,582,583>,<577,578,582>,<578,581,582>,<578,579,581>,
              <579,580,581>
<584,585,591>,<585,590,591>,<585,586,590>,<586,589,590>,<586,587,589>,
              <587,588,589>
<592,593,599>,<593,598,599>,<593,594,598>,<594,597,598>,<594,595,597>,
              <595,596,597>
<600,601,607>,<601,606,607>,<601,602,606>,<602,605,606>,<602,603,605>,
              <603,604,605>
<608,609,615>,<609,614,615>,<609,610,614>,<610,613,614>,<610,611,613>,
              <611,612,613>
<616,617,623>,<617,622,623>,<617,618,622>,<618,621,622>,<618,619,621>,
              <619,620,621>
<624,625,631>,<625,630,631>,<625,626,630>,<626,629,630>,<626,627,629>,
              <627,628,629>
<632,633,639>,<633,638,639>,<633,634,638>,<634,637,638>,<634,635,637>,
              <635,636,637>
<640,641,647>,<641,646,647>,<641,642,646>,<642,645,646>,<642,643,645>,
              <643,644,645>
<648,649,655>,<649,654,655>,<649,650,654>,<650,653,654>,<650,651,653>,
              <651,652,653>
<656,657,663>,<657,662,663>,<657,658,662>,<658,661,662>,<658,659,661>,
              <659,660,661>
<664,665,671>,<665,670,671>,<665,666,670>,<666,669,670>,<666,667,669>,
              <667,668,669>
<672,673,679>,<673,678,679>,<673,674,678>,<674,677,678>,<674,675,677>,
              <675,676,677>
<680,681,687>,<681,686,687>,<681,682,686>,<682,685,686>,<682,683,685>,
              <683,684,685>
<688,689,695>,<689,694,695>,<689,690,694>,<690,693,694>,<690,691,693>,
              <691,692,693>
<696,697,703>,<697,702,703>,<697,698,702>,<698,701,702>,<698,699,701>,
              <699,700,701>
<704,705,711>,<705,710,711>,<705,706,710>,<706,709,710>,<706,707,709>,
              <707,708,709>
<712,713,719>,<713,718,719>,<713,714,718>,<714,717,718>,<714,715,717>,
              <715,716,717>
<720,721,727>,<721,726,727>,<721,722,726>,<722,725,726>,<722,723,725>,
              <723,724,725>
<728,729,735>,<729,734,735>,<729,730,734>,<730,733,734>,<730,731,733>,
              <731,732,733>
<736,737,743>,<737,742,743>,<737,738,742>,<738,741,742>,<738,739,741>,
              <739,740,741>
<744,745,751>,<745,750,751>,<745,746,750>,<746,749,750>,<746,747,749>,
              <747,748,749>
<752,753,759>,<753,758,759>,<753,754,758>,<754,757,758>,<754,755,757>,
              <755,756,757>
<760,761,767>,<761,766,767>,<761,762,766>,<762,765,766>,<762,763,765>,
              <763,764,765>
<768,769,775>,<769,774,775>,<769,770,774>,<770,773,774>,<770,771,773>,
              <771,772,773>
<776,777,783>,<777,782,783>,<777,778,782>,<778,781,782>,<778,779,781>,
              <779,780,781>
<784,785,791>,<785,790,791>,<785,786,790>,<786,789,790>,<786,787,789>,
              <787,788,789>
<792,793,799>,<793,798,799>,<793,794,798>,<794,797,798>,<794,795,797>,
              <795,796,797>
<800,801,807>,<801,806,807>,<801,802,806>,<802,805,806>,<802,803,805>,
              <803,804,805>
<808,809,815>,<809,814,815>,<809,810,814>,<810,813,814>,<810,811,813>,
              <811,812,813>
<816,817,823>,<817,822,823>,<817,818,822>,<818,821,822>,<818,819,821>,
              <819,820,821>
<824,825,831>,<825,830,831>,<825,826,830>,<826,829,830>,<826,827,829>,
              <827,828,829>
<832,833,839>,<833,838,839>,<833,834,838>,<834,837,838>,<834,835,837>,
              <835,836,837>
<840,841,847>,<841,846,847>,<841,842,846>,<842,845,846>,<842,843,845>,
              <843,844,845>
<848,849,855>,<849,854,855>,<849,850,854>,<850,853,854>,<850,851,853>,
              <851,852,853>
<856,857,863>,<857,862,863>,<857,858,862>,<858,861,862>,<858,859,861>,
              <859,860,861>
<864,865,871>,<865,870,871>,<865,866,870>,<866,869,870>,<866,867,869>,
              <867,868,869>
<872,873,879>,<873,878,879>,<873,874,878>,<874,877,878>,<874,875,877>,
              <875,876,877>
<880,881,887>,<881,886,887>,<881,882,886>,<882,885,886>,<882,883,885>,
              <883,884,885>
<888,889,895>,<889,894,895>,<889,890,894>,<890,893,894>,<890,891,893>,
              <891,892,893>
<896,897,903>,<897,902,903>,<897,898,902>,<898,901,902>,<898,899,901>,
              <899,900,901>
<904,905,911>,<905,910,911>,<905,906,910>,<906,909,910>,<906,907,909>,
              <907,908,909>
<912,913,919>,<913,918,919>,<913,914,918>,<914,917,918>,<914,915,917>,
              <915,916,917>
<920,921,927>,<921,926,927>,<921,922,926>,<922,925,926>,<922,923,925>,
              <923,924,925>
<928,929,935>,<929,934,935>,<929,930,934>,<930,933,934>,<930,931,933>,
              <931,932,933>
<936,937,943>,<937,942,943>,<937,938,942>,<938,941,942>,<938,939,941>,
              <939,940,941>
<944,945,951>,<945,950,951>,<945,946,950>,<946,949,950>,<946,947,949>,
              <947,948,949>
<952,953,959>,<953,958,959>,<953,954,958>,<954,957,958>,<954,955,957>,
              <955,956,957>
<960,961,967>,<961,966,967>,<961,962,966>,<962,965,966>,<962,963,965>,
              <963,964,965>
<968,969,975>,<969,974,975>,<969,970,974>,<970,973,974>,<970,971,973>,
              <971,972,973>
<976,977,983>,<977,982,983>,<977,978,982>,<978,981,982>,<978,979,981>,
              <979,980,981>
<984,985,991>,<985,990,991>,<985,986,990>,<986,989,990>,<986,987,989>,
              <987,988,989>
<992,993,999>,<993,998,999>,<993,994,998>,<994,997,998>,<994,995,997>,
              <995,996,997>
<1000,1001,1007>,<1001,1006,1007>,<1001,1002,1006>,<1002,1005,1006>,<1002,1003,1005>,
              <1003,1004,1005>
<1008,1009,1015>,<1009,1014,1015>,<1009,1010,1014>,<1010,1013,1014>,<1010,1011,1013>,
              <1011,1012,1013>
<1016,1017,1023>,<1017,1022,1023>,<1017,1018,1022>,<1018,1021,1022>,<1018,1019,1021>,
              <1019,1020,1021>
<1024,1025,1031>,<1025,1030,1031>,<1025,1026,1030>,<1026,1029,1030>,<1026,1027,1029>,
              <1027,1028,1029>
<1032,1033,1039>,<1033,1038,1039>,<1033,1034,1038>,<1034,1037,1038>,<1034,1035,1037>,
              <1035,1036,1037>
<1040,1041,1047>,<1041,1046,1047>,<1041,1042,1046>,<1042,1045,1046>,<1042,1043,1045>,
              <1043,1044,1045>
<1048,1049,1055>,<1049,1054,1055>,<1049,1050,1054>,<1050,1053,1054>,<1050,1051,1053>,
              <1051,1052,1053>
<1056,1057,1063>,<1057,1062,1063>,<1057,1058,1062>,<1058,1061,1062>,<1058,1059,1061>,
              <1059,1060,1061>
<1064,1065,1071>,<1065,1070,1071>,<1065,1066,1070>,<1066,1069,1070>,<1066,1067,1069>,
              <1067,1068,1069>
<1072,1073,1079>,<1073,1078,1079>,<1073,1074,1078>,<1074,1077,1078>,<1074,1075,1077>,
              <1075,1076,1077>
<1080,1081,1087>,<1081,1086,1087>,<1081,1082,1086>,<1082,1085,1086>,<1082,1083,1085>,
              <1083,1084,1085>
<1088,1089,1095>,<1089,1094,1095>,<1089,1090,1094>,<1090,1093,1094>,<1090,1091,1093>,
              <1091,1092,1093>
<1096,1097,1103>,<1097,1102,1103>,<1097,1098,1102>,<1098,1101,1102>,<1098,1099,1101>,
              <1099,1100,1101>
<1104,1105,1111>,<1105,1110,1111>,<1105,1106,1110>,<1106,1109,1110>,<1106,1107,1109>,
              <1107,1108,1109>
<1112,1113,1119>,<1113,1118,1119>,<1113,1114,1118>,<1114,1117,1118>,<1114,1115,1117>,
              <1115,1116,1117>
<1120,1121,1127>,<1121,1126,1127>,<1121,1122,1126>,<1122,1125,1126>,<1122,1123,1125>,
              <1123,1124,1125>
<1128,1129,1135>,<1129,1134,1135>,<1129,1130,1134>,<1130,1133,1134>,<1130,1131,1133>,
              <1131,1132,1133>
<1136,1137,1143>,<1137,1142,1143>,<1137,1138,1142>,<1138,1141,1142>,<1138,1139,1141>,
              <1139,1140,1141>
<1144,1145,1151>,<1145,1150,1151>,<1145,1146,1150>,<1146,1149,1150>,<1146,1147,1149>,
              <1147,1148,1149>
<1152,1153,1159>,<1153,1158,1159>,<1153,1154,1158>,<1154,1157,1158>,<1154,1155,1157>,
              <1155,1156,1157>
<1160,1161,1167>,<1161,1166,1167>,<1161,1162,1166>,<1162,1165,1166>,<1162,1163,1165>,
              <1163,1164,1165>
<1168,1169,1175>,<1169,1174,1175>,<1169,1170,1174>,<1170,1173,1174>,<1170,1171,1173>,
              <1171,1172,1173>
<1176,1177,1183>,<1177,1182,1183>,<1177,1178,1182>,<1178,1181,1182>,<1178,1179,1181>,
              <1179,1180,1181>
<1184,1185,1191>,<1185,1190,1191>,<1185,1186,1190>,<1186,1189,1190>,<1186,1187,1189>,
              <1187,1188,1189>
<1192,1193,1199>,<1193,1198,1199>,<1193,1194,1198>,<1194,1197,1198>,<1194,1195,1197>,
              <1195,1196,1197>
<1200,1201,1207>,<1201,1206,1207>,<1201,1202,1206>,<1202,1205,1206>,<1202,1203,1205>,
              <1203,1204,1205>
<1208,1209,1215>,<1209,1214,1215>,<1209,1210,1214>,<1210,1213,1214>,<1210,1211,1213>,
              <1211,1212,1213>
<1216,1217,1223>,<1217,1222,1223>,<1217,1218,1222>,<1218,1221,1222>,<1218,1219,1221>,
              <1219,1220,1221>
<1224,1225,1231>,<1225,1230,1231>,<1225,1226,1230>,<1226,1229,1230>,<1226,1227,1229>,
              <1227,1228,1229>
<1232,1233,1239>,<1233,1238,1239>,<1233,1234,1238>,<1234,1237,1238>,<1234,1235,1237>,
              <1235,1236,1237>
<1240,1241,1247>,<1241,1246,1247>,<1241,1242,1246>,<1242,1245,1246>,<1242,1243,1245>,
              <1243,1244,1245>
<1248,1249,1255>,<1249,1254,1255>,<1249,1250,1254>,<1250,1253,1254>,<1250,1251,1253>,
              <1251,1252,1253>
<1256,1257,1263>,<1257,1262,1263>,<1257,1258,1262>,<1258,1261,1262>,<1258,1259,1261>,
              <1259,1260,1261>
<1264,1265,1271>,<1265,1270,1271>,<1265,1266,1270>,<1266,1269,1270>,<1266,1267,1269>,
              <1267,1268,1269>
<1272,1273,1279>,<1273,1278,1279>,<1273,1274,1278>,<1274,1277,1278>,<1274,1275,1277>,
              <1275,1276,1277>
<1280,1281,1287>,<1281,1286,1287>,<1281,1282,1286>,<1282,1285,1286>,<1282,1283,1285>,
              <1283,1284,1285>
<1288,1289,1295>,<1289,1294,1295>,<1289,1290,1294>,<1290,1293,1294>,<1290,1291,1293>,
              <1291,1292,1293>
<1296,1297,1303>,<1297,1302,1303>,<1297,1298,1302>,<1298,1301,1302>,<1298,1299,1301>,
              <1299,1300,1301>
<1304,1305,1311>,<1305,1310,1311>,<1305,1306,1310>,<1306,1309,1310>,<1306,1307,1309>,
              <1307,1308,1309>
<1312,1313,1319>,<1313,1318,1319>,<1313,1314,1318>,<1314,1317,1318>,<1314,1315,1317>,
              <1315,1316,1317>
<1320,1321,1327>,<1321,1326,1327>,<1321,1322,1326>,<1322,1325,1326>,<1322,1323,1325>,
              <1323,1324,1325>
<1328,1329,1335>,<1329,1334,1335>,<1329,1330,1334>,<1330,1333,1334>,<1330,1331,1333>,
              <1331,1332,1333>
<1336,1337,1343>,<1337,1342,1343>,<1337,1338,1342>,<1338,1341,1342>,<1338,1339,1341>,
              <1339,1340,1341>
<1344,1345,1351>,<1345,1350,1351>,<1345,1346,1350>,<1346,1349,1350>,<1346,1347,1349>,
              <1347,1348,1349>
<1352,1353,1359>,<1353,1358,1359>,<1353,1354,1358>,<1354,1357,1358>,<1354,1355,1357>,
              <1355,1356,1357>
<1360,1361,1367>,<1361,1366,1367>,<1361,1362,1366>,<1362,1365,1366>,<1362,1363,1365>,
              <1363,1364,1365>
<1368,1369,1375>,<1369,1374,1375>,<1369,1370,1374>,<1370,1373,1374>,<1370,1371,1373>,
              <1371,1372,1373>
<1376,1377,1383>,<1377,1382,1383>,<1377,1378,1382>,<1378,1381,1382>,<1378,1379,1381>,
              <1379,1380,1381>
<1384,1385,1391>,<1385,1390,1391>,<1385,1386,1390>,<1386,1389,1390>,<1386,1387,1389>,
              <1387,1388,1389>
<1392,1393,1399>,<1393,1398,1399>,<1393,1394,1398>,<1394,1397,1398>,<1394,1395,1397>,
              <1395,1396,1397>
<1400,1401,1407>,<1401,1406,1407>,<1401,1402,1406>,<1402,1405,1406>,<1402,1403,1405>,
              <1403,1404,1405>
<1408,1409,1415>,<1409,1414,1415>,<1409,1410,1414>,<1410,1413,1414>,<1410,1411,1413>,
              <1411,1412,1413>
<1416,1417,1423>,<1417,1422,1423>,<1417,1418,1422>,<1418,1421,1422>,<1418,1419,1421>,
              <1419,1420,1421>
<1424,1425,1431>,<1425,1430,1431>,<1425,1426,1430>,<1426,1429,1430>,<1426,1427,1429>,
              <1427,1428,1429>
<1432,1433,1439>,<1433,1438,1439>,<1433,1434,1438>,<1434,1437,1438>,<1434,1435,1437>,
              <1435,1436,1437>
<1440,1441,1447>,<1441,1446,1447>,<1441,1442,1446>,<1442,1445,1446>,<1442,1443,1445>,
              <1443,1444,1445>
<1448,1449,1455>,<1449,1454,1455>,<1449,1450,1454>,<1450,1453,1454>,<1450,1451,1453>,
              <1451,1452,1453>
<1456,1457,1463>,<1457,1462,1463>,<1457,1458,1462>,<1458,1461,1462>,<1458,1459,1461>,
              <1459,1460,1461>
<1464,1465,1471>,<1465,1470,1471>,<1465,1466,1470>,<1466,1469,1470>,<1466,1467,1469>,
              <1467,1468,1469>
<1472,1473,1479>,<1473,1478,1479>,<1473,1474,1478>,<1474,1477,1478>,<1474,1475,1477>,
              <1475,1476,1477>
<1480,1481,1487>,<1481,1486,1487>,<1481,1482,1486>,<1482,1485,1486>,<1482,1483,1485>,
              <1483,1484,1485>
<1488,1489,1495>,<1489,1494,1495>,<1489,1490,1494>,<1490,1493,1494>,<1490,1491,1493>,
              <1491,1492,1493>
<1496,1497,1503>,<1497,1502,1503>,<1497,1498,1502>,<1498,1501,1502>,<1498,1499,1501>,
              <1499,1500,1501>
<1504,1505,1511>,<1505,1510,1511>,<1505,1506,1510>,<1506,1509,1510>,<1506,1507,1509>,
              <1507,1508,1509>
<1512,1513,1519>,<1513,1518,1519>,<1513,1514,1518>,<1514,1517,1518>,<1514,1515,1517>,
              <1515,1516,1517>
<1520,1521,1527>,<1521,1526,1527>,<1521,1522,1526>,<1522,1525,1526>,<1522,1523,1525>,
              <1523,1524,1525>
<1528,1529,1535>,<1529,1534,1535>,<1529,1530,1534>,<1530,1533,1534>,<1530,1531,1533>,
              <1531,1532,1533>
<1536,1537,1543>,<1537,1542,1543>,<1537,1538,1542>,<1538,1541,1542>,<1538,1539,1541>,
              <1539,1540,1541>
<1544,1545,1551>,<1545,1550,1551>,<1545,1546,1550>,<1546,1549,1550>,<1546,1547,1549>,
              <1547,1548,1549>
<1552,1553,1559>,<1553,1558,1559>,<1553,1554,1558>,<1554,1557,1558>,<1554,1555,1557>,
              <1555,1556,1557>
<1560,1561,1567>,<1561,1566,1567>,<1561,1562,1566>,<1562,1565,1566>,<1562,1563,1565>,
              <1563,1564,1565>
<1568,1569,1575>,<1569,1574,1575>,<1569,1570,1574>,<1570,1573,1574>,<1570,1571,1573>,
              <1571,1572,1573>
<1576,1577,1583>,<1577,1582,1583>,<1577,1578,1582>,<1578,1581,1582>,<1578,1579,1581>,
              <1579,1580,1581>
<1584,1585,1591>,<1585,1590,1591>,<1585,1586,1590>,<1586,1589,1590>,<1586,1587,1589>,
              <1587,1588,1589>
<1592,1593,1599>,<1593,1598,1599>,<1593,1594,1598>,<1594,1597,1598>,<1594,1595,1597>,
              <1595,1596,1597>
<1600,1601,1607>,<1601,1606,1607>,<1601,1602,1606>,<1602,1605,1606>,<1602,1603,1605>,
              <1603,1604,1605>
<1608,1609,1615>,<1609,1614,1615>,<1609,1610,1614>,<1610,1613,1614>,<1610,1611,1613>,
              <1611,1612,1613>
<1616,1617,1623>,<1617,1622,1623>,<1617,1618,1622>,<1618,1621,1622>,<1618,1619,1621>,
              <1619,1620,1621>
<1624,1625,1631>,<1625,1630,1631>,<1625,1626,1630>,<1626,1629,1630>,<1626,1627,1629>,
              <1627,1628,1629>
<1632,1633,1639>,<1633,1638,1639>,<1633,1634,1638>,<1634,1637,1638>,<1634,1635,1637>,
              <1635,1636,1637>
<1640,1641,1647>,<1641,1646,1647>,<1641,1642,1646>,<1642,1645,1646>,<1642,1643,1645>,
              <1643,1644,1645>
<1648,1649,1655>,<1649,1654,1655>,<1649,1650,1654>,<1650,1653,1654>,<1650,1651,1653>,
              <1651,1652,1653>
<1656,1657,1663>,<1657,1662,1663>,<1657,1658,1662>,<1658,1661,1662>,<1658,1659,1661>,
              <1659,1660,1661>
<1664,1665,1671>,<1665,1670,1671>,<1665,1666,1670>,<1666,1669,1670>,<1666,1667,1669>,
              <1667,1668,1669>
<1672,1673,1679>,<1673,1678,1679>,<1673,1674,1678>,<1674,1677,1678>,<1674,1675,1677>,
              <1675,1676,1677>
<1680,1681,1687>,<1681,1686,1687>,<1681,1682,1686>,<1682,1685,1686>,<1682,1683,1685>,
              <1683,1684,1685>
<1688,1689,1695>,<1689,1694,1695>,<1689,1690,1694>,<1690,1693,1694>,<1690,1691,1693>,
              <1691,1692,1693>
<1696,1697,1703>,<1697,1702,1703>,<1697,1698,1702>,<1698,1701,1702>,<1698,1699,1701>,
              <1699,1700,1701>
<1704,1705,1711>,<1705,1710,1711>,<1705,1706,1710>,<1706,1709,1710>,<1706,1707,1709>,
              <1707,1708,1709>
<1712,1713,1719>,<1713,1718,1719>,<1713,1714,1718>,<1714,1717,1718>,<1714,1715,1717>,
              <1715,1716,1717>
<1720,1721,1727>,<1721,1726,1727>,<1721,1722,1726>,<1722,1725,1726>,<1722,1723,1725>,
              <1723,1724,1725>
<1728,1729,1735>,<1729,1734,1735>,<1729,1730,1734>,<1730,1733,1734>,<1730,1731,1733>,
              <1731,1732,1733>
<1736,1737,1743>,<1737,1742,1743>,<1737,1738,1742>,<1738,1741,1742>,<1738,1739,1741>,
              <1739,1740,1741>
<1744,1745,1751>,<1745,1750,1751>,<1745,1746,1750>,<1746,1749,1750>,<1746,1747,1749>,
              <1747,1748,1749>
<1752,1753,1759>,<1753,1758,1759>,<1753,1754,1758>,<1754,1757,1758>,<1754,1755,1757>,
              <1755,1756,1757>
<1760,1761,1767>,<1761,1766,1767>,<1761,1762,1766>,<1762,1765,1766>,<1762,1763,1765>,
              <1763,1764,1765>
<1768,1769,1775>,<1769,1774,1775>,<1769,1770,1774>,<1770,1773,1774>,<1770,1771,1773>,
              <1771,1772,1773>
<1776,1777,1783>,<1777,1782,1783>,<1777,1778,1782>,<1778,1781,1782>,<1778,1779,1781>,
              <1779,1780,1781>
<1784,1785,1791>,<1785,1790,1791>,<1785,1786,1790>,<1786,1789,1790>,<1786,1787,1789>,
              <1787,1788,1789>
<1792,1793,1799>,<1793,1798,1799>,<1793,1794,1798>,<1794,1797,1798>,<1794,1795,1797>,
              <1795,1796,1797>
<1800,1801,1807>,<1801,1806,1807>,<1801,1802,1806>,<1802,1805,1806>,<1802,1803,1805>,
              <1803,1804,1805>
<1808,1809,1815>,<1809,1814,1815>,<1809,1810,1814>,<1810,1813,1814>,<1810,1811,1813>,
              <1811,1812,1813>
<1816,1817,1823>,<1817,1822,1823>,<1817,1818,1822>,<1818,1821,1822>,<1818,1819,1821>,
              <1819,1820,1821>
<1824,1825,1831>,<1825,1830,1831>,<1825,1826,1830>,<1826,1829,1830>,<1826,1827,1829>,
              <1827,1828,1829>
<1832,1833,1839>,<1833,1838,1839>,<1833,1834,1838>,<1834,1837,1838>,<1834,1835,1837>,
              <1835,1836,1837>
<1840,1841,1847>,<1841,1846,1847>,<1841,1842,1846>,<1842,1845,1846>,<1842,1843,1845>,
              <1843,1844,1845>
<1848,1849,1855>,<1849,1854,1855>,<1849,1850,1854>,<1850,1853,1854>,<1850,1851,1853>,
              <1851,1852,1853>
<1856,1857,1863>,<1857,1862,1863>,<1857,1858,1862>,<1858,1861,1862>,<1858,1859,1861>,
              <1859,1860,1861>
<1864,1865,1871>,<1865,1870,1871>,<1865,1866,1870>,<1866,1869,1870>,<1866,1867,1869>,
              <1867,1868,1869>
<1872,1873,1879>,<1873,1878,1879>,<1873,1874,1878>,<1874,1877,1878>,<1874,1875,1877>,
              <1875,1876,1877>
<1880,1881,1887>,<1881,1886,1887>,<1881,1882,1886>,<1882,1885,1886>,<1882,1883,1885>,
              <1883,1884,1885>
<1888,1889,1895>,<1889,1894,1895>,<1889,1890,1894>,<1890,1893,1894>,<1890,1891,1893>,
              <1891,1892,1893>
<1896,1897,1903>,<1897,1902,1903>,<1897,1898,1902>,<1898,1901,1902>,<1898,1899,1901>,
              <1899,1900,1901>
<1904,1905,1911>,<1905,1910,1911>,<1905,1906,1910>,<1906,1909,1910>,<1906,1907,1909>,
              <1907,1908,1909>
<1912,1913,1919>,<1913,1918,1919>,<1913,1914,1918>,<1914,1917,1918>,<1914,1915,1917>,
              <1915,1916,1917>
<1920,1921,1927>,<1921,1926,1927>,<1921,1922,1926>,<1922,1925,1926>,<1922,1923,1925>,
              <1923,1924,1925>
<1928,1929,1935>,<1929,1934,1935>,<1929,1930,1934>,<1930,1933,1934>,<1930,1931,1933>,
              <1931,1932,1933>
<1936,1937,1943>,<1937,1942,1943>,<1937,1938,1942>,<1938,1941,1942>,<1938,1939,1941>,
              <1939,1940,1941>
<1944,1945,1951>,<1945,1950,1951>,<1945,1946,1950>,<1946,1949,1950>,<1946,1947,1949>,
              <1947,1948,1949>
<1952,1953,1959>,<1953,1958,1959>,<1953,1954,1958>,<1954,1957,1958>,<1954,1955,1957>,
              <1955,1956,1957>
<1960,1961,1967>,<1961,1966,1967>,<1961,1962,1966>,<1962,1965,1966>,<1962,1963,1965>,
              <1963,1964,1965>
<1968,1969,1975>,<1969,1974,1975>,<1969,1970,1974>,<1970,1973,1974>,<1970,1971,1973>,
              <1971,1972,1973>
<1976,1977,1983>,<1977,1982,1983>,<1977,1978,1982>,<1978,1981,1982>,<1978,1979,1981>,
              <1979,1980,1981>
<1984,1985,1991>,<1985,1990,1991>,<1985,1986,1990>,<1986,1989,1990>,<1986,1987,1989>,
              <1987,1988,1989>
<1992,1993,1999>,<1993,1998,1999>,<1993,1994,1998>,<1994,1997,1998>,<1994,1995,1997>,
              <1995,1996,1997>
<2000,2001,2007>,<2001,2006,2007>,<2001,2002,2006>,<2002,2005,2006>,<2002,2003,2005>,
              <2003,2004,2005>
<2008,2009,2015>,<2009,2014,2015>,<2009,2010,2014>,<2010,2013,2014>,<2010,2011,2013>,
              <2011,2012,2013>
<2016,2017,2023>,<2017,2022,2023>,<2017,2018,2022>,<2018,2021,2022>,<2018,2019,2021>,
              <2019,2020,2021>
<2024,2025,2031>,<2025,2030,2031>,<2025,2026,2030>,<2026,2029,2030>,<2026,2027,2029>,
              <2027,2028,2029>
<2032,2033,2039>,<2033,2038,2039>,<2033,2034,2038>,<2034,2037,2038>,<2034,2035,2037>,
              <2035,2036,2037>
<2040,2041,2047>,<2041,2046,2047>,<2041,2042,2046>,<2042,2045,2046>,<2042,2043,2045>,
              <2043,2044,2045>
<2048,2049,2055>,<2049,2054,2055>,<2049,2050,2054>,<2050,2053,2054>,<2050,2051,2053>,
              <2051,2052,2053>
<2056,2057,2063>,<2057,2062,2063>,<2057,2058,2062>,<2058,2061,2062>,<2058,2059,2061>,
              <2059,2060,2061>
<2064,2065,2071>,<2065,2070,2071>,<2065,2066,2070>,<2066,2069,2070>,<2066,2067,2069>,
              <2067,2068,2069>
<2072,2073,2079>,<2073,2078,2079>,<2073,2074,2078>,<2074,2077,2078>,<2074,2075,2077>,
              <2075,2076,2077>
<2080,2081,2087>,<2081,2086,2087>,<2081,2082,2086>,<2082,2085,2086>,<2082,2083,2085>,
              <2083,2084,2085>
<2088,2089,2095>,<2089,2094,2095>,<2089,2090,2094>,<2090,2093,2094>,<2090,2091,2093>,
              <2091,2092,2093>
<2096,2097,2103>,<2097,2102,2103>,<2097,2098,2102>,<2098,2101,2102>,<2098,2099,2101>,
              <2099,2100,2101>
<2104,2105,2111>,<2105,2110,2111>,<2105,2106,2110>,<2106,2109,2110>,<2106,2107,2109>,
              <2107,2108,2109>
<2112,2113,2119>,<2113,2118,2119>,<2113,2114,2118>,<2114,2117,2118>,<2114,2115,2117>,
              <2115,2116,2117>
<2120,2121,2127>,<2121,2126,2127>,<2121,2122,2126>,<2122,2125,2126>,<2122,2123,2125>,
              <2123,2124,2125>
<2128,2129,2135>,<2129,2134,2135>,<2129,2130,2134>,<2130,2133,2134>,<2130,2131,2133>,
              <2131,2132,2133>
<2136,2137,2143>,<2137,2142,2143>,<2137,2138,2142>,<2138,2141,2142>,<2138,2139,2141>,
              <2139,2140,2141>
<2144,2145,2151>,<2145,2150,2151>,<2145,2146,2150>,<2146,2149,2150>,<2146,2147,2149>,
              <2147,2148,2149>
<2152,2153,2159>,<2153,2158,2159>,<2153,2154,2158>,<2154,2157,2158>,<2154,2155,2157>,
              <2155,2156,2157>
<2160,2161,2167>,<2161,2166,2167>,<2161,2162,2166>,<2162,2165,2166>,<2162,2163,2165>,
              <2163,2164,2165>
<2168,2169,2175>,<2169,2174,2175>,<2169,2170,2174>,<2170,2173,2174>,<2170,2171,2173>,
              <2171,2172,2173>
<2176,2177,2183>,<2177,2182,2183>,<2177,2178,2182>,<2178,2181,2182>,<2178,2179,2181>,
              <2179,2180,2181>
<2184,2185,2191>,<2185,2190,2191>,<2185,2186,2190>,<2186,2189,2190>,<2186,2187,2189>,
              <2187,2188,2189>
<2192,2193,2199>,<2193,2198,2199>,<2193,2194,2198>,<2194,2197,2198>,<2194,2195,2197>,
              <2195,2196,2197>
<2200,2201,2207>,<2201,2206,2207>,<2201,2202,2206>,<2202,2205,2206>,<2202,2203,2205>,
              <2203,2204,2205>
<2208,2209,2215>,<2209,2214,2215>,<2209,2210,2214>,<2210,2213,2214>,<2210,2211,2213>,
              <2211,2212,2213>
<2216,2217,2223>,<2217,2222,2223>,<2217,2218,2222>,<2218,2221,2222>,<2218,2219,2221>,
              <2219,2220,2221>
<2224,2225,2231>,<2225,2230,2231>,<2225,2226,2230>,<2226,2229,2230>,<2226,2227,2229>,
              <2227,2228,2229>
<2232,2233,2239>,<2233,2238,2239>,<2233,2234,2238>,<2234,2237,2238>,<2234,2235,2237>,
              <2235,2236,2237>
<2240,2241,2247>,<2241,2246,2247>,<2241,2242,2246>,<2242,2245,2246>,<2242,2243,2245>,
              <2243,2244,2245>
<2248,2249,2255>,<2249,2254,2255>,<2249,2250,2254>,<2250,2253,2254>,<2250,2251,2253>,
              <2251,2252,2253>
<2256,2257,2263>,<2257,2262,2263>,<2257,2258,2262>,<2258,2261,2262>,<2258,2259,2261>,
              <2259,2260,2261>
<2264,2265,2271>,<2265,2270,2271>,<2265,2266,2270>,<2266,2269,2270>,<2266,2267,2269>,
              <2267,2268,2269>
<2272,2273,2279>,<2273,2278,2279>,<2273,2274,2278>,<2274,2277,2278>,<2274,2275,2277>,
              <2275,2276,2277>
<2280,2281,2287>,<2281,2286,2287>,<2281,2282,2286>,<2282,2285,2286>,<2282,2283,2285>,
              <2283,2284,2285>
<2288,2289,2295>,<2289,2294,2295>,<2289,2290,2294>,<2290,2293,2294>,<2290,2291,2293>,
              <2291,2292,2293>
<2296,2297,2303>,<2297,2302,2303>,<2297,2298,2302>,<2298,2301,2302>,<2298,2299,2301>,
              <2299,2300,2301>
<2304,2305,2311>,<2305,2310,2311>,<2305,2306,2310>,<2306,2309,2310>,<2306,2307,2309>,
              <2307,2308,2309>
<2312,2313,2319>,<2313,2318,2319>,<2313,2314,2318>,<2314,2317,2318>,<2314,2315,2317>,
              <2315,2316,2317>
<2320,2321,2327>,<2321,2326,2327>,<2321,2322,2326>,<2322,2325,2326>,<2322,2323,2325>,
              <2323,2324,2325>
<2328,2329,2335>,<2329,2334,2335>,<2329,2330,2334>,<2330,2333,2334>,<2330,2331,2333>,
              <2331,2332,2333>
<2336,2337,2343>,<2337,2342,2343>,<2337,2338,2342>,<2338,2341,2342>,<2338,2339,2341>,
              <2339,2340,2341>
<2344,2345,2351>,<2345,2350,2351>,<2345,2346,2350>,<2346,2349,2350>,<2346,2347,2349>,
              <2347,2348,2349>
<2352,2353,2359>,<2353,2358,2359>,<2353,2354,2358>,<2354,2357,2358>,<2354,2355,2357>,
              <2355,2356,2357>
<2360,2361,2367>,<2361,2366,2367>,<2361,2362,2366>,<2362,2365,2366>,<2362,2363,2365>,
              <2363,2364,2365>
<2368,2369,2375>,<2369,2374,2375>,<2369,2370,2374>,<2370,2373,2374>,<2370,2371,2373>,
              <2371,2372,2373>
<2376,2377,2383>,<2377,2382,2383>,<2377,2378,2382>,<2378,2381,2382>,<2378,2379,2381>,
              <2379,2380,2381>
<2384,2385,2391>,<2385,2390,2391>,<2385,2386,2390>,<2386,2389,2390>,<2386,2387,2389>,
              <2387,2388,2389>
<2392,2393,2399>,<2393,2398,2399>,<2393,2394,2398>,<2394,2397,2398>,<2394,2395,2397>,
              <2395,2396,2397>
<2400,2401,2407>,<2401,2406,2407>,<2401,2402,2406>,<2402,2405,2406>,<2402,2403,2405>,
              <2403,2404,2405>
<2408,2409,2415>,<2409,2414,2415>,<2409,2410,2414>,<2410,2413,2414>,<2410,2411,2413>,
              <2411,2412,2413>
<2416,2417,2423>,<2417,2422,2423>,<2417,2418,2422>,<2418,2421,2422>,<2418,2419,2421>,
              <2419,2420,2421>
<2424,2425,2431>,<2425,2430,2431>,<2425,2426,2430>,<2426,2429,2430>,<2426,2427,2429>,
              <2427,2428,2429>
<2432,2433,2439>,<2433,2438,2439>,<2433,2434,2438>,<2434,2437,2438>,<2434,2435,2437>,
              <2435,2436,2437>
<2440,2441,2447>,<2441,2446,2447>,<2441,2442,2446>,<2442,2445,2446>,<2442,2443,2445>,
              <2443,2444,2445>
<2448,2449,2455>,<2449,2454,2455>,<2449,2450,2454>,<2450,2453,2454>,<2450,2451,2453>,
              <2451,2452,2453>
<2456,2457,2463>,<2457,2462,2463>,<2457,2458,2462>,<2458,2461,2462>,<2458,2459,2461>,
              <2459,2460,2461>
<2464,2465,2471>,<2465,2470,2471>,<2465,2466,2470>,<2466,2469,2470>,<2466,2467,2469>,
              <2467,2468,2469>
<2472,2473,2479>,<2473,2478,2479>,<2473,2474,2478>,<2474,2477,2478>,<2474,2475,2477>,
              <2475,2476,2477>
<2480,2481,2487>,<2481,2486,2487>,<2481,2482,2486>,<2482,2485,2486>,<2482,2483,2485>,
              <2483,2484,2485>
<2488,2489,2495>,<2489,2494,2495>,<2489,2490,2494>,<2490,2493,2494>,<2490,2491,2493>,
              <2491,2492,2493>
<2496,2497,2503>,<2497,2502,2503>,<2497,2498,2502>,<2498,2501,2502>,<2498,2499,2501>,
              <2499,2500,2501>
<2504,2505,2511>,<2505,2510,2511>,<2505,2506,2510>,<2506,2509,2510>,<2506,2507,2509>,
              <2507,2508,2509>
<2512,2513,2519>,<2513,2518,2519>,<2513,2514,2518>,<2514,2517,2518>,<2514,2515,2517>,
              <2515,2516,2517>
<2520,2521,2527>,<2521,2526,2527>,<2521,2522,2526>,<2522,2525,2526>,<2522,2523,2525>,
              <2523,2524,2525>
<2528,2529,2535>,<2529,2534,2535>,<2529,2530,2534>,<2530,2533,2534>,<2530,2531,2533>,
              <2531,2532,2533>
<2536,2537,2543>,<2537,2542,2543>,<2537,2538,2542>,<2538,2541,2542>,<2538,2539,2541>,
              <2539,2540,2541>
<2544,2545,2551>,<2545,2550,2551>,<2545,2546,2550>,<2546,2549,2550>,<2546,2547,2549>,
              <2547,2548,2549>
<2552,2553,2559>,<2553,2558,2559>,<2553,2554,2558>,<2554,2557,2558>,<2554,2555,2557>,
              <2555,2556,2557>
<2560,2561,2567>,<2561,2566,2567>,<2561,2562,2566>,<2562,2565,2566>,<2562,2563,2565>,
              <2563,2564,2565>
<2568,2569,2575>,<2569,2574,2575>,<2569,2570,2574>,<2570,2573,2574>,<2570,2571,2573>,
              <2571,2572,2573>
<2576,2577,2583>,<2577,2582,2583>,<2577,2578,2582>,<2578,2581,2582>,<2578,2579,2581>,
              <2579,2580,2581>
<2584,2585,2591>,<2585,2590,2591>,<2585,2586,2590>,<2586,2589,2590>,<2586,2587,2589>,
              <2587,2588,2589>
<2592,2593,2599>,<2593,2598,2599>,<2593,2594,2598>,<2594,2597,2598>,<2594,2595,2597>,
              <2595,2596,2597>
<2600,2601,2607>,<2601,2606,2607>,<2601,2602,2606>,<2602,2605,2606>,<2602,2603,2605>,
              <2603,2604,2605>
<2608,2609,2615>,<2609,2614,2615>,<2609,2610,2614>,<2610,2613,2614>,<2610,2611,2613>,
              <2611,2612,2613>
<2616,2617,2623>,<2617,2622,2623>,<2617,2618,2622>,<2618,2621,2622>,<2618,2619,2621>,
              <2619,2620,2621>
<2624,2625,2631>,<2625,2630,2631>,<2625,2626,2630>,<2626,2629,2630>,<2626,2627,2629>,
              <2627,2628,2629>
<2632,2633,2639>,<2633,2638,2639>,<2633,2634,2638>,<2634,2637,2638>,<2634,2635,2637>,
              <2635,2636,2637>
<2640,2641,2647>,<2641,2646,2647>,<2641,2642,2646>,<2642,2645,2646>,<2642,2643,2645>,
              <2643,2644,2645>
<2648,2649,2655>,<2649,2654,2655>,<2649,2650,2654>,<2650,2653,2654>,<2650,2651,2653>,
              <2651,2652,2653>
<2656,2657,2663>,<2657,2662,2663>,<2657,2658,2662>,<2658,2661,2662>,<2658,2659,2661>,
              <2659,2660,2661>
<2664,2665,2671>,<2665,2670,2671>,<2665,2666,2670>,<2666,2669,2670>,<2666,2667,2669>,
              <2667,2668,2669>
<2672,2673,2679>,<2673,2678,2679>,<2673,2674,2678>,<2674,2677,2678>,<2674,2675,2677>,
              <2675,2676,2677>
<2680,2681,2687>,<2681,2686,2687>,<2681,2682,2686>,<2682,2685,2686>,<2682,2683,2685>,
              <2683,2684,2685>
<2688,2689,2695>,<2689,2694,2695>,<2689,2690,2694>,<2690,2693,2694>,<2690,2691,2693>,
              <2691,2692,2693>
<2696,2697,2703>,<2697,2702,2703>,<2697,2698,2702>,<2698,2701,2702>,<2698,2699,2701>,
              <2699,2700,2701>
<2704,2705,2711>,<2705,2710,2711>,<2705,2706,2710>,<2706,2709,2710>,<2706,2707,2709>,
              <2707,2708,2709>
<2712,2713,2719>,<2713,2718,2719>,<2713,2714,2718>,<2714,2717,2718>,<2714,2715,2717>,
              <2715,2716,2717>
<2720,2721,2727>,<2721,2726,2727>,<2721,2722,2726>,<2722,2725,2726>,<2722,2723,2725>,
              <2723,2724,2725>
<2728,2729,2735>,<2729,2734,2735>,<2729,2730,2734>,<2730,2733,2734>,<2730,2731,2733>,
              <2731,2732,2733>
<2736,2737,2743>,<2737,2742,2743>,<2737,2738,2742>,<2738,2741,2742>,<2738,2739,2741>,
              <2739,2740,2741>
<2744,2745,2751>,<2745,2750,2751>,<2745,2746,2750>,<2746,2749,2750>,<2746,2747,2749>,
              <2747,2748,2749>
<2752,2753,2759>,<2753,2758,2759>,<2753,2754,2758>,<2754,2757,2758>,<2754,2755,2757>,
              <2755,2756,2757>
<2760,2761,2767>,<2761,2766,2767>,<2761,2762,2766>,<2762,2765,2766>,<2762,2763,2765>,
              <2763,2764,2765>
<2768,2769,2775>,<2769,2774,2775>,<2769,2770,2774>,<2770,2773,2774>,<2770,2771,2773>,
              <2771,2772,2773>
<2776,2777,2783>,<2777,2782,2783>,<2777,2778,2782>,<2778,2781,2782>,<2778,2779,2781>,
              <2779,2780,2781>
<2784,2785,2791>,<2785,2790,2791>,<2785,2786,2790>,<2786,2789,2790>,<2786,2787,2789>,
              <2787,2788,2789>
<2792,2793,2799>,<2793,2798,2799>,<2793,2794,2798>,<2794,2797,2798>,<2794,2795,2797>,
              <2795,2796,2797>
<2800,2801,2807>,<2801,2806,2807>,<2801,2802,2806>,<2802,2805,2806>,<2802,2803,2805>,
              <2803,2804,2805>
<2808,2809,2815>,<2809,2814,2815>,<2809,2810,2814>,<2810,2813,2814>,<2810,2811,2813>,
              <2811,2812,2813>
<2816,2817,2823>,<2817,2822,2823>,<2817,2818,2822>,<2818,2821,2822>,<2818,2819,2821>,
              <2819,2820,2821>
<2824,2825,2831>,<2825,2830,2831>,<2825,2826,2830>,<2826,2829,2830>,<2826,2827,2829>,
              <2827,2828,2829>
<2832,2833,2839>,<2833,2838,2839>,<2833,2834,2838>,<2834,2837,2838>,<2834,2835,2837>,
              <2835,2836,2837>
<2840,2841,2847>,<2841,2846,2847>,<2841,2842,2846>,<2842,2845,2846>,<2842,2843,2845>,
              <2843,2844,2845>
<2848,2849,2855>,<2849,2854,2855>,<2849,2850,2854>,<2850,2853,2854>,<2850,2851,2853>,
              <2851,2852,2853>
<2856,2857,2863>,<2857,2862,2863>,<2857,2858,2862>,<2858,2861,2862>,<2858,2859,2861>,
              <2859,2860,2861>
<2864,2865,2871>,<2865,2870,2871>,<2865,2866,2870>,<2866,2869,2870>,<2866,2867,2869>,
              <2867,2868,2869>
<2872,2873,2879>,<2873,2878,2879>,<2873,2874,2878>,<2874,2877,2878>,<2874,2875,2877>,
              <2875,2876,2877>
<2880,2881,2887>,<2881,2886,2887>,<2881,2882,2886>,<2882,2885,2886>,<2882,2883,2885>,
              <2883,2884,2885>
<2888,2889,2895>,<2889,2894,2895>,<2889,2890,2894>,<2890,2893,2894>,<2890,2891,2893>,
              <2891,2892,2893>
<2896,2897,2903>,<2897,2902,2903>,<2897,2898,2902>,<2898,2901,2902>,<2898,2899,2901>,
              <2899,2900,2901>
<2904,2905,2911>,<2905,2910,2911>,<2905,2906,2910>,<2906,2909,2910>,<2906,2907,2909>,
              <2907,2908,2909>
<2912,2913,2919>,<2913,2918,2919>,<2913,2914,2918>,<2914,2917,2918>,<2914,2915,2917>,
              <2915,2916,2917>
<2920,2921,2927>,<2921,2926,2927>,<2921,2922,2926>,<2922,2925,2926>,<2922,2923,2925>,
              <2923,2924,2925>
<2928,2929,2935>,<2929,2934,2935>,<2929,2930,2934>,<2930,2933,2934>,<2930,2931,2933>,
              <2931,2932,2933>
<2936,2937,2943>,<2937,2942,2943>,<2937,2938,2942>,<2938,2941,2942>,<2938,2939,2941>,
              <2939,2940,2941>
<2944,2945,2951>,<2945,2950,2951>,<2945,2946,2950>,<2946,2949,2950>,<2946,2947,2949>,
              <2947,2948,2949>
<2952,2953,2959>,<2953,2958,2959>,<2953,2954,2958>,<2954,2957,2958>,<2954,2955,2957>,
              <2955,2956,2957>
<2960,2961,2967>,<2961,2966,2967>,<2961,2962,2966>,<2962,2965,2966>,<2962,2963,2965>,
              <2963,2964,2965>
<2968,2969,2975>,<2969,2974,2975>,<2969,2970,2974>,<2970,2973,2974>,<2970,2971,2973>,
              <2971,2972,2973>
<2976,2977,2983>,<2977,2982,2983>,<2977,2978,2982>,<2978,2981,2982>,<2978,2979,2981>,
              <2979,2980,2981>
<2984,2985,2991>,<2985,2990,2991>,<2985,2986,2990>,<2986,2989,2990>,<2986,2987,2989>,
              <2987,2988,2989>
<2992,2993,2999>,<2993,2998,2999>,<2993,2994,2998>,<2994,2997,2998>,<2994,2995,2997>,
              <2995,2996,2997>
<3000,3001,3007>,<3001,3006,3007>,<3001,3002,3006>,<3002,3005,3006>,<3002,3003,3005>,
              <3003,3004,3005>
<3008,3009,3015>,<3009,3014,3015>,<3009,3010,3014>,<3010,3013,3014>,<3010,3011,3013>,
              <3011,3012,3013>
<3016,3017,3023>,<3017,3022,3023>,<3017,3018,3022>,<3018,3021,3022>,<3018,3019,3021>,
              <3019,3020,3021>
<3024,3025,3031>,<3025,3030,3031>,<3025,3026,3030>,<3026,3029,3030>,<3026,3027,3029>,
              <3027,3028,3029>
<3032,3033,3039>,<3033,3038,3039>,<3033,3034,3038>,<3034,3037,3038>,<3034,3035,3037>,
              <3035,3036,3037>
<3040,3041,3047>,<3041,3046,3047>,<3041,3042,3046>,<3042,3045,3046>,<3042,3043,3045>,
              <3043,3044,3045>
<3048,3049,3055>,<3049,3054,3055>,<3049,3050,3054>,<3050,3053,3054>,<3050,3051,3053>,
              <3051,3052,3053>
<3056,3057,3063>,<3057,3062,3063>,<3057,3058,3062>,<3058,3061,3062>,<3058,3059,3061>,
              <3059,3060,3061>
<3064,3065,3071>,<3065,3070,3071>,<3065,3066,3070>,<3066,3069,3070>,<3066,3067,3069>,
              <3067,3068,3069>
<3072,3073,3079>,<3073,3078,3079>,<3073,3074,3078>,<3074,3077,3078>,<3074,3075,3077>,
              <3075,3076,3077>
<3080,3081,3087>,<3081,3086,3087>,<3081,3082,3086>,<3082,3085,3086>,<3082,3083,3085>,
              <3083,3084,3085>
<3088,3089,3095>,<3089,3094,3095>,<3089,3090,3094>,<3090,3093,3094>,<3090,3091,3093>,
              <3091,3092,3093>
<3096,3097,3103>,<3097,3102,3103>,<3097,3098,3102>,<3098,3101,3102>,<3098,3099,3101>,
              <3099,3100,3101>
<3104,3105,3111>,<3105,3110,3111>,<3105,3106,3110>,<3106,3109,3110>,<3106,3107,3109>,
              <3107,3108,3109>
<3112,3113,3119>,<3113,3118,3119>,<3113,3114,3118>,<3114,3117,3118>,<3114,3115,3117>,
              <3115,3116,3117>
<3120,3121,3127>,<3121,3126,3127>,<3121,3122,3126>,<3122,3125,3126>,<3122,3123,3125>,
              <3123,3124,3125>
<3128,3129,3135>,<3129,3134,3135>,<3129,3130,3134>,<3130,3133,3134>,<3130,3131,3133>,
              <3131,3132,3133>
<3136,3137,3143>,<3137,3142,3143>,<3137,3138,3142>,<3138,3141,3142>,<3138,3139,3141>,
              <3139,3140,3141>
<3144,3145,3151>,<3145,3150,3151>,<3145,3146,3150>,<3146,3149,3150>,<3146,3147,3149>,
              <3147,3148,3149>
<3152,3153,3159>,<3153,3158,3159>,<3153,3154,3158>,<3154,3157,3158>,<3154,3155,3157>,
              <3155,3156,3157>
<3160,3161,3167>,<3161,3166,3167>,<3161,3162,3166>,<3162,3165,3166>,<3162,3163,3165>,
              <3163,3164,3165>
<3168,3169,3175>,<3169,3174,3175>,<3169,3170,3174>,<3170,3173,3174>,<3170,3171,3173>,
              <3171,3172,3173>
<3176,3177,3183>,<3177,3182,3183>,<3177,3178,3182>,<3178,3181,3182>,<3178,3179,3181>,
              <3179,3180,3181>
<3184,3185,3191>,<3185,3190,3191>,<3185,3186,3190>,<3186,3189,3190>,<3186,3187,3189>,
              <3187,3188,3189>
<3192,3193,3199>,<3193,3198,3199>,<3193,3194,3198>,<3194,3197,3198>,<3194,3195,3197>,
              <3195,3196,3197>
<3200,3201,3207>,<3201,3206,3207>,<3201,3202,3206>,<3202,3205,3206>,<3202,3203,3205>,
              <3203,3204,3205>
<3208,3209,3215>,<3209,3214,3215>,<3209,3210,3214>,<3210,3213,3214>,<3210,3211,3213>,
              <3211,3212,3213>
<3216,3217,3223>,<3217,3222,3223>,<3217,3218,3222>,<3218,3221,3222>,<3218,3219,3221>,
              <3219,3220,3221>
<3224,3225,3231>,<3225,3230,3231>,<3225,3226,3230>,<3226,3229,3230>,<3226,3227,3229>,
              <3227,3228,3229>
<3232,3233,3239>,<3233,3238,3239>,<3233,3234,3238>,<3234,3237,3238>,<3234,3235,3237>,
              <3235,3236,3237>
<3240,3241,3247>,<3241,3246,3247>,<3241,3242,3246>,<3242,3245,3246>,<3242,3243,3245>,
              <3243,3244,3245>
<3248,3249,3255>,<3249,3254,3255>,<3249,3250,3254>,<3250,3253,3254>,<3250,3251,3253>,
              <3251,3252,3253>
<3256,3257,3263>,<3257,3262,3263>,<3257,3258,3262>,<3258,3261,3262>,<3258,3259,3261>,
              <3259,3260,3261>
<3264,3265,3271>,<3265,3270,3271>,<3265,3266,3270>,<3266,3269,3270>,<3266,3267,3269>,
              <3267,3268,3269>
<3272,3273,3279>,<3273,3278,3279>,<3273,3274,3278>,<3274,3277,3278>,<3274,3275,3277>,
              <3275,3276,3277>
<3280,3281,3287>,<3281,3286,3287>,<3281,3282,3286>,<3282,3285,3286>,<3282,3283,3285>,
              <3283,3284,3285>
<3288,3289,3295>,<3289,3294,3295>,<3289,3290,3294>,<3290,3293,3294>,<3290,3291,3293>,
              <3291,3292,3293>
<3296,3297,3303>,<3297,3302,3303>,<3297,3298,3302>,<3298,3301,3302>,<3298,3299,3301>,
              <3299,3300,3301>
<3304,3305,3311>,<3305,3310,3311>,<3305,3306,3310>,<3306,3309,3310>,<3306,3307,3309>,
              <3307,3308,3309>
<3312,3313,3319>,<3313,3318,3319>,<3313,3314,3318>,<3314,3317,3318>,<3314,3315,3317>,
              <3315,3316,3317>
<3320,3321,3327>,<3321,3326,3327>,<3321,3322,3326>,<3322,3325,3326>,<3322,3323,3325>,
              <3323,3324,3325>
<3328,3329,3335>,<3329,3334,3335>,<3329,3330,3334>,<3330,3333,3334>,<3330,3331,3333>,
              <3331,3332,3333>
<3336,3337,3343>,<3337,3342,3343>,<3337,3338,3342>,<3338,3341,3342>,<3338,3339,3341>,
              <3339,3340,3341>
<3344,3345,3351>,<3345,3350,3351>,<3345,3346,3350>,<3346,3349,3350>,<3346,3347,3349>,
              <3347,3348,3349>
<3352,3353,3359>,<3353,3358,3359>,<3353,3354,3358>,<3354,3357,3358>,<3354,3355,3357>,
              <3355,3356,3357>
<3360,3361,3367>,<3361,3366,3367>,<3361,3362,3366>,<3362,3365,3366>,<3362,3363,3365>,
              <3363,3364,3365>
<3368,3369,3375>,<3369,3374,3375>,<3369,3370,3374>,<3370,3373,3374>,<3370,3371,3373>,
              <3371,3372,3373>
<3376,3377,3383>,<3377,3382,3383>,<3377,3378,3382>,<3378,3381,3382>,<3378,3379,3381>,
              <3379,3380,3381>
<3384,3385,3391>,<3385,3390,3391>,<3385,3386,3390>,<3386,3389,3390>,<3386,3387,3389>,
              <3387,3388,3389>
<3392,3393,3399>,<3393,3398,3399>,<3393,3394,3398>,<3394,3397,3398>,<3394,3395,3397>,
              <3395,3396,3397>
<3400,3401,3407>,<3401,3406,3407>,<3401,3402,3406>,<3402,3405,3406>,<3402,3403,3405>,
              <3403,3404,3405>
<3408,3409,3415>,<3409,3414,3415>,<3409,3410,3414>,<3410,3413,3414>,<3410,3411,3413>,
              <3411,3412,3413>
<3416,3417,3423>,<3417,3422,3423>,<3417,3418,3422>,<3418,3421,3422>,<3418,3419,3421>,
              <3419,3420,3421>
<3424,3425,3431>,<3425,3430,3431>,<3425,3426,3430>,<3426,3429,3430>,<3426,3427,3429>,
              <3427,3428,3429>
<3432,3433,3439>,<3433,3438,3439>,<3433,3434,3438>,<3434,3437,3438>,<3434,3435,3437>,
              <3435,3436,3437>
<3440,3441,3447>,<3441,3446,3447>,<3441,3442,3446>,<3442,3445,3446>,<3442,3443,3445>,
              <3443,3444,3445>
<3448,3449,3455>,<3449,3454,3455>,<3449,3450,3454>,<3450,3453,3454>,<3450,3451,3453>,
              <3451,3452,3453>
<3456,3457,3463>,<3457,3462,3463>,<3457,3458,3462>,<3458,3461,3462>,<3458,3459,3461>,
              <3459,3460,3461>
<3464,3465,3471>,<3465,3470,3471>,<3465,3466,3470>,<3466,3469,3470>,<3466,3467,3469>,
              <3467,3468,3469>
<3472,3473,3479>,<3473,3478,3479>,<3473,3474,3478>,<3474,3477,3478>,<3474,3475,3477>,
              <3475,3476,3477>
<3480,3481,3487>,<3481,3486,3487>,<3481,3482,3486>,<3482,3485,3486>,<3482,3483,3485>,
              <3483,3484,3485>
<3488,3489,3495>,<3489,3494,3495>,<3489,3490,3494>,<3490,3493,3494>,<3490,3491,3493>,
              <3491,3492,3493>
<3496,3497,3503>,<3497,3502,3503>,<3497,3498,3502>,<3498,3501,3502>,<3498,3499,3501>,
              <3499,3500,3501>
<3504,3505,3511>,<3505,3510,3511>,<3505,3506,3510>,<3506,3509,3510>,<3506,3507,3509>,
              <3507,3508,3509>
<3512,3513,3519>,<3513,3518,3519>,<3513,3514,3518>,<3514,3517,3518>,<3514,3515,3517>,
              <3515,3516,3517>
<3520,3521,3527>,<3521,3526,3527>,<3521,3522,3526>,<3522,3525,3526>,<3522,3523,3525>,
              <3523,3524,3525>
<3528,3529,3535>,<3529,3534,3535>,<3529,3530,3534>,<3530,3533,3534>,<3530,3531,3533>,
              <3531,3532,3533>
<3536,3537,3543>,<3537,3542,3543>,<3537,3538,3542>,<3538,3541,3542>,<3538,3539,3541>,
              <3539,3540,3541>
<3544,3545,3551>,<3545,3550,3551>,<3545,3546,3550>,<3546,3549,3550>,<3546,3547,3549>,
              <3547,3548,3549>
<3552,3553,3559>,<3553,3558,3559>,<3553,3554,3558>,<3554,3557,3558>,<3554,3555,3557>,
              <3555,3556,3557>
<3560,3561,3567>,<3561,3566,3567>,<3561,3562,3566>,<3562,3565,3566>,<3562,3563,3565>,
              <3563,3564,3565>
<3568,3569,3575>,<3569,3574,3575>,<3569,3570,3574>,<3570,3573,3574>,<3570,3571,3573>,
              <3571,3572,3573>
<3576,3577,3583>,<3577,3582,3583>,<3577,3578,3582>,<3578,3581,3582>,<3578,3579,3581>,
              <3579,3580,3581>
<3584,3585,3591>,<3585,3590,3591>,<3585,3586,3590>,<3586,3589,3590>,<3586,3587,3589>,
              <3587,3588,3589>
<3592,3593,3599>,<3593,3598,3599>,<3593,3594,3598>,<3594,3597,3598>,<3594,3595,3597>,
              <3595,3596,3597>
<3600,3601,3607>,<3601,3606,3607>,<3601,3602,3606>,<3602,3605,3606>,<3602,3603,3605>,
              <3603,3604,3605>
<3608,3609,3615>,<3609,3614,3615>,<3609,3610,3614>,<3610,3613,3614>,<3610,3611,3613>,
              <3611,3612,3613>
<3616,3617,3623>,<3617,3622,3623>,<3617,3618,3622>,<3618,3621,3622>,<3618,3619,3621>,
              <3619,3620,3621>
<3624,3625,3631>,<3625,3630,3631>,<3625,3626,3630>,<3626,3629,3630>,<3626,3627,3629>,
              <3627,3628,3629>
<3632,3633,3639>,<3633,3638,3639>,<3633,3634,3638>,<3634,3637,3638>,<3634,3635,3637>,
              <3635,3636,3637>
<3640,3641,3647>,<3641,3646,3647>,<3641,3642,3646>,<3642,3645,3646>,<3642,3643,3645>,
              <3643,3644,3645>
<3648,3649,3655>,<3649,3654,3655>,<3649,3650,3654>,<3650,3653,3654>,<3650,3651,3653>,
              <3651,3652,3653>
<3656,3657,3663>,<3657,3662,3663>,<3657,3658,3662>,<3658,3661,3662>,<3658,3659,3661>,
              <3659,3660,3661>
<3664,3665,3671>,<3665,3670,3671>,<3665,3666,3670>,<3666,3669,3670>,<3666,3667,3669>,
              <3667,3668,3669>
<3672,3673,3679>,<3673,3678,3679>,<3673,3674,3678>,<3674,3677,3678>,<3674,3675,3677>,
              <3675,3676,3677>
<3680,3681,3687>,<3681,3686,3687>,<3681,3682,3686>,<3682,3685,3686>,<3682,3683,3685>,
              <3683,3684,3685>
<3688,3689,3695>,<3689,3694,3695>,<3689,3690,3694>,<3690,3693,3694>,<3690,3691,3693>,
              <3691,3692,3693>
<3696,3697,3703>,<3697,3702,3703>,<3697,3698,3702>,<3698,3701,3702>,<3698,3699,3701>,
              <3699,3700,3701>
<3704,3705,3711>,<3705,3710,3711>,<3705,3706,3710>,<3706,3709,3710>,<3706,3707,3709>,
              <3707,3708,3709>
<3712,3713,3719>,<3713,3718,3719>,<3713,3714,3718>,<3714,3717,3718>,<3714,3715,3717>,
              <3715,3716,3717>
<3720,3721,3727>,<3721,3726,3727>,<3721,3722,3726>,<3722,3725,3726>,<3722,3723,3725>,
              <3723,3724,3725>
<3728,3729,3735>,<3729,3734,3735>,<3729,3730,3734>,<3730,3733,3734>,<3730,3731,3733>,
              <3731,3732,3733>
<3736,3737,3743>,<3737,3742,3743>,<3737,3738,3742>,<3738,3741,3742>,<3738,3739,3741>,
              <3739,3740,3741>
<3744,3745,3751>,<3745,3750,3751>,<3745,3746,3750>,<3746,3749,3750>,<3746,3747,3749>,
              <3747,3748,3749>
<3752,3753,3759>,<3753,3758,3759>,<3753,3754,3758>,<3754,3757,3758>,<3754,3755,3757>,
              <3755,3756,3757>
<3760,3761,3767>,<3761,3766,3767>,<3761,3762,3766>,<3762,3765,3766>,<3762,3763,3765>,
              <3763,3764,3765>
<3768,3769,3775>,<3769,3774,3775>,<3769,3770,3774>,<3770,3773,3774>,<3770,3771,3773>,
              <3771,3772,3773>
<3776,3777,3783>,<3777,3782,3783>,<3777,3778,3782>,<3778,3781,3782>,<3778,3779,3781>,
              <3779,3780,3781>
<3784,3785,3791>,<3785,3790,3791>,<3785,3786,3790>,<3786,3789,3790>,<3786,3787,3789>,
              <3787,3788,3789>
<3792,3793,3799>,<3793,3798,3799>,<3793,3794,3798>,<3794,3797,3798>,<3794,3795,3797>,
              <3795,3796,3797>
<3800,3801,3807>,<3801,3806,3807>,<3801,3802,3806>,<3802,3805,3806>,<3802,3803,3805>,
              <3803,3804,3805>
<3808,3809,3815>,<3809,3814,3815>,<3809,3810,3814>,<3810,3813,3814>,<3810,3811,3813>,
              <3811,3812,3813>
<3816,3817,3823>,<3817,3822,3823>,<3817,3818,3822>,<3818,3821,3822>,<3818,3819,3821>,
              <3819,3820,3821>
<3824,3825,3831>,<3825,3830,3831>,<3825,3826,3830>,<3826,3829,3830>,<3826,3827,3829>,
              <3827,3828,3829>
<3832,3833,3839>,<3833,3838,3839>,<3833,3834,3838>,<3834,3837,3838>,<3834,3835,3837>,
              <3835,3836,3837>
<3840,3841,3847>,<3841,3846,3847>,<3841,3842,3846>,<3842,3845,3846>,<3842,3843,3845>,
              <3843,3844,3845>
<3848,3849,3855>,<3849,3854,3855>,<3849,3850,3854>,<3850,3853,3854>,<3850,3851,3853>,
              <3851,3852,3853>
<3856,3857,3863>,<3857,3862,3863>,<3857,3858,3862>,<3858,3861,3862>,<3858,3859,3861>,
              <3859,3860,3861>
<3864,3865,3871>,<3865,3870,3871>,<3865,3866,3870>,<3866,3869,3870>,<3866,3867,3869>,
              <3867,3868,3869>
<3872,3873,3879>,<3873,3878,3879>,<3873,3874,3878>,<3874,3877,3878>,<3874,3875,3877>,
              <3875,3876,3877>
<3880,3881,3887>,<3881,3886,3887>,<3881,3882,3886>,<3882,3885,3886>,<3882,3883,3885>,
              <3883,3884,3885>
<3888,3889,3895>,<3889,3894,3895>,<3889,3890,3894>,<3890,3893,3894>,<3890,3891,3893>,
              <3891,3892,3893>
<3896,3897,3903>,<3897,3902,3903>,<3897,3898,3902>,<3898,3901,3902>,<3898,3899,3901>,
              <3899,3900,3901>
<3904,3905,3911>,<3905,3910,3911>,<3905,3906,3910>,<3906,3909,3910>,<3906,3907,3909>,
              <3907,3908,3909>
<3912,3913,3919>,<3913,3918,3919>,<3913,3914,3918>,<3914,3917,3918>,<3914,3915,3917>,
              <3915,3916,3917>
<3920,3921,3927>,<3921,3926,3927>,<3921,3922,3926>,<3922,3925,3926>,<3922,3923,3925>,
              <3923,3924,3925>
<3928,3929,3935>,<3929,3934,3935>,<3929,3930,3934>,<3930,3933,3934>,<3930,3931,3933>,
              <3931,3932,3933>
<3936,3937,3943>,<3937,3942,3943>,<3937,3938,3942>,<3938,3941,3942>,<3938,3939,3941>,
              <3939,3940,3941>
<3944,3945,3951>,<3945,3950,3951>,<3945,3946,3950>,<3946,3949,3950>,<3946,3947,3949>,
              <3947,3948,3949>
<3952,3953,3959>,<3953,3958,3959>,<3953,3954,3958>,<3954,3957,3958>,<3954,3955,3957>,
              <3955,3956,3957>
<3960,3961,3967>,<3961,3966,3967>,<3961,3962,3966>,<3962,3965,3966>,<3962,3963,3965>,
              <3963,3964,3965>
<3968,3969,3975>,<3969,3974,3975>,<3969,3970,3974>,<3970,3973,3974>,<3970,3971,3973>,
              <3971,3972,3973>
<3976,3977,3983>,<3977,3982,3983>,<3977,3978,3982>,<3978,3981,3982>,<3978,3979,3981>,
              <3979,3980,3981>
<3984,3985,3991>,<3985,3990,3991>,<3985,3986,3990>,<3986,3989,3990>,<3986,3987,3989>,
              <3987,3988,3989>
<3992,3993,3999>,<3993,3998,3999>,<3993,3994,3998>,<3994,3997,3998>,<3994,3995,3997>,
              <3995,3996,3997>
<4000,4001,4007>,<4001,4006,4007>,<4001,4002,4006>,<4002,4005,4006>,<4002,4003,4005>,
              <4003,4004,4005>
<4008,4009,4015>,<4009,4014,4015>,<4009,4010,4014>,<4010,4013,4014>,<4010,4011,4013>,
              <4011,4012,4013>
<4016,4017,4023>,<4017,4022,4023>,<4017,4018,4022>,<4018,4021,4022>,<4018,4019,4021>,
              <4019,4020,4021>
<4024,4025,4031>,<4025,4030,4031>,<4025,4026,4030>,<4026,4029,4030>,<4026,4027,4029>,
              <4027,4028,4029>
<4032,4033,4039>,<4033,4038,4039>,<4033,4034,4038>,<4034,4037,4038>,<4034,4035,4037>,
              <4035,4036,4037>
<4040,4041,4047>,<4041,4046,4047>,<4041,4042,4046>,<4042,4045,4046>,<4042,4043,4045>,
              <4043,4044,4045>
<4048,4049,4055>,<4049,4054,4055>,<4049,4050,4054>,<4050,4053,4054>,<4050,4051,4053>,
              <4051,4052,4053>
<4056,4057,4063>,<4057,4062,4063>,<4057,4058,4062>,<4058,4061,4062>,<4058,4059,4061>,
              <4059,4060,4061>
<4064,4065,4071>,<4065,4070,4071>,<4065,4066,4070>,<4066,4069,4070>,<4066,4067,4069>,
              <4067,4068,4069>
<4072,4073,4079>,<4073,4078,4079>,<4073,4074,4078>,<4074,4077,4078>,<4074,4075,4077>,
              <4075,4076,4077>
<4080,4081,4087>,<4081,4086,4087>,<4081,4082,4086>,<4082,4085,4086>,<4082,4083,4085>,
              <4083,4084,4085>
<4088,4089,4095>,<4089,4094,4095>,<4089,4090,4094>,<4090,4093,4094>,<4090,4091,4093>,
              <4091,4092,4093>
<4096,4097,4103>,<4097,4102,4103>,<4097,4098,4102>,<4098,4101,4102>,<4098,4099,4101>,
              <4099,4100,4101>
<4104,4105,4111>,<4105,4110,4111>,<4105,4106,4110>,<4106,4109,4110>,<4106,4107,4109>,
              <4107,4108,4109>
<4112,4113,4119>,<4113,4118,4119>,<4113,4114,4118>,<4114,4117,4118>,<4114,4115,4117>,
              <4115,4116,4117>
<4120,4121,4127>,<4121,4126,4127>,<4121,4122,4126>,<4122,4125,4126>,<4122,4123,4125>,
              <4123,4124,4125>
<4128,4129,4135>,<4129,4134,4135>,<4129,4130,4134>,<4130,4133,4134>,<4130,4131,4133>,
              <4131,4132,4133>
<4136,4137,4143>,<4137,4142,4143>,<4137,4138,4142>,<4138,4141,4142>,<4138,4139,4141>,
              <4139,4140,4141>
<4144,4145,4151>,<4145,4150,4151>,<4145,4146,4150>,<4146,4149,4150>,<4146,4147,4149>,
              <4147,4148,4149>
<4152,4153,4159>,<4153,4158,4159>,<4153,4154,4158>,<4154,4157,4158>,<4154,4155,4157>,
              <4155,4156,4157>
<4160,4161,4167>,<4161,4166,4167>,<4161,4162,4166>,<4162,4165,4166>,<4162,4163,4165>,
              <4163,4164,4165>
<4168,4169,4175>,<4169,4174,4175>,<4169,4170,4174>,<4170,4173,4174>,<4170,4171,4173>,
              <4171,4172,4173>
<4176,4177,4183>,<4177,4182,4183>,<4177,4178,4182>,<4178,4181,4182>,<4178,4179,4181>,
              <4179,4180,4181>
<4184,4185,4191>,<4185,4190,4191>,<4185,4186,4190>,<4186,4189,4190>,<4186,4187,4189>,
              <4187,4188,4189>
<4192,4193,4199>,<4193,4198,4199>,<4193,4194,4198>,<4194,4197,4198>,<4194,4195,4197>,
              <4195,4196,4197>
<4200,4201,4207>,<4201,4206,4207>,<4201,4202,4206>,<4202,4205,4206>,<4202,4203,4205>,
              <4203,4204,4205>
<4208,4209,4215>,<4209,4214,4215>,<4209,4210,4214>,<4210,4213,4214>,<4210,4211,4213>,
              <4211,4212,4213>
<4216,4217,4223>,<4217,4222,4223>,<4217,4218,4222>,<4218,4221,4222>,<4218,4219,4221>,
              <4219,4220,4221>
<4224,4225,4231>,<4225,4230,4231>,<4225,4226,4230>,<4226,4229,4230>,<4226,4227,4229>,
              <4227,4228,4229>
<4232,4233,4239>,<4233,4238,4239>,<4233,4234,4238>,<4234,4237,4238>,<4234,4235,4237>,
              <4235,4236,4237>
<4240,4241,4247>,<4241,4246,4247>,<4241,4242,4246>,<4242,4245,4246>,<4242,4243,4245>,
              <4243,4244,4245>
<4248,4249,4255>,<4249,4254,4255>,<4249,4250,4254>,<4250,4253,4254>,<4250,4251,4253>,
              <4251,4252,4253>
<4256,4257,4263>,<4257,4262,4263>,<4257,4258,4262>,<4258,4261,4262>,<4258,4259,4261>,
              <4259,4260,4261>
<4264,4265,4271>,<4265,4270,4271>,<4265,4266,4270>,<4266,4269,4270>,<4266,4267,4269>,
              <4267,4268,4269>
<4272,4273,4279>,<4273,4278,4279>,<4273,4274,4278>,<4274,4277,4278>,<4274,4275,4277>,
              <4275,4276,4277>
<4280,4281,4287>,<4281,4286,4287>,<4281,4282,4286>,<4282,4285,4286>,<4282,4283,4285>,
              <4283,4284,4285>
<4288,4289,4295>,<4289,4294,4295>,<4289,4290,4294>,<4290,4293,4294>,<4290,4291,4293>,
              <4291,4292,4293>
<4296,4297,4303>,<4297,4302,4303>,<4297,4298,4302>,<4298,4301,4302>,<4298,4299,4301>,
              <4299,4300,4301>
<4304,4305,4311>,<4305,4310,4311>,<4305,4306,4310>,<4306,4309,4310>,<4306,4307,4309>,
              <4307,4308,4309>
<4312,4313,4319>,<4313,4318,4319>,<4313,4314,4318>,<4314,4317,4318>,<4314,4315,4317>,
              <4315,4316,4317>
<4320,4321,4327>,<4321,4326,4327>,<4321,4322,4326>,<4322,4325,4326>,<4322,4323,4325>,
              <4323,4324,4325>
<4328,4329,4335>,<4329,4334,4335>,<4329,4330,4334>,<4330,4333,4334>,<4330,4331,4333>,
              <4331,4332,4333>
<4336,4337,4343>,<4337,4342,4343>,<4337,4338,4342>,<4338,4341,4342>,<4338,4339,4341>,
              <4339,4340,4341>
<4344,4345,4351>,<4345,4350,4351>,<4345,4346,4350>,<4346,4349,4350>,<4346,4347,4349>,
              <4347,4348,4349>
<4352,4353,4359>,<4353,4358,4359>,<4353,4354,4358>,<4354,4357,4358>,<4354,4355,4357>,
              <4355,4356,4357>
<4360,4361,4367>,<4361,4366,4367>,<4361,4362,4366>,<4362,4365,4366>,<4362,4363,4365>,
              <4363,4364,4365>
<4368,4369,4375>,<4369,4374,4375>,<4369,4370,4374>,<4370,4373,4374>,<4370,4371,4373>,
              <4371,4372,4373>
<4376,4377,4383>,<4377,4382,4383>,<4377,4378,4382>,<4378,4381,4382>,<4378,4379,4381>,
              <4379,4380,4381>
<4384,4385,4391>,<4385,4390,4391>,<4385,4386,4390>,<4386,4389,4390>,<4386,4387,4389>,
              <4387,4388,4389>
<4392,4393,4399>,<4393,4398,4399>,<4393,4394,4398>,<4394,4397,4398>,<4394,4395,4397>,
              <4395,4396,4397>
<4400,4401,4407>,<4401,4406,4407>,<4401,4402,4406>,<4402,4405,4406>,<4402,4403,4405>,
              <4403,4404,4405>
<4408,4409,4415>,<4409,4414,4415>,<4409,4410,4414>,<4410,4413,4414>,<4410,4411,4413>,
              <4411,4412,4413>
<4416,4417,4423>,<4417,4422,4423>,<4417,4418,4422>,<4418,4421,4422>,<4418,4419,4421>,
              <4419,4420,4421>
<4424,4425,4431>,<4425,4430,4431>,<4425,4426,4430>,<4426,4429,4430>,<4426,4427,4429>,
              <4427,4428,4429>
<4432,4433,4439>,<4433,4438,4439>,<4433,4434,4438>,<4434,4437,4438>,<4434,4435,4437>,
              <4435,4436,4437>
<4440,4441,4447>,<4441,4446,4447>,<4441,4442,4446>,<4442,4445,4446>,<4442,4443,4445>,
              <4443,4444,4445>
<4448,4449,4455>,<4449,4454,4455>,<4449,4450,4454>,<4450,4453,4454>,<4450,4451,4453>,
              <4451,4452,4453>
<4456,4457,4463>,<4457,4462,4463>,<4457,4458,4462>,<4458,4461,4462>,<4458,4459,4461>,
              <4459,4460,4461>
<4464,4465,4471>,<4465,4470,4471>,<4465,4466,4470>,<4466,4469,4470>,<4466,4467,4469>,
              <4467,4468,4469>
<4472,4473,4479>,<4473,4478,4479>,<4473,4474,4478>,<4474,4477,4478>,<4474,4475,4477>,
              <4475,4476,4477>
<4480,4481,4487>,<4481,4486,4487>,<4481,4482,4486>,<4482,4485,4486>,<4482,4483,4485>,
              <4483,4484,4485>
<4488,4489,4495>,<4489,4494,4495>,<4489,4490,4494>,<4490,4493,4494>,<4490,4491,4493>,
              <4491,4492,4493>
<4496,4497,4503>,<4497,4502,4503>,<4497,4498,4502>,<4498,4501,4502>,<4498,4499,4501>,
              <4499,4500,4501>
<4504,4505,4511>,<4505,4510,4511>,<4505,4506,4510>,<4506,4509,4510>,<4506,4507,4509>,
              <4507,4508,4509>
<4512,4513,4519>,<4513,4518,4519>,<4513,4514,4518>,<4514,4517,4518>,<4514,4515,4517>,
              <4515,4516,4517>
<4520,4521,4527>,<4521,4526,4527>,<4521,4522,4526>,<4522,4525,4526>,<4522,4523,4525>,
              <4523,4524,4525>
<4528,4529,4535>,<4529,4534,4535>,<4529,4530,4534>,<4530,4533,4534>,<4530,4531,4533>,
              <4531,4532,4533>
<4536,4537,4543>,<4537,4542,4543>,<4537,4538,4542>,<4538,4541,4542>,<4538,4539,4541>,
              <4539,4540,4541>
<4544,4545,4551>,<4545,4550,4551>,<4545,4546,4550>,<4546,4549,4550>,<4546,4547,4549>,
              <4547,4548,4549>
<4552,4553,4559>,<4553,4558,4559>,<4553,4554,4558>,<4554,4557,4558>,<4554,4555,4557>,
              <4555,4556,4557>
<4560,4561,4567>,<4561,4566,4567>,<4561,4562,4566>,<4562,4565,4566>,<4562,4563,4565>,
              <4563,4564,4565>
<4568,4569,4575>,<4569,4574,4575>,<4569,4570,4574>,<4570,4573,4574>,<4570,4571,4573>,
              <4571,4572,4573>
<4576,4577,4583>,<4577,4582,4583>,<4577,4578,4582>,<4578,4581,4582>,<4578,4579,4581>,
              <4579,4580,4581>
<4584,4585,4591>,<4585,4590,4591>,<4585,4586,4590>,<4586,4589,4590>,<4586,4587,4589>,
              <4587,4588,4589>
<4592,4593,4599>,<4593,4598,4599>,<4593,4594,4598>,<4594,4597,4598>,<4594,4595,4597>,
              <4595,4596,4597>
<4600,4601,4607>,<4601,4606,4607>,<4601,4602,4606>,<4602,4605,4606>,<4602,4603,4605>,
              <4603,4604,4605>
<4608,4609,4615>,<4609,4614,4615>,<4609,4610,4614>,<4610,4613,4614>,<4610,4611,4613>,
              <4611,4612,4613>
<4616,4617,4623>,<4617,4622,4623>,<4617,4618,4622>,<4618,4621,4622>,<4618,4619,4621>,
              <4619,4620,4621>
<4624,4625,4631>,<4625,4630,4631>,<4625,4626,4630>,<4626,4629,4630>,<4626,4627,4629>,
              <4627,4628,4629>
<4632,4633,4639>,<4633,4638,4639>,<4633,4634,4638>,<4634,4637,4638>,<4634,4635,4637>,
              <4635,4636,4637>
<4640,4641,4647>,<4641,4646,4647>,<4641,4642,4646>,<4642,4645,4646>,<4642,4643,4645>,
              <4643,4644,4645>
<4648,4649,4655>,<4649,4654,4655>,<4649,4650,4654>,<4650,4653,4654>,<4650,4651,4653>,
              <4651,4652,4653>
<4656,4657,4663>,<4657,4662,4663>,<4657,4658,4662>,<4658,4661,4662>,<4658,4659,4661>,
              <4659,4660,4661>
<4664,4665,4671>,<4665,4670,4671>,<4665,4666,4670>,<4666,4669,4670>,<4666,4667,4669>,
              <4667,4668,4669>
<4672,4673,4679>,<4673,4678,4679>,<4673,4674,4678>,<4674,4677,4678>,<4674,4675,4677>,
              <4675,4676,4677>
<4680,4681,4687>,<4681,4686,4687>,<4681,4682,4686>,<4682,4685,4686>,<4682,4683,4685>,
              <4683,4684,4685>
<4688,4689,4695>,<4689,4694,4695>,<4689,4690,4694>,<4690,4693,4694>,<4690,4691,4693>,
              <4691,4692,4693>
<4696,4697,4703>,<4697,4702,4703>,<4697,4698,4702>,<4698,4701,4702>,<4698,4699,4701>,
              <4699,4700,4701>
<4704,4705,4711>,<4705,4710,4711>,<4705,4706,4710>,<4706,4709,4710>,<4706,4707,4709>,
              <4707,4708,4709>
<4712,4713,4719>,<4713,4718,4719>,<4713,4714,4718>,<4714,4717,4718>,<4714,4715,4717>,
              <4715,4716,4717>
<4720,4721,4727>,<4721,4726,4727>,<4721,4722,4726>,<4722,4725,4726>,<4722,4723,4725>,
              <4723,4724,4725>
<4728,4729,4735>,<4729,4734,4735>,<4729,4730,4734>,<4730,4733,4734>,<4730,4731,4733>,
              <4731,4732,4733>
<4736,4737,4743>,<4737,4742,4743>,<4737,4738,4742>,<4738,4741,4742>,<4738,4739,4741>,
              <4739,4740,4741>
<4744,4745,4751>,<4745,4750,4751>,<4745,4746,4750>,<4746,4749,4750>,<4746,4747,4749>,
              <4747,4748,4749>
<4752,4753,4759>,<4753,4758,4759>,<4753,4754,4758>,<4754,4757,4758>,<4754,4755,4757>,
              <4755,4756,4757>
<4760,4761,4767>,<4761,4766,4767>,<4761,4762,4766>,<4762,4765,4766>,<4762,4763,4765>,
              <4763,4764,4765>
<4768,4769,4775>,<4769,4774,4775>,<4769,4770,4774>,<4770,4773,4774>,<4770,4771,4773>,
              <4771,4772,4773>
<4776,4777,4783>,<4777,4782,4783>,<4777,4778,4782>,<4778,4781,4782>,<4778,4779,4781>,
              <4779,4780,4781>
<4784,4785,4791>,<4785,4790,4791>,<4785,4786,4790>,<4786,4789,4790>,<4786,4787,4789>,
              <4787,4788,4789>
<4792,4793,4799>,<4793,4798,4799>,<4793,4794,4798>,<4794,4797,4798>,<4794,4795,4797>,
              <4795,4796,4797>
<4800,4801,4807>,<4801,4806,4807>,<4801,4802,4806>,<4802,4805,4806>,<4802,4803,4805>,
              <4803,4804,4805>
<4808,4809,4815>,<4809,4814,4815>,<4809,4810,4814>,<4810,4813,4814>,<4810,4811,4813>,
              <4811,4812,4813>
<4816,4817,4823>,<4817,4822,4823>,<4817,4818,4822>,<4818,4821,4822>,<4818,4819,4821>,
              <4819,4820,4821>
<4824,4825,4831>,<4825,4830,4831>,<4825,4826,4830>,<4826,4829,4830>,<4826,4827,4829>,
              <4827,4828,4829>
<4832,4833,4839>,<4833,4838,4839>,<4833,4834,4838>,<4834,4837,4838>,<4834,4835,4837>,
              <4835,4836,4837>
<4840,4841,4847>,<4841,4846,4847>,<4841,4842,4846>,<4842,4845,4846>,<4842,4843,4845>,
              <4843,4844,4845>
<4848,4849,4855>,<4849,4854,4855>,<4849,4850,4854>,<4850,4853,4854>,<4850,4851,4853>,
              <4851,4852,4853>
<4856,4857,4863>,<4857,4862,4863>,<4857,4858,4862>,<4858,4861,4862>,<4858,4859,4861>,
              <4859,4860,4861>
<4864,4865,4871>,<4865,4870,4871>,<4865,4866,4870>,<4866,4869,4870>,<4866,4867,4869>,
              <4867,4868,4869>
<4872,4873,4879>,<4873,4878,4879>,<4873,4874,4878>,<4874,4877,4878>,<4874,4875,4877>,
              <4875,4876,4877>
<4880,4881,4887>,<4881,4886,4887>,<4881,4882,4886>,<4882,4885,4886>,<4882,4883,4885>,
              <4883,4884,4885>
<4888,4889,4895>,<4889,4894,4895>,<4889,4890,4894>,<4890,4893,4894>,<4890,4891,4893>,
              <4891,4892,4893>
<4896,4897,4903>,<4897,4902,4903>,<4897,4898,4902>,<4898,4901,4902>,<4898,4899,4901>,
              <4899,4900,4901>
<4904,4905,4911>,<4905,4910,4911>,<4905,4906,4910>,<4906,4909,4910>,<4906,4907,4909>,
              <4907,4908,4909>
<4912,4913,4919>,<4913,4918,4919>,<4913,4914,4918>,<4914,4917,4918>,<4914,4915,4917>,
              <4915,4916,4917>
<4920,4921,4927>,<4921,4926,4927>,<4921,4922,4926>,<4922,4925,4926>,<4922,4923,4925>,
              <4923,4924,4925>
<4928,4929,4935>,<4929,4934,4935>,<4929,4930,4934>,<4930,4933,4934>,<4930,4931,4933>,
              <4931,4932,4933>
<4936,4937,4943>,<4937,4942,4943>,<4937,4938,4942>,<4938,4941,4942>,<4938,4939,4941>,
              <4939,4940,4941>
<4944,4945,4951>,<4945,4950,4951>,<4945,4946,4950>,<4946,4949,4950>,<4946,4947,4949>,
              <4947,4948,4949>
<4952,4953,4959>,<4953,4958,4959>,<4953,4954,4958>,<4954,4957,4958>,<4954,4955,4957>,
              <4955,4956,4957>
<4960,4961,4967>,<4961,4966,4967>,<4961,4962,4966>,<4962,4965,4966>,<4962,4963,4965>,
              <4963,4964,4965>
<4968,4969,4975>,<4969,4974,4975>,<4969,4970,4974>,<4970,4973,4974>,<4970,4971,4973>,
              <4971,4972,4973>
<4976,4977,4983>,<4977,4982,4983>,<4977,4978,4982>,<4978,4981,4982>,<4978,4979,4981>,
              <4979,4980,4981>
<4984,4985,4991>,<4985,4990,4991>,<4985,4986,4990>,<4986,4989,4990>,<4986,4987,4989>,
              <4987,4988,4989>
<4992,4993,4999>,<4993,4998,4999>,<4993,4994,4998>,<4994,4997,4998>,<4994,4995,4997>,
              <4995,4996,4997>
<5000,5001,5007>,<5001,5006,5007>,<5001,5002,5006>,<5002,5005,5006>,<5002,5003,5005>,
              <5003,5004,5005>
<5008,5009,5015>,<5009,5014,5015>,<5009,5010,5014>,<5010,5013,5014>,<5010,5011,5013>,
              <5011,5012,5013>
<5016,5017,5023>,<5017,5022,5023>,<5017,5018,5022>,<5018,5021,5022>,<5018,5019,5021>,
              <5019,5020,5021>
<5024,5025,5031>,<5025,5030,5031>,<5025,5026,5030>,<5026,5029,5030>,<5026,5027,5029>,
              <5027,5028,5029>
<5032,5033,5039>,<5033,5038,5039>,<5033,5034,5038>,<5034,5037,5038>,<5034,5035,5037>,
              <5035,5036,5037>
<5040,5041,5047>,<5041,5046,5047>,<5041,5042,5046>,<5042,5045,5046>,<5042,5043,5045>,
              <5043,5044,5045>
<5048,5049,5055>,<5049,5054,5055>,<5049,5050,5054>,<5050,5053,5054>,<5050,5051,5053>,
              <5051,5052,5053>
<5056,5057,5063>,<5057,5062,5063>,<5057,5058,5062>,<5058,5061,5062>,<5058,5059,5061>,
              <5059,5060,5061>
<5064,5065,5071>,<5065,5070,5071>,<5065,5066,5070>,<5066,5069,5070>,<5066,5067,5069>,
              <5067,5068,5069>
<5072,5073,5079>,<5073,5078,5079>,<5073,5074,5078>,<5074,5077,5078>,<5074,5075,5077>,
              <5075,5076,5077>
<5080,5081,5087>,<5081,5086,5087>,<5081,5082,5086>,<5082,5085,5086>,<5082,5083,5085>,
              <5083,5084,5085>
<5088,5089,5095>,<5089,5094,5095>,<5089,5090,5094>,<5090,5093,5094>,<5090,5091,5093>,
              <5091,5092,5093>
<5096,5097,5103>,<5097,5102,5103>,<5097,5098,5102>,<5098,5101,5102>,<5098,5099,5101>,
              <5099,5100,5101>
<5104,5105,5111>,<5105,5110,5111>,<5105,5106,5110>,<5106,5109,5110>,<5106,5107,5109>,
              <5107,5108,5109>
<5112,5113,5119>,<5113,5118,5119>,<5113,5114,5118>,<5114,5117,5118>,<5114,5115,5117>,
              <5115,5116,5117>
<5120,5121,5127>,<5121,5126,5127>,<5121,5122,5126>,<5122,5125,5126>,<5122,5123,5125>,
              <5123,5124,5125>
<5128,5129,5135>,<5129,5134,5135>,<5129,5130,5134>,<5130,5133,5134>,<5130,5131,5133>,
              <5131,5132,5133>
<5136,5137,5143>,<5137,5142,5143>,<5137,5138,5142>,<5138,5141,5142>,<5138,5139,5141>,
              <5139,5140,5141>
<5144,5145,5151>,<5145,5150,5151>,<5145,5146,5150>,<5146,5149,5150>,<5146,5147,5149>,
              <5147,5148,5149>
<5152,5153,5159>,<5153,5158,5159>,<5153,5154,5158>,<5154,5157,5158>,<5154,5155,5157>,
              <5155,5156,5157>
<5160,5161,5167>,<5161,5166,5167>,<5161,5162,5166>,<5162,5165,5166>,<5162,5163,5165>,
              <5163,5164,5165>
<5168,5169,5175>,<5169,5174,5175>,<5169,5170,5174>,<5170,5173,5174>,<5170,5171,5173>,
              <5171,5172,5173>
<5176,5177,5183>,<5177,5182,5183>,<5177,5178,5182>,<5178,5181,5182>,<5178,5179,5181>,
              <5179,5180,5181>
<5184,5185,5191>,<5185,5190,5191>,<5185,5186,5190>,<5186,5189,5190>,<5186,5187,5189>,
              <5187,5188,5189>
<5192,5193,5199>,<5193,5198,5199>,<5193,5194,5198>,<5194,5197,5198>,<5194,5195,5197>,
              <5195,5196,5197>
<5200,5201,5207>,<5201,5206,5207>,<5201,5202,5206>,<5202,5205,5206>,<5202,5203,5205>,
              <5203,5204,5205>
<5208,5209,5215>,<5209,5214,5215>,<5209,5210,5214>,<5210,5213,5214>,<5210,5211,5213>,
              <5211,5212,5213>
<5216,5217,5223>,<5217,5222,5223>,<5217,5218,5222>,<5218,5221,5222>,<5218,5219,5221>,
              <5219,5220,5221>
<5224,5225,5231>,<5225,5230,5231>,<5225,5226,5230>,<5226,5229,5230>,<5226,5227,5229>,
              <5227,5228,5229>
<5232,5233,5239>,<5233,5238,5239>,<5233,5234,5238>,<5234,5237,5238>,<5234,5235,5237>,
              <5235,5236,5237>
<5240,5241,5247>,<5241,5246,5247>,<5241,5242,5246>,<5242,5245,5246>,<5242,5243,5245>,
              <5243,5244,5245>
<5248,5249,5255>,<5249,5254,5255>,<5249,5250,5254>,<5250,5253,5254>,<5250,5251,5253>,
              <5251,5252,5253>
<5256,5257,5263>,<5257,5262,5263>,<5257,5258,5262>,<5258,5261,5262>,<5258,5259,5261>,
              <5259,5260,5261>
<5264,5265,5271>,<5265,5270,5271>,<5265,5266,5270>,<5266,5269,5270>,<5266,5267,5269>,
              <5267,5268,5269>
<5272,5273,5279>,<5273,5278,5279>,<5273,5274,5278>,<5274,5277,5278>,<5274,5275,5277>,
              <5275,5276,5277>
<5280,5281,5287>,<5281,5286,5287>,<5281,5282,5286>,<5282,5285,5286>,<5282,5283,5285>,
              <5283,5284,5285>
<5288,5289,5295>,<5289,5294,5295>,<5289,5290,5294>,<5290,5293,5294>,<5290,5291,5293>,
              <5291,5292,5293>
<5296,5297,5303>,<5297,5302,5303>,<5297,5298,5302>,<5298,5301,5302>,<5298,5299,5301>,
              <5299,5300,5301>
<5304,5305,5311>,<5305,5310,5311>,<5305,5306,5310>,<5306,5309,5310>,<5306,5307,5309>,
              <5307,5308,5309>
<5312,5313,5319>,<5313,5318,5319>,<5313,5314,5318>,<5314,5317,5318>,<5314,5315,5317>,
              <5315,5316,5317>
<5320,5321,5327>,<5321,5326,5327>,<5321,5322,5326>,<5322,5325,5326>,<5322,5323,5325>,
              <5323,5324,5325>
<5328,5329,5335>,<5329,5334,5335>,<5329,5330,5334>,<5330,5333,5334>,<5330,5331,5333>,
              <5331,5332,5333>
<5336,5337,5343>,<5337,5342,5343>,<5337,5338,5342>,<5338,5341,5342>,<5338,5339,5341>,
              <5339,5340,5341>
<5344,5345,5351>,<5345,5350,5351>,<5345,5346,5350>,<5346,5349,5350>,<5346,5347,5349>,
              <5347,5348,5349>
<5352,5353,5359>,<5353,5358,5359>,<5353,5354,5358>,<5354,5357,5358>,<5354,5355,5357>,
              <5355,5356,5357>
<5360,5361,5367>,<5361,5366,5367>,<5361,5362,5366>,<5362,5365,5366>,<5362,5363,5365>,
              <5363,5364,5365>
<5368,5369,5375>,<5369,5374,5375>,<5369,5370,5374>,<5370,5373,5374>,<5370,5371,5373>,
              <5371,5372,5373>
<5376,5377,5383>,<5377,5382,5383>,<5377,5378,5382>,<5378,5381,5382>,<5378,5379,5381>,
              <5379,5380,5381>
<5384,5385,5391>,<5385,5390,5391>,<5385,5386,5390>,<5386,5389,5390>,<5386,5387,5389>,
              <5387,5388,5389>
<5392,5393,5399>,<5393,5398,5399>,<5393,5394,5398>,<5394,5397,5398>,<5394,5395,5397>,
              <5395,5396,5397>
<5400,5401,5407>,<5401,5406,5407>,<5401,5402,5406>,<5402,5405,5406>,<5402,5403,5405>,
              <5403,5404,5405>
<5408,5409,5415>,<5409,5414,5415>,<5409,5410,5414>,<5410,5413,5414>,<5410,5411,5413>,
              <5411,5412,5413>
<5416,5417,5423>,<5417,5422,5423>,<5417,5418,5422>,<5418,5421,5422>,<5418,5419,5421>,
              <5419,5420,5421>
<5424,5425,5431>,<5425,5430,5431>,<5425,5426,5430>,<5426,5429,5430>,<5426,5427,5429>,
              <5427,5428,5429>
<5432,5433,5439>,<5433,5438,5439>,<5433,5434,5438>,<5434,5437,5438>,<5434,5435,5437>,
              <5435,5436,5437>
<5440,5441,5447>,<5441,5446,5447>,<5441,5442,5446>,<5442,5445,5446>,<5442,5443,5445>,
              <5443,5444,5445>
<5448,5449,5455>,<5449,5454,5455>,<5449,5450,5454>,<5450,5453,5454>,<5450,5451,5453>,
              <5451,5452,5453>
<5456,5457,5463>,<5457,5462,5463>,<5457,5458,5462>,<5458,5461,5462>,<5458,5459,5461>,
              <5459,5460,5461>
<5464,5465,5471>,<5465,5470,5471>,<5465,5466,5470>,<5466,5469,5470>,<5466,5467,5469>,
              <5467,5468,5469>
<5472,5473,5479>,<5473,5478,5479>,<5473,5474,5478>,<5474,5477,5478>,<5474,5475,5477>,
              <5475,5476,5477>
<5480,5481,5487>,<5481,5486,5487>,<5481,5482,5486>,<5482,5485,5486>,<5482,5483,5485>,
              <5483,5484,5485>
<5488,5489,5495>,<5489,5494,5495>,<5489,5490,5494>,<5490,5493,5494>,<5490,5491,5493>,
              <5491,5492,5493>
<5496,5497,5503>,<5497,5502,5503>,<5497,5498,5502>,<5498,5501,5502>,<5498,5499,5501>,
              <5499,5500,5501>
<5504,5505,5511>,<5505,5510,5511>,<5505,5506,5510>,<5506,5509,5510>,<5506,5507,5509>,
              <5507,5508,5509>
<5512,5513,5519>,<5513,5518,5519>,<5513,5514,5518>,<5514,5517,5518>,<5514,5515,5517>,
              <5515,5516,5517>
<5520,5521,5527>,<5521,5526,5527>,<5521,5522,5526>,<5522,5525,5526>,<5522,5523,5525>,
              <5523,5524,5525>
<5528,5529,5535>,<5529,5534,5535>,<5529,5530,5534>,<5530,5533,5534>,<5530,5531,5533>,
              <5531,5532,5533>
<5536,5537,5543>,<5537,5542,5543>,<5537,5538,5542>,<5538,5541,5542>,<5538,5539,5541>,
              <5539,5540,5541>
<5544,5545,5551>,<5545,5550,5551>,<5545,5546,5550>,<5546,5549,5550>,<5546,5547,5549>,
              <5547,5548,5549>
<5552,5553,5559>,<5553,5558,5559>,<5553,5554,5558>,<5554,5557,5558>,<5554,5555,5557>,
              <5555,5556,5557>
<5560,5561,5567>,<5561,5566,5567>,<5561,5562,5566>,<5562,5565,5566>,<5562,5563,5565>,
              <5563,5564,5565>
<5568,5569,5575>,<5569,5574,5575>,<5569,5570,5574>,<5570,5573,5574>,<5570,5571,5573>,
              <5571,5572,5573>
<5576,5577,5583>,<5577,5582,5583>,<5577,5578,5582>,<5578,5581,5582>,<5578,5579,5581>,
              <5579,5580,5581>
<5584,5585,5591>,<5585,5590,5591>,<5585,5586,5590>,<5586,5589,5590>,<5586,5587,5589>,
              <5587,5588,5589>
<5592,5593,5599>,<5593,5598,5599>,<5593,5594,5598>,<5594,5597,5598>,<5594,5595,5597>,
              <5595,5596,5597>
<5600,5601,5607>,<5601,5606,5607>,<5601,5602,5606>,<5602,5605,5606>,<5602,5603,5605>,
              <5603,5604,5605>
<5608,5609,5615>,<5609,5614,5615>,<5609,5610,5614>,<5610,5613,5614>,<5610,5611,5613>,
              <5611,5612,5613>
<5616,5617,5623>,<5617,5622,5623>,<5617,5618,5622>,<5618,5621,5622>,<5618,5619,5621>,
              <5619,5620,5621>
<5624,5625,5631>,<5625,5630,5631>,<5625,5626,5630>,<5626,5629,5630>,<5626,5627,5629>,
              <5627,5628,5629>
<5632,5633,5639>,<5633,5638,5639>,<5633,5634,5638>,<5634,5637,5638>,<5634,5635,5637>,
              <5635,5636,5637>
<5640,5641,5647>,<5641,5646,5647>,<5641,5642,5646>,<5642,5645,5646>,<5642,5643,5645>,
              <5643,5644,5645>
<5648,5649,5655>,<5649,5654,5655>,<5649,5650,5654>,<5650,5653,5654>,<5650,5651,5653>,
              <5651,5652,5653>
<5656,5657,5663>,<5657,5662,5663>,<5657,5658,5662>,<5658,5661,5662>,<5658,5659,5661>,
              <5659,5660,5661>
<5664,5665,5671>,<5665,5670,5671>,<5665,5666,5670>,<5666,5669,5670>,<5666,5667,5669>,
              <5667,5668,5669>
<5672,5673,5679>,<5673,5678,5679>,<5673,5674,5678>,<5674,5677,5678>,<5674,5675,5677>,
              <5675,5676,5677>
<5680,5681,5687>,<5681,5686,5687>,<5681,5682,5686>,<5682,5685,5686>,<5682,5683,5685>,
              <5683,5684,5685>
<5688,5689,5695>,<5689,5694,5695>,<5689,5690,5694>,<5690,5693,5694>,<5690,5691,5693>,
              <5691,5692,5693>
<5696,5697,5703>,<5697,5702,5703>,<5697,5698,5702>,<5698,5701,5702>,<5698,5699,5701>,
              <5699,5700,5701>
<5704,5705,5711>,<5705,5710,5711>,<5705,5706,5710>,<5706,5709,5710>,<5706,5707,5709>,
              <5707,5708,5709>
<5712,5713,5719>,<5713,5718,5719>,<5713,5714,5718>,<5714,5717,5718>,<5714,5715,5717>,
              <5715,5716,5717>
<5720,5721,5727>,<5721,5726,5727>,<5721,5722,5726>,<5722,5725,5726>,<5722,5723,5725>,
              <5723,5724,5725>
<5728,5729,5735>,<5729,5734,5735>,<5729,5730,5734>,<5730,5733,5734>,<5730,5731,5733>,
              <5731,5732,5733>
<5736,5737,5743>,<5737,5742,5743>,<5737,5738,5742>,<5738,5741,5742>,<5738,5739,5741>,
              <5739,5740,5741>
<5744,5745,5751>,<5745,5750,5751>,<5745,5746,5750>,<5746,5749,5750>,<5746,5747,5749>,
              <5747,5748,5749>
<5752,5753,5759>,<5753,5758,5759>,<5753,5754,5758>,<5754,5757,5758>,<5754,5755,5757>,
              <5755,5756,5757>
<5760,5761,5767>,<5761,5766,5767>,<5761,5762,5766>,<5762,5765,5766>,<5762,5763,5765>,
              <5763,5764,5765>
<5768,5769,5775>,<5769,5774,5775>,<5769,5770,5774>,<5770,5773,5774>,<5770,5771,5773>,
              <5771,5772,5773>
<5776,5777,5783>,<5777,5782,5783>,<5777,5778,5782>,<5778,5781,5782>,<5778,5779,5781>,
              <5779,5780,5781>
<5784,5785,5791>,<5785,5790,5791>,<5785,5786,5790>,<5786,5789,5790>,<5786,5787,5789>,
              <5787,5788,5789>
<5792,5793,5799>,<5793,5798,5799>,<5793,5794,5798>,<5794,5797,5798>,<5794,5795,5797>,
              <5795,5796,5797>
<5800,5801,5807>,<5801,5806,5807>,<5801,5802,5806>,<5802,5805,5806>,<5802,5803,5805>,
              <5803,5804,5805>
<5808,5809,5815>,<5809,5814,5815>,<5809,5810,5814>,<5810,5813,5814>,<5810,5811,5813>,
              <5811,5812,5813>
<5816,5817,5823>,<5817,5822,5823>,<5817,5818,5822>,<5818,5821,5822>,<5818,5819,5821>,
              <5819,5820,5821>
<5824,5825,5831>,<5825,5830,5831>,<5825,5826,5830>,<5826,5829,5830>,<5826,5827,5829>,
              <5827,5828,5829>
<5832,5833,5839>,<5833,5838,5839>,<5833,5834,5838>,<5834,5837,5838>,<5834,5835,5837>,
              <5835,5836,5837>
<5840,5841,5847>,<5841,5846,5847>,<5841,5842,5846>,<5842,5845,5846>,<5842,5843,5845>,
              <5843,5844,5845>
<5848,5849,5855>,<5849,5854,5855>,<5849,5850,5854>,<5850,5853,5854>,<5850,5851,5853>,
              <5851,5852,5853>
<5856,5857,5863>,<5857,5862,5863>,<5857,5858,5862>,<5858,5861,5862>,<5858,5859,5861>,
              <5859,5860,5861>
<5864,5865,5871>,<5865,5870,5871>,<5865,5866,5870>,<5866,5869,5870>,<5866,5867,5869>,
              <5867,5868,5869>
<5872,5873,5879>,<5873,5878,5879>,<5873,5874,5878>,<5874,5877,5878>,<5874,5875,5877>,
              <5875,5876,5877>
<5880,5881,5887>,<5881,5886,5887>,<5881,5882,5886>,<5882,5885,5886>,<5882,5883,5885>,
              <5883,5884,5885>
<5888,5889,5895>,<5889,5894,5895>,<5889,5890,5894>,<5890,5893,5894>,<5890,5891,5893>,
              <5891,5892,5893>
<5896,5897,5903>,<5897,5902,5903>,<5897,5898,5902>,<5898,5901,5902>,<5898,5899,5901>,
              <5899,5900,5901>
<5904,5905,5911>,<5905,5910,5911>,<5905,5906,5910>,<5906,5909,5910>,<5906,5907,5909>,
              <5907,5908,5909>
<5912,5913,5919>,<5913,5918,5919>,<5913,5914,5918>,<5914,5917,5918>,<5914,5915,5917>,
              <5915,5916,5917>
<5920,5921,5927>,<5921,5926,5927>,<5921,5922,5926>,<5922,5925,5926>,<5922,5923,5925>,
              <5923,5924,5925>
<5928,5929,5935>,<5929,5934,5935>,<5929,5930,5934>,<5930,5933,5934>,<5930,5931,5933>,
              <5931,5932,5933>
<5936,5937,5943>,<5937,5942,5943>,<5937,5938,5942>,<5938,5941,5942>,<5938,5939,5941>,
              <5939,5940,5941>
<5944,5945,5951>,<5945,5950,5951>,<5945,5946,5950>,<5946,5949,5950>,<5946,5947,5949>,
              <5947,5948,5949>
<5952,5953,5959>,<5953,5958,5959>,<5953,5954,5958>,<5954,5957,5958>,<5954,5955,5957>,
              <5955,5956,5957>
<5960,5961,5967>,<5961,5966,5967>,<5961,5962,5966>,<5962,5965,5966>,<5962,5963,5965>,
              <5963,5964,5965>
<5968,5969,5975>,<5969,5974,5975>,<5969,5970,5974>,<5970,5973,5974>,<5970,5971,5973>,
              <5971,5972,5973>
<5976,5977,5983>,<5977,5982,5983>,<5977,5978,5982>,<5978,5981,5982>,<5978,5979,5981>,
              <5979,5980,5981>
<5984,5985,5991>,<5985,5990,5991>,<5985,5986,5990>,<5986,5989,5990>,<5986,5987,5989>,
              <5987,5988,5989>
<5992,5993,5999>,<5993,5998,5999>,<5993,5994,5998>,<5994,5997,5998>,<5994,5995,5997>,
              <5995,5996,5997>
<6000,6001,6007>,<6001,6006,6007>,<6001,6002,6006>,<6002,6005,6006>,<6002,6003,6005>,
              <6003,6004,6005>
<6008,6009,6015>,<6009,6014,6015>,<6009,6010,6014>,<6010,6013,6014>,<6010,6011,6013>,
              <6011,6012,6013>
<6016,6017,6023>,<6017,6022,6023>,<6017,6018,6022>,<6018,6021,6022>,<6018,6019,6021>,
              <6019,6020,6021>
<6024,6025,6031>,<6025,6030,6031>,<6025,6026,6030>,<6026,6029,6030>,<6026,6027,6029>,
              <6027,6028,6029>
<6032,6033,6039>,<6033,6038,6039>,<6033,6034,6038>,<6034,6037,6038>,<6034,6035,6037>,
              <6035,6036,6037>
<6040,6041,6047>,<6041,6046,6047>,<6041,6042,6046>,<6042,6045,6046>,<6042,6043,6045>,
              <6043,6044,6045>
<6048,6049,6055>,<6049,6054,6055>,<6049,6050,6054>,<6050,6053,6054>,<6050,6051,6053>,
              <6051,6052,6053>
<6056,6057,6063>,<6057,6062,6063>,<6057,6058,6062>,<6058,6061,6062>,<6058,6059,6061>,
              <6059,6060,6061>
<6064,6065,6071>,<6065,6070,6071>,<6065,6066,6070>,<6066,6069,6070>,<6066,6067,6069>,
              <6067,6068,6069>
<6072,6073,6079>,<6073,6078,6079>,<6073,6074,6078>,<6074,6077,6078>,<6074,6075,6077>,
              <6075,6076,6077>
<6080,6081,6087>,<6081,6086,6087>,<6081,6082,6086>,<6082,6085,6086>,<6082,6083,6085>,
              <6083,6084,6085>
<6088,6089,6095>,<6089,6094,6095>,<6089,6090,6094>,<6090,6093,6094>,<6090,6091,6093>,
              <6091,6092,6093>
<6096,6097,6103>,<6097,6102,6103>,<6097,6098,6102>,<6098,6101,6102>,<6098,6099,6101>,
              <6099,6100,6101>
<6104,6105,6111>,<6105,6110,6111>,<6105,6106,6110>,<6106,6109,6110>,<6106,6107,6109>,
              <6107,6108,6109>
<6112,6113,6119>,<6113,6118,6119>,<6113,6114,6118>,<6114,6117,6118>,<6114,6115,6117>,
              <6115,6116,6117>
<6120,6121,6127>,<6121,6126,6127>,<6121,6122,6126>,<6122,6125,6126>,<6122,6123,6125>,
              <6123,6124,6125>
<6128,6129,6135>,<6129,6134,6135>,<6129,6130,6134>,<6130,6133,6134>,<6130,6131,6133>,
              <6131,6132,6133>
<6136,6137,6143>,<6137,6142,6143>,<6137,6138,6142>,<6138,6141,6142>,<6138,6139,6141>,
              <6139,6140,6141>
<6144,6145,6151>,<6145,6150,6151>,<6145,6146,6150>,<6146,6149,6150>,<6146,6147,6149>,
              <6147,6148,6149>
<6152,6153,6159>,<6153,6158,6159>,<6153,6154,6158>,<6154,6157,6158>,<6154,6155,6157>,
              <6155,6156,6157>
<6160,6161,6167>,<6161,6166,6167>,<6161,6162,6166>,<6162,6165,6166>,<6162,6163,6165>,
              <6163,6164,6165>
<6168,6169,6175>,<6169,6174,6175>,<6169,6170,6174>,<6170,6173,6174>,<6170,6171,6173>,
              <6171,6172,6173>
<6176,6177,6183>,<6177,6182,6183>,<6177,6178,6182>,<6178,6181,6182>,<6178,6179,6181>,
              <6179,6180,6181>
<6184,6185,6191>,<6185,6190,6191>,<6185,6186,6190>,<6186,6189,6190>,<6186,6187,6189>,
              <6187,6188,6189>
<6192,6193,6199>,<6193,6198,6199>,<6193,6194,6198>,<6194,6197,6198>,<6194,6195,6197>,
              <6195,6196,6197>
<6200,6201,6207>,<6201,6206,6207>,<6201,6202,6206>,<6202,6205,6206>,<6202,6203,6205>,
              <6203,6204,6205>
<6208,6209,6215>,<6209,6214,6215>,<6209,6210,6214>,<6210,6213,6214>,<6210,6211,6213>,
              <6211,6212,6213>
<6216,6217,6223>,<6217,6222,6223>,<6217,6218,6222>,<6218,6221,6222>,<6218,6219,6221>,
              <6219,6220,6221>
<6224,6225,6231>,<6225,6230,6231>,<6225,6226,6230>,<6226,6229,6230>,<6226,6227,6229>,
              <6227,6228,6229>
<6232,6233,6239>,<6233,6238,6239>,<6233,6234,6238>,<6234,6237,6238>,<6234,6235,6237>,
              <6235,6236,6237>
<6240,6241,6247>,<6241,6246,6247>,<6241,6242,6246>,<6242,6245,6246>,<6242,6243,6245>,
              <6243,6244,6245>
<6248,6249,6255>,<6249,6254,6255>,<6249,6250,6254>,<6250,6253,6254>,<6250,6251,6253>,
              <6251,6252,6253>
<6256,6257,6263>,<6257,6262,6263>,<6257,6258,6262>,<6258,6261,6262>,<6258,6259,6261>,
              <6259,6260,6261>
<6264,6265,6271>,<6265,6270,6271>,<6265,6266,6270>,<6266,6269,6270>,<6266,6267,6269>,
              <6267,6268,6269>
<6272,6273,6279>,<6273,6278,6279>,<6273,6274,6278>,<6274,6277,6278>,<6274,6275,6277>,
              <6275,6276,6277>
<6280,6281,6287>,<6281,6286,6287>,<6281,6282,6286>,<6282,6285,6286>,<6282,6283,6285>,
              <6283,6284,6285>
<6288,6289,6295>,<6289,6294,6295>,<6289,6290,6294>,<6290,6293,6294>,<6290,6291,6293>,
              <6291,6292,6293>
<6296,6297,6303>,<6297,6302,6303>,<6297,6298,6302>,<6298,6301,6302>,<6298,6299,6301>,
              <6299,6300,6301>
<6304,6305,6311>,<6305,6310,6311>,<6305,6306,6310>,<6306,6309,6310>,<6306,6307,6309>,
              <6307,6308,6309>
<6312,6313,6319>,<6313,6318,6319>,<6313,6314,6318>,<6314,6317,6318>,<6314,6315,6317>,
              <6315,6316,6317>
<6320,6321,6327>,<6321,6326,6327>,<6321,6322,6326>,<6322,6325,6326>,<6322,6323,6325>,
              <6323,6324,6325>
<6328,6329,6335>,<6329,6334,6335>,<6329,6330,6334>,<6330,6333,6334>,<6330,6331,6333>,
              <6331,6332,6333>
<6336,6337,6343>,<6337,6342,6343>,<6337,6338,6342>,<6338,6341,6342>,<6338,6339,6341>,
              <6339,6340,6341>
<6344,6345,6351>,<6345,6350,6351>,<6345,6346,6350>,<6346,6349,6350>,<6346,6347,6349>,
              <6347,6348,6349>
<6352,6353,6359>,<6353,6358,6359>,<6353,6354,6358>,<6354,6357,6358>,<6354,6355,6357>,
              <6355,6356,6357>
<6360,6361,6367>,<6361,6366,6367>,<6361,6362,6366>,<6362,6365,6366>,<6362,6363,6365>,
              <6363,6364,6365>
<6368,6369,6375>,<6369,6374,6375>,<6369,6370,6374>,<6370,6373,6374>,<6370,6371,6373>,
              <6371,6372,6373>
<6376,6377,6383>,<6377,6382,6383>,<6377,6378,6382>,<6378,6381,6382>,<6378,6379,6381>,
              <6379,6380,6381>
<6384,6385,6391>,<6385,6390,6391>,<6385,6386,6390>,<6386,6389,6390>,<6386,6387,6389>,
              <6387,6388,6389>
<6392,6393,6399>,<6393,6398,6399>,<6393,6394,6398>,<6394,6397,6398>,<6394,6395,6397>,
              <6395,6396,6397>
<6400,6401,6407>,<6401,6406,6407>,<6401,6402,6406>,<6402,6405,6406>,<6402,6403,6405>,
              <6403,6404,6405>
<6408,6409,6415>,<6409,6414,6415>,<6409,6410,6414>,<6410,6413,6414>,<6410,6411,6413>,
              <6411,6412,6413>
<6416,6417,6423>,<6417,6422,6423>,<6417,6418,6422>,<6418,6421,6422>,<6418,6419,6421>,
              <6419,6420,6421>
<6424,6425,6431>,<6425,6430,6431>,<6425,6426,6430>,<6426,6429,6430>,<6426,6427,6429>,
              <6427,6428,6429>
<6432,6433,6439>,<6433,6438,6439>,<6433,6434,6438>,<6434,6437,6438>,<6434,6435,6437>,
              <6435,6436,6437>
<6440,6441,6447>,<6441,6446,6447>,<6441,6442,6446>,<6442,6445,6446>,<6442,6443,6445>,
              <6443,6444,6445>
<6448,6449,6455>,<6449,6454,6455>,<6449,6450,6454>,<6450,6453,6454>,<6450,6451,6453>,
              <6451,6452,6453>
<6456,6457,6463>,<6457,6462,6463>,<6457,6458,6462>,<6458,6461,6462>,<6458,6459,6461>,
              <6459,6460,6461>
<6464,6465,6471>,<6465,6470,6471>,<6465,6466,6470>,<6466,6469,6470>,<6466,6467,6469>,
              <6467,6468,6469>
<6472,6473,6479>,<6473,6478,6479>,<6473,6474,6478>,<6474,6477,6478>,<6474,6475,6477>,
              <6475,6476,6477>
<6480,6481,6487>,<6481,6486,6487>,<6481,6482,6486>,<6482,6485,6486>,<6482,6483,6485>,
              <6483,6484,6485>
<6488,6489,6495>,<6489,6494,6495>,<6489,6490,6494>,<6490,6493,6494>,<6490,6491,6493>,
              <6491,6492,6493>
<6496,6497,6503>,<6497,6502,6503>,<6497,6498,6502>,<6498,6501,6502>,<6498,6499,6501>,
              <6499,6500,6501>
<6504,6505,6511>,<6505,6510,6511>,<6505,6506,6510>,<6506,6509,6510>,<6506,6507,6509>,
              <6507,6508,6509>
<6512,6513,6519>,<6513,6518,6519>,<6513,6514,6518>,<6514,6517,6518>,<6514,6515,6517>,
              <6515,6516,6517>
<6520,6521,6527>,<6521,6526,6527>,<6521,6522,6526>,<6522,6525,6526>,<6522,6523,6525>,
              <6523,6524,6525>
<6528,6529,6535>,<6529,6534,6535>,<6529,6530,6534>,<6530,6533,6534>,<6530,6531,6533>,
              <6531,6532,6533>
<6536,6537,6543>,<6537,6542,6543>,<6537,6538,6542>,<6538,6541,6542>,<6538,6539,6541>,
              <6539,6540,6541>
<6544,6545,6551>,<6545,6550,6551>,<6545,6546,6550>,<6546,6549,6550>,<6546,6547,6549>,
              <6547,6548,6549>
<6552,6553,6559>,<6553,6558,6559>,<6553,6554,6558>,<6554,6557,6558>,<6554,6555,6557>,
              <6555,6556,6557>
<6560,6561,6567>,<6561,6566,6567>,<6561,6562,6566>,<6562,6565,6566>,<6562,6563,6565>,
              <6563,6564,6565>
<6568,6569,6575>,<6569,6574,6575>,<6569,6570,6574>,<6570,6573,6574>,<6570,6571,6573>,
              <6571,6572,6573>
<6576,6577,6583>,<6577,6582,6583>,<6577,6578,6582>,<6578,6581,6582>,<6578,6579,6581>,
              <6579,6580,6581>
<6584,6585,6591>,<6585,6590,6591>,<6585,6586,6590>,<6586,6589,6590>,<6586,6587,6589>,
              <6587,6588,6589>
<6592,6593,6599>,<6593,6598,6599>,<6593,6594,6598>,<6594,6597,6598>,<6594,6595,6597>,
              <6595,6596,6597>
<6600,6601,6607>,<6601,6606,6607>,<6601,6602,6606>,<6602,6605,6606>,<6602,6603,6605>,
              <6603,6604,6605>
<6608,6609,6615>,<6609,6614,6615>,<6609,6610,6614>,<6610,6613,6614>,<6610,6611,6613>,
              <6611,6612,6613>
<6616,6617,6623>,<6617,6622,6623>,<6617,6618,6622>,<6618,6621,6622>,<6618,6619,6621>,
              <6619,6620,6621>
<6624,6625,6631>,<6625,6630,6631>,<6625,6626,6630>,<6626,6629,6630>,<6626,6627,6629>,
              <6627,6628,6629>
<6632,6633,6639>,<6633,6638,6639>,<6633,6634,6638>,<6634,6637,6638>,<6634,6635,6637>,
              <6635,6636,6637>
<6640,6641,6647>,<6641,6646,6647>,<6641,6642,6646>,<6642,6645,6646>,<6642,6643,6645>,
              <6643,6644,6645>
<6648,6649,6655>,<6649,6654,6655>,<6649,6650,6654>,<6650,6653,6654>,<6650,6651,6653>,
              <6651,6652,6653>
<6656,6657,6663>,<6657,6662,6663>,<6657,6658,6662>,<6658,6661,6662>,<6658,6659,6661>,
              <6659,6660,6661>
<6664,6665,6671>,<6665,6670,6671>,<6665,6666,6670>,<6666,6669,6670>,<6666,6667,6669>,
              <6667,6668,6669>
<6672,6673,6679>,<6673,6678,6679>,<6673,6674,6678>,<6674,6677,6678>,<6674,6675,6677>,
              <6675,6676,6677>
<6680,6681,6687>,<6681,6686,6687>,<6681,6682,6686>,<6682,6685,6686>,<6682,6683,6685>,
              <6683,6684,6685>
<6688,6689,6695>,<6689,6694,6695>,<6689,6690,6694>,<6690,6693,6694>,<6690,6691,6693>,
              <6691,6692,6693>
<6696,6697,6703>,<6697,6702,6703>,<6697,6698,6702>,<6698,6701,6702>,<6698,6699,6701>,
              <6699,6700,6701>
<6704,6705,6711>,<6705,6710,6711>,<6705,6706,6710>,<6706,6709,6710>,<6706,6707,6709>,
              <6707,6708,6709>
<6712,6713,6719>,<6713,6718,6719>,<6713,6714,6718>,<6714,6717,6718>,<6714,6715,6717>,
              <6715,6716,6717>
<6720,6721,6727>,<6721,6726,6727>,<6721,6722,6726>,<6722,6725,6726>,<6722,6723,6725>,
              <6723,6724,6725>
<6728,6729,6735>,<6729,6734,6735>,<6729,6730,6734>,<6730,6733,6734>,<6730,6731,6733>,
              <6731,6732,6733>
<6736,6737,6743>,<6737,6742,6743>,<6737,6738,6742>,<6738,6741,6742>,<6738,6739,6741>,
              <6739,6740,6741>
<6744,6745,6751>,<6745,6750,6751>,<6745,6746,6750>,<6746,6749,6750>,<6746,6747,6749>,
              <6747,6748,6749>
<6752,6753,6759>,<6753,6758,6759>,<6753,6754,6758>,<6754,6757,6758>,<6754,6755,6757>,
              <6755,6756,6757>
<6760,6761,6767>,<6761,6766,6767>,<6761,6762,6766>,<6762,6765,6766>,<6762,6763,6765>,
              <6763,6764,6765>
<6768,6769,6775>,<6769,6774,6775>,<6769,6770,6774>,<6770,6773,6774>,<6770,6771,6773>,
              <6771,6772,6773>
<6776,6777,6783>,<6777,6782,6783>,<6777,6778,6782>,<6778,6781,6782>,<6778,6779,6781>,
              <6779,6780,6781>
<6784,6785,6791>,<6785,6790,6791>,<6785,6786,6790>,<6786,6789,6790>,<6786,6787,6789>,
              <6787,6788,6789>
<6792,6793,6799>,<6793,6798,6799>,<6793,6794,6798>,<6794,6797,6798>,<6794,6795,6797>,
              <6795,6796,6797>
<6800,6801,6807>,<6801,6806,6807>,<6801,6802,6806>,<6802,6805,6806>,<6802,6803,6805>,
              <6803,6804,6805>
<6808,6809,6815>,<6809,6814,6815>,<6809,6810,6814>,<6810,6813,6814>,<6810,6811,6813>,
              <6811,6812,6813>
<6816,6817,6823>,<6817,6822,6823>,<6817,6818,6822>,<6818,6821,6822>,<6818,6819,6821>,
              <6819,6820,6821>
<6824,6825,6831>,<6825,6830,6831>,<6825,6826,6830>,<6826,6829,6830>,<6826,6827,6829>,
              <6827,6828,6829>
<6832,6833,6839>,<6833,6838,6839>,<6833,6834,6838>,<6834,6837,6838>,<6834,6835,6837>,
              <6835,6836,6837>
<6840,6841,6847>,<6841,6846,6847>,<6841,6842,6846>,<6842,6845,6846>,<6842,6843,6845>,
              <6843,6844,6845>
<6848,6849,6855>,<6849,6854,6855>,<6849,6850,6854>,<6850,6853,6854>,<6850,6851,6853>,
              <6851,6852,6853>
<6856,6857,6863>,<6857,6862,6863>,<6857,6858,6862>,<6858,6861,6862>,<6858,6859,6861>,
              <6859,6860,6861>
<6864,6865,6871>,<6865,6870,6871>,<6865,6866,6870>,<6866,6869,6870>,<6866,6867,6869>,
              <6867,6868,6869>
<6872,6873,6879>,<6873,6878,6879>,<6873,6874,6878>,<6874,6877,6878>,<6874,6875,6877>,
              <6875,6876,6877>
<6880,6881,6887>,<6881,6886,6887>,<6881,6882,6886>,<6882,6885,6886>,<6882,6883,6885>,
              <6883,6884,6885>
<6888,6889,6895>,<6889,6894,6895>,<6889,6890,6894>,<6890,6893,6894>,<6890,6891,6893>,
              <6891,6892,6893>
<6896,6897,6903>,<6897,6902,6903>,<6897,6898,6902>,<6898,6901,6902>,<6898,6899,6901>,
              <6899,6900,6901>
<6904,6905,6911>,<6905,6910,6911>,<6905,6906,6910>,<6906,6909,6910>,<6906,6907,6909>,
              <6907,6908,6909>
<6912,6913,6919>,<6913,6918,6919>,<6913,6914,6918>,<6914,6917,6918>,<6914,6915,6917>,
              <6915,6916,6917>
<6920,6921,6927>,<6921,6926,6927>,<6921,6922,6926>,<6922,6925,6926>,<6922,6923,6925>,
              <6923,6924,6925>
<6928,6929,6935>,<6929,6934,6935>,<6929,6930,6934>,<6930,6933,6934>,<6930,6931,6933>,
              <6931,6932,6933>
<6936,6937,6943>,<6937,6942,6943>,<6937,6938,6942>,<6938,6941,6942>,<6938,6939,6941>,
              <6939,6940,6941>
<6944,6945,6951>,<6945,6950,6951>,<6945,6946,6950>,<6946,6949,6950>,<6946,6947,6949>,
              <6947,6948,6949>
<6952,6953,6959>,<6953,6958,6959>,<6953,6954,6958>,<6954,6957,6958>,<6954,6955,6957>,
              <6955,6956,6957>
<6960,6961,6967>,<6961,6966,6967>,<6961,6962,6966>,<6962,6965,6966>,<6962,6963,6965>,
              <6963,6964,6965>
<6968,6969,6975>,<6969,6974,6975>,<6969,6970,6974>,<6970,6973,6974>,<6970,6971,6973>,
              <6971,6972,6973>
<6976,6977,6983>,<6977,6982,6983>,<6977,6978,6982>,<6978,6981,6982>,<6978,6979,6981>,
              <6979,6980,6981>
<6984,6985,6991>,<6985,6990,6991>,<6985,6986,6990>,<6986,6989,6990>,<6986,6987,6989>,
              <6987,6988,6989>
<6992,6993,6999>,<6993,6998,6999>,<6993,6994,6998>,<6994,6997,6998>,<6994,6995,6997>,
              <6995,6996,6997>
<7000,7001,7007>,<7001,7006,7007>,<7001,7002,7006>,<7002,7005,7006>,<7002,7003,7005>,
              <7003,7004,7005>
<7008,7009,7015>,<7009,7014,7015>,<7009,7010,7014>,<7010,7013,7014>,<7010,7011,7013>,
              <7011,7012,7013>
<7016,7017,7023>,<7017,7022,7023>,<7017,7018,7022>,<7018,7021,7022>,<7018,7019,7021>,
              <7019,7020,7021>
<7024,7025,7031>,<7025,7030,7031>,<7025,7026,7030>,<7026,7029,7030>,<7026,7027,7029>,
              <7027,7028,7029>
<7032,7033,7039>,<7033,7038,7039>,<7033,7034,7038>,<7034,7037,7038>,<7034,7035,7037>,
              <7035,7036,7037>
<7040,7041,7047>,<7041,7046,7047>,<7041,7042,7046>,<7042,7045,7046>,<7042,7043,7045>,
              <7043,7044,7045>
<7048,7049,7055>,<7049,7054,7055>,<7049,7050,7054>,<7050,7053,7054>,<7050,7051,7053>,
              <7051,7052,7053>
<7056,7057,7063>,<7057,7062,7063>,<7057,7058,7062>,<7058,7061,7062>,<7058,7059,7061>,
              <7059,7060,7061>
<7064,7065,7071>,<7065,7070,7071>,<7065,7066,7070>,<7066,7069,7070>,<7066,7067,7069>,
              <7067,7068,7069>
<7072,7073,7079>,<7073,7078,7079>,<7073,7074,7078>,<7074,7077,7078>,<7074,7075,7077>,
              <7075,7076,7077>
<7080,7081,7087>,<7081,7086,7087>,<7081,7082,7086>,<7082,7085,7086>,<7082,7083,7085>,
              <7083,7084,7085>
<7088,7089,7095>,<7089,7094,7095>,<7089,7090,7094>,<7090,7093,7094>,<7090,7091,7093>,
              <7091,7092,7093>
<7096,7097,7103>,<7097,7102,7103>,<7097,7098,7102>,<7098,7101,7102>,<7098,7099,7101>,
              <7099,7100,7101>
<7104,7105,7111>,<7105,7110,7111>,<7105,7106,7110>,<7106,7109,7110>,<7106,7107,7109>,
              <7107,7108,7109>
<7112,7113,7119>,<7113,7118,7119>,<7113,7114,7118>,<7114,7117,7118>,<7114,7115,7117>,
              <7115,7116,7117>
<7120,7121,7127>,<7121,7126,7127>,<7121,7122,7126>,<7122,7125,7126>,<7122,7123,7125>,
              <7123,7124,7125>
<7128,7129,7135>,<7129,7134,7135>,<7129,7130,7134>,<7130,7133,7134>,<7130,7131,7133>,
              <7131,7132,7133>
<7136,7137,7143>,<7137,7142,7143>,<7137,7138,7142>,<7138,7141,7142>,<7138,7139,7141>,
              <7139,7140,7141>
<7144,7145,7151>,<7145,7150,7151>,<7145,7146,7150>,<7146,7149,7150>,<7146,7147,7149>,
              <7147,7148,7149>
<7152,7153,7159>,<7153,7158,7159>,<7153,7154,7158>,<7154,7157,7158>,<7154,7155,7157>,
              <7155,7156,7157>
<7160,7161,7167>,<7161,7166,7167>,<7161,7162,7166>,<7162,7165,7166>,<7162,7163,7165>,
              <7163,7164,7165>
<7168,7169,7175>,<7169,7174,7175>,<7169,7170,7174>,<7170,7173,7174>,<7170,7171,7173>,
              <7171,7172,7173>
<7176,7177,7183>,<7177,7182,7183>,<7177,7178,7182>,<7178,7181,7182>,<7178,7179,7181>,
              <7179,7180,7181>
<7184,7185,7191>,<7185,7190,7191>,<7185,7186,7190>,<7186,7189,7190>,<7186,7187,7189>,
              <7187,7188,7189>
     }
}
