#macro block(center,w,h,d,Q,S,tex)

#local xoff1 = rand(S)*400+rand(S)*40;
#local yoff1 = rand(S)*400+rand(S)*40;
#local zoff1 = rand(S)*400+rand(S)*40;
#local xoff2 = rand(S)*400+rand(S)*40;
#local yoff2 = rand(S)*400+rand(S)*40;
#local xoff3 = rand(S)*400+rand(S)*40;
#local yoff3 = rand(S)*400+rand(S)*40;

#local xrot = (rand(S)*2+rand(S)*.1)-1;
#local yrot = (rand(S)*2+rand(S)*.1)-1;
#local zrot = (rand(S)*2+rand(S)*.1)-1;

#local dens = 1;

#local w = .98 * w;
#local h = .9 * h;

#local block_trans =
transform{
  rotate xrot*x
  rotate yrot*y
  rotate zrot*z
  }

#if ( Q = 0)
  box{ 
    <-w/2,-h/2,-d/2>,<w/2,h/2,d/2>
    scale .92
    translate center + <w/2,h/2,0>
    texture{ tex scale 60 translate <xoff2,yoff1,xoff3> }
    //transform{ block_trans }
    }
#end

#local Min_factor= 0.6;

#if ( Q = 1)
  isosurface {                                  
          function {
             -f_superellipsoid(x*(3.4/w),y*(3.4/h),z*(3.4/d), .2, .2) 
             -  f_noise3d(x/5+xoff1, y/5+yoff1 , z/5+zoff1)*.8
             -  f_agate(x/8+xoff3, y/8+yoff3, z/8)*.3
             -  f_agate(x/2+xoff3, y/2+yoff3, z/2)*.3
             }
          
          evaluate 1.5*Min_factor,  sqrt(1.5/(1.5*Min_factor)),  0.7
          
          contained_by{ box{ <-w/1.6,-h/1.6,-d/1.6>,<w/1.6,h/1.6,d/1.6> } }
          translate center + <w/2,h/2,0>
          texture{ tex scale 60 translate <xoff2,yoff1,xoff3> }
          //transform{ block_trans }
  }
#end


#if ( Q = 2)
  isosurface {                                  
          function {
             -f_superellipsoid(x*(3.1/w),y*(3.1/h),z*(3.5/d), .6, .1) 
             -  f_noise3d(x/5+xoff1, y/5+yoff1 , z/5+zoff1)*.6
             -  f_agate(x/15+xoff3, y/15+yoff3, z/15)*.3
             -  f_agate(x/8+xoff3, y/8+yoff3, z/8)*.3
             }
             
          evaluate 2*Min_factor,  sqrt(2/(2*Min_factor)),  0.7
          
          contained_by{ box{ <-w/1.6,-h/1.6,-d/1.6>,<w/1.6,h/1.6,d/1.6> } }
          translate center + <w/2,h/2,0>
          texture{ tex scale 60 translate <xoff2,yoff1,xoff3> }
          //transform{ block_trans }
  }
#end

#if ( Q = 3)
  isosurface {                                  
          function {
             -f_superellipsoid(x*(2.5/w),y*(2.5/h),z*(2.5/d), .1, .1) 
             -  f_noise3d(x/5+xoff1, y/5+yoff1 , z/5+zoff1)*.2
             -  f_agate(x/8+xoff3, y/8+yoff3, z/8)*.1
             -  f_agate(x/2+xoff3, y/2+yoff3, z/2)*.1
             }
          
          evaluate 1.5*Min_factor,  sqrt(1.5/(1.5*Min_factor)),  0.7
          
          contained_by{ box{ <-w/1.6,-h/1.6,-d/1.6>,<w/1.6,h/1.6,d/1.6> } }
          translate center + <w/2,h/2,0>
          texture{ tex scale 60 translate <xoff2,yoff1,xoff3> }
          //transform{ block_trans }
  }
#end
  
    
#end