#declare cable_frame_large_a =
union{
  box{ <-.5,0,-.5> <.5,124.5,.5> translate -16.5*x rotate -4.12*z }
  box{ <-.5,0,-.5> <.5,124.5,.5> translate 16.5*x rotate 4.12*z }
  box{ <-7.5,-.5,-.5> <7.5,.5,.5> translate 125*y }
  }
  
#declare cable_frame_small_a =
union{
  box{ <-.5,-10,-.5> <.5,113.5,.5> translate -16.5*x rotate -4.12*z }
  box{ <-.5,-10,-.5> <.5,113.5,.5> translate 16.5*x rotate 4.12*z }
  box{ <-8.3,-.5,-.5> <8.3,.5,.5> translate 114*y }
  box{ <-.2,-.2,0> <.2,.2,60.5> translate <-9.88,91.5,0> }
  translate -60.5*z
  }  

#declare side_support =
union{
  //long side beams
  box{ <0,-.2,-.2> <60.5,.2,.2> translate 2*y }
  box{ <0,-.2,-.2> <60.5,.2,.2> translate -2*y }
  //angled supports along truss
  #declare counter = 0;
  #while ( counter < 12 )  
    box{ <0,-.1,-.1> <6.44,.1,.1> rotate 38.43*z translate -2*y translate 5.04166*counter*x }
    box{ <0,-.1,-.1> <6.44,.1,.1> rotate -38.43*z translate 2*y translate 5.04166*counter*x }
    #declare counter = counter + 1;
  #end
  //square gussets top and bottom along truss
  #declare counter = 1;
  #while ( counter < 12 )  
    box{ <-.8,0,-.1> <.8,.7,.1> translate -2*y translate 5.04166*counter*x }
    box{ <-.8,0,-.1> <.8,-.7,.1> translate 2*y translate 5.04166*counter*x }
    #declare counter = counter + 1;
  #end
  // triangle gussets for large angled supports
  prism{ linear_spline -.1,.1,4 <-1,0>,<.5,0>,<-1,1>,<-1,0> rotate -90*x translate <2*5.04166,2,0> }
  prism{ linear_spline -.1,.1,4 <-1,0>,<.5,0>,<-1,1>,<-1,0> rotate -90*x rotate 180*x translate <2*5.04166,-2,0> }
  prism{ linear_spline -.1,.1,4 <-1,0>,<.5,0>,<-1,1>,<-1,0> rotate -90*x rotate 180*y translate <10*5.04166,2,0> }
  prism{ linear_spline -.1,.1,4 <-1,0>,<.5,0>,<-1,1>,<-1,0> rotate -90*x rotate 180*y rotate 180*x translate <10*5.04166,-2,0> }
  //vertical supports in truss
  box{ <-.1,-2,-.1> <.1,2,.1> translate 2*5.04166*x }
  box{ <-.1,-2,-.1> <.1,2,.1> translate 10*5.04166*x }
  box{ <-1.1,-2,-.1> <1.1,2,.1> translate 6*5.04166*x }
  box{ <-.5,-2,-.1> <.5,2,.1> translate 1*x }
  box{ <-.5,-2,-.1> <.5,2,.1> translate 59.5*x }
  //large angled supports in truss
  box{ <-14.26,-.1,-.1> <0,.1,.1> rotate -45*z translate <2*5.04166,2,0> }
  box{ <-14.26,-.1,-.1> <0,.1,.1> rotate 45*z translate <2*5.04166,-2,0> }
  box{ <0,-.1,-.1> <14.26,.1,.1> rotate 45*z translate <10*5.04166,2,0> }
  box{ <0,-.1,-.1> <14.26,.1,.1> rotate -45*z translate <10*5.04166,-2,0> }
  //braces for center support
  box{ <-.1,-.1,-5.66> <0,.1,0> rotate 45*y translate <30.25,2,4> }
  box{ <-.1,-.1,-5.66> <0,.1,0> rotate -45*y translate <30.25,2,4> }
  rotate 90*y 
  } 

#declare center_support_low =
union{
  object{ perf_beam(2*13.48,.2,1) translate <-13.48,2,0> }    
  object{ perf_beam(2*13.76,.2,1) translate <-13.76,-2,0> }
  box{ <-9.63,-.07,-.07> <0,.07,.07> rotate 24.53*z translate <-5,2,.5> }
  box{ <-10.77,-.07,-.07> <0,.07,.07> rotate 21.80*z translate <5,2,.5> }
  box{ <-9.37,-.07,-.07> <0,.07,.07> rotate 25.26*z translate <13.48,2,.5> }
  box{ <-9.63,-.07,-.07> <0,.07,.07> rotate 24.53*z translate <-5,2,-.5> }
  box{ <-10.77,-.07,-.07> <0,.07,.07> rotate 21.80*z translate <5,2,-.5> }
  box{ <-9.37,-.07,-.07> <0,.07,.07> rotate 25.26*z translate <13.48,2,-.5> }
  box{ <-9.63,-.07,-.07> <0,.07,.07> rotate 24.53*z translate <-5,2,.5> scale <-1,1,1> }
  box{ <-10.77,-.07,-.07> <0,.07,.07> rotate 21.80*z translate <5,2,.5> scale <-1,1,1> }
  box{ <-9.37,-.07,-.07> <0,.07,.07> rotate 25.26*z translate <13.48,2,.5> scale <-1,1,1> }
  box{ <-9.63,-.07,-.07> <0,.07,.07> rotate 24.53*z translate <-5,2,-.5> scale <-1,1,1> }
  box{ <-10.77,-.07,-.07> <0,.07,.07> rotate 21.80*z translate <5,2,-.5> scale <-1,1,1> }
  box{ <-9.37,-.07,-.07> <0,.07,.07> rotate 25.26*z translate <13.48,2,-.5> scale <-1,1,1> }
  }

#declare center_support_low_mid =
union{
  box{ <-13.48,-.1,-.1> <13.48,.1,.1> translate <0,2,0> }
  box{ <-13.76,-.1,-.1> <13.76,.1,.1> translate <0,-2,0> }
  box{ <-9.63,-.07,-.07> <0,.07,.07> rotate 24.53*z translate <-5,2,0> }
  box{ <-10.77,-.07,-.07> <0,.07,.07> rotate 21.80*z translate <5,2,0> }
  box{ <-9.37,-.07,-.07> <0,.07,.07> rotate 25.26*z translate <13.48,2,0> }
  box{ <-9.63,-.07,-.07> <0,.07,.07> rotate 24.53*z translate <-5,2,0> scale <-1,1,1> }
  box{ <-10.77,-.07,-.07> <0,.07,.07> rotate 21.80*z translate <5,2,0> scale <-1,1,1> }
  box{ <-9.37,-.07,-.07> <0,.07,.07> rotate 25.26*z translate <13.48,2,0> scale <-1,1,1> } 
  }
  
#declare center_support_high =
union{
  object{ perf_beam(2*9.73,.2,.7) translate <-9.73,2,0> }
  object{ perf_beam(2*10.02,.2,.7) translate <-10.02,-2,0> }
  box{ <-7.23,-.07,-.07> <0,.07,.07> rotate 33.6*z translate <-4,2,-.3> }
  box{ <-8.94,-.07,-.07> <0,.07,.07> rotate 26.57*z translate <4,2,-.3> }
  box{ <-6.99,-.07,-.07> <0,.07,.07> rotate 34.91*z translate <9.73,2,-.3> }
  box{ <-7.23,-.07,-.07> <0,.07,.07> rotate 33.6*z translate <-4,2,.3> }
  box{ <-8.94,-.07,-.07> <0,.07,.07> rotate 26.57*z translate <4,2,.3> }
  box{ <-6.99,-.07,-.07> <0,.07,.07> rotate 34.91*z translate <9.73,2,.3> }  
  box{ <-7.23,-.07,-.07> <0,.07,.07> rotate 33.6*z translate <-4,2,-.3> scale <-1,1,1> }
  box{ <-8.94,-.07,-.07> <0,.07,.07> rotate 26.57*z translate <4,2,-.3> scale <-1,1,1> }
  box{ <-6.99,-.07,-.07> <0,.07,.07> rotate 34.91*z translate <9.73,2,-.3> scale <-1,1,1> }
  box{ <-7.23,-.07,-.07> <0,.07,.07> rotate 33.6*z translate <-4,2,.3> scale <-1,1,1> }
  box{ <-8.94,-.07,-.07> <0,.07,.07> rotate 26.57*z translate <4,2,.3> scale <-1,1,1> }
  box{ <-6.99,-.07,-.07> <0,.07,.07> rotate 34.91*z translate <9.73,2,.3> scale <-1,1,1> } 
  }

#declare center_support_high_mid =
union{
  box{ <-9.73,-.1,-.1> <9.73,.1,.1> translate <0,2,0> }
  box{ <-10.02,-.1,-.1> <10.02,.1,.1> translate <0,-2,0> }
  box{ <-7.23,-.07,-.07> <0,.07,.07> rotate 33.6*z translate <-4,2,0> }
  box{ <-8.94,-.07,-.07> <0,.07,.07> rotate 26.57*z translate <4,2,0> }
  box{ <-6.99,-.07,-.07> <0,.07,.07> rotate 34.91*z translate <9.73,2,0> }
  box{ <-7.23,-.07,-.07> <0,.07,.07> rotate 33.6*z translate <-4,2,0> scale <-1,1,1> }
  box{ <-8.94,-.07,-.07> <0,.07,.07> rotate 26.57*z translate <4,2,0> scale <-1,1,1> }
  box{ <-6.99,-.07,-.07> <0,.07,.07> rotate 34.91*z translate <9.73,2,0> scale <-1,1,1> }  
  }

#declare center_ties =
union{
  union{
    object{ perf_beam(2*11.75,.3,.8) translate <-11.75,0,0> }
    box{ <-32.4,-.05,-.05> <0,.05,.05> rotate -47.79*z translate 11.75*x }
    box{ <-34.82,-.05,-.05> <0,.05,.05> rotate 43.58*z translate 11.75*x }
    box{ <-32.4,-.05,-.05> <0,.05,.05> rotate -47.79*z translate 11.75*x scale <-1,1,1> }
    box{ <-34.82,-.05,-.05> <0,.05,.05> rotate 43.58*z translate 11.75*x scale <-1,1,1> }
    box{ <-.05,0,-.05> <.05,12.95,.05> }
    cylinder{ <0,0,-.2> <0,0,.2>, .5 translate 12.95*y }
    cylinder{ <0,0,-.2> <0,0,.2>, .5 translate -11.18*y }
    translate 66*y
  }
  union{
    box{ <-15.42,-.4,-.4> <15.42,.4,.4> }
    box{ <-37.16,-.05,-.05> <0,.05,.05> rotate -38.24*z translate 15.42*x }
    box{ <-37.16,-.05,-.05> <0,.05,.05> rotate -38.24*z translate 15.42*x scale <-1,1,1> }
    box{ <-.05,0,-.05> <.05,12.15,.05> }
    cylinder{ <0,0,-.2> <0,0,.2>, .5 translate 12.15*y }
    translate 15*y
    }
  }

#declare tri_basket =
union{
  box{ <-.15,-.15,-4> <.15,.15,0> translate 2*y }
  box{ <-.15,-.15,-5.66> <.15,.15,0> rotate 45*x translate -2*y }
  box{ <-.15,-.15,-4> <.15,.15,0> translate <5.5,2,0> }
  box{ <-.15,-.15,-5.66> <.15,.15,0> rotate 45*x translate -2*y translate 5.5*x }  
  box{ <0,-.15,-.15> <5.5,.15,.15> translate <0,2,-4> }
  translate -.5*x
  rotate 90*y
  rotate -4.12*z translate <-9.88,92,0> 
  }
  
#declare Link = cylinder{ <0,0,0> <1,0,0>, .06 }    
  
#declare wheel_tall =
union{
  //framework
  object{ perf_beam(2*8.51,.3,.8) translate -8.51*x }
  box{ <-8.51,-.2,-1.5> <8.51,.2,1.5> translate 1.7*z }
  box{ <-8.51,-.2,-.2> <8.51,.2,.2> translate -3*z }
  box{ <-8.51,-.2,-.2> <8.51,.2,.2> translate -5*z }
  box{ <-.2,-.2,-5> <.2,.2,3.2> translate -8.51*x }
  box{ <-.2,-.2,-5> <.2,.2,3.2> translate 8.51*x }
  box{ <-.2,-.2,-5> <.2,.2,3.2> }
  box{ <-.2,-.2,-5> <.2,.2,3.2> translate <8.51,3,0> }
  box{ <-.2,0,-.2> <.2,3,.2> translate <8.51,0,-5> }
  box{ <-.5,0,-.5> <.5,14,.5> }
  //pulleys
  cylinder{ <0,0,0> <8,0,0>, .2 translate <0,7,-.5> }
  object{ pulley(5,.35) translate <4,7,-.5> }
  cylinder{ <-8.18,0,0> <0,0,0>, .2 translate <0,4.5,-.5> }
  object{ pulley(6,.35) rotate 32*x translate <-1,4.5,-.5> }
  //supports
  box{ <-.1,-.1,0> <.1,.1,7.07> rotate 45*x translate <8.51,0,-5> }
  box{ <-.1,-.1,0> <.1,.1,7.07> rotate 45*x translate <-8.51,0,-5> }
  box{ <-.1,-.1,-5.94> <.1,.1,0> rotate -57.38*x translate <8.51,0,3.2> }
  box{ <-.1,-.1,-5.94> <.1,.1,0> rotate -57.38*x translate <-8.51,0,3.2> }
  //ties
  box{ <0,-.05,-.05> <24.93,.05,.05> rotate -42.98*z translate -8.51*x }
  box{ <0,-.05,-.05> <24.93,.05,.05> rotate -42.98*z translate -8.51*x scale <-1,1,1> }
  cylinder{ <0,0,-.2> <0,0,.2>, .5 translate -7.93*y } 
  translate 111*y
  }

#declare wheel_short =
union{
  //framework
  object{ perf_beam(2*9,.3,.8) translate -9*x }
  object{ perf_beam(2*9,.3,3) translate <-9,0,1.7> }
  //box{ <-9,-.2,-1.5> <9,.2,1.5> translate 1.7*z }
  box{ <-9,-.2,-.2> <9,.2,.2> translate -3*z }
  box{ <-9,-.2,-.2> <9,.2,.2> translate -5*z }
  box{ <-.2,-.2,-5> <.2,.2,3.2> translate -9*x }
  box{ <-.2,-.2,-5> <.2,.2,3.2> translate 9*x }
  box{ <-.2,-.2,-5> <.2,.2,3.2> }
  box{ <-.2,-.2,-5> <.2,.2,3.2> translate <9,3,0> }
  box{ <-.2,0,-.2> <.2,3,.2> translate <9,0,-5> }
  //pulleys
  //cylinder{ <0,0,0> <8,0,0>, .2 translate <0,7,-.5> }
  //object{ pulley(5,.35) translate <4,7,-.5> }
  cylinder{ <-8.18,0,0> <0,0,0>, .2 translate <0,4.5,-.5> }
  object{ pulley(6,.35) rotate 32*x translate <-1,4.5,-.5> }
  //supports
  box{ <-.1,-.1,0> <.1,.1,7.07> rotate 45*x translate <9,0,-5> }
  box{ <-.1,-.1,0> <.1,.1,7.07> rotate 45*x translate <-9,0,-5> }
  box{ <-.1,-.1,-5.94> <.1,.1,0> rotate -57.38*x translate <9,0,3.2> }
  box{ <-.1,-.1,-5.94> <.1,.1,0> rotate -57.38*x translate <-9,0,3.2> }
  //ties
  box{ <0,-.05,-.05> <24.93,.05,.05> rotate -42.98*z translate -9*x }
  box{ <0,-.05,-.05> <24.93,.05,.05> rotate -42.98*z translate -9*x scale <-1,1,1> }
  cylinder{ <0,0,-.2> <0,0,.2>, .5 translate -7.93*y }
  rotate 180*y 
  translate 103*y
  }

#declare cable_support =
union{
  union{
    object{ cable_frame_large_a }
    object{ cable_frame_small_a }
    object{ side_support rotate -4.12*z translate <-13.6,40,0>}  
    object{ side_support rotate -4.12*z translate <-13.6,40,0> scale <-1,1,1> }
    object{ side_support rotate -4.12*z translate <-9.88,92,0>}  
    object{ side_support rotate -4.12*z translate <-9.88,92,0> scale <-1,1,1> }
    object{ center_support_low translate <0,40,0> }
    object{ center_support_low_mid translate <0,40,-30.25> }
    object{ center_support_low translate <0,40,-60.5> }
    object{ center_support_high translate <0,92,0> }
    object{ center_support_high_mid translate <0,92,-30.25> }
    object{ center_support_high translate <0,92,-60.5> }
    object{ center_ties }
    object{ center_ties translate -60.5*z }
    object{ tri_basket }
    object{ tri_basket translate (-60.5+4.5)*z}
    object{ wheel_tall }
    object{ wheel_short translate -60.5*z }
    texture{ rusted_metal_tex }
    }
  union{  
    object{ ladder(23,1.5,1) rotate 90*y rotate -4.12*z rotate -.4*x translate <-14.3,42,-60.5> }
    object{ ladder(25,1.5,1) rotate 90*y rotate -4.12*z rotate .2*x translate <-13,66,-60.4> }
    object{ ladder(33,1.5,1) rotate 90*y rotate -4.12*z rotate .2*x translate <-10.7,91,0> }
    object{ ladder(15,1.5,1) rotate 90*y rotate -5*z rotate -.2*x translate <-10.9,91,-60.5> }  
    texture{ dull_steel_tex }
    }
  union{
    cone{ <-5.48,77.8,44.5>, .5 <-5.48,76.9,42>, .03 }
    wire(Link, <-5.48,77.67,44.5>, <-10.48,85.67,0>, 1.05, 1.4, 0)  
    wire(Link, <-10.48,83.67,0>, <-11.5,66,-60.5>, 1.1, 1.4, 0)
    wire(Link, <-11.5,66,-60.5>, <-5.5,-10,-73.5>, 1.02, 1.4, 0)
        
    wire(Link, <10.48,83.67,0>, <11.5,66,-60.5>, 1.1, 1.4, 0)
    wire(Link, <11.5,66,-60.5>, <-2,-10,-70.5>, 1.02, 1.4, 0)
    dangley(<10.48,83.67,0>,10,<0,2,4>,70,.06,seed(1583))
    
    wire(Link, <-3,110,60>, <-8.8,102.89,0>, 1.05, 1.4, 0)
    wire(Link, <-8.8,106.89,0>, <-9.73,94,-60.5>, 1.02, 1.4, 0)
    wire(Link, <-9.73,94,-60.5>, <-3,-10,-65>, 1.02, 1.4, 0)
    
    wire(Link, <8.8,106.89,0>, <-7.73,94,-60.5>, 1.02, 1.4, 0)
    wire(Link, <-7.73,94,-60.5>, <-5,-10,-75>, 1.02, 1.4, 0)
    dangley(<8.8,106.89,0>,10,<0,1,2.5>,60,.06,seed(1586))
    
    texture{ rusted_metal_tex6 }
    }
    
    
  rotate -99*y
  translate <191,6,5>
  }