#macro perf_beam(l,h,w)
  #local cont = box{ <0,-h/2,-w/2> <l,h/2,w/2> }
  #local cutter = box{ <0,-h,-.9*w/2> <2*w,h,.9*w/2> }
  difference{
    object{ cont }
    union{
      #local counter = 0;
      #while ( 2.2*counter*w < l )
        object{ cutter translate 2.2*counter*w*x }
        #declare counter = counter + 1;
      #end
      }
    }
#end



#macro ladder(l,w,r_spac)
  #local leg = cylinder{ <0,0,0> <0,l,0>, .14 }
  #local rung = cylinder{ <-w/2,r_spac,0> <w/2,r_spac,0>, .08 }
 
  union{
    object{ leg translate -w/2*x }
    object{ leg translate w/2*x }
    #local counter = 0;
    #while ( r_spac*counter < l )
      object{ rung translate counter*r_spac*y }
      #declare counter = counter + 1;
    #end
    }
#end



#macro pulley(dia,w)
  union{
    difference{ 
      cylinder{ <-w/2,0,0> <w/2,0,0>, dia/2 }
      cylinder{ <-w,0,0> <w,0,0>, .9*dia/2 }
    }
    #local counter = 0;
    #while ( counter < 7 )
      cylinder{ <0,0,0> <0,0,dia/2>, .9*w/2
        rotate counter*360/7*x
        }
      #declare counter = counter + 1;
    #end      
  }    
#end


#macro dangley(pt2,inf2,init_vect,drop,rad,S)
  #local inf1 = vlength(init_vect);
  #local pt3 = pt2 + inf1*vnormalize(init_vect);
  #local pt1 = pt2 - inf1*vnormalize(init_vect);
  #local pt4 = <pt3.x + (rand(S)*inf2-inf2/2),pt2.y-.25*drop,pt3.z + (rand(S)*inf2-inf2/2)>;
  #local pt5 = <pt4.x + (rand(S)*inf2-inf2/2),pt2.y-.5*drop,pt4.z + (rand(S)*inf2-inf2/2)>;
  #local pt6 = <pt5.x + (rand(S)*inf2-inf2/2),pt2.y-.75*drop,pt5.z + (rand(S)*inf2-inf2/2)>;
  #local pt7 = <pt6.x + (rand(S)*inf2-inf2/2),pt2.y-1.5*drop,pt6.z + (rand(S)*inf2-inf2/2)>;
  #local pt8 = <pt7.x + (rand(S)*inf2-inf2/2),pt2.y-2*drop,pt7.z + (rand(S)*inf2-inf2/2)>;
  sphere_sweep{
    b_spline
    6,
    pt1, rad
    pt2, rad
    pt3, rad
    pt4, rad
    pt5, rad
    pt6, rad
    tolerance .05
  }
#end

#macro lines(len,step,var,S)

#local pole_base1 =
union{
  cone{ <0,0,0>, .6 <0,30,0> .4 }
  cylinder{ <.4,29,-3> <.4,29,3>, .2 }
  cylinder{ <.4,27.8,-3> <.4,27.8,3>, .2 }
  texture{ utility_pole_tex }
  }

#local pole_base2 =
union{
  cone{ <0,0,0>, .6 <0,30,0> .4 }
  cylinder{ <.4,29,-3> <.4,29,3>, .2 }
  cylinder{ <.4,27.8,-3> <.4,27.8,3>, .2 }
  cylinder{ <.8,25,0> <.8,28,0>, .6 texture{ white_molding_tex } }
  texture{ utility_pole_tex }
  }
  
#local pt1_base = <.4,29.2,-2>;
#local pt2_base = <.4,29.2,2>;
#local pt3_base = <.4,28,-2>;
#local pt4_base = <.4,28,2>;
#local pt5_base = <0,20,-.5>;


#local wire_pc1 = cylinder{ <0,0,0> <1,0,0>, .06 }
#local wire_pc2 = cylinder{ <0,0,0> <1,0,0>, .06 }

union{

#local dist = 0;
  #while ( dist < len )
  
  #ifndef ( rot_nex )
    #local rot_cur = <var*rand(S)-var/2,var*rand(S)-var/2,var*rand(S)-var/2>;
    #local pt1_cur = vrotate(pt1_base,rot_cur) ;
    #local pt2_cur = vrotate(pt2_base,rot_cur) ;
    #local pt3_cur = vrotate(pt3_base,rot_cur) ;
    #local pt4_cur = vrotate(pt4_base,rot_cur) ;
    #local pt5_cur = vrotate(pt5_base,rot_cur) ;
  #else
    #local rot_cur = rot_nex;
    #local pt1_cur = pt1_nex;
    #local pt2_cur = pt2_nex;
    #local pt3_cur = pt3_nex;
    #local pt4_cur = pt4_nex;
    #local pt5_cur = pt5_nex;
  #end
   
  #local rot_nex = <var*rand(S)-var/2,var*rand(S)-var/2,var*rand(S)-var/2>;
  #local pt1_nex = vrotate(pt1_base,rot_nex) + <dist,0,0>;
  #local pt2_nex = vrotate(pt2_base,rot_nex) + <dist,0,0>;
  #local pt3_nex = vrotate(pt3_base,rot_nex) + <dist,0,0>;
  #local pt4_nex = vrotate(pt4_base,rot_nex) + <dist,0,0>;
  #local pt5_nex = vrotate(pt5_base,rot_nex) + <dist,0,0>;
  
  #if ( rand(S) > .2 )
    object{ pole_base2 rotate rot_nex translate <dist,0,0> }
  #else
    object{ pole_base1 rotate rot_nex translate <dist,0,0> }
  #end
  
  #if ( dist > 0 )
    object{ wire(wire_pc1, pt1_cur, pt1_nex, 1.01 + rand(S)*.01, 1.4, 0) texture{ utility_cable_tex } }
    object{ wire(wire_pc1, pt2_cur, pt2_nex, 1.01 + rand(S)*.01, 1.4, 0) texture{ utility_cable_tex } }
    object{ wire(wire_pc1, pt3_cur, pt3_nex, 1.01 + rand(S)*.01, 1.4, 0) texture{ utility_cable_tex } }
    object{ wire(wire_pc1, pt4_cur, pt4_nex, 1.01 + rand(S)*.01, 1.4, 0) texture{ utility_cable_tex } }
    object{ wire(wire_pc1, pt5_cur, pt5_nex, 1.01 + rand(S)*.01, 1.4, 0) texture{ utility_cable_tex } }
  #end
  
  #local dist = dist + step;
  
  #end
  
  }

#end  
  



#macro window(S)

  #local grid = 
  union{
    box{ <-.1,0,-.1> <.1,3.5,.1> translate -1.2*x }
    box{ <-.1,0,-.1> <.1,3.5,.1> }
    box{ <-.1,0,-.1> <.1,3.5,.1> translate 1.2*x }
    box{ <-2.5,-.1,-.1> <2.5,.1,.1> translate 1.7*y }
    }
  
  #local pane =
  box{ <-.6,-.8,-.05> <.6,.8,.05> }
  
  
  #local frame =
  union{
    difference{
      box{ <-.1,-.1,-.1> <5.1,7.1,1> }
      box{ <.3,.3,-.4> <4.7,6.7,1.4> }
      }
    box{ <0,3.35,-.1> <5,3.65,1> }
    object{ grid translate <2.5,0,.4> }
    object{ grid translate <2.5,3.5,.1> }
    texture{ window_molding_tex translate 10*rand(S) }
    }

  union{
    object{ frame }
    union{
      #local x_counter = .6;
      #local y_counter = .85;
      #while ( x_counter < 5 )
        #while ( y_counter < 3.5 )
        #local glass_prob = rand(S);
        #if ( glass_prob > .05 )
          object{ pane translate <x_counter,y_counter,.4> }
        #end
        #local y_counter = y_counter + 1.7;
        #end
        #local y_counter = .85;
        #local x_counter = x_counter + 1.2;
      #end
      #local x_counter = .6;
      #local y_counter = .85;
      #while ( x_counter < 5 )
        #while ( y_counter < 3.5 )
        #local glass_prob = rand(S);
        #if ( glass_prob > .05 )
          object{ pane translate <x_counter,y_counter+3.5,.1> }
        #end
        #local y_counter = y_counter + 1.7;
        #end
        #local y_counter = .85;
        #local x_counter = x_counter + 1.2;
      #end
      texture{ glass_tex } texture{ glass_tex2 scale 10 translate 10*rand(S) }
      }    
    }

#end
    


#macro rivet_rows(length,thick,siz)

  #local rivet = sphere{ <0,0,0> siz scale <1,1,.5> }
  
  #local halfstep = siz*3;
  #local dist = halfstep;
  
  union{
    
  #while ( dist <= length | dist+halfstep <= length  )
  
    object{ rivet translate <dist,-thick/2,0> }
    
    #if ( dist+halfstep < length )
      object{ rivet translate <dist+halfstep,thick/2,0> }
    #end
    
    #local dist = dist + 2*halfstep;
    
  #end
  
  }
  
#end


#macro gravel_patch(field_width,field_depth,field_center,particle_count,scale_min,scale_max,obj,sd,tex,randtex)

#local S1 = seed(sd);

#local grav_num = 0;

#local Rock = function { x*x + y*y + z*z - 1*1 };
#local Rough_Rock = 
    function{ Rock(x,y,z) +
              f_noise3d(x*.5,y*.5,z*.5)*2 +
              f_noise3d(x*5,y*5,z*5)*1 -
              f_noise3d(x*3,y*3,z*3)*.6  
    }

#while ( grav_num < particle_count )

  #if ( randtex = 1 )
    #local pig_test = rand(S1);
    #switch ( pig_test )
    #range ( 0, .1 )
       #local pig = .6*<122,98,88>/255; //reddish
    #break
    #range ( .1, .2 )
       #local pig = .6*<91,98,121>/255; //dark grey-blue
    #break
    #range ( .2, .3 )
       #local pig = .6*<147,129,99>/255; //terra cotta
    #break
    #range ( .3, .5 )
       #local pig = .6*<154,138,104>/255; //med-brown
    #break
    #range ( .5, .6 )
       #local pig = .6*<179,184,220>/255; //light grey-blue
    #break
    #range ( .6, .7 )
       #local pig = .6*<101,81,71>/255; //dark-brown
    #break
    #range ( .7, .8 )
       #local pig = .6*<206,206,206>/255; //reddish
    #break
    #else
       #local pig = .6*<239,231,213>/255; //light-brown
    #break
    #end      
       
  #end
  
  #local posx = field_center.x+field_width*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_width/2;
  #local posz = field_center.z+field_depth*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_depth/2;
  
  #local gscale = (rand(S1)+.1*rand(S1))*(scale_max-scale_min)+scale_min;
  
  #local norm = <0,0,0>;

  #local pos = trace ( obj, <posx,500,posz>, <0,-1,0>, norm );
  
  #if ( norm.y != 0 )

  isosurface {     
    function{ Rough_Rock(x,y,z) }
    contained_by{ box { <-1,-1,-1> <1,1,1> }}
    max_gradient 2
    rotate <360*rand(S1),360*rand(S1),360*rand(S1)>
    scale <gscale,gscale/1.5,gscale>
    translate gscale*.3*y
    translate pos
    #if ( randtex = 1 )
        texture{
          pigment{ color rgb pig }
          finish{ ambient 0 diffuse .5 }
          normal{ granite .5 scale .4 }
        }
        texture{
          pigment{
            agate
            agate_turb .3
            color_map{ 
              [0.0 color rgb .7*<167,157,135>/255 filter .5 ]
              [0.3 color rgb .7*<167,157,135>/255 filter .8 ]
              [0.5 color rgb .8*<167,157,135>/255 filter .95 ]
              [1.0 color rgb .8*<167,157,135>/255 filter .95 ]
              }
              scale .5
              }
          finish{ ambient 0 diffuse .6 }
          normal{ granite .5 scale .4 }
        }
        
             
    #else
      texture{ tex }
    #end
    
    }
  
  #end

  #local grav_num = grav_num + 1;

#end

#end

#macro bush_patch(field_width,field_depth,field_center,particle_count,scale_min,scale_max,obj,sd)

#local S1 = seed(sd);

#local bush_num = 0;

#while ( bush_num < particle_count )
  
  #local posx = field_center.x+field_width*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_width/2;
  #local posz = field_center.z+field_depth*(rand(S1)+.1*rand(S1)+.01*rand(S1)+.001*rand(S1))-field_depth/2;
  
  #local bscale = (rand(S1)+.1*rand(S1))*(scale_max-scale_min)+scale_min;

  #local brotx = 10*(rand(S1)+.1*rand(S1));
  #local brotz = 10*(rand(S1)+.1*rand(S1));
  #local broty = 360*(rand(S1)+.1*rand(S1));
  
   
  
  #local norm = <0,0,0>;

  #local pos = trace ( obj, <posx,500,posz>, <0,-1,0>, norm );
  
  #if ( norm.y != 0 )

  union{
    object{ bush1_branches texture{ trunk_tex } }
    object{ bush1_leaves texture{ leaf_tex1 } }
    translate -.1*y
    scale bscale
    rotate <brotx,0,brotz>
    rotate broty*y
    translate pos
    }
    
  
  #end

  #local bush_num = bush_num + 1;

#end

#end

#macro plant_patch(field_width,field_depth,field_center,particle_count,scale_min,scale_max,obj,plant,pig,sd)
#local S1 = seed(sd);
#local grass_num = 0;
  #while ( grass_num < particle_count )
    
    #local posx = field_center.x - field_width/2 + RRand(0,field_width,S1);
    #local posz = field_center.z - field_width/2 + RRand(0,field_width,S1);
    
    #local norm = <0,0,0>;
  
    #local pos = trace ( obj, <posx,500,posz>, <0,-1,0>, norm );
    
    #local dens = eval_pigment(pig, pos).x; //use red brightness to determine density
            
    #if ( norm.y != 0 & dens > rand(S1) )
      
      #local scal = eval_pigment(pig, pos).z; //use blue brightness to determine scale
      #local bscale = .5*scale_min + RRand(0,scale_max-scale_min,S1) * scal;
      #local brotx = 5 - RRand(0,10,S1);
      #local brotz = 5 - RRand(0,10,S1);
      #local broty = RRand(0,360,S1);
    
      object{
        plant
        scale bscale
        rotate <brotx,0,brotz>
        rotate broty*y
        translate pos
        }
      
      #local grass_num = grass_num + 1;
    
    #end
  
  #end

#end      