#declare size_min_w = 2; //min width of random bricks
#declare size_max_w = 6; //max width of random bricks
#declare size_min_h = 2; //min height of random bricks
#declare size_max_h = 4; //max height of random bricks
#declare size_d = 7;     //min depth of random bricks


#declare wall_scale = 21/83; //factor to scale wall by. Should be actual size (pov units) over # rows or # columns
#declare S2 = seed(4364);

#declare wall1_trans =
  transform{
    scale wall_scale
    translate <-190,0,-30>
    rotate 50*y
    translate <-90,0,260>
    
    }

#declare side_wall_int =
prism{
  linear_spline
  0,1,6
  <-20.5,21> <0,36> <21,21> <21,0> <-20.5,0> <-20.5,21>
  rotate -90*x
  rotate -90*y
  translate <0,0,21>
  }

#declare mortar1 =
height_field{
  gif "mortar_hf3.gif"
  smooth
  water_level .001
  rotate -90*x
  scale <54.2,21,5>
  translate .2*z
  }

#declare mortar2 =
height_field{
  gif "mortar_hf4.gif"
  smooth
  water_level .001
  rotate -90*x
  scale <41,39,5>
  translate .2*z
  rotate -90*y
  translate <54,0,1.2>
  }

#declare old_hh_walls =
union{
  
  #if ( hoisthouse_simple != 1 )        
  
    #declare block_qual1 = 1;
    #declare block_qual3 = 3;
  
    union{
      brick_wall(
        220,
        50,
        "brick_check_hf3.gif",
        size_min_w,
        size_max_w,
        size_min_h,
        size_max_h,
        size_d,
        seed(2893),
        200,   //200
        200,   //500
        block_qual1     
        )
      translate size_d/2*z
      scale <54/220,21/50,54/220>
      }
  
       
    union{
      brick_wall(
        171,
        75,
        "brick_check_hf4.gif",
        size_min_w,
        size_max_w,
        size_min_h,
        size_max_h,
        size_d,
        seed(2894),
        200,   //200
        200,   //500
        block_qual1     
        )
        translate size_d/2*z
        rotate -90*y
        scale <41/171,39/75,42/171>
        translate <54,0,.4>
      }
  
    object{ mortar1 texture{ mortar_tex } }
    object{ mortar2 texture{ mortar_tex } }
    
    union{
      block(<16.6,14.8,2.2>,6.3,1.3,5,block_qual3,seed(5616),sand_stone_tex1)
      block(<16.6+8.8,14.8,2.2>,6.3,1.3,5,block_qual3,seed(5617),sand_stone_tex1)
      block(<16.6+2*8.8,14.8,2.2>,6.3,1.3,5,block_qual3,seed(5618),sand_stone_tex1)
      block(<16.6+3*8.8,14.8,2.2>,6.3,1.3,5,block_qual3,seed(5619),sand_stone_tex1)
      block(<51.4,19,35>,3,1.3,6.5,block_qual3,seed(5619),sand_stone_tex2)
      }
    
  #else
    
    box{ <0,0,-3.5> <220,50,3.5>
      translate size_d/2*z
      scale <54/220,21/50,54/220>
      texture{ stone_tex }
      }

    #declare block_qual1 = 0;
    #declare block_qual3 = 0;  
       
    prism{
      linear_spline
      0,1,6
      <-20.5,21> <0,39> <21,21> <21,0> <-20.5,0> <-20.5,21>
      rotate -90*x
      rotate -90*y
      translate <53,0,21.4>
      texture{ stone_tex }
      }    
    
  #end
    
  }
  



#declare old_hh_roof = 
  prism{
    linear_spline
    -1,55,7
    <-22,-.6> <0,18> <22,-.6> <22,-.3>,<0,18.5>,<-22,-.3>,<-22,-.6>
    rotate -90*x
    texture{ hoisthouse_tex rotate 90*y rotate -90*z scale <1.2,1.2,2.4> translate -28*z }
    rotate -90*y
    translate <0,0,21>
    }    
        


