global_settings{
  //radiosity{}
  }

#include "functions.inc"
#include "rand.inc"
#include "block_macro.inc"
#include "wall_macro.inc"

light_source{ <50,120,-130> color rgb 1.5*<1,.96,.92> }
light_source{ <-50,-120,-130> color rgb .2 }

background{ color rgb .6 }

camera{
  //right 1.6*x
  //up y
  orthographic
  location <0,15,-80>
  look_at <0,15,0>
  }


///////////////////////////
// Set initial variables //
///////////////////////////

#declare size_min_w = 3; //min width of random bricks
#declare size_max_w = 8; //max width of random bricks
#declare size_min_h = 4; //min height of random bricks
#declare size_max_h = 7; //max height of random bricks
#declare size_d = 7; //min depth of random bricks


#declare wall_scale = 60/90; //factor to scale wall by. Should be actual size (pov units) over # rows or # columns
#declare wall_width = 120;
#declare wall_height = 90;
#declare block_qual = 0;

#declare wall1_trans =
  transform{
    scale wall_scale
    //translate <-69,-3,-15>
    //rotate -55*y
    
    translate <-80,-20,-20>
    
    }


//brick_wall(w_width,w_height,w_hf,bw_min,bw_max,bh_min,bh_max,bd_main,bd_max,S,num_bricks,qual)

union{

  brick_wall(
    wall_width,
    wall_height,
    "brick_check_hf.gif",
    size_min_w,
    size_max_w,
    size_min_h,
    size_max_h,
    size_d,
    seed(2893),
    200,   //500
    500,   //50k
    0   //quality setting 0 for box, 1 for isosurface     
    )
    
    block(<77,58.7,0>,22,3.5,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<34,58.7,0>,22,3.5,size_d+.5,block_qual,seed(838),sand_stone_tex)

    
    block(<114,5,0>,12,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<114,5+12*1,0>,12,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<114,5+12*2,0>,12,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<114,5+12*3,0>,12,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<114,5+12*4,0>,12,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<114,5+12*5,0>,12,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<114,5+12*6,0>,12,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    
    block(<114+5.7,-1,0>,6,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<114+5.7,-1+12*1,0>,6,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<114+5.7,-1+12*2,0>,6,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<114+5.7,-1+12*3,0>,6,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<114+5.7,-1+12*4,0>,6,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<114+5.7,-1+12*5,0>,6,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    block(<114+5.7,-1+12*6,0>,6,7.1,size_d+.5,block_qual,seed(832),sand_stone_tex)
    
    transform{ wall1_trans }
  
  }




  
  
#declare brick_mortar = function { 
  pigment{
    image_map{ png "mortar_hf_2.png" interpolate 2 }
    scale <wall_width,wall_height,wall_height>
    rotate 90*x
    }
}

#declare iso =
  isosurface {
          function {
             y
             - brick_mortar(x,y,z).grey*3
             //+  f_agate(x/4-50, y/4+60, z/4)*0.12
 
             }
          max_gradient 4
          contained_by{ box{ <0,0,0>,<wall_width-1,10,wall_height-1> } }
          texture{ mortar_tex scale 20 }
  translate -2*y
  rotate -90*x
  scale <1,1,3.2>
  transform{ wall1_trans }
    
  }          


    
  
  

      
    
    
 


  