#ifndef(Get)
 global_settings{ max_trace_level 20}

 #include "colors.inc"
 #include "Math.inc"
 #include "transforms.inc"
 //#include "metals.inc"
 #include "shapes.inc"
 #include "Woods.inc"

 camera{ location <0,0,-8>
       look_at <0,0,0>
       right x*image_width/image_height}
 light_source {<0,0,-100> White parallel point_at 0}
 //light_source {<0,100,0> White}

//plane{z,0 pigment{Pink }}


// ======== Changes ==============
#declare Splat=<1.3,1.2,.48>;//location
#declare Parts=100;
#declare Radmx=3;// max radius
#declare InRad=.5;// max inter radius
#declare InRad2=.1;//min inter radius
#declare Smx=.05;//max sphere radius
#declare Smn=.01;//min sphere radius
#declare Lmx=.8;//max splat length
#declare Gv=<0,.5,0>;// gavity
#declare Spr=0;//>3;//spiral arms >0 no of arms : 0 =off
#declare Centon=yes;//center splat on/off

#declare R1 = seed(37);//rand max radius
#declare R2 = seed(28);//rand spiral arm
#declare R3 = seed(55);//rand trail
#declare R4 = seed(74);//rand Inner Radius

#declare Spig=texture{pigment{rgbf<0.4176,1.0000,0.5608,0.5255>}
                      normal{granite scale .1} 
                      finish{specular .6 roughness .0005
                             phong .5 phong_size 240}
                      }       
// ======== End of changes ==============
#end //end of get 

#if(Spr) #declare Sv=360/Spr;
#else #declare Sv=0;
#end
#declare Cnt = 0;
#while (Cnt < Parts)
 #declare A=rand(R1)*(Radmx-InRad)+InRad;
 #if(Spr)#declare B=int(rand(R2)*Spr)*Sv;
 #else #declare B=rand(R2)*360;
 #end
 #declare Rd=rand(R3)*(Smx-Smn)+Smn;
 #declare Ln=rand(R3)*A/Radmx*Lmx; 
 #declare Rd2=0;
 #declare Bp=vrotate(x*A,z*B)-Gv*A;

 union{
  cone{<0,0,0>,Rd,<-Ln,0,0>,Rd2} 
  sphere{<0,0,0>,Rd} 
 texture{Spig} Reorient_Trans(x,Bp) translate Bp+Splat}// -Gv*A}

#declare Cnt = Cnt+1; 
#end
//inner splat
#if(Centon)
 #declare a=(InRad+InRad2)/2;//InRad;
 #declare Da=360/(2*pi*a/Smx);
 #debug concat("Da="str(Da,3,3),"\n")
 merge{
 #declare Cnt = 0;
 #while (Cnt < 360)
  #declare Ed=rand(R4)*(InRad-InRad2)+InRad2;
  #declare NR=Ed/InRad*Smx;
  union{sphere{x*Ed,NR}
       cone{0,Smn,x*Ed,NR }
       rotate z*Cnt translate Splat}
 #declare Cnt = Cnt+Da; 
 #end
 texture{Spig}}
#end