// Copyright 2006 by Christian Froeschlin

#include "colors.inc"

/* TOILET PAPER ROLL */

#declare C_CARD_BASE  = color rgb 0.8*<0.9,0.65,0.45>;
#declare C_CARD_SPOT1 = color rgb 0.3;
#declare C_CARD_SPOT2 = color Red;

#declare ROLL_RADIUS = 0.20;

#declare ROLL_SEGMENT = union
{
  cylinder {0,0.1*y,ROLL_RADIUS}
  intersection
  {
    cylinder {0,0.1*y,ROLL_RADIUS}
    plane {(x+y), 0 translate 0.05*y}
    scale 1.0025*<1,0,1> + y
    translate -0.0025*z
  }
}

#declare T_ROLL_INTERIOR = texture
{
  pigment {color rgb 0.9}
  normal
  {
    granite 0.1 scale 0.04
  }
}
 
#declare T_ROLL_EXTERIOR = texture
{
  pigment 
  {
    granite color_map
    {
      [0.00 C_CARD_SPOT1]
      [0.10 C_CARD_SPOT1]
      [0.15 C_CARD_BASE]
      [0.85 C_CARD_BASE]
      [0.90 C_CARD_SPOT2]
      [1.00 C_CARD_SPOT2]
    }
    scale 0.1
  }
  normal
  {
    granite 0.1 scale 0.04
  }

}

#declare ROLL_SOLID = union
{
  #declare i = 0;
  #while (i < 10)
    object {ROLL_SEGMENT translate i*0.1*y rotate i*(180*(0.1/ROLL_RADIUS)/pi)*y}
    #declare i = i + 1;
  #end
}


#declare ROLL_HOLE = cylinder
{
  -0.1*y,1.1*y,ROLL_RADIUS - 0.01
}

#declare ROLL = difference
{
  object 
  {
    ROLL_SOLID
    texture {T_ROLL_EXTERIOR}    
  }
  object
  {
    ROLL_HOLE
    texture {T_ROLL_INTERIOR}    
  }
}

#macro T_PAPER(fluffiness)
texture
{
  pigment
  {
    wrinkles color_map
    {
      [0.0             color rgbt 1]
      [fluffiness       color rgbt 1]
      [fluffiness + 0.2 color rgb  1.5]
    }
    scale 0.015
  }
  normal
  {
    leopard -5 scale 0.002 turbulence 1.5
  }
}
#end

#declare GLUE = intersection
{
  difference
  {
    object {ROLL_SOLID}
    object {ROLL_HOLE}
  }
  box {<-1,0.05,-0.02>,<0,0.95,0.02>}
  texture {T_ROLL_EXTERIOR}  
  texture
  {
    pigment
    {
      checker color rgbt 1 color rgbft <0,0,0,0.3,0.7> turbulence 0.6
      scale <0.4,0.1,0.4> translate <0,0.05,-0.2>
    }    
  }
  T_PAPER(0.5)
}

#declare FLUFF = union
{
  triangle {0.7*y, 0.75*y, 0.15*x + 0.725*y}
  triangle {0.4*y, 0.45*y, 0.05*x + 0.425*y translate -0.004*z}
  T_PAPER(0.35)
  translate -ROLL_RADIUS*z
  rotate 90*y
}

#declare ROLL_PAPER = union
{
  object {ROLL}
  object {GLUE translate -0.0001*x}
  object {FLUFF}
}

