//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
//  Contains 1 lights, 2 materials and 2 primitives.
//
//  This file was generated for POV-Ray V3.5 by
//  Moray V3.5 For Windows Copyright (c) 1993-2003 Lutz + Kretzschmar
//

//  Date : 10/04/2006    (04.10.2006)
//

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/*
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 3
  charset ascii
}

background { color <0.820,0.820,0.820> }

camera {  //  Camera Camera01
  location  <    -22.535,     -44.534,      71.455>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <      0.039,      -0.151,       0.036>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  photons {
  }
  translate  <-1000.0, -1000.0, 1000.0>
}
*/

//
// ********  MATERIALS  *******
//

#declare OutsideTex = 
      texture {      
         pigment {
            onion
            color_map {
               [ 0.0     rgbft <0.71, 0.61, 0.81, 0.0, 0.0>*0.5 ]
               [ 1.0     rgbft <0.9479, 0.9479, 0.9479, 0.0, 0.0> ]
            }
         }      
         normal {
            onion , 0.5
         }
      }


#declare InsideTex = 
   material {   
      texture {      
         pigment {
            color rgb <0.9479, 0.9479, 0.9479>
         }      
         finish {
            ambient 0.0
            specular 0.7266
            roughness 0.006139
         }
      }
   }


//
// ********  OBJECTS  *******
//

// SeaShell001
#include "functions.inc"
#declare MajorRadius      = 0.025;
#declare b      = 0.04;
#declare A      = 0.025;
#declare RealAlpha  = radians(45);
#declare RealBeta   = radians(90);
#declare ImagAlpha  = radians(0);
#declare ImagBeta   = radians(0);
#declare Mu     = radians(0);
#declare Phi    = radians(0);
#declare Omega  = radians(0);
#declare Sides  = 4;
#declare Power1 = 2;
#declare Power2 = 2;
#declare Power3 = 2;
#declare L      = 0;
#declare P      = radians(0);
#declare W1     = radians(1);
#declare W2     = radians(1);
#declare N      = 1;
#declare Speed  = 0;
#declare Width    = radians(0);
#declare Delta    = radians(0);
#declare m      = 50;
#declare ra     = 1;
#declare rW     = radians(0);
#declare rP     = radians(0);
#declare minw   = 0;
#declare maxw   = 0;
#declare wa     = 1;
#declare rr     = 0;
#declare vvMin  = 0;
#declare vvMax  = 360;
#declare vvStep = 4;
#declare uuMin  = -180;
#declare uuMax  = 180;
#declare uuStep = 4;
#declare NoiseEllipse = 0;
#declare NoiseSpiral  = 0;
#declare NoiseHeight  = 0;
#declare NoiseOffset  = 0;
#declare NoiseDensity = 0.0001;
#declare StartSize  	 = 0;
#declare uuNum = floor((uuMax - uuMin) / uuStep);
#declare vvNum = floor((vvMax - vvMin + StartSize) / vvStep);
#declare sMu = sin(Mu);
#declare cMu = cos(Mu);
#declare sBeta = sin(RealBeta);
#declare cBeta = cos(RealBeta);
#declare tAlpha = tan(RealAlpha);
#declare Facteur1 = cosh(ImagAlpha) * sinh(ImagAlpha)/(cos(RealAlpha)*cos(RealAlpha)*sinh(ImagAlpha)*sinh(ImagAlpha) + sin(RealAlpha)*sin(RealAlpha)*cosh(ImagAlpha)*cosh(ImagAlpha));
#declare Facteur2 = sin(RealAlpha)*cos(RealAlpha)    /(cos(RealAlpha)*cos(RealAlpha)*sinh(ImagAlpha)*sinh(ImagAlpha) + sin(RealAlpha)*sin(RealAlpha)*cosh(ImagAlpha)*cosh(ImagAlpha));
#declare sRealBeta 	= sin(RealBeta);
#declare cRealBeta 	= cos(RealBeta);
#declare chImagBeta	= cosh(ImagBeta);
#declare shImagBeta	= sinh(ImagBeta);
#ifdef (round)
	#undef round
#end
#ifdef (l_)
	#undef l_
#end
#ifdef (ShellRadius)
	#undef ShellRadius
#end
#ifdef (Ripples)
	#undef Ripples
#end
#ifdef (Waves)
	#undef Waves
#end
#ifdef (ww)
	#undef ww
#end
#ifdef (SuperFormula)
	#undef SuperFormula
#end
#ifdef (Queue)
	#undef Queue
#end
#ifdef (nps)
	#undef nps
#end
#ifdef (npe)
	#undef npe
#end
#ifdef (att)
	#undef att
#end
#ifdef (X_)
	#undef X_
#end
#ifdef (Y_)
	#undef Y_
#end
#ifdef (Z_)
	#undef Z_
#end
#declare round = function(x) {int(x+.5)}
#if (N = 0)
	#declare nps = function(y) {1}
#else
	#declare nps = function(y) {(2*pi/N)* (N*abs(y)/(2*pi) - round(N*abs(y)/(2*pi)))} 
#end
#if (Delta = 0)
	#declare npe = function(y) {abs(y - P)}
#else
	#declare npe = function(y) {Delta*(abs(y-P)/Delta - round(abs(y-P)/Delta))}
#end
#if (Speed = 0)
	#declare att = function(y) {0}
#else
	#if (Width = 0)
		#declare att = function(y) {0}
	#else
		#declare att = function(y) {(2*Speed-1)*pow(abs(y-P) / Width, 2*Speed)/(2*Speed)}
	#end
#end
#declare SuperFormula = function(x) {pow(pow(abs(cos(Sides*x/4)), Power2)/pow(MajorRadius,Power1) + pow(abs(sin(Sides*x/4)), Power3)/pow(b,Power1), 1/Power1)}
#if (N = 0)
	#declare l_ = function(y) {0} 
	#declare L = 0;
#else 
	#declare l_ = function(y) {(2*pi/N)*(N*abs(y)/(2*pi) - round(N*abs(y)/(2*pi)))} 
#end
	#declare ShellRadius = function(x,y) {((1/SuperFormula(x) + L*exp(-(2*(npe(x)/W1)*2*(npe(x)/W1)) - att(x) - (2*nps(y)/W2)*(2*nps(y)/W2))))*(1+ max(f_snoise3d(x*NoiseEllipse + NoiseOffset,y*NoiseSpiral + NoiseOffset, 0) - (1-NoiseDensity), 0) * NoiseHeight / NoiseDensity)}
#if (m = 0)
	#declare Ripples = function(x) {1}
#else
	#if (ra = 0)
		#declare Ripples = function(x) {1}
	#else
		#if (rW = 0)
			#declare Ripples = function(x) {(ra*sqrt(m*m+2*m+2-2*(m+1)*cos(m*x))/m)+1-ra}
		#else
			#declare Ripples = function(x) {(ra*exp(-(2*(x-rP)/rW)*(2*(x-rP)/rW))*sqrt(m*m+2*m+2-2*(m+1)*cos(m*x))/m)+1-ra*exp(-(2*(x-rP)/rW)*(2*(x-rP)/rW))}
		#end
	#end
#end
#if (minw + maxw = 0)
        #declare Waves = function(x) {1}
#else
        #declare ww = function(x) {max(minw + (maxw-minw)*(x-vvMin)/(vvMax-vvMin), 0.001)}
        #declare Waves = function(x) {wa*sqrt(ww(x)*ww(x)+2*ww(x)+2-2*(ww(x)+1)*cos(ww(x)*x))/ww(x) + 1 - wa}
#end 
#declare Queue = function(x) {(x<radians(vvMin))*((cos(pi*(radians(vvMin) - x)/(.000000001+radians(StartSize))) + 1) / 2) + (x >=radians(vvMin))}
#declare X_ = function(x,y) { A*(sRealBeta*chImagBeta*cos(y*Facteur1)+ cRealBeta*shImagBeta*sin(y*Facteur1)) * exp(Facteur2*y)*cos(y) + Queue(y)*Waves(y)*Ripples(x)*ShellRadius(x,y)*(cos(x+Phi)*cos(Omega+y) - sin(x+Phi)*sMu*sin(y+Omega)) * exp(y/tAlpha)}
#declare Y_ = function(x,y) {-A*(sRealBeta*chImagBeta*cos(y*Facteur1)+ cRealBeta*shImagBeta*sin(y*Facteur1)) * exp(Facteur2*y)*sin(y) - Queue(y)*Waves(y)*Ripples(x)*ShellRadius(x,y)*(cos(x+Phi)*sin(Omega+y) + sin(x+Phi)*sMu*cos(y+Omega)) * exp(y/tAlpha)}
#declare Z_ = function(x,y) {-A*(cRealBeta*chImagBeta*cos(y*Facteur1)- sRealBeta*shImagBeta*sin(y*Facteur1)) * exp(Facteur2*y)        + Queue(y)*Waves(y)*Ripples(x)*ShellRadius(x,y)*sin(x+Phi) * cMu * exp(y/tAlpha)}


#declare Lamellibranch =
mesh2 {
vertex_vectors { (uuNum + 1) * (vvNum + 1),
#declare uu = uuMin;
#while (uu <= uuMax)
	#declare vv = vvMin - StartSize;
	#while (vv <= vvMax      )
		<X_(radians(uu), radians(vv)), Y_(radians(uu), radians(vv)), Z_(radians(uu), radians(vv))>
		#declare vv = vv + vvStep;
	#end
	#declare uu = uu + uuStep;
#end
  }
face_indices {
uuNum*vvNum*2,
#declare uu = 0;
#while (uu < uuNum)
	#declare vv = 0;
	#while (vv < vvNum )
		<(vvNum+1)*uu + vv,(vvNum+1)*(uu+1) + vv, (vvNum+1)*(uu+1) + vv + 1>
		<(vvNum+1)*uu + vv,(vvNum+1)*(uu+1) + vv + 1, (vvNum+1)*uu + vv + 1>
		#declare vv = vv + 1;
	#end
	#declare uu = uu + 1;
#end
}
interior_texture{OutsideTex}
material { InsideTex }
scale <1,1,1>
rotate <180,90,180> //y is up
translate <0,0,0>
}




